/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: formfiltermanager.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 22:49:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef FORMS_SOURCE_COMPONENT_FORMFILTERMANAGER_HXX
#include "formfiltermanager.hxx"
#endif

/** === begin UNO includes === **/
#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif
/** === end UNO includes === **/

#ifndef _FRM_PROPERTY_HRC_
#include "property.hrc"
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif

//........................................................................
namespace frm
{
//........................................................................

    using namespace ::com::sun::star::uno;
    using namespace ::com::sun::star::sdbc;
    using namespace ::com::sun::star::sdb;
    using namespace ::com::sun::star::lang;
    using namespace ::com::sun::star::beans;

    using namespace ::dbtools;

    //====================================================================
	//= FormFilterManager
	//====================================================================
	//--------------------------------------------------------------------
    FormFilterManager::FormFilterManager( const Reference< XMultiServiceFactory >& _rxORB )
        :m_xORB( _rxORB )
        ,m_aFilterComponents( FC_COMPONENT_COUNT )
        ,m_bApplyPublicFilter( true )
    {
    }

	//--------------------------------------------------------------------
    void FormFilterManager::initialize( const Reference< XPropertySet >& _rxForm, const Reference< XPropertySet >& _rxFormAggregate )
    {
        OSL_ENSURE( !m_xForm.is(), "FormFilterManager::initialize: already initialized!" );
        m_xForm          = _rxForm         ;
        m_xFormAggregate = _rxFormAggregate;
        OSL_ENSURE( m_xForm.is() && m_xFormAggregate.is(), "FormFilterManager::initialize: invalid arguments!" );

        if ( m_xFormAggregate.is() )
            m_xFormAggregate->setPropertyValue( PROPERTY_APPLYFILTER, makeAny( (sal_Bool)sal_True ) );
    }

	//--------------------------------------------------------------------
    void FormFilterManager::dispose( )
    {
        m_xForm.clear();
        m_xFormAggregate.clear();
    }

	//--------------------------------------------------------------------
    const ::rtl::OUString& FormFilterManager::getFilterComponent( FilterComponent _eWhich ) const
    {
        return m_aFilterComponents[ _eWhich ];
    }

	//--------------------------------------------------------------------
    void FormFilterManager::setFilterComponent( FilterComponent _eWhich, const ::rtl::OUString& _rComponent )
    {
        m_aFilterComponents[ _eWhich ]  = _rComponent;
        try
        {
            if ( ( _eWhich != fcPublicFilter ) || m_bApplyPublicFilter )
            {
                if ( m_xFormAggregate.is() )
                    m_xFormAggregate->setPropertyValue( PROPERTY_FILTER, makeAny( getComposedFilter() ) );
            }
        }
        catch( const Exception& )
        {
        	OSL_ENSURE( sal_False, "FormFilterManager::setFilterComponent: setting the filter failed!" );
        }
    }

	//--------------------------------------------------------------------
    void FormFilterManager::setApplyPublicFilter( sal_Bool _bApply )
    {
        if ( m_bApplyPublicFilter == _bApply )
            return;

        m_bApplyPublicFilter = _bApply;

        try
        {
            if ( getFilterComponent( fcPublicFilter ).getLength() )
            {   // only if there changed something
                if ( m_xFormAggregate.is() )
                    m_xFormAggregate->setPropertyValue( PROPERTY_FILTER, makeAny( getComposedFilter() ) );
            }
        }
        catch( const Exception& )
        {
        	OSL_ENSURE( sal_False, "FormFilterManager::setApplyPublicFilter: setting the filter failed!" );
        }
    }

	//--------------------------------------------------------------------
    namespace
    {
        void    lcl_ensureBracketed( ::rtl::OUString& /* [inout] */ _rExpression )
        {
            OSL_ENSURE( _rExpression.getLength(), "lcl_ensureBracketed: expression is empty!" );
            if ( _rExpression.getLength() )
            {
                if ( ( _rExpression.getStr()[0] != '(' ) || ( _rExpression.getStr()[ _rExpression.getLength() - 1 ] != ')' ) )
                {
                    ::rtl::OUString sComposed( RTL_CONSTASCII_USTRINGPARAM( "(" ) );
                    sComposed += _rExpression;
                    sComposed += ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( ")" ) );
                    _rExpression = sComposed;
                }
            }
        }
    }
	//--------------------------------------------------------------------
    void FormFilterManager::appendFilterComponent( ::rtl::OUString& /* [inout] */ _rAppendTo, const ::rtl::OUString& _rComponent )
    {
        if ( _rAppendTo.getLength() )
            _rAppendTo += ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( " AND " ) );

        ::rtl::OUString sComponent( _rComponent );
        lcl_ensureBracketed( sComponent );
        _rAppendTo += sComponent;
    }

	//--------------------------------------------------------------------
    bool FormFilterManager::isThereAtMostOneComponent( ::rtl::OUString& _rOnlyComponent ) const
    {
        sal_Int32 nOnlyNonEmpty = -1;
	sal_Int32 i;
        for ( i = getFirstApplicableFilterIndex(); i < FC_COMPONENT_COUNT; ++i )
        {
            if ( m_aFilterComponents[ i ].getLength() )
                if ( nOnlyNonEmpty != -1 )
                    // it's the second non-empty component
                    break;
                else
                    nOnlyNonEmpty = i;
        }
        if ( nOnlyNonEmpty == -1 )
        {
            _rOnlyComponent = ::rtl::OUString();
            return true;
        }

        if ( i == FC_COMPONENT_COUNT )
        {
            // we found only one non-empty filter component
            _rOnlyComponent = m_aFilterComponents[ nOnlyNonEmpty ];
            return true;
        }
        return false;
    }

	//--------------------------------------------------------------------
    ::rtl::OUString FormFilterManager::getComposedFilter( )
    {
        ::rtl::OUString sComposedFilter;

        // if we have only one non-empty component, then there's no need to compose anything
        if ( isThereAtMostOneComponent( sComposedFilter ) )
            return sComposedFilter;

        // append the single components
        for ( sal_Int32 i = getFirstApplicableFilterIndex(); i < FC_COMPONENT_COUNT; ++i )
            appendFilterComponent( sComposedFilter, m_aFilterComponents[ i ] );

        return sComposedFilter;
    }

//........................................................................
}   // namespace frm
//........................................................................
