/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: slidview.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:08:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//STRIP001 #ifndef _SD_SLIDVIEW_HXX
//STRIP001 #define _SD_SLIDVIEW_HXX
//STRIP001 
//STRIP001 #include "sdview.hxx"
//STRIP001 
//STRIP001 class SdDrawDocument;
//STRIP001 class SdWindow;
//STRIP001 //STRIP001 class BitmapCache;
//STRIP001 class SdPage;
//STRIP001 class ShowView;
//STRIP001 class SdSlideViewShell;
//STRIP001 
// ----------------------
// - SlideViewFocusMove -
// ----------------------

//STRIP001 enum SlideViewFocusMove
//STRIP001 {
//STRIP001     SLIDEVIEWFOCUSMOVE_NONE = 0,
//STRIP001     SLIDEVIEWFOCUSMOVE_TOGGLE = 1,
//STRIP001     SLIDEVIEWFOCUSMOVE_SELECT = 2,
//STRIP001     SLIDEVIEWFOCUSMOVE_LEFT = 3,
//STRIP001     SLIDEVIEWFOCUSMOVE_TOP = 4,
//STRIP001     SLIDEVIEWFOCUSMOVE_RIGHT = 5,
//STRIP001     SLIDEVIEWFOCUSMOVE_BOTTOM = 6
//STRIP001 };
//STRIP001 
//STRIP001 // ---------------
//STRIP001 // - SdSlideView -
//STRIP001 // ---------------
//STRIP001 
//STRIP001 class SdSlideView : public SdView
//STRIP001 {
//STRIP001 	Timer				aDelayedPaintTimer;
//STRIP001 	List				aDelayedPaints;
//STRIP001 	SdSlideViewShell*	pSlideViewShell;
//STRIP001 	BitmapCache*		pCache;
//STRIP001 	ShowView*			pShowView;
//STRIP001 	VirtualDevice*		pVDev;
//STRIP001 	USHORT				nAllowInvalidateSmph;
//STRIP001 	USHORT				nPagesPerRow;
//STRIP001     USHORT              nFocusPage;
//STRIP001 	BOOL				bInPaint;
//STRIP001 	BOOL				bInDelayedPaint;
//STRIP001 
//STRIP001 	                    DECL_LINK( PaintDelayed, Timer * );
//STRIP001 
//STRIP001     void                CreateSlideTransferable( Window* pWindow, BOOL bDrag );
//STRIP001 
//STRIP001  public:
//STRIP001 	                    
//STRIP001                         TYPEINFO();
//STRIP001 
//STRIP001 	                    SdSlideView( SdDrawDocument* pDoc, Window* pWindow, SdSlideViewShell* pSlideVShell );
//STRIP001                         ~SdSlideView();
//STRIP001 
//STRIP001     void                Select( USHORT nSdPageNum, BOOL bSelect );
//STRIP001     void                SelectAll( BOOL bSelect );
//STRIP001 
//STRIP001     void                MoveFocus( SlideViewFocusMove eMove );
//STRIP001     USHORT              GetFocusPage() const;
//STRIP001     BOOL                HasFocus() const;
//STRIP001 
//STRIP001 	USHORT              ChangePagesPerRow( USHORT nNum );
//STRIP001 	USHORT              GetPagesPerRow() const { return nPagesPerRow; }
//STRIP001 
//STRIP001 	virtual void        InvalidateOneWin( Window& rWin );
//STRIP001 	virtual void        InvalidateOneWin( Window& rWin, const Rectangle& rRect );
//STRIP001 
//STRIP001 	void                SetMultiPageView( BOOL bFlag ) { bPageTwice = bFlag; }
//STRIP001 	void                SetAllowInvalidate( BOOL bFlag );
//STRIP001 	BOOL                IsInvalidateAllowed() const;
//STRIP001 
//STRIP001 	void                Paint(const Rectangle& rRect, OutputDevice* pOut);
//STRIP001 	void                DrawSelectionRect(USHORT nPage);
//STRIP001 
//STRIP001 	Point	            CalcPagePos( USHORT nPageNo ) const;
//STRIP001 	Rectangle           GetPageArea( USHORT nPageNo ) const;
//STRIP001 	ULONG	            GetPageGap() const;
//STRIP001 	Rectangle           GetFadeIconArea( USHORT nPageNo ) const;
//STRIP001     SdPage*             GetHitPage( const Point& rPos ) const;
//STRIP001     SdPage*             GetFadePage( const Point& rPos ) const;
//STRIP001     SdPage*             GetNearestPage( const Point& rPos ) const;
//STRIP001 	
//STRIP001     void	            ArrangePages();
//STRIP001 	void                DeleteMarked();
//STRIP001 	void                MoveMarked( USHORT nTargetPage );
//STRIP001 
//STRIP001 	void		            AddToCache( SdPage* pPage, const Bitmap& rBitmap, long nZoom ); 
//STRIP001 	const GraphicObject*    GetFromCache( SdPage* pPage, long& rZoom, long nZoomTolerance ) const;
//STRIP001 
//STRIP001 	virtual void        SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
//STRIP001 							        const SfxHint& rHint, const TypeId& rHintType );
//STRIP001 
//STRIP001 	virtual void        DoCut( Window* pWindow = NULL );
//STRIP001 	virtual void        DoCopy( Window* pWindow = NULL );
//STRIP001 	virtual void        DoPaste( Window* pWindow = NULL );
//STRIP001 
//STRIP001     virtual void        StartDrag( const Point& rDragPt, Window* pWindow );
//STRIP001 	virtual void        DragFinished( sal_Int8 nDropAction );
//STRIP001 	
//STRIP001     virtual sal_Int8    AcceptDrop( const AcceptDropEvent& rEvt, DropTargetHelper& rTargetHelper, 
//STRIP001                                     SdWindow* pTargetWindow = NULL, 
//STRIP001                                     USHORT nPage = SDRPAGE_NOTFOUND, 
//STRIP001                                     USHORT nLayer = SDRPAGE_NOTFOUND );
//STRIP001 	virtual sal_Int8    ExecuteDrop( const ExecuteDropEvent& rEvt, DropTargetHelper& rTargetHelper,
//STRIP001                                      SdWindow* pTargetWindow = NULL, 
//STRIP001                                      USHORT nPage = SDRPAGE_NOTFOUND, 
//STRIP001                                      USHORT nLayer = SDRPAGE_NOTFOUND );
//STRIP001 
//STRIP001 	void 	            UpdateAllPages();
//STRIP001 };
//STRIP001 
//STRIP001 #endif		// _SD_SLIDVIEW_HXX
