/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tplnedef.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:11:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#pragma hdrstop

#define _SVX_TPLNEDEF_CXX

#include "dialogs.hrc"
#include "tabline.hrc"
#include "dlgname.hrc"
#include "helpid.hrc"

#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE
#define ITEMID_DASH_LIST		SID_DASH_LIST

#include "xattr.hxx"
#include "xpool.hxx"
#include "xoutx.hxx"
#include "xtable.hxx"

#include "drawitem.hxx"
#include "tabline.hxx"
#include "dlgname.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
namespace binfilter {

//STRIP001 #define DLGWIN this->GetParent()->GetParent()

//STRIP001 #define BITMAP_WIDTH   32
//STRIP001 #define BITMAP_HEIGHT  12
//STRIP001 #define XOUT_WIDTH    150

/*************************************************************************
|*
|*	Dialog zum Definieren von Linienstilen
|*
\************************************************************************/

//STRIP001 SvxLineDefTabPage::SvxLineDefTabPage
//STRIP001 (
//STRIP001 	Window* pParent,
//STRIP001 	const SfxItemSet& rInAttrs
//STRIP001 ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, SVX_RES( RID_SVXPAGE_LINE_DEF ), rInAttrs ),
//STRIP001 
//STRIP001 	pXPool				( (XOutdevItemPool*) rInAttrs.GetPool() ),
//STRIP001 	XOut				( &aCtlPreview ),
//STRIP001 	aXLineAttr			( pXPool ),
//STRIP001 	rXLSet				( aXLineAttr.GetItemSet() ),
//STRIP001 
//STRIP001 	aXLStyle			( XLINE_DASH ),
//STRIP001 	aXWidth				( XOUT_WIDTH ),
//STRIP001 	aXColor				( String(), COL_BLACK ),
//STRIP001 	aXDash				( String(), XDash( XDASH_RECT, 3, 7, 2, 40, 15 ) ),
//STRIP001 
//STRIP001 	aFtType			( this, ResId( FT_TYPE ) ),
//STRIP001 	aLbType1		( this, ResId( LB_TYPE_1 ) ),
//STRIP001 	aLbType2		( this, ResId( LB_TYPE_2 ) ),
//STRIP001 	aFtNumber		( this, ResId( FT_NUMBER ) ),
//STRIP001 	aNumFldNumber1	( this, ResId( NUM_FLD_1 ) ),
//STRIP001 	aNumFldNumber2	( this, ResId( NUM_FLD_2 ) ),
//STRIP001 	aFtDistance		( this, ResId( FT_DISTANCE ) ),
//STRIP001 	aMtrDistance	( this, ResId( MTR_FLD_DISTANCE ) ),
//STRIP001 	aFtLength		( this, ResId( FT_LENGTH ) ),
//STRIP001 	aMtrLength1		( this, ResId( MTR_FLD_LENGTH_1 ) ),
//STRIP001 	aMtrLength2		( this, ResId( MTR_FLD_LENGTH_2 ) ),
//STRIP001 	aCbxSynchronize	( this, ResId( CBX_SYNCHRONIZE ) ),
//STRIP001 	aFlDefinition	( this, ResId( FL_DEFINITION ) ),
//STRIP001 	aLbLineStyles	( this, ResId( LB_LINESTYLES ) ),
//STRIP001 	aFTLinestyle	( this, ResId( FT_LINESTYLE ) ),
//STRIP001 	aBtnAdd			( this, ResId( BTN_ADD ) ),
//STRIP001 	aBtnModify		( this, ResId( BTN_MODIFY ) ),
//STRIP001 	aBtnDelete		( this, ResId( BTN_DELETE ) ),
//STRIP001 	aCtlPreview		( this, ResId( CTL_PREVIEW ), &XOut ),
//STRIP001 	aBtnLoad		( this, ResId( BTN_LOAD ) ),
//STRIP001 	aBtnSave		( this, ResId( BTN_SAVE ) ),
//STRIP001 	rOutAttrs		( rInAttrs )
//STRIP001 
//STRIP001 {
//STRIP001 	aBtnLoad.SetModeImage( Image( ResId( RID_SVXIMG_LOAD_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 	aBtnSave.SetModeImage( Image( ResId( RID_SVXIMG_SAVE_H ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	eFUnit = GetModuleFieldUnit( &rInAttrs );
//STRIP001 
//STRIP001 	switch ( eFUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:
//STRIP001 			eFUnit = FUNIT_MM;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	SetFieldUnit( aMtrDistance, eFUnit );
//STRIP001 	SetFieldUnit( aMtrLength1, eFUnit );
//STRIP001 	SetFieldUnit( aMtrLength2, eFUnit );
//STRIP001 
//STRIP001 	// PoolUnit ermitteln
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool?" );
//STRIP001 	ePoolUnit = pPool->GetMetric( SID_ATTR_LINE_WIDTH );
//STRIP001 
//STRIP001 	rXLSet.Put( aXLStyle );
//STRIP001 	rXLSet.Put( aXWidth );
//STRIP001 	rXLSet.Put( aXDash );
//STRIP001 	rXLSet.Put( aXColor );
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 	aBtnAdd.SetClickHdl( LINK( this, SvxLineDefTabPage, ClickAddHdl_Impl ) );
//STRIP001 	aBtnModify.SetClickHdl(
//STRIP001 		LINK( this, SvxLineDefTabPage, ClickModifyHdl_Impl ) );
//STRIP001 	aBtnDelete.SetClickHdl(
//STRIP001 		LINK( this, SvxLineDefTabPage, ClickDeleteHdl_Impl ) );
//STRIP001 	aBtnLoad.SetClickHdl( LINK( this, SvxLineDefTabPage, ClickLoadHdl_Impl ) );
//STRIP001 	aBtnSave.SetClickHdl( LINK( this, SvxLineDefTabPage, ClickSaveHdl_Impl ) );
//STRIP001 
//STRIP001 	aNumFldNumber1.SetModifyHdl(
//STRIP001 		LINK( this, SvxLineDefTabPage, ChangeNumber1Hdl_Impl ) );
//STRIP001 	aNumFldNumber2.SetModifyHdl(
//STRIP001 		LINK( this, SvxLineDefTabPage, ChangeNumber2Hdl_Impl ) );
//STRIP001 	aLbLineStyles.SetSelectHdl(
//STRIP001 		LINK( this, SvxLineDefTabPage, SelectLinestyleHdl_Impl ) );
//STRIP001 
//STRIP001 	// Absolut (in mm) oder Relativ (in %)
//STRIP001 	aCbxSynchronize.SetClickHdl(
//STRIP001 		LINK( this, SvxLineDefTabPage, ChangeMetricHdl_Impl ) );
//STRIP001 
//STRIP001 	// Wenn sich etwas aendert, muss Preview upgedatet werden werden
//STRIP001 	Link aLink = LINK( this, SvxLineDefTabPage, SelectTypeHdl_Impl );
//STRIP001 	aLbType1.SetSelectHdl( aLink );
//STRIP001 	aLbType2.SetSelectHdl( aLink );
//STRIP001 	aLink = LINK( this, SvxLineDefTabPage, ChangePreviewHdl_Impl );
//STRIP001 	aMtrLength1.SetModifyHdl( aLink );
//STRIP001 	aMtrLength2.SetModifyHdl( aLink );
//STRIP001 	aMtrDistance.SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	pDashList = NULL;
//STRIP001 }


// -----------------------------------------------------------------------

//STRIP001 void SvxLineDefTabPage::Construct()
//STRIP001 {
//STRIP001 	// Linienstile
//STRIP001 	aLbLineStyles.Fill( pDashList );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineDefTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 ) // Flaechen-Dialog
//STRIP001 	{
//STRIP001 		// ActivatePage() wird aufgerufen bevor der Dialog PageCreated() erhaelt !!!
//STRIP001 		if( pDashList )
//STRIP001 		{
//STRIP001 			if( *pPageType == 1 && *pPosDashLb >= 0 &&
//STRIP001 				*pPosDashLb != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			{
//STRIP001 				aLbLineStyles.SelectEntryPos( *pPosDashLb );
//STRIP001 			}
//STRIP001 			// Damit evtl. vorhandener Linestyle verworfen wird
//STRIP001 			SelectLinestyleHdl_Impl( this );
//STRIP001 
//STRIP001 			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String			aString( SVX_RES( RID_SVXSTR_TABLE ) ); aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 			INetURLObject	aURL( pDashList->GetPath() );
//STRIP001 
//STRIP001 			aURL.Append( pDashList->GetName() );
//STRIP001 			DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 /*			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			aFTLinestyle.SetText( aString );
//STRIP001 */
//STRIP001 			*pPageType = 0; // 2
//STRIP001 			*pPosDashLb = LISTBOX_ENTRY_NOTFOUND;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int SvxLineDefTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	CheckChanges_Impl();
//STRIP001 
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineDefTabPage::CheckChanges_Impl()
//STRIP001 {
//STRIP001 	// wird hier benutzt, um Aenderungen NICHT zu verlieren
//STRIP001 	//XDashStyle eXDS;
//STRIP001 
//STRIP001 	if( aNumFldNumber1.GetText() 	 != aNumFldNumber1.GetSavedValue() ||
//STRIP001 		aMtrLength1.GetText() 		 != aMtrLength1.GetSavedValue() ||
//STRIP001 		aLbType1.GetSelectEntryPos() != aLbType1.GetSavedValue() ||
//STRIP001 		aNumFldNumber2.GetText() 	 != aNumFldNumber2.GetSavedValue() ||
//STRIP001 		aMtrLength2.GetText() 		 != aMtrLength2.GetSavedValue() ||
//STRIP001 		aLbType2.GetSelectEntryPos() != aLbType2.GetSavedValue() ||
//STRIP001 		aMtrDistance.GetText() 		 != aMtrDistance.GetSavedValue() )
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001         Image aWarningBoxImage = WarningBox::GetStandardImage();
//STRIP001 		SvxMessDialog aMessDlg( DLGWIN,
//STRIP001 			String( ResId( RID_SVXSTR_LINESTYLE, pMgr ) ),
//STRIP001 			String( ResId( RID_SVXSTR_ASK_CHANGE_LINESTYLE, pMgr ) ),
//STRIP001 			&aWarningBoxImage );
//STRIP001 
//STRIP001 		aMessDlg.SetButtonText( MESS_BTN_1,
//STRIP001 								String( ResId( RID_SVXSTR_CHANGE, pMgr ) ) );
//STRIP001 		aMessDlg.SetButtonText( MESS_BTN_2,
//STRIP001 								String( ResId( RID_SVXSTR_ADD, pMgr ) ) );
//STRIP001 
//STRIP001 		short nRet = aMessDlg.Execute();
//STRIP001 
//STRIP001 		switch( nRet )
//STRIP001 		{
//STRIP001 			case RET_BTN_1: // Aendern
//STRIP001 			{
//STRIP001 				ClickModifyHdl_Impl( this );
//STRIP001 				//aXDash = pDashList->Get( nPos )->GetDash();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case RET_BTN_2: // Hinzufuegen
//STRIP001 			{
//STRIP001 				ClickAddHdl_Impl( this );
//STRIP001 				//nPos = aLbLineStyles.GetSelectEntryPos();
//STRIP001 				//aXDash = pDashList->Get( nPos )->GetDash();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case RET_CANCEL:
//STRIP001 			break;
//STRIP001 			// return( TRUE ); // Abbruch
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 	USHORT nPos = aLbLineStyles.GetSelectEntryPos();
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		*pPosDashLb = nPos;
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxLineDefTabPage::FillItemSet( SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	if( *pDlgType == 0 ) // Linien-Dialog
//STRIP001 	{
//STRIP001 		if( *pPageType == 2 )
//STRIP001 		{
//STRIP001 			//CheckChanges_Impl();
//STRIP001 
//STRIP001 			FillDash_Impl();
//STRIP001 
//STRIP001 			String aString( aLbLineStyles.GetSelectEntry() );
//STRIP001 			rAttrs.Put( XLineStyleItem( XLINE_DASH ) );
//STRIP001 			rAttrs.Put( XLineDashItem( aString, aDash ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( TRUE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxLineDefTabPage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	if( rAttrs.GetItemState( GetWhich( XATTR_LINESTYLE ) ) != SFX_ITEM_DONTCARE )
//STRIP001 	{
//STRIP001 		XLineStyle eXLS = (XLineStyle) ( ( const XLineStyleItem& ) rAttrs.Get( GetWhich( XATTR_LINESTYLE ) ) ).GetValue();
//STRIP001 
//STRIP001 		switch( eXLS )
//STRIP001 		{
//STRIP001 			case XLINE_NONE:
//STRIP001 			case XLINE_SOLID:
//STRIP001 				aLbLineStyles.SelectEntryPos( 0 );
//STRIP001 				break;
//STRIP001 
//STRIP001 			case XLINE_DASH:
//STRIP001 			{
//STRIP001 				const XLineDashItem& rDashItem = ( const XLineDashItem& ) rAttrs.Get( XATTR_LINEDASH );
//STRIP001 				aDash = rDashItem.GetValue();
//STRIP001 
//STRIP001 				aLbLineStyles.SetNoSelection();
//STRIP001 				aLbLineStyles.SelectEntry( rDashItem.GetName() );
//STRIP001 			}
//STRIP001 				break;
//STRIP001 
//STRIP001 			default:
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	SelectLinestyleHdl_Impl( NULL );
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if( pDashList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* SvxLineDefTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return( new SvxLineDefTabPage( pWindow, rOutAttrs ) );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, SelectLinestyleHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( pDashList->Count() > 0 )
//STRIP001 	{
//STRIP001 		int nTmp = aLbLineStyles.GetSelectEntryPos();
//STRIP001 		if( nTmp == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 		{
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aDash = pDashList->Get( nTmp )->GetDash();
//STRIP001 
//STRIP001 		FillDialog_Impl();
//STRIP001 
//STRIP001 		rXLSet.Put( XLineDashItem( String(), aDash ) );
//STRIP001 		XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 
//STRIP001 		aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 		// Wird erst hier gesetzt, um den Style nur dann zu uebernehmen,
//STRIP001 		// wenn in der ListBox ein Eintrag ausgewaehlt wurde
//STRIP001 		// Wenn ueber Reset() gerufen wurde ist p == NULL
//STRIP001 		if( p )
//STRIP001 			*pPageType = 2;
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxLineDefTabPage, ChangePreviewHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	FillDash_Impl();
//STRIP001 	aCtlPreview.Invalidate();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxLineDefTabPage, ChangePreviewHdl_Impl, void *, EMPTYARG )

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, ChangeNumber1Hdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( aNumFldNumber1.GetValue() == 0L )
//STRIP001 	{
//STRIP001 		aNumFldNumber2.SetMin( 1L );
//STRIP001 		aNumFldNumber2.SetFirst( 1L );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aNumFldNumber2.SetMin( 0L );
//STRIP001 		aNumFldNumber2.SetFirst( 0L );
//STRIP001 	}
//STRIP001 
//STRIP001 	ChangePreviewHdl_Impl( this );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, ChangeNumber2Hdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( aNumFldNumber2.GetValue() == 0L )
//STRIP001 	{
//STRIP001 		aNumFldNumber1.SetMin( 1L );
//STRIP001 		aNumFldNumber1.SetFirst( 1L );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aNumFldNumber1.SetMin( 0L );
//STRIP001 		aNumFldNumber1.SetFirst( 0L );
//STRIP001 	}
//STRIP001 
//STRIP001 	ChangePreviewHdl_Impl( this );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }


//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, ChangeMetricHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if( !aCbxSynchronize.IsChecked() && aMtrLength1.GetUnit() != eFUnit )
//STRIP001 	{
//STRIP001 		long nTmp1, nTmp2, nTmp3;
//STRIP001 
//STRIP001 		// Wurde ueber Control geaendert
//STRIP001 		if( p )
//STRIP001 		{
//STRIP001 			nTmp1 = GetCoreValue( aMtrLength1, ePoolUnit ) * XOUT_WIDTH / 100;
//STRIP001 			nTmp2 = GetCoreValue( aMtrLength2, ePoolUnit ) * XOUT_WIDTH / 100;
//STRIP001 			nTmp3 = GetCoreValue( aMtrDistance, ePoolUnit ) * XOUT_WIDTH / 100;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nTmp1 = GetCoreValue( aMtrLength1, ePoolUnit );
//STRIP001 			nTmp2 = GetCoreValue( aMtrLength2, ePoolUnit );
//STRIP001 			nTmp3 = GetCoreValue( aMtrDistance, ePoolUnit );
//STRIP001 		}
//STRIP001 		aMtrLength1.SetDecimalDigits( 2 );
//STRIP001 		aMtrLength2.SetDecimalDigits( 2 );
//STRIP001 		aMtrDistance.SetDecimalDigits( 2 );
//STRIP001 
//STRIP001 		// Metrik einstellen
//STRIP001 		aMtrLength1.SetUnit( eFUnit );
//STRIP001 		aMtrLength2.SetUnit( eFUnit );
//STRIP001 		aMtrDistance.SetUnit( eFUnit );
//STRIP001 
//STRIP001 		SetMetricValue( aMtrLength1, nTmp1, ePoolUnit );
//STRIP001 		SetMetricValue( aMtrLength2, nTmp2, ePoolUnit );
//STRIP001 		SetMetricValue( aMtrDistance, nTmp3, ePoolUnit );
//STRIP001 	}
//STRIP001 	else if( aCbxSynchronize.IsChecked() && aMtrLength1.GetUnit() != FUNIT_CUSTOM )
//STRIP001 	{
//STRIP001 		long nTmp1, nTmp2, nTmp3;
//STRIP001 
//STRIP001 		// Wurde ueber Control geaendert
//STRIP001 		if( p )
//STRIP001 		{
//STRIP001 			nTmp1 = GetCoreValue( aMtrLength1, ePoolUnit ) * 100 / XOUT_WIDTH;
//STRIP001 			nTmp2 = GetCoreValue( aMtrLength2, ePoolUnit ) * 100 / XOUT_WIDTH;
//STRIP001 			nTmp3 = GetCoreValue( aMtrDistance, ePoolUnit ) * 100 / XOUT_WIDTH;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nTmp1 = GetCoreValue( aMtrLength1, ePoolUnit );
//STRIP001 			nTmp2 = GetCoreValue( aMtrLength2, ePoolUnit );
//STRIP001 			nTmp3 = GetCoreValue( aMtrDistance, ePoolUnit );
//STRIP001 		}
//STRIP001 
//STRIP001 		aMtrLength1.SetDecimalDigits( 0 );
//STRIP001 		aMtrLength2.SetDecimalDigits( 0 );
//STRIP001 		aMtrDistance.SetDecimalDigits( 0 );
//STRIP001 
//STRIP001 		aMtrLength1.SetUnit( FUNIT_CUSTOM );
//STRIP001 		aMtrLength2.SetUnit( FUNIT_CUSTOM );
//STRIP001 		aMtrDistance.SetUnit( FUNIT_CUSTOM );
//STRIP001 
//STRIP001 
//STRIP001 		SetMetricValue( aMtrLength1, nTmp1, ePoolUnit );
//STRIP001 		SetMetricValue( aMtrLength2, nTmp2, ePoolUnit );
//STRIP001 		SetMetricValue( aMtrDistance, nTmp3, ePoolUnit );
//STRIP001 	}
//STRIP001 	SelectTypeHdl_Impl( NULL );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, SelectTypeHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	if ( p == &aLbType1 || !p )
//STRIP001 	{
//STRIP001 		if ( aLbType1.GetSelectEntryPos() == 0 )
//STRIP001 		{
//STRIP001 			aMtrLength1.Disable();
//STRIP001 			aMtrLength1.SetText( String() );
//STRIP001 		}
//STRIP001 		else if ( !aMtrLength1.IsEnabled() )
//STRIP001 		{
//STRIP001 			aMtrLength1.Enable();
//STRIP001 			aMtrLength1.Reformat();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( p == &aLbType2 || !p )
//STRIP001 	{
//STRIP001 		if ( aLbType2.GetSelectEntryPos() == 0 )
//STRIP001 		{
//STRIP001 			aMtrLength2.Disable();
//STRIP001 			aMtrLength2.SetText( String() );
//STRIP001 		}
//STRIP001 		else if ( !aMtrLength2.IsEnabled() )
//STRIP001 		{
//STRIP001 			aMtrLength2.Enable();
//STRIP001 			aMtrLength2.Reformat();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	ChangePreviewHdl_Impl( p );
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, ClickAddHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	String aNewName( ResId( RID_SVXSTR_LINESTYLE, pMgr ) );
//STRIP001 	String aDesc( ResId( RID_SVXSTR_DESC_LINESTYLE, pMgr ) );
//STRIP001 	String aName;
//STRIP001 	XDashEntry* pEntry;
//STRIP001 
//STRIP001 	long nCount = pDashList->Count();
//STRIP001 	long j = 1;
//STRIP001 	BOOL bDifferent = FALSE;
//STRIP001 
//STRIP001 	while ( !bDifferent )
//STRIP001 	{
//STRIP001 		aName = aNewName;
//STRIP001 		aName += sal_Unicode(' ');
//STRIP001 		aName += UniString::CreateFromInt32( j++ );
//STRIP001 		bDifferent = TRUE;
//STRIP001 
//STRIP001 		for ( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			if ( aName == pDashList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 	BOOL bLoop = TRUE;
//STRIP001 
//STRIP001 	while ( bLoop && pDlg->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		pDlg->GetName( aName );
//STRIP001 		bDifferent = TRUE;
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 		{
//STRIP001 			if( aName == pDashList->Get( i )->GetName() )
//STRIP001 				bDifferent = FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bDifferent )
//STRIP001 		{
//STRIP001 			bLoop = FALSE;
//STRIP001 			FillDash_Impl();
//STRIP001 
//STRIP001 			pEntry = new XDashEntry( aDash, aName );
//STRIP001 
//STRIP001 			long nCount = pDashList->Count();
//STRIP001 			pDashList->Insert( pEntry, nCount );
//STRIP001 			Bitmap* pBitmap = pDashList->GetBitmap( nCount );
//STRIP001 			aLbLineStyles.Append( pEntry, pBitmap );
//STRIP001 
//STRIP001 			aLbLineStyles.SelectEntryPos( aLbLineStyles.GetEntryCount() - 1 );
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnDashListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 			*pPageType = 2;
//STRIP001 
//STRIP001 			// Werte sichern fuer Changes-Erkennung ( -> Methode )
//STRIP001 			aNumFldNumber1.SaveValue();
//STRIP001 			aMtrLength1.SaveValue();
//STRIP001 			aLbType1.SaveValue();
//STRIP001 			aNumFldNumber2.SaveValue();
//STRIP001 			aMtrLength2.SaveValue();
//STRIP001 			aLbType2.SaveValue();
//STRIP001 			aMtrDistance.SaveValue();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			WarningBox aBox( DLGWIN, WinBits( WB_OK ),String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 			aBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 			aBox.Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	delete( pDlg );
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if ( pDashList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, ClickModifyHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbLineStyles.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( nPos != LISTBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		ResMgr* pMgr = DIALOG_MGR();
//STRIP001 		String aNewName( ResId( RID_SVXSTR_LINESTYLE, pMgr ) );
//STRIP001 		String aDesc( ResId( RID_SVXSTR_DESC_LINESTYLE, pMgr ) );
//STRIP001 		String aName( pDashList->Get( nPos )->GetName() );
//STRIP001 		String aOldName = aName;
//STRIP001 
//STRIP001 		SvxNameDialog* pDlg = new SvxNameDialog( DLGWIN, aName, aDesc );
//STRIP001 
//STRIP001 		long nCount = pDashList->Count();
//STRIP001 		BOOL bDifferent = FALSE;
//STRIP001 		BOOL bLoop = TRUE;
//STRIP001 
//STRIP001 		while ( bLoop && pDlg->Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			pDlg->GetName( aName );
//STRIP001 			bDifferent = TRUE;
//STRIP001 
//STRIP001 			for( long i = 0; i < nCount && bDifferent; i++ )
//STRIP001 			{
//STRIP001 				if( aName == pDashList->Get( i )->GetName() &&
//STRIP001 					aName != aOldName )
//STRIP001 					bDifferent = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bDifferent )
//STRIP001 			{
//STRIP001 				bLoop = FALSE;
//STRIP001 				FillDash_Impl();
//STRIP001 
//STRIP001 				XDashEntry* pEntry = new XDashEntry( aDash, aName );
//STRIP001 
//STRIP001 				delete pDashList->Replace( pEntry, nPos );
//STRIP001 				Bitmap* pBitmap = pDashList->GetBitmap( nPos );
//STRIP001 				aLbLineStyles.Modify( pEntry, nPos, pBitmap );
//STRIP001 
//STRIP001 				aLbLineStyles.SelectEntryPos( nPos );
//STRIP001 
//STRIP001 				// Flag fuer modifiziert setzen
//STRIP001 				*pnDashListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 				*pPageType = 2;
//STRIP001 
//STRIP001 				// Werte sichern fuer Changes-Erkennung ( -> Methode )
//STRIP001 				aNumFldNumber1.SaveValue();
//STRIP001 				aMtrLength1.SaveValue();
//STRIP001 				aLbType1.SaveValue();
//STRIP001 				aNumFldNumber2.SaveValue();
//STRIP001 				aMtrLength2.SaveValue();
//STRIP001 				aLbType2.SaveValue();
//STRIP001 				aMtrDistance.SaveValue();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				WarningBox aBox( DLGWIN, WinBits( WB_OK ), String( ResId( RID_SVXSTR_WARN_NAME_DUPLICATE, pMgr ) ) );
//STRIP001 				aBox.SetHelpId( HID_WARN_NAME_DUPLICATE );
//STRIP001 				aBox.Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		delete( pDlg );
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, ClickDeleteHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	int nPos = aLbLineStyles.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if ( nPos >= 0 )
//STRIP001 	{
//STRIP001 		QueryBox aQueryBox( DLGWIN, WinBits( WB_YES_NO | WB_DEF_NO ),
//STRIP001 //!			SVX_RES( RID_SVXSTR_DEL_LINESTYLE ),
//STRIP001 			String( SVX_RES( RID_SVXSTR_ASK_DEL_LINESTYLE ) ) );
//STRIP001 
//STRIP001 		if ( aQueryBox.Execute() == RET_YES )
//STRIP001 		{
//STRIP001 			delete pDashList->Remove( nPos );
//STRIP001 			aLbLineStyles.RemoveEntry( nPos );
//STRIP001 			aLbLineStyles.SelectEntryPos( 0 );
//STRIP001 
//STRIP001 			SelectLinestyleHdl_Impl( this );
//STRIP001 			*pPageType = 0; // Style soll nicht uebernommen werden
//STRIP001 
//STRIP001 			// Flag fuer modifiziert setzen
//STRIP001 			*pnDashListState |= CT_MODIFIED;
//STRIP001 
//STRIP001 			ChangePreviewHdl_Impl( this );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if ( !pDashList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, ClickLoadHdl_Impl, void *, p )
//STRIP001 {
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	USHORT nReturn = RET_YES;
//STRIP001 
//STRIP001 	if ( *pnDashListState & CT_MODIFIED )
//STRIP001 	{
//STRIP001 		nReturn = WarningBox( DLGWIN, WinBits( WB_YES_NO_CANCEL ),
//STRIP001 			String( ResId( RID_SVXSTR_WARN_TABLE_OVERWRITE, pMgr ) ) ).Execute();
//STRIP001 
//STRIP001 		if ( nReturn == RET_YES )
//STRIP001 			pDashList->Save();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nReturn != RET_CANCEL )
//STRIP001 	{
//STRIP001     	::sfx2::FileDialogHelper aDlg( ::sfx2::FILEOPEN_SIMPLE, 0 );
//STRIP001 		String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.sod" ) );
//STRIP001 		aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 		INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 		aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 		{
//STRIP001 			INetURLObject aURL( aDlg.GetPath() );
//STRIP001 			INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 			aPathURL.removeSegment();
//STRIP001 			aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 			// Liste speichern
//STRIP001 			XDashList* pDshLst = new XDashList( aPathURL.GetMainURL( INetURLObject::NO_DECODE ), pXPool );
//STRIP001 			pDshLst->SetName( aURL.getName() );
//STRIP001 
//STRIP001 			if( pDshLst->Load() )
//STRIP001 			{
//STRIP001 				if( pDshLst )
//STRIP001 				{
//STRIP001 					// Pruefen, ob Tabelle geloescht werden darf:
//STRIP001 					if( pDashList != ( (SvxLineTabDialog*) DLGWIN )->GetDashList() )
//STRIP001 						delete pDashList;
//STRIP001 
//STRIP001 					pDashList = pDshLst;
//STRIP001 					( (SvxLineTabDialog*) DLGWIN )->SetNewDashList( pDashList );
//STRIP001 
//STRIP001 					aLbLineStyles.Clear();
//STRIP001 					aLbLineStyles.Fill( pDashList );
//STRIP001 					Reset( rOutAttrs );
//STRIP001 
//STRIP001 					pDashList->SetName( aURL.getName() );
//STRIP001 
//STRIP001 /*					// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 					// der GroupBox darstellen
//STRIP001 					String aString( ResId( RID_SVXSTR_TABLE, pMgr ) );
//STRIP001 					aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 					if ( aURL.getBase().Len() > 18 )
//STRIP001 					{
//STRIP001 						aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 						aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aString += aURL.getBase();
//STRIP001 
//STRIP001 					aGrpLinestyles.SetText( aString );
//STRIP001 */
//STRIP001 					// Flag fuer gewechselt setzen
//STRIP001 					*pnDashListState |= CT_CHANGED;
//STRIP001 					// Flag fuer modifiziert entfernen
//STRIP001 					*pnDashListState &= ~CT_MODIFIED;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				//aIStream.Close();
//STRIP001 				ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 					String( ResId( RID_SVXSTR_READ_DATA_ERROR, pMgr ) ) ).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Status der Buttons ermitteln
//STRIP001 	if ( pDashList->Count() )
//STRIP001 	{
//STRIP001 		aBtnModify.Enable();
//STRIP001 		aBtnDelete.Enable();
//STRIP001 		aBtnSave.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnModify.Disable();
//STRIP001 		aBtnDelete.Disable();
//STRIP001 		aBtnSave.Disable();
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxLineDefTabPage, ClickSaveHdl_Impl, void *, p )
//STRIP001 {
//STRIP001    	::sfx2::FileDialogHelper aDlg( ::sfx2::FILESAVE_SIMPLE, 0 );
//STRIP001 	String aStrFilterType( RTL_CONSTASCII_USTRINGPARAM( "*.sod" ) );
//STRIP001 	aDlg.AddFilter( aStrFilterType, aStrFilterType );
//STRIP001 
//STRIP001 	INetURLObject aFile( SvtPathOptions().GetPalettePath() );
//STRIP001 	DBG_ASSERT( aFile.GetProtocol() != INET_PROT_NOT_VALID, "invalid URL" );
//STRIP001 
//STRIP001 	if( pDashList->GetName().Len() )
//STRIP001 	{
//STRIP001 		aFile.Append( pDashList->GetName() );
//STRIP001 
//STRIP001 		if( !aFile.getExtension().Len() )
//STRIP001 			aFile.SetExtension( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "sod" ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	aDlg.SetDisplayDirectory( aFile.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 	if ( aDlg.Execute() == ERRCODE_NONE )
//STRIP001 	{
//STRIP001 		INetURLObject aURL( aDlg.GetPath() );
//STRIP001 		INetURLObject aPathURL( aURL );
//STRIP001 
//STRIP001 		aPathURL.removeSegment();
//STRIP001 		aPathURL.removeFinalSlash();
//STRIP001 
//STRIP001 		pDashList->SetName( aURL.getName() );
//STRIP001 		pDashList->SetPath( aPathURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 		if( pDashList->Save() )
//STRIP001 		{
//STRIP001 /*			// Ermitteln (evtl. abschneiden) des Namens und in
//STRIP001 			// der GroupBox darstellen
//STRIP001 			String aString( SVX_RES( RID_SVXSTR_TABLE ) );
//STRIP001 			aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) );
//STRIP001 
//STRIP001 			if ( aURL.getBase().Len() > 18 )
//STRIP001 			{
//STRIP001 				aString += aURL.getBase().Copy( 0, 15 );
//STRIP001 				aString.AppendAscii( RTL_CONSTASCII_STRINGPARAM( "..." ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aString += aURL.getBase();
//STRIP001 
//STRIP001 			aGrpLinestyles.SetText( aString );
//STRIP001 */
//STRIP001 			// Flag fuer gespeichert setzen
//STRIP001 			*pnDashListState |= CT_SAVED;
//STRIP001 			// Flag fuer modifiziert entfernen
//STRIP001 			*pnDashListState &= ~CT_MODIFIED;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ErrorBox( DLGWIN, WinBits( WB_OK ),
//STRIP001 				String( SVX_RES( RID_SVXSTR_WRITE_DATA_ERROR ) ) ).Execute();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxLineDefTabPage::FillDash_Impl()
//STRIP001 {
//STRIP001 	XDashStyle eXDS;
//STRIP001 
//STRIP001 /*	Alle Stile werden z.Z. nicht benutzt
//STRIP001 	if( aRbtEnds1.IsChecked() )
//STRIP001 		eXDS = XDASH_ROUND;
//STRIP001 	else if( aRbtEnds2.IsChecked() )
//STRIP001 		eXDS = XDASH_RECT;
//STRIP001 	else
//STRIP001 		eXDS = XDASH_RECT;
//STRIP001 */
//STRIP001 	if( aCbxSynchronize.IsChecked() )
//STRIP001 		eXDS = XDASH_RECTRELATIVE;
//STRIP001 	else
//STRIP001 		eXDS = XDASH_RECT;
//STRIP001 
//STRIP001 	aDash.SetDashStyle( eXDS );
//STRIP001 	aDash.SetDots( (BYTE) aNumFldNumber1.GetValue() );
//STRIP001 	aDash.SetDotLen( aLbType1.GetSelectEntryPos() == 0 ? 0 :
//STRIP001 								GetCoreValue( aMtrLength1, ePoolUnit ) );
//STRIP001 	aDash.SetDashes( (BYTE) aNumFldNumber2.GetValue() );
//STRIP001 	aDash.SetDashLen( aLbType2.GetSelectEntryPos() == 0 ? 0 :
//STRIP001 								GetCoreValue( aMtrLength2, ePoolUnit ) );
//STRIP001 	aDash.SetDistance( GetCoreValue( aMtrDistance, ePoolUnit ) );
//STRIP001 
//STRIP001 	rXLSet.Put( XLineDashItem( String(), aDash ) );
//STRIP001 	XOut.SetLineAttr( aXLineAttr.GetItemSet() );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxLineDefTabPage::FillDialog_Impl()
//STRIP001 {
//STRIP001 	XDashStyle eXDS = aDash.GetDashStyle(); // XDASH_RECT, XDASH_ROUND
//STRIP001 	if( eXDS == XDASH_RECTRELATIVE )
//STRIP001 		aCbxSynchronize.Check();
//STRIP001 	else
//STRIP001 		aCbxSynchronize.Check( FALSE );
//STRIP001 
//STRIP001 	aNumFldNumber1.SetValue( aDash.GetDots() );
//STRIP001 	//aMtrLength1.SetValue( aDash.GetDotLen() );
//STRIP001 	SetMetricValue( aMtrLength1, aDash.GetDotLen(), ePoolUnit );
//STRIP001 	aLbType1.SelectEntryPos( aDash.GetDotLen() == 0 ? 0 : 1 );
//STRIP001 	aNumFldNumber2.SetValue( aDash.GetDashes() );
//STRIP001 	//aMtrLength2.SetValue( aDash.GetDashLen() );
//STRIP001 	SetMetricValue( aMtrLength2, aDash.GetDashLen(), ePoolUnit );
//STRIP001 	aLbType2.SelectEntryPos( aDash.GetDashLen() == 0 ? 0 : 1 );
//STRIP001 	//aMtrDistance.SetValue( aDash.GetDistance() );
//STRIP001 	SetMetricValue( aMtrDistance, aDash.GetDistance(), ePoolUnit );
//STRIP001 
//STRIP001 	ChangeMetricHdl_Impl( NULL );
//STRIP001 
//STRIP001 	// Werte sichern fuer Changes-Erkennung ( -> Methode )
//STRIP001 	aNumFldNumber1.SaveValue();
//STRIP001 	aMtrLength1.SaveValue();
//STRIP001 	aLbType1.SaveValue();
//STRIP001 	aNumFldNumber2.SaveValue();
//STRIP001 	aMtrLength2.SaveValue();
//STRIP001 	aLbType2.SaveValue();
//STRIP001 	aMtrDistance.SaveValue();
//STRIP001 }


//STRIP001 void SvxLineDefTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	SfxTabPage::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		USHORT nOldSelect = aLbLineStyles.GetSelectEntryPos();
//STRIP001 		aLbLineStyles.Clear();
//STRIP001 		aLbLineStyles.Fill( pDashList );
//STRIP001 		aLbLineStyles.SelectEntryPos( nOldSelect );
//STRIP001 	}
//STRIP001 }

}
