/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_glosdoc.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:17:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/



#pragma hdrstop

#define _SVSTDARR_STRINGS

// auto strip #ifndef _UNOTOOLS_TRANSLITERATIONWRAPPER_HXX
// auto strip #include <unotools/transliterationwrapper.hxx>
// auto strip #endif

#include <svtools/svstdarr.hxx>

// auto strip #ifndef __RSC //autogen
// auto strip #include <tools/errinf.hxx>
// auto strip #endif
// auto strip #ifndef _TOOLS_DEBUG_HXX //autogen
// auto strip #include <tools/debug.hxx>
// auto strip #endif
#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef SVTOOLS_FSTATHELPER_HXX
#include <svtools/fstathelper.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef _UNOTOOLS_TEMPFILE_HXX
#include <unotools/tempfile.hxx>
#endif

// auto strip #ifndef _SWTYPES_HXX
// auto strip #include <swtypes.hxx>
// auto strip #endif
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>		// ASSERT
#endif
#ifndef _UITOOL_HXX
#include <uitool.hxx>
#endif
#ifndef _GLOSDOC_HXX
#include <glosdoc.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif
#ifndef _SWUNOHELPER_HXX
#include <swunohelper.hxx>
#endif

#ifndef _SWSWERROR_H
#include <swerror.h>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#include "so3/staticbaseurl.hxx"
namespace binfilter {


// PUBLIC METHODES -------------------------------------------------------
/* -----------------------------08.02.00 15:54--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 String lcl_CheckFileName( const String& rNewFilePath,
//STRIP001 						  const String& rNewGroupName )
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 	//group name should contain only A-Z and a-z and spaces
//STRIP001 	for( xub_StrLen i = 0; i < rNewGroupName.Len(); i++ )
//STRIP001 	{
//STRIP001 		sal_Unicode cChar = rNewGroupName.GetChar(i);
//STRIP001 		if(	(cChar >= 'A' && cChar <= 'Z') ||
//STRIP001 			(cChar >= 'a' && cChar <= 'z') ||
//STRIP001 			(cChar >= '0' && cChar <= '9') ||
//STRIP001 			cChar == '_' || cChar == 0x20 )
//STRIP001 		{
//STRIP001 			sRet += cChar;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	sRet.EraseLeadingChars();
//STRIP001 	sRet.EraseTrailingChars();
//STRIP001 
//STRIP001 	BOOL bOk = FALSE;
//STRIP001 	if( sRet.Len() )
//STRIP001 	{
//STRIP001 		String sTmpDir(rNewFilePath);
//STRIP001 		sTmpDir += INET_PATH_TOKEN;
//STRIP001 		sTmpDir += sRet;
//STRIP001 		sTmpDir += SwGlossaries::GetExtension();
//STRIP001 		bOk = !FStatHelper::IsDocument( sTmpDir );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !bOk )
//STRIP001 	{
//STRIP001 		String rSG = SwGlossaries::GetExtension();
//STRIP001 		//generate generic name
//STRIP001 		utl::TempFile aTemp(
//STRIP001 			String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "group" )),
//STRIP001 			&rSG, &rNewFilePath );
//STRIP001 		aTemp.EnableKillingFile();
//STRIP001 
//STRIP001 		INetURLObject aTempURL( aTemp.GetURL() );
//STRIP001 		sRet = aTempURL.GetBase();
//STRIP001 	}
//STRIP001 	return sRet;
//STRIP001 }
/*------------------------------------------------------------------------
	Beschreibung: Liefert den Namen der Default-Gruppe
------------------------------------------------------------------------*/


/*N*/ String	SwGlossaries::GetDefName()
/*N*/ {
/*N*/ 	return String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( "standard" ));
/*N*/ 
/*N*/ }
/*------------------------------------------------------------------------
	Beschreibung: Liefert die Anzahl der Textbausteingruppen
------------------------------------------------------------------------*/


/*N*/ sal_uInt16 SwGlossaries::GetGroupCnt()
/*N*/ {
/*N*/ 	return  GetNameList()->Count();
/*N*/ }
/*------------------------------------------------------------------------
	Beschreibung: Liefert den Gruppennamen
------------------------------------------------------------------------*/
/*N*/ sal_Bool SwGlossaries::FindGroupName(String & rGroup)
/*N*/ {
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 //STRIP001 	//	enthaelt der Gruppenname keinen Pfad, kann hier ein passender
//STRIP001 	// Gruppeneintrag gesucht werden;
//STRIP001 	sal_uInt16 nCount = GetGroupCnt();
//STRIP001 	sal_uInt16 i;
//STRIP001 	for(i= 0; i < nCount; i++)
//STRIP001 	{
//STRIP001 		String sTemp(GetGroupName(i));
//STRIP001 		if(rGroup.Equals( sTemp.GetToken(0, GLOS_DELIM)))
//STRIP001 		{
//STRIP001 			rGroup = sTemp;
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	//man darf zweimal suchen, denn bei mehreren Verzeichnissen koennte
//STRIP001 	//der caseinsensitive Name mehrfach auftreten
//STRIP001 	const ::utl::TransliterationWrapper& rSCmp = GetAppCmpStrIgnore();
//STRIP001 	for(i = 0; i < nCount; i++)
//STRIP001 	{
//STRIP001 		String sTemp( GetGroupName( i ));
//STRIP001 		sal_uInt16 nPath = (sal_uInt16)sTemp.GetToken(1, GLOS_DELIM).ToInt32();
//STRIP001 
//STRIP001 		if( !SWUnoHelper::UCB_IsCaseSensitiveFileName( *(*pPathArr)[nPath] )
//STRIP001 		 	&& rSCmp.isEqual( rGroup, sTemp.GetToken( 0, GLOS_DELIM) ) )
//STRIP001 		{
//STRIP001 			rGroup = sTemp;
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sal_False;
/*N*/ }
/* ---------------------------------------------------------------------------

 ---------------------------------------------------------------------------*/

/*N*/ String SwGlossaries::GetGroupName(sal_uInt16 nGroupId)
/*N*/ {
/*N*/ 	ASSERT(nGroupId < pGlosArr->Count(), Textbausteinarray ueberindiziert);
/*N*/ 	return *(*pGlosArr)[nGroupId];
/*N*/ }
/* -----------------------------08.02.00 13:04--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ String	SwGlossaries::GetGroupTitle( const String& rGroupName )
/*N*/ {
/*N*/ 	String	sRet;
/*N*/ 	String sGroup(rGroupName);
/*N*/ 	if(STRING_NOTFOUND == sGroup.Search(GLOS_DELIM))
/*N*/ 		FindGroupName(sGroup);
/*N*/ 	SwTextBlocks* pGroup = GetGroupDoc(sGroup, sal_False);
/*N*/ 	if(pGroup)
/*N*/ 	{
/*N*/ 		sRet = pGroup->GetName();
/*N*/ 	 	PutGroupDoc( pGroup );
/*N*/ 	}
/*N*/ 	return sRet;
/*N*/ }

/*------------------------------------------------------------------------
	Beschreibung: Liefert das Textbaustein-Dokument der Gruppe rName
------------------------------------------------------------------------*/

/*N*/ SwTextBlocks* SwGlossaries::GetGroupDoc(const String &rName,
/*N*/ 										sal_Bool bCreate) const
/*N*/ {
/*N*/ 		// gfs. in die Liste der Textbausteine eintragen
/*N*/ 	if(bCreate && pGlosArr)
/*N*/ 	{
/*N*/ 		const String aName(rName);
/*N*/ 		const sal_uInt16 nCount = pGlosArr->Count();
			sal_uInt16 i=0;
/*N*/ 		for(i = 0; i < nCount; ++i)
/*N*/ 		{
/*N*/ 			const String *pName = (*pGlosArr)[i];
/*N*/ 			if(*pName == aName)
/*N*/ 				break;
/*N*/ 		}
/*N*/ 		if(i == nCount)
/*N*/ 		{	// Baustein nicht in der Liste
/*N*/ 			String *pTmp = new String(aName);
/*N*/ 			pGlosArr->Insert(pTmp, pGlosArr->Count());
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return GetGlosDoc( rName, bCreate );
/*N*/ }

/*------------------------------------------------------------------------
 Beschreibung:	Loeschen Textblock
------------------------------------------------------------------------*/

/*N*/ void SwGlossaries::PutGroupDoc(SwTextBlocks *pBlock) {
/*N*/ 	delete pBlock;
/*N*/ }
/*------------------------------------------------------------------------
	Beschreibung:	Erzeugt ein neues Dokument mit dem Gruppenname
					Wird temp. auch als File angelegt, damit die
					Gruppen auch spaeter (ohne Zugriff) vorhanden sind.
------------------------------------------------------------------------*/


/*N*/ sal_Bool SwGlossaries::NewGroupDoc(String& rGroupName, const String& rTitle)
/*N*/ {
		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 //STRIP001 	sal_uInt16 nNewPath = (sal_uInt16)rGroupName.GetToken(1, GLOS_DELIM).ToInt32();
//STRIP001 	String sNewFilePath(*(*pPathArr)[nNewPath]);
//STRIP001 	String sNewGroup = lcl_CheckFileName(sNewFilePath, rGroupName.GetToken(0, GLOS_DELIM));
//STRIP001 	sNewGroup += GLOS_DELIM;
//STRIP001 	sNewGroup += rGroupName.GetToken(1, GLOS_DELIM);
//STRIP001 	SwTextBlocks *pBlock = GetGlosDoc( sNewGroup );
//STRIP001 	if(pBlock)
//STRIP001 	{
//STRIP001 		String *pTmp =
//STRIP001 			new String(sNewGroup);
//STRIP001 		SvStrings* pList = GetNameList();
//STRIP001 		pList->Insert(pTmp, pList->Count());
//STRIP001 		pBlock->SetName(rTitle);
//STRIP001 		PutGroupDoc(pBlock);
//STRIP001 		rGroupName = sNewGroup;
//STRIP001 		rGroupName += GLOS_DELIM;
//STRIP001 		rGroupName += String::CreateFromInt32(nNewPath);
//STRIP001 		return sal_True;
//STRIP001 	}
/*N*/ 	return sal_False;
/*N*/ }
/* -----------------23.11.98 13:13-------------------
 *
 * --------------------------------------------------*/
/*N*/ sal_Bool	SwGlossaries::RenameGroupDoc(
/*N*/ 	const String& rOldGroup, String& rNewGroup, const String& rNewTitle )
/*N*/ {
/*N*/ 	sal_Bool bRet = sal_False;
/*N*/ 	sal_uInt16 nOldPath = (sal_uInt16)rOldGroup.GetToken(1, GLOS_DELIM).ToInt32();
/*N*/ 	if(nOldPath < pPathArr->Count())
/*N*/ 	{
/*N*/ 		String sOldFileURL(*(*pPathArr)[nOldPath]);
/*N*/ 		sOldFileURL += INET_PATH_TOKEN;
/*N*/ 		sOldFileURL += rOldGroup.GetToken(0, GLOS_DELIM);
/*N*/ 		sOldFileURL += SwGlossaries::GetExtension();
/*N*/ 		BOOL bExist = FStatHelper::IsDocument( sOldFileURL );
/*N*/ 		DBG_ASSERT(bExist, "Gruppe existiert nicht!")
/*N*/ 		if(bExist)
/*N*/ 		{
/*N*/ 			sal_uInt16 nNewPath = (sal_uInt16)rNewGroup.GetToken(1, GLOS_DELIM).ToInt32();
/*N*/ 			if( nNewPath < pPathArr->Count())
/*N*/ 			{
					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 				String sNewFilePath(*(*pPathArr)[nNewPath]);
//STRIP001 				String sNewFileName = lcl_CheckFileName(
//STRIP001 									sNewFilePath, rNewGroup.GetToken(0, GLOS_DELIM));
//STRIP001 				//String aTmp( rNewGroup.GetToken(0, GLOS_DELIM));
//STRIP001 				const sal_uInt16 nFileNameLen = sNewFileName.Len();
//STRIP001 				sNewFileName += SwGlossaries::GetExtension();
//STRIP001 				String sTempNewFilePath(sNewFilePath);
//STRIP001 				sTempNewFilePath += INET_PATH_TOKEN;
//STRIP001 				sTempNewFilePath += sNewFileName ;
//STRIP001 				BOOL bExist = FStatHelper::IsDocument( sTempNewFilePath );
//STRIP001 				DBG_ASSERT(!bExist, "Gruppe existiert bereits!")
//STRIP001 				if(!bExist)
//STRIP001 				{
//STRIP001 					BOOL bCopyCompleted = SWUnoHelper::UCB_CopyFile(
//STRIP001 										sOldFileURL, sTempNewFilePath, TRUE );
//STRIP001 					if(bCopyCompleted)
//STRIP001 					{
//STRIP001 						bRet = sal_True;
//STRIP001 						RemoveFileFromList( rOldGroup );
//STRIP001 
//STRIP001 						rNewGroup = sNewFileName.Copy(0, nFileNameLen);
//STRIP001 						rNewGroup += GLOS_DELIM;
//STRIP001 						rNewGroup += String::CreateFromInt32(nNewPath);
//STRIP001 						String *pTmp = new String(rNewGroup);
//STRIP001 						if(!pGlosArr)
//STRIP001 							GetNameList();
//STRIP001 						else
//STRIP001 							pGlosArr->Insert(pTmp, pGlosArr->Count());
//STRIP001 
//STRIP001 						sNewFilePath += INET_PATH_TOKEN;
//STRIP001 						sNewFilePath += sNewFileName ;
//STRIP001 						SwTextBlocks* pNewBlock = new SwTextBlocks( sNewFilePath );
//STRIP001 						pNewBlock->SetName(rNewTitle);
//STRIP001 						delete pNewBlock;
//STRIP001 					}
//STRIP001 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	return bRet;
/*N*/ }

/*------------------------------------------------------------------------
	Beschreibung: Loescht eine Textbausteingruppe
------------------------------------------------------------------------*/


/*N*/ sal_Bool SwGlossaries::DelGroupDoc(const String &rName)
/*N*/ {
/*N*/ 	sal_uInt16 nPath = (sal_uInt16)rName.GetToken(1, GLOS_DELIM).ToInt32();
/*N*/ 	if(nPath >= pPathArr->Count())
/*N*/ 		return sal_False;
/*N*/ 	String sFileURL(*(*pPathArr)[nPath]);
/*N*/ 	String aTmp( rName.GetToken(0, GLOS_DELIM));
/*N*/ 	String aName(aTmp);
/*N*/ 	aName += GLOS_DELIM;
/*N*/ 	aName += String::CreateFromInt32(nPath);
/*N*/ 
/*N*/ 	aTmp += SwGlossaries::GetExtension();
/*N*/ 	sFileURL += INET_PATH_TOKEN;
/*N*/ 	sFileURL += aTmp;
/*N*/ 		// Auch, wenn das File nicht existiert, muss es aus der Liste
/*N*/ 		// der Textbausteinbereiche entfernt werden
/*N*/ 	// Kein && wegen CFfront
/*N*/ 	BOOL bRemoved = SWUnoHelper::UCB_DeleteFile( sFileURL );
/*N*/ 	DBG_ASSERT(bRemoved, "file has not been removed");
/*N*/ 	RemoveFileFromList( aName );
/*N*/ 	return bRemoved;
/*N*/ }
/*------------------------------------------------------------------------
	Beschreibung: DTOR
------------------------------------------------------------------------*/


/*N*/ SwGlossaries::~SwGlossaries()
/*N*/ {
/*N*/ 	sal_uInt16 nCount = pGlosArr? pGlosArr->Count() : 0;
		sal_uInt16 i=0;
/*N*/ 	for( i = 0; i < nCount; ++i)
/*N*/ 	{
/*N*/ 		String *pTmp = (*pGlosArr)[i];
/*N*/ 		delete pTmp;
/*N*/ 	}
/*N*/ 	nCount = pPathArr? pPathArr->Count() : 0;
/*N*/ 	for(i = 0; i < nCount; ++i)
/*N*/ 	{
/*N*/ 		String *pTmp = (*pPathArr)[i];
/*N*/ 		delete pTmp;
/*N*/ 	}
/*N*/ 	delete pGlosArr;
/*N*/ 	delete pPathArr;
/*N*/ 
/*N*/ 	InvalidateUNOOjects();
/*N*/ }
/*------------------------------------------------------------------------
	Beschreibung: Bausteindokument einlesen
------------------------------------------------------------------------*/


//STRIP001 SwTextBlocks* SwGlossaries::GetGlosDoc( const String &rName, sal_Bool bCreate ) const
//STRIP001 {
//STRIP001 	sal_uInt16 nPath = (sal_uInt16)rName.GetToken(1, GLOS_DELIM).ToInt32();
//STRIP001 	SwTextBlocks *pTmp = 0;
//STRIP001 	if(nPath < pPathArr->Count())
//STRIP001 	{
//STRIP001 		String sFileURL(*(*pPathArr)[nPath]);
//STRIP001 		String aTmp( rName.GetToken(0, GLOS_DELIM));
//STRIP001 		aTmp += SwGlossaries::GetExtension();
//STRIP001 		sFileURL += INET_PATH_TOKEN;
//STRIP001 		sFileURL += aTmp;
//STRIP001 
//STRIP001 		BOOL bExist = FALSE;
//STRIP001 		if(!bCreate)
//STRIP001 			bExist = FStatHelper::IsDocument( sFileURL );
//STRIP001 
//STRIP001 		if (bCreate || bExist)
//STRIP001 		{
//STRIP001 			pTmp = new SwTextBlocks( sFileURL );
//STRIP001 			sal_Bool bOk = sal_True;
//STRIP001 			if( pTmp->GetError() )
//STRIP001 			{
//STRIP001 				ErrorHandler::HandleError( pTmp->GetError() );
//STRIP001 				bOk = !IsError( pTmp->GetError() );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bOk && !pTmp->GetName().Len() )
//STRIP001 				pTmp->SetName( rName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pTmp;
//STRIP001 }

/*------------------------------------------------------------------------
	Beschreibung: Zugriff auf die Liste der Name; diese wird gfs. eingelesen
------------------------------------------------------------------------*/

/*N*/ SvStrings* SwGlossaries::GetNameList()
/*N*/ {
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 //STRIP001 	if( !pGlosArr )
//STRIP001 	{
//STRIP001 		pGlosArr = new SvStrings;
//STRIP001 		String sExt( SwGlossaries::GetExtension() );
//STRIP001 		for( sal_uInt16 i = 0; i < pPathArr->Count(); i++ )
//STRIP001 		{
//STRIP001 			SvStrings aFiles( 16, 16 );
//STRIP001 
//STRIP001 			SWUnoHelper::UCB_GetFileListOfFolder( *(*pPathArr)[i], aFiles,
//STRIP001 													&sExt );
//STRIP001 			for( USHORT nFiles = 0, nFEnd = aFiles.Count();
//STRIP001 					nFiles < nFEnd; ++nFiles )
//STRIP001 			{
//STRIP001 				String* pTitle = aFiles[ nFiles ];
//STRIP001 				String sName( pTitle->Copy( 0, pTitle->Len() - sExt.Len() ));
//STRIP001 				sName += GLOS_DELIM;
//STRIP001 				sName += String::CreateFromInt32( i );
//STRIP001 				pGlosArr->Insert( new String(sName), pGlosArr->Count() );
//STRIP001 
//STRIP001 				// don't need any more these pointers
//STRIP001 				delete pTitle;
//STRIP001 			}
//STRIP001     	}
//STRIP001 		if(!pGlosArr->Count())
//STRIP001 		{
//STRIP001 			// Der Standard-Baustein steht im ersten Teil des Pfades
//STRIP001 			String *pTmp = new String( SwGlossaries::GetDefName() );
//STRIP001 			(*pTmp) += GLOS_DELIM;
//STRIP001 			(*pTmp) += '0';
//STRIP001 			pGlosArr->Insert(pTmp, pGlosArr->Count());
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return pGlosArr;
/*N*/ }

/*------------------------------------------------------------------------
	Beschreibung: CTOR
------------------------------------------------------------------------*/


/*N*/ SwGlossaries::SwGlossaries() :
/*N*/ 	pGlosArr(0),
/*N*/ 	pPathArr(0)
/*N*/ {
/*N*/ 	pPathArr = new SvStrings;
/*N*/ 	UpdateGlosPath(sal_True);
/*N*/ }

/*------------------------------------------------------------------------
	Beschreibung: Neuen Pfad einstellen und internes Array neu aufbauen
------------------------------------------------------------------------*/

/* -----------------21.01.99 15:36-------------------
*	#61050# Doppelte Pfade fuehren zu Verwirrung - als raus damit
 * --------------------------------------------------*/
/*N*/  sal_Bool lcl_FindSameEntry(const SvStrings& rDirArr, const String& rEntryURL)
/*N*/  {
/*N*/  	sal_uInt16 nSize = rDirArr.Count();
/*N*/  	for(sal_uInt16 i = 0; i < rDirArr.Count(); i++)
/*N*/  		if(rEntryURL == (*rDirArr.GetObject(i)))
/*N*/  			return sal_True;
/*N*/  	return sal_False;
/*N*/  }
/*N*/  
/*N*/  void SwGlossaries::UpdateGlosPath(sal_Bool bFull)
/*N*/  {
/*N*/  	SvtPathOptions aPathOpt;
/*N*/  	String aNewPath( aPathOpt.GetAutoTextPath() );
/*N*/  	sal_Bool bPathChanged = aPath != aNewPath;
/*N*/  	if (bFull || bPathChanged)
/*N*/  	{
/*N*/  		aPath = aNewPath;
/*N*/  		sal_uInt16 nCount = pPathArr? pPathArr->Count() : 0;
			sal_uInt16 i;
/*N*/  		for(i = nCount; i; --i)
/*N*/  		{
/*N*/  			String *pTmp = (*pPathArr)[i - 1];
/*N*/  			pPathArr->Remove(i - 1);
/*N*/  			delete pTmp;
/*N*/  		}
/*N*/  		String sErrPath;
/*N*/  		sal_uInt16 nTokenCount = aPath.GetTokenCount(SVT_SEARCHPATH_DELIMITER);
/*N*/  		SvStrings aDirArr;
/*N*/  		for( i = 0; i < nTokenCount; i++ )
/*N*/  		{
/*N*/   			String sPth(aPath.GetToken(i, SVT_SEARCHPATH_DELIMITER));
/*N*/   			sPth = so3::StaticBaseUrl::SmartRelToAbs(sPth);
/*N*/   
/*N*/   			if(i && lcl_FindSameEntry(aDirArr, sPth))
/*N*/   			{
/*N*/   				continue;
/*N*/   			}
/*N*/   			aDirArr.Insert(new String(sPth), aDirArr.Count());
/*N*/   			if( !FStatHelper::IsFolder( sPth ) )
/*N*/   			{
/*N*/   				if( sErrPath.Len() )
/*N*/   					sErrPath += SVT_SEARCHPATH_DELIMITER;
/*N*/   				INetURLObject aTemp( sPth );
/*N*/   				sErrPath += String(aTemp.GetFull());
/*N*/   			}
/*N*/   			else
/*N*/   				pPathArr->Insert(new String(sPth), pPathArr->Count());
/*N*/  		}
/*N*/  		aDirArr.DeleteAndDestroy(0, aDirArr.Count());
/*N*/  
/*N*/  		if(!nTokenCount ||
/*N*/  			sErrPath.Len() && (bPathChanged || sOldErrPath != sErrPath) )
/*N*/  		{
/*N*/  			sOldErrPath = sErrPath;
/*N*/  			// Falscher Pfad, d.h. AutoText-Verzeichnis existiert nicht
/*N*/  
/*N*/  			ErrorHandler::HandleError( *new StringErrorInfo(
/*N*/  									ERR_AUTOPATH_ERROR, sErrPath,
/*N*/  									ERRCODE_BUTTON_OK | ERRCODE_MSG_ERROR ));
/*N*/  			bError = sal_True;
/*N*/  		}
/*N*/  		else
/*N*/  			bError = sal_False;
/*N*/  
/*N*/  		if(pGlosArr)
/*N*/  		{
/*N*/  			const sal_uInt16 nCount = pGlosArr->Count();
/*N*/  			for(sal_uInt16 i = 0; i < nCount; ++i)
/*N*/  			{
/*N*/  				delete (String *)(*pGlosArr)[i];
/*N*/  			}
/*N*/  			DELETEZ(pGlosArr);
/*N*/  			GetNameList();
/*N*/  		}
/*N*/  	}
/*N*/  }

/*------------------------------------------------------------------------
	Beschreibung:
------------------------------------------------------------------------*/

//STRIP001 
//STRIP001 void SwGlossaries::ShowError()
//STRIP001 {
//STRIP001 	sal_uInt32 nPathError = *new StringErrorInfo(ERR_AUTOPATH_ERROR,
//STRIP001 											sErrPath, ERRCODE_BUTTON_OK );
//STRIP001 	ErrorHandler::HandleError( nPathError );
//STRIP001 }
/* -----------------------------09.02.00 11:37--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/  String SwGlossaries::GetExtension()
/*N*/  {
/*N*/  	return String::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( ".bau" ));
/*N*/  }


}
