/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_pview.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:47:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/



#pragma hdrstop


// auto strip #ifndef _SV_TIMER_HXX //autogen
// auto strip #include <vcl/timer.hxx>
// auto strip #endif
// auto strip #ifndef _SV_FIELD_HXX //autogen
// auto strip #include <vcl/field.hxx>
// auto strip #endif
// auto strip #ifndef _SV_FIXED_HXX //autogen
// auto strip #include <vcl/fixed.hxx>
// auto strip #endif
// auto strip #ifndef _SV_HELP_HXX //autogen
// auto strip #include <vcl/help.hxx>
// auto strip #endif
// auto strip #ifndef _VCL_CMDEVT_HXX //autogen
// auto strip #include <vcl/cmdevt.hxx>
// auto strip #endif
// auto strip #ifndef _SV_BUTTON_HXX //autogen
// auto strip #include <vcl/button.hxx>
// auto strip #endif
// auto strip #ifndef _SV_PRINTDLG_HXX_ //autogen
// auto strip #include <svtools/printdlg.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_WHITER_HXX //autogen
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_PRINTER_HXX //autogen
// auto strip #include <bf_sfx2/printer.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_TOPFRM_HXX
// auto strip #include <bf_sfx2/topfrm.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_ZOOM_HXX
// auto strip #include <bf_svx/zoom.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_STDDLG_HXX //autogen
// auto strip #include <bf_svx/stddlg.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_PAPERINF_HXX //autogen
// auto strip #include <bf_svx/paperinf.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SRCHITEM_HXX //autogen
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDVIEW_HXX //autogen
// auto strip #include <bf_svx/svdview.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_DLGUTIL_HXX //autogen
// auto strip #include <bf_svx/dlgutil.hxx>
// auto strip #endif
#ifndef _SVX_SVXIDS_HRC //autogen
#include <bf_svx/svxids.hrc>
#endif


// auto strip #ifndef _SWWAIT_HXX
// auto strip #include <swwait.hxx>
// auto strip #endif
#ifndef _SWGLOBDOCSH_HXX //autogen
#include <globdoc.hxx>
#endif
#ifndef _SWWDOCSH_HXX //autogen
#include <wdocsh.hxx>
#endif
// auto strip #ifndef _PVPRTDAT_HXX
// auto strip #include <pvprtdat.hxx>
// auto strip #endif
// auto strip #ifndef _SWMODULE_HXX
// auto strip #include <swmodule.hxx>
// auto strip #endif
// auto strip #ifndef _MODOPT_HXX //autogen
// auto strip #include <modcfg.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
// auto strip #ifndef _DOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>
// auto strip #endif
// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif
#ifndef _PVIEW_HXX
#include <pview.hxx>
#endif
// auto strip #ifndef _VIEW_HXX
// auto strip #include <view.hxx>
// auto strip #endif
// auto strip #ifndef _TEXTSH_HXX
// auto strip #include <textsh.hxx>
// auto strip #endif
#ifndef _SCROLL_HXX
#include <scroll.hxx>
#endif
// auto strip #ifndef _SWPRTOPT_HXX
// auto strip #include <swprtopt.hxx>
// auto strip #endif
// auto strip #ifndef _DOCSTAT_HXX
// auto strip #include <docstat.hxx>
// auto strip #endif
// auto strip #ifndef _USRPREF_HXX
// auto strip #include <usrpref.hxx>
// auto strip #endif
// auto strip #ifndef _VIEWFUNC_HXX
// auto strip #include <viewfunc.hxx>
// auto strip #endif


#ifndef _HELPID_H
#include <helpid.h>
#endif
#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#ifndef _POPUP_HRC
#include <popup.hrc>
#endif
#ifndef _PVIEW_HRC
#include <pview.hrc>
#endif

#define SwPagePreView
#ifndef _ITEMDEF_HXX
#include <itemdef.hxx>
#endif

// OD 12.12.2002 #103492#
// auto strip #ifndef _PAGEPREVIEWLAYOUT_HXX
// auto strip #include <pagepreviewlayout.hxx>
// auto strip #endif
namespace binfilter {
#ifndef _SWSLOTS_HXX
#include <swslots.hxx>
#endif
/*N*/ SFX_IMPL_VIEWFACTORY(SwPagePreView, SW_RES(STR_NONAME))
/*N*/ {
/*N*/ 	SFX_VIEW_REGISTRATION(SwDocShell);
/*N*/ 	SFX_VIEW_REGISTRATION(SwWebDocShell);
/*N*/ 	SFX_VIEW_REGISTRATION(SwGlobalDocShell);
/*N*/ }

/*N*/ SFX_IMPL_INTERFACE(SwPagePreView, SfxViewShell, SW_RES(RID_PVIEW_TOOLBOX))
/*N*/ {
/*N*/ 	SFX_POPUPMENU_REGISTRATION(SW_RES(MN_PPREVIEW_POPUPMENU));
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT|SFX_VISIBILITY_STANDARD|
/*N*/ 								SFX_VISIBILITY_CLIENT|SFX_VISIBILITY_FULLSCREEN|
/*N*/ 								SFX_VISIBILITY_READONLYDOC,
/*N*/ 								SW_RES(RID_PVIEW_TOOLBOX));
/*N*/ }


/*N*/  TYPEINIT1(SwPagePreView,SfxViewShell)

#define SWVIEWFLAGS ( SFX_VIEW_MAXIMIZE_FIRST|SFX_VIEW_OPTIMIZE_EACH|  \
					  SFX_VIEW_CAN_PRINT|SFX_VIEW_HAS_PRINTOPTIONS )

#define MIN_PREVIEW_ZOOM 25
#define MAX_PREVIEW_ZOOM 600
/*  */
/* -----------------26.11.2002 10:41-----------------
 *
 * --------------------------------------------------*/
//STRIP001 USHORT lcl_GetNextZoomStep(USHORT nCurrentZoom, BOOL bZoomIn)
//STRIP001 {
//STRIP001     static USHORT aZoomArr[] =
//STRIP001     {
//STRIP001         25, 50, 75, 100, 150, 200, 400, 600
//STRIP001     };
//STRIP001     const sal_uInt16 nZoomArrSize = sizeof(aZoomArr)/sizeof(USHORT);
//STRIP001     if(bZoomIn)
//STRIP001         for(USHORT i = nZoomArrSize-1; i >= 0 ; --i)
//STRIP001         {
//STRIP001             if(nCurrentZoom > aZoomArr[i] || !i)
//STRIP001                 return aZoomArr[i];
//STRIP001         }
//STRIP001     else
//STRIP001         for(USHORT i = 0; i < nZoomArrSize; ++i)
//STRIP001         {
//STRIP001             if(nCurrentZoom < aZoomArr[i])
//STRIP001                 return aZoomArr[i];
//STRIP001         }
//STRIP001     return bZoomIn ? MAX_PREVIEW_ZOOM : MIN_PREVIEW_ZOOM;
//STRIP001 };
/* -----------------02.12.2002 09:11-----------------
 *
 * --------------------------------------------------*/
//STRIP001 void lcl_InvalidateZoomSlots(SfxBindings& rBindings)
//STRIP001 {
//STRIP001     static USHORT __READONLY_DATA aInval[] =
//STRIP001     {
//STRIP001         SID_ATTR_ZOOM, SID_ZOOM_OUT, SID_ZOOM_IN, FN_PREVIEW_ZOOM, FN_STAT_ZOOM,
//STRIP001         0
//STRIP001     };
//STRIP001     rBindings.Invalidate( aInval );
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 // erstmal der Zoom-Dialog
//STRIP001 
//STRIP001 class SwPreViewZoomDlg : public SvxStandardDialog
//STRIP001 {
//STRIP001 	FixedText		aRowLbl;
//STRIP001 	NumericField 	aRowEdit;
//STRIP001 	FixedText		aColLbl;
//STRIP001 	NumericField 	aColEdit;
//STRIP001 
//STRIP001 	OKButton	 	aOkBtn;
//STRIP001 	CancelButton 	aCancelBtn;
//STRIP001 	HelpButton 		aHelpBtn;
//STRIP001 
//STRIP001 	virtual void 	Apply();
//STRIP001 
//STRIP001 public:
//STRIP001 	SwPreViewZoomDlg( SwPagePreViewWin& rParent );
//STRIP001 	~SwPreViewZoomDlg();
//STRIP001 };
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SwPreViewZoomDlg::SwPreViewZoomDlg( SwPagePreViewWin& rParent ) :
//STRIP001 	SvxStandardDialog( &rParent, SW_RES(DLG_PAGEPREVIEW_ZOOM) ),
//STRIP001 	aColLbl(this,SW_RES(FT_COL)),
//STRIP001 	aColEdit(this,SW_RES(ED_COL)),
//STRIP001 	aRowLbl(this,SW_RES(FT_ROW)),
//STRIP001 	aRowEdit(this,SW_RES(ED_ROW)),
//STRIP001 	aOkBtn(this,SW_RES(BT_OK)),
//STRIP001 	aCancelBtn(this,SW_RES(BT_CANCEL)),
//STRIP001     aHelpBtn(this,SW_RES(BT_HELP))
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aRowEdit.SetValue( rParent.GetRow() );
//STRIP001 	aColEdit.SetValue( rParent.GetCol() );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001  SwPreViewZoomDlg::~SwPreViewZoomDlg() {}
//STRIP001 
//STRIP001 
//STRIP001 void  SwPreViewZoomDlg::Apply()
//STRIP001 {
//STRIP001 	((SwPagePreViewWin*)GetParent())->CalcWish(
//STRIP001 				BYTE(aRowEdit.GetValue()),
//STRIP001 				BYTE(aColEdit.GetValue()) );
//STRIP001 }
//STRIP001 
//STRIP001 /*  */
//STRIP001 /* -----------------20.08.98 15:25-------------------
//STRIP001  * Vorschau fuer den Seitendruck
//STRIP001  * --------------------------------------------------*/
//STRIP001 struct PrintSettingsStruct;
//STRIP001 class PrtPrvWindow : public Window
//STRIP001 {
//STRIP001 		const PrintSettingsStruct& 	rSettings;
//STRIP001 
//STRIP001 		virtual void 	Paint(const Rectangle&);
//STRIP001 public :
//STRIP001 	PrtPrvWindow(Window* pParent, const ResId& rResId, const PrintSettingsStruct& 	rSett) :
//STRIP001 		Window(pParent, rResId), rSettings(rSett){}
//STRIP001 };
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: Optionen fuer das Drucken der Preview
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 struct PrintSettingsStruct
//STRIP001 {
//STRIP001 	Size				aPageMaxSize;	// groesste Seite
//STRIP001 	Size				aPrtSize;		// Papiergroesse
//STRIP001 	Size				aPrvPrtSize;	// Groesse innerhalb der LRTB-Raender
//STRIP001 	Size 				aGridSize;		// Groesse fuer jede Seite, enthaelt je
//STRIP001 										// die Haelfte von H- und V-Distance
//STRIP001 
//STRIP001 	long 				nLeft;
//STRIP001 	long 				nRight;
//STRIP001 	long				nTop;
//STRIP001 	long 				nBottom;
//STRIP001 	long 				nHori;
//STRIP001 	long 				nVert;
//STRIP001 
//STRIP001 	USHORT 				nRows;
//STRIP001 	USHORT				nCols;
//STRIP001 
//STRIP001 	BOOL 				bPrinterLandscape;		// Ausrichtung
//STRIP001 };
//STRIP001 
//STRIP001 class SwPreviewPrintOptionsDialog : public SvxStandardDialog
//STRIP001 {
//STRIP001     FixedLine            aRowColFL;
//STRIP001 	FixedText   		aRowsFT;
//STRIP001 	NumericField 		aRowsNF;
//STRIP001 	FixedText   		aColsFT;
//STRIP001 	NumericField 		aColsNF;
//STRIP001 
//STRIP001     FixedLine            aMarginFL;
//STRIP001 	FixedText			aLSpaceFT;
//STRIP001 	MetricField 		aLSpaceMF;
//STRIP001 	FixedText   		aRSpaceFT;
//STRIP001 	MetricField 		aRSpaceMF;
//STRIP001 	FixedText   		aTSpaceFT;
//STRIP001 	MetricField 		aTSpaceMF;
//STRIP001 	FixedText   		aBSpaceFT;
//STRIP001 	MetricField 		aBSpaceMF;
//STRIP001     FixedLine            aDistanceFL;
//STRIP001 	FixedText   		aHSpaceFT;
//STRIP001 	MetricField 		aHSpaceMF;
//STRIP001 	FixedText   		aVSpaceFT;
//STRIP001 	MetricField 		aVSpaceMF;
//STRIP001 
//STRIP001 	RadioButton			aLandscapeRB;
//STRIP001 	RadioButton			aPortraitRB;
//STRIP001     FixedLine            aOrientationFL;
//STRIP001 
//STRIP001 	PrtPrvWindow 		aPreviewWin;
//STRIP001 
//STRIP001 	OKButton	 		aOkBtn;
//STRIP001 	CancelButton 		aCancelBtn;
//STRIP001 	HelpButton 			aHelpBtn;
//STRIP001 
//STRIP001 	PushButton 			aStandardPB;
//STRIP001 
//STRIP001 	SwPagePreView&		rPreView;
//STRIP001     SwPagePreViewWin&   rParentWin;
//STRIP001 	PrintSettingsStruct aSettings;
//STRIP001 /*	Size				aPageMaxSize;
//STRIP001 	Size				aPrtSize;
//STRIP001 
//STRIP001 	BOOL 				bOrientation;
//STRIP001 */
//STRIP001 	BOOL 				bStandard;
//STRIP001 
//STRIP001 	virtual void 		Apply();
//STRIP001 	void				FillControls(SwPagePreViewPrtData& rData);
//STRIP001 
//STRIP001 			DECL_LINK( ModifyHdl, Edit* );
//STRIP001 			DECL_LINK( StandardHdl, PushButton* );
//STRIP001 
//STRIP001 public:
//STRIP001 	SwPreviewPrintOptionsDialog(SwPagePreViewWin& rParent, SwPagePreView&	rView);
//STRIP001 	~SwPreviewPrintOptionsDialog();
//STRIP001 };
//STRIP001 
//STRIP001 /* -----------------19.08.98 13:35-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 SwPreviewPrintOptionsDialog::SwPreviewPrintOptionsDialog( SwPagePreViewWin& rParent, SwPagePreView&	rView ) :
//STRIP001 	SvxStandardDialog( &rParent, SW_RES(DLG_PAGEPREVIEW_PRINTOPTIONS) ),
//STRIP001     aRowColFL(this,SW_RES(  FL_ROWCOL)),
//STRIP001 	aRowsFT(this,SW_RES(	FT_ROWS)),
//STRIP001 	aRowsNF(this,SW_RES(	NF_ROWS)),
//STRIP001 	aColsFT(this,SW_RES(	FT_COLS)),
//STRIP001 	aColsNF(this,SW_RES(	NF_COLS)),
//STRIP001     aMarginFL(this,SW_RES(  FL_MARGINS)),
//STRIP001 	aLSpaceFT(this,SW_RES(	FT_LMARGIN)),
//STRIP001 	aLSpaceMF(this,SW_RES(	MF_LMARGIN)),
//STRIP001 	aRSpaceFT(this,SW_RES(	FT_RMARGIN)),
//STRIP001 	aRSpaceMF(this,SW_RES(	MF_RMARGIN)),
//STRIP001 	aTSpaceFT(this,SW_RES(	FT_TMARGIN)),
//STRIP001 	aTSpaceMF(this,SW_RES(	MF_TMARGIN)),
//STRIP001 	aBSpaceFT(this,SW_RES(	FT_BMARGIN)),
//STRIP001 	aBSpaceMF(this,SW_RES(	MF_BMARGIN)),
//STRIP001     aDistanceFL(this,SW_RES(FL_DISTANCE)),
//STRIP001 	aHSpaceFT(this,SW_RES(	FT_HMARGIN)),
//STRIP001 	aHSpaceMF(this,SW_RES(	MF_HMARGIN)),
//STRIP001 	aVSpaceFT(this,SW_RES(	FT_VMARGIN)),
//STRIP001 	aVSpaceMF(this,SW_RES(	MF_VMARGIN)),
//STRIP001     aOrientationFL(this,SW_RES( FL_ORIENTATION)),
//STRIP001 	aLandscapeRB(this,SW_RES(	RB_LANDSCAPE)),
//STRIP001 	aPortraitRB(this,SW_RES(	RB_PORTRAIT)),
//STRIP001 	aPreviewWin(this,SW_RES(	WIN_PREVIEW), aSettings),
//STRIP001 	aOkBtn(this,SW_RES(BT_OK)),
//STRIP001 	aCancelBtn(this,SW_RES(BT_CANCEL)),
//STRIP001 	aHelpBtn(this,SW_RES(BT_HELP)),
//STRIP001 	aStandardPB(this,SW_RES(PB_STANDARD)),
//STRIP001 	rPreView(rView),
//STRIP001     rParentWin(rParent),
//STRIP001 	bStandard(TRUE)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001     ViewShell& rViewSh = *rPreView.GetViewShell();
//STRIP001     // OD 18.12.2002 #103492#
//STRIP001     aSettings.aPageMaxSize = rViewSh.PagePreviewLayout()->GetMaxPageSize();
//STRIP001 	SfxPrinter*  pPrinter = rViewSh.GetPrt( TRUE );
//STRIP001 	aSettings.aPrtSize = pPrinter->GetPaperSize();
//STRIP001     //#97682# make sure that no division by zero occurs
//STRIP001     if(!aSettings.aPrtSize.Width() || !aSettings.aPrtSize.Height())
//STRIP001         aSettings.aPrtSize = Size(lA4Width, lA4Height);
//STRIP001 	aSettings.bPrinterLandscape = pPrinter->GetOrientation() == ORIENTATION_LANDSCAPE;
//STRIP001 
//STRIP001 
//STRIP001 	SwDocShell* pDocShell = rPreView.GetDocShell();
//STRIP001 	const SwMasterUsrPref *pUsrPref = SW_MOD()->GetUsrPref(0 != PTR_CAST(SwWebDocShell, pDocShell));
//STRIP001 	FieldUnit eFieldUnit = pUsrPref->GetMetric();
//STRIP001 	::SetFieldUnit( aLSpaceMF, eFieldUnit );
//STRIP001 	::SetFieldUnit( aRSpaceMF, eFieldUnit );
//STRIP001 	::SetFieldUnit( aTSpaceMF, eFieldUnit );
//STRIP001 	::SetFieldUnit( aBSpaceMF, eFieldUnit );
//STRIP001 	::SetFieldUnit( aHSpaceMF, eFieldUnit );
//STRIP001 	::SetFieldUnit( aVSpaceMF, eFieldUnit );
//STRIP001 
//STRIP001 	SwDoc* pDoc = pDocShell->GetDoc();
//STRIP001 	SwPagePreViewPrtData aData;
//STRIP001 	if(pDoc->GetPreViewPrtData())
//STRIP001 	{
//STRIP001 		aData = *pDoc->GetPreViewPrtData();
//STRIP001 		bStandard = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Orientation der PreviewData an den Drucker anpassen
//STRIP001 		aData.SetLandscape(aSettings.bPrinterLandscape);
//STRIP001         aData.SetRow(rParent.GetRow());
//STRIP001         aData.SetCol(rParent.GetCol());
//STRIP001     }
//STRIP001 	FillControls(aData);
//STRIP001 
//STRIP001 	aLSpaceMF.SaveValue();
//STRIP001 	aRSpaceMF.SaveValue();
//STRIP001 	aTSpaceMF.SaveValue();
//STRIP001 	aBSpaceMF.SaveValue();
//STRIP001 	aHSpaceMF.SaveValue();
//STRIP001 	aVSpaceMF.SaveValue();
//STRIP001 	aRowsNF.SaveValue();
//STRIP001 	aColsNF.SaveValue();
//STRIP001 	aLandscapeRB.SaveValue();
//STRIP001 	aPortraitRB.SaveValue();
//STRIP001 
//STRIP001 	aStandardPB.SetClickHdl(LINK(this, SwPreviewPrintOptionsDialog, StandardHdl));
//STRIP001 	Link aLk = LINK(this, SwPreviewPrintOptionsDialog, ModifyHdl);
//STRIP001 	aLSpaceMF.SetUpHdl(aLk);
//STRIP001 	aRSpaceMF.SetUpHdl(aLk);
//STRIP001 	aTSpaceMF.SetUpHdl(aLk);
//STRIP001 	aBSpaceMF.SetUpHdl(aLk);
//STRIP001 	aHSpaceMF.SetUpHdl(aLk);
//STRIP001 	aVSpaceMF.SetUpHdl(aLk);
//STRIP001 	aRowsNF.SetUpHdl(aLk);
//STRIP001 	aColsNF.SetUpHdl(aLk);
//STRIP001 	aLSpaceMF.SetDownHdl(aLk);
//STRIP001 	aRSpaceMF.SetDownHdl(aLk);
//STRIP001 	aTSpaceMF.SetDownHdl(aLk);
//STRIP001 	aBSpaceMF.SetDownHdl(aLk);
//STRIP001 	aHSpaceMF.SetDownHdl(aLk);
//STRIP001 	aVSpaceMF.SetDownHdl(aLk);
//STRIP001 	aRowsNF.SetDownHdl(aLk);
//STRIP001 	aColsNF.SetDownHdl(aLk);
//STRIP001 	aLSpaceMF.SetLoseFocusHdl(aLk);
//STRIP001 	aRSpaceMF.SetLoseFocusHdl(aLk);
//STRIP001 	aTSpaceMF.SetLoseFocusHdl(aLk);
//STRIP001 	aBSpaceMF.SetLoseFocusHdl(aLk);
//STRIP001 	aHSpaceMF.SetLoseFocusHdl(aLk);
//STRIP001 	aVSpaceMF.SetLoseFocusHdl(aLk);
//STRIP001 	aRowsNF.SetLoseFocusHdl(aLk);
//STRIP001 	aColsNF.SetLoseFocusHdl(aLk);
//STRIP001 	aLandscapeRB.SetClickHdl(aLk);
//STRIP001 	aPortraitRB.SetClickHdl(aLk);
//STRIP001 
//STRIP001 	ModifyHdl(0);
//STRIP001 	if(bStandard)
//STRIP001 		StandardHdl(&aStandardPB);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /* -----------------19.08.98 13:36-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 SwPreviewPrintOptionsDialog::~SwPreviewPrintOptionsDialog()
//STRIP001 {
//STRIP001 }
//STRIP001 /* -----------------12.11.98 11:32-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void	SwPreviewPrintOptionsDialog::FillControls(SwPagePreViewPrtData& rData)
//STRIP001 {
//STRIP001 	aLSpaceMF.SetValue(aLSpaceMF.Normalize(rData.GetLeftSpace()  ), FUNIT_TWIP);
//STRIP001 	aRSpaceMF.SetValue(aRSpaceMF.Normalize(rData.GetRightSpace() ), FUNIT_TWIP);
//STRIP001 	aTSpaceMF.SetValue(aTSpaceMF.Normalize(rData.GetTopSpace()   ), FUNIT_TWIP);
//STRIP001 	aBSpaceMF.SetValue(aBSpaceMF.Normalize(rData.GetBottomSpace()), FUNIT_TWIP);
//STRIP001 	aHSpaceMF.SetValue(aHSpaceMF.Normalize(rData.GetHorzSpace()  ), FUNIT_TWIP);
//STRIP001 	aVSpaceMF.SetValue(aVSpaceMF.Normalize(rData.GetVertSpace()  ), FUNIT_TWIP);
//STRIP001 	aRowsNF.SetValue(rData.GetRow());
//STRIP001 	aColsNF.SetValue(rData.GetCol());
//STRIP001 	aSettings.bPrinterLandscape ? aLandscapeRB.Check() : aPortraitRB.Check();
//STRIP001 	// wenn Drucker und Einstellungen nicht uebereinstimmen, dann Seiten tauschen
//STRIP001 	if( rData.GetLandscape() != aSettings.bPrinterLandscape )
//STRIP001 	{
//STRIP001 		Size aTmp(aSettings.aPrtSize.Height(), aSettings.aPrtSize.Width());
//STRIP001 		aSettings.aPrtSize = aTmp;
//STRIP001 		aSettings.bPrinterLandscape = !aSettings.bPrinterLandscape;
//STRIP001 		// nochmal setzen, denn auch wenn nur die Default-Orientierung dem Drucker
//STRIP001 		// angepasst wurde, sollen die Einstellungen gespeichert werden
//STRIP001 		aSettings.bPrinterLandscape ? aLandscapeRB.Check() : aPortraitRB.Check();
//STRIP001 	}
//STRIP001 	aLandscapeRB.SaveValue();
//STRIP001 	aPortraitRB.SaveValue();
//STRIP001 
//STRIP001 	aSettings.nLeft		= rData.GetLeftSpace()  ;
//STRIP001 	aSettings.nRight    = rData.GetRightSpace() ;
//STRIP001 	aSettings.nTop      = rData.GetTopSpace()   ;
//STRIP001 	aSettings.nBottom   = rData.GetBottomSpace();
//STRIP001 	aSettings.nHori     = rData.GetHorzSpace()  ;
//STRIP001 	aSettings.nVert     = rData.GetVertSpace()  ;
//STRIP001 	aSettings.nRows	    = rData.GetRow()        ;
//STRIP001 	aSettings.nCols     = rData.GetCol()        ;
//STRIP001 	aSettings.aPrvPrtSize = aSettings.aPrtSize	;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------19.08.98 14:31-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwPreviewPrintOptionsDialog::Apply()
//STRIP001 {
//STRIP001 
//STRIP001 	SwDoc* pDoc = rPreView.GetDocShell()->GetDoc();
//STRIP001 	if(bStandard)
//STRIP001 		pDoc->SetPreViewPrtData(0);
//STRIP001 	else if(	aLSpaceMF.GetSavedValue() != aLSpaceMF.GetText() ||
//STRIP001 		aRSpaceMF.GetSavedValue() != aRSpaceMF.GetText() ||
//STRIP001 		aTSpaceMF.GetSavedValue() != aTSpaceMF.GetText() ||
//STRIP001 		aBSpaceMF.GetSavedValue() != aBSpaceMF.GetText() ||
//STRIP001 		aHSpaceMF.GetSavedValue() != aHSpaceMF.GetText() ||
//STRIP001 		aVSpaceMF.GetSavedValue() != aVSpaceMF.GetText() ||
//STRIP001 		aRowsNF.GetSavedValue() != aRowsNF.GetText() ||
//STRIP001 		aColsNF.GetSavedValue() != aColsNF.GetText() ||
//STRIP001 		aLandscapeRB.GetSavedValue() != aLandscapeRB.IsChecked() ||
//STRIP001 		aPortraitRB.GetSavedValue() != aPortraitRB.IsChecked() )
//STRIP001 	{
//STRIP001 		SwPagePreViewPrtData aData;
//STRIP001 		if(pDoc->GetPreViewPrtData())
//STRIP001 			aData = *pDoc->GetPreViewPrtData();
//STRIP001 		aData.SetLeftSpace(aLSpaceMF.Denormalize(aLSpaceMF.GetValue(FUNIT_TWIP)));
//STRIP001 		aData.SetRightSpace(aRSpaceMF.Denormalize(aRSpaceMF.GetValue(FUNIT_TWIP)));
//STRIP001 		aData.SetTopSpace(aTSpaceMF.Denormalize(aTSpaceMF.GetValue(FUNIT_TWIP)));
//STRIP001 		aData.SetBottomSpace(aBSpaceMF.Denormalize(aBSpaceMF.GetValue(FUNIT_TWIP)));
//STRIP001 
//STRIP001 		aData.SetHorzSpace(aHSpaceMF.Denormalize(aHSpaceMF.GetValue(FUNIT_TWIP)));
//STRIP001 		aData.SetVertSpace(aVSpaceMF.Denormalize(aVSpaceMF.GetValue(FUNIT_TWIP)));
//STRIP001 		aData.SetRow((BYTE)aRowsNF.GetValue());
//STRIP001 		aData.SetCol((BYTE)aColsNF.GetValue());
//STRIP001 		aData.SetLandscape(aLandscapeRB.IsChecked());
//STRIP001 
//STRIP001         ViewShell& rViewSh = *rPreView.GetViewShell();
//STRIP001 		SfxPrinter*  pPrinter = rViewSh.GetPrt( TRUE );
//STRIP001 		if((pPrinter->GetOrientation() == ORIENTATION_LANDSCAPE)
//STRIP001 						!= aData.GetLandscape())
//STRIP001 					pPrinter->SetOrientation(aData.GetLandscape() ? ORIENTATION_LANDSCAPE : ORIENTATION_PORTRAIT);
//STRIP001 
//STRIP001 
//STRIP001 		pDoc->SetPreViewPrtData(&aData);
//STRIP001 
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------20.08.98 08:48-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwPreviewPrintOptionsDialog, ModifyHdl, Edit*, pEdit )
//STRIP001 {
//STRIP001 	if(bStandard && pEdit)
//STRIP001 	{
//STRIP001 		aLSpaceMF.SetUserValue(aLSpaceMF.GetValue());
//STRIP001 		aRSpaceMF.SetUserValue(aRSpaceMF.GetValue());
//STRIP001 		aTSpaceMF.SetUserValue(aTSpaceMF.GetValue());
//STRIP001 		aBSpaceMF.SetUserValue(aBSpaceMF.GetValue());
//STRIP001 		aHSpaceMF.SetUserValue(aHSpaceMF.GetValue());
//STRIP001 		aVSpaceMF.SetUserValue(aVSpaceMF.GetValue());
//STRIP001 		aRowsNF.  SetUserValue(aRowsNF  .GetValue());
//STRIP001 		aColsNF.  SetUserValue(aColsNF  .GetValue());
//STRIP001 
//STRIP001 		bStandard = FALSE;
//STRIP001 	}
//STRIP001 	BOOL bOrientChanged = aSettings.bPrinterLandscape != aLandscapeRB.IsChecked();;
//STRIP001 	if(pEdit == &aLSpaceMF)
//STRIP001 		aSettings.nLeft		= aLSpaceMF.Denormalize(aLSpaceMF.GetValue(FUNIT_TWIP));
//STRIP001 	else if(pEdit == &aRSpaceMF)
//STRIP001 		aSettings.nRight    = aRSpaceMF.Denormalize(aRSpaceMF.GetValue(FUNIT_TWIP));
//STRIP001 	else if(pEdit == &aTSpaceMF)
//STRIP001 		aSettings.nTop      = aTSpaceMF.Denormalize(aTSpaceMF.GetValue(FUNIT_TWIP));
//STRIP001 	else if(pEdit == &aBSpaceMF)
//STRIP001 		aSettings.nBottom   = aBSpaceMF.Denormalize(aBSpaceMF.GetValue(FUNIT_TWIP));
//STRIP001 	else if(pEdit == &aHSpaceMF)
//STRIP001 		aSettings.nHori     = aHSpaceMF.Denormalize(aHSpaceMF.GetValue(FUNIT_TWIP));
//STRIP001 	else if(pEdit == &aVSpaceMF)
//STRIP001 		aSettings.nVert     = aVSpaceMF.Denormalize(aVSpaceMF.GetValue(FUNIT_TWIP));
//STRIP001 	else if(pEdit == &aRowsNF)
//STRIP001 		aSettings.nRows	= (USHORT)aRowsNF.GetValue();
//STRIP001 	else if(pEdit == &aColsNF)
//STRIP001 		aSettings.nCols = (USHORT)aColsNF.GetValue();
//STRIP001 	else if(pEdit == (Edit*)&aLandscapeRB)
//STRIP001 		aSettings.bPrinterLandscape = aLandscapeRB.IsChecked();
//STRIP001 	else if(pEdit == (Edit*)&aPortraitRB)
//STRIP001 		aSettings.bPrinterLandscape = aLandscapeRB.IsChecked();
//STRIP001 
//STRIP001 	if(bOrientChanged)
//STRIP001 	{
//STRIP001 		Size aTmp(aSettings.aPrtSize.Height(), aSettings.aPrtSize.Width());
//STRIP001 		aSettings.aPrtSize = aTmp;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	aSettings.aPrvPrtSize = Size(aSettings.aPrtSize.Width()  - aSettings.nRight - aSettings.nLeft,
//STRIP001 							aSettings.aPrtSize.Height() - aSettings.nTop - aSettings.nBottom);
//STRIP001 	aSettings.aGridSize = Size(aSettings.aPrvPrtSize.Width() / aSettings.nCols,
//STRIP001 								aSettings.aPrvPrtSize.Height() / aSettings.nRows	);
//STRIP001 	// was fehlt noch: Orientation auswerten, minimalrand ausrechnen, Beispiel fuettern
//STRIP001 
//STRIP001 
//STRIP001 	//am Ende Maximalwerte setzen
//STRIP001 	long n20Percent = aSettings.aPrtSize.Width() / 5;
//STRIP001 	aLSpaceMF.SetMax(aLSpaceMF.Normalize(aSettings.aPrtSize.Width() - aSettings.nRight - n20Percent), FUNIT_TWIP);
//STRIP001 	aRSpaceMF.SetMax(aRSpaceMF.Normalize(aSettings.aPrtSize.Width() - aSettings.nLeft - n20Percent), FUNIT_TWIP);
//STRIP001 	n20Percent = aSettings.aPrtSize.Height() / 5;
//STRIP001 	aTSpaceMF.SetMax(aTSpaceMF.Normalize(aSettings.aPrtSize.Height() - aSettings.nBottom - n20Percent), FUNIT_TWIP);
//STRIP001 	aBSpaceMF.SetMax(aBSpaceMF.Normalize(aSettings.aPrtSize.Height() - aSettings.nTop - n20Percent), FUNIT_TWIP);
//STRIP001 
//STRIP001 	long n80Percent = aSettings.aPrvPrtSize.Width() * 4 / 5;
//STRIP001 	aHSpaceMF.SetMax(aHSpaceMF.Normalize(n80Percent / aSettings.nRows), FUNIT_TWIP);
//STRIP001 	n80Percent = aSettings.aPrvPrtSize.Height()* 4 / 5;
//STRIP001 	aVSpaceMF.SetMax(aVSpaceMF.Normalize(n80Percent / aSettings.nCols), FUNIT_TWIP);
//STRIP001 	aHSpaceMF.Enable(aSettings.nCols > 1);
//STRIP001 	aVSpaceMF.Enable(aSettings.nRows > 1);
//STRIP001 	aRowsNF.SetMin(1);// nur damit auch nach Standard wieder der Inhalt angezeigt wird
//STRIP001 	aColsNF.SetMin(1);
//STRIP001 
//STRIP001 
//STRIP001 	aPreviewWin.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------28.08.98 14:59-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwPreviewPrintOptionsDialog, StandardHdl, PushButton*, EMPTYARG )
//STRIP001 {
//STRIP001 	SetUpdateMode(TRUE);
//STRIP001 	SwPagePreViewPrtData aData;
//STRIP001     aData.SetRow(rParentWin.GetRow());
//STRIP001     aData.SetCol(rParentWin.GetCol());
//STRIP001     FillControls(aData);
//STRIP001 	bStandard = TRUE;
//STRIP001 	aLSpaceMF.SetText(aEmptyStr);
//STRIP001 	aRSpaceMF.SetText(aEmptyStr);
//STRIP001 	aTSpaceMF.SetText(aEmptyStr);
//STRIP001 	aBSpaceMF.SetText(aEmptyStr);
//STRIP001 	aHSpaceMF.SetText(aEmptyStr);
//STRIP001 	aVSpaceMF.SetText(aEmptyStr);
//STRIP001 	aPreviewWin.Invalidate();
//STRIP001 	SetUpdateMode(FALSE);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------20.08.98 15:28-------------------
//STRIP001  * Preview anzeigen
//STRIP001  * --------------------------------------------------*/
//STRIP001 void 	PrtPrvWindow::Paint(const Rectangle&)
//STRIP001 {
//STRIP001 		Size aWinSize(GetOutputSizePixel());
//STRIP001 		long nWidth = rSettings.aPrtSize.Width();
//STRIP001 		long nHeight = rSettings.aPrtSize.Height();
//STRIP001         BOOL bHoriValid = (aWinSize.Width() * 100 / aWinSize.Height()) <
//STRIP001 					(rSettings.aPrtSize.Width() * 100/ rSettings.aPrtSize.Height());
//STRIP001 		Fraction aXScale( aWinSize.Width(), Max( nWidth , 1L ) );
//STRIP001 		Fraction aYScale( aWinSize.Height(), Max( nHeight, 1L ) );
//STRIP001 		MapMode aMapMode( GetMapMode() );
//STRIP001 		aMapMode.SetScaleX( bHoriValid ? aXScale : aYScale);
//STRIP001 		aMapMode.SetScaleY( bHoriValid ? aXScale : aYScale);
//STRIP001 		SetMapMode( aMapMode );
//STRIP001 
//STRIP001 		aWinSize = GetOutputSize();
//STRIP001 
//STRIP001 		Point aOffset(0,0);
//STRIP001 		if(bHoriValid)
//STRIP001 			aOffset.Y() = (aWinSize.Height() - rSettings.aPrtSize.Height()) / 2;
//STRIP001 		else
//STRIP001 			aOffset.X() = (aWinSize.Width() - rSettings.aPrtSize.Width()) / 2;;
//STRIP001 
//STRIP001 
//STRIP001         BOOL bUseSystemColors = SvtAccessibilityOptions().GetIsForPagePreviews()
//STRIP001                                 && GetSettings().GetStyleSettings().GetHighContrastMode();
//STRIP001 
//STRIP001 		//der weisse Seitenhintergrund
//STRIP001 		Rectangle aRect(aOffset, rSettings.aPrtSize);
//STRIP001         if(bUseSystemColors)
//STRIP001         {
//STRIP001             SetFillColor( GetSettings().GetStyleSettings().GetWindowColor() );
//STRIP001             SetLineColor( SwViewOption::GetFontColor() );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             SetFillColor( Color( COL_WHITE ) );
//STRIP001             SetLineColor(Color( COL_BLACK ) );
//STRIP001         }
//STRIP001 
//STRIP001 		DrawRect(aRect);
//STRIP001 
//STRIP001 		Point aTL(aOffset);
//STRIP001 		aTL.X() += rSettings.nLeft;
//STRIP001 		aTL.Y() += rSettings.nTop;
//STRIP001 
//STRIP001 		Size aPrvPageSize((rSettings.aPrvPrtSize.Width() - (rSettings.nCols - 1) * rSettings.nHori) / rSettings.nCols,
//STRIP001 			(rSettings.aPrvPrtSize.Height() - (rSettings.nRows - 1) * rSettings.nVert) / rSettings.nRows);
//STRIP001 		// jetzt muss noch das unterschiedliche Groessenverhaeltnis berechnet werden, um es an
//STRIP001 		// der richtigen Seite abzuziehen.
//STRIP001 		//...
//STRIP001 		long nSourceScale = rSettings.aPageMaxSize.Width() * 100 / rSettings.aPageMaxSize.Height();
//STRIP001 		long nDestScale = aPrvPageSize.Width() * 100  / aPrvPageSize.Height() ;
//STRIP001 		if(nSourceScale > nDestScale) // die Seite ist relativ breiter als das vorhandene Rechteck
//STRIP001 		{
//STRIP001 			aPrvPageSize.Height() = aPrvPageSize.Width() * 100 / nSourceScale;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aPrvPageSize.Width() = aPrvPageSize.Height() * nSourceScale / 100;
//STRIP001 		}
//STRIP001 
//STRIP001         if(bUseSystemColors)
//STRIP001             SetFillColor( GetSettings().GetStyleSettings().GetWindowColor() );
//STRIP001         else
//STRIP001             SetFillColor( Color( COL_GRAY ) );
//STRIP001 
//STRIP001 
//STRIP001 		aRect = Rectangle(aTL, aPrvPageSize);
//STRIP001 		for(USHORT i = 0; i < rSettings.nRows; i++)
//STRIP001 		{
//STRIP001 			for(USHORT j = 0; j < rSettings.nCols; j++)
//STRIP001 			{
//STRIP001 				DrawRect(aRect);
//STRIP001 				aRect.Move(aPrvPageSize.Width() + rSettings.nHori, 0);
//STRIP001 			}
//STRIP001 
//STRIP001 			aRect.Move( 0, aPrvPageSize.Height() + rSettings.nVert);
//STRIP001 			aRect.SetPos(Point(aTL.X(), aRect.TopLeft().Y()));
//STRIP001 		}
//STRIP001 	//rSettings;
//STRIP001 }
//STRIP001 
//STRIP001 /*  */
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 // alles fuers SwPagePreViewWin
//STRIP001 
//STRIP001 
/*N*/ SwPagePreViewWin::SwPagePreViewWin( Window *pParent, SwPagePreView& rPView )
/*N*/ 	: Window( pParent, WinBits( WB_CLIPCHILDREN) ),
/*N*/     mpViewShell( 0 ),
/*N*/     mrView( rPView ),
/*N*/     mbCalcScaleForPreviewLayout( true ),
/*N*/     maPaintedPreviewDocRect( Rectangle(0,0,0,0) )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SetOutDevViewType( OUTDEV_VIEWTYPE_PRINTPREVIEW ); //#106611#
//STRIP001 	SetHelpId(HID_PAGEPREVIEW);
//STRIP001 	SetFillColor( GetBackground().GetColor() );
//STRIP001 	SetLineColor( GetBackground().GetColor());
//STRIP001 	SetMapMode( MapMode(MAP_TWIP) );
//STRIP001 
//STRIP001 	const SwMasterUsrPref *pUsrPref = SW_MOD()->GetUsrPref(FALSE);
//STRIP001     mnRow = pUsrPref->GetPagePrevRow();     // 1 Zeile
//STRIP001     mnCol = pUsrPref->GetPagePrevCol();     // 1 Spalte
//STRIP001     // OD 24.03.2003 #108282# - member <mnVirtPage> no longer exists.
//STRIP001     mnSttPage = USHRT_MAX;
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


/*N*/ SwPagePreViewWin::~SwPagePreViewWin()
/*N*/ {
/*N*/     if( mpViewShell )
/*N*/         delete mpViewShell;
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


//STRIP001 void  SwPagePreViewWin::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001     if( !mpViewShell || !mpViewShell->GetLayout() )
//STRIP001 		return;
//STRIP001 
//STRIP001     USHORT nRowCol = ( mnRow << 8 ) + mnCol;
//STRIP001     if( USHRT_MAX == mnSttPage )        // wurde noch nie berechnet ? (Init-Phase!)
//STRIP001 	{
//STRIP001 		// das ist die Size, auf die ich mich immer beziehe
//STRIP001         if( !maPxWinSize.Height() || !maPxWinSize.Width() )
//STRIP001             maPxWinSize = GetOutputSizePixel();
//STRIP001 
//STRIP001 		Rectangle aRect( LogicToPixel( rRect ));
//STRIP001         mpPgPrevwLayout->Prepare( 1, Point(0,0), maPxWinSize,
//STRIP001                                   mnSttPage, maPaintedPreviewDocRect );
//STRIP001         SetSelectedPage( 1 );
//STRIP001         mpPgPrevwLayout->Paint( PixelToLogic( aRect ) );
//STRIP001         SetPagePreview(mnRow, mnCol);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         MapMode aMM( GetMapMode() );
//STRIP001         aMM.SetScaleX( maScale );
//STRIP001         aMM.SetScaleY( maScale );
//STRIP001 		SetMapMode( aMM );
//STRIP001         mpPgPrevwLayout->Paint( rRect );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 void SwPagePreViewWin::CalcWish( BYTE nNewRow, BYTE nNewCol )
//STRIP001 {
//STRIP001     if( !mpViewShell || !mpViewShell->GetLayout() )
//STRIP001 		return;
//STRIP001 
//STRIP001     USHORT nOldCol = mnCol;
//STRIP001     // OD 02.12.2002 #103492# - update <mnRow> and <mnCol>.
//STRIP001     mnRow = nNewRow;
//STRIP001     mnCol = nNewCol;
//STRIP001     USHORT nPages = mnRow * mnCol,
//STRIP001            nLastSttPg = mrView.GetPageCount()+1 > nPages
//STRIP001                             ? mrView.GetPageCount()+1 - nPages : 0;
//STRIP001     if( mnSttPage > nLastSttPg )
//STRIP001         mnSttPage = nLastSttPg;
//STRIP001 
//STRIP001     mpPgPrevwLayout->Init( mnCol, mnRow, maPxWinSize, true );
//STRIP001     mpPgPrevwLayout->Prepare( mnSttPage, Point(0,0), maPxWinSize,
//STRIP001                               mnSttPage, maPaintedPreviewDocRect );
//STRIP001     SetSelectedPage( mnSttPage );
//STRIP001     SetPagePreview(mnRow, mnCol);
//STRIP001     maScale = GetMapMode().GetScaleX();
//STRIP001 
//STRIP001 	// falls an der Spaltigkeit gedreht wurde, so muss der Sonderfall
//STRIP001 	// Einspaltig beachtet und ggfs. der Scrollbar korrigiert werden
//STRIP001     if( (1 == nOldCol) ^ (1 == mnCol) )
//STRIP001         mrView.ScrollDocSzChg();
//STRIP001 
//STRIP001 	// Sortierung muss eingehalten werden!!
//STRIP001     // OD 24.03.2003 #108282# - additional invalidate page status.
//STRIP001 	static USHORT __READONLY_DATA aInval[] =
//STRIP001 	{
//STRIP001         SID_ATTR_ZOOM, SID_ZOOM_OUT, SID_ZOOM_IN,
//STRIP001         FN_PREVIEW_ZOOM,
//STRIP001         FN_START_OF_DOCUMENT, FN_END_OF_DOCUMENT, FN_PAGEUP, FN_PAGEDOWN,
//STRIP001         FN_STAT_PAGE, FN_STAT_ZOOM,
//STRIP001         FN_SHOW_TWO_PAGES, FN_SHOW_MULTIPLE_PAGES,
//STRIP001 		0
//STRIP001 	};
//STRIP001     SfxBindings& rBindings = mrView.GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( aInval );
//STRIP001 	rBindings.Update( FN_SHOW_TWO_PAGES );
//STRIP001     rBindings.Update( FN_SHOW_MULTIPLE_PAGES );
//STRIP001     // OD 18.12.2002 #103492# - adjust scrollbars
//STRIP001     mrView.ScrollViewSzChg();
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 int SwPagePreViewWin::MovePage( int eMoveMode )
//STRIP001 {
//STRIP001 	// soviele Seiten hoch
//STRIP001     USHORT nPages = mnRow * mnCol;
//STRIP001     USHORT nNewSttPage = mnSttPage;
//STRIP001     // OD 04.12.2002 #103492#
//STRIP001     USHORT nPageCount = mrView.GetPageCount();
//STRIP001 	USHORT nDefSttPg = GetDefSttPage();
//STRIP001     // OD 06.12.2002 #103492#
//STRIP001     bool bPaintPageAtFirstCol = true;
//STRIP001 
//STRIP001 	switch( eMoveMode )
//STRIP001 	{
//STRIP001     case MV_PAGE_UP:
//STRIP001         // OD 03.12.2002 #103492# - correct calculation of new start page.
//STRIP001         nNewSttPage = (mnSttPage - nPages > 0) ? (mnSttPage - nPages) : nDefSttPg;
//STRIP001         // OD 13.12.2002 #103492# - correct calculation of new selected page.
//STRIP001         if ( (SelectedPage() - nPages) > 0 )
//STRIP001             SetSelectedPage( SelectedPage() - nPages );
//STRIP001         else
//STRIP001             SetSelectedPage( 1 );
//STRIP001         break;
//STRIP001     case MV_PAGE_DOWN:
//STRIP001         // OD 03.12.2002 #103492# - correct calculation of new start page.
//STRIP001         nNewSttPage = (mnSttPage + nPages) < nPageCount ? (mnSttPage + nPages) : nPageCount;
//STRIP001         // OD 03.12.2002 #103492# - correct calculation of new selected page.
//STRIP001         if ( (SelectedPage() + nPages) < nPageCount )
//STRIP001             SetSelectedPage( SelectedPage() + nPages );
//STRIP001         else
//STRIP001             SetSelectedPage( nPageCount );
//STRIP001         break;
//STRIP001     case MV_DOC_STT:
//STRIP001         nNewSttPage = nDefSttPg;
//STRIP001         SetSelectedPage( nNewSttPage ? nNewSttPage : 1 );
//STRIP001         break;
//STRIP001     case MV_DOC_END:
//STRIP001         // OD 03.12.2002 #103492# - correct calculation of new start page.
//STRIP001         nNewSttPage = nPageCount;
//STRIP001         SetSelectedPage( nPageCount );
//STRIP001         break;
//STRIP001     // OD 12.12.2002 #103492# - add new move mode
//STRIP001     case MV_SELPAGE:
//STRIP001         // <nNewSttPage> and <SelectedPage()> are already set.
//STRIP001         // OD 20.02.2003 #107369# - not start at first column, only if the
//STRIP001         // complete preview layout columns doesn't fit into window.
//STRIP001         if ( !mpPgPrevwLayout->DoesPreviewLayoutColsFitIntoWindow() )
//STRIP001             bPaintPageAtFirstCol = false;
//STRIP001         break;
//STRIP001     case MV_SCROLL:
//STRIP001         // OD 17.01.2003 #103492# - check, if paint page at first column
//STRIP001         // has to be avoided
//STRIP001         if ( !mpPgPrevwLayout->DoesPreviewLayoutRowsFitIntoWindow() ||
//STRIP001              !mpPgPrevwLayout->DoesPreviewLayoutColsFitIntoWindow() )
//STRIP001             bPaintPageAtFirstCol = false;
//STRIP001         break;
//STRIP001     case MV_NEWWINSIZE:
//STRIP001         // OD 18.12.2002 #103492# - nothing special to do.
//STRIP001         break;
//STRIP001     case MV_CALC:
//STRIP001         // OD 18.12.2002 #103492# - re-init page preview layout.
//STRIP001         mpPgPrevwLayout->ReInit();
//STRIP001 
//STRIP001         // OD 03.12.2002 #103492# - correct calculation of new start page.
//STRIP001         if( nNewSttPage > nPageCount )
//STRIP001             nNewSttPage = nPageCount;
//STRIP001 
//STRIP001         // OD 18.12.2002 #103492# - correct selected page number
//STRIP001         if( SelectedPage() > nPageCount )
//STRIP001             SetSelectedPage( nNewSttPage ? nNewSttPage : 1 );
//STRIP001 	}
//STRIP001 
//STRIP001     mpPgPrevwLayout->Prepare( nNewSttPage, Point(0,0), maPxWinSize,
//STRIP001                               nNewSttPage,
//STRIP001                               maPaintedPreviewDocRect, bPaintPageAtFirstCol );
//STRIP001     if( nNewSttPage == mnSttPage &&
//STRIP001         eMoveMode != MV_SELPAGE )
//STRIP001         return FALSE;
//STRIP001 
//STRIP001     SetPagePreview(mnRow, mnCol);
//STRIP001     mnSttPage = nNewSttPage;
//STRIP001 
//STRIP001     // OD 24.03.2003 #108282# - additional invalidate page status.
//STRIP001 	static USHORT __READONLY_DATA aInval[] =
//STRIP001 	{
//STRIP001         FN_START_OF_DOCUMENT, FN_END_OF_DOCUMENT, FN_PAGEUP, FN_PAGEDOWN,
//STRIP001         FN_STAT_PAGE, 0
//STRIP001 	};
//STRIP001 
//STRIP001     SfxBindings& rBindings = mrView.GetViewFrame()->GetBindings();
//STRIP001 	rBindings.Invalidate( aInval );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreViewWin::SetWinSize( const Size& rNewSize )
//STRIP001 {
//STRIP001 	// die Size wollen wir aber immer in Pixel-Einheiten haben
//STRIP001     maPxWinSize = LogicToPixel( rNewSize );
//STRIP001     USHORT nRowCol = ( mnRow << 8 ) + mnCol; // Zeilen / DoppelSeiten
//STRIP001 
//STRIP001     if( USHRT_MAX == mnSttPage )
//STRIP001     {
//STRIP001         mnSttPage = GetDefSttPage();
//STRIP001         SetSelectedPage( GetDefSttPage() );
//STRIP001     }
//STRIP001 
//STRIP001     if ( mbCalcScaleForPreviewLayout )
//STRIP001     {
//STRIP001         mpPgPrevwLayout->Init( mnCol, mnRow, maPxWinSize, true );
//STRIP001         maScale = GetMapMode().GetScaleX();
//STRIP001     }
//STRIP001     mpPgPrevwLayout->Prepare( mnSttPage, Point(0,0), maPxWinSize,
//STRIP001                               mnSttPage, maPaintedPreviewDocRect );
//STRIP001     if ( mbCalcScaleForPreviewLayout )
//STRIP001     {
//STRIP001         SetSelectedPage( mnSttPage );
//STRIP001         mbCalcScaleForPreviewLayout = false;
//STRIP001     }
//STRIP001     SetPagePreview(mnRow, mnCol);
//STRIP001     maScale = GetMapMode().GetScaleX();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreViewWin::GetStatusStr( String& rStr, USHORT nPageCnt ) const
//STRIP001 {
//STRIP001     // OD 24.03.2003 #108282# - show physical and virtual page number of
//STRIP001     // selected page, if it's visible.
//STRIP001     sal_uInt16 nPageNum;
//STRIP001     if ( mpPgPrevwLayout->IsPageVisible( mpPgPrevwLayout->SelectedPage() ) )
//STRIP001     {
//STRIP001         nPageNum = mpPgPrevwLayout->SelectedPage();
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         nPageNum = mnSttPage > 1 ? mnSttPage : 1;
//STRIP001     }
//STRIP001     sal_uInt16 nVirtPageNum = mpPgPrevwLayout->GetVirtPageNumByPageNum( nPageNum );
//STRIP001     if( nVirtPageNum && nVirtPageNum != nPageNum )
//STRIP001 	{
//STRIP001         rStr += String::CreateFromInt32( nVirtPageNum );
//STRIP001 		rStr += ' ';
//STRIP001 	}
//STRIP001     rStr += String::CreateFromInt32( nPageNum );
//STRIP001 	rStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM(" / "));
//STRIP001 	rStr += String::CreateFromInt32( nPageCnt );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  SwPagePreViewWin::KeyInput( const KeyEvent &rKEvt )
//STRIP001 {
//STRIP001     const KeyCode& rKeyCode = rKEvt.GetKeyCode();
//STRIP001     USHORT nKey = rKeyCode.GetCode();
//STRIP001     BOOL bHandled = FALSE;
//STRIP001     if(!rKeyCode.GetModifier())
//STRIP001     {
//STRIP001         USHORT nSlot = 0;
//STRIP001         switch(nKey)
//STRIP001         {
//STRIP001             case KEY_ADD : nSlot = SID_ZOOM_OUT;         break;
//STRIP001             case KEY_SUBTRACT : nSlot = SID_ZOOM_IN;    break;
//STRIP001         }
//STRIP001         if(nSlot)
//STRIP001         {
//STRIP001             bHandled = TRUE;
//STRIP001             mrView.GetViewFrame()->GetDispatcher()->Execute(
//STRIP001                                 nSlot, SFX_CALLMODE_ASYNCHRON );
//STRIP001         }
//STRIP001     }
//STRIP001     if( !bHandled && !mrView.KeyInput( rKEvt ) )
//STRIP001 		Window::KeyInput( rKEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /******************************************************************************
//STRIP001  *	Beschreibung:
//STRIP001  ******************************************************************************/
//STRIP001 
//STRIP001 void SwPagePreViewWin::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	BOOL bCallBase = TRUE;
//STRIP001 	switch( rCEvt.GetCommand() )
//STRIP001 	{
//STRIP001 	case COMMAND_CONTEXTMENU:
//STRIP001         mrView.GetViewFrame()->GetDispatcher()->ExecutePopup();
//STRIP001 		bCallBase = FALSE;
//STRIP001 		break;
//STRIP001 
//STRIP001 	case COMMAND_WHEEL:
//STRIP001 	case COMMAND_STARTAUTOSCROLL:
//STRIP001 	case COMMAND_AUTOSCROLL:
//STRIP001         bCallBase = !mrView.HandleWheelCommands( rCEvt );
//STRIP001 		break;
//STRIP001 
//STRIP001     default:
//STRIP001         // OD 17.12.2002 #103492# - delete assertion
//STRIP001         ;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bCallBase )
//STRIP001 		Window::Command( rCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 void SwPagePreViewWin::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     // OD 17.12.2002 #103492# - consider single-click to set selected page
//STRIP001     if( MOUSE_LEFT == ( rMEvt.GetModifier() + rMEvt.GetButtons() ) )
//STRIP001 	{
//STRIP001         Point aPrevwPos( PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001         Point aDocPos;
//STRIP001         bool bPosInEmptyPage;
//STRIP001         sal_uInt16 nNewSelectedPage;
//STRIP001         bool bIsDocPos =
//STRIP001             mpPgPrevwLayout->IsPrevwPosInDocPrevwPage( aPrevwPos,
//STRIP001                                     aDocPos, bPosInEmptyPage, nNewSelectedPage );
//STRIP001         if ( bIsDocPos && rMEvt.GetClicks() == 2 )
//STRIP001         {
//STRIP001             // close page preview, set new cursor position and switch to
//STRIP001             // normal view.
//STRIP001             String sNewCrsrPos( String::CreateFromInt32( aDocPos.X() ));
//STRIP001             ((( sNewCrsrPos += ';' )
//STRIP001                             += String::CreateFromInt32( aDocPos.Y() )) )
//STRIP001                             += ';';
//STRIP001             mrView.SetNewCrsrPos( sNewCrsrPos );
//STRIP001 
//STRIP001             SfxViewFrame *pTmpFrm = mrView.GetViewFrame();
//STRIP001             pTmpFrm->GetBindings().Execute( SID_VIEWSHELL0, NULL, 0,
//STRIP001                                                     SFX_CALLMODE_ASYNCHRON );
//STRIP001         }
//STRIP001         else if ( bIsDocPos || bPosInEmptyPage )
//STRIP001             // show clicked page as the selected one
//STRIP001             mpPgPrevwLayout->MarkNewSelectedPage( nNewSelectedPage );
//STRIP001             GetViewShell()->ShowPreViewSelection( nNewSelectedPage );
//STRIP001             // OD 19.02.2003 #107369# - adjust position at vertical scrollbar.
//STRIP001             if ( mpPgPrevwLayout->DoesPreviewLayoutRowsFitIntoWindow() )
//STRIP001             {
//STRIP001                 mrView.SetVScrollbarThumbPos( nNewSelectedPage );
//STRIP001             }
//STRIP001             // OD 24.03.2003 #108282# - invalidate page status.
//STRIP001             static USHORT __READONLY_DATA aInval[] =
//STRIP001             {
//STRIP001                 FN_STAT_PAGE, 0
//STRIP001             };
//STRIP001             SfxBindings& rBindings = mrView.GetViewFrame()->GetBindings();
//STRIP001             rBindings.Invalidate( aInval );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /******************************************************************************
//STRIP001  *	Beschreibung: Userprefs bzw Viewoptions setzen
//STRIP001  ******************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreViewWin::SetPagePreview( BYTE nRow, BYTE nCol )
//STRIP001 {
//STRIP001 	SwMasterUsrPref *pOpt = (SwMasterUsrPref *)SW_MOD()->GetUsrPref(FALSE);
//STRIP001 
//STRIP001 	if (nRow != pOpt->GetPagePrevRow() || nCol != pOpt->GetPagePrevCol())
//STRIP001 	{
//STRIP001 		pOpt->SetPagePrevRow( nRow );
//STRIP001 		pOpt->SetPagePrevCol( nCol );
//STRIP001 		pOpt->SetModified();
//STRIP001 
//STRIP001         //Scrollbar updaten!
//STRIP001         mrView.ScrollViewSzChg();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /** get selected page in document preview
//STRIP001 
//STRIP001     OD 13.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 sal_uInt16 SwPagePreViewWin::SelectedPage() const
//STRIP001 {
//STRIP001     return mpPgPrevwLayout->SelectedPage();
//STRIP001 }
//STRIP001 
//STRIP001 /** set selected page number in document preview
//STRIP001 
//STRIP001     OD 13.12.2002 #103492#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreViewWin::SetSelectedPage( sal_uInt16 _nSelectedPageNum )
//STRIP001 {
//STRIP001     mpPgPrevwLayout->SetSelectedPage( _nSelectedPageNum );
//STRIP001 }
//STRIP001 
//STRIP001 void SwPagePreViewWin::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	switch( rDCEvt.GetType() )
//STRIP001 	{
//STRIP001 	case DATACHANGED_SETTINGS:
//STRIP001 		// ScrollBars neu anordnen bzw. Resize ausloesen, da sich
//STRIP001 		// ScrollBar-Groesse geaendert haben kann. Dazu muss dann im
//STRIP001 		// Resize-Handler aber auch die Groesse der ScrollBars aus
//STRIP001 		// den Settings abgefragt werden.
//STRIP001 		if( rDCEvt.GetFlags() & SETTINGS_STYLE )
//STRIP001             mrView.InvalidateBorder();              //Scrollbarbreiten
//STRIP001         //#106746# zoom has to be disabled if Accessibility support is switched on
//STRIP001         lcl_InvalidateZoomSlots(mrView.GetViewFrame()->GetBindings());
//STRIP001         break;
//STRIP001 
//STRIP001 	case DATACHANGED_PRINTER:
//STRIP001 	case DATACHANGED_DISPLAY:
//STRIP001 	case DATACHANGED_FONTS:
//STRIP001 	case DATACHANGED_FONTSUBSTITUTION:
//STRIP001         mrView.GetDocShell()->UpdateFontList(); //Fontwechsel
//STRIP001         if ( mpViewShell->GetWin() )
//STRIP001             mpViewShell->GetWin()->Invalidate();
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /** help method to execute SfxRequest FN_PAGEUP and FN_PAGEDOWN
//STRIP001 
//STRIP001     OD 04.03.2003 #107369#
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreView::_ExecPgUpAndPgDown( const bool  _bPgUp,
//STRIP001                                         SfxRequest* _pReq )
//STRIP001 {
//STRIP001     SwPagePreviewLayout* pPagePrevwLay = GetViewShell()->PagePreviewLayout();
//STRIP001     // check, if top/bottom of preview is *not* already visible.
//STRIP001     if( pPagePrevwLay->GetWinPagesScrollAmount( _bPgUp ? -1 : 1 ) != 0 )
//STRIP001     {
//STRIP001         if ( pPagePrevwLay->DoesPreviewLayoutRowsFitIntoWindow() &&
//STRIP001              pPagePrevwLay->DoesPreviewLayoutColsFitIntoWindow() )
//STRIP001         {
//STRIP001             const int eMvMode = _bPgUp ?
//STRIP001                                 SwPagePreViewWin::MV_PAGE_UP :
//STRIP001                                 SwPagePreViewWin::MV_PAGE_DOWN;
//STRIP001             if ( ChgPage( eMvMode, TRUE ) )
//STRIP001                 aViewWin.Invalidate();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             SwTwips nScrollAmount;
//STRIP001             sal_uInt16 nNewSelectedPageNum = 0;
//STRIP001             const sal_uInt16 nVisPages = aViewWin.GetRow() * aViewWin.GetCol();
//STRIP001             if( _bPgUp )
//STRIP001             {
//STRIP001                 if ( pPagePrevwLay->DoesPreviewLayoutRowsFitIntoWindow() )
//STRIP001                 {
//STRIP001                     nScrollAmount = pPagePrevwLay->GetWinPagesScrollAmount( -1 );
//STRIP001                     if ( (aViewWin.SelectedPage() - nVisPages) > 0 )
//STRIP001                         nNewSelectedPageNum = aViewWin.SelectedPage() - nVisPages;
//STRIP001                     else
//STRIP001                         nNewSelectedPageNum = 1;
//STRIP001                 }
//STRIP001                 else
//STRIP001                     nScrollAmount = - Min( aViewWin.GetOutputSize().Height(),
//STRIP001                                            aViewWin.GetPaintedPreviewDocRect().Top() );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 if ( pPagePrevwLay->DoesPreviewLayoutRowsFitIntoWindow() )
//STRIP001                 {
//STRIP001                     nScrollAmount = pPagePrevwLay->GetWinPagesScrollAmount( 1 );
//STRIP001                     if ( (aViewWin.SelectedPage() + nVisPages) <= mnPageCount )
//STRIP001                         nNewSelectedPageNum = aViewWin.SelectedPage() + nVisPages;
//STRIP001                     else
//STRIP001                         nNewSelectedPageNum = mnPageCount;
//STRIP001                 }
//STRIP001                 else
//STRIP001                     nScrollAmount = Min( aViewWin.GetOutputSize().Height(),
//STRIP001                                          ( pPagePrevwLay->GetPrevwDocSize().Height() -
//STRIP001                                            aViewWin.GetPaintedPreviewDocRect().Bottom() ) );
//STRIP001             }
//STRIP001             aViewWin.Scroll( 0, nScrollAmount );
//STRIP001             if ( nNewSelectedPageNum != 0 )
//STRIP001             {
//STRIP001                 aViewWin.SetSelectedPage( nNewSelectedPageNum );
//STRIP001             }
//STRIP001             ScrollViewSzChg();
//STRIP001 			// OD 24.03.2003 #108282# - additional invalidate page status.
//STRIP001             static USHORT __READONLY_DATA aInval[] =
//STRIP001             {
//STRIP001                 FN_START_OF_DOCUMENT, FN_END_OF_DOCUMENT, FN_PAGEUP, FN_PAGEDOWN,
//STRIP001 				FN_STAT_PAGE, 0
//STRIP001             };
//STRIP001             SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001             rBindings.Invalidate( aInval );
//STRIP001             aViewWin.Invalidate();
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     if ( _pReq )
//STRIP001         _pReq->Done();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 // dann mal alles fuer die SwPagePreView
//STRIP001 void  SwPagePreView::Execute( SfxRequest &rReq )
//STRIP001 {
//STRIP001 	int eMvMode;
//STRIP001 	BYTE nRow = 1;
//STRIP001     BOOL bRetVal = FALSE;
//STRIP001     bool bRefresh = true;
//STRIP001 
//STRIP001     USHORT  nSttPage = aViewWin.GetSttPage(),
//STRIP001 			nPages = aViewWin.GetRow() * aViewWin.GetCol(),
//STRIP001 			nLineSz = aViewWin.GetCol(),
//STRIP001             // OD 04.12.2002 #103492#
//STRIP001             //nLastSttPg = nPageCount+1 > nPages ? nPageCount+1 - nPages : 0,
//STRIP001             nLastSttPg = mnPageCount,
//STRIP001 			nDefSttPg = aViewWin.GetDefSttPage();
//STRIP001 
//STRIP001 	switch(rReq.GetSlot())
//STRIP001 	{
//STRIP001 		case FN_REFRESH_VIEW:
//STRIP001 		case FN_STAT_PAGE:
//STRIP001 		case FN_STAT_ZOOM:
//STRIP001 			break;
//STRIP001 
//STRIP001         case FN_SHOW_MULTIPLE_PAGES:
//STRIP001         {
//STRIP001             const SfxItemSet *pArgs = rReq.GetArgs();
//STRIP001             if( pArgs && pArgs->Count() >= 2 )
//STRIP001             {
//STRIP001                 BYTE nCols = (BYTE)((SfxUInt16Item &)pArgs->Get(
//STRIP001                                         SID_ATTR_TABLE_COLUMN)).GetValue();
//STRIP001                 BYTE nRows = (BYTE)((SfxUInt16Item &)pArgs->Get(
//STRIP001                                         SID_ATTR_TABLE_ROW)).GetValue();
//STRIP001                 aViewWin.CalcWish( nRows, nCols );
//STRIP001 
//STRIP001             }
//STRIP001             else
//STRIP001                 SwPreViewZoomDlg( aViewWin ).Execute();
//STRIP001 
//STRIP001         }
//STRIP001 		break;
//STRIP001         case FN_SHOW_TWO_PAGES:
//STRIP001 			aViewWin.CalcWish( nRow, 2 );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FN_PREVIEW_ZOOM:
//STRIP001 		case SID_ATTR_ZOOM:
//STRIP001 		{
//STRIP001 			const SfxItemSet *pArgs = rReq.GetArgs();
//STRIP001             const SfxPoolItem* pItem;
//STRIP001             SvxZoomDialog* pDlg = 0;
//STRIP001             if(!pArgs)
//STRIP001             {
//STRIP001                 SfxItemSet aCoreSet(GetPool(), SID_ATTR_ZOOM, SID_ATTR_ZOOM);
//STRIP001                 const SwViewOption* pVOpt = GetViewShell()->GetViewOptions();
//STRIP001                 SvxZoomItem aZoom( (SvxZoomType)pVOpt->GetZoomType(),
//STRIP001                                             pVOpt->GetZoom() );
//STRIP001                 aZoom.SetValueSet(
//STRIP001                         SVX_ZOOM_ENABLE_50|
//STRIP001                         SVX_ZOOM_ENABLE_75|
//STRIP001                         SVX_ZOOM_ENABLE_100|
//STRIP001                         SVX_ZOOM_ENABLE_150|
//STRIP001                         SVX_ZOOM_ENABLE_200|
//STRIP001                         SVX_ZOOM_ENABLE_WHOLEPAGE);
//STRIP001                 aCoreSet.Put( aZoom );
//STRIP001 
//STRIP001 				pDlg = new SvxZoomDialog( &GetViewFrame()->GetWindow(), aCoreSet );
//STRIP001                 pDlg->SetLimits( MINZOOM, MAXZOOM );
//STRIP001 
//STRIP001                 if( pDlg->Execute() != RET_CANCEL )
//STRIP001                     pArgs = pDlg->GetOutputItemSet();
//STRIP001             }
//STRIP001             if( pArgs )
//STRIP001             {
//STRIP001                 enum SvxZoomType eType = SVX_ZOOM_PERCENT;
//STRIP001                 USHORT nZoomFactor = USHRT_MAX;
//STRIP001                 if(SFX_ITEM_SET == pArgs->GetItemState(SID_ATTR_ZOOM, TRUE, &pItem))
//STRIP001                 {
//STRIP001                     eType = ((const SvxZoomItem *)pItem)->GetType();
//STRIP001                     nZoomFactor = ((const SvxZoomItem *)pItem)->GetValue();
//STRIP001                 }
//STRIP001                 else if(SFX_ITEM_SET == pArgs->GetItemState(FN_PREVIEW_ZOOM, TRUE, &pItem))
//STRIP001                     nZoomFactor = ((const SfxUInt16Item *)pItem)->GetValue();
//STRIP001                 if(USHRT_MAX != nZoomFactor)
//STRIP001                     SetZoom(eType, nZoomFactor);
//STRIP001             }
//STRIP001 			delete pDlg;
//STRIP001         }
//STRIP001 		break;
//STRIP001         case SID_ZOOM_IN:
//STRIP001         case SID_ZOOM_OUT:
//STRIP001         {
//STRIP001             enum SvxZoomType eType = SVX_ZOOM_PERCENT;
//STRIP001             const SwViewOption* pVOpt = GetViewShell()->GetViewOptions();
//STRIP001             SetZoom(eType,
//STRIP001                     lcl_GetNextZoomStep(pVOpt->GetZoom(), SID_ZOOM_IN == rReq.GetSlot()));
//STRIP001         }
//STRIP001         break;
//STRIP001         case FN_CHAR_LEFT:
//STRIP001         case FN_CHAR_RIGHT:
//STRIP001         case FN_LINE_UP:
//STRIP001         case FN_LINE_DOWN:
//STRIP001         {
//STRIP001             SwPagePreviewLayout* pPagePrevwLay = GetViewShell()->PagePreviewLayout();
//STRIP001             sal_uInt16 nNewSelectedPage;
//STRIP001             sal_uInt16 nNewStartPage;
//STRIP001             Point aNewStartPos;
//STRIP001             sal_Int16 nHoriMove = 0;
//STRIP001             sal_Int16 nVertMove = 0;
//STRIP001             switch(rReq.GetSlot())
//STRIP001             {
//STRIP001                 case FN_CHAR_LEFT:  nHoriMove = -1; break;
//STRIP001                 case FN_CHAR_RIGHT: nHoriMove = 1;  break;
//STRIP001                 case FN_LINE_UP:    nVertMove = -1; break;
//STRIP001                 case FN_LINE_DOWN:  nVertMove = 1;  break;
//STRIP001             }
//STRIP001             pPagePrevwLay->CalcStartValuesForSelectedPageMove( nHoriMove, nVertMove,
//STRIP001                                 nNewSelectedPage, nNewStartPage, aNewStartPos );
//STRIP001             if ( aViewWin.SelectedPage() != nNewSelectedPage )
//STRIP001             {
//STRIP001                 if ( pPagePrevwLay->IsPageVisible( nNewSelectedPage ) )
//STRIP001                 {
//STRIP001                     pPagePrevwLay->MarkNewSelectedPage( nNewSelectedPage );
//STRIP001                     // OD 19.02.2003 #107369# - adjust position at vertical scrollbar.
//STRIP001                     SetVScrollbarThumbPos( nNewSelectedPage );
//STRIP001                     bRefresh = false;
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     aViewWin.SetSelectedPage( nNewSelectedPage );
//STRIP001                     aViewWin.SetSttPage( nNewStartPage );
//STRIP001                     int nRet = ChgPage( SwPagePreViewWin::MV_SELPAGE, TRUE );
//STRIP001                     bRefresh = 0 != nRet;
//STRIP001                 }
//STRIP001                 GetViewShell()->ShowPreViewSelection( nNewSelectedPage );
//STRIP001                 // OD 24.03.2003 #108282# - invalidate page status.
//STRIP001                 static USHORT __READONLY_DATA aInval[] =
//STRIP001                 {
//STRIP001                     FN_STAT_PAGE, 0
//STRIP001                 };
//STRIP001                 SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001                 rBindings.Invalidate( aInval );
//STRIP001                 rReq.Done();
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001 		case FN_PAGEUP:
//STRIP001         case FN_PAGEDOWN:
//STRIP001         {
//STRIP001             _ExecPgUpAndPgDown( rReq.GetSlot() == FN_PAGEUP, &rReq );
//STRIP001             break;
//STRIP001         }
//STRIP001         case FN_START_OF_LINE:
//STRIP001         case FN_START_OF_DOCUMENT:
//STRIP001             aViewWin.SetSelectedPage( 1 );
//STRIP001 			eMvMode = SwPagePreViewWin::MV_DOC_STT;	bRetVal = TRUE;	goto MOVEPAGE;
//STRIP001         case FN_END_OF_LINE:
//STRIP001         case FN_END_OF_DOCUMENT:
//STRIP001             aViewWin.SetSelectedPage( mnPageCount );
//STRIP001             eMvMode = SwPagePreViewWin::MV_DOC_END; bRetVal = TRUE; goto MOVEPAGE;
//STRIP001 MOVEPAGE:
//STRIP001 			{
//STRIP001 				int nRet = ChgPage( eMvMode, TRUE );
//STRIP001 				// return value fuer Basic
//STRIP001 				if(bRetVal)
//STRIP001 					rReq.SetReturnValue(SfxBoolItem(rReq.GetSlot(), nRet == 0));
//STRIP001 
//STRIP001 				bRefresh = 0 != nRet;
//STRIP001 				rReq.Done();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FN_PRINT_PAGEPREVIEW:
//STRIP001 		{
//STRIP001 			const SwPagePreViewPrtData* pPPVPD = aViewWin.GetViewShell()->GetDoc()->GetPreViewPrtData();
//STRIP001 			// die Sache mit der Orientation
//STRIP001 			if(pPPVPD)
//STRIP001 			{
//STRIP001 				SfxPrinter* pPrinter = GetPrinter();
//STRIP001 				if((pPrinter->GetOrientation() == ORIENTATION_LANDSCAPE)
//STRIP001 						!= pPPVPD->GetLandscape())
//STRIP001 					pPrinter->SetOrientation(pPPVPD->GetLandscape() ? ORIENTATION_LANDSCAPE : ORIENTATION_PORTRAIT);
//STRIP001 			}
//STRIP001 			::binfilter::SetAppPrintOptions( aViewWin.GetViewShell(), FALSE );
//STRIP001 			bNormalPrint = FALSE;
//STRIP001 			USHORT nPrtSlot = SID_PRINTDOC;
//STRIP001 			rReq.SetSlot( nPrtSlot );
//STRIP001 			SfxViewShell::ExecuteSlot( rReq, SfxViewShell::GetInterface() );
//STRIP001 			rReq.SetSlot( FN_PRINT_PAGEPREVIEW );
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		case FN_PREVIEW_PRINT_OPTIONS :
//STRIP001 		{
//STRIP001 			SwPreviewPrintOptionsDialog aDlg(aViewWin, *this);
//STRIP001 			aDlg.Execute();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_PRINTDOCDIRECT:
//STRIP001 		case SID_PRINTDOC:
//STRIP001 			::binfilter::SetAppPrintOptions( aViewWin.GetViewShell(), FALSE );
//STRIP001 			bNormalPrint = TRUE;
//STRIP001 			SfxViewShell::ExecuteSlot( rReq, SfxViewShell::GetInterface() );
//STRIP001 			return;
//STRIP001         case FN_CLOSE_PAGEPREVIEW:
//STRIP001         case SID_PRINTPREVIEW:
//STRIP001 			//	print preview is now always in the same frame as the tab view
//STRIP001 			//	-> always switch this frame back to normal view
//STRIP001 			//	(ScTabViewShell ctor reads stored view data)
//STRIP001             GetViewFrame()->GetDispatcher()->Execute( SID_VIEWSHELL0, NULL, 0, SFX_CALLMODE_ASYNCHRON );
//STRIP001 			break;
//STRIP001         case FN_INSERT_BREAK:
//STRIP001         {
//STRIP001             USHORT nSelPage = aViewWin.SelectedPage();
//STRIP001             //if a dummy page is selected (e.g. a non-existing right/left page)
//STRIP001             //the direct neighbor is used
//STRIP001             if(GetViewShell()->IsDummyPage( nSelPage ) && GetViewShell()->IsDummyPage( --nSelPage ))
//STRIP001                 nSelPage +=2;
//STRIP001             SetNewPage( nSelPage );
//STRIP001             SfxViewFrame *pTmpFrm = GetViewFrame();
//STRIP001 			pTmpFrm->GetBindings().Execute( SID_VIEWSHELL0, NULL, 0,
//STRIP001 													SFX_CALLMODE_ASYNCHRON );
//STRIP001 		}
//STRIP001         break;
//STRIP001         default:
//STRIP001 			ASSERT(!this, falscher Dispatcher);
//STRIP001 			return;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bRefresh )
//STRIP001 		aViewWin.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  SwPagePreView::GetState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxWhichIter aIter(rSet);
//STRIP001 	BYTE nRow = 1;
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001     ASSERT(nWhich, leeres Set);
//STRIP001     SwPagePreviewLayout* pPagePrevwLay = GetViewShell()->PagePreviewLayout();
//STRIP001     //#106746# zoom has to be disabled if Accessibility support is switched on
//STRIP001     BOOL bZoomEnabled = !Application::GetSettings().GetMiscSettings().GetEnableATToolSupport();
//STRIP001 
//STRIP001 	while(nWhich)
//STRIP001 	{
//STRIP001 		switch(nWhich)
//STRIP001 		{
//STRIP001 		case FN_START_OF_DOCUMENT:
//STRIP001         {
//STRIP001             if ( pPagePrevwLay->IsPageVisible( 1 ) )
//STRIP001                 rSet.DisableItem(nWhich);
//STRIP001             break;
//STRIP001         }
//STRIP001         case FN_END_OF_DOCUMENT:
//STRIP001         {
//STRIP001             if ( pPagePrevwLay->IsPageVisible( mnPageCount ) )
//STRIP001                 rSet.DisableItem(nWhich);
//STRIP001             break;
//STRIP001         }
//STRIP001         case FN_PAGEUP:
//STRIP001         {
//STRIP001             if( pPagePrevwLay->GetWinPagesScrollAmount( -1 ) == 0 )
//STRIP001 				rSet.DisableItem(nWhich);
//STRIP001 			break;
//STRIP001         }
//STRIP001 		case FN_PAGEDOWN:
//STRIP001         {
//STRIP001             if( pPagePrevwLay->GetWinPagesScrollAmount( 1 ) == 0 )
//STRIP001                 rSet.DisableItem(nWhich);
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001 		case FN_STAT_PAGE:
//STRIP001 			{
//STRIP001 				String aStr( sPageStr );
//STRIP001                 aViewWin.GetStatusStr( aStr, mnPageCount );
//STRIP001 				rSet.Put( SfxStringItem( nWhich, aStr) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_ZOOM:
//STRIP001 		case FN_STAT_ZOOM:
//STRIP001 			{
//STRIP001                 if(bZoomEnabled)
//STRIP001                 {
//STRIP001                     const SwViewOption* pVOpt = GetViewShell()->GetViewOptions();
//STRIP001                     SvxZoomItem aZoom((SvxZoomType)pVOpt->GetZoomType(),
//STRIP001                                         pVOpt->GetZoom());
//STRIP001                     aZoom.SetValueSet(
//STRIP001                             SVX_ZOOM_ENABLE_50|
//STRIP001                             SVX_ZOOM_ENABLE_75|
//STRIP001                             SVX_ZOOM_ENABLE_100|
//STRIP001                             SVX_ZOOM_ENABLE_150|
//STRIP001                             SVX_ZOOM_ENABLE_200);
//STRIP001                     rSet.Put( aZoom );
//STRIP001                 }
//STRIP001                 else
//STRIP001                     rSet.DisableItem(nWhich);
//STRIP001             }
//STRIP001         break;
//STRIP001 		case FN_PREVIEW_ZOOM:
//STRIP001 		{
//STRIP001             if(bZoomEnabled)
//STRIP001             {
//STRIP001                 const SwViewOption* pVOpt = GetViewShell()->GetViewOptions();
//STRIP001                 rSet.Put(SfxUInt16Item(nWhich, pVOpt->GetZoom()));
//STRIP001             }
//STRIP001             else
//STRIP001                 rSet.DisableItem(nWhich);
//STRIP001         }
//STRIP001 		break;
//STRIP001         case SID_ZOOM_IN:
//STRIP001         case SID_ZOOM_OUT:
//STRIP001         {
//STRIP001             const SwViewOption* pVOpt = GetViewShell()->GetViewOptions();
//STRIP001             if(!bZoomEnabled || (SID_ZOOM_OUT == nWhich && pVOpt->GetZoom() >= MAX_PREVIEW_ZOOM)||
//STRIP001               (SID_ZOOM_IN == nWhich && pVOpt->GetZoom() <= MIN_PREVIEW_ZOOM))
//STRIP001             {
//STRIP001                 rSet.DisableItem(nWhich);
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001         case FN_SHOW_MULTIPLE_PAGES:
//STRIP001 		//should never be disabled
//STRIP001 		break;
//STRIP001 
//STRIP001 		case FN_SHOW_TWO_PAGES:
//STRIP001 			if( 2 == aViewWin.GetCol() && nRow == aViewWin.GetRow() )
//STRIP001 				rSet.DisableItem( nWhich );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FN_PRINT_PAGEPREVIEW:
//STRIP001 			// hat den gleichen Status wie das normale Drucken
//STRIP001 			{
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				SfxItemSet aSet( *rSet.GetPool(), SID_PRINTDOC, SID_PRINTDOC );
//STRIP001 				GetSlotState( SID_PRINTDOC, SfxViewShell::GetInterface(), &aSet );
//STRIP001 				if( SFX_ITEM_SET == aSet.GetItemState( SID_PRINTDOC,
//STRIP001 						FALSE, &pItem ))
//STRIP001 				{
//STRIP001 					((SfxPoolItem*)pItem)->SetWhich( FN_PRINT_PAGEPREVIEW );
//STRIP001 					rSet.Put( *pItem );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_PRINTPREVIEW:
//STRIP001 			rSet.Put( SfxBoolItem( nWhich, TRUE ) );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_PRINTDOC:
//STRIP001 		case SID_PRINTDOCDIRECT:
//STRIP001 			GetSlotState( nWhich, SfxViewShell::GetInterface(),	&rSet );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  SwPagePreView::StateUndo(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SfxWhichIter aIter(rSet);
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 
//STRIP001 	while (nWhich)
//STRIP001 	{
//STRIP001 		rSet.DisableItem(nWhich);
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreView::Init(const SwViewOption * pPrefs)
//STRIP001 {
//STRIP001     if ( GetViewShell()->HasDrawView() )
//STRIP001         GetViewShell()->GetDrawView()->SetAnimationEnabled( FALSE );
//STRIP001 
//STRIP001 	bNormalPrint = TRUE;
//STRIP001 
//STRIP001 	// Die DocSize erfragen und verarbeiten. Ueber die Handler konnte
//STRIP001 	// die Shell nicht gefunden werden, weil die Shell innerhalb CTOR-Phase
//STRIP001 	// nicht in der SFX-Verwaltung bekannt ist.
//STRIP001 
//STRIP001 	if( !pPrefs )
//STRIP001 		pPrefs = SW_MOD()->GetUsrPref(FALSE);
//STRIP001 
//STRIP001 	// die Felder aktualisieren
//STRIP001 	// ACHTUNG: hochcasten auf die EditShell, um die SS zu nutzen.
//STRIP001 	//			In den Methoden wird auf die akt. Shell abgefragt!
//STRIP001     SwEditShell* pESh = (SwEditShell*)GetViewShell();
//STRIP001 	BOOL bIsModified = pESh->IsModified();
//STRIP001 
//STRIP001 
//STRIP001 	SwViewOption aOpt( *pPrefs );
//STRIP001     aOpt.SetPagePreview(TRUE);
//STRIP001 	aOpt.SetTab( FALSE );
//STRIP001 	aOpt.SetBlank( FALSE );
//STRIP001 	aOpt.SetHardBlank( FALSE );
//STRIP001 	aOpt.SetParagraph( FALSE );
//STRIP001 	aOpt.SetLineBreak( FALSE );
//STRIP001 	aOpt.SetPageBreak( FALSE );
//STRIP001 	aOpt.SetColumnBreak( FALSE );
//STRIP001 	aOpt.SetSoftHyph( FALSE );
//STRIP001 	aOpt.SetFldName( FALSE );
//STRIP001 	aOpt.SetPostIts( FALSE );
//STRIP001 	aOpt.SetHidden( FALSE );
//STRIP001     aOpt.SetViewHRuler( FALSE );
//STRIP001     aOpt.SetViewVRuler( FALSE );
//STRIP001 	aOpt.SetGraphic( TRUE );
//STRIP001     aOpt.SetTable( TRUE );
//STRIP001     aOpt.SetSnap( FALSE );
//STRIP001 	aOpt.SetGridVisible( FALSE );
//STRIP001 	aOpt.SetHideSpell( TRUE );
//STRIP001     GetViewShell()->ApplyViewOptions( aOpt );
//STRIP001     GetViewShell()->ApplyAccessiblityOptions(SW_MOD()->GetAccessibilityOptions());
//STRIP001 
//STRIP001     // OD 09.01.2003 #i6467# - adjust view shell option to the same as for print
//STRIP001     SwPrtOptions aPrintOptions( GetViewFrame()->GetObjectShell()->GetTitle(0) );
//STRIP001     SwView::MakeOptions( 0, aPrintOptions, 0, false, 0, 0 );
//STRIP001     GetViewShell()->AdjustOptionsForPagePreview( aPrintOptions );
//STRIP001 
//STRIP001 	if(	pESh->GetDoc()->IsBrowseMode() )
//STRIP001 	{
//STRIP001 		pESh->GetDoc()->SetBrowseMode( FALSE );
//STRIP001 		pESh->CheckBrowseView( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001     GetViewShell()->CalcLayout();
//STRIP001     DocSzChgd( GetViewShell()->GetDocSize() );
//STRIP001 
//STRIP001 	if( !bIsModified )
//STRIP001 		pESh->ResetModified();
//STRIP001 
//STRIP001     pVScrollbar->Show(pPrefs->IsViewVScrollBar());
//STRIP001     pHScrollbar->Show(pPrefs->IsViewHScrollBar());
//STRIP001     pScrollFill->Show(pPrefs->IsViewVScrollBar() && pPrefs->IsViewHScrollBar());
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
/*N*/ SwPagePreView::SwPagePreView(SfxViewFrame *pFrame, SfxViewShell* pOldSh):
/*N*/ 	SfxViewShell( pFrame, SWVIEWFLAGS ),
/*N*/ 	aViewWin( &pFrame->GetWindow(), *this ),
/*N*/ 	pHScrollbar(0),
/*N*/ 	pVScrollbar(0),
/*N*/ 	pPageUpBtn(0),
/*N*/ 	pPageDownBtn(0),
/*N*/     pScrollFill(new ScrollBarBox( &pFrame->GetWindow(),
/*N*/         GetDocShell()->IsInFrame()? 0 : WB_SIZEABLE )),
/*N*/ 	sPageStr( SW_RES(STR_PAGE) ),
/*N*/     mnPageCount( 0 ),
/*N*/     nNewPage(USHRT_MAX),
/*N*/     // OD 09.01.2003 #106334#
/*N*/     mbResetFormDesignMode( false ),
/*N*/     mbFormDesignModeToReset( false )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 	SetName(String::CreateFromAscii("PageView" ));
//STRIP001 /*?*/ 	SetWindow( &aViewWin );
//STRIP001 /*?*/ 	SetHelpId(SW_PAGEPREVIEW);
//STRIP001 /*?*/     _CreateScrollbar( TRUE );
//STRIP001 /*?*/     _CreateScrollbar( FALSE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/     SfxObjectShell* pObjShell = pFrame->GetObjectShell();
//STRIP001 /*?*/ 	if ( !pOldSh )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		//Gibt es schon eine Sicht auf das Dokument?
//STRIP001 /*?*/ 		SfxViewFrame *pF = SfxViewFrame::GetFirst( pObjShell );
//STRIP001 /*?*/ 		if ( pF == pFrame )
//STRIP001 /*?*/ 			pF = SfxViewFrame::GetNext( *pF, pObjShell );
//STRIP001 /*?*/ 		if ( pF )
//STRIP001 /*?*/ 			pOldSh = pF->GetViewShell();
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	ViewShell *pVS, *pNew;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	if( pOldSh && pOldSh->IsA( TYPE( SwPagePreView ) ) )
//STRIP001 /*?*/         pVS = ((SwPagePreView*)pOldSh)->GetViewShell();
//STRIP001 /*?*/ 	else
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		if( pOldSh && pOldSh->IsA( TYPE( SwView ) ) )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pVS = ((SwView*)pOldSh)->GetWrtShellPtr();
//STRIP001 /*?*/ 			// save the current ViewData of the previous SwView
//STRIP001 /*?*/ 			pOldSh->WriteUserData( sSwViewData, FALSE );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			pVS = GetDocShell()->GetWrtShell();
//STRIP001 /*?*/ 		if( pVS )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// setze die akt. Seite als die erste
//STRIP001 /*?*/ 			USHORT nPhysPg, nVirtPg;
//STRIP001 /*?*/ 			((SwCrsrShell*)pVS)->GetPageNum( nPhysPg, nVirtPg, /*FALSE*/TRUE, FALSE );
//STRIP001 /*?*/ 			if( 1 != aViewWin.GetCol() && 1 == nPhysPg )
//STRIP001 /*?*/ 				--nPhysPg;
//STRIP001 /*?*/ 			aViewWin.SetSttPage( nPhysPg );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/     // OD 09.01.2003 #106334# - for form shell remember design mode of draw view
//STRIP001 /*?*/     // of previous view shell
//STRIP001 /*?*/     if ( pVS && pVS->HasDrawView() )
//STRIP001 /*?*/     {
//STRIP001 /*?*/         mbResetFormDesignMode = true;
//STRIP001 /*?*/         mbFormDesignModeToReset = pVS->GetDrawView()->IsDesignMode();
//STRIP001 /*?*/     }
//STRIP001 /*?*/ 
//STRIP001 /*?*/     if( pVS )
//STRIP001 /*?*/ 		pNew = new ViewShell( *pVS, &aViewWin, 0, VSHELLFLAG_ISPREVIEW );
//STRIP001 /*?*/ 	else
//STRIP001 /*?*/ 		pNew = new ViewShell(
//STRIP001 /*?*/ 				*((SwDocShell*)pFrame->GetObjectShell())->GetDoc(),
//STRIP001 /*?*/ 				&aViewWin, 0, 0, VSHELLFLAG_ISPREVIEW );
//STRIP001 /*?*/ 
//STRIP001 /*?*/     aViewWin.SetViewShell( pNew );
//STRIP001 /*?*/ 	pNew->SetSfxViewShell( this );
//STRIP001 /*?*/ 	Init();
/*N*/ }


/*--------------------------------------------------------------------
	Beschreibung:
--------------------------------------------------------------------*/


/*N*/  SwPagePreView::~SwPagePreView()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 	SetWindow( 0 );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	delete pScrollFill;
//STRIP001 /*?*/ 	delete pHScrollbar;
//STRIP001 /*?*/ 	delete pVScrollbar;
//STRIP001 /*?*/ 	delete pPageUpBtn;
//STRIP001 /*?*/ 	delete pPageDownBtn;

/*    SfxObjectShell* pDocSh = GetDocShell();
	TypeId aType = TYPE( SfxTopViewFrame );

	for( SfxViewFrame *pFrame = SfxViewFrame::GetFirst( pDocSh, aType );
		pFrame; pFrame = SfxViewFrame::GetNext( *pFrame, pDocSh, aType ) )
		if( pFrame != GetViewFrame() )
		{
			// es gibt noch eine weitere Sicht auf unser Dokument, also
			// aktiviere dieses
			pFrame->GetFrame()->Appear();
			break;
		}
*/}

/*--------------------------------------------------------------------
 	Beschreibung:
 --------------------------------------------------------------------*/


/*N*/ SwDocShell* SwPagePreView::GetDocShell()
/*N*/ {
/*N*/ 	return PTR_CAST(SwDocShell, GetViewFrame()->GetObjectShell());
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


//STRIP001 int	SwPagePreView::_CreateScrollbar( int bHori )
//STRIP001 {
//STRIP001 	Window *pMDI = &GetViewFrame()->GetWindow();
//STRIP001 	SwScrollbar** ppScrollbar = bHori ? &pHScrollbar : &pVScrollbar;
//STRIP001 
//STRIP001 	ASSERT( !*ppScrollbar, "vorher abpruefen!" )
//STRIP001 
//STRIP001 	if( !bHori )
//STRIP001 	{
//STRIP001 
//STRIP001 		pPageUpBtn		= new ImageButton(pMDI, SW_RES( BTN_PAGEUP ) );
//STRIP001 		pPageUpBtn->SetHelpId(FN_PAGEUP);
//STRIP001 		pPageDownBtn	= new ImageButton(pMDI, SW_RES( BTN_PAGEDOWN ) );
//STRIP001 		pPageDownBtn->SetHelpId(FN_PAGEDOWN);
//STRIP001 		Link aLk( LINK( this, SwPagePreView, BtnPage ) );
//STRIP001 		pPageUpBtn->SetClickHdl( aLk );
//STRIP001 		pPageDownBtn->SetClickHdl( aLk );
//STRIP001 		pPageUpBtn->Show();
//STRIP001 		pPageDownBtn->Show();
//STRIP001 	}
//STRIP001 
//STRIP001 	*ppScrollbar = new SwScrollbar( pMDI, bHori );
//STRIP001 
//STRIP001     ScrollDocSzChg();
//STRIP001     (*ppScrollbar)->EnableDrag( TRUE );
//STRIP001     (*ppScrollbar)->SetEndScrollHdl( LINK( this, SwPagePreView, EndScrollHdl ));
//STRIP001 
//STRIP001 
//STRIP001 	(*ppScrollbar)->SetScrollHdl( LINK( this, SwPagePreView, ScrollHdl ));
//STRIP001 
//STRIP001 	InvalidateBorder();
//STRIP001 	(*ppScrollbar)->Show();
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 /*
//STRIP001  * Button-Handler
//STRIP001  */
//STRIP001 IMPL_LINK_INLINE_START( SwPagePreView, BtnPage, Button *, pButton )
//STRIP001 {
//STRIP001     // OD 04.03.2003 #107369# - use new helper method to perform page up
//STRIP001     // respectively page down.
//STRIP001     _ExecPgUpAndPgDown( pButton == pPageUpBtn );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwPagePreView, BtnPage, Button *, pButton )
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 int SwPagePreView::ChgPage( int eMvMode, int bUpdateScrollbar )
//STRIP001 {
//STRIP001 	Rectangle aPixVisArea( aViewWin.LogicToPixel( aVisArea ) );
//STRIP001 	int bChg = aViewWin.MovePage( eMvMode ) ||
//STRIP001                eMvMode == SwPagePreViewWin::MV_CALC ||
//STRIP001                eMvMode == SwPagePreViewWin::MV_NEWWINSIZE;
//STRIP001 	aVisArea = aViewWin.PixelToLogic( aPixVisArea );
//STRIP001 
//STRIP001 	if( bChg )
//STRIP001 	{
//STRIP001 		// Statusleiste updaten
//STRIP001 		String aStr( sPageStr );
//STRIP001         aViewWin.GetStatusStr( aStr, mnPageCount );
//STRIP001 		SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 
//STRIP001 		if( bUpdateScrollbar )
//STRIP001 		{
//STRIP001             ScrollViewSzChg();
//STRIP001 
//STRIP001 			static USHORT __READONLY_DATA aInval[] =
//STRIP001 			{
//STRIP001 				FN_START_OF_DOCUMENT, FN_END_OF_DOCUMENT,
//STRIP001 				FN_PAGEUP, FN_PAGEDOWN, 0
//STRIP001 			};
//STRIP001 			rBindings.Invalidate( aInval );
//STRIP001 		}
//STRIP001 		rBindings.SetState( SfxStringItem( FN_STAT_PAGE, aStr ) );
//STRIP001 	}
//STRIP001 	return bChg;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*  */
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 // ab hier alles aus der SwView uebernommen
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreView::CalcAndSetBorderPixel( SvBorder &rToFill, FASTBOOL bInner )
//STRIP001 {
//STRIP001 //	const long nAdd = bInner ? 0 : ScrollBar::GetWindowOverlapPixel();
//STRIP001 	const StyleSettings &rSet = aViewWin.GetSettings().GetStyleSettings();
//STRIP001 	const long nTmp = rSet.GetScrollBarSize();// - nAdd;
//STRIP001     if ( pVScrollbar->IsVisible())
//STRIP001 		rToFill.Right()  = nTmp;
//STRIP001 	if ( pHScrollbar->IsVisible() )
//STRIP001 		rToFill.Bottom() = nTmp;
//STRIP001 	SetBorderPixel( rToFill );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  SwPagePreView::InnerResizePixel( const Point &rOfst, const Size &rSize )
//STRIP001 {
//STRIP001 	SvBorder aBorder;
//STRIP001 	CalcAndSetBorderPixel( aBorder, TRUE );
//STRIP001 	Rectangle aRect( rOfst, rSize );
//STRIP001 	aRect += aBorder;
//STRIP001 	ViewResizePixel( aViewWin, aRect.TopLeft(), aRect.GetSize(),
//STRIP001 					aViewWin.GetOutputSizePixel(),
//STRIP001 					TRUE,
//STRIP001                     *pVScrollbar, *pHScrollbar, pPageUpBtn, pPageDownBtn, 0,
//STRIP001                     *pScrollFill );
//STRIP001 
//STRIP001 	//EditWin niemals einstellen!
//STRIP001 	//VisArea niemals einstellen!
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  SwPagePreView::OuterResizePixel( const Point &rOfst, const Size &rSize )
//STRIP001 {
//STRIP001 	SvBorder aBorder;
//STRIP001 	CalcAndSetBorderPixel( aBorder, FALSE );
//STRIP001 	ViewResizePixel( aViewWin, rOfst, rSize, aViewWin.GetOutputSizePixel(),
//STRIP001                         FALSE, *pVScrollbar,
//STRIP001                         *pHScrollbar, pPageUpBtn, pPageDownBtn, 0, *pScrollFill );
//STRIP001 
//STRIP001 	//EditWin niemals einstellen!
//STRIP001 
//STRIP001 	Size aTmpSize( aViewWin.GetOutputSizePixel() );
//STRIP001 	Point aBottomRight( aViewWin.PixelToLogic( Point( aTmpSize.Width(), aTmpSize.Height() ) ) );
//STRIP001 	SetVisArea( Rectangle( Point(), aBottomRight ) );
//STRIP001 
//STRIP001 	//Aufruf der DocSzChgd-Methode der Scrollbars ist noetig, da vom maximalen
//STRIP001 	//Scrollrange immer die halbe Hoehe der VisArea abgezogen wird.
//STRIP001 	if ( pVScrollbar )
//STRIP001         ScrollDocSzChg();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreView::SetVisArea( const Rectangle &rRect, BOOL bUpdateScrollbar )
//STRIP001 {
//STRIP001 	const Point aTopLeft(AlignToPixel(rRect.TopLeft()));
//STRIP001 	const Point aBottomRight(AlignToPixel(rRect.BottomRight()));
//STRIP001 	Rectangle aLR(aTopLeft,aBottomRight);
//STRIP001 
//STRIP001 	if(aLR == aVisArea)
//STRIP001 		return;
//STRIP001 		// keine negative Position, keine neg. Groesse
//STRIP001 
//STRIP001 	if(aLR.Top() < 0)
//STRIP001 	{
//STRIP001 		aLR.Bottom() += Abs(aLR.Top());
//STRIP001 		aLR.Top() = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(aLR.Left() < 0)
//STRIP001 	{
//STRIP001 		aLR.Right() += Abs(aLR.Left());
//STRIP001 		aLR.Left() = 0;
//STRIP001 	}
//STRIP001 	if(aLR.Right() < 0) aLR.Right() = 0;
//STRIP001 	if(aLR.Bottom() < 0) aLR.Bottom() = 0;
//STRIP001 	if(aLR == aVisArea ||
//STRIP001 		// JP 29.10.97: Bug 45173 - Leeres Rechteck nicht beachten
//STRIP001 		( 0 == aLR.Bottom() - aLR.Top() && 0 == aLR.Right() - aLR.Left() ) )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if( aLR.Left() > aLR.Right() || aLR.Top() > aLR.Bottom() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	//Bevor die Daten veraendert werden ggf. ein Update rufen. Dadurch wird
//STRIP001 	//sichergestellt, da?anliegende Paints korrekt in Dokumentkoordinaten
//STRIP001 	//umgerechnet werden.
//STRIP001 	//Vorsichtshalber tun wir das nur wenn an der Shell eine Action laeuft,
//STRIP001 	//denn dann wir nicht wirklich gepaintet sondern die Rechtecke werden
//STRIP001 	//lediglich (in Dokumentkoordinaten) vorgemerkt.
//STRIP001     if( GetViewShell()->ActionPend() )
//STRIP001 		aViewWin.Update();
//STRIP001 
//STRIP001 	// setze am View-Win die aktuelle Size
//STRIP001 	aVisArea = aLR;
//STRIP001 	aViewWin.SetWinSize( aLR.GetSize() );
//STRIP001     // OD 18.12.2002 #103492# - use new mode
//STRIP001     ChgPage( SwPagePreViewWin::MV_NEWWINSIZE, bUpdateScrollbar );
//STRIP001 
//STRIP001 	aViewWin.Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwPagePreView, ScrollHdl, SwScrollbar *, pScrollbar )
//STRIP001 {
//STRIP001     if(!GetViewShell())
//STRIP001         return 0;
//STRIP001     if( !pScrollbar->IsHoriScroll() &&
//STRIP001         pScrollbar->GetType() == SCROLL_DRAG &&
//STRIP001         Help::IsQuickHelpEnabled() &&
//STRIP001         GetViewShell()->PagePreviewLayout()->DoesPreviewLayoutRowsFitIntoWindow())
//STRIP001 	{
//STRIP001 		// wieviele Seiten scrollen ??
//STRIP001 		String sStateStr(sPageStr);
//STRIP001 		USHORT nThmbPos = (USHORT)pScrollbar->GetThumbPos();
//STRIP001 		if( 1 == aViewWin.GetCol() || !nThmbPos )
//STRIP001 			++nThmbPos;
//STRIP001 		sStateStr += String::CreateFromInt32( nThmbPos );
//STRIP001 		Point aPos = pScrollbar->GetParent()->OutputToScreenPixel(
//STRIP001 										pScrollbar->GetPosPixel());
//STRIP001 		aPos.Y() = pScrollbar->OutputToScreenPixel(pScrollbar->GetPointerPosPixel()).Y();
//STRIP001 		Size aSize = pScrollbar->GetSizePixel();
//STRIP001 		Rectangle aRect;
//STRIP001 		aRect.Left() 	= aPos.X() -8;
//STRIP001 		aRect.Right() 	= aRect.Left();
//STRIP001 		aRect.Top()		= aPos.Y();
//STRIP001 		aRect.Bottom()	= aRect.Top();
//STRIP001 
//STRIP001 		Help::ShowQuickHelp(pScrollbar, aRect, sStateStr,
//STRIP001 				QUICKHELP_RIGHT|QUICKHELP_VCENTER);
//STRIP001 
//STRIP001 	}
//STRIP001 	else
//STRIP001 		EndScrollHdl( pScrollbar );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwPagePreView, EndScrollHdl, SwScrollbar *, pScrollbar )
//STRIP001 {
//STRIP001     if(!GetViewShell())
//STRIP001         return 0;
//STRIP001 
//STRIP001     // OD 04.03.2003 #107369# - boolean to avoid unnecessary invalidation of the window.
//STRIP001     bool bInvalidateWin = true;
//STRIP001 
//STRIP001     if( !pScrollbar->IsHoriScroll() )       // scroll vertically
//STRIP001 	{
//STRIP001         if ( Help::IsQuickHelpEnabled() )
//STRIP001 			Help::ShowQuickHelp(pScrollbar, Rectangle(), aEmptyStr, 0);
//STRIP001         if ( GetViewShell()->PagePreviewLayout()->DoesPreviewLayoutRowsFitIntoWindow() )
//STRIP001         {
//STRIP001             // wieviele Seiten scrollen ??
//STRIP001             USHORT nThmbPos = (USHORT)pScrollbar->GetThumbPos();
//STRIP001             // OD 05.12.2002 #103492# - adjust to new preview functionality
//STRIP001             if( nThmbPos != aViewWin.SelectedPage() )
//STRIP001             {
//STRIP001                 // OD 17.01.2003 #103492# - consider case that page <nThmbPos>
//STRIP001                 // is already visible
//STRIP001                 SwPagePreviewLayout* pPagePrevwLay = GetViewShell()->PagePreviewLayout();
//STRIP001                 if ( pPagePrevwLay->IsPageVisible( nThmbPos ) )
//STRIP001                 {
//STRIP001                     pPagePrevwLay->MarkNewSelectedPage( nThmbPos );
//STRIP001                     // OD 04.03.2003 #107369# - invalidation of window is unnecessary
//STRIP001                     bInvalidateWin = false;
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     // OD 17.01.2003 #103492# - consider whether layout columns
//STRIP001                     // fit or not.
//STRIP001                     if ( !pPagePrevwLay->DoesPreviewLayoutColsFitIntoWindow() )
//STRIP001                     {
//STRIP001                         aViewWin.SetSttPage( nThmbPos );
//STRIP001                         aViewWin.SetSelectedPage( nThmbPos );
//STRIP001                         ChgPage( SwPagePreViewWin::MV_SCROLL, FALSE );
//STRIP001                         // OD 20.01.2003 #103492# - update scrollbars
//STRIP001                         ScrollViewSzChg();
//STRIP001                     }
//STRIP001                     else
//STRIP001                     {
//STRIP001                         // OD 04.03.2003 #107369# - correct scroll amount
//STRIP001                         const sal_Int16 nPageDiff = nThmbPos - aViewWin.SelectedPage();
//STRIP001                         const sal_uInt16 nVisPages = aViewWin.GetRow() * aViewWin.GetCol();
//STRIP001                         sal_Int16 nWinPagesToScroll = nPageDiff / nVisPages;
//STRIP001                         if ( nPageDiff % nVisPages )
//STRIP001                         {
//STRIP001                             // decrease/increase number of preview pages to scroll
//STRIP001                             nPageDiff < 0 ? --nWinPagesToScroll : ++nWinPagesToScroll;
//STRIP001                         }
//STRIP001                         aViewWin.SetSelectedPage( nThmbPos );
//STRIP001                         aViewWin.Scroll( 0, pPagePrevwLay->GetWinPagesScrollAmount( nWinPagesToScroll ) );
//STRIP001                     }
//STRIP001                 }
//STRIP001                 // OD 17.01.2003 #103492# - update accessibility
//STRIP001                 GetViewShell()->ShowPreViewSelection( nThmbPos );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 // OD 04.03.2003 #107369# - invalidation of window is unnecessary
//STRIP001                 bInvalidateWin = false;
//STRIP001             }
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             long nThmbPos = pScrollbar->GetThumbPos();
//STRIP001             aViewWin.Scroll(0, nThmbPos - aViewWin.GetPaintedPreviewDocRect().Top());
//STRIP001         }
//STRIP001 	}
//STRIP001     else
//STRIP001     {
//STRIP001         long nThmbPos = pScrollbar->GetThumbPos();
//STRIP001         aViewWin.Scroll(nThmbPos - aViewWin.GetPaintedPreviewDocRect().Left(), 0);
//STRIP001     }
//STRIP001     // OD 24.03.2003 #108282# - additional invalidate page status.
//STRIP001     static USHORT __READONLY_DATA aInval[] =
//STRIP001     {
//STRIP001         FN_START_OF_DOCUMENT, FN_END_OF_DOCUMENT, FN_PAGEUP, FN_PAGEDOWN,
//STRIP001         FN_STAT_PAGE, 0
//STRIP001     };
//STRIP001     SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001     rBindings.Invalidate( aInval );
//STRIP001     // OD 04.03.2003 #107369# - control invalidation of window
//STRIP001     if ( bInvalidateWin )
//STRIP001     {
//STRIP001         aViewWin.Invalidate();
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 Point SwPagePreView::AlignToPixel(const Point &rPt) const
//STRIP001 {
//STRIP001 	return aViewWin.PixelToLogic( aViewWin.LogicToPixel( rPt ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreView::DocSzChgd( const Size &rSz )
//STRIP001 {
//STRIP001 	if( aDocSz == rSz )
//STRIP001 		return;
//STRIP001 
//STRIP001 	aDocSz = rSz;
//STRIP001 
//STRIP001 	// die neue Anzahl von Seiten bestimmen
//STRIP001     USHORT nNewCnt = GetViewShell()->GetNumPages();
//STRIP001     if( nNewCnt == mnPageCount )
//STRIP001 		return;
//STRIP001 
//STRIP001 	// dann eine neue Startseite berechnen
//STRIP001     mnPageCount = nNewCnt;
//STRIP001 	if( aVisArea.GetWidth() )
//STRIP001 	{
//STRIP001 		ChgPage( SwPagePreViewWin::MV_CALC, TRUE );
//STRIP001         ScrollDocSzChg();
//STRIP001 
//STRIP001 		aViewWin.Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreView::ScrollViewSzChg()
//STRIP001 {
//STRIP001     if(!GetViewShell())
//STRIP001         return ;
//STRIP001     if(pVScrollbar)
//STRIP001     {
//STRIP001         if(GetViewShell()->PagePreviewLayout()->DoesPreviewLayoutRowsFitIntoWindow())
//STRIP001         {
//STRIP001             //vertical scrolling by row
//STRIP001             // OD 04.12.2002 #103492# - adjust to new preview functionality
//STRIP001             USHORT nVisPages = aViewWin.GetRow() * aViewWin.GetCol();
//STRIP001             pVScrollbar->SetVisibleSize( nVisPages );
//STRIP001             // OD 19.02.2003 #107369# - set selected page as scroll bar position,
//STRIP001             // if it is visible.
//STRIP001             SwPagePreviewLayout* pPagePrevwLay = GetViewShell()->PagePreviewLayout();
//STRIP001             if ( pPagePrevwLay->IsPageVisible( aViewWin.SelectedPage() ) )
//STRIP001             {
//STRIP001                 pVScrollbar->SetThumbPos( aViewWin.SelectedPage() );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 pVScrollbar->SetThumbPos( aViewWin.GetSttPage() );
//STRIP001             }
//STRIP001             pVScrollbar->SetLineSize( aViewWin.GetCol() );
//STRIP001             pVScrollbar->SetPageSize( nVisPages );
//STRIP001             // calculate and set scrollbar range
//STRIP001             Range aScrollbarRange( 1, mnPageCount );
//STRIP001             // increase range by one, because left-top-corner is left blank.
//STRIP001             ++aScrollbarRange.Max();
//STRIP001             // OD 17.01.2003 #103492# - increase range in order to access all pages
//STRIP001             aScrollbarRange.Max() += ( nVisPages - 1 );
//STRIP001             pVScrollbar->SetRange( aScrollbarRange );
//STRIP001         }
//STRIP001         else //vertical scrolling by pixel
//STRIP001         {
//STRIP001             const Rectangle& rDocRect = aViewWin.GetPaintedPreviewDocRect();
//STRIP001             const Size& rPreviewSize =
//STRIP001                     GetViewShell()->PagePreviewLayout()->GetPrevwDocSize();
//STRIP001             pVScrollbar->SetRangeMax(rPreviewSize.Height()) ;
//STRIP001             long nVisHeight = rDocRect.GetHeight();
//STRIP001             pVScrollbar->SetVisibleSize( nVisHeight );
//STRIP001             pVScrollbar->SetThumbPos( rDocRect.Top() );
//STRIP001             pVScrollbar->SetLineSize( nVisHeight / 10 );
//STRIP001             pVScrollbar->SetPageSize( nVisHeight / 2 );
//STRIP001         }
//STRIP001     }
//STRIP001     if(pHScrollbar)
//STRIP001     {
//STRIP001         const Rectangle& rDocRect = aViewWin.GetPaintedPreviewDocRect();
//STRIP001         const Size& rPreviewSize =
//STRIP001                 GetViewShell()->PagePreviewLayout()->GetPrevwDocSize();
//STRIP001         long nVisWidth = 0;
//STRIP001         long nThumb   = 0;
//STRIP001         long nVisPage = 0;
//STRIP001         Range aRange(0,0);
//STRIP001 
//STRIP001         if(rDocRect.GetWidth() < rPreviewSize.Width())
//STRIP001         {
//STRIP001             nVisWidth = rDocRect.GetWidth();
//STRIP001             nThumb = rDocRect.Left();
//STRIP001             aRange = Range(0, rPreviewSize.Width());
//STRIP001         }
//STRIP001         pHScrollbar->SetRange( aRange );
//STRIP001         pHScrollbar->SetVisibleSize( nVisWidth );
//STRIP001         pHScrollbar->SetThumbPos( nThumb );
//STRIP001         pHScrollbar->SetLineSize( nVisWidth / 10 );
//STRIP001         pHScrollbar->SetPageSize( nVisWidth / 2 );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwPagePreView::ScrollDocSzChg()
//STRIP001 {
//STRIP001     ScrollViewSzChg();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*  */
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 // alles zum Thema Drucken
//STRIP001 
//STRIP001 USHORT  SwPagePreView::Print( SfxProgress &rProgress, PrintDialog *pDlg )
//STRIP001 {
//STRIP001 	ViewShell* pSh = aViewWin.GetViewShell();
//STRIP001 	SfxPrinter* pPrinter = GetPrinter();
//STRIP001 	if( !pPrinter || !pPrinter->InitJob( &aViewWin, pSh->HasDrawView() &&
//STRIP001 					pSh->GetDrawView()->GetModel()->HasTransparentObjects() ))
//STRIP001 		return ERRCODE_IO_ABORT;
//STRIP001 
//STRIP001 
//STRIP001 	SwWait aWait( *GetDocShell(), TRUE );
//STRIP001 
//STRIP001 	USHORT nRowCol = ( aViewWin.GetRow() << 8 ) +
//STRIP001 						aViewWin.GetCol();	// Zeilen / DoppelSeiten
//STRIP001 
//STRIP001 	{
//STRIP001 		// die Felder aktualisieren
//STRIP001 		// ACHTUNG: hochcasten auf die EditShell, um die SS zu nutzen.
//STRIP001 		//			In den Methoden wird auf die akt. Shell abgefragt!
//STRIP001 		SwEditShell* pESh = (SwEditShell*)pSh;
//STRIP001 		SwDocStat aDocStat;
//STRIP001 		BOOL bIsModified = pESh->IsModified();
//STRIP001 
//STRIP001 		pESh->StartAllAction();
//STRIP001 		pESh->UpdateDocStat( aDocStat );
//STRIP001 		pSh->UpdateFlds();
//STRIP001 		pESh->EndAllAction();
//STRIP001 
//STRIP001 		if( !bIsModified )
//STRIP001 			pESh->ResetModified();
//STRIP001 	}
//STRIP001 
//STRIP001 	// Druckauftrag starten
//STRIP001 	SfxObjectShell *pObjShell = GetViewFrame()->GetObjectShell();
//STRIP001 	SwPrtOptions aOpts( pObjShell->GetTitle(0) );
//STRIP001 
//STRIP001 	BOOL bPrtPros;
//STRIP001     SwView::MakeOptions( pDlg, aOpts, &bPrtPros, FALSE, GetPrinter(), GetDocShell()->GetDoc()->GetPrintData() );
//STRIP001 
//STRIP001 	if( bNormalPrint )
//STRIP001 	{
//STRIP001 		if( bPrtPros )
//STRIP001 			pSh->PrintProspect( aOpts, rProgress );
//STRIP001 		else
//STRIP001 			pSh->Prt( aOpts, rProgress );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const SwPagePreViewPrtData* pPPVPD = pSh->GetDoc()->GetPreViewPrtData();
//STRIP001 		if( pPPVPD && pPPVPD->GetCol() && pPPVPD->GetRow() )
//STRIP001 		{
//STRIP001 			// Zeilen / Seiten
//STRIP001 			nRowCol = ( pPPVPD->GetRow() << 8 ) + pPPVPD->GetCol();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pPPVPD = 0;
//STRIP001 		pSh->PrintPreViewPage( aOpts, nRowCol, rProgress, pPPVPD );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0; // OK
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SfxPrinter*  SwPagePreView::GetPrinter( BOOL bCreate )
//STRIP001 {
//STRIP001 	return aViewWin.GetViewShell()->GetPrt( bCreate );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 USHORT  SwPagePreView::SetPrinter( SfxPrinter *pNew, USHORT nDiffFlags )
//STRIP001 {
//STRIP001     ViewShell &rSh = *GetViewShell();
//STRIP001 	SwEditShell &rESh = (SwEditShell&)rSh;	//Buh...
//STRIP001 	if( ( SFX_PRINTER_PRINTER | SFX_PRINTER_JOBSETUP ) & nDiffFlags )
//STRIP001 	{
//STRIP001 		rSh.SetPrt( pNew );
//STRIP001 		if( nDiffFlags & SFX_PRINTER_PRINTER )
//STRIP001 			rESh.SetModified();
//STRIP001 	}
//STRIP001 	if ( ( nDiffFlags & SFX_PRINTER_OPTIONS ) == SFX_PRINTER_OPTIONS )
//STRIP001 		::SetPrinter( pNew, FALSE );
//STRIP001 
//STRIP001 	const BOOL bChgOri = nDiffFlags & SFX_PRINTER_CHG_ORIENTATION ? TRUE : FALSE;
//STRIP001 	const BOOL bChgSize= nDiffFlags & SFX_PRINTER_CHG_SIZE ? TRUE : FALSE;
//STRIP001 	if ( bChgOri || bChgSize )
//STRIP001 	{
//STRIP001 		rESh.StartAllAction();
//STRIP001 		if ( bChgOri )
//STRIP001 			rSh.ChgAllPageOrientation( USHORT(pNew->GetOrientation()) );
//STRIP001 		if ( bChgSize )
//STRIP001 		{
//STRIP001 			Size aSz( SvxPaperInfo::GetPaperSize( pNew ) );
//STRIP001 			rSh.ChgAllPageSize( aSz );
//STRIP001 		}
//STRIP001 		if( !bNormalPrint )
//STRIP001 			aViewWin.CalcWish( aViewWin.GetRow(), aViewWin.GetCol() );
//STRIP001 		rESh.SetModified();
//STRIP001 		rESh.EndAllAction();
//STRIP001 
//STRIP001 		static USHORT __READONLY_DATA aInval[] =
//STRIP001 		{
//STRIP001 			SID_ATTR_LONG_ULSPACE, SID_ATTR_LONG_LRSPACE,
//STRIP001 			SID_RULER_BORDERS, SID_RULER_PAGE_POS, 0
//STRIP001 		};
//STRIP001 #ifndef PRODUCT
//STRIP001 	{
//STRIP001 		const USHORT* pPtr = aInval + 1;
//STRIP001 		do {
//STRIP001 			ASSERT( *(pPtr - 1) < *pPtr, "falsche Sortierung!" );
//STRIP001 		} while( *++pPtr );
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 		GetViewFrame()->GetBindings().Invalidate(aInval);
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SfxTabPage*  SwPagePreView::CreatePrintOptionsPage( Window *pParent,
//STRIP001 												const SfxItemSet &rOptions )
//STRIP001 {
//STRIP001 	return ::CreatePrintOptionsPage( pParent, rOptions, !bNormalPrint );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 PrintDialog*  SwPagePreView::CreatePrintDialog( Window *pParent )
//STRIP001 {
//STRIP001 	PrintDialog *pDlg = ::CreatePrintDialog( pParent, 1, 0 );
//STRIP001 	pDlg->DisableRange( PRINTDIALOG_SELECTION );
//STRIP001 	return pDlg;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 // OD 18.12.2002 #103492# - no longer needed ??
//STRIP001 Size  SwPagePreView::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001     ASSERT( false, "overloaded virtual method <SwPagePreView::GetOptimalSizePixel()> needed ??" )
//STRIP001     return Size( -1, -1 );
//STRIP001 /*
//STRIP001     //JP 09.06.99: was wird hier errechnet ?????
//STRIP001 // ALT:
//STRIP001 //   SfxApplicationWindow* pWin = SFX_APPWINDOW ;
//STRIP001 //   Rectangle aRect = pWin->GetClientAreaPixel();
//STRIP001 
//STRIP001 	Window& rWin = GetViewFrame()->GetWindow();
//STRIP001 	Rectangle aRect( Point(0, 0), rWin.GetOutputSizePixel() );
//STRIP001 	Size aMaxSize( aRect.GetWidth(), aRect.GetHeight() );
//STRIP001 	Size aInSize = rWin.GetOutputSizePixel();
//STRIP001 	Size aOutSize = rWin.GetSizePixel();
//STRIP001 	USHORT nXBorder = USHORT(aOutSize.Width() - aInSize.Width());
//STRIP001 	USHORT nYBorder = USHORT(aOutSize.Height() - aInSize.Height());
//STRIP001 	aMaxSize.Width() -= nXBorder;
//STRIP001 	//'auf Verdacht' etwas vom Border abziehen (Menue)
//STRIP001 	nYBorder -= (nYBorder - nXBorder) / 2;
//STRIP001 	aMaxSize.Height() -= nYBorder;
//STRIP001 	//mit der max. moeglichen Outputsize guenstigstes Verhaeltnis ausrechnen
//STRIP001 	aViewWin.GetOptimalSize(aMaxSize);
//STRIP001 	// Border wieder dazuzaehlen
//STRIP001 	aMaxSize.Height() += nYBorder;
//STRIP001 	aMaxSize.Width() += nXBorder;
//STRIP001 	return aMaxSize;
//STRIP001 */
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 // OD 12.12.2002 #103492#
//STRIP001 void SwPagePreViewWin::SetViewShell( ViewShell* pShell )
//STRIP001 {
//STRIP001     mpViewShell = pShell;
//STRIP001     if ( mpViewShell && mpViewShell->IsPreView() )
//STRIP001     {
//STRIP001         mpPgPrevwLayout = mpViewShell->PagePreviewLayout();
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void SwPagePreViewWin::RepaintCoreRect( const SwRect& rRect )
//STRIP001 {
//STRIP001     mpPgPrevwLayout->Repaint( Rectangle( rRect.Pos(), rRect.SSize() ) );
//STRIP001 }
//STRIP001 
//STRIP001 /** method to adjust preview to a new zoom factor
//STRIP001 
//STRIP001     OD 02.12.2002 #103492#
//STRIP001 */
//STRIP001 void SwPagePreViewWin::AdjustPreviewToNewZoom( const sal_uInt16 nZoomFactor)
//STRIP001 {
//STRIP001     // calculate new scaling and set mapping mode appropriately.
//STRIP001     Fraction aNewScale( nZoomFactor, 100 );
//STRIP001     MapMode aNewMapMode = GetMapMode();
//STRIP001     aNewMapMode.SetScaleX( aNewScale );
//STRIP001     aNewMapMode.SetScaleY( aNewScale );
//STRIP001     SetMapMode( aNewMapMode );
//STRIP001 
//STRIP001     // calculate new start position for preview paint
//STRIP001     Size aNewWinSize = PixelToLogic( maPxWinSize );
//STRIP001     Point aNewPaintStartPos =
//STRIP001             mpPgPrevwLayout->GetPreviewStartPosForNewScale( aNewScale, maScale, aNewWinSize );
//STRIP001 
//STRIP001     // remember new scaling and prepare preview paint
//STRIP001     // Note: paint of preview will be performed by a corresponding invalidate
//STRIP001     //          due to property changes.
//STRIP001     maScale = aNewScale;
//STRIP001     mpPgPrevwLayout->Prepare( 0, aNewPaintStartPos, maPxWinSize,
//STRIP001                               mnSttPage, maPaintedPreviewDocRect );
//STRIP001 
//STRIP001 }
//STRIP001 /* -----------------04.12.2002 10:46-----------------
//STRIP001  * pixel scrolling - horizontally always or vertically
//STRIP001  * when less than the desired number of rows fits into
//STRIP001  * the view
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwPagePreViewWin::Scroll(long nXMove, long nYMove)
//STRIP001 {
//STRIP001     maPaintedPreviewDocRect.Move(nXMove, nYMove);
//STRIP001     mpPgPrevwLayout->Prepare( 0, maPaintedPreviewDocRect.TopLeft(),
//STRIP001                               maPxWinSize, mnSttPage,
//STRIP001                               maPaintedPreviewDocRect );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SwPagePreView::HandleWheelCommands( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	BOOL bOk = FALSE;
//STRIP001 	const CommandWheelData* pWData = rCEvt.GetWheelData();
//STRIP001 	if( pWData && COMMAND_WHEEL_ZOOM == pWData->GetMode() )
//STRIP001 	{
//STRIP001         if(!Application::GetSettings().GetMiscSettings().GetEnableATToolSupport())
//STRIP001         {
//STRIP001             USHORT nFactor = GetViewShell()->GetViewOptions()->GetZoom();
//STRIP001             const USHORT nOffset = 10;
//STRIP001             if( 0L > pWData->GetDelta() )
//STRIP001             {
//STRIP001                 nFactor -= nOffset;
//STRIP001                 if(nFactor < MIN_PREVIEW_ZOOM)
//STRIP001                         nFactor = MIN_PREVIEW_ZOOM;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 nFactor += nOffset;
//STRIP001                 if(nFactor > MAX_PREVIEW_ZOOM)
//STRIP001                         nFactor = MAX_PREVIEW_ZOOM;
//STRIP001             }
//STRIP001             SetZoom(SVX_ZOOM_PERCENT, nFactor);
//STRIP001         }
//STRIP001 		bOk = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001         bOk = aViewWin.HandleScrollCommand( rCEvt, pHScrollbar, pVScrollbar );
//STRIP001 	return bOk;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible>
//STRIP001     SwPagePreViewWin::CreateAccessible()
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());	// this should have
//STRIP001 														// happend already!!!
//STRIP001 
//STRIP001     DBG_ASSERT( GetViewShell() != NULL, "We need a view shell" );
//STRIP001     return GetViewShell()->CreateAccessiblePreview();
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------------------06.05.2002 13:18------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwPagePreView::ApplyAccessiblityOptions(SvtAccessibilityOptions& rAccessibilityOptions)
//STRIP001 {
//STRIP001     GetViewShell()->ApplyAccessiblityOptions(rAccessibilityOptions);
//STRIP001 }
//STRIP001 /* -----------------------------2002/06/26 14:30------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwPagePreView::ShowHScrollbar(sal_Bool bShow)
//STRIP001 {
//STRIP001     pHScrollbar->Show(bShow);
//STRIP001 	InvalidateBorder();
//STRIP001 }
//STRIP001 /* -----------------------------2002/06/26 14:30------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool SwPagePreView::IsHScrollbarVisible()const
//STRIP001 {
//STRIP001     return     pVScrollbar->IsVisible();
//STRIP001 }
//STRIP001 /* -----------------------------2002/06/26 14:30------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwPagePreView::ShowVScrollbar(sal_Bool bShow)
//STRIP001 {
//STRIP001     pVScrollbar->Show(bShow);
//STRIP001 	InvalidateBorder();
//STRIP001 }
//STRIP001 /* -----------------------------2002/06/26 14:30------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool SwPagePreView::IsVScrollbarVisible()const
//STRIP001 {
//STRIP001     return pVScrollbar->IsVisible();
//STRIP001 }
//STRIP001 /* -----------------25.11.2002 16:36-----------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwPagePreView::SetZoom(SvxZoomType eType, USHORT nFactor)
//STRIP001 {
//STRIP001     ViewShell& rSh = *GetViewShell();
//STRIP001     SwViewOption aOpt(*rSh.GetViewOptions());
//STRIP001     // OD 16.12.2002 #103492# - perform action only on changes of zoom or zoom type.
//STRIP001     if ( aOpt.GetZoom() != nFactor ||
//STRIP001          aOpt.GetZoomType() != eType )
//STRIP001     {
//STRIP001         aOpt.SetZoom(nFactor);
//STRIP001         aOpt.SetZoomType(eType);
//STRIP001         rSh.ApplyViewOptions( aOpt );
//STRIP001         lcl_InvalidateZoomSlots(GetViewFrame()->GetBindings());
//STRIP001         // OD 02.12.2002 #103492#
//STRIP001         aViewWin.AdjustPreviewToNewZoom( nFactor );
//STRIP001         ScrollViewSzChg();
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /** adjust position of vertical scrollbar
//STRIP001 
//STRIP001     OD 19.02.2003 #107369
//STRIP001 
//STRIP001     @author OD
//STRIP001 */
//STRIP001 void SwPagePreView::SetVScrollbarThumbPos( const sal_uInt16 _nNewThumbPos )
//STRIP001 {
//STRIP001     if ( pVScrollbar )
//STRIP001     {
//STRIP001         pVScrollbar->SetThumbPos( _nNewThumbPos );
//STRIP001     }
//STRIP001 }
}
