/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dbdefobj.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:45:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_DBDEFOBJ_HXX
#define _SBA_DBDEFOBJ_HXX

#include "dbobj.hxx"

#ifndef _SBA_DBOBJENU_HXX
#include "dbobjenu.hxx"
#endif

#ifndef _SFXLSTNER_HXX //autogen
#include <svtools/lstner.hxx>
#endif

#ifndef _SDB_SDBSTOR_HXX //autogen
#include <sdb/sdbstor.hxx>
#endif
class SfxPoolItem; 
namespace binfilter {

#define EXPLORER_EXCHANGE	0x0001
#define RTF_EXCHANGE		0x0002
#define HTML_EXCHANGE		0x0003

class SbaDataExchObj;
class SbaExplorerExchObj;
 

//==================================================================
// SbaDBDef
//==================================================================
class SbaDBDef : public SbaDBObj, public SfxListener
{
	friend class SbaDatabase;
	friend class SbaDBDataDefDocSh;
	friend class SbaFileDefDocSh;

protected:
	DBObject				edbObj;
	unsigned char			aLockCounter;	// Object zu schreiben gesperrt
	SdbStorageRef			aDBStor;

public:
	TYPEINFO();
	SbaDBDef(SbaDatabase* pDB,
			 const String& rName,
			 DBObject eObj,
			 BOOL _bNew = TRUE,
			 BOOL _bShow = TRUE);

	virtual	~SbaDBDef();

	// Zugriff auf den Vater, geht nur wenn Objekt geoeffnet
	virtual SbaDatabase* GetDatabase() const;

	// Ist das Object bereits zum Update (Aendern der Definition) geffnet worden?
	BOOL    IsLocked() const {return (aLockCounter > 0);}
	virtual BOOL SetLock(BOOL _bLocked);
	inline 	BOOL Lock() {return SetLock(TRUE);}
	inline  BOOL UnLock() {return SetLock(FALSE);}

	DBObject GetKind()		const {return edbObj;}

	virtual BOOL OpenDoc(BOOL bReadOnly, const SfxPoolItem *pArg1, ... );
	virtual BOOL Drop();
	virtual BOOL Rename(const String& rNewName);
	virtual String ToURL() const;
	virtual SbaDataExchObj* CreateDataExchObj( USHORT nType, const String& rExchStr = String() );

	// reversibles Loeschen
	virtual BOOL DropReversible();
		// Loeschen mit Hilfe des DeleteObject an der Datenbank

	// kann die Definition freigegeben werden
	virtual BOOL CanRelease();

	static String ToURL(const String& rDBName, DBObject eKind, const String& rName);
	static SbaDataExchObj* CreateDataExchObj(USHORT nType, SbaDatabase* pDB, DBObject eKind,
		const String& rName);

protected:
	virtual void SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
							const SfxHint& rHint, const TypeId& rHintType);

	virtual void Close();
	virtual void OnCreate();
	virtual BOOL DropImpl() = 0;
	virtual BOOL RenameImpl(const String& rNewName) = 0;
	virtual BOOL Compare(const SdbObj&) const;

	virtual BOOL DropReversibleImpl();

	// Zugriff auf die SDB-Datenbank
	BOOL BeginTrans(BOOL bForStore);
	BOOL EndTrans(BOOL bCommit = FALSE);
	BOOL Commit() {return EndTrans(TRUE);}
	BOOL Rollback(){return EndTrans(FALSE);}

	static ULONG CopyTo(SvStream& rTarget, SvStream& rDest);
};

SV_DECL_IMPL_REF(SbaDBDef);

#if _SOLAR__PRIVATE

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

#include "sbadb.hxx"

class SbaDBDefItem : public SfxPoolItem
{
	SbaDatabaseRef	xDatabase;
	SbaDBDefRef		xDBDef;

public:
	TYPEINFO();
	SbaDBDefItem( USHORT nWhich ):SfxPoolItem(nWhich){}
	SbaDBDefItem( USHORT nWhich, SbaDBDef* pDef = NULL, SbaDatabase* pDB = NULL)
		:SfxPoolItem(nWhich),xDBDef(pDef),xDatabase(pDB){};
	SbaDatabase* GetDatabase() const {return &xDatabase;}
	SbaDBDef* GetDBDef() const {return &xDBDef;}
	virtual int operator==( const SfxPoolItem& ) const;
	virtual SfxPoolItem* Clone( SfxItemPool *pPool = 0) const;
};

#endif

} //namespace binfilter
#endif

