/*
 * Copyright (C) 2014 by Daniel Molkentin <danimo@owncloud.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 */

#ifndef MIRALL_AUTHENTICATIONDIALOG_H
#define MIRALL_AUTHENTICATIONDIALOG_H

#include <QDialog>

class QLineEdit;

namespace Mirall {

/** @brief Authenticate a user for a specific credential given his credentials */
class AuthenticationDialog : public QDialog {
    Q_OBJECT
public:
    AuthenticationDialog(const QString &realm, const QString &domain, QWidget *parent = 0);

    QString user() const;
    QString password() const;

private:
    QLineEdit *_user;
    QLineEdit *_password;

};


} // namespace Mirall

#endif // MIRALL_AUTHENTICATIONDIALOG_H
