<?php
/** 
*
* common [Vietnamese]
*
* @package language
* @version $Id: common.php 135 2009-05-07 17:49:00Z nedka $
* @copyright (c) 2006 nedka (Nguyen Dang Khoa)
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*
* Vietnamese Language Pack for phpBB3
*
* phpBB iVN (phpBB in Vietnamese) Project
* Translated by nedka (Nguyen Dang Khoa) - http://www.vinabb.com/
* Submited to phpBB3.0.5 June 24,2009 - http://phpbasic.com/
* Submited to phpBB3.0.5 June 24,2009 - http://phpbasic.com/
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Vietnamese translation', // Please do not edit or remove my copyright
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|', // 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'vi',

	'1_DAY'		=> '1 ngày',
	'1_MONTH'	=> '1 tháng',
	'1_YEAR'	=> '1 năm',
	'2_WEEKS'	=> '2 tuần',
	'3_MONTHS'	=> '3 tháng',
	'6_MONTHS'	=> '6 tháng',
	'7_DAYS'	=> '7 ngày',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Tài khoản của bạn vừa được kích hoạt.',
	'ACCOUNT_DEACTIVATED'			=> 'Tài khoản của bạn đã bị ngưng kích hoạt và chỉ có thể được kích hoạt trở lại bởi một quản trị viên.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Tài khoản của bạn chưa được kích hoạt.',
	'ACP'							=> 'Bảng quản trị viên',
	'ACTIVE'						=> 'có hiệu lực',
	'ACTIVE_ERROR'					=> 'Tên thành viên đã chọn hiện tại chưa được kích hoạt. Nếu bạn gặp rắc rối trong việc kích hoạt tài khoản của mình, hãy liên hệ với người quản trị.',
	'ADMINISTRATOR'					=> 'Quản trị viên',
	'ADMINISTRATORS'				=> 'Quản trị viên',
	'AGE'							=> 'Tuổi',	
	'AIM'							=> 'Tài khoản AIM',
	'ALLOWED'						=> 'Đã cho phép',
	'ALL_FILES'						=> 'Tất cả tập tin',
	'ALL_FORUMS'					=> 'Tất cả chuyên mục',
	'ALL_MESSAGES'					=> 'Tất cả tin nhắn',
	'ALL_POSTS'						=> 'Tất cả bài viết',
	'ALL_TIMES'						=> 'Múi giờ %1$s %2$s',
	'ALL_TOPICS'					=> 'Tất cả chủ đề',
	'AND'							=> 'Và',
	'ARE_WATCHING_FORUM'			=> 'Bạn đã đồng ý nhận thông báo về các bài viết mới trong chuyên mục này.',
	'ARE_WATCHING_TOPIC'			=> 'Bạn đã đồng ý nhận thông báo về các bài viết mới trong chủ đề này.',
	'ASCENDING'						=> 'Tăng dần',
	'ATTACHMENTS'					=> 'Tập tin đính kèm',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Tập tin hình ảnh mà bạn đã cố gắng đính kèm không hợp lệ.',
	'AUTHOR'						=> 'Người gửi',
	'AUTH_NO_PROFILE_CREATED'		=> 'Quá trình tạo một thông tin cá nhân đã thất bại.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Hình bạn vừa tải lên bị từ chối bởi vì nội dung tập tin này đã được xác định có mục đích tấn công hệ thống.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Tập tin này không thể được hiển thị bởi vì loại tập tin <strong>%s</strong> không được phép sử dụng.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Tập tin hình đại diện bạn vừa tải lên bị rỗng.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Hình đại diện vừa chọn không thể tải lên được bởi vì tập tin từ địa chỉ URL mà bạn đã xác định không hợp lệ hoặc đã bị hỏng.',
	'AVATAR_INVALID_FILENAME'		=> '<strong>%s</strong> là tên tập tin hình đại diện không hợp lệ.',
	'AVATAR_NOT_UPLOADED'			=> 'Không thể tải lên hình đại diện.',
	'AVATAR_NO_SIZE'				=> 'Chiều rộng hoặc chiều cao của hình đại diện liên kết không thể xác định được. Bạn hãy vui lòng tự nhập kích thước của hình.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Hình đại diện đã chọn chỉ được tải lên một phần và chưa hoàn chỉnh.',
	'AVATAR_PHP_SIZE_NA'			=> 'Dung lượng tập tin của hình đại diện quá lớn.<br />Dung lượng tối đa cho phép xác lập bởi tập tin <samp>php.ini</samp> không thể xác định được.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Dung lượng tập tin của hình đại diện quá lớn. Dung lượng tập tin tối đa được phép tải lên là %1$d %2$s.<br />Bạn cần lưu ý rằng dung lượng tối đa này được xác lập bởi tập tin <samp>php.ini</samp> và không thể thay thế.',
	'AVATAR_URL_INVALID'			=> 'Địa chỉ URL bạn vừa nhập không hợp lệ.',
	'AVATAR_URL_NOT_FOUND'			=> 'Tập tin bạn vừa nhập không thể tìm thấy.',
	'AVATAR_WRONG_FILESIZE'			=> 'Dung lượng tập tin hình đại diện phải từ <strong>0</strong> đến <strong>%1d</strong> %2s.',
	'AVATAR_WRONG_SIZE'				=> 'Kích thước hình đại diện vừa chọn rộng <strong>%5$d</strong> Pixel và cao <strong>%6$d</strong> Pixel. Kích thước hình đại diện phải rộng ít nhất <strong>%1$d</strong> Pixel và cao ít nhất <strong>%2$d</strong> Pixel cũng như không được phép rộng quá <strong>%3$d</strong> Pixel và cao quá <strong>%4$d</strong> Pixel.',

	'BACK_TO_TOP'				=> 'Đầu trang',
	'BACK_TO_PREV'				=> 'Quay về trang trước',
	'BAN_TRIGGERED_BY_EMAIL'	=> 'Địa chỉ email của bạn đã bị cấm.',
	'BAN_TRIGGERED_BY_IP'		=> 'Địa chỉ IP của bạn đã bị cấm.',
	'BAN_TRIGGERED_BY_USER'		=> 'Tên thành viên của bạn đã bị cấm.',
	'BBCODE_GUIDE'				=> 'Tài liệu hướng dẫn sử dụng BBCode',
	'BCC'						=> 'Đồng gửi',
	'BIRTHDAYS'					=> 'Sinh nhật',
	'BOARD_BAN_PERM'			=> 'Bạn đã bị cấm tham gia vào diễn đàn.<br /><br />Hãy liên hệ với %2$sngười quản trị%3$s để biết thêm thông tin.',
	'BOARD_BAN_REASON'			=> 'Nguyên nhân dẫn đến việc bạn bị cấm tham gia là: <strong>%s</strong>',
	'BOARD_BAN_TIME'			=> 'Bạn đã bị cấm tham gia vào diễn đàn cho đến ngày <strong>%1$s</strong>.<br /><br />Hãy liên hệ với %2$sngười quản trị%3$s để biết thêm thông tin.',
	'BOARD_DISABLE'				=> 'Xin lỗi, hệ thống hiện tại không thể hoạt động được.',
	'BOARD_DISABLED'			=> 'Hệ thống hiện tại ngưng hoạt động.',	
	'BOARD_UNAVAILABLE'			=> 'Xin lỗi, hệ thống tạm thời không thể hoạt động được. Bạn hãy vui lòng quay lại sau vài phút nữa.',
	'BROWSING_FORUM'			=> 'Đang xem chuyên mục này: %1$s',
	'BROWSING_FORUM_GUEST'		=> 'Đang xem chuyên mục này: <strong>%1$s</strong> và <strong>%2$d</strong> khách.',
	'BROWSING_FORUM_GUESTS'		=> 'Đang xem chuyên mục này: <strong>%1$s</strong> và <strong>%2$d</strong> khách.',
	'BYTES'						=> 'Byte',

	'CANCEL'				=> 'Huỷ bỏ',
	'CHANGE'				=> 'Thay đổi',
	'CHANGE_FONT_SIZE'		=> 'Chỉnh kích thước phông chữ',
	'CHANGING_PREFERENCES'	=> 'Đang thay đổi thiết lập hệ thống',
	'CHANGING_PROFILE'		=> 'Đang thay đổi thiết lập cá nhân',
	'CLICK_VIEW_PRIVMSG'	=> '%sChuyển đến hộp tin nhận của bạn%s',	
	'COLLAPSE_VIEW'			=> 'Xem thu gọn',	
	'CLOSE_WINDOW'			=> 'Đóng cửa sổ',
	'COLOUR_SWATCH'			=> 'Bảng mã màu',
	'COMMA_SEPARATOR'		=> ', ', // Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Xác nhận',
	'CONFIRM_CODE'			=> 'Mã xác nhận',
	'CONFIRM_CODE_EXPLAIN'	=> 'Nhập vào đoạn mã xác nhận mà bạn thực sự nhìn thấy trong hình. Tất cả chữ cái đều không phân biệt hoa thường và không có số <strong>O</strong>.',
	'CONFIRM_CODE_WRONG'	=> 'Mã xác nhận bạn vừa nhập không chính xác.',
	'CONFIRM_OPERATION'		=> 'Bạn có chắc chắn muốn thực hiện yêu cầu này?',
	'CONGRATULATIONS'		=> 'Chúc mừng sinh nhật đến',
	'CONNECTION_FAILED'		=> 'Kết nối thất bại!',
	'CONNECTION_SUCCESS'	=> 'Kết nối thành công!',
	'COOKIES_DELETED'		=> 'Tất cả cookie đã được xóa thành công.',
	'CURRENT_TIME'			=> 'Hôm nay, %s',

	'DAY'					=> 'Ngày',
	'DAYS'					=> 'Ngày',
	'DELETE'				=> 'Xóa',
	'DELETE_ALL'			=> 'Xóa tất cả',
	'DELETE_COOKIES'		=> 'Xóa hết cookie',
	'DELETE_MARKED'			=> 'Xóa đánh dấu',
	'DELETE_POST'			=> 'Xóa bài viết',
	'DELIMITER'				=> 'Dấu phân cách',
	'DESCENDING'			=> 'Giảm dần',
	'DISABLED'				=> 'Vô hiệu',
	'DISPLAY'				=> 'Hiển thị',
	'DISPLAY_GUESTS'		=> 'Hiển thị khách',
	'DISPLAY_MESSAGES'		=> 'Hiển thị tin nhắn cách đây',
	'DISPLAY_POSTS'			=> 'Hiển thị bài viết cách đây',
	'DISPLAY_TOPICS'		=> 'Hiển thị chủ đề cách đây',
	'DOWNLOADED'			=> 'Lượt tải về',
	'DOWNLOADING_FILE'		=> 'Đang tải về tập tin',
	'DOWNLOAD_COUNT'		=> 'Đã tải về <strong>%d</strong> lần.',
	'DOWNLOAD_COUNTS'		=> 'Đã tải về <strong>%d</strong> lần.',
	'DOWNLOAD_COUNT_NONE'	=> 'Chưa tải về lần nào.',
	'VIEWED_COUNT'			=> 'Đã xem <strong>%d</strong> lần.',
	'VIEWED_COUNTS'			=> 'Đã xem <strong>%d</strong> lần.',
	'VIEWED_COUNT_NONE'		=> 'Chưa xem lần nào.',

	'EDIT_POST'							=> 'Sửa bài viết',
	'EMAIL'								=> 'Gửi email', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Địa chỉ email',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Có rắc rối xảy ra trong quá trình gửi email tại <strong>dòng %1$s</strong>. Nguyên nhân: %2$s.',
	'EMPTY_SUBJECT'						=> 'Bạn phải nhập tiêu đề cho chủ đề mới.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Bạn phải nhập tiêu đề cho tin nhắn mà mình muốn gửi.',
	'ENABLED'							=> 'Bật',
	'ENCLOSURE'							=> 'Đính kèm',
	'ERR_CHANGING_DIRECTORY'			=> 'Không thể thay đổi thư mục.',
	'ERR_CONNECTING_SERVER'				=> 'Có lỗi xảy ra trong khi kết nối đến máy chủ.',
	'ERR_JAB_AUTH'						=> 'Không thể xác thực trên máy chủ Jabber.',
	'ERR_JAB_CONNECT'					=> 'Không thể kết nối đến máy chủ Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Tên thành viên hoặc mật khẩu đã nhập không chính xác.',	
	'ERR_UNWATCHING'					=> 'Có một lỗi xảy ra trong quá trình chọn ngừng theo dõi.',
	'ERR_WATCHING'						=> 'Có một lỗi xảy ra trong quá trình chọn theo dõi.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Đường dẫn đến hệ thống phpBB vừa nhập dường như không hợp lệ.',
	'EXPAND_VIEW'						=> 'Xem toàn bộ',
	'EXTENSION'							=> 'Loại tập tin',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Loại tập tin <strong>%s</strong> không còn được phép sử dụng và vì thế sẽ không hiển thị.',

	'FAQ'					=> 'Trợ giúp',
	'FAQ_EXPLAIN'			=> 'Những câu hỏi thường gặp',
	'FILENAME'				=> 'Tên tập tin',
	'FILESIZE'				=> 'Dung lượng tập tin',
	'FILEDATE'				=> 'Ngày cập nhật tập tin',
	'FILE_COMMENT'			=> 'Chú thích tập tin',
	'FILE_NOT_FOUND'		=> 'Không thể tìm thấy tập tin bạn yêu cầu.',
	'FIND_USERNAME'			=> 'Tìm một thành viên',
	'FOLDER'				=> 'Thư mục',
	'FORGOT_PASS'			=> 'Quên mật khẩu',
	'FORM_INVALID'			=> 'Mẫu dữ liệu bạn vừa gửi không hợp lệ. Hãy vui lòng thử lại.',
	'FORUM'					=> 'Chuyên mục',
	'FORUMS'				=> 'Chuyên mục',
	'FORUMS_MARKED'			=> 'Tất cả chuyên mục đã được đánh dấu xem rồi.',
	'FORUM_CAT'				=> 'Diễn đàn',
	'FORUM_INDEX'			=> 'Trang chủ',
	'FORUM_LINK'			=> 'Chuyên mục liên kết',
	'FORUM_LOCATION'		=> 'Vị trí chuyên mục',
	'FORUM_LOCKED'			=> 'Chuyên mục đã khóa',
	'FORUM_RULES'			=> 'Nội qui chuyên mục',
	'FORUM_RULES_LINK'		=> 'Bấm vào đây để xem những nội qui của chuyên mục này',
	'FROM'					=> 'từ',
	'FSOCK_DISABLED'		=> 'Yêu cầu này không thể được hoàn tất vì hàm <var>fsockopen</var> đã bị vô hiệu hoặc địa chỉ của máy chủ được truy xuất trong yêu cầu không thể tìm thấy.',

	'FTP_FSOCK_HOST'				=> 'Địa chỉ FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Địa chỉ máy chủ FTP được sử dụng để kết nối đến hệ thống của bạn.',
	'FTP_FSOCK_PASSWORD'			=> 'Mật khẩu FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Mật khẩu đăng nhập tài khoản FTP.',
	'FTP_FSOCK_PORT'				=> 'Cổng FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Cổng được sử dụng để kết nối đến máy chủ FTP của bạn.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Đường dẫn đến thư mục cài đặt hệ thống',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Đường dẫn đến thư mục chính nơi mà bạn cài đặt hệ thống này.',
	'FTP_FSOCK_TIMEOUT'				=> 'Thời gian kết nối FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Số giây tối đa hệ thống chờ đợi trong khi kết nối đến máy chủ FTP của bạn.',
	'FTP_FSOCK_USERNAME'			=> 'Tên đăng nhập tài khoản FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Tên đăng nhập vào tài khoản FTP trên máy chủ của bạn.',

	'FTP_HOST'					=> 'Địa chỉ FTP',
	'FTP_HOST_EXPLAIN'			=> 'Địa chỉ máy chủ FTP được sử dụng để kết nối đến hệ thống của bạn.',
	'FTP_PASSWORD'				=> 'Mật khẩu đăng nhập tài khoản FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Mật khẩu dùng cho tên đăng nhập tài khoản FTP.',
	'FTP_PORT'					=> 'Cổng FTP',
	'FTP_PORT_EXPLAIN'			=> 'Cổng FTP được sử dụng để kết nối đến máy chủ của bạn.',
	'FTP_ROOT_PATH'				=> 'Đường dẫn đến thư mục cài đặt hệ thống',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Đường dẫn đến thư mục chính nơi mà bạn cài đặt hệ thống này.',
	'FTP_TIMEOUT'				=> 'Thời gian kết nối FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Số giây tối đa hệ thống chờ đợi trong khi kết nối đến máy chủ FTP của bạn.',
	'FTP_USERNAME'				=> 'Tên đăng nhập tài khoản FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Tên đăng nhập vào tài khoản FTP trên máy chủ của bạn.',

	'GENERAL_ERROR'				=> 'Lỗi tổng quát',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Chuyển',
	'GOTO_PAGE'					=> 'Chuyển đến trang',
	'GROUP'						=> 'Nhóm',
	'GROUPS'					=> 'Nhóm',
	'GROUP_ERR_TYPE'			=> 'Bạn đã xác định loại nhóm không thích hợp.',
	'GROUP_ERR_USERNAME'		=> 'Không có tên nhóm nào được xác định.',
	'GROUP_ERR_USER_LONG'		=> 'Tên của nhóm không được vượt quá <strong>60</strong> ký tự. Tên nhóm bạn vừa nhập quá dài.',
	'GUEST'						=> 'Khách',
	'GUEST_USERS_ONLINE'		=> 'Có <strong>%d</strong> khách trực tuyến.',
	'GUEST_USERS_TOTAL'			=> '<strong>%d</strong> khách',
	'GUEST_USERS_ZERO_ONLINE'	=> '<strong>0</strong> khách trực tuyến.',
	'GUEST_USERS_ZERO_TOTAL'	=> '<strong>0</strong> khách',
	'GUEST_USER_ONLINE'			=> '<strong>%d</strong> khách trực tuyến.',
	'GUEST_USER_TOTAL'			=> '<strong>%d</strong> khách',
	'G_ADMINISTRATORS'			=> 'Quản trị viên',
	'G_BOTS'					=> 'Máy tìm kiếm',
	'G_GUESTS'					=> 'Khách',
	'G_REGISTERED'				=> 'Thành viên',
	'G_REGISTERED_COPPA'		=> 'Thành viên theo điều khoản COPPA',
	'G_GLOBAL_MODERATORS'		=> 'Điều hành viên chính',

	'HIDDEN_USERS_ONLINE'			=> '<strong>%d</strong> thành viên ẩn trực tuyến',
	'HIDDEN_USERS_TOTAL'			=> '<strong>%d</strong> thành viên ẩn',
	'HIDDEN_USERS_TOTAL_AND'		=> '<strong>%d</strong> thành viên ẩn và ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '<strong>0</strong> thành viên ẩn trực tuyến',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '<strong>0</strong> thành viên ẩn',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '<strong>0</strong> thành viên ẩn và ',
	'HIDDEN_USER_ONLINE'			=> '<strong>%d</strong> thành viên ẩn trực tuyến',
	'HIDDEN_USER_TOTAL'				=> '<strong>%d</strong> thành viên ẩn',
	'HIDDEN_USER_TOTAL_AND'			=> '<strong>%d</strong> thành viên ẩn và ',
	'HIDE_GUESTS'					=> 'Không hiển thị khách',
	'HIDE_ME'						=> 'Ẩn trạng thái trực tuyến trong phiên đăng nhập này',
	'HOURS'							=> 'Giờ',
	'HOME'							=> 'Trang chủ',

	'ICQ'						=> 'Tài khoản ICQ',
	'ICQ_STATUS'				=> 'Trạng thái ICQ',
	'IF'						=> 'Nếu',
	'IMAGE'						=> 'Hình ảnh',
	'IMAGE_FILETYPE_INVALID'	=> 'Loại tập tin hình ảnh “%d” trong nhóm tập tin “%s” không được hỗ trợ.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Loại tập tin hình ảnh không phù hợp: đuôi tập tin mở rộng khai báo là “%1$s” nhưng thực sự lại là “%2$s”.',
	'IN'						=> 'trong',
	'INDEX'						=> 'Trang chủ',
	'INFORMATION'				=> 'Thông tin',
	'INTERESTS'					=> 'Sở thích',
	'INVALID_DIGEST_CHALLENGE'	=> 'Giao thức yêu cầu ký số không hợp lệ.',	
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> có lẽ là một địa chỉ email không hợp lệ?',
	'IP'						=> 'Địa chỉ IP',
	'IP_BLACKLISTED'			=> 'Địa chỉ IP của bạn <strong>%1$s</strong> đã bị chặn bởi vì nó có trong danh sách cấm. Để biết thêm chi tiết, hãy vui lòng xem tại đây <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Tài khoản Jabber',
	'JOINED'				=> 'Ngày tham gia',
	'JUMP_PAGE'				=> 'Nhập số trang bạn muốn chuyển đến',
	'JUMP_TO'				=> 'Chuyển đến',
	'JUMP_TO_PAGE'			=> 'Bấm vào đây để chuyển đến trang…',

	'KB'	=> 'KB',
	'KIB'	=> 'KiB',

	'LAST_POST'							=> 'Bài viết sau cùng',
	'LAST_UPDATED'						=> 'Cập nhật',
	'LAST_VISIT'						=> 'Lần ghé thăm trước',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Ứng dụng mở rộng LDAP không có sẵn.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Không thể kết nối đến máy chủ LDAP.',	
	'LEGEND'							=> 'Chú thích',
	'LOCATION'							=> 'Đến từ',
	'LOCK_POST'							=> 'Khóa bài viết',
	'LOCK_POST_EXPLAIN'					=> 'Không cho phép sửa bài viết',
	'LOCK_TOPIC'						=> 'Khóa chủ đề',
	'LOGIN'								=> 'Đăng nhập',
	'LOGIN_CHECK_PM'					=> 'Đăng nhập để kiểm tra tin nhắn của bạn.',
	'LOGIN_CONFIRMATION'				=> 'Xác nhận đăng nhập',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Để bảo vệ các tài khoản thành viên trong hệ thống, chúng tôi yêu cầu bạn phải nhập vào một đoạn mã xác nhận nếu bạn đăng nhập thất bại vượt quá số lần cho phép. Đoạn mã được hiển thị trong hình mà bạn nhìn thấy bên dưới. Nếu thị lực của bạn kém hoặc bạn không thể nhìn thấy đoạn mã này vì một lý do nào đó, hãy vui lòng liên hệ với %sngười quản trị%s.',
	'LOGIN_ERROR_ATTEMPTS'				=> 'Bạn đã đăng nhập thất bại vượt quá số lần cho phép. Nếu muốn tiếp tục đăng nhập, bây giờ, ngoài tên thành viên và mật khẩu của mình, bạn còn phải nhập vào đoạn mã xác nhận trong hình bên dưới mà bạn nhìn thấy.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Bạn không được xác thực bởi <strong>Apache</strong>.',
	'LOGIN_ERROR_PASSWORD'				=> 'Bạn đã nhập mật khẩu không chính xác. Hãy vui lòng kiểm tra lại mật khẩu của mình. Nếu bạn vẫn còn gặp rắc rối này, hãy liên hệ với %sngười quản trị%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Hệ thống mới không thể chuyển đổi mật khẩu của bạn trong khi cập nhật từ hệ thống cũ. Bạn hãy vui lòng %syêu cầu một mật khẩu mới%s. Nếu bạn vẫn còn gặp rắc rối này, hãy liên hệ với %sngười quản trị%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Bạn đã nhập tên thành viên không chính xác. Hãy vui lòng kiểm tra lại tên thành viên của bạn. Nếu bạn vẫn còn gặp rắc rối này, hãy liên hệ với %sngười quản trị%s.',
	'LOGIN_FORUM'						=> 'Để xem hoặc gửi bài trong chuyên mục này, bạn phải nhập vào mật khẩu.',
	'LOGIN_INFO'						=> 'Để đăng nhập vào hệ thống, bạn phải có tài khoản thành viên đã đăng ký. Việc đăng ký chỉ tốn mất của bạn một chút thời gian nhưng bù lại bạn có thể sử dụng đầy đủ công cụ và chức năng trong hệ thống dành cho thành viên. Quản trị viên có thể thay đổi quyền hạn của những thành viên đã đăng ký. Trước khi tiến hành đăng ký, hãy chắc chắn rằng bạn đã biết rõ về những điều khoản của chúng tôi và các chính sách có liên quan khác. Bạn cũng phải chắc chắn rằng đã đọc kỹ nội qui riêng của từng chuyên mục trong diễn đàn.',
	'LOGIN_VIEWFORUM'					=> 'Bạn phải đăng nhập để xem chuyên mục này.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Bạn phải đăng nhập vào hệ thống mới có thể sửa các bài viết trong chuyên mục này.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Bạn phải đăng nhập vào hệ thống mới có thể xem danh sách những ai trực tuyến.',
	'LOGOUT'							=> 'Thoát',
	'LOGOUT_USER'						=> 'Thoát [ %s ]',
	'LOG_ME_IN'							=> 'Đăng nhập tự động mỗi lần ghé thăm',
	
	'MARK'					=> 'Chọn',
	'MARK_ALL'				=> 'Chọn tất cả',
	'MARK_FORUMS_READ'		=> 'Đánh dấu đã xem tất cả chuyên mục',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Bảng điều hành viên',
	'MEMBERLIST'			=> 'Thành viên',
	'MEMBERLIST_EXPLAIN'	=> 'Xem toàn bộ danh sách thành viên',
	'MERGE'					=> 'Nhập chung',
	'MERGE_POSTS'			=> 'Nhập chung bài viết',
	'MERGE_TOPIC'			=> 'Nhập chung chủ đề',
	'MESSAGE'				=> 'Nội dung',
	'MESSAGES'				=> 'Tin nhắn',
	'MESSAGE_BODY'			=> 'Phần nội dung',
	'MINUTES'				=> 'Phút',
	'MODERATE'				=> 'Quản lí',
	'MODERATOR'				=> 'Điều hành viên',
	'MODERATORS'			=> 'Điều hành viên',
	'MONTH'					=> 'Tháng',
	'MOVE'					=> 'Di chuyển',
	'MSNM'					=> 'Tài khoản MSNM/WLM',

	'NA'						=> 'Không thể',
	'NEWEST_USER'				=> 'Thành viên mới nhất: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Tin nhắn mới',
	'NEW_MESSAGES'				=> 'Tin nhắn mới',
	'NEW_PM'					=> '<strong>%d</strong> tin nhắn mới',
	'NEW_PMS'					=> '<strong>%d</strong> tin nhắn mới',
	'NEW_POST'					=> 'Bài viết mới',
	'NEW_POSTS'					=> 'Bài viết mới',
	'NEXT'						=> 'Trang kế tiếp', // Used in pagination
	'NEXT_STEP'					=> 'Bước kế tiếp',
	'NEVER'						=> 'Chu bao giờ',	
	'NO'						=> 'Không',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Bạn không được phép quản lí nhóm này.',
	'NOT_AUTHORISED'			=> 'Bạn không được phép truy cập khu vực này.',
	'NOT_WATCHING_FORUM'		=> 'Bạn đã chọn không nhận thông báo về các bài viết mới trong chuyên mục này nữa.',
	'NOT_WATCHING_TOPIC'		=> 'Bạn đã chọn không nhận thông báo về các bài viết mới trong chủ đề này nữa.',
	'NOTIFY_ADMIN'				=> 'Bạn hãy vui lòng thông báo cho quản trị viên hoặc người chủ của website này.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Bạn hãy vui lòng thông báo cho quản trị viên hoặc người chủ của website này: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Bạn không được phép truy cập tập tin này.',
	'NO_ACTION'					=> 'Yêu cầu không xác định!',
	'NO_ADMINISTRATORS'			=> 'Không có quản trị viên nào.',
	'NO_AUTH_ADMIN'				=> 'Bạn không được phép truy cập vào bảng quản trị viên bởi vì bạn không có quyền hạn của người quản trị.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Bạn không thể xác nhận lại như là một thành viên khác.',
	'NO_AUTH_OPERATION'			=> 'Bạn không được cấp phép đầy đủ để hoàn tất yêu cầu này.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Không thể kết nối đến địa chỉ SMTP: %1$s : %2$s',	
	'NO_BIRTHDAYS'				=> 'Không có sinh nhật của thành viên nào hôm nay.',
	'NO_EMAIL_MESSAGE'			=> 'Bạn chưa nhập nội dung email.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Không nhận được phản hồi từ máy chủ gửi Mail.',
	'NO_EMAIL_SUBJECT'			=> 'Bạn chưa nhập tiêu đề cho email.',	
	'NO_FORUM'					=> 'Chuyên mục vừa chọn không tồn tại.',
	'NO_FORUMS'					=> 'Diễn đàn này không có chuyên mục nào.',
	'NO_GROUP'					=> 'Nhóm bạn vừa yêu cầu không tồn tại.',
	'NO_GROUP_MEMBERS'			=> 'Nhóm này hiện tại chưa có thành viên nào tham gia.',
	'NO_IPS_DEFINED'			=> 'Không có địa chỉ IP hoặc tên miền nào được chỉ định',
	'NO_MEMBERS'				=> 'Không tìm thấy thành viên nào thỏa điều kiện tìm kiếm này.',
	'NO_MESSAGES'				=> 'Không có tin nhắn nào',
	'NO_MODE'					=> 'Chế độ không xác định!',
	'NO_MODERATORS'				=> 'Không có điều hành viên nào.',	
	'NO_NEW_MESSAGES'			=> 'Không có tin nhắn mới',
	'NO_NEW_PM'					=> '<strong>0</strong> tin nhắn mới',
	'NO_NEW_POSTS'				=> 'Không có bài viết mới',
	'NO_ONLINE_USERS'			=> 'Không có thành viên nào trực tuyến.',
	'NO_POSTS'					=> 'Không có bài viết nào',
	'NO_POSTS_TIME_FRAME'		=> 'Chủ đề này không có bài viết nào trong khoảng thời gian vừa chọn.',
	'NO_SUBJECT'				=> 'Không tiêu đề', // Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Lựa chọn tìm kiếm bạn vừa thực hiện không tồn tại.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Không có phương thức xác thực nào được hỗ trợ trên máy chủ.',	
	'NO_TOPIC'					=> 'Chủ đề bạn vừa yêu cầu không tồn tại.',
	'NO_TOPIC_FORUM'			=> 'Chủ đề hay chuyên mục không tồn tại.',
	'NO_TOPICS'					=> 'Không có chủ đề hoặc bài viết nào trong chuyên mục này.',
	'NO_TOPICS_TIME_FRAME'		=> 'Chuyên mục này không có chủ đề nào trong khoảng thời gian vừa chọn.',
	'NO_UNREAD_PM'				=> 'Không có tin nhắn nào chưa xem',
	'NO_UPLOAD_FORM_FOUND'		=> 'Quá trình tải lên đã bắt đầu nhưng không có tập tin tải lên nào được tìm thấy.',
	'NO_USER'					=> 'Thành viên bạn vừa yêu cầu không tồn tại.',
	'NO_USERS'					=> 'Những thành viên bạn vừa yêu cầu không tồn tại.',
	'NO_USER_SPECIFIED'			=> 'Không có tên thành viên nào được xác định.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0	=> 'Không có bài viết nào chờ kiểm duyệt', // 0
		1	=> '<strong>1</strong> bài viết chờ kiểm duyệt', // 1
		2	=> '<strong>%d</strong> bài viết chờ kiểm duyệt', // 2+
	),

	'OCCUPATION'				=> 'Nghề nghiệp',
	'OFFLINE'					=> 'Ngoại tuyến',
	'ONLINE'					=> 'Trực tuyến',
	'ONLINE_BUDDIES'			=> 'Bạn thân trực tuyến',
	'ONLINE_USERS_TOTAL'		=> 'Có <strong>%d</strong> người trực tuyến: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Có <strong>0</strong> người trực tuyến: ',
	'ONLINE_USER_TOTAL'			=> 'Có <strong>%d</strong> người trực tuyến: ',
	'OPTIONS'					=> 'Tùy chọn',

	'PAGE_OF'					=> 'Trang <strong>%1$d</strong> trên <strong>%2$d</strong>',
	'PASSWORD'					=> 'Mật khẩu',
	'PLAY_QUICKTIME_FILE'		=> 'Chạy tập tin QuickTime',
	'PM'						=> 'Tin nhắn',
	'POSTING_MESSAGE'			=> 'Đang gửi bài trong chuyên mục %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Đang soạn tin nhắn',
	'POST'						=> 'Gửi bài',
	'POST_ANNOUNCEMENT'			=> 'Thông báo',
	'POST_STICKY'				=> 'Chú ý',
	'POSTED'					=> 'Đã gửi',
	'POSTED_IN_FORUM'			=> 'trong chuyên mục',
	'POSTED_ON_DATE'			=> 'vào ngày',
	'POSTS'						=> 'Bài viết',
	'POSTS_UNAPPROVED'			=> 'Có ít nhất một bài viết trong chủ đề này không được duyệt.',	
	'POST_BY_AUTHOR'			=> 'gửi bởi',
	'POST_BY_FOE'				=> 'Bài viết này được gửi bởi <strong>%1$s</strong> người hiện tại đang có tên trong danh sách cấm của bạn. %2$sHiển thị bài viết này%3$s.',
	'POST_DAY'					=> '%.2f bài viết/ngày',
	'POST_DETAILS'				=> 'Thông tin chi tiết về bài viết',
	'POST_NEW_TOPIC'			=> 'Tạo chủ đề mới',
	'POST_PCT'					=> '%.2f%% trong tổng số bài viết',
	'POST_PCT_ACTIVE'			=> '%.2f%% trong tổng số bài viết của thành viên này',	
	'POST_PCT_ACTIVE_OWN'		=> '%.2f%% trong tổng số bài viết của bạn',
	'POST_REPLY'				=> 'Gửi bài trả lời',
	'POST_REPORTED'				=> 'Bấm vào đây để xem báo cáo',
	'POST_SUBJECT'				=> 'Tiêu đề bài viết',
	'POST_TIME'					=> 'Ngày gửi',
	'POST_TOPIC'				=> 'Tạo chủ đề mới',
	'POST_UNAPPROVED'			=> 'Bài viết này đang chờ được duyệt',
	'PREVIEW'					=> 'Xem trước',
	'PREVIOUS'					=> 'Trang vừa xem', // Used in pagination
	'PREVIOUS_STEP'				=> 'Bước vừa hoàn tất',
	'PRIVACY'					=> 'Chính sách bảo mật',
	'PRIVATE_MESSAGE'			=> 'Tin nhắn',
	'PRIVATE_MESSAGES'			=> 'Tin nhắn',
	'PRIVATE_MESSAGING'			=> 'Đang gửi tin nhắn',
	'PROFILE'					=> 'Thiết lập cá nhân',

	'READING_FORUM'				=> 'Đang xem các chủ đề trong chuyên mục %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Đang xem thông báo chung',
	'READING_LINK'				=> 'Đang ghé thăm chuyên mục liên kết %s',
	'READING_TOPIC'				=> 'Đang xem các bài viết trong chủ đề %s',
	'READ_PROFILE'				=> 'Xem thông tin cá nhân',
	'REASON'					=> 'Nguyên nhân',
	'RECORD_ONLINE_USERS'		=> 'Lượt người ghé thăm đông nhất là <strong>%1$s</strong> vào ngày %2$s',
	'REDIRECT'					=> 'Chuyển trang',
	'REDIRECTS'					=> 'Số lượt ghé thăm',
	'REGISTER'					=> 'Đăng ký',
	'REGISTERED_USERS'			=> 'Các thành viên trực tuyến:',
	'REG_USERS_ONLINE'			=> 'Có <strong>%d</strong> thành viên và ',
	'REG_USERS_TOTAL'			=> '<strong>%d</strong> thành viên, ',
	'REG_USERS_TOTAL_AND'		=> '<strong>%d</strong> thành viên và ',
	'REG_USERS_ZERO_ONLINE'		=> '<strong>0</strong> thành viên và ',
	'REG_USERS_ZERO_TOTAL'		=> '<strong>0</strong> thành viên, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '<strong>0</strong> thành viên và ',
	'REG_USER_ONLINE'			=> '<strong>%d</strong> thành viên và ',
	'REG_USER_TOTAL'			=> '<strong>%d</strong> thành viên, ',
	'REG_USER_TOTAL_AND'		=> '<strong>%d</strong> thành viên và ',
	'REMOVE'					=> 'Gỡ bỏ',
	'REMOVE_INSTALL'			=> 'Hãy vui lòng xóa, di chuyển hoặc đổi tên thư mục <samp>install/</samp> trước khi bạn bắt đầu sử dụng hệ thống. Nếu thư mục này vẫn còn hiện diện, bạn sẽ chỉ có thể truy cập vào được bảng quản trị viên.',
	'REPLIES'					=> 'Trả lời',
	'REPLY_WITH_QUOTE'			=> 'Trả lời kèm trích dẫn',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Đang trả lời thông báo chung',
	'REPLYING_MESSAGE'			=> 'Đang trả lời bài viết trong %s',
	'REPORT_BY'					=> 'Báo cáo bởi',
	'REPORT_POST'				=> 'Báo cáo bài viết này',
	'REPORTING_POST'			=> 'Đang báo cáo bài viết',
	'RESEND_ACTIVATION'			=> 'Gửi lại email kích hoạt tài khoản',
	'RESET'						=> 'Làm lại',
	'RESTORE_PERMISSIONS'		=> 'Phục hồi thiết lập cấp phép',
	'RETURN_INDEX'				=> '%sQuay về trang chủ%s',
	'RETURN_FORUM'				=> '%sQuay về chuyên mục vừa xem%s',
	'RETURN_PAGE'				=> '%sQuay về trang trước%s',
	'RETURN_TOPIC'				=> '%sQuay về chủ đề vừa xem%s',
	'RETURN_TO'					=> 'Quay về',
	'RULES_ATTACH_CAN'			=> 'Bạn <strong>có thể</strong> gửi tập tin đính kèm.',
	'RULES_ATTACH_CANNOT'		=> 'Bạn <strong>không thể</strong> gửi tập tin đính kèm.',
	'RULES_DELETE_CAN'			=> 'Bạn <strong>có thể</strong> xóa những bài viết của mình.',
	'RULES_DELETE_CANNOT'		=> 'Bạn <strong>không thể</strong> xóa những bài viết của mình.',
	'RULES_DOWNLOAD_CAN'		=> 'Bạn <strong>có thể</strong> tải về tập tin đính kèm.',
	'RULES_DOWNLOAD_CANNOT'		=> 'Bạn <strong>không thể</strong> tải về tập tin đính kèm.',
	'RULES_EDIT_CAN'			=> 'Bạn <strong>có thể</strong> sửa những bài viết của mình.',
	'RULES_EDIT_CANNOT'			=> 'Bạn <strong>không thể</strong> sửa những bài viết của mình.',
	'RULES_LOCK_CAN'			=> 'Bạn <strong>có thể</strong> khóa những chủ đề của mình.',
	'RULES_LOCK_CANNOT'			=> 'Bạn <strong>không thể</strong> khóa những chủ đề của mình.',
	'RULES_POST_CAN'			=> 'Bạn <strong>có thể</strong> tạo chủ đề mới.',
	'RULES_POST_CANNOT'			=> 'Bạn <strong>không thể</strong> tạo chủ đề mới.',
	'RULES_REPLY_CAN'			=> 'Bạn <strong>có thể</strong> trả lời bài viết.',
	'RULES_REPLY_CANNOT'		=> 'Bạn <strong>không thể</strong> trả lời bài viết.',
	'RULES_VOTE_CAN'			=> 'Bạn <strong>có thể</strong> tham gia bình chọn.',
	'RULES_VOTE_CANNOT'			=> 'Bạn <strong>không thể</strong> tham gia bình chọn.',

	'SEARCH'					=> 'Tìm kiếm',
	'SEARCH_MINI'				=> 'Nhập từ khóa…',
	'SEARCH_ADV'				=> 'Tìm kiếm nâng cao',
	'SEARCH_ADV_EXPLAIN'		=> 'Xem những lựa chọn tìm kiếm nâng cao',
	'SEARCH_KEYWORDS'			=> 'Từ khóa tìm kiếm',
	'SEARCHING_FORUMS'			=> 'Đang tìm kiếm các chuyên mục',
	'SEARCH_ACTIVE_TOPICS'		=> 'Chủ đề sôi nổi',
	'SEARCH_FOR'				=> 'Tìm với từ khóa',
	'SEARCH_FORUM'				=> 'Tìm trong chuyên mục này…',
	'SEARCH_NEW'				=> 'Bài viết mới',
	'SEARCH_POSTS_BY'			=> 'Tìm kiếm bài viết được gửi bởi',
	'SEARCH_SELF'				=> 'Bài viết của bạn',
	'SEARCH_TOPIC'				=> 'Tìm kiếm trong chủ đề này…',
	'SEARCH_UNANSWERED'			=> 'Bài viết chưa được trả lời',
	'SECONDS'					=> 'Giây',
	'SELECT'					=> 'Chọn',
	'SELECT_ALL_CODE'			=> 'Chọn tất cả',
	'SELECT_DESTINATION_FORUM'	=> 'Hãy chọn một chuyên mục để tiếp tục',
	'SELECT_FORUM'				=> 'Chọn một chuyên mục',
	'SEND_EMAIL'				=> 'Gửi email', // Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Gửi email cho', // Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Gửi tin nhắn',
	'SETTINGS'					=> 'Thiết lập',
	'SIGNATURE'					=> 'Chữ ký cá nhân',
	'SKIP'						=> 'Bỏ qua nội dung',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Máy chủ SMTP không hỗ trợ giao thức xác thực.',	
	'SORRY_AUTH_READ'			=> 'Bạn không được cấp phép để xem chuyên mục này.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Bạn không được cấp phép để tải về tập tin đính kèm này.',	
	'SORT_BY'					=> 'Sắp xếp theo',
	'SORT_JOINED'				=> 'Ngày tham gia',
	'SORT_LOCATION'				=> 'Nơi đến',
	'SORT_RANK'					=> 'Xếp hạng',
	'SORT_TOPIC_TITLE'			=> 'Tiêu đề bài viết',
	'SORT_USERNAME'				=> 'Tên thành viên',
	'SPLIT_TOPIC'				=> 'Chia nhỏ chủ đề',
	'SQL_ERROR_OCCURRED'		=> 'Có một lỗi SQL xuất hiện trong khi đang nạp trang này. Hãy liên hệ với người quản trị nếu rắc rối này vẫn còn.',
	'STATISTICS'				=> 'Thống kê',
	'START_WATCHING_FORUM'		=> 'Theo dõi chuyên mục',
	'START_WATCHING_TOPIC'		=> 'Theo dõi chủ đề',
	'STOP_WATCHING_FORUM'		=> 'Ngừng theo dõi chuyên mục',
	'STOP_WATCHING_TOPIC'		=> 'Ngừng theo dõi chủ đề',
	'SUBFORUM'					=> 'Chuyên mục con',
	'SUBFORUMS'					=> 'Chuyên mục con',
	'SUBJECT'					=> 'Tiêu đề',
	'SUBMIT'					=> 'Chấp nhận',

	'TERMS_USE'			=> 'Điều khoản đăng ký thành viên',
	'TEST_CONNECTION'	=> 'Kiểm tra kết nối',
	'THE_TEAM'			=> 'Ban điều hành',
	'TIME'				=> 'Thời gian',

	'TOO_LONG'	=> 'Giá trị bạn vừa nhập quá dài.',

	'TOO_LONG_AIM'					=> 'Tên tài khoản AIM bạn vừa nhập quá dài.',
	'TOO_LONG_CONFIRM_CODE'			=> 'Mã xác nhận bạn vừa nhập quá dài.',
	'TOO_LONG_DATEFORMAT'			=> 'Định dạng ngày tháng bạn vừa nhập quá dài.',
	'TOO_LONG_ICQ'					=> 'Số tài khoản ICQ bạn vừa nhập quá dài.',
	'TOO_LONG_INTERESTS'			=> 'Nội dung trong phần sở thích bạn vừa nhập quá dài.',
	'TOO_LONG_JABBER'				=> 'Tên tài khoản Jabber bạn vừa nhập quá dài.',
	'TOO_LONG_LOCATION'				=> 'Nội dung trong phần nơi đến bạn vừa nhập quá dài.',
	'TOO_LONG_MSN'					=> 'Tên tài khoản MSNM/WLM bạn vừa nhập quá dài.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Mật khẩu mới bạn vừa nhập quá dài.',
	'TOO_LONG_OCCUPATION'			=> 'Nội dung trong phần nghề nghiệp bạn vừa nhập quá dài.',	
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Mật khẩu xác nhận bạn vừa nhập quá dài.',
	'TOO_LONG_USER_PASSWORD'		=> 'Mật khẩu bạn vừa nhập quá dài.',
	'TOO_LONG_USERNAME'				=> 'Tên thành viên bạn vừa nhập quá dài.',
	'TOO_LONG_EMAIL'				=> 'Địa chỉ email bạn vừa nhập quá dài.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'Địa chỉ email xác nhận bạn vừa nhập quá dài.',
	'TOO_LONG_WEBSITE'				=> 'Địa chỉ website bạn vừa nhập quá dài.',
	'TOO_LONG_YIM'					=> 'Tên tài khoản Yahoo bạn vừa nhập quá dài.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Bạn không thể bình chọn cho nhiều đối tượng.',

	'TOO_SHORT'	=> 'Giá trị bạn vừa nhập quá ngắn.',

	'TOO_SHORT_AIM'					=> 'Tên tài khoản AIM bạn vừa nhập quá ngắn.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'Mã xác nhận bạn vừa nhập quá ngắn.',
	'TOO_SHORT_DATEFORMAT'			=> 'Định dạng ngày tháng bạn vừa nhập quá ngắn.',
	'TOO_SHORT_ICQ'					=> 'Số tài khoản ICQ bạn vừa nhập quá ngắn.',
	'TOO_SHORT_INTERESTS'			=> 'Nội dung trong phần sở thích bạn vừa nhập quá ngắn.',
	'TOO_SHORT_JABBER'				=> 'Tên tài khoản Jabber bạn vừa nhập quá ngắn.',
	'TOO_SHORT_LOCATION'			=> 'Nội dung trong phần nơi đến bạn vừa nhập quá ngắn.',
	'TOO_SHORT_MSN'					=> 'Tên tài khoản MSNM/WLM bạn vừa nhập quá ngắn.',	
	'TOO_SHORT_NEW_PASSWORD'		=> 'Mật khẩu mới bạn vừa nhập quá ngắn.',
	'TOO_SHORT_OCCUPATION'			=> 'Nội dung trong phần nghề nghiệp bạn vừa nhập quá ngắn.',	
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Mật khẩu bạn vừa nhập quá ngắn.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Mật khẩu bạn vừa nhập quá ngắn.',
	'TOO_SHORT_USERNAME'			=> 'Tên thành viên bạn vừa nhập quá ngắn.',
	'TOO_SHORT_EMAIL'				=> 'Địa chỉ email bạn vừa nhập quá ngắn.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Địa chỉ email xác nhận bạn vừa nhập quá ngắn.',
	'TOO_SHORT_WEBSITE'				=> 'Địa chỉ website bạn vừa nhập quá ngắn.',
	'TOO_SHORT_YIM'					=> 'Tên tài khoản Yahoo bạn vừa nhập quá ngắn.',

	'TOPIC'					=> 'Chủ đề',
	'TOPICS'				=> 'Chủ đề',
	'TOPIC_ICON'			=> 'Biểu tượng bài viết',
	'TOPIC_LOCKED'			=> 'Chủ đề này đã bị khóa, bạn không thể sửa những bài viết của mình hay trả lời bài viết thêm nữa.',
	'TOPIC_LOCKED_SHORT'	=> 'Chủ đề đã khóa',
	'TOPIC_MOVED'			=> 'Chủ đề đã di chuyển',
	'TOPIC_REVIEW'			=> 'Xem lại chủ đề',
	'TOPIC_TITLE'			=> 'Tiêu đề',
	'TOPIC_UNAPPROVED'		=> 'Chủ đề này chưa được duyệt',
	'TOTAL_ATTACHMENTS'		=> 'Tập tin đính kèm',
	'TOTAL_LOG'				=> '<strong>1</strong> ghi nhận',
	'TOTAL_LOGS'			=> '<strong>%d</strong> ghi nhận',
	'TOTAL_NO_PM'			=> '<strong>0</strong> tin nhắn',
	'TOTAL_PM'				=> '<strong>1</strong> tin nhắn',
	'TOTAL_PMS'				=> '<strong>%d</strong> tin nhắn',
	'TOTAL_POSTS'			=> 'Số bài viết',
	'TOTAL_POSTS_OTHER'		=> 'Số bài viết: <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'		=> 'Số bài viết: <strong>0</strong>',
	'TOPIC_REPORTED'		=> 'Chủ đề này đã được báo cáo',	
	'TOTAL_TOPICS_OTHER'	=> 'Số chủ đề: <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'		=> 'Số chủ đề: <strong>0</strong>',
	'TOTAL_USERS_OTHER'		=> 'Số thành viên: <strong>%d</strong>',
	'TOTAL_USERS_ZERO'		=> 'Số thành viên: <strong>0</strong>',
	'TRACKED_PHP_ERROR'		=> 'Các lỗi PHP đã phát hiện: %s',

	'UNABLE_GET_IMAGE_SIZE'		=> 'Không thể xác định kích thước của tập tin hình ảnh.',
	'UNABLE_TO_DELIVER_FILE'	=> 'Không thể thực thi tập tin.',
	'UNKNOWN_BROWSER'			=> 'Trình duyệt không xác định',
	'UNMARK_ALL'				=> 'Bỏ chọn tất cả',
	'UNREAD_MESSAGES'			=> 'Tin nhắn chưa xem',
	'UNREAD_PM'					=> '<strong>%d</strong> tin nhắn chưa xem',
	'UNREAD_PMS'				=> '<strong>%d</strong> tin nhắn chưa xem',
	'UNWATCHED_FORUMS'			=> 'Bạn không còn theo dõi những chuyên mục đã chọn.',
	'UNWATCHED_TOPICS'			=> 'Bạn không còn theo dõi những chủ đề đã chọn.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Bạn không còn theo dõi những mục đã chọn.',
	'UPDATE'					=> 'Cập nhật',	
	'UPLOAD_IN_PROGRESS'		=> 'Đang tải lên.',
	'URL_REDIRECT'				=> 'Nếu trình duyệt của bạn không hỗ trợ chuyển trang tự động, %shãy bấm vào đây để tiếp tục%s.',
	'USERGROUPS'				=> 'Nhóm',
	'USERNAME'					=> 'Tên thành viên',
	'USERNAMES'					=> 'Tên thành viên',
	'USER_AVATAR'				=> 'Hình đại diện của thành viên',
	'USER_CANNOT_READ'			=> 'Bạn không thể xem những bài viết trong chuyên mục này.',
	'USER_POST'					=> '%d bài viết',
	'USER_POSTS'				=> '%d bài viết',
	'USERS'						=> 'Người',
	'USE_PERMISSIONS'			=> 'Kiểm tra cấp phép cho thành viên',

	'VARIANT_DATE_SEPARATOR'	=> ' / ', // Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Đã xem',
	'VIEWING_FAQ'				=> 'Đang xem trợ giúp',
	'VIEWING_MEMBERS'			=> 'Đang xem danh sách các thành viên',
	'VIEWING_ONLINE'			=> 'Đang xem các thành viên trực tuyến',
	'VIEWING_MCP'				=> 'Đang xem bảng điều hành viên',
	'VIEWING_MEMBER_PROFILE'	=> 'Đang xem thông tin cá nhân của thành viên',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Đang xem tin nhắn',
	'VIEWING_REGISTER'			=> 'Đang đăng ký thành viên mới',
	'VIEWING_UCP'				=> 'Đang xem bảng thiết lập cá nhân',
	'VIEWS'						=> 'Xem',
	'VIEW_BOOKMARKS'			=> 'Xem trang yêu thích',
	'VIEW_FORUM_LOGS'			=> 'Xem ghi nhận chuyên mục',
	'VIEW_LATEST_POST'			=> 'Xem bài viết mới nhất vừa gửi',
	'VIEW_NEWEST_POST'			=> 'Xem bài viết chưa xem đầu tiên',
	'VIEW_NOTES'				=> 'Xem phản hồi về thành viên',
	'VIEW_ONLINE_TIME'			=> 'dựa trên số người hoạt động trong <strong>%d</strong> phút vừa qua',
	'VIEW_ONLINE_TIMES'			=> 'dựa trên số người hoạt động trong <strong>%d</strong> phút vừa qua',
	'VIEW_TOPIC'				=> 'Xem chủ đề',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Thông báo: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Thông báo chung: ',	
	'VIEW_TOPIC_LOCKED'			=> 'Đã khóa: ',
	'VIEW_TOPIC_LOGS'			=> 'Xem ghi nhận chủ đề',
	'VIEW_TOPIC_MOVED'			=> 'Di chuyển: ',
	'VIEW_TOPIC_POLL'			=> 'Bình chọn: ',
	'VIEW_TOPIC_STICKY'			=> 'Chú ý: ',
	'VISIT_WEBSITE'				=> 'Ghé thăm website',

	'WARNINGS'			=> 'Cảnh cáo',
	'WARN_USER'			=> 'Cảnh cáo thành viên',
	'WELCOME_SUBJECT'	=> 'Chào mừng bạn đã đến với %s!',
	'WEBSITE'			=> 'Website',
	'WHOIS'				=> 'Tra cứu địa chỉ IP',
	'WHO_IS_ONLINE'		=> 'Đang trực tuyến',
	'WRONG_PASSWORD'	=> 'Bạn vừa nhập mật khẩu không chính xác.',

	'WRONG_DATA_ICQ'			=> 'Số tài khoản ICQ bạn vừa nhập không hợp lệ.',
	'WRONG_DATA_JABBER'			=> 'Tên tài khoản Jabber bạn vừa nhập không hợp lệ.',
	'WRONG_DATA_LANG'			=> 'Ngôn ngữ bạn vừa nhập không hợp lệ.',
	'WRONG_DATA_WEBSITE'		=> 'Địa chỉ website bạn vừa nhập không phải là một địa chỉ URL hợp lệ và phải đính kèm cả giao thức. Ví dụ: <code>http://www.example.com/</code>.',
	'WROTE'						=> 'đã viết',

	'YEAR'				=> 'Năm',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'Có',
	'YIM'				=> 'Tài khoản Yahoo',
	'YOU_LAST_VISIT'	=> 'Lần ghé thăm trước: %s',
	'YOU_NEW_PM'		=> 'Bạn có một tin nhắn mới trong hộp tin nhận của mình.',
	'YOU_NEW_PMS'		=> 'Bạn có nhiều tin nhắn mới trong hộp tin nhận của mình.',
	'YOU_NO_NEW_PM'		=> 'Bạn không có tin nhắn mới nào trong hộp tin nhận của mình.',

	'datetime'		=> array(
		'TODAY'		=> 'Hôm nay',
		'TOMORROW'	=> 'Ngày mai',
		'YESTERDAY'	=> 'Hôm qua',
		'AGO'		=> array(
			0		=> 'chưa đầy một phút trước',
			1		=> '%d phút trước',
			2		=> '%d phút trước',
			60		=> '1 giờ trước',
		),

		'Sunday'	=> 'Chủ nhật',
		'Monday'	=> 'Thứ hai',
		'Tuesday'	=> 'Thứ ba',
		'Wednesday'	=> 'Thứ tư',
		'Thursday'	=> 'Thứ năm',
		'Friday'	=> 'Thứ sáu',
		'Saturday'	=> 'Thứ bảy',

		'Sun'		=> 'CN',
		'Mon'		=> 'T.Hai',
		'Tue'		=> 'T.Ba',
		'Wed'		=> 'T.Tư',
		'Thu'		=> 'T.Năm',
		'Fri'		=> 'T.Sáu',
		'Sat'		=> 'T.Bảy',

		'January'	=> 'Tháng một',
		'February'	=> 'Tháng hai',
		'March'		=> 'Tháng ba',
		'April'		=> 'Tháng tư',
		'May'		=> 'Tháng năm',
		'June'		=> 'Tháng sáu',
		'July'		=> 'Tháng bảy',
		'August'	=> 'Tháng tám',
		'September' => 'Tháng chín',
		'October'	=> 'Tháng mười',
		'November'	=> 'Tháng mười một',
		'December'	=> 'Tháng mười hai',

		'Jan'		=> 'Tháng 1',
		'Feb'		=> 'Tháng 2',
		'Mar'		=> 'Tháng 3',
		'Apr'		=> 'Tháng 4',
		'May_short'	=> 'Tháng 5', // Short representation of "May". May_short used because in English the short and long date are the same for May.		
		'Jun'		=> 'Tháng 6',
		'Jul'		=> 'Tháng 7',
		'Aug'		=> 'Tháng 8',
		'Sep'		=> 'Tháng 9',
		'Oct'		=> 'Tháng 10',
		'Nov'		=> 'Tháng 11',
		'Dec'		=> 'Tháng 12',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 Giờ',
		'-11'	=> 'UTC - 11 Giờ',
		'-10'	=> 'UTC - 10 Giờ',
		'-9.5'	=> 'UTC - 9:30 Giờ',
		'-9'	=> 'UTC - 9 Giờ',
		'-8'	=> 'UTC - 8 Giờ',
		'-7'	=> 'UTC - 7 Giờ',
		'-6'	=> 'UTC - 6 Giờ',
		'-5'	=> 'UTC - 5 Giờ',
		'-4.5'	=> 'UTC - 4:30 Giờ',
		'-4'	=> 'UTC - 4 Giờ',
		'-3.5'	=> 'UTC - 3:30 Giờ',
		'-3'	=> 'UTC - 3 Giờ',
		'-2'	=> 'UTC - 2 Giờ',
		'-1'	=> 'UTC - 1 Giờ',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 Giờ',
		'2'		=> 'UTC + 2 Giờ',
		'3'		=> 'UTC + 3 Giờ',
		'3.5'	=> 'UTC + 3:30 Giờ',
		'4'		=> 'UTC + 4 Giờ',
		'4.5'	=> 'UTC + 4:30 Giờ',
		'5'		=> 'UTC + 5 Giờ',
		'5.5'	=> 'UTC + 5:30 Giờ',
		'5.75'	=> 'UTC + 5:45 Giờ',
		'6'		=> 'UTC + 6 Giờ',
		'6.5'	=> 'UTC + 6:30 Giờ',
		'7'		=> 'UTC + 7 Giờ',
		'8'		=> 'UTC + 8 Giờ',
		'8.75'	=> 'UTC + 8:45 Giờ',
		'9'		=> 'UTC + 9 Giờ',
		'9.5'	=> 'UTC + 9:30 Giờ',
		'10'	=> 'UTC + 10 Giờ',
		'10.5'	=> 'UTC + 10:30 Giờ',
		'11'	=> 'UTC + 11 Giờ',
		'11.5'	=> 'UTC + 11:30 Giờ',
		'12'	=> 'UTC + 12 Giờ',
		'12.75'	=> 'UTC + 12:45 Giờ',
		'13'	=> 'UTC + 13 Giờ',
		'14'	=> 'UTC + 14 Giờ',
		'dst'	=> '[ <abbr title="Giờ mùa hè (Daylight Saving Time)">DST</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Giờ chuẩn của đảo Baker',
		'-11'	=> '[UTC - 11] Giờ chuẩn của Niue, Samoa',
		'-10'	=> '[UTC - 10] Giờ chuẩn của Hawaii-Aleutian, đảo Cook',
		'-9.5'	=> '[UTC - 9:30] Giờ chuẩn của quần đảo Marquesas',
		'-9'	=> '[UTC - 9] Giờ chuẩn của Alaska, đảo Gambier',
		'-8'	=> '[UTC - 8] Giờ chuẩn của Thái Bình Dương',
		'-7'	=> '[UTC - 7] Giờ chuẩn của Mountain',
		'-6'	=> '[UTC - 6] Giờ chuẩn của trung tâm thế giới',
		'-5'	=> '[UTC - 5] Giờ chuẩn của phía Đông thế giới',
		'-4.5'	=> '[UTC - 4:30] Giờ chuẩn của Venezuelan',
		'-4'	=> '[UTC - 4] Giờ chuẩn của Đại Tây Dương',
		'-3.5'	=> '[UTC - 3:30] Giờ chuẩn của Newfoundland',
		'-3'	=> '[UTC - 3] Giờ chuẩn của Amazon, trung tâm Greenland',
		'-2'	=> '[UTC - 2] Giờ chuẩn của Fernando de Noronha, phía Nam Georgia &amp; quần đảo Sandwich',
		'-1'	=> '[UTC - 1] Giờ chuẩn của Azores, Cape Verde, phía Đông Greenland',
		'0'		=> '[UTC] Giờ chuẩn của Tây Âu, Greenwich Mean',
		'1'		=> '[UTC + 1] Giờ chuẩn của trung tâm châu Âu, Tây Phi',
		'2'		=> '[UTC + 2] Giờ chuẩn của Đông Âu, trung tâm châu Phi',
		'3'		=> '[UTC + 3] Giờ chuẩn của Nga, Đông Phi',
		'3.5'	=> '[UTC + 3:30] Giờ chuẩn của Iran',
		'4'		=> '[UTC + 4] Giờ chuẩn của Gulf, Samara',
		'4.5'	=> '[UTC + 4:30] Giờ chuẩn của Afghanistan',
		'5'		=> '[UTC + 5] Giờ chuẩn của Pakistan, Yekaterinburg',
		'5.5'	=> '[UTC + 5:30] Giờ chuẩn của Ấn Độ, Sri Lanka',
		'5.75'	=> '[UTC + 5:45] Giờ chuẩn của Nepal',
		'6'		=> '[UTC + 6] Giờ chuẩn của Bangladesh, Bhutan, Novosibirsk',
		'6.5'	=> '[UTC + 6:30] Giờ chuẩn của Cocos, Myanmar',
		'7'		=> '[UTC + 7] Giờ chuẩn của Indochina, Krasnoyarsk, Việt Nam',
		'8'		=> '[UTC + 8] Giờ chuẩn của Trung Quốc, phía Tây nước Úc, Irkutsk',
		'8.75'	=> '[UTC + 8:45] Giờ chuẩn của Đông Nam và phía Tây nước Úc',
		'9'		=> '[UTC + 9] Giờ chuẩn của Nhật Bản, Hàn Quốc, Chita',
		'9.5'	=> '[UTC + 9:30] Giờ chuẩn của trung tâm nước Úc',
		'10'	=> '[UTC + 10] Giờ chuẩn của phía Đông nước Úc, Vladivostok',
		'10.5'	=> '[UTC + 10:30] Giờ chuẩn của Lord Howe',
		'11'	=> '[UTC + 11] Giờ chuẩn của đảo Solomon, Magadan',
		'11.5'	=> '[UTC + 11:30] Giờ chuẩn của đảo Norfolk',
		'12'	=> '[UTC + 12] Giờ chuẩn của New Zealand, Fiji, Kamchatka',
		'12.75'	=> '[UTC + 12:45] Giờ chuẩn của quần đảo Chatham',
		'13'	=> '[UTC + 13] Giờ chuẩn của Tonga, quần đảo Phoenix',
		'14'	=> '[UTC + 14] Giờ chuẩn của đảo Line',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'			=> array(
		'd M Y, H:i'		=> '01 Tháng 1 2007, 13:37',
		'd M Y H:i'			=> '01 Tháng 1 2007 13:37',
		'M d, \'y, H:i'		=> 'Tháng 1 01, \'07, 13:37', // Replaced 'jS' by 'd' for Vietnamese
		'D M d, Y g:i a'	=> 'Thứ 2 Tháng 1 01, 2007 1:37 pm',
		'F d, Y, g:i a'		=> 'Tháng một 01, 2007, 1:37 pm', // Replaced 'jS' by 'd' for Vietnamese
		'|d M Y|, H:i'		=> 'Hôm nay, 13:37 / 01 Tháng 1 2007, 13:37',
		'|F d, Y|, g:i a'	=> 'Hôm nay, 1:37 pm / Tháng một 01, 2007, 1:37 pm' // Replaced 'jS' by 'd' for Vietnamese
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D d M, Y g:i a', // Mon 01 Jan, 2007 1:37 pm

));

?>