<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.botimeperiod.inc.php,v 1.11 2001/09/06 22:56:15 bettina Exp $ */

	class botimeperiod
	{
		var $start;
		var $query;
		var $sort;
		var $order;
		var $filter;
		var $cat_id;

		var $public_functions = array
		(
			'read_timeperiods'	=> True,
			'read_single_tp'	=> True,
			'save_timeperiod'	=> True,
			'delete_timeperiod'	=> True,
			'check_values'		=> True,
			'select_tp_list'	=> True,
			'read_times'		=> True
		);

		function botimeperiod($session=False)
		{
			global $phpgw;

			$this->sotimeperiod = CreateObject('netsaint.sotimeperiod');

			if ($session)
			{
				$this->read_sessiondata();
				$this->use_session = True;
			}

			global $start, $query, $filter, $sort, $order, $cat_id;

			if(isset($start)) { $this->start = $start; }
			if(isset($query)) { $this->query = $query; }
			if(!empty($filter)) { $this->filter = $filter; }
			if(isset($sort)) { $this->sort = $sort; }
			if(isset($order)) { $this->order = $order; }
			if(isset($cat_id)) { $this->cat_id = $cat_id; }
		}

		function save_sessiondata($data)
		{
			global $phpgw;

			if ($this->use_session)
			{
				$phpgw->session->appsession('session_data','netsaint_time',$data);
			}
		}

		function read_sessiondata()
		{
			global $phpgw;

			$data = $phpgw->session->appsession('session_data','netsaint_time');

			$this->start	= $data['start'];
			$this->query	= $data['query'];
			$this->filter	= $data['filter'];
			$this->sort 	= $data['sort'];
			$this->order	= $data['order'];
			$this->cat_id	= $data['cat_id'];
		}

		function read_timeperiods($start, $limit, $query, $filter, $sort, $order, $cat_id)
		{
			$tp = $this->sotimeperiod->read_timeperiods($start, $limit, $query, $filter, $sort, $order, $cat_id);
			$this->total_records = $this->sotimeperiod->total_records;
			return $tp;
		}

		function read_times($start, $limit)
		{
			$t = $this->sotimeperiod->read_times($start, $limit);
			$this->total_records = $this->sotimeperiod->total_records;
			return $t;
		}

		function read_single_tp($tp_id)
		{
			$tp = $this->sotimeperiod->read_single_tp($tp_id);
			return $tp;
		}

		function select_tp_list($action, $selected)
		{
			if ($action == 'tp')
			{
				$t = $this->sotimeperiod->select_tp_list($selected);
			}
			else
			{
				$t = $this->sotimeperiod->select_time_list($selected);
			}
			return $t;
		}

		function check_values($action, $values)
		{
			global $phpgw;

			if ($action == 'tp')
			{
				if (!$values['name'])
				{
					$error[] = lang('Please enter a name !');
				}
				else
				{
					if (strlen($values['name']) >= 25)
					{
						$error[] = lang('The short name can not exceed 25 characters in length !');
					}
					else
					{
						$exists = $this->sotimeperiod->exists($values['name'], $values['id']);
						if ($exists)
						{
							$error[] = lang('This name has been used already !');
						}
					}
				}

				if (!$values['alias'])
				{
					$error[] = lang('Please enter a description !');
				}

				if (strlen($values['alias']) >= 255)
				{
					$error[] = lang('The description can not exceed 255 characters in length !');
				}

				if ($values['repeat'] && is_array($values['repeat_day']))
				{
					$error[] = lang('You can not choose both: to repeat the times every day AND also select days to repeat !');
				}
				elseif (! is_array($values['seven']) && is_array($values['repeat_day']))
				{
					$error[] = lang('Please select times to repeat !');
				}
				elseif (! is_array($values['seven']) && $values['repeat'])
				{
					$error[] = lang('Please select times to repeat !');
				}
				elseif (! $values['repeat'] && ! is_array($values['repeat_day']) && is_array($values['seven']))
				{
					$error[] = lang('Please select the days to repeat this times !');
				}

			/*	for ($i=0;$i<7;$i++)
				{	
					if (!$values['repeat'] && (! is_array($values['seven'])) && (! is_array($values[$i])))
					{
						$error[] = lang('Please select times !');
					}
				} */
			}

			if ($action == 'time')
			{
				if ($values['shour'] > $values['ehour'])
				{
					$error[] = lang('Ending time can not be before start time !');
				}
				elseif ($values['shour'] == $values['ehour'] && $values['smin'] > $values['emin'])
				{
					$error[] = lang('Ending time can not be before start time !');
				}
				elseif ($values['shour']==24)
				{
					$error[] = lang('The starting time can not be 24 !');
				}
				elseif ($values['ehour']==24 && $values['emin'] > 0)
				{
					$error[] = lang('The ending time can not be more than 24 !');			
				}
			}

			if (is_array($error))
			{
				return $error;
			}
		}

		function save_timeperiod($action, $values)
		{
//			_debug_array($values);
//			exit;

			if ($action == 'tp')
			{
				if ($values['access'])
				{
					$values['access'] = 'private';
				}
				else
				{
					$values['access'] = 'public';
				}

				$week = array
				(
					'mon_time',
					'tue_time',
					'wed_time',
					'thu_time',
					'fri_time',
					'sat_time',
					'sun_time'
				);

				if ($values['repeat'])
				{
					for ($i=0;$i<7;$i++)
					{
						$values[$week[$i]] = implode(',',$values['seven']);
					}
				}
				else
				{
					for ($i=0;$i<7;$i++)
					{
						if (is_array($values[$i]))
						{
							$values[$week[$i]] = implode(',',$values[$i]);
						}
					}

					if (is_array($values['repeat_day']))
					{
						while($repweek = each($values['repeat_day']))
						{
							$values[$repweek[1]] = implode(',',$values['seven']);
						}
					}
				}

				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sotimeperiod->edit_timeperiod($values);
					}
				}
				else
				{
					$this->sotimeperiod->add_timeperiod($values);
				}
			}
			else
			{
				$values['value'] = $values['shour'] . ':' . $values['smin'] . '-' . $values['ehour'] . ':' . $values['emin'];

				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sotimeperiod->edit_time($values);
					}
				}
				else
				{
					$this->sotimeperiod->add_time($values);
				}
			}
		}

		function delete_timeperiod($action, $t_id)
		{
			if ($action == 'tp')
			{
				$this->sotimeperiod->delete_timeperiod($t_id);
			}
			else
			{
				$this->sotimeperiod->delete_time($t_id);
			}
		}
	}
?>
