#!/bin/sh
#########################################################
## This script creates the individual translated packages
## from the raw phpwebsite source code.
##
## To add a language, just copy the en.pp to
## [language].pp, edit and add the [language] to the
## languages list below. That's all!
##
## Do not use the multi feature - is is unstable and
## untested! You have been warned! If you want to help
## fixing it: go ahead.
#########################################################

## some definitions
languages="de en id cz fr es it pt br-pt zh no is nl"
version="0.7.8" # To be touched by maintainer only!

if [ "$1" = "multi" ] ; then
    echo "Creating multi lingual package";
elif test "$1" ; then
    languages=$@
fi

## do_language is now a function called translate
function translate(){
    ##  Make the dirs.
    mkdir $1
    mkdir $1/admin
    mkdir $1/setup
    mkdir $1/setup/upgrade
    mkdir $1/themes
    mkdir $1/themes/ASU
    mkdir $1/themes/Cool_Blue
    mkdir $1/themes/Default
    mkdir $1/themes/JET
    mkdir $1/themes/1225AM
    mkdir $1/themes/Science
    mkdir $1/include

    ##  cp the files not done by sed
    cp -R ../images ./$1/
    cp -R ../docs ./$1/

    cp -R ../setup/poweredby.jpg ./$1/setup/
    cp -R ../setup/websetup.jpg ./$1/setup/

    cp ../themes/ASU/deflogo.gif ./$1/themes/ASU/deflogo.gif
    cp ../themes/ASU/*.css ./$1/themes/ASU/

    cp ../themes/Cool_Blue/deflogo.gif ./$1/themes/Cool_Blue/deflogo.gif
    cp ../themes/Cool_Blue/*.css ./$1/themes/Cool_Blue/

    cp ../themes/Default/deflogo.gif ./$1/themes/Default/deflogo.gif
    cp ../themes/Default/*.css ./$1/themes/Default/

    cp ../themes/JET/deflogo.gif ./$1/themes/JET/deflogo.gif
    cp ../themes/JET/*.css ./$1/themes/JET/

    cp -R ../themes/1225AM/img ./$1/themes/1225AM/img/
    cp ../themes/1225AM/*.css ./$1/themes/1225AM/

    cp -R ../themes/Science/img ./$1/themes/Science/img/
    cp ../themes/Science/*.css ./$1/themes/Science/

    cp -R  ../plug-ins ./$1/
    cp ../weather_admin.php ./$1/
    cp ../weather_setup.php ./$1/

    ## sed stuff
    for i in `find .. -name *.php | grep -v make_distro` ; do
	sed --file=sed_$1 $i > ./$1/${i#../}
    done
    
    ## copy language files if we are creating a multi package
    if [ "$1" = "multi" ]; then
	mkdir ./$1/lang
	cp *.lang ./$1/lang/
    fi

    ## set some permissions on regular files (rw-rw-r--)
    chmod 664 `find $1 -type f`
}

## check for uncaught TRANSLATE statements and output to $1.err
function check_translation()
{
    echo "Looking for uncaught TRANSLATE statements in $1..."
    grep -Hrn TRANSLATE\\[\\[ ./$1 > $1.err
}

## remove some stuff (just to make sure)
echo "Cleaning up..."
rm -f sed_*
rm -f *.lang
rm -f *.err
rm -rf packages

## create the sedfiles from scratch
echo "Creating sed files..."
if [ "$1" = "multi" ]; then
    cat en.pp | \
	gawk -F "]]" '{print "s/TRANSLATE"$1"\\]\\]/$translate\\[\""$1"\"\\]/g"}' | \
	sed -e 's/ = \[\[//g' | \
	sed -e 's/TRANSLATE\[\[/TRANSLATE\\\[\\\[/g' |  sed -e 's/\[\[//g' \
	> sed_multi
    echo "sed_multi"
    echo "Creating language files"
    for i in $languages; do
	cat $i.pp | \
	    gawk -F "]]" '{print "$translate[\""$1"\"]=\""$2"\";"}' | \
	    sed -e 's/ = \[\[//g' | \
	    sed -e 's/\[\[//g' | \
	    sed -e 's/\\\&/\&/g' \
	    > $i.lang
	echo "$i.lang"
    done
else
    for i in $languages; do
	cat $i.pp | \
	    gawk -F "]]" '{print "s/TRANSLATE"$1"\\]\\]/"$2"/g"}' | \
	    sed -e 's/ = \[\[//g' | \
	    sed -e 's/TRANSLATE\[\[/TRANSLATE\\\[\\\[/g' \
	    > sed_$i
	echo "sed_$i"
    done
fi

## create the translated files and check for errors
echo "Translating (the hard work!)..."
if [ "$1" = "multi" ]; then
    echo "Translating for multi package"
    translate multi
    check_translation multi
else
    for language in $languages; do
	echo "Translating $language"
	translate $language
	check_translation $language
    done
fi

## create packages from all the subdirs
if [ "$1" = "multi" ]; then
    echo "Creating package..."
    rm -rf `find multi -name CVS`
    mv multi phpwebsite_multi
    tar czf phpWebSite-multi-$version.tar.gz phpwebsite_multi
    zip -r phpWebSite-multi-$version.zip phpwebsite_multi
else
    echo "Creating packages..."
    for language in $languages; do
	rm -rf `find $language -name CVS`
	mv $language phpwebsite_$language
	tar czf phpWebSite-$language-$version.tar.gz phpwebsite_$language
	zip -r phpWebSite-$language-$version.zip phpwebsite_$language
    done
fi
mkdir packages
mv *.gz packages
mv *.zip packages

## clean up afterwards
echo "Final cleanup..."
rm -f sed_*
rm -rf phpwebsite_*
rm -rf *.lang

## we are done!
echo "Done!"
exit 0
