#
#
#
#

set CMD_SHELL "/bin/sh -c"
set CMD_KILL "/bin/kill"

set cmd_list {}

proc cmd:edit {main_flag} {
    Toplevel:Start .tkppxpCommandEditor TkppxpCommandEditor "Command Edit" \
	$main_flag cmded:start_window {}
}

proc cmded:start_window {w args} {
    global CMD_VAR cmd_buf cmd_list cmd_list_buf

    foreach i [array names CMD_VAR] {
	set cmd_buf($i) $CMD_VAR($i)
    }
    set cmd_list_buf $cmd_list

    frame $w.pathFrame
    label $w.pathLabel
    entry $w.pathEntry -textvariable cmd_buf(PATH)
    pack $w.pathLabel -in $w.pathFrame -side left
    pack $w.pathEntry -in $w.pathFrame -side left -fill x -expand yes

    frame $w.timeoutFrame
    label $w.timeoutLabel
    entry $w.timeoutEntry -textvariable cmd_buf(CONNECT_TIMEOUT)
    label $w.timeoutUnit
    pack $w.timeoutLabel -in $w.timeoutFrame -side left
    pack $w.timeoutEntry -in $w.timeoutFrame -side left -fill x -expand yes
    pack $w.timeoutUnit  -in $w.timeoutFrame -side left

    LabelFrame $w.windowFrame
    $w.windowFrame checkbutton $w.windowFrame.showWindowButton \
	-variable cmd_buf(SHOW_WINDOW)
    set f [$w.windowFrame subwidget frame]

    frame $f.posFrame
    label $f.posLabel
    label $f.posXLabel
    entry $f.posXEntry -textvariable cmd_buf(WINDOW_POS_X)
    label $f.posYLabel
    entry $f.posYEntry -textvariable cmd_buf(WINDOW_POS_Y)
    pack $f.posLabel $f.posXLabel $f.posXEntry $f.posYLabel $f.posYEntry \
	-in $f.posFrame -side left

    checkbutton $f.hideButton -variable cmd_buf(HIDE_WINDOW)

    cmded:set_window_state $f cmd_buf(SHOW_WINDOW)
    Widget:SetTrace $f cmd_buf(SHOW_WINDOW) w \
	[list cmded:set_window_state $f cmd_buf(SHOW_WINDOW)]

    pack $f.posFrame -side top -anchor w
    pack $f.hideButton -side top -anchor w

    LabelFrame $w.commandFrame
    $w.commandFrame label $w.commandFrame.commandFrameLabel
    set f [$w.commandFrame subwidget frame]

    label $f.menuLabel
    listbox $f.menuList -yscrollcommand [list $f.menuScroll set] \
	-exportselection 0
    scrollbar $f.menuScroll -command [list $f.menuList yview]

    button $f.deleteButton -command [list cmded:delete_button $f]
    button $f.upButton     -command [list cmded:up_button     $f]
    button $f.downButton   -command [list cmded:down_button   $f]

    label $f.labelLabel
    entry $f.labelEntry
    label $f.commandLabel
    entry $f.commandEntry

    checkbutton $f.specifyButton -variable cmd_specify_names_flag
    entry $f.specifyEntry -textvariable cmd_specify_names
    cmded:set_specify_state $f.specifyEntry cmd_specify_names_flag
    Widget:SetTrace $f.specifyEntry cmd_specify_names_flag w \
	[list cmded:set_specify_state $f.specifyEntry cmd_specify_names_flag]

    checkbutton $f.disconButton -variable cmd_discon_flag

    button $f.addButton    -command [list cmded:add_button    $f]
    button $f.clearButton  -command [list cmded:clear_button  $f]

    button $w.okButton -command [list cmded:ok_button $w $f]
    button $w.cancelButton -command [list cmded:cancel_button $w]

    bind $f.menuList <Button-1> [list cmded:menu_list_set $f]
    bind $f.menuList <ButtonRelease-1> [list cmded:menu_list_select $f %x %y]

    foreach i $cmd_list_buf {
	$f.menuList insert end [lindex $i 0]
    }
    frame $f.updownFrame; lower $f.updownFrame
    pack $f.upButton   -in $f.updownFrame -side top
    pack $f.downButton -in $f.updownFrame -side top

    grid $f.menuLabel    -column 0 -row 0 -sticky w  -columnspan 3
    grid $f.menuList     -column 0 -row 1 -sticky ns -columnspan 3 \
	-rowspan 6
    grid $f.menuScroll   -column 3 -row 1 -sticky ns -rowspan 6
    grid $f.deleteButton -column 0 -row 7 -sticky w
    grid $f.updownFrame  -column 1 -row 7 -sticky w

    grid $f.labelLabel    -column 4 -row 0 -sticky w  -columnspan 3
    grid $f.labelEntry    -column 4 -row 1 -sticky ew -columnspan 3
    grid $f.commandLabel  -column 4 -row 2 -sticky w  -columnspan 3
    grid $f.commandEntry  -column 4 -row 3 -sticky ew -columnspan 3
    grid $f.specifyButton -column 4 -row 4 -sticky w  -columnspan 3
    grid $f.specifyEntry  -column 4 -row 5 -sticky ew -columnspan 3
    grid $f.disconButton  -column 4 -row 6 -sticky w  -columnspan 3

    grid $f.addButton   -column 5 -row 7 -sticky e
    grid $f.clearButton -column 6 -row 7 -sticky e

    grid columnconfigure $f 2 -weight 1
    grid columnconfigure $f 4 -weight 1

    frame $w.f2; lower $w.f2

    pack $w.okButton     -in $w.f2 -side left
    pack $w.cancelButton -in $w.f2 -side left

    pack $w.pathFrame    -side top -anchor w
    pack $w.timeoutFrame -side top -anchor w
    pack $w.windowFrame  -side top -fill x -expand yes -padx 5
    pack $w.commandFrame -side top -fill both -expand yes -padx 5
    pack $w.f2 -side top -anchor e
}

proc cmded:set_window_state {w flagname} {
    upvar \#0 $flagname flag

    if {$flag} {
	Widget:SetEntryState $w.posXEntry normal
	Widget:SetEntryState $w.posYEntry normal
	$w.hideButton configure -state normal
    } else {
	Widget:SetEntryState $w.posXEntry disabled
	Widget:SetEntryState $w.posYEntry disabled
	$w.hideButton configure -state disabled
    }
}

proc cmded:set_specify_state {e flagname} {
    upvar \#0 $flagname flag

    if $flag {
	Widget:SetEntryState $e normal
    } else {
	$e delete 0 end
	Widget:SetEntryState $e disabled
    }
}

proc cmded:show_menu_command {f index} {
    global cmd_specify_names_flag cmd_discon_flag
    global cmd_list_buf

    if {!($index == "end" || $index >= 0)} {
	return
    }
    set c [lindex $cmd_list_buf $index]
    $f.labelEntry delete 0 end
    $f.labelEntry insert 0 [lindex $c 0]
    $f.commandEntry delete 0 end
    $f.commandEntry insert 0 [lindex $c 1]

    $f.specifyEntry configure -state normal
    $f.specifyEntry delete 0 end
    set names [lindex $c 2]
    if {$names == ""} {
	set cmd_specify_names_flag 0
    } else {
	set cmd_specify_names_flag 1
	$f.specifyEntry insert 0 $names
    }
    set cmd_discon_flag [lindex $c 3]
}

proc cmded:menu_list_set {f} {
    global cmd_discon_flag
    global cmd_list_buf

    set sel [$f.menuList curselection]
    if {$sel == ""} {
	return
    }
    set c [lindex $cmd_list_buf $sel]
    if {[lindex $c 0] != [$f.labelEntry get]} {
	return
    }
    set c [lreplace $c 1 3 \
	       [$f.commandEntry get] [$f.specifyEntry get] $cmd_discon_flag]
    set cmd_list_buf [lreplace $cmd_list_buf $sel $sel $c]
}

proc cmded:menu_list_select {f x y} {
    cmded:show_menu_command $f [$f.menuList index @$x,$y]
}

proc cmded:clear_button {f} {
    cmded:menu_list_set $f

    $f.labelEntry delete 0 end
    $f.commandEntry delete 0 end

    $f.specifyEntry configure -state normal
    $f.specifyEntry delete 0 end

    global cmd_specify_names_flag
    set cmd_specify_names_flag 0

    global cmd_discon_flag
    set cmd_discon_flag 0

    $f.menuList selection clear 0 end
}

proc cmded:add_button {f} {
    global cmd_specify_names_flag cmd_discon_flag
    global cmd_list_buf

    set label [string trim [$f.labelEntry get]]
    if {$label == ""} {
	return
    }
    set sel [$f.menuList curselection]
    if {$sel != "" && [lindex [lindex $cmd_list_buf $sel] 0] == $label} {
	return
    }
    set cmd [string trim [$f.commandEntry get]]

    if $cmd_specify_names_flag {
	set names [string trim [$f.specifyEntry get]]
    } else {
	set names {}
    }
    lappend cmd_list_buf [list $label $cmd $names $cmd_discon_flag]

    $f.menuList insert end $label
    $f.menuList see end
    $f.menuList selection clear 0 end
    $f.menuList selection set end
    cmded:show_menu_command $f end
}

proc cmded:delete_button {f} {
    global cmd_list_buf

    set sel [$f.menuList curselection]
    if {$sel == ""} {
	return
    }
    set cmd_list_buf [lreplace $cmd_list_buf $sel $sel]

    $f.menuList delete $sel $sel
    if {$sel < [$f.menuList index end]} {
	$f.menuList selection set $sel
    } else {
	$f.menuList selection set end
    }
}

proc cmded:updown_button {f step min max} {
    global cmd_list_buf

    set n [$f.menuList curselection]
    if {$n == "" || $n < $min || $n > $max} {
	return
    }
    set m $n
    incr n $step

    set c [lindex $cmd_list_buf $m]
    set cmd_list_buf [lreplace $cmd_list_buf $m $m]
    set cmd_list_buf [linsert  $cmd_list_buf $n $c]

    $f.menuList selection clear 0 end
    $f.menuList delete $m $m
    $f.menuList insert $n [lindex [lindex $cmd_list_buf $n] 0]
    $f.menuList selection set $n
}

proc cmded:up_button {f} {
    global cmd_list_buf
    cmded:updown_button $f -1 1 [expr [llength $cmd_list_buf] - 1]
}

proc cmded:down_button {f} {
    global cmd_list_buf
    cmded:updown_button $f 1 0 [expr [llength $cmd_list_buf] - 2]
}

proc cmded:cancel_button {w} {
    Toplevel:Close $w
}

proc cmded:ok_button {w f} {
    cmded:clear_button $f
    update

    global CMD_VAR cmd_buf cmd_list cmd_list_buf

    set save 0
    foreach i [array names CMD_VAR] {
	if {$CMD_VAR($i) != $cmd_buf($i)} {
	    set CMD_VAR($i) $cmd_buf($i)
	    set save 1
	}
    }
    if {$cmd_list != $cmd_list_buf} {
	set cmd_list $cmd_list_buf
	set save 1
    }
    if $save {
	cmd:save_file
    }
    Toplevel:Close $w
}

set cmdex_current(command) {}
set cmdex_current(proc_id) {}
set cmdex_current(file_id) {}
set cmdex_current(status_id) {}
set cmdex_current(connect_flag) 0

proc cmdex:start {lbl cmd discon_flag log} {
    global cmdex_current CMD_VAR

    if {$cmdex_current(command) != ""} {
	return
    }
    set cmdex_current(command) $cmd

    global DEBUG
    if {[PPxP:OnLine] || $DEBUG} {
	set cmdex_current(connect_flag) 0
	cmdex:exec $lbl $cmd $discon_flag $log
    } else {
	global PPxP
	$PPxP connect
	set cmdex_current(connect_flag) 1

	set cmdex_current(status_id) \
	    [PPxP:RegisterUpdateStatus \
		 [list cmdex:exec_online $lbl $cmd $discon_flag $log]]

	if {$CMD_VAR(CONNECT_TIMEOUT) > 0} {
	    set cmdex_current(timeout_id) \
		[after [expr $CMD_VAR(CONNECT_TIMEOUT)*1000] {
		    PPxP:UnregisterUpdate $cmdex_current(status_id)
		    set cmdex_current(status_id) {}
		    cmdex:finish 1
		}]
	}
    }
}

proc cmdex:finish {discon_flag} {
    global cmdex_current
    set cmdex_current(command) {}
    set cmdex_current(proc_id) {}
    set cmdex_current(file_id) {}
    set cmdex_current(connect_flag) 0

    global PPxP
    if $discon_flag {
	$PPxP disconnect
    }
}

proc cmdex:clear_handlers {} {
    global cmdex_current

    if {[info exists cmdex_current(timeout_id)] &&
	$cmdex_current(timeout_id) != ""} {

	after cancel $cmdex_current(timeout_id)
	set cmdex_current(timeout_id) {}
    }
    if {[info exists cmdex_current(status_id)] &&
	$cmdex_current(status_id) != ""} {

	PPxP:UnregisterUpdate $cmdex_current(status_id)
	set cmdex_current(status_id) {}
    }
}

proc cmdex:output {f w lbl discon_flag} {
    if [eof $f] {
	catch {close $f}
	cmdex:finish $discon_flag

	$w insert end "[clock format [clock second]] $lbl finished."
	$w tag add msg {insert linestart} {insert lineend}
	$w insert end "\n"
	$w see end

	global CMD_VAR
	if $CMD_VAR(HIDE_WINDOW) {
	    wm withdraw [winfo toplevel $w]
	}
	return
    }
    set text [read $f]
    $w insert end $text
    $w see end
}

proc cmdex:exec {lbl cmd discon_flag w} {
    global cmdex_current env CMD_VAR
    global CMD_SHELL

    set env(PATH) $CMD_VAR(PATH)
    set f [open "| $CMD_SHELL \"$cmd\" 2>@stdout" r+]
    fconfigure $f -blocking 0
    fileevent $f readable [list cmdex:output $f $w $lbl $discon_flag]

    set cmdex_current(proc_id) [pid $f]
    set cmdex_current(file_id) $f

    $w insert end "[clock format [clock second]] $lbl start."
    $w tag add msg {insert linestart} {insert lineend}
    $w insert end "\n"
}

proc cmdex:exec_online {lbl cmd discon_flag w} {
    global cmdex_current

    if ![PPxP:OnLine] {
	return
    }
    cmdex:clear_handlers
    cmdex:exec $lbl $cmd $discon_flag $w
}

proc cmdex:option_menu {w varname first args} {
    upvar \#0 $varname var

    if ![info exists var] {
	set var [lindex $first 0]
    }
    menubutton $w -textvariable $varname -indicatoron 1 -menu $w.menu \
	-relief raised -bd 2 -highlightthickness 2 -anchor c \
	-direction flush
    menu $w.menu -tearoff 0
    $w.menu add radiobutton -variable $varname \
	-label [lindex $first 1] -value [lindex $first 0]
    foreach i $args {
	$w.menu add radiobutton -variable $varname \
	    -label [lindex $i 1] -value [lindex $i 0]
    }
    return $w.menu
}

set cmdex_signal(INT)	2
set cmdex_signal(QUIT)	3
set cmdex_signal(ABRT)	6
set cmdex_signal(KILL)	9
set cmdex_signal(ALRM)	14
set cmdex_signal(TERM)	15

proc cmdex:signal_dialog {w args} {
    global cmdex_stop cmdex_stop_signal cmdex_stop_discon

    set pid [lindex 0 $args]
    set cmdex_stop_signal TERM
    set cmdex_stop_discon 1

    label $w.message
    tk_optionMenu $w.signals cmdex_stop_signal INT QUIT ABRT KILL ALRM TERM
    checkbutton $w.disconButton -variable cmdex_stop_discon
    button $w.okButton -command "Toplevel:Close $w; set cmdex_stop 1"
    button $w.cancelButton -command "Toplevel:Close $w; set cmdex_stop 0"

    $w configure -borderwidth 5

    frame $w.f1; lower $w.f1
    pack $w.message $w.signals -in $w.f1 -side left
    frame $w.f2; lower $w.f2
    pack $w.cancelButton $w.okButton -in $w.f2 -side left

    pack $w.f1 $w.disconButton -side top -anchor w
    pack $w.f2 -side top -anchor e
}

proc cmdex:stop {w} {
    global cmdex_current cmdex_signal

    update
    cmdex:clear_handlers

    if {$cmdex_current(proc_id) != ""} {
	global CMD_KILL
	global cmdex_stop cmdex_stop_signal cmdex_stop_discon

	Toplevel:Start $w.stopDialog TkppxpCommandStop \
	    "PPxP Stop Command" 0 cmdex:signal_dialog $cmdex_current(proc_id)
#	wm transient $w.stopDialog
#	wm overrideredirect $w.stopDialog 1
	tkwait variable cmdex_stop

	if $cmdex_stop {
	    set pid $cmdex_current(proc_id)
	    catch {exec $CMD_KILL -$cmdex_signal($cmdex_stop_signal) $pid}

	    if $cmdex_stop_discon {
		global PPxP
		set cmdex_current(connect_flag) 0
		$PPxP disconnect
	    }
	}
    } elseif $cmdex_current(connect_flag) {
	global PPxP
	set cmdex_current(connect_flag) 0
	$PPxP disconnect
	cmdex:finish 0
    }
}

proc cmdex:start_window {w args} {
    label $w.commandLabel
    entry $w.currentCommand -textvariable cmdex_current(command)
    Widget:SetEntryState $w.currentCommand readonly

    label $w.pidLabel
    entry $w.currentPid -textvariable cmdex_current(proc_id)
    Widget:SetEntryState $w.currentPid readonly

    button $w.stopButton -command [list cmdex:stop $w]

    text $w.logText \
	-yscrollcommand [list $w.yscroll set]
    scrollbar $w.yscroll -orient vertical   -command [list $w.logText yview]
    $w.logText tag configure msg -foreground blue

    button $w.clearButton -command [list $w.logText delete 1.0 end]
    button $w.closeButton -command [list wm withdraw $w]

    frame $w.f1; lower $w.f1
    pack $w.commandLabel -in $w.f1 -side left
    pack $w.currentCommand -in $w.f1 -side left -fill x -expand yes
    pack $w.pidLabel -in $w.f1 -side left
    pack $w.currentPid -in $w.f1 -side left
    pack $w.stopButton -in $w.f1 -side left

    frame $w.f2; lower $w.f2
    pack $w.logText -in $w.f2 -side left -fill both -expand yes
    pack $w.yscroll -in $w.f2 -side left -fill y

    frame $w.f3; lower $w.f3
    pack $w.clearButton -in $w.f3 -side left
    pack $w.closeButton -in $w.f3 -side left

    pack $w.f1 -side top -fill x
    pack $w.f2 -side top -fill both -expand yes
    pack $w.f3 -side top -anchor e
}

proc cmd:show_window {} {
    global CMD_VAR

    set w .tkppxpCommandExec

    Toplevel:Start $w TkppxpCommandExec \
	"PPxP Command Execution" 0 cmdex:start_window {}

    if {$CMD_VAR(WINDOW_POS_X) != "" && $CMD_VAR(WINDOW_POS_Y) != ""} {
	wm withdraw $w
	update idletasks
	if {$CMD_VAR(WINDOW_POS_X) >= 0} {
	    set x "+[expr $CMD_VAR(WINDOW_POS_X)]"
	} else {
	    set x "-[expr -$CMD_VAR(WINDOW_POS_X)]"
	}
	if {$CMD_VAR(WINDOW_POS_Y) >= 0} {
	    set y "+[expr $CMD_VAR(WINDOW_POS_Y)]"
	} else {
	    set y "-[expr -$CMD_VAR(WINDOW_POS_Y)]"
	}
	wm geometry $w $x$y
	wm deiconify $w
    }
}

proc cmd:start_command {lbl cmd discon_flag} {
    global CMD_VAR

    cmd:show_window
    if !$CMD_VAR(SHOW_WINDOW) {
	wm withdraw .tkppxpCommandExec
    }
    if [PPxP:OnLine] {
	set discon_flag 0
    }
    cmdex:start $lbl $cmd $discon_flag .tkppxpCommandExec.logText
}

proc cmd:set_menu {menu} {
    global cmd_list PPxPVar

    $menu delete 0 end

    foreach i $cmd_list {
	set label  [lindex $i 0]
	set cmd    [lindex $i 1]
	set names  [lindex $i 2]
	set discon [lindex $i 3]

	if {$names == "" || [lsearch -exact $names $PPxPVar(NAME)] >= 0} {
	    $menu add command -label $label \
		-command [list cmd:start_command $label $cmd $discon]
	}
    }
    $menu add separator
    $menu add command -label "Edit commands" -command {cmd:edit 0}
    $menu add command -label "Show command window" -command {cmd:show_window}
}

proc Cmd:CreateMenu {menu} {
    global CMD_VAR cmd_list

    if ![info exists CMD_VAR(VERSION)] {
	cmd:load_file
    }
    cmd:set_menu $menu
    Widget:SetTrace $menu cmd_list w [list cmd:set_menu $menu]
    PPxP:UpdateVarWidget $menu NAME [list cmd:set_menu $menu]
}

proc Command {args} {
    global cmd_list
    lappend cmd_list $args
}

proc cmd:load_file {} {
    global PPxP_UsrPath PPxPVar
    global CMD_VAR

    # set defaults
    set CMD_VAR(VERSION)	$PPxPVar(VERSION)
    set CMD_VAR(PATH)		"/bin:/usr/bin"
    set CMD_VAR(CONNECT_TIMEOUT)	0
    set CMD_VAR(SHOW_WINDOW)	1
    set CMD_VAR(WINDOW_POS_X)	{}
    set CMD_VAR(WINDOW_POS_Y)	{}
    set CMD_VAR(HIDE_WINDOW)	0

    if ![info exists PPxP_UsrPath] {
	return
    }
    set file [file join $PPxP_UsrPath tkppxp command]

    if ![file readable $file] {
	return
    }
    catch {source $file}
}

proc cmd:save_file {} {
    global PPxPVar PPxP_UsrPath env
    global CMD_VAR cmd_list

    if ![info exists PPxP_UsrPath] {
	return
    }
    set file [file join $PPxP_UsrPath tkppxp command]
    set f [open $file w]

    puts $f "\# DO NOT EDIT. This file is generated automatically by tkPPxP."
    puts $f ""

    foreach i [array names CMD_VAR] {
	puts $f "set CMD_VAR($i) $CMD_VAR($i)"
    }
    puts $f ""

    foreach c $cmd_list {
	puts $f "Command $c"
    }
    close $f
}
