/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: raconfigform.h
 *              
 *      Abstract: Raconfig main UI 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      MarkW           9th  Feb 04     Baseline of code
 *      Mike Skinner    22nd Feb 04     Rolled in main form GUI changes
 *      Ivo van Doorn   19th May 04     Cleanup of GUI sizings 
 ***************************************************************************/ 


#ifndef RaConfigForm_H
#define RaConfigForm_H

#include <qvariant.h>
#include <qdialog.h>

#include "rt_tool.h"
#include "qhexvalidator.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QGroupBox;
class QLabel;
class QLineEdit;
class QListView;
class QListViewItem;
class QProgressBar;
class QPushButton;
class QTabWidget;
class QWidget;
class QTextEdit;

extern PRT_PROFILE_SETTING	RTMPProfile;

class RaConfigForm : public QWidget
{ 
	Q_OBJECT

public:
	RaConfigForm( int socket_id, const char *device_name, QWidget *parent = 0, const char *name = 0 );
	~RaConfigForm();

	QTabWidget* TabWidget3;
	QWidget* tab;
	QLineEdit* LineEdit1;
	QPushButton* ConnectPushButton;
	QPushButton* RescanPushButton;
	QPushButton* AddToProfilePushButton;
	QListView* NetworkListView;
	QLabel* RadioTextLabel;
	QPushButton* RadioPushButton;

	QWidget* tab_2;
	QLabel* TextLabel1;
	QLabel* TextLabel3;
	QLabel* TextLabel4;
	QLabel* TextLabel4_2_2;
	QLabel* TextLabel2;
	QLabel* TextLabel4_2;
	QLabel* TextLabel7_1;
	QLabel* TextLabel6;
	QLabel* TextLabel15;
	QLabel* TextLabel16;
	QLabel* StatusTextLabel;
	QLabel* ChannelTextLabel;
	QLabel* RateTextLabel;
	QLabel* TxTextLabel;
	QLabel* RxTextLabel;
	QProgressBar* LinkProgressBar;
	QProgressBar* SignalProgressBar;

	QWidget* tab_3;
	QGroupBox* GroupBox1;
	QListView* ProfileListView;
	QPushButton* EditPushButton;
	QPushButton* ActivePushButton;
	QPushButton* AddPushButton;
	QPushButton* DeletePushButton;

	QWidget* tab_4;
	QGroupBox* GroupBox3;
	QLabel* ST_TextLabel8;
	QLabel* ST_TextLabel9;
	QLabel* RcvSucFrameLabel;
	QLabel* RcvCRCErrLabel;
	QLabel* RcvDropFrameLabel;
	QLabel* RcvDupFrameLabel;
	QLabel* ST_TextLabel7;
	QLabel* ST_TextLabel10;
	QLabel* ST_TextLabel17;
	QLabel* ST_TextLabel18;
	QLabel* ST_TextLabel19;
	QLabel* ST_TextLabel20;
	QGroupBox* GroupBox2;
	QLabel* ST_TextLabel2;
	QLabel* ST_TextLabel3;
	QLabel* ST_TextLabel4;
	QLabel* ST_TextLabel5;
	QLabel* ST_TextLabel6;
	QLabel* TranSucFrameLable;
	QLabel* TranSucWithoutRetryLabel;
	QLabel* TranSucAftRetryLabel;
	QLabel* TranFailAckLabel;
	QLabel* TranSucRTSLabel;
	QLabel* TranFailRTSLabel;
	QLabel* ST_TextLabel1;
	QLabel* ST_TextLabel11;
	QLabel* ST_TextLabel12;
	QLabel* ST_TextLabel13;
	QLabel* ST_TextLabel14;
	QLabel* ST_TextLabel15_2;
	QLabel* ST_TextLabel16_2;
	QPushButton* ResetPushButton;

	QWidget* tab_5;
	QGroupBox* GroupBox4;
	QLabel* Date_TextLabel1;
	QLabel* UIVersionTextLabel;
	QLabel* Ver_TextLabel1;
	QLabel* UIDateTextLabel;
	QGroupBox* GroupBox5;
	QLabel* Ver_TextLabel2;
	QLabel* Date_TextLabel2;
	QLabel* NICVersionTextLabel;
	QLabel* NICDateTextLabel;
	QGroupBox* GroupBox6;
	QLabel* MACTextLabel;
	QLabel* phy_AddressTextLabel;
	QLabel* AboutRTlogoTextLabel;
	QPushButton* ExitPushButton;
	QLabel* cautionTextLabel;

	QHexValidator  *hexValidator;	 

	QWidget* tab_6;
	QGroupBox* SetMacGroupBox;
	QLineEdit* MacOffsetLineEdit;
	QLabel* MacOffsetTextLabel;
	QLabel* MacValueTextLabel;
	QLineEdit* MacValueLineEdit;
	QPushButton* MacQueryPushButton;
	QPushButton* MacSetPushButton;
	QLabel* SetMacTextLabel1_2;
	QGroupBox* SetBBPGroupBox;
	QLabel* SetMacTextLabel4_3;
	QLabel* SetMacTextLabel5;
	QLineEdit* BBPIDLineEdit;
	QLabel* SetMacTextLabel6_2;
	QPushButton* BBPSetPushButton;
	QLineEdit* BBPValueLineEdit;
	QPushButton* BBPQueryPushButton;
	QGroupBox* SetRFGroupBox;
	QLabel* SetMacTextLabel9;
	QLabel* SetMacTextLabel8;
	QLineEdit* RFValueLineEdit;
	QPushButton* RFSetPushButton;

	QWidget* tab_7;
	QTextEdit* notesTextEdit1;
		 
	//Driver info.
	PNDIS_802_11_BSSID_LIST m_pBssidList;
	NDIS_802_11_MAC_ADDRESS m_BssidQuery;
	NDIS_802_11_MAC_ADDRESS m_BssidSet;
	PRT_PROFILE_SETTING  ProfileSetting;

	int		timerId_sitesurvey;
	int		timerId_connected;
	int		timerId_getLinkStatus;
	int		timerId_statistic;
	int		timerId_alive;
	int		timerId_refresh;
	int		timerId_updatepro;
	int		SiteItemIndex;	
	ULONG	m_lTxCount;
	ULONG	m_lRxCount;
	int		Socket_Id;
	char	*Device_Name;
	bool	m_bRescan;
	bool	m_bRadio;
	char	test_profile[255];
	char	active_profile[32+1];

	void	RescanTimerFunc();
	void	ProbeConnectStatus();
	void	UpdateProfileStatus();
	void	LinkStatusPage_Active();
	void	StatisticPage_Active();
	void	m_Get_LinkStatus();
	void	m_Get_Statistic();
	void	m_WriteToProfile();
	void	m_SaveConfig();
	void	AboutPage_Active();
	bool	ResetOidValue(NDIS_802_11_NETWORK_INFRASTRUCTURE enumInfrastructureMode = Ndis802_11Infrastructure);
	void	m_ActiveSetting(PRT_PROFILE_SETTING prtProfile);

public slots:	
	virtual void m_Connect();
	virtual void m_Rescan();
	virtual void m_TabChanged();
	virtual void AddProfile();
	virtual void DeleteProfile();
	virtual void EditProfile();
	virtual void ActiveProfile();
	virtual void timerEvent(QTimerEvent* e);
	virtual void ResetPushButton_clicked();
	virtual void AddToProfilePushButton_clicked();
	virtual void RadioPushButton_clicked();
	virtual void NetworkListView_doubleClicked();
	virtual void ProfileListView_doubleClicked();
	virtual void MacQueryPushButton_clicked();
	virtual void MacSetPushButton_clicked();
	virtual void BBPSetPushButton_clicked();
	virtual void BBPQueryPushButton_clicked();
	virtual void RFSetPushButton_clicked();	
};

#endif // RaConfigForm_H
