/*  Project sword
    
    GNU Copyleft GPL  1995. Almost No Rights Reserved.

    SUBSYSTEM:    sword.apx Application
    FILE:         tversedt.cpp
    AUTHOR:       The Sword Project Team


    OVERVIEW
    ========
    Source file for implementation of TVerseEdit (TEdit).      
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "tversedt.h"
#include <swkey.h>

void SWLookup(char *modname, SWKey &key);

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TVerseEdit, TEdit)
//{{TVerseEditRSP_TBL_BEGIN}}
    EV_WM_RBUTTONDOWN,
    EV_COMMAND(CM_EBDLOOKUP, EbdLookUp),
    EV_COMMAND(CM_VBDLOOKUP, VbdLookUp),
//{{TVerseEditRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TVerseEdit Implementation}}


TVerseEdit::TVerseEdit (TWindow* parent, int id, const char far* text, int x, int y, int w, int h, uint textLen, bool multiline, TModule* module):
    TEdit(parent, id, text, x, y, w, h, textLen, multiline, module)
{
}


TVerseEdit::~TVerseEdit ()
{
    Destroy();

    // INSERT>> Your destructor code here.

}


void TVerseEdit::EvRButtonDown (uint modKeys, TPoint& point)
{
    TEdit::EvRButtonDown(modKeys, point);

    GetCursorPos(point);
    PopupMenu.TrackPopupMenu(TPM_LEFTALIGN, point, 0, HWindow);
}


void TVerseEdit::SetupWindow ()
{
    TEdit::SetupWindow();

	PopupMenu.AppendMenu(MF_STRING, CM_EBDLOOKUP, "Easton's Bible Dictionary");
	PopupMenu.AppendMenu(MF_STRING, CM_VBDLOOKUP, "Vine's Bible Dictionary");
}


void TVerseEdit::EbdLookUp()
{
	unsigned int start, end;
	char *buf, *str;

	GetSelection(start, end);
	if (end - start) {
		buf = new char [ (end - start) + 1 ];
		GetSubText(buf, start, end);
		for (str = &buf[ strlen(buf) - 1 ]; str > buf; str--) {
			if (!isalnum(*str))
				*str = 0;
			else break;
		}
		SWLookup("Eastons", buf);
		delete [] buf;
	}
}


void TVerseEdit::VbdLookUp()
{
	unsigned int start, end;
	char *buf, *str;

	GetSelection(start, end);
	if (end - start) {
		buf = new char [ (end - start) + 1 ];
		GetSubText(buf, start, end);
		for (str = &buf[ strlen(buf) - 1 ]; str > buf; str--) {
			if (!isalnum(*str))
				*str = 0;
			else break;
		}
		SWLookup("Vines", buf);
		delete [] buf;
	}
}

