#ifndef W3M_REGEX_H
#define W3M_REGEX_H

#include <wcrx.h>
#include "Str.h"

#define RE_FLAG_BOF (1 << 0)
#define RE_FLAG_REUSE (1 << 1)
#define RE_FLAG_EOL (1 << 2)
#define RE_FLAG_EOF (1 << 3)

typedef struct {
  uirx_nfa_t *nfa;
  int igncase;
  char *position, *lposition;
} Regex;

Regex *newRegex(char *ex, int igncase, Regex *regex, char **error_msg);
int RegexSearch(Regex *re, char **pb, char **pe, int firstp);
int RegexMatch(Regex *re, char *p, int len);
void MatchedPosition(Regex *re, char **first, char **last);


/* backward compatibility */
char *regexCompile(char *ex, int igncase);
int regexSearch(char **pb, char **pe, int firstp);
int regexMatch(char *p, int len);
void matchedPosition(char **first, char **last);

#endif
