# apt-lib.pl
# Functions for installing packages from debian APT

# update_system_input()
# Returns HTML for entering a package to install
sub update_system_input
{
return "$text{'apt_input'} <input name=update size=20> <input type=button onClick='window.ifield = document.forms[1].update; chooser = window.open(\"apt_find.cgi\", \"chooser\", \"toolbar=no,menubar=no,scrollbars=yes,width=400,height=500\")' value=\"...\">";
}

# update_system_install()
# Install some package with apt
sub update_system_install
{
local (@rv, @newpacks);
print "<b>",&text('apt_install', "<tt>apt-get -y -f install $in{'update'}</tt>"),"</b><p>\n";
print "<pre>";
&additional_log('exec', undef, "apt-get -y -f install \"$in{'update'}\"");
open(CMD, "apt-get -y -f install \"$in{'update'}\" 2>&1 </dev/null |");
while(<CMD>) {
	if (/setting\s+up\s+(\S+)/i) {
		push(@rv, $1);
		}
	elsif (/packages\s+will\s+be\s+upgraded/i ||
	       /new\s+packages\s+will\s+be\s+installed/i) {
		print;
		$line = $_ = <CMD>;
		$line =~ s/^\s+//; $line =~ s/\s+$//;
		push(@newpacks, split(/\s+/, $line));
		}
	print;
	}
close(CMD);
if (!@rv && $config{'package_system'} ne 'debian' && !$?) {
	# Other systems don't list the packages installed!
	@rv = @newpacks;
	}
print "</pre>\n";
if ($?) { print "<b>$text{'apt_failed'}</b><p>\n"; }
else { print "<b>$text{'apt_ok'}</b><p>\n"; }
return @rv;
}

# update_system_form()
# Shows a form for updating all packages on the system
sub update_system_form
{
print "<h3>$text{'apt_form'}</h3>\n";
print "<form action=apt_upgrade.cgi>\n";
print "<table>\n";

print "<tr> <td><b>$text{'apt_update'}</b></td>\n";
print "<td><input type=radio name=update value=1 checked> $text{'yes'}\n";
print "<input type=radio name=update value=0> $text{'no'}</td> </tr>\n";

print "<tr> <td><b>$text{'apt_dist'}</b></td>\n";
print "<td><input type=radio name=dist value=1> $text{'yes'}\n";
print "<input type=radio name=dist value=0 checked> $text{'no'}</td> </tr>\n";

print "<tr> <td><b>$text{'apt_sim'}</b></td>\n";
print "<td><input type=radio name=sim value=1> $text{'yes'}\n";
print "<input type=radio name=sim value=0 checked> $text{'no'}</td> </tr>\n";

print "</table>\n";
print "<input type=submit value='$text{'apt_apply'}'></form>\n";
}

