/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-nbap.c                                                              */
/* asn2wrs.py -p nbap -c ./nbap.cnf -s ./packet-nbap-template -D . -O ../.. NBAP-CommonDataTypes.asn NBAP-Constants.asn NBAP-Containers.asn NBAP-IEs.asn NBAP-PDU-Contents.asn NBAP-PDU-Descriptions.asn */

/* Input file: packet-nbap-template.c */

#line 1 "./asn1/nbap/packet-nbap-template.c"
/* packet-nbap-template.c
 * Routines for UMTS Node B Application Part(NBAP) packet dissection
 * Copyright 2005, 2009 Anders Broman <anders.broman@ericsson.com>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Ref: 3GPP TS 25.433 version 6.6.0 Release 6
 */

#include "config.h"

#include <epan/packet.h>
#include <epan/sctpppids.h>
#include <epan/asn1.h>
#include <epan/conversation.h>
#include <epan/expert.h>
#include <epan/prefs.h>
#include <epan/proto_data.h>
#include <epan/uat.h>

#include <wsutil/ws_printf.h> /* ws_g_warning */

#include "packet-per.h"
#include "packet-isup.h"
#include "packet-umts_fp.h"
#include "packet-umts_mac.h"
#include "packet-rrc.h"
#include "packet-umts_rlc.h"
#include "packet-nbap.h"

#ifdef _MSC_VER
/* disable: "warning C4146: unary minus operator applied to unsigned type, result still unsigned" */
#pragma warning(disable:4146)
#endif

#define PNAME  "UTRAN Iub interface NBAP signalling"
#define PSNAME "NBAP"
#define PFNAME "nbap"


#define NBAP_IGNORE_PORT 255

/* Debug */
#define DEBUG_NBAP 0
#if DEBUG_NBAP
#include <epan/to_str.h>
#define nbap_debug(...) ws_g_warning(__VA_ARGS__)
#else
#define nbap_debug(...)
#endif

void proto_register_nbap(void);
void proto_reg_handoff_nbap(void);

/* Protocol Handles */
static dissector_handle_t fp_handle;


/*--- Included file: packet-nbap-val.h ---*/
#line 1 "./asn1/nbap/packet-nbap-val.h"
#define maxPrivateIEs                  65535
#define maxProtocolExtensions          65535
#define maxProtocolIEs                 65535
#define maxNrOfCodes                   10
#define maxNrOfDLTSs                   15
#define maxNrOfDLTSLCRs                6
#define maxNrOfErrors                  256
#define maxNrOfTFs                     32
#define maxNrOfTFCs                    1024
#define maxNrOfRLs                     16
#define maxNrOfRLs_1                   15
#define maxNrOfRLs_2                   14
#define maxNrOfRLSets                  maxNrOfRLs
#define maxNrOfDPCHs                   240
#define maxNrOfDPCHsPerRL_1            239
#define maxNrOfDPCHLCRs                240
#define maxNrOfDPCHsLCRPerRL_1         95
#define maxNrOfDPCHs768                480
#define maxNrOfDPCHs768PerRL_1         479
#define maxNrOfSCCPCHs                 8
#define maxNrOfSCCPCHsinExt            232
#define maxNrOfSCCPCHs768              480
#define maxNrOfDCHs                    128
#define maxNrOfDSCHs                   32
#define maxNrOfFACHs                   8
#define maxNrOfCCTrCHs                 16
#define maxNrOfPDSCHs                  256
#define maxNrOfHSPDSCHs                16
#define maxNrOfHSPDSCHs768             32
#define maxNrOfPUSCHs                  256
#define maxNrOfPUSCHs_1                255
#define maxNrOfPDSCHSets               256
#define maxNrOfPRACHLCRs               8
#define maxNrOfPUSCHSets               256
#define maxNrOfSCCPCHLCRs              8
#define maxNrOfSCCPCHsLCRinExt         88
#define maxNrOfULTSs                   15
#define maxNrOfULTSLCRs                6
#define maxNrOfUSCHs                   32
#define maxNrOfSlotFormatsPRACH        8
#define maxCellinNodeB                 256
#define maxCCPinNodeB                  256
#define maxCTFC                        16777215
#define maxLocalCellinNodeB            maxCellinNodeB
#define maxFPACHCell                   8
#define maxRACHCell                    maxPRACHCell
#define maxPLCCHCell                   16
#define maxPRACHCell                   16
#define maxSCCPCHCell                  32
#define maxSCCPCHCellinExt             208
#define maxSCCPCHCellinExtLCR          64
#define maxSCCPCHCell768               480
#define maxSCPICHCell                  32
#define maxTTI_count                   4
#define maxIBSEG                       16
#define maxIB                          64
#define maxFACHCell                    256
#define maxRateMatching                256
#define maxHS_PDSCHCodeNrComp_1        15
#define maxHS_SCCHCodeNrComp_1         127
#define maxNrOfCellSyncBursts          10
#define maxNrOfReceptsPerSyncFrame     16
#define maxNrOfMeasNCell               96
#define maxNrOfMeasNCell_1             95
#define maxNrOfSF                      8
#define maxTGPS                        6
#define maxCommunicationContext        1048575
#define maxNrOfLevels                  256
#define maxNoSat                       16
#define maxNoGPSItems                  8
#define maxNrOfHSSCCHs                 32
#define maxNrOfHSSICHs                 4
#define maxNrOfHSSICHs_1               3
#define maxNrOfSyncFramesLCR           512
#define maxNrOfReceptionsperSyncFrameLCR 8
#define maxNrOfSyncDLCodesLCR          32
#define maxNrOfHSSCCHCodes             4
#define maxNrOfMACdFlows               8
#define maxNrOfMACdFlows_1             7
#define maxNrOfMACdPDUIndexes          8
#define maxNrOfMACdPDUIndexes_1        7
#define maxNrOfMACdPDUSize             32
#define maxNrOfNIs                     256
#define maxNrOfPriorityQueues          8
#define maxNrOfPriorityQueues_1        7
#define maxNrOfHARQProcesses           8
#define maxNrOfContextsOnUeList        16
#define maxNrOfCellPortionsPerCell     64
#define maxNrOfCellPortionsPerCell_1   63
#define maxNrOfPriorityClasses         16
#define maxNrOfSatAlmanac_maxNoSat     16
#define maxNrOfE_AGCHs                 32
#define maxNrOfEDCHMACdFlows           8
#define maxNrOfEDCHMACdFlows_1         7
#define maxNrOfE_RGCHs_E_HICHs         32
#define maxNrOfEDCH_HARQ_PO_QUANTSTEPs 6
#define maxNrOfEDCHHARQProcesses2msEDCH 8
#define maxNrOfEDPCCH_PO_QUANTSTEPs    8
#define maxNrOfBits_MACe_PDU_non_scheduled 19982
#define maxNrOfRefETFCIs               8
#define maxNrOfRefETFCI_PO_QUANTSTEPs  29
#define maxNrofSigSeqRGHI_1            39
#define maxNoOfLogicalChannels         16
#define maxNrOfCombEDPDCH              12
#define maxE_RUCCHCell                 16
#define maxNrOfEAGCHCodes              4
#define maxNrOfRefBetas                8
#define maxNrOfE_PUCHSlots             13
#define maxNrOfEAGCHs                  32
#define maxNrOfHS_DSCH_TBSs_HS_SCCHless 4
#define maxNrOfHS_DSCH_TBSs            90
#define maxNrOfEHICHCodes              4
#define maxNrOfE_PUCHSlotsLCR          5
#define maxNrOfEPUCHcodes              16
#define maxNrOfEHICHs                  32
#define maxNrOfCommonMACFlows          8
#define maxNrOfCommonMACFlows_1        7
#define maxNrOfPagingMACFlow           4
#define maxNrOfPagingMACFlow_1         3
#define maxNrOfcommonMACQueues         8
#define maxNrOfpagingMACQueues         8
#define maxNrOfHS_DSCHTBSsE_PCH        2
#define maxGANSSSat                    64
#define maxNoGANSS                     8
#define maxSgnType                     8
#define maxFrequencyinCell             12
#define maxFrequencyinCell_1           11
#define maxHSDPAFrequency              8
#define maxHSDPAFrequency_1            7
#define maxNrOfHSSCCHsinExt            224
#define maxGANSSSatAlmanac             36
#define maxGANSSClockMod               4
#define maxNrOfEDCHRLs                 4
#define maxERNTItoRelease              256
#define maxNrOfCommonEDCH              32
#define maxNrOfCommonMACFlowsLCR       256
#define maxNrOfCommonMACFlowsLCR_1     255
#define maxNrOfHSSCCHsLCR              256
#define maxNrOfEDCHMACdFlowsLCR        256
#define maxNrOfEDCHMACdFlowsLCR_1      255
#define maxNrOfEAGCHsLCR               256
#define maxNrOfEHICHsLCR               256
#define maxnrofERUCCHsLCR              32
#define maxNrOfHSDSCH_1                32
#define maxNrOfHSDSCH                  33
#define maxGANSS_1                     7
#define maxNoOfTBSs_Mapping_HS_DSCH_SPS 4
#define maxNoOfTBSs_Mapping_HS_DSCH_SPS_1 3
#define maxNoOfHS_DSCH_TBSsLCR         64
#define maxNoOfRepetition_Period_LCR   4
#define maxNoOfRepetitionPeriod_SPS_LCR_1 3
#define maxNoOf_HS_SICH_SPS            4
#define maxNoOf_HS_SICH_SPS_1          3
#define maxNoOfNon_HS_SCCH_Assosiated_HS_SICH 4
#define maxNoOfNon_HS_SCCH_Assosiated_HS_SICH_Ext 44
#define maxMBMSServiceSelect           256
#define maxNrOfCellPortionsPerCellLCR  256
#define maxNrOfCellPortionsPerCellLCR_1 255
#define maxNrOfEDCH_1                  32
#define maxNoOfCommonH_RNTI            256
#define maxNrOfCommonMACFlowsLCRExt    248
#define maxofERNTI                     256
#define maxNrOfDCHMeasurementOccasionPatternSequence 6

/* enumerated values for ProcedureCode */
#define NBAP_ID_AUDIT   0
#define NBAP_ID_AUDITREQUIRED   1
#define NBAP_ID_BLOCKRESOURCE   2
#define NBAP_ID_CELLDELETION   3
#define NBAP_ID_CELLRECONFIGURATION   4
#define NBAP_ID_CELLSETUP   5
#define NBAP_ID_CELLSYNCHRONISATIONINITIATION  45
#define NBAP_ID_CELLSYNCHRONISATIONRECONFIGURATION  46
#define NBAP_ID_CELLSYNCHRONISATIONREPORTING  47
#define NBAP_ID_CELLSYNCHRONISATIONTERMINATION  48
#define NBAP_ID_CELLSYNCHRONISATIONFAILURE  49
#define NBAP_ID_COMMONMEASUREMENTFAILURE   6
#define NBAP_ID_COMMONMEASUREMENTINITIATION   7
#define NBAP_ID_COMMONMEASUREMENTREPORT   8
#define NBAP_ID_COMMONMEASUREMENTTERMINATION   9
#define NBAP_ID_COMMONTRANSPORTCHANNELDELETE  10
#define NBAP_ID_COMMONTRANSPORTCHANNELRECONFIGURE  11
#define NBAP_ID_COMMONTRANSPORTCHANNELSETUP  12
#define NBAP_ID_COMPRESSEDMODECOMMAND  14
#define NBAP_ID_DEDICATEDMEASUREMENTFAILURE  16
#define NBAP_ID_DEDICATEDMEASUREMENTINITIATION  17
#define NBAP_ID_DEDICATEDMEASUREMENTREPORT  18
#define NBAP_ID_DEDICATEDMEASUREMENTTERMINATION  19
#define NBAP_ID_DOWNLINKPOWERCONTROL  20
#define NBAP_ID_DOWNLINKPOWERTIMESLOTCONTROL  38
#define NBAP_ID_ERRORINDICATIONFORCOMMON  35
#define NBAP_ID_ERRORINDICATIONFORDEDICATED  21
#define NBAP_ID_INFORMATIONEXCHANGEFAILURE  40
#define NBAP_ID_INFORMATIONEXCHANGEINITIATION  41
#define NBAP_ID_INFORMATIONEXCHANGETERMINATION  42
#define NBAP_ID_INFORMATIONREPORTING  43
#define NBAP_ID_BEARERREARRANGEMENT  50
#define NBAP_ID_MBMSNOTIFICATIONUPDATE  53
#define NBAP_ID_PHYSICALSHAREDCHANNELRECONFIGURATION  37
#define NBAP_ID_PRIVATEMESSAGEFORCOMMON  36
#define NBAP_ID_PRIVATEMESSAGEFORDEDICATED  22
#define NBAP_ID_RADIOLINKADDITION  23
#define NBAP_ID_RADIOLINKDELETION  24
#define NBAP_ID_RADIOLINKFAILURE  25
#define NBAP_ID_RADIOLINKPREEMPTION  39
#define NBAP_ID_RADIOLINKRESTORATION  26
#define NBAP_ID_RADIOLINKSETUP  27
#define NBAP_ID_RESET  13
#define NBAP_ID_RESOURCESTATUSINDICATION  28
#define NBAP_ID_CELLSYNCHRONISATIONADJUSTMENT  44
#define NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCANCELLATION  29
#define NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCOMMIT  30
#define NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION  31
#define NBAP_ID_SYSTEMINFORMATIONUPDATE  32
#define NBAP_ID_UNBLOCKRESOURCE  33
#define NBAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION  34
#define NBAP_ID_RADIOLINKACTIVATION  51
#define NBAP_ID_RADIOLINKPARAMETERUPDATE  52
#define NBAP_ID_UESTATUSUPDATE  54
#define NBAP_ID_SECONDARYULFREQUENCYREPORTING  55
#define NBAP_ID_SECONDARYULFREQUENCYUPDATE  56

typedef enum _DdMode_enum {
  tdd          =   0,
  fdd          =   1,
  common       =   2
} DdMode_enum;

typedef enum _ProtocolIE_ID_enum {
  id_AICH_Information =   0,
  id_AICH_InformationItem_ResourceStatusInd =   1,
  id_BCH_Information =   7,
  id_BCH_InformationItem_ResourceStatusInd =   8,
  id_BCCH_ModificationTime =   9,
  id_BlockingPriorityIndicator =  10,
  id_Cause     =  13,
  id_CCP_InformationItem_AuditRsp =  14,
  id_CCP_InformationList_AuditRsp =  15,
  id_CCP_InformationItem_ResourceStatusInd =  16,
  id_Cell_InformationItem_AuditRsp =  17,
  id_Cell_InformationItem_ResourceStatusInd =  18,
  id_Cell_InformationList_AuditRsp =  19,
  id_CellParameterID =  23,
  id_CFN       =  24,
  id_C_ID      =  25,
  id_Unknown_38 =  38,
  id_CommonMeasurementAccuracy =  39,
  id_CommonMeasurementObjectType_CM_Rprt =  31,
  id_CommonMeasurementObjectType_CM_Rqst =  32,
  id_CommonMeasurementObjectType_CM_Rsp =  33,
  id_CommonMeasurementType =  34,
  id_CommonPhysicalChannelID =  35,
  id_CommonPhysicalChannelType_CTCH_SetupRqstFDD =  36,
  id_CommonPhysicalChannelType_CTCH_SetupRqstTDD =  37,
  id_CommunicationControlPortID =  40,
  id_ConfigurationGenerationID =  43,
  id_CRNC_CommunicationContextID =  44,
  id_CriticalityDiagnostics =  45,
  id_DCHs_to_Add_FDD =  48,
  id_DCH_AddList_RL_ReconfPrepTDD =  49,
  id_DCHs_to_Add_TDD =  50,
  id_DCH_DeleteList_RL_ReconfPrepFDD =  52,
  id_DCH_DeleteList_RL_ReconfPrepTDD =  53,
  id_DCH_DeleteList_RL_ReconfRqstFDD =  54,
  id_DCH_DeleteList_RL_ReconfRqstTDD =  55,
  id_DCH_FDD_Information =  56,
  id_DCH_TDD_Information =  57,
  id_DCH_InformationResponse =  59,
  id_Unknown_60 =  60,
  id_Unknown_61 =  61,
  id_FDD_DCHs_to_Modify =  62,
  id_TDD_DCHs_to_Modify =  63,
  id_DCH_ModifyList_RL_ReconfRqstTDD =  65,
  id_DCH_RearrangeList_Bearer_RearrangeInd = 135,
  id_DedicatedMeasurementObjectType_DM_Rprt =  67,
  id_DedicatedMeasurementObjectType_DM_Rqst =  68,
  id_DedicatedMeasurementObjectType_DM_Rsp =  69,
  id_DedicatedMeasurementType =  70,
  id_Unknown_71 =  71,
  id_DL_CCTrCH_InformationItem_RL_SetupRqstTDD =  72,
  id_DL_CCTrCH_InformationList_RL_AdditionRqstTDD =  73,
  id_DL_CCTrCH_InformationList_RL_SetupRqstTDD =  76,
  id_Unknown_75 =  75,
  id_DL_DPCH_InformationItem_RL_AdditionRqstTDD =  77,
  id_DL_DPCH_InformationList_RL_SetupRqstTDD =  79,
  id_Unknown_80 =  80,
  id_DL_DPCH_Information_RL_ReconfPrepFDD =  81,
  id_DL_DPCH_Information_RL_ReconfRqstFDD =  82,
  id_DL_DPCH_Information_RL_SetupRqstFDD =  83,
  id_DL_DPCH_TimingAdjustment =  21,
  id_DL_ReferencePowerInformationItem_DL_PC_Rqst =  84,
  id_DLReferencePower =  85,
  id_DLReferencePowerList_DL_PC_Rqst =  86,
  id_Unused_ProtocolIE_ID_87 =  87,
  id_Unknown_88 =  88,
  id_Unused_ProtocolIE_ID_89 =  89,
  id_Unused_ProtocolIE_ID_91 =  91,
  id_Unknown_92 =  92,
  id_Unused_ProtocolIE_ID_93 =  93,
  id_Unknown_95 =  95,
  id_DSCHs_to_Add_TDD =  96,
  id_DSCH_Information_DeleteList_RL_ReconfPrepTDD =  98,
  id_DSCH_Information_ModifyList_RL_ReconfPrepTDD = 100,
  id_DSCH_InformationResponse = 105,
  id_Unused_ProtocolIE_ID_106 = 106,
  id_DSCH_TDD_Information = 107,
  id_Unused_ProtocolIE_ID_108 = 108,
  id_Unknown_109 = 109,
  id_Unused_ProtocolIE_ID_112 = 112,
  id_DSCH_RearrangeList_Bearer_RearrangeInd = 136,
  id_End_Of_Audit_Sequence_Indicator = 113,
  id_FACH_Information = 116,
  id_FACH_InformationItem_ResourceStatusInd = 117,
  id_Unknown_118 = 118,
  id_FACH_ParametersList_CTCH_ReconfRqstTDD = 120,
  id_FACH_ParametersListIE_CTCH_SetupRqstFDD = 121,
  id_FACH_ParametersListIE_CTCH_SetupRqstTDD = 122,
  id_IndicationType_ResourceStatusInd = 123,
  id_Local_Cell_ID = 124,
  id_Local_Cell_Group_InformationItem_AuditRsp =   2,
  id_Local_Cell_Group_InformationItem_ResourceStatusInd =   3,
  id_Local_Cell_Group_InformationItem2_ResourceStatusInd =   4,
  id_Local_Cell_Group_InformationList_AuditRsp =   5,
  id_Local_Cell_InformationItem_AuditRsp = 125,
  id_Local_Cell_InformationItem_ResourceStatusInd = 126,
  id_Local_Cell_InformationItem2_ResourceStatusInd = 127,
  id_Local_Cell_InformationList_AuditRsp = 128,
  id_AdjustmentPeriod = 129,
  id_MaxAdjustmentStep = 130,
  id_MaximumTransmissionPower = 131,
  id_MeasurementFilterCoefficient = 132,
  id_MeasurementID = 133,
  id_MessageStructure = 115,
  id_MIB_SB_SIB_InformationList_SystemInfoUpdateRqst = 134,
  id_Unknown_137 = 137,
  id_Unknown_140 = 140,
  id_NodeB_CommunicationContextID = 143,
  id_NeighbouringCellMeasurementInformation = 455,
  id_P_CCPCH_Information = 144,
  id_P_CCPCH_InformationItem_ResourceStatusInd = 145,
  id_P_CPICH_Information = 146,
  id_P_CPICH_InformationItem_ResourceStatusInd = 147,
  id_P_SCH_Information = 148,
  id_Unknown_149 = 149,
  id_PCCPCH_Information_Cell_ReconfRqstTDD = 150,
  id_PCCPCH_Information_Cell_SetupRqstTDD = 151,
  id_Unknown_152 = 152,
  id_Unknown_153 = 153,
  id_PCH_Parameters_CTCH_ReconfRqstTDD = 155,
  id_PCH_ParametersItem_CTCH_SetupRqstFDD = 156,
  id_PCH_ParametersItem_CTCH_SetupRqstTDD = 157,
  id_PCH_Information = 158,
  id_Unknown_159 = 159,
  id_Unknown_160 = 160,
  id_PDSCH_Information_AddListIE_PSCH_ReconfRqst = 161,
  id_PDSCH_Information_ModifyListIE_PSCH_ReconfRqst = 162,
  id_PDSCHSets_AddList_PSCH_ReconfRqst = 163,
  id_PDSCHSets_DeleteList_PSCH_ReconfRqst = 164,
  id_PDSCHSets_ModifyList_PSCH_ReconfRqst = 165,
  id_PICH_Information = 166,
  id_PICH_Parameters_CTCH_ReconfRqstTDD = 168,
  id_PowerAdjustmentType = 169,
  id_PRACH_Information = 170,
  id_Unknown_171 = 171,
  id_Unknown_172 = 172,
  id_Unknown_173 = 173,
  id_PrimaryCCPCH_Information_Cell_ReconfRqstFDD = 175,
  id_PrimaryCCPCH_Information_Cell_SetupRqstFDD = 176,
  id_PrimaryCPICH_Information_Cell_ReconfRqstFDD = 177,
  id_PrimaryCPICH_Information_Cell_SetupRqstFDD = 178,
  id_PrimarySCH_Information_Cell_ReconfRqstFDD = 179,
  id_PrimarySCH_Information_Cell_SetupRqstFDD = 180,
  id_PrimaryScramblingCode = 181,
  id_Unknown_182 = 182,
  id_SCH_Information_Cell_ReconfRqstTDD = 183,
  id_SCH_Information_Cell_SetupRqstTDD = 184,
  id_PUSCH_Information_AddListIE_PSCH_ReconfRqst = 185,
  id_PUSCH_Information_ModifyListIE_PSCH_ReconfRqst = 186,
  id_PUSCHSets_AddList_PSCH_ReconfRqst = 187,
  id_PUSCHSets_DeleteList_PSCH_ReconfRqst = 188,
  id_PUSCHSets_ModifyList_PSCH_ReconfRqst = 189,
  id_RACH_Information = 190,
  id_Unknown_191 = 191,
  id_Unknown_192 = 192,
  id_Unknown_193 = 193,
  id_Unknown_194 = 194,
  id_Unknown_195 = 195,
  id_RACH_ParametersItem_CTCH_SetupRqstFDD = 196,
  id_RACH_ParameterItem_CTCH_SetupRqstTDD = 197,
  id_ReportCharacteristics = 198,
  id_Reporting_Object_RL_FailureInd = 199,
  id_Reporting_Object_RL_RestoreInd = 200,
  id_Unknown_201 = 201,
  id_RL_InformationItem_DM_Rprt = 202,
  id_RL_InformationItem_DM_Rqst = 203,
  id_RL_InformationItem_DM_Rsp = 204,
  id_RL_InformationItem_RL_AdditionRqstFDD = 205,
  id_RL_informationItem_RL_DeletionRqst = 206,
  id_RL_InformationItem_RL_FailureInd = 207,
  id_RL_InformationItem_RL_PreemptRequiredInd = 286,
  id_RL_InformationItem_RL_ReconfPrepFDD = 208,
  id_RL_InformationItem_RL_ReconfRqstFDD = 209,
  id_RL_InformationItem_RL_RestoreInd = 210,
  id_RL_InformationItem_RL_SetupRqstFDD = 211,
  id_RL_InformationList_RL_AdditionRqstFDD = 212,
  id_RL_informationList_RL_DeletionRqst = 213,
  id_RL_InformationList_RL_PreemptRequiredInd = 237,
  id_RL_InformationList_RL_ReconfPrepFDD = 214,
  id_RL_InformationList_RL_ReconfRqstFDD = 215,
  id_RL_InformationList_RL_SetupRqstFDD = 216,
  id_RL_InformationResponseItem_RL_AdditionRspFDD = 217,
  id_RL_InformationResponseItem_RL_ReconfReady = 218,
  id_RL_InformationResponseItem_RL_ReconfRsp = 219,
  id_RL_InformationResponseItem_RL_SetupRspFDD = 220,
  id_RL_InformationResponseList_RL_AdditionRspFDD = 221,
  id_RL_InformationResponseList_RL_ReconfReady = 222,
  id_RL_InformationResponseList_RL_ReconfRsp = 223,
  id_RL_InformationResponseList_RL_SetupRspFDD = 224,
  id_RL_InformationResponse_RL_AdditionRspTDD = 225,
  id_RL_InformationResponse_RL_SetupRspTDD = 226,
  id_RL_Information_RL_AdditionRqstTDD = 227,
  id_RL_Information_RL_ReconfRqstTDD = 228,
  id_RL_Information_RL_ReconfPrepTDD = 229,
  id_RL_Information_RL_SetupRqstTDD = 230,
  id_RL_ReconfigurationFailureItem_RL_ReconfFailure = 236,
  id_RL_Set_InformationItem_DM_Rprt = 238,
  id_Unknown_239 = 239,
  id_RL_Set_InformationItem_DM_Rsp = 240,
  id_RL_Set_InformationItem_RL_FailureInd = 241,
  id_RL_Set_InformationItem_RL_RestoreInd = 242,
  id_Unknown_243 = 243,
  id_Unknown_244 = 244,
  id_Unknown_245 = 245,
  id_Unknown_246 = 246,
  id_S_CCPCH_Information = 247,
  id_Unknown_248 = 248,
  id_S_CPICH_Information = 249,
  id_Unknown_250 = 250,
  id_SCH_Information = 251,
  id_Unknown_252 = 252,
  id_S_SCH_Information = 253,
  id_Unknown_254 = 254,
  id_Unknown_255 = 255,
  id_Unknown_256 = 256,
  id_Secondary_CCPCHListIE_CTCH_ReconfRqstTDD = 257,
  id_Secondary_CCPCH_parameterListIE_CTCH_SetupRqstTDD = 258,
  id_Secondary_CCPCH_Parameters_CTCH_ReconfRqstTDD = 259,
  id_SecondaryCPICH_InformationItem_Cell_ReconfRqstFDD = 260,
  id_SecondaryCPICH_InformationItem_Cell_SetupRqstFDD = 261,
  id_SecondaryCPICH_InformationList_Cell_ReconfRqstFDD = 262,
  id_SecondaryCPICH_InformationList_Cell_SetupRqstFDD = 263,
  id_SecondarySCH_Information_Cell_ReconfRqstFDD = 264,
  id_SecondarySCH_Information_Cell_SetupRqstFDD = 265,
  id_SegmentInformationListIE_SystemInfoUpdate = 266,
  id_Unknown_267 = 267,
  id_SFN       = 268,
  id_SignallingBearerRequestIndicator = 138,
  id_ShutdownTimer = 269,
  id_Start_Of_Audit_Sequence_Indicator = 114,
  id_Successful_RL_InformationRespItem_RL_AdditionFailureFDD = 270,
  id_Successful_RL_InformationRespItem_RL_SetupFailureFDD = 271,
  id_Unknown_272 = 272,
  id_Unknown_273 = 273,
  id_SyncCase  = 274,
  id_SyncCaseIndicatorItem_Cell_SetupRqstTDD_PSCH = 275,
  id_T_Cell    = 276,
  id_TargetCommunicationControlPortID = 139,
  id_TimeSlotConfigurationList_Cell_ReconfRqstTDD = 277,
  id_TimeSlotConfigurationList_Cell_SetupRqstTDD = 278,
  id_TransmissionDiversityApplied = 279,
  id_TypeOfError = 508,
  id_UARFCNforNt = 280,
  id_UARFCNforNd = 281,
  id_UARFCNforNu = 282,
  id_UL_CCTrCH_InformationItem_RL_SetupRqstTDD = 284,
  id_UL_CCTrCH_InformationList_RL_AdditionRqstTDD = 285,
  id_UL_CCTrCH_InformationList_RL_SetupRqstTDD = 288,
  id_UL_DPCH_InformationItem_RL_AdditionRqstTDD = 289,
  id_UL_DPCH_InformationList_RL_SetupRqstTDD = 291,
  id_UL_DPCH_Information_RL_ReconfPrepFDD = 293,
  id_UL_DPCH_Information_RL_ReconfRqstFDD = 294,
  id_UL_DPCH_Information_RL_SetupRqstFDD = 295,
  id_Unsuccessful_RL_InformationRespItem_RL_AdditionFailureFDD = 296,
  id_Unsuccessful_RL_InformationRespItem_RL_SetupFailureFDD = 297,
  id_Unknown_298 = 298,
  id_Unknown_299 = 299,
  id_Unsuccessful_RL_InformationResp_RL_AdditionFailureTDD = 300,
  id_Unsuccessful_RL_InformationResp_RL_SetupFailureTDD = 301,
  id_USCH_Information_Add = 302,
  id_Unknown_303 = 303,
  id_USCH_Information_DeleteList_RL_ReconfPrepTDD = 304,
  id_Unknown_305 = 305,
  id_USCH_Information_ModifyList_RL_ReconfPrepTDD = 306,
  id_Unknown_307 = 307,
  id_Unknown_308 = 308,
  id_USCH_InformationResponse = 309,
  id_USCH_Information = 310,
  id_USCH_RearrangeList_Bearer_RearrangeInd = 141,
  id_Unknown_313 = 313,
  id_Active_Pattern_Sequence_Information = 315,
  id_AICH_ParametersListIE_CTCH_ReconfRqstFDD = 316,
  id_AdjustmentRatio = 317,
  id_Unknown_318 = 318,
  id_Unknown_319 = 319,
  id_Not_Used_320 = 320,
  id_Unknown_321 = 321,
  id_Not_Used_322 = 322,
  id_FACH_ParametersListIE_CTCH_ReconfRqstFDD = 323,
  id_CauseLevel_PSCH_ReconfFailure = 324,
  id_CauseLevel_RL_AdditionFailureFDD = 325,
  id_CauseLevel_RL_AdditionFailureTDD = 326,
  id_CauseLevel_RL_ReconfFailure = 327,
  id_CauseLevel_RL_SetupFailureFDD = 328,
  id_CauseLevel_RL_SetupFailureTDD = 329,
  id_Not_Used_330 = 330,
  id_Unknown_331 = 331,
  id_Not_Used_332 = 332,
  id_Closed_Loop_Timing_Adjustment_Mode = 333,
  id_CommonPhysicalChannelType_CTCH_ReconfRqstFDD = 334,
  id_Compressed_Mode_Deactivation_Flag = 335,
  id_Not_Used_336 = 336,
  id_Unknown_337 = 337,
  id_Unknown_338 = 338,
  id_Unknown_339 = 339,
  id_Unknown_340 = 340,
  id_Unknown_341 = 341,
  id_Not_Used_342 = 342,
  id_Not_Used_343 = 343,
  id_Unknown_344 = 344,
  id_Unknown_345 = 345,
  id_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = 346,
  id_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = 347,
  id_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = 348,
  id_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = 349,
  id_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = 350,
  id_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = 351,
  id_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = 352,
  id_DL_DPCH_InformationAddListIE_RL_ReconfPrepTDD = 353,
  id_Unknown_354 = 354,
  id_DL_DPCH_InformationModify_AddListIE_RL_ReconfPrepTDD = 355,
  id_DL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD = 356,
  id_DL_DPCH_InformationModify_ModifyListIE_RL_ReconfPrepTDD = 357,
  id_DL_TPC_Pattern01Count = 358,
  id_DPC_Mode  = 450,
  id_DPCHConstant = 359,
  id_Unused_ProtocolIE_ID_94 =  94,
  id_Unused_ProtocolIE_ID_110 = 110,
  id_Unused_ProtocolIE_ID_111 = 111,
  id_Unknown_360 = 360,
  id_Unknown_361 = 361,
  id_FACH_ParametersList_CTCH_SetupRsp = 362,
  id_Unknown_363 = 363,
  id_Unknown_364 = 364,
  id_Unknown_365 = 365,
  id_Unknown_366 = 366,
  id_Unknown_367 = 367,
  id_Unknown_368 = 368,
  id_Limited_power_increase_information_Cell_SetupRqstFDD = 369,
  id_Unknown_370 = 370,
  id_Unknown_371 = 371,
  id_Unknown_372 = 372,
  id_Unknown_373 = 373,
  id_PCH_Parameters_CTCH_SetupRsp = 374,
  id_PCH_ParametersItem_CTCH_ReconfRqstFDD = 375,
  id_Not_Used_376 = 376,
  id_Unknown_377 = 377,
  id_Unknown_378 = 378,
  id_Unknown_379 = 379,
  id_PICH_ParametersItem_CTCH_ReconfRqstFDD = 380,
  id_PRACHConstant = 381,
  id_Unknown_382 = 382,
  id_PRACH_ParametersListIE_CTCH_ReconfRqstFDD = 383,
  id_PUSCHConstant = 384,
  id_RACH_Parameters_CTCH_SetupRsp = 385,
  id_Unknown_386 = 386,
  id_Unknown_387 = 387,
  id_Unknown_388 = 388,
  id_Unknown_389 = 389,
  id_Unknown_390 = 390,
  id_Unknown_391 = 391,
  id_Unknown_392 = 392,
  id_Unused_ProtocolIE_ID_443 = 443,
  id_Synchronisation_Configuration_Cell_ReconfRqst = 393,
  id_Synchronisation_Configuration_Cell_SetupRqst = 394,
  id_Transmission_Gap_Pattern_Sequence_Information = 395,
  id_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = 396,
  id_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = 397,
  id_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = 398,
  id_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = 399,
  id_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = 400,
  id_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = 401,
  id_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = 402,
  id_UL_DPCH_InformationAddListIE_RL_ReconfPrepTDD = 403,
  id_Unknown_404 = 404,
  id_UL_DPCH_InformationModify_AddListIE_RL_ReconfPrepTDD = 405,
  id_UL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD = 406,
  id_UL_DPCH_InformationModify_ModifyListIE_RL_ReconfPrepTDD = 407,
  id_Unsuccessful_PDSCHSetItem_PSCH_ReconfFailureTDD = 408,
  id_Unsuccessful_PUSCHSetItem_PSCH_ReconfFailureTDD = 409,
  id_Unknown_410 = 410,
  id_Unknown_411 = 411,
  id_CommunicationContextInfoItem_Reset = 412,
  id_Unknown_413 = 413,
  id_CommunicationControlPortInfoItem_Reset = 414,
  id_Unknown_415 = 415,
  id_ResetIndicator = 416,
  id_Unused_ProtocolIE_ID_417 = 417,
  id_Unused_ProtocolIE_ID_418 = 418,
  id_Unused_ProtocolIE_ID_419 = 419,
  id_Unused_ProtocolIE_ID_142 = 142,
  id_TimingAdvanceApplied = 287,
  id_CFNReportingIndicator =   6,
  id_SFNReportingIndicator =  11,
  id_InnerLoopDLPCStatus =  12,
  id_TimeslotISCPInfo = 283,
  id_PICH_ParametersItem_CTCH_SetupRqstTDD = 167,
  id_PRACH_ParametersItem_CTCH_SetupRqstTDD =  20,
  id_CCTrCH_InformationItem_RL_FailureInd =  46,
  id_CCTrCH_InformationItem_RL_RestoreInd =  47,
  id_CauseLevel_SyncAdjustmntFailureTDD = 420,
  id_CellAdjustmentInfo_SyncAdjustmntRqstTDD = 421,
  id_CellAdjustmentInfoItem_SyncAdjustmentRqstTDD = 494,
  id_CellSyncBurstInfoList_CellSyncReconfRqstTDD = 482,
  id_CellSyncBurstTransInit_CellSyncInitiationRqstTDD = 422,
  id_CellSyncBurstMeasureInit_CellSyncInitiationRqstTDD = 423,
  id_CellSyncBurstTransReconfiguration_CellSyncReconfRqstTDD = 424,
  id_CellSyncBurstMeasReconfiguration_CellSyncReconfRqstTDD = 425,
  id_CellSyncBurstTransInfoList_CellSyncReconfRqstTDD = 426,
  id_CellSyncBurstMeasInfoList_CellSyncReconfRqstTDD = 427,
  id_CellSyncBurstTransReconfInfo_CellSyncReconfRqstTDD = 428,
  id_CellSyncInfo_CellSyncReprtTDD = 429,
  id_CSBTransmissionID = 430,
  id_CSBMeasurementID = 431,
  id_IntStdPhCellSyncInfoItem_CellSyncReprtTDD = 432,
  id_NCyclesPerSFNperiod = 433,
  id_NRepetitionsPerCyclePeriod = 434,
  id_SyncFrameNumber = 437,
  id_SynchronisationReportType = 438,
  id_SynchronisationReportCharacteristics = 439,
  id_Unsuccessful_cell_InformationRespItem_SyncAdjustmntFailureTDD = 440,
  id_Unknown_441 = 441,
  id_Unknown_442 = 442,
  id_LateEntranceCellSyncInfoItem_CellSyncReprtTDD = 119,
  id_ReferenceClockAvailability = 435,
  id_ReferenceSFNoffset = 436,
  id_InformationExchangeID = 444,
  id_InformationExchangeObjectType_InfEx_Rqst = 445,
  id_InformationType = 446,
  id_InformationReportCharacteristics = 447,
  id_InformationExchangeObjectType_InfEx_Rsp = 448,
  id_InformationExchangeObjectType_InfEx_Rprt = 449,
  id_IPDLParameter_Information_Cell_ReconfRqstFDD = 451,
  id_IPDLParameter_Information_Cell_SetupRqstFDD = 452,
  id_IPDLParameter_Information_Cell_ReconfRqstTDD = 453,
  id_IPDLParameter_Information_Cell_SetupRqstTDD = 454,
  id_DL_DPCH_LCR_Information_RL_SetupRqstTDD =  74,
  id_DwPCH_LCR_Information =  78,
  id_DwPCH_LCR_InformationList_AuditRsp =  90,
  id_DwPCH_LCR_Information_Cell_SetupRqstTDD =  97,
  id_DwPCH_LCR_Information_Cell_ReconfRqstTDD =  99,
  id_DwPCH_LCR_Information_ResourceStatusInd = 101,
  id_maxFACH_Power_LCR_CTCH_SetupRqstTDD = 154,
  id_maxFACH_Power_LCR_CTCH_ReconfRqstTDD = 174,
  id_FPACH_LCR_Information = 290,
  id_FPACH_LCR_Information_AuditRsp = 292,
  id_FPACH_LCR_InformationList_AuditRsp =  22,
  id_FPACH_LCR_InformationList_ResourceStatusInd = 311,
  id_FPACH_LCR_Parameters_CTCH_SetupRqstTDD = 312,
  id_FPACH_LCR_Parameters_CTCH_ReconfRqstTDD = 314,
  id_PCCPCH_LCR_Information_Cell_SetupRqstTDD = 456,
  id_PCH_Power_LCR_CTCH_SetupRqstTDD = 457,
  id_PCH_Power_LCR_CTCH_ReconfRqstTDD = 458,
  id_PICH_LCR_Parameters_CTCH_SetupRqstTDD = 459,
  id_Unknown_460 = 460,
  id_PRACH_LCR_ParametersList_CTCH_SetupRqstTDD = 461,
  id_Unknown_462 = 462,
  id_RL_InformationResponse_LCR_RL_SetupRspTDD = 463,
  id_Unknown_464 = 464,
  id_Secondary_CCPCH_LCR_parameterList_CTCH_SetupRqstTDD = 465,
  id_TimeSlot  = 495,
  id_TimeSlotConfigurationList_LCR_Cell_ReconfRqstTDD = 466,
  id_TimeSlotConfigurationList_LCR_Cell_SetupRqstTDD = 467,
  id_TimeslotISCP_LCR_InfoList_RL_SetupRqstTDD = 468,
  id_TimeSlotLCR_CM_Rqst = 469,
  id_UL_DPCH_LCR_Information_RL_SetupRqstTDD = 470,
  id_Unknown_471 = 471,
  id_DL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD = 472,
  id_UL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD = 473,
  id_TimeslotISCP_InformationList_LCR_RL_AdditionRqstTDD = 474,
  id_DL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD = 475,
  id_Unknown_476 = 476,
  id_DL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD = 477,
  id_Unknown_478 = 478,
  id_DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD = 479,
  id_TimeslotISCPInfoList_LCR_DL_PC_RqstTDD = 480,
  id_UL_DPCH_LCR_InformationAddListIE_RL_ReconfPrepTDD = 481,
  id_UL_DPCH_LCR_InformationModify_AddList = 483,
  id_Unknown_484 = 484,
  id_UL_TimeslotLCR_Information_RL_ReconfPrepTDD = 485,
  id_UL_SIRTarget = 510,
  id_PDSCH_AddInformation_LCR_PSCH_ReconfRqst = 486,
  id_PDSCH_AddInformation_LCR_AddListIE_PSCH_ReconfRqst = 487,
  id_Unused_ProtocolIE_ID_26 =  26,
  id_Unused_ProtocolIE_ID_27 =  27,
  id_PDSCH_ModifyInformation_LCR_PSCH_ReconfRqst = 488,
  id_PDSCH_ModifyInformation_LCR_ModifyListIE_PSCH_ReconfRqst = 489,
  id_PUSCH_AddInformation_LCR_PSCH_ReconfRqst = 490,
  id_PUSCH_AddInformation_LCR_AddListIE_PSCH_ReconfRqst = 491,
  id_PUSCH_ModifyInformation_LCR_PSCH_ReconfRqst = 492,
  id_PUSCH_ModifyInformation_LCR_ModifyListIE_PSCH_ReconfRqst = 493,
  id_timeslotInfo_CellSyncInitiationRqstTDD = 496,
  id_SyncReportType_CellSyncReprtTDD = 497,
  id_Power_Local_Cell_Group_InformationItem_AuditRsp = 498,
  id_Power_Local_Cell_Group_InformationItem_ResourceStatusInd = 499,
  id_Power_Local_Cell_Group_InformationItem2_ResourceStatusInd = 500,
  id_Power_Local_Cell_Group_InformationList_AuditRsp = 501,
  id_Power_Local_Cell_Group_InformationList_ResourceStatusInd = 502,
  id_Power_Local_Cell_Group_InformationList2_ResourceStatusInd = 503,
  id_Power_Local_Cell_Group_ID = 504,
  id_PUSCH_Info_DM_Rqst = 505,
  id_PUSCH_Info_DM_Rsp = 506,
  id_PUSCH_Info_DM_Rprt = 507,
  id_InitDL_Power = 509,
  id_cellSyncBurstRepetitionPeriod = 511,
  id_ReportCharacteristicsType_OnModification = 512,
  id_SFNSFNMeasurementValueInformation = 513,
  id_SFNSFNMeasurementThresholdInformation = 514,
  id_TUTRANGPSMeasurementValueInformation = 515,
  id_TUTRANGPSMeasurementThresholdInformation = 516,
  id_Rx_Timing_Deviation_Value_LCR = 520,
  id_RL_InformationResponse_LCR_RL_AdditionRspTDD =  51,
  id_DL_PowerBalancing_Information =  28,
  id_DL_PowerBalancing_ActivationIndicator =  29,
  id_DL_PowerBalancing_UpdatedIndicator =  30,
  id_CCTrCH_Initial_DL_Power_RL_SetupRqstTDD = 517,
  id_CCTrCH_Initial_DL_Power_RL_AdditionRqstTDD = 518,
  id_CCTrCH_Initial_DL_Power_RL_ReconfPrepTDD = 519,
  id_IPDLParameter_Information_LCR_Cell_SetupRqstTDD =  41,
  id_IPDLParameter_Information_LCR_Cell_ReconfRqstTDD =  42,
  id_HS_PDSCH_HS_SCCH_E_AGCH_E_RGCH_E_HICH_MaxPower_PSCH_ReconfRqst = 522,
  id_HS_PDSCH_HS_SCCH_ScramblingCode_PSCH_ReconfRqst = 523,
  id_HS_PDSCH_FDD_Code_Information_PSCH_ReconfRqst = 524,
  id_HS_SCCH_FDD_Code_Information_PSCH_ReconfRqst = 525,
  id_HS_PDSCH_TDD_Information_PSCH_ReconfRqst = 526,
  id_Add_To_HS_SCCH_Resource_Pool_PSCH_ReconfRqst = 527,
  id_Modify_HS_SCCH_Resource_Pool_PSCH_ReconfRqst = 528,
  id_Delete_From_HS_SCCH_Resource_Pool_PSCH_ReconfRqst = 529,
  id_bindingID = 102,
  id_RL_Specific_DCH_Info = 103,
  id_transportlayeraddress = 104,
  id_DelayedActivation = 231,
  id_DelayedActivationList_RL_ActivationCmdFDD = 232,
  id_DelayedActivationInformation_RL_ActivationCmdFDD = 233,
  id_DelayedActivationList_RL_ActivationCmdTDD = 234,
  id_DelayedActivationInformation_RL_ActivationCmdTDD = 235,
  id_neighbouringTDDCellMeasurementInformationLCR =  58,
  id_SYNCDlCodeId_TransInitLCR_CellSyncInitiationRqstTDD = 543,
  id_SYNCDlCodeId_MeasureInitLCR_CellSyncInitiationRqstTDD = 544,
  id_SYNCDlCodeIdTransReconfInfoLCR_CellSyncReconfRqstTDD = 545,
  id_SYNCDlCodeIdMeasReconfigurationLCR_CellSyncReconfRqstTDD = 546,
  id_SYNCDlCodeIdMeasInfoList_CellSyncReconfRqstTDD = 547,
  id_SyncDLCodeIdsMeasInfoList_CellSyncReprtTDD = 548,
  id_SyncDLCodeIdThreInfoLCR = 549,
  id_NSubCyclesPerCyclePeriod_CellSyncReconfRqstTDD = 550,
  id_DwPCH_Power = 551,
  id_AccumulatedClockupdate_CellSyncReprtTDD = 552,
  id_Angle_Of_Arrival_Value_LCR = 521,
  id_HSDSCH_FDD_Information = 530,
  id_HSDSCH_FDD_Information_Response = 531,
  id_Unknown_532 = 532,
  id_Unknown_533 = 533,
  id_HSDSCH_Information_to_Modify = 534,
  id_HSDSCH_RNTI = 535,
  id_HSDSCH_TDD_Information = 536,
  id_HSDSCH_TDD_Information_Response = 537,
  id_Unknown_538 = 538,
  id_Unknown_539 = 539,
  id_Unknown_540 = 540,
  id_HSPDSCH_RL_ID = 541,
  id_PrimCCPCH_RSCP_DL_PC_RqstTDD = 542,
  id_Unused_ProtocolIE_ID_64 =  64,
  id_PDSCH_RL_ID =  66,
  id_HSDSCH_RearrangeList_Bearer_RearrangeInd = 553,
  id_UL_Synchronisation_Parameters_LCR = 554,
  id_HSDSCH_FDD_Update_Information = 555,
  id_HSDSCH_TDD_Update_Information = 556,
  id_Unknown_557 = 557,
  id_DL_DPCH_TimeSlotFormat_LCR_ModifyItem_RL_ReconfPrepTDD = 558,
  id_UL_DPCH_TimeSlotFormat_LCR_ModifyItem_RL_ReconfPrepTDD = 559,
  id_TDD_TPC_UplinkStepSize_LCR_RL_SetupRqstTDD = 560,
  id_TDD_TPC_UplinkStepSize_LCR_RL_AdditionRqstTDD = 561,
  id_TDD_TPC_DownlinkStepSize_RL_AdditionRqstTDD = 562,
  id_TDD_TPC_UplinkStepSize_InformationAdd_LCR_RL_ReconfPrepTDD = 563,
  id_TDD_TPC_UplinkStepSize_InformationModify_LCR_RL_ReconfPrepTDD = 564,
  id_TDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD = 565,
  id_TDD_TPC_DownlinkStepSize_InformationAdd_RL_ReconfPrepTDD = 566,
  id_CCTrCH_Maximum_DL_Power_RL_SetupRqstTDD = 567,
  id_CCTrCH_Minimum_DL_Power_RL_SetupRqstTDD = 568,
  id_CCTrCH_Maximum_DL_Power_RL_AdditionRqstTDD = 569,
  id_CCTrCH_Minimum_DL_Power_RL_AdditionRqstTDD = 570,
  id_CCTrCH_Maximum_DL_Power_InformationAdd_RL_ReconfPrepTDD = 571,
  id_CCTrCH_Minimum_DL_Power_InformationAdd_RL_ReconfPrepTDD = 572,
  id_CCTrCH_Maximum_DL_Power_InformationModify_RL_ReconfPrepTDD = 573,
  id_CCTrCH_Minimum_DL_Power_InformationModify_RL_ReconfPrepTDD = 574,
  id_Maximum_DL_Power_Modify_LCR_InformationModify_RL_ReconfPrepTDD = 575,
  id_Minimum_DL_Power_Modify_LCR_InformationModify_RL_ReconfPrepTDD = 576,
  id_DL_DPCH_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD = 577,
  id_CCTrCH_Maximum_DL_Power_InformationModify_RL_ReconfRqstTDD = 578,
  id_CCTrCH_Minimum_DL_Power_InformationModify_RL_ReconfRqstTDD = 579,
  id_Initial_DL_Power_TimeslotLCR_InformationItem = 580,
  id_Maximum_DL_Power_TimeslotLCR_InformationItem = 581,
  id_Minimum_DL_Power_TimeslotLCR_InformationItem = 582,
  id_HS_DSCHProvidedBitRateValueInformation = 583,
  id_Unknown_584 = 584,
  id_HS_DSCHRequiredPowerValueInformation = 585,
  id_HS_DSCHRequiredPowerValue = 586,
  id_TransmittedCarrierPowerOfAllCodesNotUsedForHSTransmission = 587,
  id_HS_SICH_Reception_Quality = 588,
  id_HS_SICH_Reception_Quality_Measurement_Value = 589,
  id_HSSICH_Info_DM_Rprt = 590,
  id_HSSICH_Info_DM_Rqst = 591,
  id_HSSICH_Info_DM_Rsp = 592,
  id_Best_Cell_Portions_Value = 593,
  id_Primary_CPICH_Usage_for_Channel_Estimation = 594,
  id_Secondary_CPICH_Information_Change = 595,
  id_NumberOfReportedCellPortions = 596,
  id_CellPortion_InformationItem_Cell_SetupRqstFDD = 597,
  id_CellPortion_InformationList_Cell_SetupRqstFDD = 598,
  id_TimeslotISCP_LCR_InfoList_RL_ReconfPrepTDD = 599,
  id_Secondary_CPICH_Information = 600,
  id_Received_total_wide_band_power_For_CellPortion = 601,
  id_Unidirectional_DCH_Indicator = 602,
  id_TimingAdjustmentValueLCR = 603,
  id_multipleRL_dl_DPCH_InformationList = 604,
  id_multipleRL_dl_DPCH_InformationModifyList = 605,
  id_multipleRL_ul_DPCH_InformationList = 606,
  id_multipleRL_ul_DPCH_InformationModifyList = 607,
  id_RL_ID     = 608,
  id_SAT_Info_Almanac_ExtItem = 609,
  id_HSDPA_Capability = 610,
  id_HSDSCH_Resources_Information_AuditRsp = 611,
  id_HSDSCH_Resources_Information_ResourceStatusInd = 612,
  id_HSDSCH_MACdFlows_to_Add = 613,
  id_HSDSCH_MACdFlows_to_Delete = 614,
  id_HSDSCH_Information_to_Modify_Unsynchronised = 615,
  id_TnlQos    = 616,
  id_Received_total_wide_band_power_For_CellPortion_Value = 617,
  id_Transmitted_Carrier_Power_For_CellPortion = 618,
  id_Transmitted_Carrier_Power_For_CellPortion_Value = 619,
  id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortion = 620,
  id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue = 621,
  id_UpPTSInterferenceValue = 622,
  id_PrimaryCCPCH_RSCP_Delta = 623,
  id_MeasurementRecoveryBehavior = 624,
  id_MeasurementRecoveryReportingIndicator = 625,
  id_MeasurementRecoverySupportIndicator = 626,
  id_Tstd_indicator = 627,
  id_multiple_RL_Information_RL_ReconfPrepTDD = 628,
  id_multiple_RL_Information_RL_ReconfRqstTDD = 629,
  id_DL_DPCH_Power_Information_RL_ReconfPrepFDD = 630,
  id_F_DPCH_Information_RL_ReconfPrepFDD = 631,
  id_F_DPCH_Information_RL_SetupRqstFDD = 632,
  id_Additional_S_CCPCH_Parameters_CTCH_ReconfRqstTDD = 633,
  id_Additional_S_CCPCH_Parameters_CTCH_SetupRqstTDD = 634,
  id_Additional_S_CCPCH_LCR_Parameters_CTCH_ReconfRqstTDD = 635,
  id_Additional_S_CCPCH_LCR_Parameters_CTCH_SetupRqstTDD = 636,
  id_MICH_CFN  = 637,
  id_MICH_Information_AuditRsp = 638,
  id_MICH_Information_ResourceStatusInd = 639,
  id_MICH_Parameters_CTCH_ReconfRqstFDD = 640,
  id_MICH_Parameters_CTCH_ReconfRqstTDD = 641,
  id_MICH_Parameters_CTCH_SetupRqstFDD = 642,
  id_MICH_Parameters_CTCH_SetupRqstTDD = 643,
  id_Modification_Period = 644,
  id_NI_Information_NotifUpdateCmd = 645,
  id_S_CCPCH_InformationListExt_AuditRsp = 646,
  id_S_CCPCH_InformationListExt_ResourceStatusInd = 647,
  id_S_CCPCH_LCR_InformationListExt_AuditRsp = 648,
  id_S_CCPCH_LCR_InformationListExt_ResourceStatusInd = 649,
  id_HARQ_Preamble_Mode = 650,
  id_Initial_DL_DPCH_TimingAdjustment = 651,
  id_Initial_DL_DPCH_TimingAdjustment_Allowed = 652,
  id_DLTransmissionBranchLoadValue = 653,
  id_Power_Local_Cell_Group_choice_CM_Rqst = 654,
  id_Power_Local_Cell_Group_choice_CM_Rsp = 655,
  id_Power_Local_Cell_Group_choice_CM_Rprt = 656,
  id_SynchronisationIndicator = 657,
  id_HSDPA_And_EDCH_CellPortion_Information_PSCH_ReconfRqst = 658,
  id_Unused_ProtocolIE_ID_659 = 659,
  id_HS_DSCHRequiredPowerValue_For_Cell_Portion = 660,
  id_HS_DSCHRequiredPowerValueInformation_For_CellPortion = 661,
  id_HS_DSCHProvidedBitRateValueInformation_For_CellPortion = 662,
  id_E_AGCH_And_E_RGCH_E_HICH_FDD_Scrambling_Code = 663,
  id_E_AGCH_FDD_Code_Information = 664,
  id_E_DCH_Capability = 665,
  id_E_DCH_FDD_DL_Control_Channel_Information = 666,
  id_E_DCH_FDD_Information = 667,
  id_E_DCH_FDD_Information_Response = 668,
  id_E_DCH_FDD_Information_to_Modify = 669,
  id_E_DCH_MACdFlows_to_Add = 670,
  id_E_DCH_MACdFlows_to_Delete = 671,
  id_E_DCH_Resources_Information_AuditRsp = 672,
  id_E_DCH_Resources_Information_ResourceStatusInd = 673,
  id_E_DCH_RL_Indication = 674,
  id_E_DCH_RL_Set_ID = 675,
  id_E_DPCH_Information_RL_ReconfPrepFDD = 676,
  id_E_DPCH_Information_RL_SetupRqstFDD = 677,
  id_E_RGCH_E_HICH_FDD_Code_Information = 678,
  id_Serving_E_DCH_RL_ID = 679,
  id_UL_DPDCH_Indicator_For_E_DCH_Operation = 680,
  id_FDD_S_CCPCH_FrameOffset_CTCH_SetupRqstFDD = 681,
  id_E_DPCH_Information_RL_ReconfRqstFDD = 682,
  id_Maximum_Target_ReceivedTotalWideBandPower = 683,
  id_E_DCHProvidedBitRateValueInformation = 684,
  id_HARQ_Preamble_Mode_Activation_Indicator = 685,
  id_RL_Specific_E_DCH_Info = 686,
  id_E_DCH_CapacityConsumptionLaw = 687,
  id_multiple_DedicatedMeasurementValueList_TDD_DM_Rsp = 688,
  id_multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp = 689,
  id_E_DCH_RearrangeList_Bearer_RearrangeInd = 690,
  id_Unused_ProtocolIE_ID_691 = 691,
  id_multipleRL_dl_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = 692,
  id_Target_NonServing_EDCH_To_Total_EDCH_Power_Ratio = 693,
  id_CellPortion_InformationItem_Cell_ReconfRqstFDD = 694,
  id_CellPortion_InformationList_Cell_ReconfRqstFDD = 695,
  id_multiple_PUSCH_InfoList_DM_Rsp = 696,
  id_multiple_PUSCH_InfoList_DM_Rprt = 697,
  id_Reference_ReceivedTotalWideBandPower = 698,
  id_E_DCH_Serving_Cell_Change_Info_Response = 699,
  id_HS_DSCH_Serving_Cell_Change_Info = 700,
  id_HS_DSCH_Serving_Cell_Change_Info_Response = 701,
  id_Serving_Cell_Change_CFN = 702,
  id_E_DCH_HARQ_Combining_Capability = 703,
  id_E_DCH_TTI2ms_Capability = 704,
  id_E_DCH_SF_Capability = 705,
  id_E_DCH_FDD_Update_Information = 706,
  id_F_DPCH_Capability = 707,
  id_E_DCH_Non_serving_Relative_Grant_Down_CommandsValue = 708,
  id_HSSICH_SIRTarget = 709,
  id_multiple_HSSICHMeasurementValueList_TDD_DM_Rsp = 710,
  id_PLCCH_Information_AuditRsp = 711,
  id_PLCCH_Information_ResourceStatusInd = 712,
  id_PLCCH_Information_RL_ReconfPrepTDDLCR = 713,
  id_PLCCH_Information_UL_TimeslotLCR_Info = 714,
  id_PLCCH_InformationList_AuditRsp = 715,
  id_PLCCH_InformationList_ResourceStatusInd = 716,
  id_PLCCH_Parameters_CTCH_ReconfRqstTDD = 717,
  id_S_CCPCH_768_Parameters_CTCH_SetupRqstTDD = 718,
  id_PICH_768_Parameters_CTCH_SetupRqstTDD = 719,
  id_PRACH_768_Parameters_CTCH_SetupRqstTDD = 720,
  id_S_CCPCH_768_Parameters_CTCH_ReconfRqstTDD = 721,
  id_PICH_768_Parameters_CTCH_ReconfRqstTDD = 722,
  id_MICH_768_Parameters_CTCH_ReconfRqstTDD = 723,
  id_CommonPhysicalChannelID768_CommonTrChDeletionReq = 724,
  id_S_CCPCH_768_InformationList_AuditRsp = 725,
  id_S_CCPCH_768_Information_AuditRsp = 726,
  id_neighbouringTDDCellMeasurementInformation768 = 727,
  id_PCCPCH_768_Information_Cell_SetupRqstTDD = 728,
  id_SCH_768_Information_Cell_SetupRqstTDD = 729,
  id_SCH_768_Information_Cell_ReconfRqstTDD = 730,
  id_PCCPCH_768_Information_Cell_ReconfRqstTDD = 731,
  id_P_CCPCH_768_Information_AuditRsp = 732,
  id_PICH_768_Information_AuditRsp = 733,
  id_PRACH_768_InformationList_AuditRsp = 734,
  id_SCH_768_Information_AuditRsp = 735,
  id_MICH_768_Information_AuditRsp = 736,
  id_PRACH_768_Information = 737,
  id_S_CCPCH_768_Information_ResourceStatusInd = 738,
  id_P_CCPCH_768_Information_ResourceStatusInd = 739,
  id_PICH_768_Information_ResourceStatusInd = 740,
  id_PRACH_768_InformationList_ResourceStatusInd = 741,
  id_SCH_768_Information_ResourceStatusInd = 742,
  id_MICH_768_Information_ResourceStatusInd = 743,
  id_S_CCPCH_768_InformationList_ResourceStatusInd = 744,
  id_UL_DPCH_768_Information_RL_SetupRqstTDD = 745,
  id_DL_DPCH_768_Information_RL_SetupRqstTDD = 746,
  id_DL_DPCH_InformationItem_768_RL_AdditionRqstTDD = 747,
  id_UL_DPCH_InformationItem_768_RL_AdditionRqstTDD = 748,
  id_UL_DPCH_768_InformationAddItemIE_RL_ReconfPrepTDD = 749,
  id_UL_DPCH_768_InformationAddListIE_RL_ReconfPrepTDD = 750,
  id_UL_DPCH_768_InformationModify_AddItem = 751,
  id_UL_DPCH_768_InformationModify_AddList = 752,
  id_UL_Timeslot768_Information_RL_ReconfPrepTDD = 753,
  id_DL_DPCH_768_InformationAddItem_RL_ReconfPrepTDD = 754,
  id_DL_DPCH_768_InformationAddList_RL_ReconfPrepTDD = 755,
  id_DL_DPCH_768_InformationModify_AddItem_RL_ReconfPrepTDD = 756,
  id_DL_DPCH_768_InformationModify_AddList_RL_ReconfPrepTDD = 757,
  id_DL_Timeslot_768_InformationModify_ModifyList_RL_ReconfPrepTDD = 758,
  id_DPCH_ID768_DM_Rqst = 759,
  id_multiple_DedicatedMeasurementValueList_768_TDD_DM_Rsp = 760,
  id_DPCH_ID768_DM_Rsp = 761,
  id_Rx_Timing_Deviation_Value_768 = 762,
  id_DPCH_ID768_DM_Rprt = 763,
  id_PDSCH_AddInformation_768_PSCH_ReconfRqst = 764,
  id_PDSCH_ModifyInformation_768_PSCH_ReconfRqst = 765,
  id_PUSCH_AddInformation_768_PSCH_ReconfRqst = 766,
  id_PUSCH_ModifyInformation_768_PSCH_ReconfRqst = 767,
  id_dL_HS_PDSCH_Timeslot_Information_768_PSCH_ReconfRqst = 768,
  id_hS_SCCH_Information_768_PSCH_ReconfRqst = 769,
  id_hS_SCCH_InformationModify_768_PSCH_ReconfRqst = 770,
  id_hsSCCH_Specific_Information_ResponseTDD768 = 771,
  id_E_DPCH_Information_RL_AdditionReqFDD = 772,
  id_Unknown_773 = 773,
  id_Unknown_774 = 774,
  id_PDSCH_Timeslot_Format_PSCH_ReconfRqst_LCR = 775,
  id_Unknown_776 = 776,
  id_Unknown_777 = 777,
  id_Unknown_778 = 778,
  id_Unknown_779 = 779,
  id_PUSCH_Timeslot_Format_PSCH_ReconfRqst_LCR = 780,
  id_Unknown_781 = 781,
  id_E_DCH_PowerOffset_for_SchedulingInfo = 782,
  id_HSDSCH_Configured_Indicator = 783,
  id_Unknown_784 = 784,
  id_Unknown_785 = 785,
  id_Rx_Timing_Deviation_Value_384_ext = 786,
  id_RTWP_ReportingIndicator = 787,
  id_RTWP_CellPortion_ReportingIndicator = 788,
  id_Received_Scheduled_EDCH_Power_Share_Value = 789,
  id_Received_Scheduled_EDCH_Power_Share_For_CellPortion_Value = 790,
  id_Received_Scheduled_EDCH_Power_Share = 791,
  id_Received_Scheduled_EDCH_Power_Share_For_CellPortion = 792,
  id_tFCI_Presence = 793,
  id_HSSICH_TPC_StepSize = 794,
  id_E_RUCCH_InformationList_AuditRsp = 795,
  id_E_RUCCH_InformationList_ResourceStatusInd = 796,
  id_E_DCH_TDD_CapacityConsumptionLaw = 797,
  id_E_RUCCH_Information = 798,
  id_E_DCH_Information = 799,
  id_E_DCH_Information_Response = 800,
  id_E_DCH_Information_Reconfig = 801,
  id_E_PUCH_Information_PSCH_ReconfRqst = 802,
  id_Add_To_E_AGCH_Resource_Pool_PSCH_ReconfRqst = 803,
  id_Modify_E_AGCH_Resource_Pool_PSCH_ReconfRqst = 804,
  id_Delete_From_E_AGCH_Resource_Pool_PSCH_ReconfRqst = 805,
  id_E_HICH_Information_PSCH_ReconfRqst = 806,
  id_E_HICH_TimeOffset = 807,
  id_Maximum_Generated_ReceivedTotalWideBandPowerInOtherCells = 808,
  id_E_DCH_Serving_RL_ID = 809,
  id_E_RUCCH_768_InformationList_AuditRsp = 810,
  id_E_RUCCH_768_InformationList_ResourceStatusInd = 811,
  id_E_RUCCH_768_Information = 812,
  id_E_DCH_768_Information = 813,
  id_E_DCH_768_Information_Reconfig = 814,
  id_E_PUCH_Information_768_PSCH_ReconfRqst = 815,
  id_Add_To_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst = 816,
  id_Modify_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst = 817,
  id_E_HICH_Information_768_PSCH_ReconfRqst = 818,
  id_ExtendedPropagationDelay = 819,
  id_Extended_Round_Trip_Time_Value = 820,
  id_AlternativeFormatReportingIndicator = 821,
  id_DCH_Indicator_For_E_DCH_HSDPA_Operation = 822,
  id_Reference_ReceivedTotalWideBandPowerReporting = 823,
  id_Reference_ReceivedTotalWideBandPowerSupportIndicator = 824,
  id_ueCapability_Info = 825,
  id_MAChs_ResetIndicator = 826,
  id_Fast_Reconfiguration_Mode = 827,
  id_Fast_Reconfiguration_Permission = 828,
  id_BroadcastReference = 829,
  id_BroadcastCommonTransportBearerIndication = 830,
  id_ContinuousPacketConnectivityDTX_DRX_Capability = 831,
  id_ContinuousPacketConnectivityDTX_DRX_Information = 832,
  id_ContinuousPacketConnectivityHS_SCCH_less_Capability = 833,
  id_ContinuousPacketConnectivityHS_SCCH_less_Information = 834,
  id_ContinuousPacketConnectivityHS_SCCH_less_Information_Response = 835,
  id_CPC_Information = 836,
  id_MIMO_Capability = 837,
  id_MIMO_PilotConfiguration = 838,
  id_Unknown_839 = 839,
  id_Unknown_840 = 840,
  id_MBSFN_Cell_ParameterID_Cell_SetupRqstTDD = 841,
  id_MBSFN_Cell_ParameterID_Cell_ReconfRqstTDD = 842,
  id_S_CCPCH_Modulation = 843,
  id_HS_PDSCH_Code_Change_Grant = 844,
  id_HS_PDSCH_Code_Change_Indicator = 845,
  id_SYNC_UL_Partition_LCR = 846,
  id_E_DCH_LCR_Information = 847,
  id_E_DCH_LCR_Information_Reconfig = 848,
  id_Unknown_849 = 849,
  id_Unknown_850 = 850,
  id_Unknown_851 = 851,
  id_E_PUCH_Information_LCR_PSCH_ReconfRqst = 852,
  id_Add_To_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst = 853,
  id_Modify_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst = 854,
  id_Add_To_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst = 855,
  id_Modify_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst = 856,
  id_Delete_From_E_HICH_Resource_Pool_PSCH_ReconfRqst = 857,
  id_E_HICH_TimeOffsetLCR = 858,
  id_Unknown_859 = 859,
  id_SixtyfourQAM_DL_Capability = 860,
  id_SixteenQAM_UL_Capability = 861,
  id_Unknown_862 = 862,
  id_Unknown_863 = 863,
  id_HSDSCH_MACdPDU_SizeCapability = 864,
  id_HSDSCH_MACdPDUSizeFormat = 865,
  id_MaximumMACdPDU_SizeExtended = 866,
  id_Unknown_867 = 867,
  id_Unknown_868 = 868,
  id_Unknown_869 = 869,
  id_F_DPCH_SlotFormat = 870,
  id_F_DPCH_SlotFormatCapability = 871,
  id_LCRTDD_uplink_Physical_Channel_Capability = 872,
  id_Extended_RNC_ID = 873,
  id_Max_UE_DTX_Cycle = 874,
  id_Unknown_875 = 875,
  id_Secondary_CCPCH_SlotFormat_Extended = 876,
  id_Unknown_877 = 877,
  id_MBSFN_Only_Mode_Indicator_Cell_SetupRqstTDD_LCR = 878,
  id_MBSFN_Only_Mode_Capability = 879,
  id_Time_Slot_Parameter_ID = 880,
  id_Additional_failed_HS_SICH = 881,
  id_Additional_missed_HS_SICH = 882,
  id_Additional_total_HS_SICH = 883,
  id_Additional_HS_SICH_Reception_Quality_Measurement_Value = 884,
  id_Unknown_885 = 885,
  id_Unknown_886 = 886,
  id_GANSS_Common_Data = 887,
  id_GANSS_Information = 888,
  id_GANSS_Generic_Data = 889,
  id_TUTRANGANSSMeasurementThresholdInformation = 890,
  id_TUTRANGANSSMeasurementValueInformation = 891,
  id_ModulationPO_MBSFN = 892,
  id_Unknown_893 = 893,
  id_Unknown_894 = 894,
  id_Enhanced_FACH_Capability = 895,
  id_Enhanced_PCH_Capability = 896,
  id_HSDSCH_Common_System_InformationFDD = 897,
  id_HSDSCH_Common_System_Information_ResponseFDD = 898,
  id_HSDSCH_Paging_System_InformationFDD = 899,
  id_HSDSCH_Paging_System_Information_ResponseFDD = 900,
  id_MBMS_Capability = 901,
  id_Ext_Reference_E_TFCI_PO = 902,
  id_Ext_Max_Bits_MACe_PDU_non_scheduled = 903,
  id_HARQ_MemoryPartitioningInfoExtForMIMO = 904,
  id_MIMO_ActivationIndicator = 905,
  id_MIMO_Mode_Indicator = 906,
  id_MIMO_N_M_Ratio = 907,
  id_IPMulticastIndication = 908,
  id_IPMulticastDataBearerIndication = 909,
  id_TransportBearerNotSetupIndicator = 910,
  id_TransportBearerNotRequestedIndicator = 911,
  id_TimeSlotConfigurationList_LCR_CTCH_SetupRqstTDD = 912,
  id_Cell_Frequency_List_Information_LCR_MulFreq_AuditRsp = 913,
  id_Cell_Frequency_List_InformationItem_LCR_MulFreq_AuditRsp = 914,
  id_Cell_Frequency_List_LCR_MulFreq_Cell_SetupRqstTDD = 915,
  id_UARFCN_Adjustment = 916,
  id_Cell_Frequency_List_Information_LCR_MulFreq_ResourceStatusInd = 917,
  id_Cell_Frequency_List_InformationItem_LCR_MulFreq_ResourceStatusInd = 918,
  id_UPPCHPositionLCR = 919,
  id_UPPCH_LCR_Parameters_CTCH_ReconfRqstTDD = 920,
  id_UPPCH_LCR_InformationList_AuditRsp = 921,
  id_UPPCH_LCR_InformationItem_AuditRsp = 922,
  id_UPPCH_LCR_InformationList_ResourceStatusInd = 923,
  id_UPPCH_LCR_InformationItem_ResourceStatusInd = 924,
  id_multipleFreq_dL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst = 925,
  id_number_Of_Supported_Carriers = 926,
  id_multipleFreq_HSPDSCH_InformationList_ResponseTDDLCR = 927,
  id_Unsuccessful_UARFCNItem_PSCH_ReconfFailureTDD = 928,
  id_multipleFreq_HS_DSCH_Resources_InformationList_AuditRsp = 929,
  id_multipleFreq_HS_DSCH_Resources_InformationList_ResourceStatusInd = 930,
  id_UARFCNSpecificCauseList = 931,
  id_tSN_Length = 932,
  id_MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst = 933,
  id_multicarrier_number = 934,
  id_Extended_HS_SCCH_ID = 935,
  id_Extended_HS_SICH_ID = 936,
  id_HSSICH_InfoExt_DM_Rqst = 937,
  id_Delete_From_HS_SCCH_Resource_PoolExt_PSCH_ReconfRqst = 938,
  id_HS_SCCH_InformationExt_LCR_PSCH_ReconfRqst = 939,
  id_HS_SCCH_InformationModifyExt_LCR_PSCH_ReconfRqst = 940,
  id_PowerControlGAP = 941,
  id_MBSFN_SpecialTimeSlot_LCR = 942,
  id_Common_MACFlows_to_DeleteFDD = 943,
  id_Paging_MACFlows_to_DeleteFDD = 944,
  id_E_TFCI_Boost_Information = 945,
  id_SixteenQAM_UL_Operation_Indicator = 946,
  id_SixtyfourQAM_UsageAllowedIndicator = 947,
  id_SixtyfourQAM_DL_UsageIndicator = 948,
  id_Default_Serving_Grant_in_DTX_Cycle2 = 949,
  id_Maximum_Target_ReceivedTotalWideBandPower_LCR = 950,
  id_E_DPDCH_PowerInterpolation = 951,
  id_Extended_E_DCH_LCRTDD_PhysicalLayerCategory = 952,
  id_MultipleFreq_E_DCH_Resources_InformationList_AuditRsp = 953,
  id_MultipleFreq_E_DCH_Resources_InformationList_ResourceStatusInd = 954,
  id_MultipleFreq_E_PUCH_Timeslot_InformationList_LCR_PSCH_ReconfRqst = 955,
  id_MultipleFreq_E_PUCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst = 956,
  id_Extended_E_HICH_ID_TDD = 957,
  id_ContinuousPacketConnectivityHS_SCCH_less_Deactivate_Indicator = 958,
  id_E_DCH_MACdPDU_SizeCapability = 959,
  id_E_DCH_MACdPDUSizeFormat = 960,
  id_MaximumNumber_Of_Retransmission_for_Scheduling_Info_LCRTDD = 961,
  id_E_DCH_RetransmissionTimer_for_SchedulingInfo_LCRTDD = 962,
  id_E_HICH_TimeOffset_Extension = 963,
  id_MultipleFreq_E_HICH_TimeOffsetLCR = 964,
  id_E_PUCH_PowerControlGAP = 965,
  id_HSDSCH_TBSizeTableIndicator = 966,
  id_E_DCH_DL_Control_Channel_Change_Information = 967,
  id_E_DCH_DL_Control_Channel_Grant_Information = 968,
  id_DGANSS_Corrections_Req = 969,
  id_UE_with_enhanced_HS_SCCH_support_indicator = 970,
  id_AdditionalTimeSlotListLCR = 971,
  id_AdditionalMeasurementValueList = 972,
  id_Unknown_973 = 973,
  id_Unknown_974 = 974,
  id_Unknown_975 = 975,
  id_Unknown_976 = 976,
  id_Unknown_977 = 977,
  id_E_AGCH_Table_Choice = 978,
  id_Unknown_979 = 979,
  id_Unknown_980 = 980,
  id_PLCCH_parameters = 981,
  id_E_RUCCH_parameters = 982,
  id_E_RUCCH_768_parameters = 983,
  id_HS_Cause  = 984,
  id_E_Cause   = 985,
  id_Unknown_986 = 986,
  id_Common_EDCH_Capability = 987,
  id_E_AI_Capability = 988,
  id_Common_EDCH_System_InformationFDD = 989,
  id_Common_UL_MACFlows_to_DeleteFDD = 990,
  id_Common_EDCH_MACdFlows_to_DeleteFDD = 991,
  id_Common_EDCH_System_Information_ResponseFDD = 992,
  id_Cell_ERNTI_Status_Information = 993,
  id_Enhanced_UE_DRX_Capability = 994,
  id_Enhanced_UE_DRX_InformationFDD = 995,
  id_TransportBearerRequestIndicator = 996,
  id_SixtyfourQAM_DL_MIMO_Combined_Capability = 997,
  id_E_RNTI    = 998,
  id_MinimumReducedE_DPDCH_GainFactor = 999,
  id_GANSS_Time_ID = 1000,
  id_GANSS_AddIonoModelReq = 1001,
  id_GANSS_EarthOrientParaReq = 1002,
  id_GANSS_AddNavigationModelsReq = 1003,
  id_GANSS_AddUTCModelsReq = 1004,
  id_GANSS_AuxInfoReq = 1005,
  id_GANSS_SBAS_ID = 1006,
  id_GANSS_ID  = 1007,
  id_GANSS_Additional_Ionospheric_Model = 1008,
  id_GANSS_Earth_Orientation_Parameters = 1009,
  id_GANSS_Additional_Time_Models = 1010,
  id_GANSS_Additional_Navigation_Models = 1011,
  id_GANSS_Additional_UTC_Models = 1012,
  id_GANSS_Auxiliary_Information = 1013,
  id_ERACH_CM_Rqst = 1014,
  id_ERACH_CM_Rsp = 1015,
  id_ERACH_CM_Rprt = 1016,
  id_EDCH_RACH_Report_Value = 1017,
  id_EDCH_RACH_Report_IncrDecrThres = 1018,
  id_EDCH_RACH_Report_ThresholdInformation = 1019,
  id_E_DPCCH_Power_Boosting_Capability = 1020,
  id_HSDSCH_Common_System_InformationLCR = 1021,
  id_Unknown_1022 = 1022,
  id_HSDSCH_Common_System_Information_ResponseLCR = 1222,
  id_HSDSCH_Paging_System_InformationLCR = 1023,
  id_HSDSCH_Paging_System_Information_ResponseLCR = 1024,
  id_Common_MACFlows_to_DeleteLCR = 1025,
  id_Paging_MACFlows_to_DeleteLCR = 1026,
  id_Common_EDCH_System_InformationLCR = 1027,
  id_Common_UL_MACFlows_to_DeleteLCR = 1028,
  id_Common_EDCH_MACdFlows_to_DeleteLCR = 1029,
  id_Common_EDCH_System_Information_ResponseLCR = 1030,
  id_Enhanced_UE_DRX_CapabilityLCR = 1031,
  id_Enhanced_UE_DRX_InformationLCR = 1032,
  id_HSDSCH_PreconfigurationSetup = 1033,
  id_HSDSCH_PreconfigurationInfo = 1034,
  id_NoOfTargetCellHS_SCCH_Order = 1035,
  id_EnhancedHSServingCC_Abort = 1036,
  id_Additional_HS_Cell_Information_RL_Setup = 1037,
  id_Additional_HS_Cell_Information_Response = 1038,
  id_Additional_HS_Cell_Information_RL_Addition = 1039,
  id_Additional_HS_Cell_Change_Information_Response = 1040,
  id_Additional_HS_Cell_Information_RL_Reconf_Prep = 1041,
  id_Additional_HS_Cell_Information_RL_Reconf_Req = 1042,
  id_Additional_HS_Cell_Information_RL_Param_Upd = 1043,
  id_Multi_Cell_Capability_Info = 1044,
  id_IMB_Parameters = 1045,
  id_MACes_Maximum_Bitrate_LCR = 1046,
  id_Semi_PersistentScheduling_CapabilityLCR = 1047,
  id_E_DCH_Semi_PersistentScheduling_Information_LCR = 1048,
  id_HS_DSCH_Semi_PersistentScheduling_Information_LCR = 1049,
  id_Add_To_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst = 1050,
  id_Modify_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst = 1051,
  id_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst = 1052,
  id_ContinuousPacketConnectivity_DRX_CapabilityLCR = 1053,
  id_ContinuousPacketConnectivity_DRX_InformationLCR = 1054,
  id_ContinuousPacketConnectivity_DRX_Information_ResponseLCR = 1055,
  id_CPC_InformationLCR = 1056,
  id_HS_DSCH_Semi_PersistentScheduling_Information_ResponseLCR = 1057,
  id_E_DCH_Semi_PersistentScheduling_Information_ResponseLCR = 1058,
  id_E_AGCH_UE_Inactivity_Monitor_Threshold = 1059,
  id_Unknown_1060 = 1060,
  id_Unknown_1061 = 1061,
  id_Unknown_1062 = 1062,
  id_IdleIntervalInformation = 1063,
  id_GANSS_alm_keplerianNAVAlmanac = 1064,
  id_GANSS_alm_keplerianReducedAlmanac = 1065,
  id_GANSS_alm_keplerianMidiAlmanac = 1066,
  id_GANSS_alm_keplerianGLONASS = 1067,
  id_GANSS_alm_ecefSBASAlmanac = 1068,
  id_Unknown_1069 = 1069,
  id_HSSICH_ReferenceSignal_InformationLCR = 1070,
  id_MIMO_ReferenceSignal_InformationListLCR = 1071,
  id_MIMO_SFMode_For_HSPDSCHDualStream = 1072,
  id_MIMO_SFMode_Supported_For_HSPDSCHDualStream = 1073,
  id_UE_Selected_MBMS_Service_Information = 1074,
  id_Unknown_1075 = 1075,
  id_Unknown_1076 = 1076,
  id_MultiCarrier_HSDSCH_Physical_Layer_Category = 1077,
  id_Common_E_DCH_HSDPCCH_Capability = 1078,
  id_DL_RLC_PDU_Size_Format = 1079,
  id_HSSICH_ReferenceSignal_InformationModifyLCR = 1080,
  id_schedulingPriorityIndicator = 1081,
  id_TimeSlotMeasurementValueListLCR = 1082,
  id_Unknown_1083 = 1083,
  id_Unknown_1084 = 1084,
  id_UE_SupportIndicatorExtension = 1085,
  id_Unknown_1086 = 1086,
  id_Unknown_1087 = 1087,
  id_Single_Stream_MIMO_ActivationIndicator = 1088,
  id_Single_Stream_MIMO_Capability = 1089,
  id_Single_Stream_MIMO_Mode_Indicator = 1090,
  id_Dual_Band_Capability_Info = 1091,
  id_UE_AggregateMaximumBitRate = 1092,
  id_UE_AggregateMaximumBitRate_Enforcement_Indicator = 1093,
  id_Unknown_1094 = 1094,
  id_Unknown_1095 = 1095,
  id_Unknown_1096 = 1096,
  id_Unknown_1097 = 1097,
  id_Unknown_1098 = 1098,
  id_Unknown_1099 = 1099,
  id_Unknown_1100 = 1100,
  id_MIMO_Power_Offset_For_S_CPICH_Capability = 1101,
  id_MIMO_PilotConfigurationExtension = 1102,
  id_TxDiversityOnDLControlChannelsByMIMOUECapability = 1103,
  id_ULTimeslotISCPValue_For_CellPortion = 1104,
  id_UpPTSInterferenceValue_For_CellPortion = 1105,
  id_Best_Cell_Portions_ValueLCR = 1106,
  id_Transmitted_Carrier_Power_For_CellPortion_ValueLCR = 1107,
  id_Received_total_wide_band_power_For_CellPortion_ValueLCR = 1108,
  id_UL_TimeslotISCP_For_CellPortion_Value = 1109,
  id_HS_DSCHRequiredPowerValueInformation_For_CellPortionLCR = 1110,
  id_HS_DSCHProvidedBitRateValueInformation_For_CellPortionLCR = 1111,
  id_E_DCHProvidedBitRateValueInformation_For_CellPortion = 1112,
  id_UpPTSInterference_For_CellPortion_Value = 1113,
  id_NumberOfReportedCellPortionsLCR = 1114,
  id_CellPortion_CapabilityLCR = 1115,
  id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortionValue = 1116,
  id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortion = 1117,
  id_Unknown_1118 = 1118,
  id_ActivationInformation = 1119,
  id_Additional_EDCH_Cell_Information_RL_Setup_Req = 1120,
  id_Additional_EDCH_Cell_Information_Response = 1121,
  id_Additional_EDCH_Cell_Information_RL_Add_Req = 1122,
  id_Additional_EDCH_Cell_Information_Response_RL_Add = 1123,
  id_Additional_EDCH_Cell_Information_RL_Reconf_Prep = 1124,
  id_Additional_EDCH_Cell_Information_RL_Reconf_Req = 1125,
  id_Additional_EDCH_Cell_Information_Bearer_Rearrangement = 1126,
  id_Additional_EDCH_Cell_Information_RL_Param_Upd = 1127,
  id_Additional_EDCH_Preconfiguration_Information = 1128,
  id_EDCH_Indicator = 1129,
  id_Unknown_1130 = 1130,
  id_HS_DSCH_SPS_Reservation_Indicator = 1131,
  id_E_DCH_SPS_Reservation_Indicator = 1132,
  id_MultipleFreq_HARQ_MemoryPartitioning_InformationList = 1133,
  id_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext = 1134,
  id_RepetitionPeriodIndex = 1135,
  id_MidambleShiftLCR = 1136,
  id_MaxHSDSCH_HSSCCH_Power_per_CELLPORTION = 1137,
  id_DormantModeIndicator = 1138,
  id_DiversityMode = 1139,
  id_TransmitDiversityIndicator = 1140,
  id_NonCellSpecificTxDiversity = 1141,
  id_Cell_Capability_Container = 1142,
  id_E_RNTI_List_Request = 1143,
  id_E_RNTI_List = 1144,
  id_PowerControlGAP_For_CellFACHLCR = 1145,
  id_Unknown_1146 = 1146,
  id_UL_Synchronisation_Parameters_For_FACHLCR = 1147,
  id_HS_DSCH_SPS_Operation_Indicator = 1148,
  id_HSDSCH_RNTI_For_FACH = 1149,
  id_E_RNTI_For_FACH = 1150,
  id_Out_of_Sychronization_Window = 1151,
  id_Max_RTWP_perUARFCN_Information_LCR_PSCH_ReconfRqst = 1152,
  id_E_HICH_TimeOffset_ReconfFailureTDD = 1153,
  id_HSSCCH_TPC_StepSize = 1154,
  id_TS0_CapabilityLCR = 1155,
  id_UE_TS0_CapabilityLCR = 1156,
  id_Common_System_Information_ResponseLCR = 1157,
  id_Additional_EDCH_Cell_Information_ResponseRLReconf = 1158,
  id_Multicell_EDCH_InformationItemIEs = 1159,
  id_Multicell_EDCH_RL_Specific_InformationItemIEs = 1160,
  id_Add_To_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext = 1161,
  id_Modify_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext = 1162,
  id_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext = 1163,
  id_Initial_DL_Transmission_Power = 1164,
  id_Maximum_DL_Power = 1165,
  id_Minimum_DL_Power = 1166,
  id_DCH_MeasurementOccasion_Information = 1167,
  id_AssociatedPhsicalChannelID = 1168,
  id_DGNSS_ValidityPeriod = 1169,
  id_PhysicalChannelID_for_CommonERNTI_RequestedIndicator = 1170,
  id_PrecodingWeightSetRestriction = 1171,
  id_Treset_Usage_Indicator = 1172,
  id_Non_Serving_RL_Preconfig_Info = 1173,
  id_Non_Serving_RL_Preconfig_Setup = 1174,
  id_Non_Serving_RL_Preconfig_Removal = 1175,
  id_Additional_E_DCH_Non_Serving_RL_Preconfiguration_Setup = 1176,
  id_Additional_E_DCH_New_non_serving_RL_E_DCH_FDD_DL_Control_Channel_InfoList = 1177,
  id_Ul_common_E_DCH_MACflow_Specific_InfoListLCR_Ext = 1178,
  id_CommonMACFlow_Specific_InfoList_ResponseLCR_Ext = 1179,
  id_Enabling_Delay_Ext_LCR = 1180,
  id_Unallocated_1181 = 1181,
  id_Unallocated_1182 = 1182,
  id_Unallocated_1183 = 1183,
  id_Unallocated_1184 = 1184,
  id_Unallocated_1185 = 1185,
  id_Unallocated_1186 = 1186,
  id_Unallocated_1187 = 1187,
  id_Unallocated_1188 = 1188,
  id_Unallocated_1189 = 1189,
  id_Unallocated_1190 = 1190,
  id_Unallocated_1191 = 1191,
  id_Unallocated_1192 = 1192,
  id_Unallocated_1193 = 1193,
  id_Unallocated_1194 = 1194,
  id_Unallocated_1195 = 1195,
  id_Unallocated_1196 = 1196,
  id_Unallocated_1197 = 1197,
  id_Unallocated_1198 = 1198,
  id_Unallocated_1199 = 1199,
  id_Unallocated_1200 = 1200,
  id_Unallocated_1201 = 1201,
  id_Unallocated_1202 = 1202,
  id_Unallocated_1203 = 1203,
  id_Unallocated_1204 = 1204,
  id_Unallocated_1205 = 1205,
  id_Unallocated_1206 = 1206,
  id_Unallocated_1207 = 1207,
  id_Unallocated_1208 = 1208,
  id_Unallocated_1209 = 1209,
  id_Unallocated_1210 = 1210,
  id_Unallocated_1211 = 1211,
  id_Unallocated_1212 = 1212,
  id_Unallocated_1213 = 1213,
  id_Unallocated_1214 = 1214,
  id_Unallocated_1215 = 1215,
  id_Unallocated_1216 = 1216,
  id_Unallocated_1217 = 1217,
  id_Unallocated_1218 = 1218,
  id_Unallocated_1219 = 1219,
  id_Unallocated_1220 = 1220,
  id_Unallocated_1221 = 1221
} ProtocolIE_ID_enum;

/*--- End of included file: packet-nbap-val.h ---*/
#line 63 "./asn1/nbap/packet-nbap-template.c"

/* Initialize the protocol and registered fields */
static int proto_nbap = -1;
static int hf_nbap_transportLayerAddress_ipv4 = -1;
static int hf_nbap_transportLayerAddress_ipv6 = -1;
static int hf_nbap_transportLayerAddress_nsap = -1;
static int hf_nbap_reassembled_information_block = -1;


/*--- Included file: packet-nbap-hf.c ---*/
#line 1 "./asn1/nbap/packet-nbap-hf.c"
static int hf_nbap_ActivationInformation_PDU = -1;  /* ActivationInformation */
static int hf_nbap_Additional_EDCH_Setup_Info_PDU = -1;  /* Additional_EDCH_Setup_Info */
static int hf_nbap_Additional_EDCH_Cell_Information_Response_List_PDU = -1;  /* Additional_EDCH_Cell_Information_Response_List */
static int hf_nbap_Additional_EDCH_Cell_Information_Response_RLReconf_List_PDU = -1;  /* Additional_EDCH_Cell_Information_Response_RLReconf_List */
static int hf_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_List_PDU = -1;  /* Additional_EDCH_Cell_Information_Response_RL_Add_List */
static int hf_nbap_AdditionalMeasurementValueList_PDU = -1;  /* AdditionalMeasurementValueList */
static int hf_nbap_AdditionalTimeSlotListLCR_PDU = -1;  /* AdditionalTimeSlotListLCR */
static int hf_nbap_Active_Pattern_Sequence_Information_PDU = -1;  /* Active_Pattern_Sequence_Information */
static int hf_nbap_AlternativeFormatReportingIndicator_PDU = -1;  /* AlternativeFormatReportingIndicator */
static int hf_nbap_Angle_Of_Arrival_Value_LCR_PDU = -1;  /* Angle_Of_Arrival_Value_LCR */
static int hf_nbap_BCCH_ModificationTime_PDU = -1;  /* BCCH_ModificationTime */
static int hf_nbap_Best_Cell_Portions_Value_PDU = -1;  /* Best_Cell_Portions_Value */
static int hf_nbap_Best_Cell_Portions_ValueLCR_PDU = -1;  /* Best_Cell_Portions_ValueLCR */
static int hf_nbap_BindingID_PDU = -1;            /* BindingID */
static int hf_nbap_BlockingPriorityIndicator_PDU = -1;  /* BlockingPriorityIndicator */
static int hf_nbap_BroadcastCommonTransportBearerIndication_PDU = -1;  /* BroadcastCommonTransportBearerIndication */
static int hf_nbap_BroadcastReference_PDU = -1;   /* BroadcastReference */
static int hf_nbap_Cause_PDU = -1;                /* Cause */
static int hf_nbap_Cell_Capability_Container_PDU = -1;  /* Cell_Capability_Container */
static int hf_nbap_Cell_ERNTI_Status_Information_PDU = -1;  /* Cell_ERNTI_Status_Information */
static int hf_nbap_CellParameterID_PDU = -1;      /* CellParameterID */
static int hf_nbap_CellPortion_CapabilityLCR_PDU = -1;  /* CellPortion_CapabilityLCR */
static int hf_nbap_CellSyncBurstRepetitionPeriod_PDU = -1;  /* CellSyncBurstRepetitionPeriod */
static int hf_nbap_CFN_PDU = -1;                  /* CFN */
static int hf_nbap_C_ID_PDU = -1;                 /* C_ID */
static int hf_nbap_Closedlooptimingadjustmentmode_PDU = -1;  /* Closedlooptimingadjustmentmode */
static int hf_nbap_Common_EDCH_Capability_PDU = -1;  /* Common_EDCH_Capability */
static int hf_nbap_Common_E_DCH_HSDPCCH_Capability_PDU = -1;  /* Common_E_DCH_HSDPCCH_Capability */
static int hf_nbap_Common_EDCH_System_InformationFDD_PDU = -1;  /* Common_EDCH_System_InformationFDD */
static int hf_nbap_Common_EDCH_System_Information_ResponseFDD_PDU = -1;  /* Common_EDCH_System_Information_ResponseFDD */
static int hf_nbap_E_RNTI_List_PDU = -1;          /* E_RNTI_List */
static int hf_nbap_Common_MACFlows_to_DeleteFDD_PDU = -1;  /* Common_MACFlows_to_DeleteFDD */
static int hf_nbap_CommonMeasurementAccuracy_PDU = -1;  /* CommonMeasurementAccuracy */
static int hf_nbap_CommonMeasurementType_PDU = -1;  /* CommonMeasurementType */
static int hf_nbap_CommonPhysicalChannelID_PDU = -1;  /* CommonPhysicalChannelID */
static int hf_nbap_CommonPhysicalChannelID768_PDU = -1;  /* CommonPhysicalChannelID768 */
static int hf_nbap_Common_PhysicalChannel_Status_Information_PDU = -1;  /* Common_PhysicalChannel_Status_Information */
static int hf_nbap_Common_PhysicalChannel_Status_Information768_PDU = -1;  /* Common_PhysicalChannel_Status_Information768 */
static int hf_nbap_CommonTransportChannel_InformationResponse_PDU = -1;  /* CommonTransportChannel_InformationResponse */
static int hf_nbap_Common_TransportChannel_Status_Information_PDU = -1;  /* Common_TransportChannel_Status_Information */
static int hf_nbap_CommunicationControlPortID_PDU = -1;  /* CommunicationControlPortID */
static int hf_nbap_Compressed_Mode_Deactivation_Flag_PDU = -1;  /* Compressed_Mode_Deactivation_Flag */
static int hf_nbap_ConfigurationGenerationID_PDU = -1;  /* ConfigurationGenerationID */
static int hf_nbap_ConstantValue_PDU = -1;        /* ConstantValue */
static int hf_nbap_ContinuousPacketConnectivityDTX_DRX_Capability_PDU = -1;  /* ContinuousPacketConnectivityDTX_DRX_Capability */
static int hf_nbap_ContinuousPacketConnectivityDTX_DRX_Information_PDU = -1;  /* ContinuousPacketConnectivityDTX_DRX_Information */
static int hf_nbap_ContinuousPacketConnectivityHS_SCCH_less_Capability_PDU = -1;  /* ContinuousPacketConnectivityHS_SCCH_less_Capability */
static int hf_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information_PDU = -1;  /* ContinuousPacketConnectivityHS_SCCH_less_Information */
static int hf_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information_Response_PDU = -1;  /* ContinuousPacketConnectivityHS_SCCH_less_Information_Response */
static int hf_nbap_ControlGAP_PDU = -1;           /* ControlGAP */
static int hf_nbap_CPC_Information_PDU = -1;      /* CPC_Information */
static int hf_nbap_ContinuousPacketConnectivityHS_SCCH_less_Deactivate_Indicator_PDU = -1;  /* ContinuousPacketConnectivityHS_SCCH_less_Deactivate_Indicator */
static int hf_nbap_CriticalityDiagnostics_PDU = -1;  /* CriticalityDiagnostics */
static int hf_nbap_CRNC_CommunicationContextID_PDU = -1;  /* CRNC_CommunicationContextID */
static int hf_nbap_CSBMeasurementID_PDU = -1;     /* CSBMeasurementID */
static int hf_nbap_CSBTransmissionID_PDU = -1;    /* CSBTransmissionID */
static int hf_nbap_Common_EDCH_System_InformationLCR_PDU = -1;  /* Common_EDCH_System_InformationLCR */
static int hf_nbap_Common_EDCH_System_Information_ResponseLCR_PDU = -1;  /* Common_EDCH_System_Information_ResponseLCR */
static int hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext_PDU = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext */
static int hf_nbap_Common_MACFlows_to_DeleteLCR_PDU = -1;  /* Common_MACFlows_to_DeleteLCR */
static int hf_nbap_CPC_InformationLCR_PDU = -1;   /* CPC_InformationLCR */
static int hf_nbap_ContinuousPacketConnectivity_DRX_CapabilityLCR_PDU = -1;  /* ContinuousPacketConnectivity_DRX_CapabilityLCR */
static int hf_nbap_ContinuousPacketConnectivity_DRX_InformationLCR_PDU = -1;  /* ContinuousPacketConnectivity_DRX_InformationLCR */
static int hf_nbap_E_AGCH_UE_Inactivity_Monitor_Threshold_PDU = -1;  /* E_AGCH_UE_Inactivity_Monitor_Threshold */
static int hf_nbap_ContinuousPacketConnectivity_DRX_Information_ResponseLCR_PDU = -1;  /* ContinuousPacketConnectivity_DRX_Information_ResponseLCR */
static int hf_nbap_DCH_FDD_Information_PDU = -1;  /* DCH_FDD_Information */
static int hf_nbap_DCH_Indicator_For_E_DCH_HSDPA_Operation_PDU = -1;  /* DCH_Indicator_For_E_DCH_HSDPA_Operation */
static int hf_nbap_DCH_InformationResponse_PDU = -1;  /* DCH_InformationResponse */
static int hf_nbap_DCH_MeasurementOccasion_Information_PDU = -1;  /* DCH_MeasurementOccasion_Information */
static int hf_nbap_DCH_TDD_Information_PDU = -1;  /* DCH_TDD_Information */
static int hf_nbap_FDD_DCHs_to_Modify_PDU = -1;   /* FDD_DCHs_to_Modify */
static int hf_nbap_TDD_DCHs_to_Modify_PDU = -1;   /* TDD_DCHs_to_Modify */
static int hf_nbap_DedicatedMeasurementType_PDU = -1;  /* DedicatedMeasurementType */
static int hf_nbap_DelayedActivation_PDU = -1;    /* DelayedActivation */
static int hf_nbap_DGANSS_Corrections_Req_PDU = -1;  /* DGANSS_Corrections_Req */
static int hf_nbap_DGNSS_ValidityPeriod_PDU = -1;  /* DGNSS_ValidityPeriod */
static int hf_nbap_DiversityMode_PDU = -1;        /* DiversityMode */
static int hf_nbap_DL_DPCH_TimingAdjustment_PDU = -1;  /* DL_DPCH_TimingAdjustment */
static int hf_nbap_DL_Power_PDU = -1;             /* DL_Power */
static int hf_nbap_DL_PowerBalancing_Information_PDU = -1;  /* DL_PowerBalancing_Information */
static int hf_nbap_DL_PowerBalancing_ActivationIndicator_PDU = -1;  /* DL_PowerBalancing_ActivationIndicator */
static int hf_nbap_DL_PowerBalancing_UpdatedIndicator_PDU = -1;  /* DL_PowerBalancing_UpdatedIndicator */
static int hf_nbap_DL_ScramblingCode_PDU = -1;    /* DL_ScramblingCode */
static int hf_nbap_DL_TimeslotISCPInfo_PDU = -1;  /* DL_TimeslotISCPInfo */
static int hf_nbap_DL_TimeslotISCPInfoLCR_PDU = -1;  /* DL_TimeslotISCPInfoLCR */
static int hf_nbap_DL_TPC_Pattern01Count_PDU = -1;  /* DL_TPC_Pattern01Count */
static int hf_nbap_DLTransmissionBranchLoadValue_PDU = -1;  /* DLTransmissionBranchLoadValue */
static int hf_nbap_MaxHSDSCH_HSSCCH_Power_per_CELLPORTION_PDU = -1;  /* MaxHSDSCH_HSSCCH_Power_per_CELLPORTION */
static int hf_nbap_DPC_Mode_PDU = -1;             /* DPC_Mode */
static int hf_nbap_DPCH_ID768_PDU = -1;           /* DPCH_ID768 */
static int hf_nbap_DSCH_InformationResponse_PDU = -1;  /* DSCH_InformationResponse */
static int hf_nbap_DSCH_TDD_Information_PDU = -1;  /* DSCH_TDD_Information */
static int hf_nbap_Dual_Band_Capability_Info_PDU = -1;  /* Dual_Band_Capability_Info */
static int hf_nbap_DwPCH_Power_PDU = -1;          /* DwPCH_Power */
static int hf_nbap_E_AGCH_Table_Choice_PDU = -1;  /* E_AGCH_Table_Choice */
static int hf_nbap_E_AGCH_FDD_Code_Information_PDU = -1;  /* E_AGCH_FDD_Code_Information */
static int hf_nbap_E_AI_Capability_PDU = -1;      /* E_AI_Capability */
static int hf_nbap_E_DCH_Capability_PDU = -1;     /* E_DCH_Capability */
static int hf_nbap_E_DCHCapacityConsumptionLaw_PDU = -1;  /* E_DCHCapacityConsumptionLaw */
static int hf_nbap_E_DCH_TDD_CapacityConsumptionLaw_PDU = -1;  /* E_DCH_TDD_CapacityConsumptionLaw */
static int hf_nbap_E_DCH_TTI2ms_Capability_PDU = -1;  /* E_DCH_TTI2ms_Capability */
static int hf_nbap_E_DCH_SF_Capability_PDU = -1;  /* E_DCH_SF_Capability */
static int hf_nbap_E_DCH_HARQ_Combining_Capability_PDU = -1;  /* E_DCH_HARQ_Combining_Capability */
static int hf_nbap_E_DCH_FDD_DL_Control_Channel_Information_PDU = -1;  /* E_DCH_FDD_DL_Control_Channel_Information */
static int hf_nbap_E_DCH_FDD_Information_PDU = -1;  /* E_DCH_FDD_Information */
static int hf_nbap_E_DCH_FDD_Information_Response_PDU = -1;  /* E_DCH_FDD_Information_Response */
static int hf_nbap_E_DCH_FDD_Information_to_Modify_PDU = -1;  /* E_DCH_FDD_Information_to_Modify */
static int hf_nbap_E_DCH_FDD_Update_Information_PDU = -1;  /* E_DCH_FDD_Update_Information */
static int hf_nbap_E_DCH_DL_Control_Channel_Change_Information_PDU = -1;  /* E_DCH_DL_Control_Channel_Change_Information */
static int hf_nbap_E_DCH_DL_Control_Channel_Grant_Information_PDU = -1;  /* E_DCH_DL_Control_Channel_Grant_Information */
static int hf_nbap_E_DCH_PowerOffset_for_SchedulingInfo_PDU = -1;  /* E_DCH_PowerOffset_for_SchedulingInfo */
static int hf_nbap_E_DCH_MACdPDU_SizeCapability_PDU = -1;  /* E_DCH_MACdPDU_SizeCapability */
static int hf_nbap_E_DCH_MACdPDUSizeFormat_PDU = -1;  /* E_DCH_MACdPDUSizeFormat */
static int hf_nbap_E_DCH_MACdFlows_Information_PDU = -1;  /* E_DCH_MACdFlows_Information */
static int hf_nbap_E_DCH_MACdFlows_to_Delete_PDU = -1;  /* E_DCH_MACdFlows_to_Delete */
static int hf_nbap_E_DCH_Non_serving_Relative_Grant_Down_Commands_PDU = -1;  /* E_DCH_Non_serving_Relative_Grant_Down_Commands */
static int hf_nbap_Maximum_Target_ReceivedTotalWideBandPower_PDU = -1;  /* Maximum_Target_ReceivedTotalWideBandPower */
static int hf_nbap_Target_NonServing_EDCH_To_Total_EDCH_Power_Ratio_PDU = -1;  /* Target_NonServing_EDCH_To_Total_EDCH_Power_Ratio */
static int hf_nbap_E_DCH_RL_Indication_PDU = -1;  /* E_DCH_RL_Indication */
static int hf_nbap_E_DCH_Serving_Cell_Change_Info_Response_PDU = -1;  /* E_DCH_Serving_Cell_Change_Info_Response */
static int hf_nbap_EDCH_RACH_Report_Value_PDU = -1;  /* EDCH_RACH_Report_Value */
static int hf_nbap_E_DPDCH_PowerInterpolation_PDU = -1;  /* E_DPDCH_PowerInterpolation */
static int hf_nbap_E_DCH_MACdFlows_to_DeleteLCR_PDU = -1;  /* E_DCH_MACdFlows_to_DeleteLCR */
static int hf_nbap_Enhanced_UE_DRX_InformationLCR_PDU = -1;  /* Enhanced_UE_DRX_InformationLCR */
static int hf_nbap_End_Of_Audit_Sequence_Indicator_PDU = -1;  /* End_Of_Audit_Sequence_Indicator */
static int hf_nbap_E_RGCH_E_HICH_FDD_Code_Information_PDU = -1;  /* E_RGCH_E_HICH_FDD_Code_Information */
static int hf_nbap_E_RNTI_PDU = -1;               /* E_RNTI */
static int hf_nbap_E_TFCI_Boost_Information_PDU = -1;  /* E_TFCI_Boost_Information */
static int hf_nbap_E_DCHProvidedBitRate_PDU = -1;  /* E_DCHProvidedBitRate */
static int hf_nbap_E_DCHProvidedBitRateValueInformation_For_CellPortion_PDU = -1;  /* E_DCHProvidedBitRateValueInformation_For_CellPortion */
static int hf_nbap_E_HICH_TimeOffset_PDU = -1;    /* E_HICH_TimeOffset */
static int hf_nbap_E_HICH_TimeOffsetLCR_PDU = -1;  /* E_HICH_TimeOffsetLCR */
static int hf_nbap_E_DCH_Information_PDU = -1;    /* E_DCH_Information */
static int hf_nbap_E_DCH_MACdFlow_Retransmission_Timer_PDU = -1;  /* E_DCH_MACdFlow_Retransmission_Timer */
static int hf_nbap_E_DCH_Information_Response_PDU = -1;  /* E_DCH_Information_Response */
static int hf_nbap_E_DCH_Information_Reconfig_PDU = -1;  /* E_DCH_Information_Reconfig */
static int hf_nbap_Maximum_Generated_ReceivedTotalWideBandPowerInOtherCells_PDU = -1;  /* Maximum_Generated_ReceivedTotalWideBandPowerInOtherCells */
static int hf_nbap_E_DCH_768_Information_PDU = -1;  /* E_DCH_768_Information */
static int hf_nbap_E_DCH_768_Information_Reconfig_PDU = -1;  /* E_DCH_768_Information_Reconfig */
static int hf_nbap_E_DCH_LCR_Information_PDU = -1;  /* E_DCH_LCR_Information */
static int hf_nbap_E_DCH_LCR_Information_Reconfig_PDU = -1;  /* E_DCH_LCR_Information_Reconfig */
static int hf_nbap_DormantModeIndicator_PDU = -1;  /* DormantModeIndicator */
static int hf_nbap_Enhanced_FACH_Capability_PDU = -1;  /* Enhanced_FACH_Capability */
static int hf_nbap_EnhancedHSServingCC_Abort_PDU = -1;  /* EnhancedHSServingCC_Abort */
static int hf_nbap_Enhanced_PCH_Capability_PDU = -1;  /* Enhanced_PCH_Capability */
static int hf_nbap_Enhanced_UE_DRX_Capability_PDU = -1;  /* Enhanced_UE_DRX_Capability */
static int hf_nbap_Enhanced_UE_DRX_InformationFDD_PDU = -1;  /* Enhanced_UE_DRX_InformationFDD */
static int hf_nbap_Extended_E_DCH_LCRTDD_PhysicalLayerCategory_PDU = -1;  /* Extended_E_DCH_LCRTDD_PhysicalLayerCategory */
static int hf_nbap_Ext_Max_Bits_MACe_PDU_non_scheduled_PDU = -1;  /* Ext_Max_Bits_MACe_PDU_non_scheduled */
static int hf_nbap_Ext_Reference_E_TFCI_PO_PDU = -1;  /* Ext_Reference_E_TFCI_PO */
static int hf_nbap_ExtendedPropagationDelay_PDU = -1;  /* ExtendedPropagationDelay */
static int hf_nbap_Extended_RNC_ID_PDU = -1;      /* Extended_RNC_ID */
static int hf_nbap_Extended_Round_Trip_Time_Value_PDU = -1;  /* Extended_Round_Trip_Time_Value */
static int hf_nbap_Extended_HS_SCCH_ID_PDU = -1;  /* Extended_HS_SCCH_ID */
static int hf_nbap_Extended_HS_SICH_ID_PDU = -1;  /* Extended_HS_SICH_ID */
static int hf_nbap_Extended_E_HICH_ID_TDD_PDU = -1;  /* Extended_E_HICH_ID_TDD */
static int hf_nbap_E_DCH_Semi_PersistentScheduling_Information_LCR_PDU = -1;  /* E_DCH_Semi_PersistentScheduling_Information_LCR */
static int hf_nbap_E_DCH_Semi_PersistentScheduling_Information_ResponseLCR_PDU = -1;  /* E_DCH_Semi_PersistentScheduling_Information_ResponseLCR */
static int hf_nbap_Fast_Reconfiguration_Mode_PDU = -1;  /* Fast_Reconfiguration_Mode */
static int hf_nbap_Fast_Reconfiguration_Permission_PDU = -1;  /* Fast_Reconfiguration_Permission */
static int hf_nbap_FDD_S_CCPCH_FrameOffset_PDU = -1;  /* FDD_S_CCPCH_FrameOffset */
static int hf_nbap_F_DPCH_Capability_PDU = -1;    /* F_DPCH_Capability */
static int hf_nbap_F_DPCH_SlotFormat_PDU = -1;    /* F_DPCH_SlotFormat */
static int hf_nbap_F_DPCH_SlotFormatCapability_PDU = -1;  /* F_DPCH_SlotFormatCapability */
static int hf_nbap_FNReportingIndicator_PDU = -1;  /* FNReportingIndicator */
static int hf_nbap_GANSS_AddIonoModelReq_PDU = -1;  /* GANSS_AddIonoModelReq */
static int hf_nbap_GANSS_AddNavigationModelsReq_PDU = -1;  /* GANSS_AddNavigationModelsReq */
static int hf_nbap_GANSS_AddUTCModelsReq_PDU = -1;  /* GANSS_AddUTCModelsReq */
static int hf_nbap_GANSS_Additional_Ionospheric_Model_PDU = -1;  /* GANSS_Additional_Ionospheric_Model */
static int hf_nbap_GANSS_Additional_Navigation_Models_PDU = -1;  /* GANSS_Additional_Navigation_Models */
static int hf_nbap_GANSS_Additional_Time_Models_PDU = -1;  /* GANSS_Additional_Time_Models */
static int hf_nbap_GANSS_Additional_UTC_Models_PDU = -1;  /* GANSS_Additional_UTC_Models */
static int hf_nbap_GANSS_ALM_ECEFsbasAlmanacSet_PDU = -1;  /* GANSS_ALM_ECEFsbasAlmanacSet */
static int hf_nbap_GANSS_ALM_GlonassAlmanacSet_PDU = -1;  /* GANSS_ALM_GlonassAlmanacSet */
static int hf_nbap_GANSS_ALM_MidiAlmanacSet_PDU = -1;  /* GANSS_ALM_MidiAlmanacSet */
static int hf_nbap_GANSS_ALM_NAVKeplerianSet_PDU = -1;  /* GANSS_ALM_NAVKeplerianSet */
static int hf_nbap_GANSS_ALM_ReducedKeplerianSet_PDU = -1;  /* GANSS_ALM_ReducedKeplerianSet */
static int hf_nbap_GANSS_Auxiliary_Information_PDU = -1;  /* GANSS_Auxiliary_Information */
static int hf_nbap_GANSS_AuxInfoReq_PDU = -1;     /* GANSS_AuxInfoReq */
static int hf_nbap_GANSS_Common_Data_PDU = -1;    /* GANSS_Common_Data */
static int hf_nbap_GANSS_Earth_Orientation_Parameters_PDU = -1;  /* GANSS_Earth_Orientation_Parameters */
static int hf_nbap_GANSS_EarthOrientParaReq_PDU = -1;  /* GANSS_EarthOrientParaReq */
static int hf_nbap_GANSS_Generic_Data_PDU = -1;   /* GANSS_Generic_Data */
static int hf_nbap_GANSS_ID_PDU = -1;             /* GANSS_ID */
static int hf_nbap_GANSS_Information_PDU = -1;    /* GANSS_Information */
static int hf_nbap_GANSS_SBAS_ID_PDU = -1;        /* GANSS_SBAS_ID */
static int hf_nbap_GANSS_Time_ID_PDU = -1;        /* GANSS_Time_ID */
static int hf_nbap_HARQ_MemoryPartitioningInfoExtForMIMO_PDU = -1;  /* HARQ_MemoryPartitioningInfoExtForMIMO */
static int hf_nbap_HARQ_Preamble_Mode_PDU = -1;   /* HARQ_Preamble_Mode */
static int hf_nbap_HARQ_Preamble_Mode_Activation_Indicator_PDU = -1;  /* HARQ_Preamble_Mode_Activation_Indicator */
static int hf_nbap_HSDPA_Capability_PDU = -1;     /* HSDPA_Capability */
static int hf_nbap_HS_DSCHProvidedBitRate_PDU = -1;  /* HS_DSCHProvidedBitRate */
static int hf_nbap_HS_DSCHProvidedBitRateValueInformation_For_CellPortion_PDU = -1;  /* HS_DSCHProvidedBitRateValueInformation_For_CellPortion */
static int hf_nbap_HS_DSCHProvidedBitRateValueInformation_For_CellPortionLCR_PDU = -1;  /* HS_DSCHProvidedBitRateValueInformation_For_CellPortionLCR */
static int hf_nbap_HS_DSCHRequiredPower_PDU = -1;  /* HS_DSCHRequiredPower */
static int hf_nbap_HS_DSCHRequiredPowerValue_PDU = -1;  /* HS_DSCHRequiredPowerValue */
static int hf_nbap_HS_DSCHRequiredPowerValueInformation_For_CellPortion_PDU = -1;  /* HS_DSCHRequiredPowerValueInformation_For_CellPortion */
static int hf_nbap_HS_DSCHRequiredPowerValueInformation_For_CellPortionLCR_PDU = -1;  /* HS_DSCHRequiredPowerValueInformation_For_CellPortionLCR */
static int hf_nbap_HSDSCH_Common_System_InformationFDD_PDU = -1;  /* HSDSCH_Common_System_InformationFDD */
static int hf_nbap_HSDSCH_Common_System_Information_ResponseFDD_PDU = -1;  /* HSDSCH_Common_System_Information_ResponseFDD */
static int hf_nbap_HSDSCH_FDD_Information_PDU = -1;  /* HSDSCH_FDD_Information */
static int hf_nbap_HSDSCH_TDD_Information_PDU = -1;  /* HSDSCH_TDD_Information */
static int hf_nbap_HSDSCH_Information_to_Modify_PDU = -1;  /* HSDSCH_Information_to_Modify */
static int hf_nbap_HSDSCH_MACdPDUSizeFormat_PDU = -1;  /* HSDSCH_MACdPDUSizeFormat */
static int hf_nbap_HSDSCH_MACdPDU_SizeCapability_PDU = -1;  /* HSDSCH_MACdPDU_SizeCapability */
static int hf_nbap_HSDSCH_Information_to_Modify_Unsynchronised_PDU = -1;  /* HSDSCH_Information_to_Modify_Unsynchronised */
static int hf_nbap_HSDSCH_FDD_Information_Response_PDU = -1;  /* HSDSCH_FDD_Information_Response */
static int hf_nbap_HSDSCH_Paging_System_InformationFDD_PDU = -1;  /* HSDSCH_Paging_System_InformationFDD */
static int hf_nbap_HSDSCH_Paging_System_Information_ResponseFDD_PDU = -1;  /* HSDSCH_Paging_System_Information_ResponseFDD */
static int hf_nbap_HSDSCH_TDD_Information_Response_PDU = -1;  /* HSDSCH_TDD_Information_Response */
static int hf_nbap_HSDSCH_MACdFlows_Information_PDU = -1;  /* HSDSCH_MACdFlows_Information */
static int hf_nbap_HSDSCH_MACdFlows_to_Delete_PDU = -1;  /* HSDSCH_MACdFlows_to_Delete */
static int hf_nbap_HSDSCH_TBSizeTableIndicator_PDU = -1;  /* HSDSCH_TBSizeTableIndicator */
static int hf_nbap_HSDSCH_PreconfigurationInfo_PDU = -1;  /* HSDSCH_PreconfigurationInfo */
static int hf_nbap_Additional_EDCH_Preconfiguration_Information_PDU = -1;  /* Additional_EDCH_Preconfiguration_Information */
static int hf_nbap_HSDSCH_PreconfigurationSetup_PDU = -1;  /* HSDSCH_PreconfigurationSetup */
static int hf_nbap_HSSCCH_Specific_InformationRespListTDD768_PDU = -1;  /* HSSCCH_Specific_InformationRespListTDD768 */
static int hf_nbap_HS_SICH_Reception_Quality_Value_PDU = -1;  /* HS_SICH_Reception_Quality_Value */
static int hf_nbap_HS_SICH_failed_PDU = -1;       /* HS_SICH_failed */
static int hf_nbap_HS_SICH_missed_PDU = -1;       /* HS_SICH_missed */
static int hf_nbap_HS_SICH_total_PDU = -1;        /* HS_SICH_total */
static int hf_nbap_HS_SICH_Reception_Quality_Measurement_Value_PDU = -1;  /* HS_SICH_Reception_Quality_Measurement_Value */
static int hf_nbap_HSDSCH_RNTI_PDU = -1;          /* HSDSCH_RNTI */
static int hf_nbap_HS_PDSCH_FDD_Code_Information_PDU = -1;  /* HS_PDSCH_FDD_Code_Information */
static int hf_nbap_HS_SICH_ID_PDU = -1;           /* HS_SICH_ID */
static int hf_nbap_HS_SCCH_FDD_Code_Information_PDU = -1;  /* HS_SCCH_FDD_Code_Information */
static int hf_nbap_HS_PDSCH_Code_Change_Indicator_PDU = -1;  /* HS_PDSCH_Code_Change_Indicator */
static int hf_nbap_HS_PDSCH_Code_Change_Grant_PDU = -1;  /* HS_PDSCH_Code_Change_Grant */
static int hf_nbap_HSDSCH_Configured_Indicator_PDU = -1;  /* HSDSCH_Configured_Indicator */
static int hf_nbap_HS_DSCH_Serving_Cell_Change_Info_PDU = -1;  /* HS_DSCH_Serving_Cell_Change_Info */
static int hf_nbap_HS_DSCH_Serving_Cell_Change_Info_Response_PDU = -1;  /* HS_DSCH_Serving_Cell_Change_Info_Response */
static int hf_nbap_HSDSCH_FDD_Update_Information_PDU = -1;  /* HSDSCH_FDD_Update_Information */
static int hf_nbap_HSDSCH_TDD_Update_Information_PDU = -1;  /* HSDSCH_TDD_Update_Information */
static int hf_nbap_HSDSCH_Common_System_InformationLCR_PDU = -1;  /* HSDSCH_Common_System_InformationLCR */
static int hf_nbap_HSDSCH_Common_System_Information_ResponseLCR_PDU = -1;  /* HSDSCH_Common_System_Information_ResponseLCR */
static int hf_nbap_HSDSCH_Paging_System_InformationLCR_PDU = -1;  /* HSDSCH_Paging_System_InformationLCR */
static int hf_nbap_HSDSCH_Paging_System_Information_ResponseLCR_PDU = -1;  /* HSDSCH_Paging_System_Information_ResponseLCR */
static int hf_nbap_HS_DSCH_Semi_PersistentScheduling_Information_LCR_PDU = -1;  /* HS_DSCH_Semi_PersistentScheduling_Information_LCR */
static int hf_nbap_RepetitionPeriodIndex_PDU = -1;  /* RepetitionPeriodIndex */
static int hf_nbap_SPS_Reservation_Indicator_PDU = -1;  /* SPS_Reservation_Indicator */
static int hf_nbap_HS_DSCH_SPS_Operation_Indicator_PDU = -1;  /* HS_DSCH_SPS_Operation_Indicator */
static int hf_nbap_HS_DSCH_Semi_PersistentScheduling_Information_ResponseLCR_PDU = -1;  /* HS_DSCH_Semi_PersistentScheduling_Information_ResponseLCR */
static int hf_nbap_Add_To_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_PDU = -1;  /* Add_To_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst */
static int hf_nbap_Non_HS_SCCH_Associated_HS_SICH_InformationList_Ext_PDU = -1;  /* Non_HS_SCCH_Associated_HS_SICH_InformationList_Ext */
static int hf_nbap_Modify_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_PDU = -1;  /* Modify_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst */
static int hf_nbap_Modify_Non_HS_SCCH_Associated_HS_SICH_InformationList_Ext_PDU = -1;  /* Modify_Non_HS_SCCH_Associated_HS_SICH_InformationList_Ext */
static int hf_nbap_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_PDU = -1;  /* Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst */
static int hf_nbap_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext_PDU = -1;  /* Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext */
static int hf_nbap_MIMO_ReferenceSignal_InformationListLCR_PDU = -1;  /* MIMO_ReferenceSignal_InformationListLCR */
static int hf_nbap_HSSICH_ReferenceSignal_InformationLCR_PDU = -1;  /* HSSICH_ReferenceSignal_InformationLCR */
static int hf_nbap_HSSICH_ReferenceSignal_InformationModifyLCR_PDU = -1;  /* HSSICH_ReferenceSignal_InformationModifyLCR */
static int hf_nbap_IMB_Parameters_PDU = -1;       /* IMB_Parameters */
static int hf_nbap_InformationReportCharacteristics_PDU = -1;  /* InformationReportCharacteristics */
static int hf_nbap_InformationExchangeID_PDU = -1;  /* InformationExchangeID */
static int hf_nbap_InformationType_PDU = -1;      /* InformationType */
static int hf_nbap_Initial_DL_DPCH_TimingAdjustment_Allowed_PDU = -1;  /* Initial_DL_DPCH_TimingAdjustment_Allowed */
static int hf_nbap_InnerLoopDLPCStatus_PDU = -1;  /* InnerLoopDLPCStatus */
static int hf_nbap_IPMulticastIndication_PDU = -1;  /* IPMulticastIndication */
static int hf_nbap_IPMulticastDataBearerIndication_PDU = -1;  /* IPMulticastDataBearerIndication */
static int hf_nbap_IdleIntervalInformation_PDU = -1;  /* IdleIntervalInformation */
static int hf_nbap_Local_Cell_ID_PDU = -1;        /* Local_Cell_ID */
static int hf_nbap_LCRTDD_Uplink_Physical_Channel_Capability_PDU = -1;  /* LCRTDD_Uplink_Physical_Channel_Capability */
static int hf_nbap_MAC_PDU_SizeExtended_PDU = -1;  /* MAC_PDU_SizeExtended */
static int hf_nbap_MACes_Maximum_Bitrate_LCR_PDU = -1;  /* MACes_Maximum_Bitrate_LCR */
static int hf_nbap_Maximum_Number_of_Retransmissions_For_E_DCH_PDU = -1;  /* Maximum_Number_of_Retransmissions_For_E_DCH */
static int hf_nbap_Maximum_Target_ReceivedTotalWideBandPower_LCR_PDU = -1;  /* Maximum_Target_ReceivedTotalWideBandPower_LCR */
static int hf_nbap_MaximumTransmissionPower_PDU = -1;  /* MaximumTransmissionPower */
static int hf_nbap_Max_UE_DTX_Cycle_PDU = -1;     /* Max_UE_DTX_Cycle */
static int hf_nbap_MBMS_Capability_PDU = -1;      /* MBMS_Capability */
static int hf_nbap_MeasurementFilterCoefficient_PDU = -1;  /* MeasurementFilterCoefficient */
static int hf_nbap_MeasurementID_PDU = -1;        /* MeasurementID */
static int hf_nbap_MeasurementRecoveryBehavior_PDU = -1;  /* MeasurementRecoveryBehavior */
static int hf_nbap_MeasurementRecoveryReportingIndicator_PDU = -1;  /* MeasurementRecoveryReportingIndicator */
static int hf_nbap_MeasurementRecoverySupportIndicator_PDU = -1;  /* MeasurementRecoverySupportIndicator */
static int hf_nbap_MessageStructure_PDU = -1;     /* MessageStructure */
static int hf_nbap_MICH_CFN_PDU = -1;             /* MICH_CFN */
static int hf_nbap_MidambleShiftLCR_PDU = -1;     /* MidambleShiftLCR */
static int hf_nbap_MIMO_ActivationIndicator_PDU = -1;  /* MIMO_ActivationIndicator */
static int hf_nbap_MIMO_Capability_PDU = -1;      /* MIMO_Capability */
static int hf_nbap_MIMO_Mode_Indicator_PDU = -1;  /* MIMO_Mode_Indicator */
static int hf_nbap_MIMO_N_M_Ratio_PDU = -1;       /* MIMO_N_M_Ratio */
static int hf_nbap_MIMO_PilotConfiguration_PDU = -1;  /* MIMO_PilotConfiguration */
static int hf_nbap_MIMO_PilotConfigurationExtension_PDU = -1;  /* MIMO_PilotConfigurationExtension */
static int hf_nbap_MIMO_PowerOffsetForS_CPICHCapability_PDU = -1;  /* MIMO_PowerOffsetForS_CPICHCapability */
static int hf_nbap_MinimumReducedE_DPDCH_GainFactor_PDU = -1;  /* MinimumReducedE_DPDCH_GainFactor */
static int hf_nbap_Modification_Period_PDU = -1;  /* Modification_Period */
static int hf_nbap_MAChs_ResetIndicator_PDU = -1;  /* MAChs_ResetIndicator */
static int hf_nbap_ModulationMBSFN_PDU = -1;      /* ModulationMBSFN */
static int hf_nbap_ModulationPO_MBSFN_PDU = -1;   /* ModulationPO_MBSFN */
static int hf_nbap_MBSFN_Only_Mode_Indicator_PDU = -1;  /* MBSFN_Only_Mode_Indicator */
static int hf_nbap_MBSFN_Only_Mode_Capability_PDU = -1;  /* MBSFN_Only_Mode_Capability */
static int hf_nbap_Multicarrier_Number_PDU = -1;  /* Multicarrier_Number */
static int hf_nbap_MultipleFreq_HARQ_MemoryPartitioning_InformationList_PDU = -1;  /* MultipleFreq_HARQ_MemoryPartitioning_InformationList */
static int hf_nbap_MultipleFreq_HSPDSCH_InformationList_ResponseTDDLCR_PDU = -1;  /* MultipleFreq_HSPDSCH_InformationList_ResponseTDDLCR */
static int hf_nbap_Multi_Cell_Capability_Info_PDU = -1;  /* Multi_Cell_Capability_Info */
static int hf_nbap_Multicell_EDCH_InformationItemIEs_PDU = -1;  /* Multicell_EDCH_InformationItemIEs */
static int hf_nbap_Multicell_EDCH_RL_Specific_InformationItemIEs_PDU = -1;  /* Multicell_EDCH_RL_Specific_InformationItemIEs */
static int hf_nbap_MIMO_SFMode_For_HSPDSCHDualStream_PDU = -1;  /* MIMO_SFMode_For_HSPDSCHDualStream */
static int hf_nbap_NCyclesPerSFNperiod_PDU = -1;  /* NCyclesPerSFNperiod */
static int hf_nbap_NRepetitionsPerCyclePeriod_PDU = -1;  /* NRepetitionsPerCyclePeriod */
static int hf_nbap_NeighbouringCellMeasurementInformation_PDU = -1;  /* NeighbouringCellMeasurementInformation */
static int hf_nbap_NeighbouringTDDCellMeasurementInformationLCR_PDU = -1;  /* NeighbouringTDDCellMeasurementInformationLCR */
static int hf_nbap_NeighbouringTDDCellMeasurementInformation768_PDU = -1;  /* NeighbouringTDDCellMeasurementInformation768 */
static int hf_nbap_NonCellSpecificTxDiversity_PDU = -1;  /* NonCellSpecificTxDiversity */
static int hf_nbap_NI_Information_PDU = -1;       /* NI_Information */
static int hf_nbap_NodeB_CommunicationContextID_PDU = -1;  /* NodeB_CommunicationContextID */
static int hf_nbap_NumberOfReportedCellPortions_PDU = -1;  /* NumberOfReportedCellPortions */
static int hf_nbap_NumberOfReportedCellPortionsLCR_PDU = -1;  /* NumberOfReportedCellPortionsLCR */
static int hf_nbap_NSubCyclesPerCyclePeriod_PDU = -1;  /* NSubCyclesPerCyclePeriod */
static int hf_nbap_Number_Of_Supported_Carriers_PDU = -1;  /* Number_Of_Supported_Carriers */
static int hf_nbap_NoOfTargetCellHS_SCCH_Order_PDU = -1;  /* NoOfTargetCellHS_SCCH_Order */
static int hf_nbap_Out_of_Sychronization_Window_PDU = -1;  /* Out_of_Sychronization_Window */
static int hf_nbap_Paging_MACFlows_to_DeleteFDD_PDU = -1;  /* Paging_MACFlows_to_DeleteFDD */
static int hf_nbap_PhysicalChannelID_for_CommonERNTI_RequestedIndicator_PDU = -1;  /* PhysicalChannelID_for_CommonERNTI_RequestedIndicator */
static int hf_nbap_PLCCHinformation_PDU = -1;     /* PLCCHinformation */
static int hf_nbap_PowerAdjustmentType_PDU = -1;  /* PowerAdjustmentType */
static int hf_nbap_PrecodingWeightSetRestriction_PDU = -1;  /* PrecodingWeightSetRestriction */
static int hf_nbap_Primary_CPICH_Usage_for_Channel_Estimation_PDU = -1;  /* Primary_CPICH_Usage_for_Channel_Estimation */
static int hf_nbap_PrimaryScramblingCode_PDU = -1;  /* PrimaryScramblingCode */
static int hf_nbap_PrimaryCCPCH_RSCP_PDU = -1;    /* PrimaryCCPCH_RSCP */
static int hf_nbap_PrimaryCCPCH_RSCP_Delta_PDU = -1;  /* PrimaryCCPCH_RSCP_Delta */
static int hf_nbap_UE_Selected_MBMS_Service_Information_PDU = -1;  /* UE_Selected_MBMS_Service_Information */
static int hf_nbap_Paging_MACFlows_to_DeleteLCR_PDU = -1;  /* Paging_MACFlows_to_DeleteLCR */
static int hf_nbap_RL_Specific_DCH_Info_PDU = -1;  /* RL_Specific_DCH_Info */
static int hf_nbap_RL_Specific_E_DCH_Info_PDU = -1;  /* RL_Specific_E_DCH_Info */
static int hf_nbap_Reference_ReceivedTotalWideBandPower_PDU = -1;  /* Reference_ReceivedTotalWideBandPower */
static int hf_nbap_Reference_ReceivedTotalWideBandPowerReporting_PDU = -1;  /* Reference_ReceivedTotalWideBandPowerReporting */
static int hf_nbap_Reference_ReceivedTotalWideBandPowerSupportIndicator_PDU = -1;  /* Reference_ReceivedTotalWideBandPowerSupportIndicator */
static int hf_nbap_ReferenceClockAvailability_PDU = -1;  /* ReferenceClockAvailability */
static int hf_nbap_ReferenceSFNoffset_PDU = -1;   /* ReferenceSFNoffset */
static int hf_nbap_ReportCharacteristics_PDU = -1;  /* ReportCharacteristics */
static int hf_nbap_ReportCharacteristicsType_OnModification_PDU = -1;  /* ReportCharacteristicsType_OnModification */
static int hf_nbap_EDCH_RACH_Report_IncrDecrThres_PDU = -1;  /* EDCH_RACH_Report_IncrDecrThres */
static int hf_nbap_EDCH_RACH_Report_ThresholdInformation_PDU = -1;  /* EDCH_RACH_Report_ThresholdInformation */
static int hf_nbap_RL_ID_PDU = -1;                /* RL_ID */
static int hf_nbap_RL_Set_ID_PDU = -1;            /* RL_Set_ID */
static int hf_nbap_DL_RLC_PDU_Size_Format_PDU = -1;  /* DL_RLC_PDU_Size_Format */
static int hf_nbap_Received_total_wide_band_power_For_CellPortion_Value_PDU = -1;  /* Received_total_wide_band_power_For_CellPortion_Value */
static int hf_nbap_Received_total_wide_band_power_For_CellPortion_ValueLCR_PDU = -1;  /* Received_total_wide_band_power_For_CellPortion_ValueLCR */
static int hf_nbap_Received_total_wide_band_power_Value_IncrDecrThres_PDU = -1;  /* Received_total_wide_band_power_Value_IncrDecrThres */
static int hf_nbap_Received_Scheduled_EDCH_Power_Share_For_CellPortion_Value_PDU = -1;  /* Received_Scheduled_EDCH_Power_Share_For_CellPortion_Value */
static int hf_nbap_Received_Scheduled_EDCH_Power_Share_Value_PDU = -1;  /* Received_Scheduled_EDCH_Power_Share_Value */
static int hf_nbap_RSEPS_Value_IncrDecrThres_PDU = -1;  /* RSEPS_Value_IncrDecrThres */
static int hf_nbap_Rx_Timing_Deviation_Value_LCR_PDU = -1;  /* Rx_Timing_Deviation_Value_LCR */
static int hf_nbap_Rx_Timing_Deviation_Value_768_PDU = -1;  /* Rx_Timing_Deviation_Value_768 */
static int hf_nbap_Rx_Timing_Deviation_Value_384_ext_PDU = -1;  /* Rx_Timing_Deviation_Value_384_ext */
static int hf_nbap_RTWP_ReportingIndicator_PDU = -1;  /* RTWP_ReportingIndicator */
static int hf_nbap_RTWP_CellPortion_ReportingIndicator_PDU = -1;  /* RTWP_CellPortion_ReportingIndicator */
static int hf_nbap_AdjustmentPeriod_PDU = -1;     /* AdjustmentPeriod */
static int hf_nbap_E_DPCCH_Power_Boosting_Capability_PDU = -1;  /* E_DPCCH_Power_Boosting_Capability */
static int hf_nbap_SAT_Info_Almanac_ExtList_PDU = -1;  /* SAT_Info_Almanac_ExtList */
static int hf_nbap_ScaledAdjustmentRatio_PDU = -1;  /* ScaledAdjustmentRatio */
static int hf_nbap_MaxAdjustmentStep_PDU = -1;    /* MaxAdjustmentStep */
static int hf_nbap_SchedulingPriorityIndicator_PDU = -1;  /* SchedulingPriorityIndicator */
static int hf_nbap_Secondary_CPICH_Information_Change_PDU = -1;  /* Secondary_CPICH_Information_Change */
static int hf_nbap_Secondary_CCPCH_SlotFormat_Extended_PDU = -1;  /* Secondary_CCPCH_SlotFormat_Extended */
static int hf_nbap_Serving_E_DCH_RL_ID_PDU = -1;  /* Serving_E_DCH_RL_ID */
static int hf_nbap_SFN_PDU = -1;                  /* SFN */
static int hf_nbap_SFNSFNMeasurementThresholdInformation_PDU = -1;  /* SFNSFNMeasurementThresholdInformation */
static int hf_nbap_SFNSFNMeasurementValueInformation_PDU = -1;  /* SFNSFNMeasurementValueInformation */
static int hf_nbap_ShutdownTimer_PDU = -1;        /* ShutdownTimer */
static int hf_nbap_Single_Stream_MIMO_ActivationIndicator_PDU = -1;  /* Single_Stream_MIMO_ActivationIndicator */
static int hf_nbap_Single_Stream_MIMO_Capability_PDU = -1;  /* Single_Stream_MIMO_Capability */
static int hf_nbap_Single_Stream_MIMO_Mode_Indicator_PDU = -1;  /* Single_Stream_MIMO_Mode_Indicator */
static int hf_nbap_SignallingBearerRequestIndicator_PDU = -1;  /* SignallingBearerRequestIndicator */
static int hf_nbap_SixtyfourQAM_UsageAllowedIndicator_PDU = -1;  /* SixtyfourQAM_UsageAllowedIndicator */
static int hf_nbap_SixtyfourQAM_DL_UsageIndicator_PDU = -1;  /* SixtyfourQAM_DL_UsageIndicator */
static int hf_nbap_SixtyfourQAM_DL_Capability_PDU = -1;  /* SixtyfourQAM_DL_Capability */
static int hf_nbap_SixtyfourQAM_DL_MIMO_Combined_Capability_PDU = -1;  /* SixtyfourQAM_DL_MIMO_Combined_Capability */
static int hf_nbap_SixteenQAM_UL_Capability_PDU = -1;  /* SixteenQAM_UL_Capability */
static int hf_nbap_SixteenQAM_UL_Operation_Indicator_PDU = -1;  /* SixteenQAM_UL_Operation_Indicator */
static int hf_nbap_Start_Of_Audit_Sequence_Indicator_PDU = -1;  /* Start_Of_Audit_Sequence_Indicator */
static int hf_nbap_SyncCase_PDU = -1;             /* SyncCase */
static int hf_nbap_SynchronisationReportCharacteristics_PDU = -1;  /* SynchronisationReportCharacteristics */
static int hf_nbap_SyncDLCodeIdThreInfoLCR_PDU = -1;  /* SyncDLCodeIdThreInfoLCR */
static int hf_nbap_SynchronisationReportType_PDU = -1;  /* SynchronisationReportType */
static int hf_nbap_Semi_PersistentScheduling_CapabilityLCR_PDU = -1;  /* Semi_PersistentScheduling_CapabilityLCR */
static int hf_nbap_T_Cell_PDU = -1;               /* T_Cell */
static int hf_nbap_TDD_DL_DPCH_TimeSlotFormat_LCR_PDU = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_nbap_TDD_TPC_DownlinkStepSize_PDU = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_nbap_TDD_TPC_UplinkStepSize_LCR_PDU = -1;  /* TDD_TPC_UplinkStepSize_LCR */
static int hf_nbap_TDD_UL_DPCH_TimeSlotFormat_LCR_PDU = -1;  /* TDD_UL_DPCH_TimeSlotFormat_LCR */
static int hf_nbap_TFCI_Presence_PDU = -1;        /* TFCI_Presence */
static int hf_nbap_TimeSlot_PDU = -1;             /* TimeSlot */
static int hf_nbap_TimeSlotLCR_PDU = -1;          /* TimeSlotLCR */
static int hf_nbap_TimeslotLCR_Extension_PDU = -1;  /* TimeslotLCR_Extension */
static int hf_nbap_TimeSlotMeasurementValueListLCR_PDU = -1;  /* TimeSlotMeasurementValueListLCR */
static int hf_nbap_TimingAdjustmentValue_PDU = -1;  /* TimingAdjustmentValue */
static int hf_nbap_TimingAdjustmentValueLCR_PDU = -1;  /* TimingAdjustmentValueLCR */
static int hf_nbap_TimingAdvanceApplied_PDU = -1;  /* TimingAdvanceApplied */
static int hf_nbap_SynchronisationIndicator_PDU = -1;  /* SynchronisationIndicator */
static int hf_nbap_TnlQos_PDU = -1;               /* TnlQos */
static int hf_nbap_Transmission_Gap_Pattern_Sequence_Information_PDU = -1;  /* Transmission_Gap_Pattern_Sequence_Information */
static int hf_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue_PDU = -1;  /* TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue */
static int hf_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortionValue_PDU = -1;  /* TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortionValue */
static int hf_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHSTransmissionValue_PDU = -1;  /* TransmittedCarrierPowerOfAllCodesNotUsedForHSTransmissionValue */
static int hf_nbap_Transmitted_Carrier_Power_For_CellPortion_Value_PDU = -1;  /* Transmitted_Carrier_Power_For_CellPortion_Value */
static int hf_nbap_Transmitted_Carrier_Power_For_CellPortion_ValueLCR_PDU = -1;  /* Transmitted_Carrier_Power_For_CellPortion_ValueLCR */
static int hf_nbap_Transmitted_Carrier_Power_Value_PDU = -1;  /* Transmitted_Carrier_Power_Value */
static int hf_nbap_TransmissionDiversityApplied_PDU = -1;  /* TransmissionDiversityApplied */
static int hf_nbap_TransmitDiversityIndicator_PDU = -1;  /* TransmitDiversityIndicator */
static int hf_nbap_TransportBearerRequestIndicator_PDU = -1;  /* TransportBearerRequestIndicator */
static int hf_nbap_TransportBearerNotRequestedIndicator_PDU = -1;  /* TransportBearerNotRequestedIndicator */
static int hf_nbap_TransportBearerNotSetupIndicator_PDU = -1;  /* TransportBearerNotSetupIndicator */
static int hf_nbap_TransportLayerAddress_PDU = -1;  /* TransportLayerAddress */
static int hf_nbap_TS0_CapabilityLCR_PDU = -1;    /* TS0_CapabilityLCR */
static int hf_nbap_TSTD_Indicator_PDU = -1;       /* TSTD_Indicator */
static int hf_nbap_TSN_Length_PDU = -1;           /* TSN_Length */
static int hf_nbap_TUTRANGANSSMeasurementThresholdInformation_PDU = -1;  /* TUTRANGANSSMeasurementThresholdInformation */
static int hf_nbap_TUTRANGANSSMeasurementValueInformation_PDU = -1;  /* TUTRANGANSSMeasurementValueInformation */
static int hf_nbap_TUTRANGPSMeasurementThresholdInformation_PDU = -1;  /* TUTRANGPSMeasurementThresholdInformation */
static int hf_nbap_TUTRANGPSMeasurementValueInformation_PDU = -1;  /* TUTRANGPSMeasurementValueInformation */
static int hf_nbap_TxDiversityOnDLControlChannelsByMIMOUECapability_PDU = -1;  /* TxDiversityOnDLControlChannelsByMIMOUECapability */
static int hf_nbap_TypeOfError_PDU = -1;          /* TypeOfError */
static int hf_nbap_UARFCN_PDU = -1;               /* UARFCN */
static int hf_nbap_UE_AggregateMaximumBitRate_PDU = -1;  /* UE_AggregateMaximumBitRate */
static int hf_nbap_UE_AggregateMaximumBitRate_Enforcement_Indicator_PDU = -1;  /* UE_AggregateMaximumBitRate_Enforcement_Indicator */
static int hf_nbap_UE_Capability_Information_PDU = -1;  /* UE_Capability_Information */
static int hf_nbap_UE_TS0_CapabilityLCR_PDU = -1;  /* UE_TS0_CapabilityLCR */
static int hf_nbap_UE_SupportIndicatorExtension_PDU = -1;  /* UE_SupportIndicatorExtension */
static int hf_nbap_LCRTDD_HSDSCH_Physical_Layer_Category_PDU = -1;  /* LCRTDD_HSDSCH_Physical_Layer_Category */
static int hf_nbap_UL_DPDCH_Indicator_For_E_DCH_Operation_PDU = -1;  /* UL_DPDCH_Indicator_For_E_DCH_Operation */
static int hf_nbap_UL_SIR_PDU = -1;               /* UL_SIR */
static int hf_nbap_UL_Synchronisation_Parameters_LCR_PDU = -1;  /* UL_Synchronisation_Parameters_LCR */
static int hf_nbap_UPPCHPositionLCR_PDU = -1;     /* UPPCHPositionLCR */
static int hf_nbap_UpPTSInterference_For_CellPortion_Value_PDU = -1;  /* UpPTSInterference_For_CellPortion_Value */
static int hf_nbap_UpPTSInterferenceValue_PDU = -1;  /* UpPTSInterferenceValue */
static int hf_nbap_Unidirectional_DCH_Indicator_PDU = -1;  /* Unidirectional_DCH_Indicator */
static int hf_nbap_USCH_Information_PDU = -1;     /* USCH_Information */
static int hf_nbap_USCH_InformationResponse_PDU = -1;  /* USCH_InformationResponse */
static int hf_nbap_UL_TimeslotISCP_For_CellPortion_Value_PDU = -1;  /* UL_TimeslotISCP_For_CellPortion_Value */
static int hf_nbap_UL_TimeslotISCP_Value_IncrDecrThres_PDU = -1;  /* UL_TimeslotISCP_Value_IncrDecrThres */
static int hf_nbap_CommonTransportChannelSetupRequestFDD_PDU = -1;  /* CommonTransportChannelSetupRequestFDD */
static int hf_nbap_CommonPhysicalChannelType_CTCH_SetupRqstFDD_PDU = -1;  /* CommonPhysicalChannelType_CTCH_SetupRqstFDD */
static int hf_nbap_FACH_ParametersListIE_CTCH_SetupRqstFDD_PDU = -1;  /* FACH_ParametersListIE_CTCH_SetupRqstFDD */
static int hf_nbap_PCH_ParametersItem_CTCH_SetupRqstFDD_PDU = -1;  /* PCH_ParametersItem_CTCH_SetupRqstFDD */
static int hf_nbap_MICH_Parameters_CTCH_SetupRqstFDD_PDU = -1;  /* MICH_Parameters_CTCH_SetupRqstFDD */
static int hf_nbap_RACH_ParametersItem_CTCH_SetupRqstFDD_PDU = -1;  /* RACH_ParametersItem_CTCH_SetupRqstFDD */
static int hf_nbap_CommonTransportChannelSetupRequestTDD_PDU = -1;  /* CommonTransportChannelSetupRequestTDD */
static int hf_nbap_CommonPhysicalChannelType_CTCH_SetupRqstTDD_PDU = -1;  /* CommonPhysicalChannelType_CTCH_SetupRqstTDD */
static int hf_nbap_Secondary_CCPCH_parameterListIE_CTCH_SetupRqstTDD_PDU = -1;  /* Secondary_CCPCH_parameterListIE_CTCH_SetupRqstTDD */
static int hf_nbap_Secondary_CCPCH_LCR_parameterList_CTCH_SetupRqstTDD_PDU = -1;  /* Secondary_CCPCH_LCR_parameterList_CTCH_SetupRqstTDD */
static int hf_nbap_Secondary_CCPCH_768_parameterList_CTCH_SetupRqstTDD_PDU = -1;  /* Secondary_CCPCH_768_parameterList_CTCH_SetupRqstTDD */
static int hf_nbap_FACH_ParametersListIE_CTCH_SetupRqstTDD_PDU = -1;  /* FACH_ParametersListIE_CTCH_SetupRqstTDD */
static int hf_nbap_PCH_ParametersItem_CTCH_SetupRqstTDD_PDU = -1;  /* PCH_ParametersItem_CTCH_SetupRqstTDD */
static int hf_nbap_PICH_ParametersItem_CTCH_SetupRqstTDD_PDU = -1;  /* PICH_ParametersItem_CTCH_SetupRqstTDD */
static int hf_nbap_PICH_LCR_Parameters_CTCH_SetupRqstTDD_PDU = -1;  /* PICH_LCR_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_PICH_768_ParametersItem_CTCH_SetupRqstTDD_PDU = -1;  /* PICH_768_ParametersItem_CTCH_SetupRqstTDD */
static int hf_nbap_MICH_Parameters_CTCH_SetupRqstTDD_PDU = -1;  /* MICH_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_TimeSlotConfigurationList_LCR_CTCH_SetupRqstTDD_PDU = -1;  /* TimeSlotConfigurationList_LCR_CTCH_SetupRqstTDD */
static int hf_nbap_Secondary_CCPCH_parameterExtendedList_CTCH_SetupRqstTDD_PDU = -1;  /* Secondary_CCPCH_parameterExtendedList_CTCH_SetupRqstTDD */
static int hf_nbap_Secondary_CCPCH_LCR_parameterExtendedList_CTCH_SetupRqstTDD_PDU = -1;  /* Secondary_CCPCH_LCR_parameterExtendedList_CTCH_SetupRqstTDD */
static int hf_nbap_PRACH_ParametersItem_CTCH_SetupRqstTDD_PDU = -1;  /* PRACH_ParametersItem_CTCH_SetupRqstTDD */
static int hf_nbap_RACH_ParameterItem_CTCH_SetupRqstTDD_PDU = -1;  /* RACH_ParameterItem_CTCH_SetupRqstTDD */
static int hf_nbap_PRACH_LCR_ParametersList_CTCH_SetupRqstTDD_PDU = -1;  /* PRACH_LCR_ParametersList_CTCH_SetupRqstTDD */
static int hf_nbap_PRACH_768_ParametersItem_CTCH_SetupRqstTDD_PDU = -1;  /* PRACH_768_ParametersItem_CTCH_SetupRqstTDD */
static int hf_nbap_FPACH_LCR_Parameters_CTCH_SetupRqstTDD_PDU = -1;  /* FPACH_LCR_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_PLCCH_parameters_PDU = -1;     /* PLCCH_parameters */
static int hf_nbap_E_RUCCH_parameters_PDU = -1;   /* E_RUCCH_parameters */
static int hf_nbap_E_RUCCH_768_parameters_PDU = -1;  /* E_RUCCH_768_parameters */
static int hf_nbap_CommonTransportChannelSetupResponse_PDU = -1;  /* CommonTransportChannelSetupResponse */
static int hf_nbap_FACH_CommonTransportChannel_InformationResponse_PDU = -1;  /* FACH_CommonTransportChannel_InformationResponse */
static int hf_nbap_CommonTransportChannelSetupFailure_PDU = -1;  /* CommonTransportChannelSetupFailure */
static int hf_nbap_CommonTransportChannelReconfigurationRequestFDD_PDU = -1;  /* CommonTransportChannelReconfigurationRequestFDD */
static int hf_nbap_CommonPhysicalChannelType_CTCH_ReconfRqstFDD_PDU = -1;  /* CommonPhysicalChannelType_CTCH_ReconfRqstFDD */
static int hf_nbap_FACH_ParametersListIE_CTCH_ReconfRqstFDD_PDU = -1;  /* FACH_ParametersListIE_CTCH_ReconfRqstFDD */
static int hf_nbap_PCH_ParametersItem_CTCH_ReconfRqstFDD_PDU = -1;  /* PCH_ParametersItem_CTCH_ReconfRqstFDD */
static int hf_nbap_PICH_ParametersItem_CTCH_ReconfRqstFDD_PDU = -1;  /* PICH_ParametersItem_CTCH_ReconfRqstFDD */
static int hf_nbap_MICH_Parameters_CTCH_ReconfRqstFDD_PDU = -1;  /* MICH_Parameters_CTCH_ReconfRqstFDD */
static int hf_nbap_PRACH_ParametersListIE_CTCH_ReconfRqstFDD_PDU = -1;  /* PRACH_ParametersListIE_CTCH_ReconfRqstFDD */
static int hf_nbap_AICH_ParametersListIE_CTCH_ReconfRqstFDD_PDU = -1;  /* AICH_ParametersListIE_CTCH_ReconfRqstFDD */
static int hf_nbap_CommonTransportChannelReconfigurationRequestTDD_PDU = -1;  /* CommonTransportChannelReconfigurationRequestTDD */
static int hf_nbap_Secondary_CCPCH_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* Secondary_CCPCH_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_Secondary_CCPCHListIE_CTCH_ReconfRqstTDD_PDU = -1;  /* Secondary_CCPCHListIE_CTCH_ReconfRqstTDD */
static int hf_nbap_Secondary_CCPCH_parameterExtendedList_CTCH_ReconfRqstTDD_PDU = -1;  /* Secondary_CCPCH_parameterExtendedList_CTCH_ReconfRqstTDD */
static int hf_nbap_Secondary_CCPCH_LCR_parameterExtendedList_CTCH_ReconfRqstTDD_PDU = -1;  /* Secondary_CCPCH_LCR_parameterExtendedList_CTCH_ReconfRqstTDD */
static int hf_nbap_PICH_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* PICH_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_FACH_ParametersList_CTCH_ReconfRqstTDD_PDU = -1;  /* FACH_ParametersList_CTCH_ReconfRqstTDD */
static int hf_nbap_PCH_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* PCH_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_FPACH_LCR_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* FPACH_LCR_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_MICH_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* MICH_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_PLCCH_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* PLCCH_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_Secondary_CCPCH_768_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* Secondary_CCPCH_768_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_PICH_768_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* PICH_768_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_MICH_768_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* MICH_768_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_UPPCH_LCR_Parameters_CTCH_ReconfRqstTDD_PDU = -1;  /* UPPCH_LCR_Parameters_CTCH_ReconfRqstTDD */
static int hf_nbap_CommonTransportChannelReconfigurationResponse_PDU = -1;  /* CommonTransportChannelReconfigurationResponse */
static int hf_nbap_CommonTransportChannelReconfigurationFailure_PDU = -1;  /* CommonTransportChannelReconfigurationFailure */
static int hf_nbap_CommonTransportChannelDeletionRequest_PDU = -1;  /* CommonTransportChannelDeletionRequest */
static int hf_nbap_CommonTransportChannelDeletionResponse_PDU = -1;  /* CommonTransportChannelDeletionResponse */
static int hf_nbap_BlockResourceRequest_PDU = -1;  /* BlockResourceRequest */
static int hf_nbap_BlockResourceResponse_PDU = -1;  /* BlockResourceResponse */
static int hf_nbap_BlockResourceFailure_PDU = -1;  /* BlockResourceFailure */
static int hf_nbap_UnblockResourceIndication_PDU = -1;  /* UnblockResourceIndication */
static int hf_nbap_AuditRequiredIndication_PDU = -1;  /* AuditRequiredIndication */
static int hf_nbap_AuditRequest_PDU = -1;         /* AuditRequest */
static int hf_nbap_AuditResponse_PDU = -1;        /* AuditResponse */
static int hf_nbap_Cell_InformationList_AuditRsp_PDU = -1;  /* Cell_InformationList_AuditRsp */
static int hf_nbap_Cell_InformationItem_AuditRsp_PDU = -1;  /* Cell_InformationItem_AuditRsp */
static int hf_nbap_FPACH_LCR_InformationList_AuditRsp_PDU = -1;  /* FPACH_LCR_InformationList_AuditRsp */
static int hf_nbap_HS_DSCH_Resources_Information_AuditRsp_PDU = -1;  /* HS_DSCH_Resources_Information_AuditRsp */
static int hf_nbap_S_CCPCH_InformationListExt_AuditRsp_PDU = -1;  /* S_CCPCH_InformationListExt_AuditRsp */
static int hf_nbap_S_CCPCH_LCR_InformationListExt_AuditRsp_PDU = -1;  /* S_CCPCH_LCR_InformationListExt_AuditRsp */
static int hf_nbap_E_DCH_Resources_Information_AuditRsp_PDU = -1;  /* E_DCH_Resources_Information_AuditRsp */
static int hf_nbap_PLCCH_InformationList_AuditRsp_PDU = -1;  /* PLCCH_InformationList_AuditRsp */
static int hf_nbap_S_CCPCH_768_InformationList_AuditRsp_PDU = -1;  /* S_CCPCH_768_InformationList_AuditRsp */
static int hf_nbap_PRACH_768_InformationList_AuditRsp_PDU = -1;  /* PRACH_768_InformationList_AuditRsp */
static int hf_nbap_E_RUCCH_InformationList_AuditRsp_PDU = -1;  /* E_RUCCH_InformationList_AuditRsp */
static int hf_nbap_E_RUCCH_768_InformationList_AuditRsp_PDU = -1;  /* E_RUCCH_768_InformationList_AuditRsp */
static int hf_nbap_Cell_Frequency_List_Information_LCR_MulFreq_AuditRsp_PDU = -1;  /* Cell_Frequency_List_Information_LCR_MulFreq_AuditRsp */
static int hf_nbap_Cell_Frequency_List_InformationItem_LCR_MulFreq_AuditRsp_PDU = -1;  /* Cell_Frequency_List_InformationItem_LCR_MulFreq_AuditRsp */
static int hf_nbap_UPPCH_LCR_InformationList_AuditRsp_PDU = -1;  /* UPPCH_LCR_InformationList_AuditRsp */
static int hf_nbap_UPPCH_LCR_InformationItem_AuditRsp_PDU = -1;  /* UPPCH_LCR_InformationItem_AuditRsp */
static int hf_nbap_MultipleFreq_HS_DSCH_Resources_InformationList_AuditRsp_PDU = -1;  /* MultipleFreq_HS_DSCH_Resources_InformationList_AuditRsp */
static int hf_nbap_MultipleFreq_E_DCH_Resources_InformationList_AuditRsp_PDU = -1;  /* MultipleFreq_E_DCH_Resources_InformationList_AuditRsp */
static int hf_nbap_CCP_InformationList_AuditRsp_PDU = -1;  /* CCP_InformationList_AuditRsp */
static int hf_nbap_CCP_InformationItem_AuditRsp_PDU = -1;  /* CCP_InformationItem_AuditRsp */
static int hf_nbap_Local_Cell_InformationList_AuditRsp_PDU = -1;  /* Local_Cell_InformationList_AuditRsp */
static int hf_nbap_Local_Cell_InformationItem_AuditRsp_PDU = -1;  /* Local_Cell_InformationItem_AuditRsp */
static int hf_nbap_Local_Cell_Group_InformationList_AuditRsp_PDU = -1;  /* Local_Cell_Group_InformationList_AuditRsp */
static int hf_nbap_Local_Cell_Group_InformationItem_AuditRsp_PDU = -1;  /* Local_Cell_Group_InformationItem_AuditRsp */
static int hf_nbap_Power_Local_Cell_Group_InformationList_AuditRsp_PDU = -1;  /* Power_Local_Cell_Group_InformationList_AuditRsp */
static int hf_nbap_Power_Local_Cell_Group_InformationItem_AuditRsp_PDU = -1;  /* Power_Local_Cell_Group_InformationItem_AuditRsp */
static int hf_nbap_AuditFailure_PDU = -1;         /* AuditFailure */
static int hf_nbap_CommonMeasurementInitiationRequest_PDU = -1;  /* CommonMeasurementInitiationRequest */
static int hf_nbap_CommonMeasurementObjectType_CM_Rqst_PDU = -1;  /* CommonMeasurementObjectType_CM_Rqst */
static int hf_nbap_ERACH_CM_Rqst_PDU = -1;        /* ERACH_CM_Rqst */
static int hf_nbap_PowerLocalCellGroup_CM_Rqst_PDU = -1;  /* PowerLocalCellGroup_CM_Rqst */
static int hf_nbap_CommonMeasurementInitiationResponse_PDU = -1;  /* CommonMeasurementInitiationResponse */
static int hf_nbap_CommonMeasurementObjectType_CM_Rsp_PDU = -1;  /* CommonMeasurementObjectType_CM_Rsp */
static int hf_nbap_ERACH_CM_Rsp_PDU = -1;         /* ERACH_CM_Rsp */
static int hf_nbap_PowerLocalCellGroup_CM_Rsp_PDU = -1;  /* PowerLocalCellGroup_CM_Rsp */
static int hf_nbap_CommonMeasurementInitiationFailure_PDU = -1;  /* CommonMeasurementInitiationFailure */
static int hf_nbap_CommonMeasurementReport_PDU = -1;  /* CommonMeasurementReport */
static int hf_nbap_CommonMeasurementObjectType_CM_Rprt_PDU = -1;  /* CommonMeasurementObjectType_CM_Rprt */
static int hf_nbap_ERACH_CM_Rprt_PDU = -1;        /* ERACH_CM_Rprt */
static int hf_nbap_PowerLocalCellGroup_CM_Rprt_PDU = -1;  /* PowerLocalCellGroup_CM_Rprt */
static int hf_nbap_CommonMeasurementTerminationRequest_PDU = -1;  /* CommonMeasurementTerminationRequest */
static int hf_nbap_CommonMeasurementFailureIndication_PDU = -1;  /* CommonMeasurementFailureIndication */
static int hf_nbap_CellSetupRequestFDD_PDU = -1;  /* CellSetupRequestFDD */
static int hf_nbap_Synchronisation_Configuration_Cell_SetupRqst_PDU = -1;  /* Synchronisation_Configuration_Cell_SetupRqst */
static int hf_nbap_PrimarySCH_Information_Cell_SetupRqstFDD_PDU = -1;  /* PrimarySCH_Information_Cell_SetupRqstFDD */
static int hf_nbap_SecondarySCH_Information_Cell_SetupRqstFDD_PDU = -1;  /* SecondarySCH_Information_Cell_SetupRqstFDD */
static int hf_nbap_PrimaryCPICH_Information_Cell_SetupRqstFDD_PDU = -1;  /* PrimaryCPICH_Information_Cell_SetupRqstFDD */
static int hf_nbap_SecondaryCPICH_InformationList_Cell_SetupRqstFDD_PDU = -1;  /* SecondaryCPICH_InformationList_Cell_SetupRqstFDD */
static int hf_nbap_SecondaryCPICH_InformationItem_Cell_SetupRqstFDD_PDU = -1;  /* SecondaryCPICH_InformationItem_Cell_SetupRqstFDD */
static int hf_nbap_PrimaryCCPCH_Information_Cell_SetupRqstFDD_PDU = -1;  /* PrimaryCCPCH_Information_Cell_SetupRqstFDD */
static int hf_nbap_Limited_power_increase_information_Cell_SetupRqstFDD_PDU = -1;  /* Limited_power_increase_information_Cell_SetupRqstFDD */
static int hf_nbap_IPDLParameter_Information_Cell_SetupRqstFDD_PDU = -1;  /* IPDLParameter_Information_Cell_SetupRqstFDD */
static int hf_nbap_CellPortion_InformationList_Cell_SetupRqstFDD_PDU = -1;  /* CellPortion_InformationList_Cell_SetupRqstFDD */
static int hf_nbap_CellPortion_InformationItem_Cell_SetupRqstFDD_PDU = -1;  /* CellPortion_InformationItem_Cell_SetupRqstFDD */
static int hf_nbap_CellSetupRequestTDD_PDU = -1;  /* CellSetupRequestTDD */
static int hf_nbap_SCH_Information_Cell_SetupRqstTDD_PDU = -1;  /* SCH_Information_Cell_SetupRqstTDD */
static int hf_nbap_SyncCaseIndicatorItem_Cell_SetupRqstTDD_PSCH_PDU = -1;  /* SyncCaseIndicatorItem_Cell_SetupRqstTDD_PSCH */
static int hf_nbap_PCCPCH_Information_Cell_SetupRqstTDD_PDU = -1;  /* PCCPCH_Information_Cell_SetupRqstTDD */
static int hf_nbap_TimeSlotConfigurationList_Cell_SetupRqstTDD_PDU = -1;  /* TimeSlotConfigurationList_Cell_SetupRqstTDD */
static int hf_nbap_TimeSlotConfigurationList_LCR_Cell_SetupRqstTDD_PDU = -1;  /* TimeSlotConfigurationList_LCR_Cell_SetupRqstTDD */
static int hf_nbap_PCCPCH_LCR_Information_Cell_SetupRqstTDD_PDU = -1;  /* PCCPCH_LCR_Information_Cell_SetupRqstTDD */
static int hf_nbap_DwPCH_LCR_Information_Cell_SetupRqstTDD_PDU = -1;  /* DwPCH_LCR_Information_Cell_SetupRqstTDD */
static int hf_nbap_IPDLParameter_Information_Cell_SetupRqstTDD_PDU = -1;  /* IPDLParameter_Information_Cell_SetupRqstTDD */
static int hf_nbap_IPDLParameter_Information_LCR_Cell_SetupRqstTDD_PDU = -1;  /* IPDLParameter_Information_LCR_Cell_SetupRqstTDD */
static int hf_nbap_PCCPCH_768_Information_Cell_SetupRqstTDD_PDU = -1;  /* PCCPCH_768_Information_Cell_SetupRqstTDD */
static int hf_nbap_SCH_768_Information_Cell_SetupRqstTDD_PDU = -1;  /* SCH_768_Information_Cell_SetupRqstTDD */
static int hf_nbap_Cell_Frequency_List_LCR_MulFreq_Cell_SetupRqstTDD_PDU = -1;  /* Cell_Frequency_List_LCR_MulFreq_Cell_SetupRqstTDD */
static int hf_nbap_CellSetupResponse_PDU = -1;    /* CellSetupResponse */
static int hf_nbap_CellSetupFailure_PDU = -1;     /* CellSetupFailure */
static int hf_nbap_CellReconfigurationRequestFDD_PDU = -1;  /* CellReconfigurationRequestFDD */
static int hf_nbap_Synchronisation_Configuration_Cell_ReconfRqst_PDU = -1;  /* Synchronisation_Configuration_Cell_ReconfRqst */
static int hf_nbap_PrimarySCH_Information_Cell_ReconfRqstFDD_PDU = -1;  /* PrimarySCH_Information_Cell_ReconfRqstFDD */
static int hf_nbap_SecondarySCH_Information_Cell_ReconfRqstFDD_PDU = -1;  /* SecondarySCH_Information_Cell_ReconfRqstFDD */
static int hf_nbap_PrimaryCPICH_Information_Cell_ReconfRqstFDD_PDU = -1;  /* PrimaryCPICH_Information_Cell_ReconfRqstFDD */
static int hf_nbap_SecondaryCPICH_InformationList_Cell_ReconfRqstFDD_PDU = -1;  /* SecondaryCPICH_InformationList_Cell_ReconfRqstFDD */
static int hf_nbap_SecondaryCPICH_InformationItem_Cell_ReconfRqstFDD_PDU = -1;  /* SecondaryCPICH_InformationItem_Cell_ReconfRqstFDD */
static int hf_nbap_PrimaryCCPCH_Information_Cell_ReconfRqstFDD_PDU = -1;  /* PrimaryCCPCH_Information_Cell_ReconfRqstFDD */
static int hf_nbap_IPDLParameter_Information_Cell_ReconfRqstFDD_PDU = -1;  /* IPDLParameter_Information_Cell_ReconfRqstFDD */
static int hf_nbap_CellPortion_InformationList_Cell_ReconfRqstFDD_PDU = -1;  /* CellPortion_InformationList_Cell_ReconfRqstFDD */
static int hf_nbap_CellPortion_InformationItem_Cell_ReconfRqstFDD_PDU = -1;  /* CellPortion_InformationItem_Cell_ReconfRqstFDD */
static int hf_nbap_CellReconfigurationRequestTDD_PDU = -1;  /* CellReconfigurationRequestTDD */
static int hf_nbap_SCH_Information_Cell_ReconfRqstTDD_PDU = -1;  /* SCH_Information_Cell_ReconfRqstTDD */
static int hf_nbap_PCCPCH_Information_Cell_ReconfRqstTDD_PDU = -1;  /* PCCPCH_Information_Cell_ReconfRqstTDD */
static int hf_nbap_TimeSlotConfigurationList_Cell_ReconfRqstTDD_PDU = -1;  /* TimeSlotConfigurationList_Cell_ReconfRqstTDD */
static int hf_nbap_TimeSlotConfigurationList_LCR_Cell_ReconfRqstTDD_PDU = -1;  /* TimeSlotConfigurationList_LCR_Cell_ReconfRqstTDD */
static int hf_nbap_DwPCH_LCR_Information_Cell_ReconfRqstTDD_PDU = -1;  /* DwPCH_LCR_Information_Cell_ReconfRqstTDD */
static int hf_nbap_IPDLParameter_Information_Cell_ReconfRqstTDD_PDU = -1;  /* IPDLParameter_Information_Cell_ReconfRqstTDD */
static int hf_nbap_IPDLParameter_Information_LCR_Cell_ReconfRqstTDD_PDU = -1;  /* IPDLParameter_Information_LCR_Cell_ReconfRqstTDD */
static int hf_nbap_SCH_768_Information_Cell_ReconfRqstTDD_PDU = -1;  /* SCH_768_Information_Cell_ReconfRqstTDD */
static int hf_nbap_PCCPCH_768_Information_Cell_ReconfRqstTDD_PDU = -1;  /* PCCPCH_768_Information_Cell_ReconfRqstTDD */
static int hf_nbap_UARFCN_Adjustment_PDU = -1;    /* UARFCN_Adjustment */
static int hf_nbap_CellReconfigurationResponse_PDU = -1;  /* CellReconfigurationResponse */
static int hf_nbap_CellReconfigurationFailure_PDU = -1;  /* CellReconfigurationFailure */
static int hf_nbap_CellDeletionRequest_PDU = -1;  /* CellDeletionRequest */
static int hf_nbap_CellDeletionResponse_PDU = -1;  /* CellDeletionResponse */
static int hf_nbap_ResourceStatusIndication_PDU = -1;  /* ResourceStatusIndication */
static int hf_nbap_IndicationType_ResourceStatusInd_PDU = -1;  /* IndicationType_ResourceStatusInd */
static int hf_nbap_Local_Cell_InformationItem_ResourceStatusInd_PDU = -1;  /* Local_Cell_InformationItem_ResourceStatusInd */
static int hf_nbap_Local_Cell_Group_InformationItem_ResourceStatusInd_PDU = -1;  /* Local_Cell_Group_InformationItem_ResourceStatusInd */
static int hf_nbap_Power_Local_Cell_Group_InformationList_ResourceStatusInd_PDU = -1;  /* Power_Local_Cell_Group_InformationList_ResourceStatusInd */
static int hf_nbap_Power_Local_Cell_Group_InformationItem_ResourceStatusInd_PDU = -1;  /* Power_Local_Cell_Group_InformationItem_ResourceStatusInd */
static int hf_nbap_Local_Cell_InformationItem2_ResourceStatusInd_PDU = -1;  /* Local_Cell_InformationItem2_ResourceStatusInd */
static int hf_nbap_Local_Cell_Group_InformationItem2_ResourceStatusInd_PDU = -1;  /* Local_Cell_Group_InformationItem2_ResourceStatusInd */
static int hf_nbap_CCP_InformationItem_ResourceStatusInd_PDU = -1;  /* CCP_InformationItem_ResourceStatusInd */
static int hf_nbap_Cell_InformationItem_ResourceStatusInd_PDU = -1;  /* Cell_InformationItem_ResourceStatusInd */
static int hf_nbap_FPACH_LCR_InformationList_ResourceStatusInd_PDU = -1;  /* FPACH_LCR_InformationList_ResourceStatusInd */
static int hf_nbap_DwPCH_LCR_Information_ResourceStatusInd_PDU = -1;  /* DwPCH_LCR_Information_ResourceStatusInd */
static int hf_nbap_HS_DSCH_Resources_Information_ResourceStatusInd_PDU = -1;  /* HS_DSCH_Resources_Information_ResourceStatusInd */
static int hf_nbap_S_CCPCH_InformationListExt_ResourceStatusInd_PDU = -1;  /* S_CCPCH_InformationListExt_ResourceStatusInd */
static int hf_nbap_S_CCPCH_LCR_InformationListExt_ResourceStatusInd_PDU = -1;  /* S_CCPCH_LCR_InformationListExt_ResourceStatusInd */
static int hf_nbap_E_DCH_Resources_Information_ResourceStatusInd_PDU = -1;  /* E_DCH_Resources_Information_ResourceStatusInd */
static int hf_nbap_PLCCH_InformationList_ResourceStatusInd_PDU = -1;  /* PLCCH_InformationList_ResourceStatusInd */
static int hf_nbap_S_CCPCH_768_InformationList_ResourceStatusInd_PDU = -1;  /* S_CCPCH_768_InformationList_ResourceStatusInd */
static int hf_nbap_PRACH_768_InformationList_ResourceStatusInd_PDU = -1;  /* PRACH_768_InformationList_ResourceStatusInd */
static int hf_nbap_E_RUCCH_InformationList_ResourceStatusInd_PDU = -1;  /* E_RUCCH_InformationList_ResourceStatusInd */
static int hf_nbap_E_RUCCH_768_InformationList_ResourceStatusInd_PDU = -1;  /* E_RUCCH_768_InformationList_ResourceStatusInd */
static int hf_nbap_Cell_Frequency_List_Information_LCR_MulFreq_ResourceStatusInd_PDU = -1;  /* Cell_Frequency_List_Information_LCR_MulFreq_ResourceStatusInd */
static int hf_nbap_Cell_Frequency_List_InformationItem_LCR_MulFreq_ResourceStatusInd_PDU = -1;  /* Cell_Frequency_List_InformationItem_LCR_MulFreq_ResourceStatusInd */
static int hf_nbap_UPPCH_LCR_InformationList_ResourceStatusInd_PDU = -1;  /* UPPCH_LCR_InformationList_ResourceStatusInd */
static int hf_nbap_UPPCH_LCR_InformationItem_ResourceStatusInd_PDU = -1;  /* UPPCH_LCR_InformationItem_ResourceStatusInd */
static int hf_nbap_MultipleFreq_HS_DSCH_Resources_InformationList_ResourceStatusInd_PDU = -1;  /* MultipleFreq_HS_DSCH_Resources_InformationList_ResourceStatusInd */
static int hf_nbap_Power_Local_Cell_Group_InformationList2_ResourceStatusInd_PDU = -1;  /* Power_Local_Cell_Group_InformationList2_ResourceStatusInd */
static int hf_nbap_Power_Local_Cell_Group_InformationItem2_ResourceStatusInd_PDU = -1;  /* Power_Local_Cell_Group_InformationItem2_ResourceStatusInd */
static int hf_nbap_MultipleFreq_E_DCH_Resources_InformationList_ResourceStatusInd_PDU = -1;  /* MultipleFreq_E_DCH_Resources_InformationList_ResourceStatusInd */
static int hf_nbap_SystemInformationUpdateRequest_PDU = -1;  /* SystemInformationUpdateRequest */
static int hf_nbap_MIB_SB_SIB_InformationList_SystemInfoUpdateRqst_PDU = -1;  /* MIB_SB_SIB_InformationList_SystemInfoUpdateRqst */
static int hf_nbap_SegmentInformationListIE_SystemInfoUpdate_PDU = -1;  /* SegmentInformationListIE_SystemInfoUpdate */
static int hf_nbap_SystemInformationUpdateResponse_PDU = -1;  /* SystemInformationUpdateResponse */
static int hf_nbap_SystemInformationUpdateFailure_PDU = -1;  /* SystemInformationUpdateFailure */
static int hf_nbap_RadioLinkSetupRequestFDD_PDU = -1;  /* RadioLinkSetupRequestFDD */
static int hf_nbap_Additional_HS_Cell_Information_RL_Setup_List_PDU = -1;  /* Additional_HS_Cell_Information_RL_Setup_List */
static int hf_nbap_UL_DPCH_Information_RL_SetupRqstFDD_PDU = -1;  /* UL_DPCH_Information_RL_SetupRqstFDD */
static int hf_nbap_DL_DPCH_Information_RL_SetupRqstFDD_PDU = -1;  /* DL_DPCH_Information_RL_SetupRqstFDD */
static int hf_nbap_RL_InformationList_RL_SetupRqstFDD_PDU = -1;  /* RL_InformationList_RL_SetupRqstFDD */
static int hf_nbap_RL_InformationItem_RL_SetupRqstFDD_PDU = -1;  /* RL_InformationItem_RL_SetupRqstFDD */
static int hf_nbap_E_DPCH_Information_RL_SetupRqstFDD_PDU = -1;  /* E_DPCH_Information_RL_SetupRqstFDD */
static int hf_nbap_F_DPCH_Information_RL_SetupRqstFDD_PDU = -1;  /* F_DPCH_Information_RL_SetupRqstFDD */
static int hf_nbap_RadioLinkSetupRequestTDD_PDU = -1;  /* RadioLinkSetupRequestTDD */
static int hf_nbap_UL_CCTrCH_InformationList_RL_SetupRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationList_RL_SetupRqstTDD */
static int hf_nbap_UL_CCTrCH_InformationItem_RL_SetupRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationItem_RL_SetupRqstTDD */
static int hf_nbap_UL_DPCH_InformationItem_RL_SetupRqstTDD_PDU = -1;  /* UL_DPCH_InformationItem_RL_SetupRqstTDD */
static int hf_nbap_UL_DPCH_LCR_Information_RL_SetupRqstTDD_PDU = -1;  /* UL_DPCH_LCR_Information_RL_SetupRqstTDD */
static int hf_nbap_UL_DPCH_768_Information_RL_SetupRqstTDD_PDU = -1;  /* UL_DPCH_768_Information_RL_SetupRqstTDD */
static int hf_nbap_DL_CCTrCH_InformationList_RL_SetupRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationList_RL_SetupRqstTDD */
static int hf_nbap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationItem_RL_SetupRqstTDD */
static int hf_nbap_DL_DPCH_InformationItem_RL_SetupRqstTDD_PDU = -1;  /* DL_DPCH_InformationItem_RL_SetupRqstTDD */
static int hf_nbap_DL_DPCH_LCR_Information_RL_SetupRqstTDD_PDU = -1;  /* DL_DPCH_LCR_Information_RL_SetupRqstTDD */
static int hf_nbap_DL_DPCH_768_Information_RL_SetupRqstTDD_PDU = -1;  /* DL_DPCH_768_Information_RL_SetupRqstTDD */
static int hf_nbap_RL_Information_RL_SetupRqstTDD_PDU = -1;  /* RL_Information_RL_SetupRqstTDD */
static int hf_nbap_RadioLinkSetupResponseFDD_PDU = -1;  /* RadioLinkSetupResponseFDD */
static int hf_nbap_Additional_HS_Cell_Information_Response_List_PDU = -1;  /* Additional_HS_Cell_Information_Response_List */
static int hf_nbap_RL_InformationResponseList_RL_SetupRspFDD_PDU = -1;  /* RL_InformationResponseList_RL_SetupRspFDD */
static int hf_nbap_RL_InformationResponseItem_RL_SetupRspFDD_PDU = -1;  /* RL_InformationResponseItem_RL_SetupRspFDD */
static int hf_nbap_RadioLinkSetupResponseTDD_PDU = -1;  /* RadioLinkSetupResponseTDD */
static int hf_nbap_RL_InformationResponse_RL_SetupRspTDD_PDU = -1;  /* RL_InformationResponse_RL_SetupRspTDD */
static int hf_nbap_RL_InformationResponse_LCR_RL_SetupRspTDD_PDU = -1;  /* RL_InformationResponse_LCR_RL_SetupRspTDD */
static int hf_nbap_RadioLinkSetupFailureFDD_PDU = -1;  /* RadioLinkSetupFailureFDD */
static int hf_nbap_CauseLevel_RL_SetupFailureFDD_PDU = -1;  /* CauseLevel_RL_SetupFailureFDD */
static int hf_nbap_Unsuccessful_RL_InformationRespItem_RL_SetupFailureFDD_PDU = -1;  /* Unsuccessful_RL_InformationRespItem_RL_SetupFailureFDD */
static int hf_nbap_Successful_RL_InformationRespItem_RL_SetupFailureFDD_PDU = -1;  /* Successful_RL_InformationRespItem_RL_SetupFailureFDD */
static int hf_nbap_RadioLinkSetupFailureTDD_PDU = -1;  /* RadioLinkSetupFailureTDD */
static int hf_nbap_CauseLevel_RL_SetupFailureTDD_PDU = -1;  /* CauseLevel_RL_SetupFailureTDD */
static int hf_nbap_Unsuccessful_RL_InformationResp_RL_SetupFailureTDD_PDU = -1;  /* Unsuccessful_RL_InformationResp_RL_SetupFailureTDD */
static int hf_nbap_RadioLinkAdditionRequestFDD_PDU = -1;  /* RadioLinkAdditionRequestFDD */
static int hf_nbap_Additional_HS_Cell_Information_RL_Addition_List_PDU = -1;  /* Additional_HS_Cell_Information_RL_Addition_List */
static int hf_nbap_Additional_EDCH_Cell_Information_RL_Add_Req_PDU = -1;  /* Additional_EDCH_Cell_Information_RL_Add_Req */
static int hf_nbap_RL_InformationList_RL_AdditionRqstFDD_PDU = -1;  /* RL_InformationList_RL_AdditionRqstFDD */
static int hf_nbap_RL_InformationItem_RL_AdditionRqstFDD_PDU = -1;  /* RL_InformationItem_RL_AdditionRqstFDD */
static int hf_nbap_E_DPCH_Information_RL_AdditionReqFDD_PDU = -1;  /* E_DPCH_Information_RL_AdditionReqFDD */
static int hf_nbap_RadioLinkAdditionRequestTDD_PDU = -1;  /* RadioLinkAdditionRequestTDD */
static int hf_nbap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationList_RL_AdditionRqstTDD */
static int hf_nbap_UL_DPCH_InformationItem_RL_AdditionRqstTDD_PDU = -1;  /* UL_DPCH_InformationItem_RL_AdditionRqstTDD */
static int hf_nbap_UL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD_PDU = -1;  /* UL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD */
static int hf_nbap_UL_DPCH_InformationItem_768_RL_AdditionRqstTDD_PDU = -1;  /* UL_DPCH_InformationItem_768_RL_AdditionRqstTDD */
static int hf_nbap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationList_RL_AdditionRqstTDD */
static int hf_nbap_DL_DPCH_InformationItem_RL_AdditionRqstTDD_PDU = -1;  /* DL_DPCH_InformationItem_RL_AdditionRqstTDD */
static int hf_nbap_DL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD_PDU = -1;  /* DL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD */
static int hf_nbap_DL_DPCH_InformationItem_768_RL_AdditionRqstTDD_PDU = -1;  /* DL_DPCH_InformationItem_768_RL_AdditionRqstTDD */
static int hf_nbap_RL_Information_RL_AdditionRqstTDD_PDU = -1;  /* RL_Information_RL_AdditionRqstTDD */
static int hf_nbap_RadioLinkAdditionResponseFDD_PDU = -1;  /* RadioLinkAdditionResponseFDD */
static int hf_nbap_Additional_HS_Cell_Change_Information_Response_List_PDU = -1;  /* Additional_HS_Cell_Change_Information_Response_List */
static int hf_nbap_RL_InformationResponseList_RL_AdditionRspFDD_PDU = -1;  /* RL_InformationResponseList_RL_AdditionRspFDD */
static int hf_nbap_RL_InformationResponseItem_RL_AdditionRspFDD_PDU = -1;  /* RL_InformationResponseItem_RL_AdditionRspFDD */
static int hf_nbap_RadioLinkAdditionResponseTDD_PDU = -1;  /* RadioLinkAdditionResponseTDD */
static int hf_nbap_RL_InformationResponse_RL_AdditionRspTDD_PDU = -1;  /* RL_InformationResponse_RL_AdditionRspTDD */
static int hf_nbap_RL_InformationResponse_LCR_RL_AdditionRspTDD_PDU = -1;  /* RL_InformationResponse_LCR_RL_AdditionRspTDD */
static int hf_nbap_RadioLinkAdditionFailureFDD_PDU = -1;  /* RadioLinkAdditionFailureFDD */
static int hf_nbap_CauseLevel_RL_AdditionFailureFDD_PDU = -1;  /* CauseLevel_RL_AdditionFailureFDD */
static int hf_nbap_Unsuccessful_RL_InformationRespItem_RL_AdditionFailureFDD_PDU = -1;  /* Unsuccessful_RL_InformationRespItem_RL_AdditionFailureFDD */
static int hf_nbap_Successful_RL_InformationRespItem_RL_AdditionFailureFDD_PDU = -1;  /* Successful_RL_InformationRespItem_RL_AdditionFailureFDD */
static int hf_nbap_RadioLinkAdditionFailureTDD_PDU = -1;  /* RadioLinkAdditionFailureTDD */
static int hf_nbap_CauseLevel_RL_AdditionFailureTDD_PDU = -1;  /* CauseLevel_RL_AdditionFailureTDD */
static int hf_nbap_Unsuccessful_RL_InformationResp_RL_AdditionFailureTDD_PDU = -1;  /* Unsuccessful_RL_InformationResp_RL_AdditionFailureTDD */
static int hf_nbap_RadioLinkReconfigurationPrepareFDD_PDU = -1;  /* RadioLinkReconfigurationPrepareFDD */
static int hf_nbap_Additional_HS_Cell_Information_RL_Reconf_Prep_PDU = -1;  /* Additional_HS_Cell_Information_RL_Reconf_Prep */
static int hf_nbap_Additional_EDCH_Cell_Information_RL_Reconf_Prep_PDU = -1;  /* Additional_EDCH_Cell_Information_RL_Reconf_Prep */
static int hf_nbap_UL_DPCH_Information_RL_ReconfPrepFDD_PDU = -1;  /* UL_DPCH_Information_RL_ReconfPrepFDD */
static int hf_nbap_DL_DPCH_Information_RL_ReconfPrepFDD_PDU = -1;  /* DL_DPCH_Information_RL_ReconfPrepFDD */
static int hf_nbap_DL_DPCH_Power_Information_RL_ReconfPrepFDD_PDU = -1;  /* DL_DPCH_Power_Information_RL_ReconfPrepFDD */
static int hf_nbap_DCH_DeleteList_RL_ReconfPrepFDD_PDU = -1;  /* DCH_DeleteList_RL_ReconfPrepFDD */
static int hf_nbap_RL_InformationList_RL_ReconfPrepFDD_PDU = -1;  /* RL_InformationList_RL_ReconfPrepFDD */
static int hf_nbap_RL_InformationItem_RL_ReconfPrepFDD_PDU = -1;  /* RL_InformationItem_RL_ReconfPrepFDD */
static int hf_nbap_E_DPCH_Information_RL_ReconfPrepFDD_PDU = -1;  /* E_DPCH_Information_RL_ReconfPrepFDD */
static int hf_nbap_F_DPCH_Information_RL_ReconfPrepFDD_PDU = -1;  /* F_DPCH_Information_RL_ReconfPrepFDD */
static int hf_nbap_RadioLinkReconfigurationPrepareTDD_PDU = -1;  /* RadioLinkReconfigurationPrepareTDD */
static int hf_nbap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_UL_DPCH_InformationAddItem_RL_ReconfPrepTDD_PDU = -1;  /* UL_DPCH_InformationAddItem_RL_ReconfPrepTDD */
static int hf_nbap_UL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* UL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_MultipleRL_UL_DPCH_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* MultipleRL_UL_DPCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_UL_DPCH_768_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* UL_DPCH_768_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD */
static int hf_nbap_UL_DPCH_InformationModify_AddItem_RL_ReconfPrepTDD_PDU = -1;  /* UL_DPCH_InformationModify_AddItem_RL_ReconfPrepTDD */
static int hf_nbap_UL_DPCH_InformationModify_ModifyItem_RL_ReconfPrepTDD_PDU = -1;  /* UL_DPCH_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_UL_TimeslotLCR_InformationModify_ModifyList_RL_ReconfPrepTDD_PDU = -1;  /* UL_TimeslotLCR_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_UL_Timeslot768_InformationModify_ModifyList_RL_ReconfPrepTDD_PDU = -1;  /* UL_Timeslot768_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_UL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD_PDU = -1;  /* UL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD */
static int hf_nbap_UL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD_PDU = -1;  /* UL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD */
static int hf_nbap_MultipleRL_UL_DPCH_InformationModifyList_RL_ReconfPrepTDD_PDU = -1;  /* MultipleRL_UL_DPCH_InformationModifyList_RL_ReconfPrepTDD */
static int hf_nbap_UL_DPCH_768_InformationModify_AddList_RL_ReconfPrepTDD_PDU = -1;  /* UL_DPCH_768_InformationModify_AddList_RL_ReconfPrepTDD */
static int hf_nbap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_PDU = -1;  /* UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD */
static int hf_nbap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_DL_DPCH_InformationAddItem_RL_ReconfPrepTDD_PDU = -1;  /* DL_DPCH_InformationAddItem_RL_ReconfPrepTDD */
static int hf_nbap_DL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* DL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_MultipleRL_DL_DPCH_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* MultipleRL_DL_DPCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_DL_DPCH_768_InformationAddList_RL_ReconfPrepTDD_PDU = -1;  /* DL_DPCH_768_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DL_DPCH_InformationModify_AddItem_RL_ReconfPrepTDD_PDU = -1;  /* DL_DPCH_InformationModify_AddItem_RL_ReconfPrepTDD */
static int hf_nbap_DL_DPCH_InformationModify_ModifyItem_RL_ReconfPrepTDD_PDU = -1;  /* DL_DPCH_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD_PDU = -1;  /* DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DL_Timeslot_768_InformationModify_ModifyList_RL_ReconfPrepTDD_PDU = -1;  /* DL_Timeslot_768_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD_PDU = -1;  /* DL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD */
static int hf_nbap_DL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD_PDU = -1;  /* DL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD */
static int hf_nbap_MultipleRL_DL_DPCH_InformationModifyList_RL_ReconfPrepTDD_PDU = -1;  /* MultipleRL_DL_DPCH_InformationModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DL_DPCH_768_InformationModify_AddList_RL_ReconfPrepTDD_PDU = -1;  /* DL_DPCH_768_InformationModify_AddList_RL_ReconfPrepTDD */
static int hf_nbap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_PDU = -1;  /* DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD */
static int hf_nbap_DCH_DeleteList_RL_ReconfPrepTDD_PDU = -1;  /* DCH_DeleteList_RL_ReconfPrepTDD */
static int hf_nbap_DSCH_Information_ModifyList_RL_ReconfPrepTDD_PDU = -1;  /* DSCH_Information_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DSCH_Information_DeleteList_RL_ReconfPrepTDD_PDU = -1;  /* DSCH_Information_DeleteList_RL_ReconfPrepTDD */
static int hf_nbap_USCH_Information_ModifyList_RL_ReconfPrepTDD_PDU = -1;  /* USCH_Information_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_USCH_Information_DeleteList_RL_ReconfPrepTDD_PDU = -1;  /* USCH_Information_DeleteList_RL_ReconfPrepTDD */
static int hf_nbap_MultipleRL_Information_RL_ReconfPrepTDD_PDU = -1;  /* MultipleRL_Information_RL_ReconfPrepTDD */
static int hf_nbap_RL_Information_RL_ReconfPrepTDD_PDU = -1;  /* RL_Information_RL_ReconfPrepTDD */
static int hf_nbap_RadioLinkReconfigurationReady_PDU = -1;  /* RadioLinkReconfigurationReady */
static int hf_nbap_RL_InformationResponseList_RL_ReconfReady_PDU = -1;  /* RL_InformationResponseList_RL_ReconfReady */
static int hf_nbap_RL_InformationResponseItem_RL_ReconfReady_PDU = -1;  /* RL_InformationResponseItem_RL_ReconfReady */
static int hf_nbap_RadioLinkReconfigurationFailure_PDU = -1;  /* RadioLinkReconfigurationFailure */
static int hf_nbap_CauseLevel_RL_ReconfFailure_PDU = -1;  /* CauseLevel_RL_ReconfFailure */
static int hf_nbap_RL_ReconfigurationFailureItem_RL_ReconfFailure_PDU = -1;  /* RL_ReconfigurationFailureItem_RL_ReconfFailure */
static int hf_nbap_RadioLinkReconfigurationCommit_PDU = -1;  /* RadioLinkReconfigurationCommit */
static int hf_nbap_RadioLinkReconfigurationCancel_PDU = -1;  /* RadioLinkReconfigurationCancel */
static int hf_nbap_RadioLinkReconfigurationRequestFDD_PDU = -1;  /* RadioLinkReconfigurationRequestFDD */
static int hf_nbap_Additional_HS_Cell_Information_RL_Reconf_Req_PDU = -1;  /* Additional_HS_Cell_Information_RL_Reconf_Req */
static int hf_nbap_Additional_EDCH_Cell_Information_RL_Reconf_Req_PDU = -1;  /* Additional_EDCH_Cell_Information_RL_Reconf_Req */
static int hf_nbap_UL_DPCH_Information_RL_ReconfRqstFDD_PDU = -1;  /* UL_DPCH_Information_RL_ReconfRqstFDD */
static int hf_nbap_DL_DPCH_Information_RL_ReconfRqstFDD_PDU = -1;  /* DL_DPCH_Information_RL_ReconfRqstFDD */
static int hf_nbap_DCH_DeleteList_RL_ReconfRqstFDD_PDU = -1;  /* DCH_DeleteList_RL_ReconfRqstFDD */
static int hf_nbap_RL_InformationList_RL_ReconfRqstFDD_PDU = -1;  /* RL_InformationList_RL_ReconfRqstFDD */
static int hf_nbap_RL_InformationItem_RL_ReconfRqstFDD_PDU = -1;  /* RL_InformationItem_RL_ReconfRqstFDD */
static int hf_nbap_E_DPCH_Information_RL_ReconfRqstFDD_PDU = -1;  /* E_DPCH_Information_RL_ReconfRqstFDD */
static int hf_nbap_RadioLinkReconfigurationRequestTDD_PDU = -1;  /* RadioLinkReconfigurationRequestTDD */
static int hf_nbap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD */
static int hf_nbap_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD */
static int hf_nbap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD */
static int hf_nbap_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD_PDU = -1;  /* UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD */
static int hf_nbap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD */
static int hf_nbap_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD */
static int hf_nbap_MultipleRL_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_PDU = -1;  /* MultipleRL_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD */
static int hf_nbap_DL_DPCH_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD_PDU = -1;  /* DL_DPCH_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD */
static int hf_nbap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD */
static int hf_nbap_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD_PDU = -1;  /* DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD */
static int hf_nbap_DCH_DeleteList_RL_ReconfRqstTDD_PDU = -1;  /* DCH_DeleteList_RL_ReconfRqstTDD */
static int hf_nbap_Multiple_RL_Information_RL_ReconfRqstTDD_PDU = -1;  /* Multiple_RL_Information_RL_ReconfRqstTDD */
static int hf_nbap_RL_Information_RL_ReconfRqstTDD_PDU = -1;  /* RL_Information_RL_ReconfRqstTDD */
static int hf_nbap_RadioLinkReconfigurationResponse_PDU = -1;  /* RadioLinkReconfigurationResponse */
static int hf_nbap_RL_InformationResponseList_RL_ReconfRsp_PDU = -1;  /* RL_InformationResponseList_RL_ReconfRsp */
static int hf_nbap_RL_InformationResponseItem_RL_ReconfRsp_PDU = -1;  /* RL_InformationResponseItem_RL_ReconfRsp */
static int hf_nbap_RadioLinkDeletionRequest_PDU = -1;  /* RadioLinkDeletionRequest */
static int hf_nbap_RL_informationList_RL_DeletionRqst_PDU = -1;  /* RL_informationList_RL_DeletionRqst */
static int hf_nbap_RL_informationItem_RL_DeletionRqst_PDU = -1;  /* RL_informationItem_RL_DeletionRqst */
static int hf_nbap_RadioLinkDeletionResponse_PDU = -1;  /* RadioLinkDeletionResponse */
static int hf_nbap_DL_PowerControlRequest_PDU = -1;  /* DL_PowerControlRequest */
static int hf_nbap_DL_ReferencePowerInformationList_DL_PC_Rqst_PDU = -1;  /* DL_ReferencePowerInformationList_DL_PC_Rqst */
static int hf_nbap_DL_ReferencePowerInformationItem_DL_PC_Rqst_PDU = -1;  /* DL_ReferencePowerInformationItem_DL_PC_Rqst */
static int hf_nbap_DL_PowerTimeslotControlRequest_PDU = -1;  /* DL_PowerTimeslotControlRequest */
static int hf_nbap_DedicatedMeasurementInitiationRequest_PDU = -1;  /* DedicatedMeasurementInitiationRequest */
static int hf_nbap_DedicatedMeasurementObjectType_DM_Rqst_PDU = -1;  /* DedicatedMeasurementObjectType_DM_Rqst */
static int hf_nbap_RL_InformationItem_DM_Rqst_PDU = -1;  /* RL_InformationItem_DM_Rqst */
static int hf_nbap_PUSCH_Info_DM_Rqst_PDU = -1;   /* PUSCH_Info_DM_Rqst */
static int hf_nbap_HSSICH_Info_DM_Rqst_PDU = -1;  /* HSSICH_Info_DM_Rqst */
static int hf_nbap_HSSICH_InfoExt_DM_Rqst_PDU = -1;  /* HSSICH_InfoExt_DM_Rqst */
static int hf_nbap_DedicatedMeasurementInitiationResponse_PDU = -1;  /* DedicatedMeasurementInitiationResponse */
static int hf_nbap_DedicatedMeasurementObjectType_DM_Rsp_PDU = -1;  /* DedicatedMeasurementObjectType_DM_Rsp */
static int hf_nbap_RL_InformationItem_DM_Rsp_PDU = -1;  /* RL_InformationItem_DM_Rsp */
static int hf_nbap_PUSCH_Info_DM_Rsp_PDU = -1;    /* PUSCH_Info_DM_Rsp */
static int hf_nbap_Multiple_PUSCH_InfoList_DM_Rsp_PDU = -1;  /* Multiple_PUSCH_InfoList_DM_Rsp */
static int hf_nbap_Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp_PDU = -1;  /* Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp */
static int hf_nbap_Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp_PDU = -1;  /* Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp */
static int hf_nbap_Multiple_HSSICHMeasurementValueList_TDD_DM_Rsp_PDU = -1;  /* Multiple_HSSICHMeasurementValueList_TDD_DM_Rsp */
static int hf_nbap_Multiple_DedicatedMeasurementValueList_768_TDD_DM_Rsp_PDU = -1;  /* Multiple_DedicatedMeasurementValueList_768_TDD_DM_Rsp */
static int hf_nbap_RL_Set_InformationItem_DM_Rsp_PDU = -1;  /* RL_Set_InformationItem_DM_Rsp */
static int hf_nbap_DedicatedMeasurementInitiationFailure_PDU = -1;  /* DedicatedMeasurementInitiationFailure */
static int hf_nbap_DedicatedMeasurementReport_PDU = -1;  /* DedicatedMeasurementReport */
static int hf_nbap_DedicatedMeasurementObjectType_DM_Rprt_PDU = -1;  /* DedicatedMeasurementObjectType_DM_Rprt */
static int hf_nbap_RL_InformationItem_DM_Rprt_PDU = -1;  /* RL_InformationItem_DM_Rprt */
static int hf_nbap_PUSCH_Info_DM_Rprt_PDU = -1;   /* PUSCH_Info_DM_Rprt */
static int hf_nbap_Multiple_PUSCH_InfoList_DM_Rprt_PDU = -1;  /* Multiple_PUSCH_InfoList_DM_Rprt */
static int hf_nbap_RL_Set_InformationItem_DM_Rprt_PDU = -1;  /* RL_Set_InformationItem_DM_Rprt */
static int hf_nbap_DedicatedMeasurementTerminationRequest_PDU = -1;  /* DedicatedMeasurementTerminationRequest */
static int hf_nbap_DedicatedMeasurementFailureIndication_PDU = -1;  /* DedicatedMeasurementFailureIndication */
static int hf_nbap_RadioLinkFailureIndication_PDU = -1;  /* RadioLinkFailureIndication */
static int hf_nbap_Reporting_Object_RL_FailureInd_PDU = -1;  /* Reporting_Object_RL_FailureInd */
static int hf_nbap_RL_InformationItem_RL_FailureInd_PDU = -1;  /* RL_InformationItem_RL_FailureInd */
static int hf_nbap_RL_Set_InformationItem_RL_FailureInd_PDU = -1;  /* RL_Set_InformationItem_RL_FailureInd */
static int hf_nbap_CCTrCH_InformationItem_RL_FailureInd_PDU = -1;  /* CCTrCH_InformationItem_RL_FailureInd */
static int hf_nbap_RadioLinkPreemptionRequiredIndication_PDU = -1;  /* RadioLinkPreemptionRequiredIndication */
static int hf_nbap_RL_InformationList_RL_PreemptRequiredInd_PDU = -1;  /* RL_InformationList_RL_PreemptRequiredInd */
static int hf_nbap_RL_InformationItem_RL_PreemptRequiredInd_PDU = -1;  /* RL_InformationItem_RL_PreemptRequiredInd */
static int hf_nbap_RadioLinkRestoreIndication_PDU = -1;  /* RadioLinkRestoreIndication */
static int hf_nbap_Reporting_Object_RL_RestoreInd_PDU = -1;  /* Reporting_Object_RL_RestoreInd */
static int hf_nbap_RL_InformationItem_RL_RestoreInd_PDU = -1;  /* RL_InformationItem_RL_RestoreInd */
static int hf_nbap_RL_Set_InformationItem_RL_RestoreInd_PDU = -1;  /* RL_Set_InformationItem_RL_RestoreInd */
static int hf_nbap_CCTrCH_InformationItem_RL_RestoreInd_PDU = -1;  /* CCTrCH_InformationItem_RL_RestoreInd */
static int hf_nbap_CompressedModeCommand_PDU = -1;  /* CompressedModeCommand */
static int hf_nbap_ErrorIndication_PDU = -1;      /* ErrorIndication */
static int hf_nbap_PrivateMessage_PDU = -1;       /* PrivateMessage */
static int hf_nbap_PhysicalSharedChannelReconfigurationRequestFDD_PDU = -1;  /* PhysicalSharedChannelReconfigurationRequestFDD */
static int hf_nbap_HSDPA_And_EDCH_CellPortion_InformationList_PSCH_ReconfRqst_PDU = -1;  /* HSDPA_And_EDCH_CellPortion_InformationList_PSCH_ReconfRqst */
static int hf_nbap_PhysicalSharedChannelReconfigurationRequestTDD_PDU = -1;  /* PhysicalSharedChannelReconfigurationRequestTDD */
static int hf_nbap_PDSCHSets_AddList_PSCH_ReconfRqst_PDU = -1;  /* PDSCHSets_AddList_PSCH_ReconfRqst */
static int hf_nbap_PDSCH_Information_AddItem_PSCH_ReconfRqst_PDU = -1;  /* PDSCH_Information_AddItem_PSCH_ReconfRqst */
static int hf_nbap_PDSCH_AddInformation_LCR_AddItem_PSCH_ReconfRqst_PDU = -1;  /* PDSCH_AddInformation_LCR_AddItem_PSCH_ReconfRqst */
static int hf_nbap_PDSCH_AddInformation_768_AddItem_PSCH_ReconfRqst_PDU = -1;  /* PDSCH_AddInformation_768_AddItem_PSCH_ReconfRqst */
static int hf_nbap_PDSCHSets_ModifyList_PSCH_ReconfRqst_PDU = -1;  /* PDSCHSets_ModifyList_PSCH_ReconfRqst */
static int hf_nbap_PDSCH_Information_ModifyItem_PSCH_ReconfRqst_PDU = -1;  /* PDSCH_Information_ModifyItem_PSCH_ReconfRqst */
static int hf_nbap_PDSCH_ModifyInformation_LCR_ModifyItem_PSCH_ReconfRqst_PDU = -1;  /* PDSCH_ModifyInformation_LCR_ModifyItem_PSCH_ReconfRqst */
static int hf_nbap_PDSCH_ModifyInformation_768_ModifyItem_PSCH_ReconfRqst_PDU = -1;  /* PDSCH_ModifyInformation_768_ModifyItem_PSCH_ReconfRqst */
static int hf_nbap_PDSCHSets_DeleteList_PSCH_ReconfRqst_PDU = -1;  /* PDSCHSets_DeleteList_PSCH_ReconfRqst */
static int hf_nbap_PUSCHSets_AddList_PSCH_ReconfRqst_PDU = -1;  /* PUSCHSets_AddList_PSCH_ReconfRqst */
static int hf_nbap_PUSCH_Information_AddItem_PSCH_ReconfRqst_PDU = -1;  /* PUSCH_Information_AddItem_PSCH_ReconfRqst */
static int hf_nbap_PUSCH_AddInformation_LCR_AddItem_PSCH_ReconfRqst_PDU = -1;  /* PUSCH_AddInformation_LCR_AddItem_PSCH_ReconfRqst */
static int hf_nbap_PUSCH_AddInformation_768_AddItem_PSCH_ReconfRqst_PDU = -1;  /* PUSCH_AddInformation_768_AddItem_PSCH_ReconfRqst */
static int hf_nbap_PUSCHSets_ModifyList_PSCH_ReconfRqst_PDU = -1;  /* PUSCHSets_ModifyList_PSCH_ReconfRqst */
static int hf_nbap_PUSCH_Information_ModifyItem_PSCH_ReconfRqst_PDU = -1;  /* PUSCH_Information_ModifyItem_PSCH_ReconfRqst */
static int hf_nbap_PUSCH_ModifyInformation_LCR_ModifyItem_PSCH_ReconfRqst_PDU = -1;  /* PUSCH_ModifyInformation_LCR_ModifyItem_PSCH_ReconfRqst */
static int hf_nbap_PUSCH_ModifyInformation_768_ModifyItem_PSCH_ReconfRqst_PDU = -1;  /* PUSCH_ModifyInformation_768_ModifyItem_PSCH_ReconfRqst */
static int hf_nbap_PUSCHSets_DeleteList_PSCH_ReconfRqst_PDU = -1;  /* PUSCHSets_DeleteList_PSCH_ReconfRqst */
static int hf_nbap_HS_PDSCH_TDD_Information_PSCH_ReconfRqst_PDU = -1;  /* HS_PDSCH_TDD_Information_PSCH_ReconfRqst */
static int hf_nbap_DL_HS_PDSCH_Timeslot_Information_768_PSCH_ReconfRqst_PDU = -1;  /* DL_HS_PDSCH_Timeslot_Information_768_PSCH_ReconfRqst */
static int hf_nbap_MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst_PDU = -1;  /* MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst */
static int hf_nbap_MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst_PDU = -1;  /* MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst */
static int hf_nbap_Add_To_HS_SCCH_Resource_Pool_PSCH_ReconfRqst_PDU = -1;  /* Add_To_HS_SCCH_Resource_Pool_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_Information_768_PSCH_ReconfRqst_PDU = -1;  /* HS_SCCH_Information_768_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_InformationExt_LCR_PSCH_ReconfRqst_PDU = -1;  /* HS_SCCH_InformationExt_LCR_PSCH_ReconfRqst */
static int hf_nbap_Modify_HS_SCCH_Resource_Pool_PSCH_ReconfRqst_PDU = -1;  /* Modify_HS_SCCH_Resource_Pool_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_InformationModifyExt_LCR_PSCH_ReconfRqst_PDU = -1;  /* HS_SCCH_InformationModifyExt_LCR_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_InformationModify_768_PSCH_ReconfRqst_PDU = -1;  /* HS_SCCH_InformationModify_768_PSCH_ReconfRqst */
static int hf_nbap_Delete_From_HS_SCCH_Resource_Pool_PSCH_ReconfRqst_PDU = -1;  /* Delete_From_HS_SCCH_Resource_Pool_PSCH_ReconfRqst */
static int hf_nbap_E_PUCH_Information_PSCH_ReconfRqst_PDU = -1;  /* E_PUCH_Information_PSCH_ReconfRqst */
static int hf_nbap_Add_To_E_AGCH_Resource_Pool_PSCH_ReconfRqst_PDU = -1;  /* Add_To_E_AGCH_Resource_Pool_PSCH_ReconfRqst */
static int hf_nbap_Modify_E_AGCH_Resource_Pool_PSCH_ReconfRqst_PDU = -1;  /* Modify_E_AGCH_Resource_Pool_PSCH_ReconfRqst */
static int hf_nbap_Delete_From_E_AGCH_Resource_Pool_PSCH_ReconfRqst_PDU = -1;  /* Delete_From_E_AGCH_Resource_Pool_PSCH_ReconfRqst */
static int hf_nbap_E_HICH_Information_PSCH_ReconfRqst_PDU = -1;  /* E_HICH_Information_PSCH_ReconfRqst */
static int hf_nbap_E_PUCH_Information_768_PSCH_ReconfRqst_PDU = -1;  /* E_PUCH_Information_768_PSCH_ReconfRqst */
static int hf_nbap_Add_To_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst_PDU = -1;  /* Add_To_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst */
static int hf_nbap_Modify_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst_PDU = -1;  /* Modify_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst */
static int hf_nbap_E_HICH_Information_768_PSCH_ReconfRqst_PDU = -1;  /* E_HICH_Information_768_PSCH_ReconfRqst */
static int hf_nbap_E_PUCH_Information_LCR_PSCH_ReconfRqst_PDU = -1;  /* E_PUCH_Information_LCR_PSCH_ReconfRqst */
static int hf_nbap_Add_To_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst_PDU = -1;  /* Add_To_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst */
static int hf_nbap_Modify_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst_PDU = -1;  /* Modify_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst */
static int hf_nbap_Add_To_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst_PDU = -1;  /* Add_To_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst */
static int hf_nbap_Modify_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst_PDU = -1;  /* Modify_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst */
static int hf_nbap_Delete_From_E_HICH_Resource_Pool_PSCH_ReconfRqst_PDU = -1;  /* Delete_From_E_HICH_Resource_Pool_PSCH_ReconfRqst */
static int hf_nbap_SYNC_UL_Partition_LCR_PDU = -1;  /* SYNC_UL_Partition_LCR */
static int hf_nbap_Delete_From_HS_SCCH_Resource_PoolExt_PSCH_ReconfRqst_PDU = -1;  /* Delete_From_HS_SCCH_Resource_PoolExt_PSCH_ReconfRqst */
static int hf_nbap_MultipleFreq_E_PUCH_Timeslot_InformationList_LCR_PSCH_ReconfRqst_PDU = -1;  /* MultipleFreq_E_PUCH_Timeslot_InformationList_LCR_PSCH_ReconfRqst */
static int hf_nbap_MultipleFreq_E_PUCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst_PDU = -1;  /* MultipleFreq_E_PUCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst */
static int hf_nbap_Max_RTWP_perUARFCN_Information_LCR_PSCH_ReconfRqst_PDU = -1;  /* Max_RTWP_perUARFCN_Information_LCR_PSCH_ReconfRqst */
static int hf_nbap_PhysicalSharedChannelReconfigurationResponse_PDU = -1;  /* PhysicalSharedChannelReconfigurationResponse */
static int hf_nbap_E_HICH_TimeOffset_ExtensionLCR_PDU = -1;  /* E_HICH_TimeOffset_ExtensionLCR */
static int hf_nbap_MultipleFreq_E_HICH_TimeOffsetLCR_PDU = -1;  /* MultipleFreq_E_HICH_TimeOffsetLCR */
static int hf_nbap_PhysicalSharedChannelReconfigurationFailure_PDU = -1;  /* PhysicalSharedChannelReconfigurationFailure */
static int hf_nbap_CauseLevel_PSCH_ReconfFailure_PDU = -1;  /* CauseLevel_PSCH_ReconfFailure */
static int hf_nbap_Unsuccessful_PDSCHSetItem_PSCH_ReconfFailureTDD_PDU = -1;  /* Unsuccessful_PDSCHSetItem_PSCH_ReconfFailureTDD */
static int hf_nbap_Unsuccessful_PUSCHSetItem_PSCH_ReconfFailureTDD_PDU = -1;  /* Unsuccessful_PUSCHSetItem_PSCH_ReconfFailureTDD */
static int hf_nbap_UARFCNSpecificCauseList_PSCH_ReconfFailureTDD_PDU = -1;  /* UARFCNSpecificCauseList_PSCH_ReconfFailureTDD */
static int hf_nbap_Unsuccessful_UARFCNItem_PSCH_ReconfFailureTDD_PDU = -1;  /* Unsuccessful_UARFCNItem_PSCH_ReconfFailureTDD */
static int hf_nbap_E_HICH_TimeOffset_ReconfFailureTDD_PDU = -1;  /* E_HICH_TimeOffset_ReconfFailureTDD */
static int hf_nbap_Common_System_Information_ResponseLCR_PDU = -1;  /* Common_System_Information_ResponseLCR */
static int hf_nbap_ResetRequest_PDU = -1;         /* ResetRequest */
static int hf_nbap_ResetIndicator_PDU = -1;       /* ResetIndicator */
static int hf_nbap_CommunicationContextInfoItem_Reset_PDU = -1;  /* CommunicationContextInfoItem_Reset */
static int hf_nbap_CommunicationControlPortInfoItem_Reset_PDU = -1;  /* CommunicationControlPortInfoItem_Reset */
static int hf_nbap_ResetResponse_PDU = -1;        /* ResetResponse */
static int hf_nbap_InformationExchangeInitiationRequest_PDU = -1;  /* InformationExchangeInitiationRequest */
static int hf_nbap_InformationExchangeObjectType_InfEx_Rqst_PDU = -1;  /* InformationExchangeObjectType_InfEx_Rqst */
static int hf_nbap_InformationExchangeInitiationResponse_PDU = -1;  /* InformationExchangeInitiationResponse */
static int hf_nbap_InformationExchangeObjectType_InfEx_Rsp_PDU = -1;  /* InformationExchangeObjectType_InfEx_Rsp */
static int hf_nbap_InformationExchangeInitiationFailure_PDU = -1;  /* InformationExchangeInitiationFailure */
static int hf_nbap_InformationReport_PDU = -1;    /* InformationReport */
static int hf_nbap_InformationExchangeObjectType_InfEx_Rprt_PDU = -1;  /* InformationExchangeObjectType_InfEx_Rprt */
static int hf_nbap_InformationExchangeTerminationRequest_PDU = -1;  /* InformationExchangeTerminationRequest */
static int hf_nbap_InformationExchangeFailureIndication_PDU = -1;  /* InformationExchangeFailureIndication */
static int hf_nbap_CellSynchronisationInitiationRequestTDD_PDU = -1;  /* CellSynchronisationInitiationRequestTDD */
static int hf_nbap_TimeslotInfo_CellSyncInitiationRqstTDD_PDU = -1;  /* TimeslotInfo_CellSyncInitiationRqstTDD */
static int hf_nbap_CellSyncBurstTransInit_CellSyncInitiationRqstTDD_PDU = -1;  /* CellSyncBurstTransInit_CellSyncInitiationRqstTDD */
static int hf_nbap_CellSyncBurstMeasureInit_CellSyncInitiationRqstTDD_PDU = -1;  /* CellSyncBurstMeasureInit_CellSyncInitiationRqstTDD */
static int hf_nbap_SYNCDlCodeId_TransInitLCR_CellSyncInitiationRqstTDD_PDU = -1;  /* SYNCDlCodeId_TransInitLCR_CellSyncInitiationRqstTDD */
static int hf_nbap_SYNCDlCodeId_MeasureInitLCR_CellSyncInitiationRqstTDD_PDU = -1;  /* SYNCDlCodeId_MeasureInitLCR_CellSyncInitiationRqstTDD */
static int hf_nbap_CellSynchronisationInitiationResponseTDD_PDU = -1;  /* CellSynchronisationInitiationResponseTDD */
static int hf_nbap_CellSynchronisationInitiationFailureTDD_PDU = -1;  /* CellSynchronisationInitiationFailureTDD */
static int hf_nbap_CellSynchronisationReconfigurationRequestTDD_PDU = -1;  /* CellSynchronisationReconfigurationRequestTDD */
static int hf_nbap_CellSyncBurstTransReconfInfo_CellSyncReconfRqstTDD_PDU = -1;  /* CellSyncBurstTransReconfInfo_CellSyncReconfRqstTDD */
static int hf_nbap_CellSyncBurstMeasInfo_CellSyncReconfRqstTDD_PDU = -1;  /* CellSyncBurstMeasInfo_CellSyncReconfRqstTDD */
static int hf_nbap_CellSyncBurstMeasInfoListIE_CellSyncReconfRqstTDD_PDU = -1;  /* CellSyncBurstMeasInfoListIE_CellSyncReconfRqstTDD */
static int hf_nbap_SYNCDlCodeIdTransReconfInfoLCR_CellSyncReconfRqstTDD_PDU = -1;  /* SYNCDlCodeIdTransReconfInfoLCR_CellSyncReconfRqstTDD */
static int hf_nbap_SYNCDlCodeIdMeasInfoLCR_CellSyncReconfRqstTDD_PDU = -1;  /* SYNCDlCodeIdMeasInfoLCR_CellSyncReconfRqstTDD */
static int hf_nbap_CellSynchronisationReconfigurationResponseTDD_PDU = -1;  /* CellSynchronisationReconfigurationResponseTDD */
static int hf_nbap_CellSynchronisationReconfigurationFailureTDD_PDU = -1;  /* CellSynchronisationReconfigurationFailureTDD */
static int hf_nbap_CellSynchronisationAdjustmentRequestTDD_PDU = -1;  /* CellSynchronisationAdjustmentRequestTDD */
static int hf_nbap_CellAdjustmentInfo_SyncAdjustmentRqstTDD_PDU = -1;  /* CellAdjustmentInfo_SyncAdjustmentRqstTDD */
static int hf_nbap_CellAdjustmentInfoItem_SyncAdjustmentRqstTDD_PDU = -1;  /* CellAdjustmentInfoItem_SyncAdjustmentRqstTDD */
static int hf_nbap_CellSynchronisationAdjustmentResponseTDD_PDU = -1;  /* CellSynchronisationAdjustmentResponseTDD */
static int hf_nbap_CellSynchronisationAdjustmentFailureTDD_PDU = -1;  /* CellSynchronisationAdjustmentFailureTDD */
static int hf_nbap_CauseLevel_SyncAdjustmntFailureTDD_PDU = -1;  /* CauseLevel_SyncAdjustmntFailureTDD */
static int hf_nbap_Unsuccessful_cell_InformationRespItem_SyncAdjustmntFailureTDD_PDU = -1;  /* Unsuccessful_cell_InformationRespItem_SyncAdjustmntFailureTDD */
static int hf_nbap_CellSynchronisationTerminationRequestTDD_PDU = -1;  /* CellSynchronisationTerminationRequestTDD */
static int hf_nbap_CellSynchronisationFailureIndicationTDD_PDU = -1;  /* CellSynchronisationFailureIndicationTDD */
static int hf_nbap_CellSynchronisationReportTDD_PDU = -1;  /* CellSynchronisationReportTDD */
static int hf_nbap_CellSyncInfo_CellSyncReprtTDD_PDU = -1;  /* CellSyncInfo_CellSyncReprtTDD */
static int hf_nbap_SyncReportType_CellSyncReprtTDD_PDU = -1;  /* SyncReportType_CellSyncReprtTDD */
static int hf_nbap_SyncDLCodeIdsMeasInfoList_CellSyncReprtTDD_PDU = -1;  /* SyncDLCodeIdsMeasInfoList_CellSyncReprtTDD */
static int hf_nbap_BearerRearrangementIndication_PDU = -1;  /* BearerRearrangementIndication */
static int hf_nbap_DCH_RearrangeList_Bearer_RearrangeInd_PDU = -1;  /* DCH_RearrangeList_Bearer_RearrangeInd */
static int hf_nbap_DSCH_RearrangeList_Bearer_RearrangeInd_PDU = -1;  /* DSCH_RearrangeList_Bearer_RearrangeInd */
static int hf_nbap_USCH_RearrangeList_Bearer_RearrangeInd_PDU = -1;  /* USCH_RearrangeList_Bearer_RearrangeInd */
static int hf_nbap_HSDSCH_RearrangeList_Bearer_RearrangeInd_PDU = -1;  /* HSDSCH_RearrangeList_Bearer_RearrangeInd */
static int hf_nbap_E_DCH_RearrangeList_Bearer_RearrangeInd_PDU = -1;  /* E_DCH_RearrangeList_Bearer_RearrangeInd */
static int hf_nbap_Additional_EDCH_Cell_Information_Bearer_Rearrangement_List_PDU = -1;  /* Additional_EDCH_Cell_Information_Bearer_Rearrangement_List */
static int hf_nbap_RadioLinkActivationCommandFDD_PDU = -1;  /* RadioLinkActivationCommandFDD */
static int hf_nbap_DelayedActivationInformationList_RL_ActivationCmdFDD_PDU = -1;  /* DelayedActivationInformationList_RL_ActivationCmdFDD */
static int hf_nbap_DelayedActivationInformation_RL_ActivationCmdFDD_PDU = -1;  /* DelayedActivationInformation_RL_ActivationCmdFDD */
static int hf_nbap_RadioLinkActivationCommandTDD_PDU = -1;  /* RadioLinkActivationCommandTDD */
static int hf_nbap_DelayedActivationInformationList_RL_ActivationCmdTDD_PDU = -1;  /* DelayedActivationInformationList_RL_ActivationCmdTDD */
static int hf_nbap_DelayedActivationInformation_RL_ActivationCmdTDD_PDU = -1;  /* DelayedActivationInformation_RL_ActivationCmdTDD */
static int hf_nbap_RadioLinkParameterUpdateIndicationFDD_PDU = -1;  /* RadioLinkParameterUpdateIndicationFDD */
static int hf_nbap_Additional_HS_Cell_Information_RL_Param_Upd_PDU = -1;  /* Additional_HS_Cell_Information_RL_Param_Upd */
static int hf_nbap_Additional_EDCH_Cell_Information_RL_Param_Upd_PDU = -1;  /* Additional_EDCH_Cell_Information_RL_Param_Upd */
static int hf_nbap_RadioLinkParameterUpdateIndicationTDD_PDU = -1;  /* RadioLinkParameterUpdateIndicationTDD */
static int hf_nbap_MBMSNotificationUpdateCommand_PDU = -1;  /* MBMSNotificationUpdateCommand */
static int hf_nbap_UEStatusUpdateCommand_PDU = -1;  /* UEStatusUpdateCommand */
static int hf_nbap_SecondaryULFrequencyReport_PDU = -1;  /* SecondaryULFrequencyReport */
static int hf_nbap_SecondaryULFrequencyUpdateIndication_PDU = -1;  /* SecondaryULFrequencyUpdateIndication */
static int hf_nbap_NBAP_PDU_PDU = -1;             /* NBAP_PDU */
static int hf_nbap_NULL_PDU = -1;                 /* NULL */
static int hf_nbap_local = -1;                    /* INTEGER_0_maxPrivateIEs */
static int hf_nbap_global = -1;                   /* OBJECT_IDENTIFIER */
static int hf_nbap_procedureCode = -1;            /* ProcedureCode */
static int hf_nbap_ddMode = -1;                   /* DdMode */
static int hf_nbap_shortTransActionId = -1;       /* T_shortTransActionId */
static int hf_nbap_longTransActionId = -1;        /* T_longTransActionId */
static int hf_nbap_ProtocolIE_Container_item = -1;  /* ProtocolIE_Field */
static int hf_nbap_id = -1;                       /* ProtocolIE_ID */
static int hf_nbap_criticality = -1;              /* Criticality */
static int hf_nbap_ie_field_value = -1;           /* ProtocolIE_Field_value */
static int hf_nbap_ProtocolExtensionContainer_item = -1;  /* ProtocolExtensionField */
static int hf_nbap_extensionValue = -1;           /* T_extensionValue */
static int hf_nbap_PrivateIE_Container_item = -1;  /* PrivateIE_Field */
static int hf_nbap_id_01 = -1;                    /* PrivateIE_ID */
static int hf_nbap_private_value = -1;            /* PrivateIE_Field_value */
static int hf_nbap_ActivationInformation_item = -1;  /* ActivationInformationItem */
static int hf_nbap_uU_ActivationState = -1;       /* Uu_ActivationState */
static int hf_nbap_iE_Extensions = -1;            /* ProtocolExtensionContainer */
static int hf_nbap_multicell_EDCH_Transport_Bearer_Mode = -1;  /* Multicell_EDCH_Transport_Bearer_Mode */
static int hf_nbap_additional_EDCH_Cell_Information_Setup = -1;  /* Additional_EDCH_Cell_Information_Setup */
static int hf_nbap_Additional_EDCH_Cell_Information_Setup_item = -1;  /* Additional_EDCH_FDD_Setup_Cell_Information */
static int hf_nbap_additional_EDCH_UL_DPCH_Information_Setup = -1;  /* Additional_EDCH_UL_DPCH_Information_Setup */
static int hf_nbap_additional_EDCH_RL_Specific_Information_To_Setup = -1;  /* Additional_EDCH_RL_Specific_Information_To_Setup_List */
static int hf_nbap_additional_EDCH_FDD_Information = -1;  /* Additional_EDCH_FDD_Information */
static int hf_nbap_additional_EDCH_F_DPCH_Information_Setup = -1;  /* Additional_EDCH_F_DPCH_Information */
static int hf_nbap_multicell_EDCH_Information = -1;  /* Multicell_EDCH_Information */
static int hf_nbap_ul_ScramblingCode = -1;        /* UL_ScramblingCode */
static int hf_nbap_ul_SIR_Target = -1;            /* UL_SIR */
static int hf_nbap_fdd_TPC_DownlinkStepSize = -1;  /* FDD_TPC_DownlinkStepSize */
static int hf_nbap_limitedPowerIncrease = -1;     /* LimitedPowerIncrease */
static int hf_nbap_innerLoopDLPCStatus = -1;      /* InnerLoopDLPCStatus */
static int hf_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_List_item = -1;  /* Additional_EDCH_RL_Specific_Information_To_Setup_ItemIEs */
static int hf_nbap_eDCH_Additional_RL_ID = -1;    /* RL_ID */
static int hf_nbap_c_ID = -1;                     /* C_ID */
static int hf_nbap_firstRLS_indicator = -1;       /* FirstRLS_Indicator */
static int hf_nbap_propagationDelay = -1;         /* PropagationDelay */
static int hf_nbap_dl_CodeInformation = -1;       /* FDD_DL_CodeInformation */
static int hf_nbap_initialDL_transmissionPower = -1;  /* DL_Power */
static int hf_nbap_maximumDL_power = -1;          /* DL_Power */
static int hf_nbap_minimumDL_power = -1;          /* DL_Power */
static int hf_nbap_f_DPCH_SlotFormat = -1;        /* F_DPCH_SlotFormat */
static int hf_nbap_e_RNTI = -1;                   /* E_RNTI */
static int hf_nbap_multicell_EDCH_RL_Specific_Information = -1;  /* Multicell_EDCH_RL_Specific_Information */
static int hf_nbap_Additional_EDCH_Cell_Information_To_Add_List_item = -1;  /* Additional_EDCH_Cell_Information_To_Add_ItemIEs */
static int hf_nbap_additional_EDCH_RL_Specific_Information_To_Add_ItemIEs = -1;  /* Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs */
static int hf_nbap_Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs_item = -1;  /* EDCH_Additional_RL_Specific_Information_To_Add_List */
static int hf_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_List_item = -1;  /* Additional_EDCH_RL_Specific_Information_To_Modify_ItemIEs */
static int hf_nbap_additional_EDCH_MAC_d_Flows_Specific_Information = -1;  /* Additional_EDCH_MAC_d_Flows_Specific_Info_List */
static int hf_nbap_hARQ_Process_Allocation_Scheduled_2ms_EDCH = -1;  /* HARQ_Process_Allocation_2ms_EDCH */
static int hf_nbap_e_DCH_Maximum_Bitrate = -1;    /* E_DCH_Maximum_Bitrate */
static int hf_nbap_e_DCH_Processing_Overload_Level = -1;  /* E_DCH_Processing_Overload_Level */
static int hf_nbap_e_DCH_Min_Set_E_TFCI = -1;     /* E_TFCI */
static int hf_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_List_item = -1;  /* Additional_EDCH_MAC_d_Flows_Specific_Info */
static int hf_nbap_e_DCH_MACdFlow_ID = -1;        /* E_DCH_MACdFlow_ID */
static int hf_nbap_bindingID = -1;                /* BindingID */
static int hf_nbap_transportLayerAddress = -1;    /* TransportLayerAddress */
static int hf_nbap_Additional_EDCH_Cell_Information_Response_List_item = -1;  /* Additional_EDCH_FDD_Information_Response_ItemIEs */
static int hf_nbap_eDCH_Additional_RL_Specific_Information_Response = -1;  /* EDCH_Additional_RL_Specific_Information_Response_List */
static int hf_nbap_additional_EDCH_MAC_d_Flow_Specific_Information_Response = -1;  /* Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List */
static int hf_nbap_EDCH_Additional_RL_Specific_Information_Response_List_item = -1;  /* EDCH_Additional_RL_Specific_Information_Response_ItemIEs */
static int hf_nbap_received_total_wide_band_power = -1;  /* Received_total_wide_band_power_Value */
static int hf_nbap_dL_PowerBalancing_ActivationIndicator = -1;  /* DL_PowerBalancing_ActivationIndicator */
static int hf_nbap_rL_Set_ID = -1;                /* RL_Set_ID */
static int hf_nbap_e_DCH_RL_Set_ID = -1;          /* RL_Set_ID */
static int hf_nbap_e_DCH_FDD_DL_Control_Channel_Information = -1;  /* E_DCH_FDD_DL_Control_Channel_Information */
static int hf_nbap_Additional_EDCH_Cell_Information_Response_RLReconf_List_item = -1;  /* Additional_EDCH_FDD_Information_Response_RLReconf_Items */
static int hf_nbap_additional_EDCH_FDD_Information_Response_ItemIEs = -1;  /* Additional_EDCH_FDD_Information_Response_ItemIEs */
static int hf_nbap_additional_Modififed_EDCH_FDD_Information_Response_ItemIEs = -1;  /* Additional_Modififed_EDCH_FDD_Information_Response_ItemIEs */
static int hf_nbap_eDCH_Additional_Modified_RL_Specific_Information_Response = -1;  /* EDCH_Additional_Modified_RL_Specific_Information_Response_List */
static int hf_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List_item = -1;  /* EDCH_Additional_Modified_RL_Specific_Information_Response_List_Items */
static int hf_nbap_dL_PowerBalancing_UpdatedIndicator = -1;  /* DL_PowerBalancing_UpdatedIndicator */
static int hf_nbap_Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List_item = -1;  /* Additional_EDCH_MAC_d_Flows_Specific_Info_Response */
static int hf_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_List_item = -1;  /* Additional_EDCH_Cell_Information_Response_RL_Add_ItemIEs */
static int hf_nbap_additional_EDCH_FDD_Information_Response = -1;  /* Additional_EDCH_FDD_Information_Response_ItemIEs */
static int hf_nbap_additional_EDCH_Serving_Cell_Change_Information_Response = -1;  /* E_DCH_Serving_Cell_Change_Info_Response */
static int hf_nbap_Additional_EDCH_Cell_Information_ConfigurationChange_List_item = -1;  /* Additional_EDCH_ConfigurationChange_Info_ItemIEs */
static int hf_nbap_additional_EDCH_UL_DPCH_Information_Modify = -1;  /* Additional_EDCH_UL_DPCH_Information_Modify */
static int hf_nbap_additional_EDCH_RL_Specific_Information_To_Add = -1;  /* Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs */
static int hf_nbap_additional_EDCH_RL_Specific_Information_To_Modify = -1;  /* Additional_EDCH_RL_Specific_Information_To_Modify_List */
static int hf_nbap_additional_EDCH_FDD_Information_To_Modify = -1;  /* Additional_EDCH_FDD_Information */
static int hf_nbap_additional_EDCH_F_DPCH_Information_Modify = -1;  /* Additional_EDCH_F_DPCH_Information */
static int hf_nbap_Additional_EDCH_Cell_Information_Removal_List_item = -1;  /* Additional_EDCH_Cell_Information_Removal_Info_ItemIEs */
static int hf_nbap_rL_on_Secondary_UL_Frequency = -1;  /* RL_on_Secondary_UL_Frequency */
static int hf_nbap_additional_EDCH_DL_Control_Channel_Change_Information = -1;  /* Additional_EDCH_DL_Control_Channel_Change_Information_List */
static int hf_nbap_Additional_EDCH_DL_Control_Channel_Change_Information_List_item = -1;  /* Additional_EDCH_DL_Control_Channel_Change_Info_ItemIEs */
static int hf_nbap_AdditionalMeasurementValueList_item = -1;  /* AdditionalMeasurementValue */
static int hf_nbap_uARFCN = -1;                   /* UARFCN */
static int hf_nbap_timeSlotMeasurementValueListLCR = -1;  /* TimeSlotMeasurementValueListLCR */
static int hf_nbap_AdditionalTimeSlotListLCR_item = -1;  /* AdditionalTimeSlotLCR */
static int hf_nbap_timeslot_InitiatedListLCR = -1;  /* TimeSlot_InitiatedListLCR */
static int hf_nbap_cMConfigurationChangeCFN = -1;  /* CFN */
static int hf_nbap_transmission_Gap_Pattern_Sequence_Status = -1;  /* Transmission_Gap_Pattern_Sequence_Status_List */
static int hf_nbap_Transmission_Gap_Pattern_Sequence_Status_List_item = -1;  /* Transmission_Gap_Pattern_Sequence_Status_List_item */
static int hf_nbap_tGPSID = -1;                   /* TGPSID */
static int hf_nbap_tGPRC = -1;                    /* TGPRC */
static int hf_nbap_tGCFN = -1;                    /* CFN */
static int hf_nbap_priorityLevel = -1;            /* PriorityLevel */
static int hf_nbap_pre_emptionCapability = -1;    /* Pre_emptionCapability */
static int hf_nbap_pre_emptionVulnerability = -1;  /* Pre_emptionVulnerability */
static int hf_nbap_aOA_LCR = -1;                  /* AOA_LCR */
static int hf_nbap_aOA_LCR_Accuracy_Class = -1;   /* AOA_LCR_Accuracy_Class */
static int hf_nbap_bCCH_Specific_HSDSCH_RNTI = -1;  /* HSDSCH_RNTI */
static int hf_nbap_hSSCCH_Power = -1;             /* DL_Power */
static int hf_nbap_hSPDSCH_Power = -1;            /* DL_Power */
static int hf_nbap_Best_Cell_Portions_Value_item = -1;  /* Best_Cell_Portions_Item */
static int hf_nbap_cellPortionID = -1;            /* CellPortionID */
static int hf_nbap_sIRValue = -1;                 /* SIR_Value */
static int hf_nbap_Best_Cell_Portions_ValueLCR_item = -1;  /* Best_Cell_Portions_ItemLCR */
static int hf_nbap_cellPortionLCRID = -1;         /* CellPortionLCRID */
static int hf_nbap_rSCPValue = -1;                /* RSCP_Value */
static int hf_nbap_commonTransportChannelID = -1;  /* CommonTransportChannelID */
static int hf_nbap_cid = -1;                      /* C_ID */
static int hf_nbap_radioNetwork = -1;             /* CauseRadioNetwork */
static int hf_nbap_transport = -1;                /* CauseTransport */
static int hf_nbap_protocol = -1;                 /* CauseProtocol */
static int hf_nbap_misc = -1;                     /* CauseMisc */
static int hf_nbap_Cell_ERNTI_Status_Information_item = -1;  /* Cell_ERNTI_Status_Information_Item */
static int hf_nbap_vacant_ERNTI = -1;             /* Vacant_ERNTI */
static int hf_nbap_Vacant_ERNTI_item = -1;        /* E_RNTI */
static int hf_nbap_initialPhase_0_1048575 = -1;   /* INTEGER_0_1048575_ */
static int hf_nbap_steadyStatePhase = -1;         /* INTEGER_0_255_ */
static int hf_nbap_initialPhase = -1;             /* INTEGER_0_524287_ */
static int hf_nbap_steadyStatePhase_01 = -1;      /* INTEGER_0_127_ */
static int hf_nbap_CommonChannelsCapacityConsumptionLaw_item = -1;  /* CommonChannelsCapacityConsumptionLaw_item */
static int hf_nbap_dl_Cost = -1;                  /* INTEGER_0_65535 */
static int hf_nbap_ul_Cost = -1;                  /* INTEGER_0_65535 */
static int hf_nbap_common_E_DCH_UL_DPCH_Information = -1;  /* Common_E_DCH_UL_DPCH_InfoItem */
static int hf_nbap_common_E_DCH_EDPCH_Information = -1;  /* Common_E_DCH_EDPCH_InfoItem */
static int hf_nbap_common_E_DCH_Information = -1;  /* Common_E_DCH_InfoItem */
static int hf_nbap_common_E_DCH_HSDPCCH_Information = -1;  /* Common_E_DCH_HSDPCCH_InfoItem */
static int hf_nbap_common_E_DCH_Preamble_Control_Information = -1;  /* Common_E_DCH_Preamble_Control_InfoItem */
static int hf_nbap_common_E_DCH_FDPCH_Information = -1;  /* Common_E_DCH_FDPCH_InfoItem */
static int hf_nbap_common_E_DCH_E_AGCH_ChannelisationCodeNumber = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_common_E_DCH_Resource_Combination_Information = -1;  /* Common_E_DCH_Resource_Combination_InfoList */
static int hf_nbap_ul_common_E_DCH_MACflow_Specific_Information = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoList */
static int hf_nbap_uL_SIR_Target = -1;            /* UL_SIR */
static int hf_nbap_dPC_Mode = -1;                 /* DPC_Mode */
static int hf_nbap_maxSet_E_DPDCHs = -1;          /* Max_Set_E_DPDCHs */
static int hf_nbap_ul_PunctureLimit = -1;         /* PunctureLimit */
static int hf_nbap_e_TFCS_Information = -1;       /* E_TFCS_Information */
static int hf_nbap_e_TTI = -1;                    /* E_TTI */
static int hf_nbap_e_DPCCH_PO = -1;               /* E_DPCCH_PO */
static int hf_nbap_e_RGCH_2_IndexStepThreshold = -1;  /* E_RGCH_2_IndexStepThreshold */
static int hf_nbap_e_RGCH_3_IndexStepThreshold = -1;  /* E_RGCH_3_IndexStepThreshold */
static int hf_nbap_hARQ_Info_for_E_DCH = -1;      /* HARQ_Info_for_E_DCH */
static int hf_nbap_e_DCH_Reference_Power_Offset = -1;  /* E_DCH_Reference_Power_Offset */
static int hf_nbap_e_DCH_PowerOffset_for_SchedulingInfo = -1;  /* E_DCH_PowerOffset_for_SchedulingInfo */
static int hf_nbap_max_EDCH_Resource_Allocation_for_CCCH = -1;  /* Max_EDCH_Resource_Allocation_for_CCCH */
static int hf_nbap_max_Period_for_Collistion_Resolution = -1;  /* Max_Period_for_Collistion_Resolution */
static int hf_nbap_max_TB_Sizes = -1;             /* Max_TB_Sizes */
static int hf_nbap_common_E_DCH_ImplicitRelease_Indicator = -1;  /* BOOLEAN */
static int hf_nbap_ackNackRepetitionFactor = -1;  /* AckNack_RepetitionFactor */
static int hf_nbap_ackPowerOffset = -1;           /* Ack_Power_Offset */
static int hf_nbap_nackPowerOffset = -1;          /* Nack_Power_Offset */
static int hf_nbap_common_E_DCH_CQI_Info = -1;    /* Common_E_DCH_CQI_Info */
static int hf_nbap_cqiFeedback_CycleK = -1;       /* CQI_Feedback_Cycle */
static int hf_nbap_cqiRepetitionFactor = -1;      /* CQI_RepetitionFactor */
static int hf_nbap_cqiPowerOffset = -1;           /* CQI_Power_Offset */
static int hf_nbap_measurement_Power_Offset = -1;  /* Measurement_Power_Offset */
static int hf_nbap_commonPhysicalChannelID = -1;  /* CommonPhysicalChannelID */
static int hf_nbap_common_E_DCH_PreambleSignatures = -1;  /* PreambleSignatures */
static int hf_nbap_scramblingCodeNumber = -1;     /* ScramblingCodeNumber */
static int hf_nbap_preambleThreshold = -1;        /* PreambleThreshold */
static int hf_nbap_e_AI_Indicator = -1;           /* E_AI_Indicator */
static int hf_nbap_common_E_DCH_AICH_Information = -1;  /* Common_E_DCH_AICH_Information */
static int hf_nbap_aICH_TransmissionTiming = -1;  /* AICH_TransmissionTiming */
static int hf_nbap_fdd_dl_ChannelisationCodeNumber = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_aICH_Power = -1;               /* AICH_Power */
static int hf_nbap_sTTD_Indicator = -1;           /* STTD_Indicator */
static int hf_nbap_Common_E_DCH_Resource_Combination_InfoList_item = -1;  /* Common_E_DCH_Resource_Combination_InfoList_Item */
static int hf_nbap_soffset = -1;                  /* Soffset */
static int hf_nbap_f_DPCH_DL_Code_Number = -1;    /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_ul_DPCH_ScramblingCode = -1;   /* UL_ScramblingCode */
static int hf_nbap_e_RGCH_E_HICH_Channelisation_Code = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_e_RGCH_Signature_Sequence = -1;  /* E_RGCH_Signature_Sequence */
static int hf_nbap_e_HICH_Signature_Sequence = -1;  /* E_HICH_Signature_Sequence */
static int hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_item = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoList_Item */
static int hf_nbap_ul_Common_MACFlowID = -1;      /* Common_MACFlow_ID */
static int hf_nbap_transportBearerRequestIndicator = -1;  /* TransportBearerRequestIndicator */
static int hf_nbap_tnlQos = -1;                   /* TnlQos */
static int hf_nbap_payloadCRC_PresenceIndicator = -1;  /* PayloadCRC_PresenceIndicator */
static int hf_nbap_bundlingModeIndicator = -1;    /* BundlingModeIndicator */
static int hf_nbap_common_E_DCH_MACdFlow_Specific_Information = -1;  /* Common_E_DCH_MACdFlow_Specific_InfoList */
static int hf_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_item = -1;  /* Common_E_DCH_MACdFlow_Specific_InfoList_Item */
static int hf_nbap_common_e_DCH_MACdFlow_ID = -1;  /* E_DCH_MACdFlow_ID */
static int hf_nbap_maximum_Number_of_Retransmissions_For_E_DCH = -1;  /* Maximum_Number_of_Retransmissions_For_E_DCH */
static int hf_nbap_eDCH_HARQ_PO_FDD = -1;         /* E_DCH_HARQ_PO_FDD */
static int hf_nbap_eDCH_MACdFlow_Multiplexing_List = -1;  /* E_DCH_MACdFlow_Multiplexing_List */
static int hf_nbap_common_E_DCHLogicalChannelInformation = -1;  /* Common_E_DCH_LogicalChannel_InfoList */
static int hf_nbap_Common_E_DCH_LogicalChannel_InfoList_item = -1;  /* Common_E_DCH_LogicalChannel_InfoList_Item */
static int hf_nbap_logicalChannelId = -1;         /* LogicalChannelID */
static int hf_nbap_maximumMACcPDU_SizeExtended = -1;  /* MAC_PDU_SizeExtended */
static int hf_nbap_ul_common_E_DCH_MACflow_Specific_InfoResponse = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoResponseList */
static int hf_nbap_serving_Grant_Value = -1;      /* E_Serving_Grant_Value */
static int hf_nbap_E_RNTI_List_item = -1;         /* E_RNTI */
static int hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_item = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoResponseList_Item */
static int hf_nbap_Common_MACFlows_to_DeleteFDD_item = -1;  /* Common_MACFlows_to_DeleteFDD_Item */
static int hf_nbap_common_MACFlow_ID = -1;        /* Common_MACFlow_ID */
static int hf_nbap_CommonMACFlow_Specific_InfoList_item = -1;  /* CommonMACFlow_Specific_InfoItem */
static int hf_nbap_common_MACFlow_Id = -1;        /* Common_MACFlow_ID */
static int hf_nbap_tnl_qos = -1;                  /* TnlQos */
static int hf_nbap_common_MACFlow_PriorityQueue_Information = -1;  /* Common_MACFlow_PriorityQueue_Information */
static int hf_nbap_CommonMACFlow_Specific_InfoList_Response_item = -1;  /* CommonMACFlow_Specific_InfoItem_Response */
static int hf_nbap_commonMACFlow_ID = -1;         /* Common_MACFlow_ID */
static int hf_nbap_hSDSCH_Initial_Capacity_Allocation = -1;  /* HSDSCH_Initial_Capacity_Allocation */
static int hf_nbap_Common_MACFlow_PriorityQueue_Information_item = -1;  /* Common_MACFlow_PriorityQueue_Item */
static int hf_nbap_priority_Queue_Information_for_Enhanced_FACH = -1;  /* Priority_Queue_Information_for_Enhanced_FACH_PCH */
static int hf_nbap_tUTRANGPSMeasurementAccuracyClass = -1;  /* TUTRANGPSAccuracyClass */
static int hf_nbap_tUTRANGANSSMeasurementAccuracyClass = -1;  /* TUTRANGANSSAccuracyClass */
static int hf_nbap_transmitted_carrier_power = -1;  /* Transmitted_Carrier_Power_Value */
static int hf_nbap_acknowledged_prach_preambles = -1;  /* Acknowledged_PRACH_preambles_Value */
static int hf_nbap_uL_TimeslotISCP = -1;          /* UL_TimeslotISCP_Value */
static int hf_nbap_notUsed_1_acknowledged_PCPCH_access_preambles = -1;  /* NULL */
static int hf_nbap_notUsed_2_detected_PCPCH_access_preambles = -1;  /* NULL */
static int hf_nbap_extension_CommonMeasurementValue = -1;  /* Extension_CommonMeasurementValue */
static int hf_nbap_measurementAvailable = -1;     /* CommonMeasurementAvailable */
static int hf_nbap_measurementnotAvailable = -1;  /* CommonMeasurementnotAvailable */
static int hf_nbap_commonmeasurementValue = -1;   /* CommonMeasurementValue */
static int hf_nbap_ie_Extensions = -1;            /* ProtocolExtensionContainer */
static int hf_nbap_resourceOperationalState = -1;  /* ResourceOperationalState */
static int hf_nbap_availabilityStatus = -1;       /* AvailabilityStatus */
static int hf_nbap_commonPhysicalChannelID768 = -1;  /* CommonPhysicalChannelID768 */
static int hf_nbap_uE_DTX_DRX_Offset = -1;        /* UE_DTX_DRX_Offset */
static int hf_nbap_enabling_Delay = -1;           /* Enabling_Delay */
static int hf_nbap_dTX_Information = -1;          /* DTX_Information */
static int hf_nbap_dRX_Information = -1;          /* DRX_Information */
static int hf_nbap_dTX_Information_to_Modify = -1;  /* DTX_Information_to_Modify */
static int hf_nbap_dRX_Information_to_Modify = -1;  /* DRX_Information_to_Modify */
static int hf_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information_item = -1;  /* ContinuousPacketConnectivityHS_SCCH_less_InformationItem */
static int hf_nbap_transport_Block_Size_Index = -1;  /* Transport_Block_Size_Index */
static int hf_nbap_hSPDSCH_Second_Code_Support = -1;  /* HSPDSCH_Second_Code_Support */
static int hf_nbap_hSPDSCH_First_Code_Index = -1;  /* HSPDSCH_First_Code_Index */
static int hf_nbap_hSPDSCH_Second_Code_Index = -1;  /* HSPDSCH_Second_Code_Index */
static int hf_nbap_continuousPacketConnectivityDTX_DRX_Information = -1;  /* ContinuousPacketConnectivityDTX_DRX_Information */
static int hf_nbap_continuousPacketConnectivityDTX_DRX_Information_to_Modify = -1;  /* ContinuousPacketConnectivityDTX_DRX_Information_to_Modify */
static int hf_nbap_continuousPacketConnectivityHS_SCCH_less_Information = -1;  /* ContinuousPacketConnectivityHS_SCCH_less_Information */
static int hf_nbap_procedureID = -1;              /* ProcedureID */
static int hf_nbap_triggeringMessage = -1;        /* TriggeringMessage */
static int hf_nbap_procedureCriticality = -1;     /* Criticality */
static int hf_nbap_transactionID = -1;            /* TransactionID */
static int hf_nbap_iEsCriticalityDiagnostics = -1;  /* CriticalityDiagnostics_IE_List */
static int hf_nbap_CriticalityDiagnostics_IE_List_item = -1;  /* CriticalityDiagnostics_IE_List_item */
static int hf_nbap_iECriticality = -1;            /* Criticality */
static int hf_nbap_iE_ID = -1;                    /* ProtocolIE_ID */
static int hf_nbap_repetitionNumber = -1;         /* RepetitionNumber0 */
static int hf_nbap_ul_common_E_DCH_MACflow_Specific_InformationLCR = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoListLCR */
static int hf_nbap_common_E_PUCH_InformationLCR = -1;  /* Common_E_PUCH_InformationLCR */
static int hf_nbap_e_TFCS_Information_TDD = -1;   /* E_TFCS_Information_TDD */
static int hf_nbap_maximum_Number_of_Retransmissions_For_SchedulingInfo = -1;  /* Maximum_Number_of_Retransmissions_For_E_DCH */
static int hf_nbap_eDCH_Retransmission_Timer_SchedulingInfo = -1;  /* E_DCH_MACdFlow_Retransmission_Timer */
static int hf_nbap_minCR = -1;                    /* CodeRate */
static int hf_nbap_maxCR = -1;                    /* CodeRate */
static int hf_nbap_harqInfo = -1;                 /* HARQ_Info_for_E_DCH */
static int hf_nbap_pRXdes_base_perURAFCN = -1;    /* PRXdes_base_perURAFCN */
static int hf_nbap_e_PUCH_TPC_StepSize = -1;      /* TDD_TPC_UplinkStepSize_LCR */
static int hf_nbap_e_AGCH_TPC_StepSize = -1;      /* TDD_TPC_DownlinkStepSize */
static int hf_nbap_e_PUCH_PowerControlGAP = -1;   /* ControlGAP */
static int hf_nbap_PRXdes_base_perURAFCN_item = -1;  /* PRXdes_base_Item */
static int hf_nbap_pRXdes_base = -1;              /* PRXdes_base */
static int hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoListLCR_item = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoList_ItemLCR */
static int hf_nbap_ul_Common_MACFlowIDLCR = -1;   /* Common_MACFlow_ID_LCR */
static int hf_nbap_common_E_DCH_MACdFlow_Specific_InformationLCR = -1;  /* Common_E_DCH_MACdFlow_Specific_InfoListLCR */
static int hf_nbap_Common_E_DCH_MACdFlow_Specific_InfoListLCR_item = -1;  /* Common_E_DCH_MACdFlow_Specific_InfoList_ItemLCR */
static int hf_nbap_common_e_DCH_MACdFlow_ID_01 = -1;  /* E_DCH_MACdFlow_ID_LCR */
static int hf_nbap_eDCH_HARQ_PO_TDD = -1;         /* E_DCH_HARQ_PO_TDD */
static int hf_nbap_eDCH_MACdFlow_Retransmission_Timer = -1;  /* E_DCH_MACdFlow_Retransmission_Timer */
static int hf_nbap_ul_common_E_DCH_MACflow_Specific_InfoResponseLCR = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR */
static int hf_nbap_common_E_AGCH_ListLCR = -1;    /* Common_E_AGCH_ListLCR */
static int hf_nbap_common_E_HICH_ListLCR = -1;    /* Common_E_HICH_ListLCR */
static int hf_nbap_common_E_RNTI_Info_LCR = -1;   /* Common_E_RNTI_Info_LCR */
static int hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_item = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR */
static int hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext_item = -1;  /* Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR */
static int hf_nbap_ul_Common_MACFlowID_LCR = -1;  /* Common_MACFlow_ID_LCR */
static int hf_nbap_Common_E_AGCH_ListLCR_item = -1;  /* Common_E_AGCH_ItemLCR */
static int hf_nbap_e_AGCH_ID = -1;                /* E_AGCH_Id */
static int hf_nbap_Common_E_HICH_ListLCR_item = -1;  /* Common_E_HICH_ItemLCR */
static int hf_nbap_eI = -1;                       /* EI */
static int hf_nbap_e_HICH_ID = -1;                /* E_HICH_ID_LCR */
static int hf_nbap_Common_E_RNTI_Info_LCR_item = -1;  /* Common_E_RNTI_Info_ItemLCR */
static int hf_nbap_starting_E_RNTI = -1;          /* E_RNTI */
static int hf_nbap_number_of_Group = -1;          /* INTEGER_1_32 */
static int hf_nbap_number_of_e_E_RNTI_perGroup = -1;  /* INTEGER_1_7 */
static int hf_nbap_Common_MACFlows_to_DeleteLCR_item = -1;  /* Common_MACFlows_to_DeleteLCR_Item */
static int hf_nbap_common_MACFlow_ID_LCR = -1;    /* Common_MACFlow_ID_LCR */
static int hf_nbap_CommonMACFlow_Specific_InfoListLCR_item = -1;  /* CommonMACFlow_Specific_InfoItemLCR */
static int hf_nbap_common_MACFlow_PriorityQueue_InformationLCR = -1;  /* Common_MACFlow_PriorityQueue_Information */
static int hf_nbap_Common_H_RNTI_InformationLCR_item = -1;  /* Common_H_RNTI_InfoItemLCR */
static int hf_nbap_common_H_RNTI = -1;            /* HSDSCH_RNTI */
static int hf_nbap_t_SYNC = -1;                   /* T_SYNC */
static int hf_nbap_t_PROTECT = -1;                /* T_PROTECT */
static int hf_nbap_n_PROTECT = -1;                /* N_PROTECT */
static int hf_nbap_CommonMACFlow_Specific_InfoList_ResponseLCR_item = -1;  /* CommonMACFlow_Specific_InfoItem_ResponseLCR */
static int hf_nbap_continuousPacketConnectivity_DRX_InformationLCR = -1;  /* ContinuousPacketConnectivity_DRX_InformationLCR */
static int hf_nbap_continuousPacketConnectivity_DRX_Information_to_Modify_LCR = -1;  /* ContinuousPacketConnectivity_DRX_Information_to_Modify_LCR */
static int hf_nbap_hS_DSCH_Semi_PersistentScheduling_Information_LCR = -1;  /* HS_DSCH_Semi_PersistentScheduling_Information_LCR */
static int hf_nbap_hS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR = -1;  /* HS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR */
static int hf_nbap_hS_DSCH_SPS_Deactivate_Indicator_LCR = -1;  /* NULL */
static int hf_nbap_e_DCH_Semi_PersistentScheduling_Information_LCR = -1;  /* E_DCH_Semi_PersistentScheduling_Information_LCR */
static int hf_nbap_e_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR = -1;  /* E_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR */
static int hf_nbap_e_DCH_SPS_Deactivate_Indicator_LCR = -1;  /* NULL */
static int hf_nbap_hS_SCCH_DRX_Information_LCR = -1;  /* HS_SCCH_DRX_Information_LCR */
static int hf_nbap_e_AGCH_DRX_Information_LCR = -1;  /* E_AGCH_DRX_Information_LCR */
static int hf_nbap_hS_SCCH_UE_DRX_Cycle_LCR = -1;  /* UE_DRX_Cycle_LCR */
static int hf_nbap_hS_SCCH_Inactivity_Threshold_for_UE_DRX_Cycle_LCR = -1;  /* Inactivity_Threshold_for_UE_DRX_Cycle_LCR */
static int hf_nbap_hS_SCCH_UE_DRX_Offset_LCR = -1;  /* UE_DRX_Offset_LCR */
static int hf_nbap_sameAsHS_SCCH = -1;            /* NULL */
static int hf_nbap_e_AGCH_DRX_Parameters = -1;    /* E_AGCH_DRX_Parameters */
static int hf_nbap_e_AGCH_UE_DRX_Cycle_LCR = -1;  /* UE_DRX_Cycle_LCR */
static int hf_nbap_e_AGCH_UE_Inactivity_Monitor_Threshold = -1;  /* E_AGCH_UE_Inactivity_Monitor_Threshold */
static int hf_nbap_e_AGCH_UE_DRX_Offset_LCR = -1;  /* UE_DRX_Offset_LCR */
static int hf_nbap_dRX_Information_to_Modify_LCR = -1;  /* DRX_Information_to_Modify_LCR */
static int hf_nbap_modify = -1;                   /* DRX_Information_to_Modify_Items_LCR */
static int hf_nbap_deactivate = -1;               /* NULL */
static int hf_nbap_hS_SCCH_DRX_Information_ResponseLCR = -1;  /* HS_SCCH_DRX_Information_ResponseLCR */
static int hf_nbap_e_AGCH_DRX_Information_ResponseLCR = -1;  /* E_AGCH_DRX_Information_ResponseLCR */
static int hf_nbap_e_AGCH_DRX_Parameters_Response = -1;  /* E_AGCH_DRX_Parameters_Response */
static int hf_nbap_DCH_FDD_Information_item = -1;  /* DCH_FDD_InformationItem */
static int hf_nbap_ul_FP_Mode = -1;               /* UL_FP_Mode */
static int hf_nbap_toAWS = -1;                    /* ToAWS */
static int hf_nbap_toAWE = -1;                    /* ToAWE */
static int hf_nbap_dCH_SpecificInformationList = -1;  /* DCH_Specific_FDD_InformationList */
static int hf_nbap_DCH_Specific_FDD_InformationList_item = -1;  /* DCH_Specific_FDD_Item */
static int hf_nbap_dCH_ID = -1;                   /* T_dCH_ID */
static int hf_nbap_ul_TransportFormatSet = -1;    /* T_ul_TransportFormatSet */
static int hf_nbap_dl_TransportFormatSet = -1;    /* T_dl_TransportFormatSet */
static int hf_nbap_allocationRetentionPriority = -1;  /* AllocationRetentionPriority */
static int hf_nbap_frameHandlingPriority = -1;    /* FrameHandlingPriority */
static int hf_nbap_qE_Selector = -1;              /* QE_Selector */
static int hf_nbap_DCH_InformationResponse_item = -1;  /* DCH_InformationResponseItem */
static int hf_nbap_dCH_ID_01 = -1;                /* DCH_ID */
static int hf_nbap_DCH_MeasurementOccasion_Information_item = -1;  /* DchMeasurementOccasionInformation_Item */
static int hf_nbap_pattern_Sequence_Identifier = -1;  /* Pattern_Sequence_Identifier */
static int hf_nbap_status_Flag = -1;              /* Status_Flag */
static int hf_nbap_measurement_Occasion_Pattern_Sequence_parameters = -1;  /* Measurement_Occasion_Pattern_Sequence_parameters */
static int hf_nbap_measurement_Occasion_Pattern_Sequence_parameters_k = -1;  /* INTEGER_1_9 */
static int hf_nbap_measurement_Occasion_Pattern_Sequence_parameters_offset = -1;  /* INTEGER_0_511 */
static int hf_nbap_measurement_Occasion_Pattern_Sequence_parameters_M_Length = -1;  /* INTEGER_1_512 */
static int hf_nbap_measurement_Occasion_Pattern_Sequence_parameters_Timeslot_Bitmap = -1;  /* BIT_STRING_SIZE_7 */
static int hf_nbap_DCH_TDD_Information_item = -1;  /* DCH_TDD_InformationItem */
static int hf_nbap_dCH_SpecificInformationList_01 = -1;  /* DCH_Specific_TDD_InformationList */
static int hf_nbap_DCH_Specific_TDD_InformationList_item = -1;  /* DCH_Specific_TDD_Item */
static int hf_nbap_ul_CCTrCH_ID = -1;             /* CCTrCH_ID */
static int hf_nbap_dl_CCTrCH_ID = -1;             /* CCTrCH_ID */
static int hf_nbap_ul_TransportFormatSet_01 = -1;  /* TransportFormatSet */
static int hf_nbap_dl_TransportFormatSet_01 = -1;  /* TransportFormatSet */
static int hf_nbap_FDD_DCHs_to_Modify_item = -1;  /* FDD_DCHs_to_ModifyItem */
static int hf_nbap_dCH_SpecificInformationList_02 = -1;  /* DCH_ModifySpecificInformation_FDD */
static int hf_nbap_DCH_ModifySpecificInformation_FDD_item = -1;  /* DCH_ModifySpecificItem_FDD */
static int hf_nbap_dCH_ID_02 = -1;                /* T_dCH_ID_01 */
static int hf_nbap_ul_TransportFormatSet_02 = -1;  /* T_ul_TransportFormatSet_01 */
static int hf_nbap_dl_TransportFormatSet_02 = -1;  /* T_dl_TransportFormatSet_01 */
static int hf_nbap_TDD_DCHs_to_Modify_item = -1;  /* DCH_ModifyItem_TDD */
static int hf_nbap_dCH_SpecificInformationList_03 = -1;  /* DCH_ModifySpecificInformation_TDD */
static int hf_nbap_DCH_ModifySpecificInformation_TDD_item = -1;  /* DCH_ModifySpecificItem_TDD */
static int hf_nbap_DedicatedChannelsCapacityConsumptionLaw_item = -1;  /* DedicatedChannelsCapacityConsumptionLaw_item */
static int hf_nbap_dl_Cost_1 = -1;                /* INTEGER_0_65535 */
static int hf_nbap_dl_Cost_2 = -1;                /* INTEGER_0_65535 */
static int hf_nbap_ul_Cost_1 = -1;                /* INTEGER_0_65535 */
static int hf_nbap_ul_Cost_2 = -1;                /* INTEGER_0_65535 */
static int hf_nbap_sIR_Value = -1;                /* SIR_Value */
static int hf_nbap_sIR_ErrorValue = -1;           /* SIR_Error_Value */
static int hf_nbap_transmittedCodePowerValue = -1;  /* Transmitted_Code_Power_Value */
static int hf_nbap_rSCP = -1;                     /* RSCP_Value */
static int hf_nbap_rxTimingDeviationValue = -1;   /* Rx_Timing_Deviation_Value */
static int hf_nbap_roundTripTime = -1;            /* Round_Trip_Time_Value */
static int hf_nbap_extension_DedicatedMeasurementValue = -1;  /* Extension_DedicatedMeasurementValue */
static int hf_nbap_measurementAvailable_01 = -1;  /* DedicatedMeasurementAvailable */
static int hf_nbap_measurementnotAvailable_01 = -1;  /* DedicatedMeasurementnotAvailable */
static int hf_nbap_dedicatedmeasurementValue = -1;  /* DedicatedMeasurementValue */
static int hf_nbap_cFN = -1;                      /* CFN */
static int hf_nbap_cfn = -1;                      /* CFN */
static int hf_nbap_separate_indication = -1;      /* NULL */
static int hf_nbap_activate = -1;                 /* Activate_Info */
static int hf_nbap_deactivate_01 = -1;            /* Deactivate_Info */
static int hf_nbap_activation_type = -1;          /* Execution_Type */
static int hf_nbap_initial_dl_tx_power = -1;      /* DL_Power */
static int hf_nbap_firstRLS_Indicator = -1;       /* FirstRLS_Indicator */
static int hf_nbap_propagation_delay = -1;        /* PropagationDelay */
static int hf_nbap_deactivation_type = -1;        /* Execution_Type */
static int hf_nbap_synchronised = -1;             /* CFN */
static int hf_nbap_unsynchronised = -1;           /* NULL */
static int hf_nbap_dGANSS_ReferenceTime = -1;     /* INTEGER_0_119 */
static int hf_nbap_dGANSS_Information = -1;       /* DGANSS_Information */
static int hf_nbap_dGANSS_Signal_ID = -1;         /* BIT_STRING_SIZE_8 */
static int hf_nbap_DGANSS_Information_item = -1;  /* DGANSS_InformationItem */
static int hf_nbap_gANSS_SignalId = -1;           /* GANSS_Signal_ID */
static int hf_nbap_gANSS_StatusHealth = -1;       /* GANSS_StatusHealth */
static int hf_nbap_dGANSS_SignalInformation = -1;  /* DGANSS_SignalInformation */
static int hf_nbap_DGANSS_SignalInformation_item = -1;  /* DGANSS_SignalInformationItem */
static int hf_nbap_satId = -1;                    /* INTEGER_0_63 */
static int hf_nbap_gANSS_iod = -1;                /* BIT_STRING_SIZE_10 */
static int hf_nbap_udre = -1;                     /* UDRE */
static int hf_nbap_ganss_prc = -1;                /* INTEGER_M2047_2047 */
static int hf_nbap_ganss_rrc = -1;                /* INTEGER_M127_127 */
static int hf_nbap_pRCDeviation = -1;             /* PRCDeviation */
static int hf_nbap_udreGrowthRate = -1;           /* UDREGrowthRate */
static int hf_nbap_udreValidityTime = -1;         /* UDREValidityTime */
static int hf_nbap_gpstow = -1;                   /* GPSTOW */
static int hf_nbap_status_health = -1;            /* GPS_Status_Health */
static int hf_nbap_satelliteinfo = -1;            /* SAT_Info_DGPSCorrections */
static int hf_nbap_prcdeviation = -1;             /* PRCDeviation */
static int hf_nbap_DL_Timeslot_Information_item = -1;  /* DL_Timeslot_InformationItem */
static int hf_nbap_timeSlot = -1;                 /* TimeSlot */
static int hf_nbap_midambleShiftAndBurstType = -1;  /* MidambleShiftAndBurstType */
static int hf_nbap_tFCI_Presence = -1;            /* TFCI_Presence */
static int hf_nbap_dL_Code_Information = -1;      /* TDD_DL_Code_Information */
static int hf_nbap_DL_TimeslotLCR_Information_item = -1;  /* DL_TimeslotLCR_InformationItem */
static int hf_nbap_timeSlotLCR = -1;              /* TimeSlotLCR */
static int hf_nbap_midambleShiftLCR = -1;         /* MidambleShiftLCR */
static int hf_nbap_dL_Code_LCR_Information = -1;  /* TDD_DL_Code_LCR_Information */
static int hf_nbap_DL_Timeslot768_Information_item = -1;  /* DL_Timeslot768_InformationItem */
static int hf_nbap_midambleShiftAndBurstType768 = -1;  /* MidambleShiftAndBurstType768 */
static int hf_nbap_dL_Code_768_Information = -1;  /* TDD_DL_Code_768_Information */
static int hf_nbap_powerAdjustmentType = -1;      /* PowerAdjustmentType */
static int hf_nbap_dLReferencePower = -1;         /* DL_Power */
static int hf_nbap_dLReferencePowerList_DL_PC_Rqst = -1;  /* DL_ReferencePowerInformationList */
static int hf_nbap_maxAdjustmentStep = -1;        /* MaxAdjustmentStep */
static int hf_nbap_adjustmentPeriod = -1;         /* AdjustmentPeriod */
static int hf_nbap_adjustmentRatio = -1;          /* ScaledAdjustmentRatio */
static int hf_nbap_DL_ReferencePowerInformationList_item = -1;  /* DL_ReferencePowerInformationItem */
static int hf_nbap_rL_ID = -1;                    /* RL_ID */
static int hf_nbap_dl_Reference_Power = -1;       /* DL_Power */
static int hf_nbap_DL_TimeslotISCPInfo_item = -1;  /* DL_TimeslotISCPInfoItem */
static int hf_nbap_dL_TimeslotISCP = -1;          /* DL_TimeslotISCP */
static int hf_nbap_DL_TimeslotISCPInfoLCR_item = -1;  /* DL_TimeslotISCPInfoItemLCR */
static int hf_nbap_DL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst_item = -1;  /* DL_HS_PDSCH_Timeslot_InformationItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_midambleShiftAndBurstType_01 = -1;  /* MidambleShiftLCR */
static int hf_nbap_dl_HS_PDSCH_Codelist_LCR_PSCH_ReconfRqst = -1;  /* DL_HS_PDSCH_Codelist_LCR_PSCH_ReconfRqst */
static int hf_nbap_maxHSDSCH_HSSCCH_Power = -1;   /* MaximumTransmissionPower */
static int hf_nbap_MaxHSDSCH_HSSCCH_Power_per_CELLPORTION_item = -1;  /* MaxHSDSCH_HSSCCH_Power_per_CELLPORTION_Item */
static int hf_nbap_DL_HS_PDSCH_Codelist_LCR_PSCH_ReconfRqst_item = -1;  /* TDD_ChannelisationCode */
static int hf_nbap_uE_DRX_Cycle = -1;             /* UE_DRX_Cycle */
static int hf_nbap_inactivity_Threshold_for_UE_DRX_Cycle = -1;  /* Inactivity_Threshold_for_UE_DRX_Cycle */
static int hf_nbap_inactivity_Threshold_for_UE_Grant_Monitoring = -1;  /* Inactivity_Threshold_for_UE_Grant_Monitoring */
static int hf_nbap_uE_DRX_Grant_Monitoring = -1;  /* UE_DRX_Grant_Monitoring */
static int hf_nbap_modify_01 = -1;                /* DRX_Information_to_Modify_Items */
static int hf_nbap_DSCH_InformationResponse_item = -1;  /* DSCH_InformationResponseItem */
static int hf_nbap_dSCH_ID = -1;                  /* DSCH_ID */
static int hf_nbap_DSCH_TDD_Information_item = -1;  /* DSCH_TDD_InformationItem */
static int hf_nbap_cCTrCH_ID = -1;                /* CCTrCH_ID */
static int hf_nbap_transportFormatSet = -1;       /* TransportFormatSet */
static int hf_nbap_uE_DTX_Cycle1_2ms = -1;        /* UE_DTX_Cycle1_2ms */
static int hf_nbap_uE_DTX_Cycle2_2ms = -1;        /* UE_DTX_Cycle2_2ms */
static int hf_nbap_mAC_DTX_Cycle_2ms = -1;        /* MAC_DTX_Cycle_2ms */
static int hf_nbap_uE_DTX_Cycle1_10ms = -1;       /* UE_DTX_Cycle1_10ms */
static int hf_nbap_uE_DTX_Cycle2_10ms = -1;       /* UE_DTX_Cycle2_10ms */
static int hf_nbap_mAC_DTX_Cycle_10ms = -1;       /* MAC_DTX_Cycle_10ms */
static int hf_nbap_e_DCH_TTI_Length = -1;         /* E_DCH_TTI_Length */
static int hf_nbap_inactivity_Threshold_for_UE_DTX_Cycle2 = -1;  /* Inactivity_Threshold_for_UE_DTX_Cycle2 */
static int hf_nbap_uE_DTX_Long_Preamble = -1;     /* UE_DTX_Long_Preamble */
static int hf_nbap_mAC_Inactivity_Threshold = -1;  /* MAC_Inactivity_Threshold */
static int hf_nbap_cQI_DTX_Timer = -1;            /* CQI_DTX_Timer */
static int hf_nbap_uE_DPCCH_burst1 = -1;          /* UE_DPCCH_burst1 */
static int hf_nbap_uE_DPCCH_burst2 = -1;          /* UE_DPCCH_burst2 */
static int hf_nbap_modify_02 = -1;                /* DTX_Information_to_Modify_Items */
static int hf_nbap_e_DCH_TTI_Length_to_Modify = -1;  /* E_DCH_TTI_Length_to_Modify */
static int hf_nbap_dual_Band_Capability = -1;     /* Dual_Band_Capability */
static int hf_nbap_possible_Secondary_Serving_Cell_List = -1;  /* Possible_Secondary_Serving_Cell_List */
static int hf_nbap_replace = -1;                  /* E_AGCH_FDD_Code_List */
static int hf_nbap_remove = -1;                   /* NULL */
static int hf_nbap_E_AGCH_FDD_Code_List_item = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_e_DCH_SF_allocation = -1;      /* E_DCH_SF_allocation */
static int hf_nbap_E_DCH_SF_allocation_item = -1;  /* E_DCH_SF_allocation_item */
static int hf_nbap_e_AGCH_And_E_RGCH_E_HICH_FDD_Scrambling_Code = -1;  /* DL_ScramblingCode */
static int hf_nbap_e_AGCH_Channelisation_Code = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_primary_e_RNTI = -1;           /* E_RNTI */
static int hf_nbap_secondary_e_RNTI = -1;         /* E_RNTI */
static int hf_nbap_primary_Secondary_Grant_Selector = -1;  /* E_Primary_Secondary_Grant_Selector */
static int hf_nbap_e_RGCH_Release_Indicator = -1;  /* E_RGCH_Release_Indicator */
static int hf_nbap_e_DCH_MACdFlows_Information = -1;  /* E_DCH_MACdFlows_Information */
static int hf_nbap_e_DCH_MACdFlow_Specific_InformationResp = -1;  /* E_DCH_MACdFlow_Specific_InformationResp */
static int hf_nbap_e_DCH_MACdFlow_Specific_Info_to_Modify = -1;  /* E_DCH_MACdFlow_Specific_InfoList_to_Modify */
static int hf_nbap_mACeReset_Indicator = -1;      /* MACeReset_Indicator */
static int hf_nbap_e_DCH_MACdFlow_Specific_UpdateInformation = -1;  /* E_DCH_MACdFlow_Specific_UpdateInformation */
static int hf_nbap_E_DCH_MACdFlow_Specific_UpdateInformation_item = -1;  /* E_DCH_MACdFlow_Specific_UpdateInformation_Item */
static int hf_nbap_hARQ_Process_Allocation_NonSched_2ms_EDCH = -1;  /* HARQ_Process_Allocation_2ms_EDCH */
static int hf_nbap_E_DCH_DL_Control_Channel_Change_Information_item = -1;  /* E_DCH_DL_Control_Channel_Change_Information_Item */
static int hf_nbap_e_DCH_RL_ID = -1;              /* RL_ID */
static int hf_nbap_E_DCH_DL_Control_Channel_Grant_Information_item = -1;  /* E_DCH_DL_Control_Channel_Grant_Information_Item */
static int hf_nbap_e_DCH_Non_Scheduled_Transmission_Grant = -1;  /* E_DCH_Non_Scheduled_Transmission_Grant_Items */
static int hf_nbap_e_DCH_Scheduled_Transmission_Grant = -1;  /* NULL */
static int hf_nbap_E_DCH_LogicalChannelInformation_item = -1;  /* E_DCH_LogicalChannelInformationItem */
static int hf_nbap_schedulingPriorityIndicator = -1;  /* SchedulingPriorityIndicator */
static int hf_nbap_schedulingInformation = -1;    /* SchedulingInformation */
static int hf_nbap_mACesGuaranteedBitRate = -1;   /* MACesGuaranteedBitRate */
static int hf_nbap_e_DCH_DDI_Value = -1;          /* E_DCH_DDI_Value */
static int hf_nbap_mACd_PDU_Size_List = -1;       /* E_DCH_MACdPDU_SizeList */
static int hf_nbap_E_DCH_MACdPDU_SizeList_item = -1;  /* E_DCH_MACdPDU_SizeListItem */
static int hf_nbap_mACdPDU_Size = -1;             /* MACdPDU_Size */
static int hf_nbap_E_DCH_LogicalChannelToModify_item = -1;  /* E_DCH_LogicalChannelToModifyItem */
static int hf_nbap_mACd_PDU_Size_List_01 = -1;    /* E_DCH_MACdPDU_SizeToModifyList */
static int hf_nbap_E_DCH_MACdPDU_SizeToModifyList_item = -1;  /* E_DCH_MACdPDU_SizeListItem */
static int hf_nbap_E_DCH_LogicalChannelToDelete_item = -1;  /* E_DCH_LogicalChannelToDeleteItem */
static int hf_nbap_e_DCH_MACdFlow_Specific_Info = -1;  /* E_DCH_MACdFlow_Specific_InfoList */
static int hf_nbap_E_DCH_MACdFlow_Specific_InfoList_item = -1;  /* E_DCH_MACdFlow_Specific_InfoItem */
static int hf_nbap_eDCH_Grant_Type_Information = -1;  /* E_DCH_Grant_Type_Information */
static int hf_nbap_eDCHLogicalChannelInformation = -1;  /* E_DCH_LogicalChannelInformation */
static int hf_nbap_E_DCH_MACdFlow_Specific_InformationResp_item = -1;  /* E_DCH_MACdFlow_Specific_InformationResp_Item */
static int hf_nbap_E_DCH_MACdFlow_Specific_InfoList_to_Modify_item = -1;  /* E_DCH_MACdFlow_Specific_InfoItem_to_Modify */
static int hf_nbap_eDCH_LogicalChannelToAdd = -1;  /* E_DCH_LogicalChannelInformation */
static int hf_nbap_eDCH_LogicalChannelToModify = -1;  /* E_DCH_LogicalChannelToModify */
static int hf_nbap_eDCH_LogicalChannelToDelete = -1;  /* E_DCH_LogicalChannelToDelete */
static int hf_nbap_E_DCH_MACdFlows_to_Delete_item = -1;  /* E_DCH_MACdFlow_to_Delete_Item */
static int hf_nbap_maxBits_MACe_PDU_non_scheduled = -1;  /* Max_Bits_MACe_PDU_non_scheduled */
static int hf_nbap_hARQ_Process_Allocation_NonSched_2ms = -1;  /* HARQ_Process_Allocation_2ms_EDCH */
static int hf_nbap_e_DCH_serving_cell_choice = -1;  /* E_DCH_serving_cell_choice */
static int hf_nbap_e_DCH_serving_cell_change_successful = -1;  /* E_DCH_serving_cell_change_successful */
static int hf_nbap_e_DCH_serving_cell_change_unsuccessful = -1;  /* E_DCH_serving_cell_change_unsuccessful */
static int hf_nbap_e_DCH_RL_InformationList_Rsp = -1;  /* E_DCH_RL_InformationList_Rsp */
static int hf_nbap_E_DCH_RL_InformationList_Rsp_item = -1;  /* E_DCH_RL_InformationList_Rsp_Item */
static int hf_nbap_rl_ID = -1;                    /* RL_ID */
static int hf_nbap_e_DCH_FDD_DL_Control_Channel_Info = -1;  /* E_DCH_FDD_DL_Control_Channel_Information */
static int hf_nbap_cause = -1;                    /* Cause */
static int hf_nbap_EDCH_RACH_Report_Value_item = -1;  /* EDCH_RACH_Report_Value_item */
static int hf_nbap_granted_EDCH_RACH_resources = -1;  /* Granted_EDCH_RACH_Resources_Value */
static int hf_nbap_denied_EDCH_RACH_resources = -1;  /* Denied_EDCH_RACH_Resources_Value */
static int hf_nbap_two_ms = -1;                   /* DTX_Cycle_2ms_Items */
static int hf_nbap_ten_ms = -1;                   /* DTX_Cycle_10ms_Items */
static int hf_nbap_two_ms_01 = -1;                /* DTX_Cycle_2ms_to_Modify_Items */
static int hf_nbap_ten_ms_01 = -1;                /* DTX_Cycle_10ms_to_Modify_Items */
static int hf_nbap_E_DCH_MACdFlows_to_DeleteLCR_item = -1;  /* E_DCH_MACdFlow_to_Delete_ItemLCR */
static int hf_nbap_e_DCH_MACdFlow_ID_LCR = -1;    /* E_DCH_MACdFlow_ID_LCR */
static int hf_nbap_t321 = -1;                     /* T321 */
static int hf_nbap_hS_DSCH_DRX_Cycle_FACH = -1;   /* HS_DSCH_DRX_Cycle_FACH */
static int hf_nbap_hS_DSCH_RX_Burst_FACH = -1;    /* HS_DSCH_RX_Burst_FACH */
static int hf_nbap_replace_01 = -1;               /* E_RGCH_E_HICH_FDD_Code_List */
static int hf_nbap_E_RGCH_E_HICH_FDD_Code_List_item = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_e_TFCI_BetaEC_Boost = -1;      /* E_TFCI_BetaEC_Boost */
static int hf_nbap_uL_Delta_T2TP = -1;            /* UL_Delta_T2TP */
static int hf_nbap_e_DCH_TFCI_Table_Index = -1;   /* E_DCH_TFCI_Table_Index */
static int hf_nbap_reference_E_TFCI_Information = -1;  /* Reference_E_TFCI_Information */
static int hf_nbap_E_DCHProvidedBitRate_item = -1;  /* E_DCHProvidedBitRate_Item */
static int hf_nbap_e_DCHProvidedBitRateValue = -1;  /* E_DCHProvidedBitRateValue */
static int hf_nbap_E_DCHProvidedBitRateValueInformation_For_CellPortion_item = -1;  /* E_DCHProvidedBitRateValueInformation_For_CellPortion_Item */
static int hf_nbap_e_DCHProvidedBitRateValue_01 = -1;  /* E_DCHProvidedBitRate */
static int hf_nbap_e_PUCH_Information = -1;       /* E_PUCH_Information */
static int hf_nbap_e_DCH_MACdFlows_Information_TDD = -1;  /* E_DCH_MACdFlows_Information_TDD */
static int hf_nbap_e_DCH_Non_Scheduled_Grant_Info = -1;  /* E_DCH_Non_Scheduled_Grant_Info */
static int hf_nbap_e_DCH_TDD_Information = -1;    /* E_DCH_TDD_Information */
static int hf_nbap_n_E_UCCH = -1;                 /* N_E_UCCH */
static int hf_nbap_e_DCH_QPSK_RefBetaInfo = -1;   /* E_DCH_QPSK_RefBetaInfo */
static int hf_nbap_e_DCH_sixteenQAM_RefBetaInfo = -1;  /* E_DCH_sixteenQAM_RefBetaInfo */
static int hf_nbap_E_DCH_QPSK_RefBetaInfo_item = -1;  /* E_DCH_RefBeta_Item */
static int hf_nbap_E_DCH_sixteenQAM_RefBetaInfo_item = -1;  /* E_DCH_RefBeta_Item */
static int hf_nbap_refCodeRate = -1;              /* CodeRate_short */
static int hf_nbap_refBeta = -1;                  /* RefBeta */
static int hf_nbap_E_DCH_MACdFlows_Information_TDD_item = -1;  /* E_DCH_MACdFlow_InfoTDDItem */
static int hf_nbap_eDCH_Grant_TypeTDD = -1;       /* E_DCH_Grant_TypeTDD */
static int hf_nbap_timeslotResource = -1;         /* E_DCH_TimeslotResource */
static int hf_nbap_powerResource = -1;            /* E_DCH_PowerResource */
static int hf_nbap_repetitionPeriod = -1;         /* RepetitionPeriod */
static int hf_nbap_repetitionLength = -1;         /* RepetitionLength */
static int hf_nbap_tddE_PUCH_Offset = -1;         /* TddE_PUCH_Offset */
static int hf_nbap_tdd_ChannelisationCode = -1;   /* TDD_ChannelisationCode */
static int hf_nbap_e_DCH_TDD_Maximum_Bitrate = -1;  /* E_DCH_TDD_Maximum_Bitrate */
static int hf_nbap_e_DCH_TDD_MACdFlow_Specific_InformationResp = -1;  /* E_DCH_TDD_MACdFlow_Specific_InformationResp */
static int hf_nbap_e_AGCH_Specific_Information_ResponseTDD = -1;  /* E_AGCH_Specific_InformationRespListTDD */
static int hf_nbap_scheduled_E_HICH_Specific_InformationResp = -1;  /* Scheduled_E_HICH_Specific_Information_ResponseLCRTDD */
static int hf_nbap_Scheduled_E_HICH_Specific_Information_ResponseLCRTDD_item = -1;  /* Scheduled_E_HICH_Specific_InformationItem_ResponseLCRTDD */
static int hf_nbap_e_HICH_ID_TDD = -1;            /* E_HICH_ID_TDD */
static int hf_nbap_E_DCH_TDD_MACdFlow_Specific_InformationResp_item = -1;  /* E_DCH_TDD_MACdFlow_Specific_InformationResp_Item */
static int hf_nbap_e_DCH_MacdFlow_Id = -1;        /* E_DCH_MACdFlow_ID */
static int hf_nbap_E_AGCH_Specific_InformationRespListTDD_item = -1;  /* E_AGCH_Specific_InformationResp_ItemTDD */
static int hf_nbap_e_AGCH_Id = -1;                /* E_AGCH_Id */
static int hf_nbap_e_DCH_MACdFlows_to_Add = -1;   /* E_DCH_MACdFlows_Information_TDD */
static int hf_nbap_e_DCH_MACdFlows_to_Delete = -1;  /* E_DCH_MACdFlows_to_Delete */
static int hf_nbap_e_DCH_TDD_Information_to_Modify = -1;  /* E_DCH_TDD_Information_to_Modify */
static int hf_nbap_e_DCH_TDD_Information_to_Modify_List = -1;  /* E_DCH_TDD_Information_to_Modify_List */
static int hf_nbap_E_DCH_TDD_Information_to_Modify_List_item = -1;  /* E_DCH_MACdFlow_ModifyTDDItem */
static int hf_nbap_e_DCH_LogicalChannelToAdd = -1;  /* E_DCH_LogicalChannelInformation */
static int hf_nbap_e_DCH_LogicalChannelToModify = -1;  /* E_DCH_LogicalChannelToModify */
static int hf_nbap_e_DCH_LogicalChannelToDelete = -1;  /* E_DCH_LogicalChannelToDelete */
static int hf_nbap_e_DCH_Non_Scheduled_Grant_Info768 = -1;  /* E_DCH_Non_Scheduled_Grant_Info768 */
static int hf_nbap_e_DCH_TDD_Information768 = -1;  /* E_DCH_TDD_Information768 */
static int hf_nbap_tdd_ChannelisationCode768 = -1;  /* TDD_ChannelisationCode768 */
static int hf_nbap_e_DCH_TDD_Maximum_Bitrate768 = -1;  /* E_DCH_TDD_Maximum_Bitrate768 */
static int hf_nbap_e_PUCH_LCR_Information = -1;   /* E_PUCH_LCR_Information */
static int hf_nbap_e_DCH_Non_Scheduled_Grant_LCR_Info = -1;  /* E_DCH_Non_Scheduled_Grant_LCR_Info */
static int hf_nbap_e_DCH_LCRTDD_Information = -1;  /* E_DCH_LCRTDD_Information */
static int hf_nbap_timeslotResourceLCR = -1;      /* E_DCH_TimeslotResourceLCR */
static int hf_nbap_subframeNumber = -1;           /* T_subframeNumber */
static int hf_nbap_n_E_UCCHLCR = -1;              /* N_E_UCCHLCR */
static int hf_nbap_e_HICH_LCR_Information = -1;   /* E_HICH_LCR_Information */
static int hf_nbap_signatureSequenceGroupIndex = -1;  /* SignatureSequenceGroupIndex */
static int hf_nbap_e_DCH_LCRTDD_PhysicalLayerCategory = -1;  /* E_DCH_LCRTDD_PhysicalLayerCategory */
static int hf_nbap_dRX_Interruption_by_HS_DSCH = -1;  /* DRX_Interruption_by_HS_DSCH */
static int hf_nbap_repetition_Period_List_LCR = -1;  /* Repetition_Period_List_LCR */
static int hf_nbap_e_DCH_SPS_Indicator = -1;      /* E_DCH_SPS_Indicator */
static int hf_nbap_sPS_E_DCH_releted_E_HICH_Information = -1;  /* E_HICH_LCR_Information */
static int hf_nbap_timeslot_Resource_Related_Information = -1;  /* E_DCH_TimeslotResourceLCR */
static int hf_nbap_subframeNumber_01 = -1;        /* T_subframeNumber_01 */
static int hf_nbap_FDD_DL_CodeInformation_item = -1;  /* FDD_DL_CodeInformationItem */
static int hf_nbap_dl_ScramblingCode = -1;        /* DL_ScramblingCode */
static int hf_nbap_fdd_DL_ChannelisationCodeNumber = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_transmissionGapPatternSequenceCodeInformation = -1;  /* TransmissionGapPatternSequenceCodeInformation */
static int hf_nbap_navClockModel = -1;            /* GANSS_NAVclockModel */
static int hf_nbap_cnavClockModel = -1;           /* GANSS_CNAVclockModel */
static int hf_nbap_glonassClockModel = -1;        /* GANSS_GLONASSclockModel */
static int hf_nbap_sbasClockModel = -1;           /* GANSS_SBASclockModel */
static int hf_nbap_navKeplerianSet = -1;          /* GANSS_NavModel_NAVKeplerianSet */
static int hf_nbap_cnavKeplerianSet = -1;         /* GANSS_NavModel_CNAVKeplerianSet */
static int hf_nbap_glonassECEF = -1;              /* GANSS_NavModel_GLONASSecef */
static int hf_nbap_sbasECEF = -1;                 /* GANSS_NavModel_SBASecef */
static int hf_nbap_dataID = -1;                   /* BIT_STRING_SIZE_2 */
static int hf_nbap_alpha_beta_parameters = -1;    /* GPS_Ionospheric_Model */
static int hf_nbap_ganss_Transmission_Time = -1;  /* GANSS_Transmission_Time */
static int hf_nbap_non_broadcastIndication = -1;  /* T_non_broadcastIndication */
static int hf_nbap_ganssSatInfoNavList = -1;      /* Ganss_Sat_Info_AddNavList */
static int hf_nbap_GANSS_Additional_Time_Models_item = -1;  /* GANSS_Time_Model */
static int hf_nbap_utcModel1 = -1;                /* GANSS_UTCmodelSet1 */
static int hf_nbap_utcModel2 = -1;                /* GANSS_UTCmodelSet2 */
static int hf_nbap_utcModel3 = -1;                /* GANSS_UTCmodelSet3 */
static int hf_nbap_ganss_wk_number = -1;          /* INTEGER_0_255 */
static int hf_nbap_gANSS_AlmanacModel = -1;       /* GANSS_AlmanacModel */
static int hf_nbap_gANSS_keplerianParameters = -1;  /* GANSS_KeplerianParametersAlm */
static int hf_nbap_extension_GANSS_AlmanacModel = -1;  /* Extension_GANSS_AlmanacModel */
static int hf_nbap_sat_info_SBASecefList = -1;    /* GANSS_SAT_Info_Almanac_SBASecefList */
static int hf_nbap_sat_info_GLOkpList = -1;       /* GANSS_SAT_Info_Almanac_GLOkpList */
static int hf_nbap_t_oa = -1;                     /* INTEGER_0_255 */
static int hf_nbap_sat_info_MIDIkpList = -1;      /* GANSS_SAT_Info_Almanac_MIDIkpList */
static int hf_nbap_sat_info_NAVkpList = -1;       /* GANSS_SAT_Info_Almanac_NAVkpList */
static int hf_nbap_sat_info_REDkpList = -1;       /* GANSS_SAT_Info_Almanac_REDkpList */
static int hf_nbap_ganssID1 = -1;                 /* GANSS_AuxInfoGANSS_ID1 */
static int hf_nbap_ganssID3 = -1;                 /* GANSS_AuxInfoGANSS_ID3 */
static int hf_nbap_GANSS_AuxInfoGANSS_ID1_item = -1;  /* GANSS_AuxInfoGANSS_ID1_element */
static int hf_nbap_svID = -1;                     /* INTEGER_0_63 */
static int hf_nbap_signalsAvailable = -1;         /* BIT_STRING_SIZE_8 */
static int hf_nbap_GANSS_AuxInfoGANSS_ID3_item = -1;  /* GANSS_AuxInfoGANSS_ID3_element */
static int hf_nbap_channelNumber = -1;            /* INTEGER_M7_13 */
static int hf_nbap_GANSS_Clock_Model_item = -1;   /* GANSS_SatelliteClockModelItem */
static int hf_nbap_cnavToc = -1;                  /* BIT_STRING_SIZE_11 */
static int hf_nbap_cnavTop = -1;                  /* BIT_STRING_SIZE_11 */
static int hf_nbap_cnavURA0 = -1;                 /* BIT_STRING_SIZE_5 */
static int hf_nbap_cnavURA1 = -1;                 /* BIT_STRING_SIZE_3 */
static int hf_nbap_cnavURA2 = -1;                 /* BIT_STRING_SIZE_3 */
static int hf_nbap_cnavAf2 = -1;                  /* BIT_STRING_SIZE_10 */
static int hf_nbap_cnavAf1 = -1;                  /* BIT_STRING_SIZE_20 */
static int hf_nbap_cnavAf0 = -1;                  /* BIT_STRING_SIZE_26 */
static int hf_nbap_cnavTgd = -1;                  /* BIT_STRING_SIZE_13 */
static int hf_nbap_cnavISCl1cp = -1;              /* BIT_STRING_SIZE_13 */
static int hf_nbap_cnavISCl1cd = -1;              /* BIT_STRING_SIZE_13 */
static int hf_nbap_cnavISCl1ca = -1;              /* BIT_STRING_SIZE_13 */
static int hf_nbap_cnavISCl2c = -1;               /* BIT_STRING_SIZE_13 */
static int hf_nbap_cnavISCl5i5 = -1;              /* BIT_STRING_SIZE_13 */
static int hf_nbap_cnavISCl5q5 = -1;              /* BIT_STRING_SIZE_13 */
static int hf_nbap_ganss_Ionospheric_Model = -1;  /* GANSS_Ionospheric_Model */
static int hf_nbap_ganss_Rx_Pos = -1;             /* GANSS_RX_Pos */
static int hf_nbap_ionospheric_Model = -1;        /* BOOLEAN */
static int hf_nbap_ganssTod = -1;                 /* INTEGER_0_59_ */
static int hf_nbap_dataBitAssistancelist = -1;    /* GANSS_DataBitAssistanceList */
static int hf_nbap_GANSS_DataBitAssistanceList_item = -1;  /* GANSS_DataBitAssistanceItem */
static int hf_nbap_dataBitAssistanceSgnList = -1;  /* GANSS_DataBitAssistanceSgnList */
static int hf_nbap_GANSS_DataBitAssistanceSgnList_item = -1;  /* GANSS_DataBitAssistanceSgnItem */
static int hf_nbap_ganss_SignalId = -1;           /* GANSS_Signal_ID */
static int hf_nbap_ganssDataBits = -1;            /* BIT_STRING_SIZE_1_1024 */
static int hf_nbap_ganssTod_01 = -1;              /* INTEGER_0_86399 */
static int hf_nbap_ganss_Data_Bit_Assistance_ReqList = -1;  /* GANSS_Data_Bit_Assistance_ReqList */
static int hf_nbap_ganss_DataBitInterval = -1;    /* INTEGER_0_15 */
static int hf_nbap_ganss_SatelliteInfo = -1;      /* T_ganss_SatelliteInfo */
static int hf_nbap_ganss_SatelliteInfo_item = -1;  /* INTEGER_0_63 */
static int hf_nbap_b1 = -1;                       /* BIT_STRING_SIZE_11 */
static int hf_nbap_b2 = -1;                       /* BIT_STRING_SIZE_10 */
static int hf_nbap_teop = -1;                     /* BIT_STRING_SIZE_16 */
static int hf_nbap_pmX = -1;                      /* BIT_STRING_SIZE_21 */
static int hf_nbap_pmXdot = -1;                   /* BIT_STRING_SIZE_15 */
static int hf_nbap_pmY = -1;                      /* BIT_STRING_SIZE_21 */
static int hf_nbap_pmYdot = -1;                   /* BIT_STRING_SIZE_15 */
static int hf_nbap_deltaUT1 = -1;                 /* BIT_STRING_SIZE_31 */
static int hf_nbap_deltaUT1dot = -1;              /* BIT_STRING_SIZE_19 */
static int hf_nbap_GANSS_GenericDataInfoReqList_item = -1;  /* GANSS_GenericDataInfoReqItem */
static int hf_nbap_ganss_Id = -1;                 /* GANSS_ID */
static int hf_nbap_ganss_Navigation_Model_And_Time_Recovery = -1;  /* BOOLEAN */
static int hf_nbap_ganss_Time_Model_GNSS_GNSS = -1;  /* BIT_STRING_SIZE_9 */
static int hf_nbap_ganss_UTC_Model = -1;          /* BOOLEAN */
static int hf_nbap_ganss_Almanac = -1;            /* BOOLEAN */
static int hf_nbap_ganss_Real_Time_Integrity = -1;  /* BOOLEAN */
static int hf_nbap_ganss_Data_Bit_Assistance_Req = -1;  /* GANSS_Data_Bit_Assistance_ReqItem */
static int hf_nbap_GANSS_Generic_Data_item = -1;  /* GANSS_Generic_DataItem */
static int hf_nbap_dganss_Correction = -1;        /* DGANSSCorrections */
static int hf_nbap_ganss_Navigation_Model_And_Time_Recovery_01 = -1;  /* GANSS_Navigation_Model_And_Time_Recovery */
static int hf_nbap_ganss_Time_Model = -1;         /* GANSS_Time_Model */
static int hf_nbap_ganss_UTC_TIME = -1;           /* GANSS_UTC_Model */
static int hf_nbap_ganss_Almanac_01 = -1;         /* GANSS_Almanac */
static int hf_nbap_ganss_Real_Time_Integrity_01 = -1;  /* GANSS_Real_Time_Integrity */
static int hf_nbap_ganss_Data_Bit_Assistance = -1;  /* GANSS_Data_Bit_Assistance */
static int hf_nbap_gloTau = -1;                   /* BIT_STRING_SIZE_22 */
static int hf_nbap_gloGamma = -1;                 /* BIT_STRING_SIZE_11 */
static int hf_nbap_gloDeltaTau = -1;              /* BIT_STRING_SIZE_5 */
static int hf_nbap_gANSS_CommonDataInfoReq = -1;  /* GANSS_CommonDataInfoReq */
static int hf_nbap_gANSS_GenericDataInfoReqList = -1;  /* GANSS_GenericDataInfoReqList */
static int hf_nbap_alpha_zero_ionos = -1;         /* BIT_STRING_SIZE_12 */
static int hf_nbap_alpha_one_ionos = -1;          /* BIT_STRING_SIZE_12 */
static int hf_nbap_alpha_two_ionos = -1;          /* BIT_STRING_SIZE_12 */
static int hf_nbap_gANSS_IonosphereRegionalStormFlags = -1;  /* GANSS_IonosphereRegionalStormFlags */
static int hf_nbap_storm_flag_one = -1;           /* BOOLEAN */
static int hf_nbap_storm_flag_two = -1;           /* BOOLEAN */
static int hf_nbap_storm_flag_three = -1;         /* BOOLEAN */
static int hf_nbap_storm_flag_four = -1;          /* BOOLEAN */
static int hf_nbap_storm_flag_five = -1;          /* BOOLEAN */
static int hf_nbap_iod_a = -1;                    /* INTEGER_0_3 */
static int hf_nbap_gANSS_SatelliteInformationKP = -1;  /* GANSS_SatelliteInformationKP */
static int hf_nbap_toe_nav = -1;                  /* BIT_STRING_SIZE_14 */
static int hf_nbap_ganss_omega_nav = -1;          /* BIT_STRING_SIZE_32 */
static int hf_nbap_delta_n_nav = -1;              /* BIT_STRING_SIZE_16 */
static int hf_nbap_m_zero_nav = -1;               /* BIT_STRING_SIZE_32 */
static int hf_nbap_omegadot_nav = -1;             /* BIT_STRING_SIZE_24 */
static int hf_nbap_ganss_e_nav = -1;              /* BIT_STRING_SIZE_32 */
static int hf_nbap_idot_nav = -1;                 /* BIT_STRING_SIZE_14 */
static int hf_nbap_a_sqrt_nav = -1;               /* BIT_STRING_SIZE_32 */
static int hf_nbap_i_zero_nav = -1;               /* BIT_STRING_SIZE_32 */
static int hf_nbap_omega_zero_nav = -1;           /* BIT_STRING_SIZE_32 */
static int hf_nbap_c_rs_nav = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_nbap_c_is_nav = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_nbap_c_us_nav = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_nbap_c_rc_nav = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_nbap_c_ic_nav = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_nbap_c_uc_nav = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_nbap_navToc = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_navaf2 = -1;                   /* BIT_STRING_SIZE_8 */
static int hf_nbap_navaf1 = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_navaf0 = -1;                   /* BIT_STRING_SIZE_22 */
static int hf_nbap_navTgd = -1;                   /* BIT_STRING_SIZE_8 */
static int hf_nbap_non_broadcastIndication_01 = -1;  /* T_non_broadcastIndication_01 */
static int hf_nbap_ganssSatInfoNav = -1;          /* GANSS_Sat_Info_Nav */
static int hf_nbap_cnavURAindex = -1;             /* BIT_STRING_SIZE_5 */
static int hf_nbap_cnavDeltaA = -1;               /* BIT_STRING_SIZE_26 */
static int hf_nbap_cnavAdot = -1;                 /* BIT_STRING_SIZE_25 */
static int hf_nbap_cnavDeltaNo = -1;              /* BIT_STRING_SIZE_17 */
static int hf_nbap_cnavDeltaNoDot = -1;           /* BIT_STRING_SIZE_23 */
static int hf_nbap_cnavMo = -1;                   /* BIT_STRING_SIZE_33 */
static int hf_nbap_cnavE = -1;                    /* BIT_STRING_SIZE_33 */
static int hf_nbap_cnavOmega = -1;                /* BIT_STRING_SIZE_33 */
static int hf_nbap_cnavOMEGA0 = -1;               /* BIT_STRING_SIZE_33 */
static int hf_nbap_cnavDeltaOmegaDot = -1;        /* BIT_STRING_SIZE_17 */
static int hf_nbap_cnavIo = -1;                   /* BIT_STRING_SIZE_33 */
static int hf_nbap_cnavIoDot = -1;                /* BIT_STRING_SIZE_15 */
static int hf_nbap_cnavCis = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_nbap_cnavCic = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_nbap_cnavCrs = -1;                  /* BIT_STRING_SIZE_24 */
static int hf_nbap_cnavCrc = -1;                  /* BIT_STRING_SIZE_24 */
static int hf_nbap_cnavCus = -1;                  /* BIT_STRING_SIZE_21 */
static int hf_nbap_cnavCuc = -1;                  /* BIT_STRING_SIZE_21 */
static int hf_nbap_gloEn = -1;                    /* BIT_STRING_SIZE_5 */
static int hf_nbap_gloP1 = -1;                    /* BIT_STRING_SIZE_2 */
static int hf_nbap_gloP2 = -1;                    /* BIT_STRING_SIZE_1 */
static int hf_nbap_gloM = -1;                     /* BIT_STRING_SIZE_2 */
static int hf_nbap_gloX = -1;                     /* BIT_STRING_SIZE_27 */
static int hf_nbap_gloXdot = -1;                  /* BIT_STRING_SIZE_24 */
static int hf_nbap_gloXdotdot = -1;               /* BIT_STRING_SIZE_5 */
static int hf_nbap_gloY = -1;                     /* BIT_STRING_SIZE_27 */
static int hf_nbap_gloYdot = -1;                  /* BIT_STRING_SIZE_24 */
static int hf_nbap_gloYdotdot = -1;               /* BIT_STRING_SIZE_5 */
static int hf_nbap_gloZ = -1;                     /* BIT_STRING_SIZE_27 */
static int hf_nbap_gloZdot = -1;                  /* BIT_STRING_SIZE_24 */
static int hf_nbap_gloZdotdot = -1;               /* BIT_STRING_SIZE_5 */
static int hf_nbap_navURA = -1;                   /* BIT_STRING_SIZE_4 */
static int hf_nbap_navFitFlag = -1;               /* BIT_STRING_SIZE_1 */
static int hf_nbap_navToe = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_navOmega = -1;                 /* BIT_STRING_SIZE_32 */
static int hf_nbap_navDeltaN = -1;                /* BIT_STRING_SIZE_16 */
static int hf_nbap_navM0 = -1;                    /* BIT_STRING_SIZE_32 */
static int hf_nbap_navOmegaADot = -1;             /* BIT_STRING_SIZE_24 */
static int hf_nbap_navE = -1;                     /* BIT_STRING_SIZE_32 */
static int hf_nbap_navIDot = -1;                  /* BIT_STRING_SIZE_14 */
static int hf_nbap_navAPowerHalf = -1;            /* BIT_STRING_SIZE_32 */
static int hf_nbap_navI0 = -1;                    /* BIT_STRING_SIZE_32 */
static int hf_nbap_navOmegaA0 = -1;               /* BIT_STRING_SIZE_32 */
static int hf_nbap_navCrs = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_navCis = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_navCus = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_navCrc = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_navCic = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_navCuc = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_sbasTo = -1;                   /* BIT_STRING_SIZE_13 */
static int hf_nbap_sbasAccuracy = -1;             /* BIT_STRING_SIZE_4 */
static int hf_nbap_sbasXg = -1;                   /* BIT_STRING_SIZE_30 */
static int hf_nbap_sbasYg = -1;                   /* BIT_STRING_SIZE_30 */
static int hf_nbap_sbasZg = -1;                   /* BIT_STRING_SIZE_25 */
static int hf_nbap_sbasXgDot = -1;                /* BIT_STRING_SIZE_17 */
static int hf_nbap_sbasYgDot = -1;                /* BIT_STRING_SIZE_17 */
static int hf_nbap_sbasZgDot = -1;                /* BIT_STRING_SIZE_18 */
static int hf_nbap_sbasXgDotDot = -1;             /* BIT_STRING_SIZE_10 */
static int hf_nbap_sbagYgDotDot = -1;             /* BIT_STRING_SIZE_10 */
static int hf_nbap_sbasZgDotDot = -1;             /* BIT_STRING_SIZE_10 */
static int hf_nbap_gANSS_keplerianParameters_01 = -1;  /* GANSS_KeplerianParametersOrb */
static int hf_nbap_GANSS_Real_Time_Integrity_item = -1;  /* GANSS_RealTimeInformationItem */
static int hf_nbap_bad_ganss_satId = -1;          /* INTEGER_0_63 */
static int hf_nbap_bad_ganss_signalId = -1;       /* BIT_STRING_SIZE_8 */
static int hf_nbap_latitudeSign = -1;             /* T_latitudeSign */
static int hf_nbap_degreesOfLatitude = -1;        /* INTEGER_0_2147483647 */
static int hf_nbap_degreesOfLongitude = -1;       /* INTEGER_M2147483648_2147483647 */
static int hf_nbap_directionOfAltitude = -1;      /* T_directionOfAltitude */
static int hf_nbap_altitude = -1;                 /* INTEGER_0_32767 */
static int hf_nbap_t_oc = -1;                     /* BIT_STRING_SIZE_14 */
static int hf_nbap_a_i2 = -1;                     /* BIT_STRING_SIZE_12 */
static int hf_nbap_a_i1 = -1;                     /* BIT_STRING_SIZE_18 */
static int hf_nbap_a_i0 = -1;                     /* BIT_STRING_SIZE_28 */
static int hf_nbap_t_gd = -1;                     /* BIT_STRING_SIZE_10 */
static int hf_nbap_model_id = -1;                 /* INTEGER_0_1_ */
static int hf_nbap_GANSS_SatelliteInformationKP_item = -1;  /* GANSS_SatelliteInformationKPItem */
static int hf_nbap_ganss_e_alm = -1;              /* BIT_STRING_SIZE_11 */
static int hf_nbap_ganss_delta_I_alm = -1;        /* BIT_STRING_SIZE_11 */
static int hf_nbap_ganss_omegadot_alm = -1;       /* BIT_STRING_SIZE_11 */
static int hf_nbap_ganss_svhealth_alm = -1;       /* BIT_STRING_SIZE_4 */
static int hf_nbap_ganss_delta_a_sqrt_alm = -1;   /* BIT_STRING_SIZE_17 */
static int hf_nbap_ganss_omegazero_alm = -1;      /* BIT_STRING_SIZE_16 */
static int hf_nbap_ganss_m_zero_alm = -1;         /* BIT_STRING_SIZE_16 */
static int hf_nbap_ganss_omega_alm = -1;          /* BIT_STRING_SIZE_16 */
static int hf_nbap_ganss_af_zero_alm = -1;        /* BIT_STRING_SIZE_14 */
static int hf_nbap_ganss_af_one_alm = -1;         /* BIT_STRING_SIZE_11 */
static int hf_nbap_Ganss_Sat_Info_AddNavList_item = -1;  /* Ganss_Sat_Info_AddNavList_item */
static int hf_nbap_svHealth = -1;                 /* BIT_STRING_SIZE_6 */
static int hf_nbap_iod = -1;                      /* BIT_STRING_SIZE_11 */
static int hf_nbap_ganssAddClockModels = -1;      /* GANSS_AddClockModels */
static int hf_nbap_ganssAddOrbitModels = -1;      /* GANSS_AddOrbitModels */
static int hf_nbap_GANSS_SAT_Info_Almanac_GLOkpList_item = -1;  /* GANSS_SAT_Info_Almanac_GLOkp */
static int hf_nbap_gloAlmNA = -1;                 /* BIT_STRING_SIZE_11 */
static int hf_nbap_gloAlmnA = -1;                 /* BIT_STRING_SIZE_5 */
static int hf_nbap_gloAlmHA = -1;                 /* BIT_STRING_SIZE_5 */
static int hf_nbap_gloAlmLambdaA = -1;            /* BIT_STRING_SIZE_21 */
static int hf_nbap_gloAlmTlambdaA = -1;           /* BIT_STRING_SIZE_21 */
static int hf_nbap_gloAlmDeltaIA = -1;            /* BIT_STRING_SIZE_18 */
static int hf_nbap_gloAkmDeltaTA = -1;            /* BIT_STRING_SIZE_22 */
static int hf_nbap_gloAlmDeltaTdotA = -1;         /* BIT_STRING_SIZE_7 */
static int hf_nbap_gloAlmEpsilonA = -1;           /* BIT_STRING_SIZE_15 */
static int hf_nbap_gloAlmOmegaA = -1;             /* BIT_STRING_SIZE_16 */
static int hf_nbap_gloAlmTauA = -1;               /* BIT_STRING_SIZE_10 */
static int hf_nbap_gloAlmCA = -1;                 /* BIT_STRING_SIZE_1 */
static int hf_nbap_gloAlmMA = -1;                 /* BIT_STRING_SIZE_2 */
static int hf_nbap_GANSS_SAT_Info_Almanac_MIDIkpList_item = -1;  /* GANSS_SAT_Info_Almanac_MIDIkp */
static int hf_nbap_midiAlmE = -1;                 /* BIT_STRING_SIZE_11 */
static int hf_nbap_midiAlmDeltaI = -1;            /* BIT_STRING_SIZE_11 */
static int hf_nbap_midiAlmOmegaDot = -1;          /* BIT_STRING_SIZE_11 */
static int hf_nbap_midiAlmSqrtA = -1;             /* BIT_STRING_SIZE_17 */
static int hf_nbap_midiAlmOmega0 = -1;            /* BIT_STRING_SIZE_16 */
static int hf_nbap_midiAlmOmega = -1;             /* BIT_STRING_SIZE_16 */
static int hf_nbap_midiAlmMo = -1;                /* BIT_STRING_SIZE_16 */
static int hf_nbap_midiAlmaf0 = -1;               /* BIT_STRING_SIZE_11 */
static int hf_nbap_midiAlmaf1 = -1;               /* BIT_STRING_SIZE_10 */
static int hf_nbap_midiAlmL1Health = -1;          /* BIT_STRING_SIZE_1 */
static int hf_nbap_midiAlmL2Health = -1;          /* BIT_STRING_SIZE_1 */
static int hf_nbap_midiAlmL5Health = -1;          /* BIT_STRING_SIZE_1 */
static int hf_nbap_GANSS_SAT_Info_Almanac_NAVkpList_item = -1;  /* GANSS_SAT_Info_Almanac_NAVkp */
static int hf_nbap_navAlmE = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_nbap_navAlmDeltaI = -1;             /* BIT_STRING_SIZE_16 */
static int hf_nbap_navAlmOMEGADOT = -1;           /* BIT_STRING_SIZE_16 */
static int hf_nbap_navAlmSVHealth = -1;           /* BIT_STRING_SIZE_8 */
static int hf_nbap_navAlmSqrtA = -1;              /* BIT_STRING_SIZE_24 */
static int hf_nbap_navAlmOMEGAo = -1;             /* BIT_STRING_SIZE_24 */
static int hf_nbap_navAlmOmega = -1;              /* BIT_STRING_SIZE_24 */
static int hf_nbap_navAlmMo = -1;                 /* BIT_STRING_SIZE_24 */
static int hf_nbap_navAlmaf0 = -1;                /* BIT_STRING_SIZE_11 */
static int hf_nbap_navAlmaf1 = -1;                /* BIT_STRING_SIZE_11 */
static int hf_nbap_GANSS_SAT_Info_Almanac_REDkpList_item = -1;  /* GANSS_SAT_Info_Almanac_REDkp */
static int hf_nbap_redAlmDeltaA = -1;             /* BIT_STRING_SIZE_8 */
static int hf_nbap_redAlmOmega0 = -1;             /* BIT_STRING_SIZE_7 */
static int hf_nbap_redAlmPhi0 = -1;               /* BIT_STRING_SIZE_7 */
static int hf_nbap_redAlmL1Health = -1;           /* BIT_STRING_SIZE_1 */
static int hf_nbap_redAlmL2Health = -1;           /* BIT_STRING_SIZE_1 */
static int hf_nbap_redAlmL5Health = -1;           /* BIT_STRING_SIZE_1 */
static int hf_nbap_GANSS_SAT_Info_Almanac_SBASecefList_item = -1;  /* GANSS_SAT_Info_Almanac_SBASecef */
static int hf_nbap_sbasAlmDataID = -1;            /* BIT_STRING_SIZE_2 */
static int hf_nbap_sbasAlmHealth = -1;            /* BIT_STRING_SIZE_8 */
static int hf_nbap_sbasAlmXg = -1;                /* BIT_STRING_SIZE_15 */
static int hf_nbap_sbasAlmYg = -1;                /* BIT_STRING_SIZE_15 */
static int hf_nbap_sbasAlmZg = -1;                /* BIT_STRING_SIZE_9 */
static int hf_nbap_sbasAlmXgdot = -1;             /* BIT_STRING_SIZE_3 */
static int hf_nbap_sbasAlmYgDot = -1;             /* BIT_STRING_SIZE_3 */
static int hf_nbap_sbasAlmZgDot = -1;             /* BIT_STRING_SIZE_4 */
static int hf_nbap_sbasAlmTo = -1;                /* BIT_STRING_SIZE_11 */
static int hf_nbap_GANSS_Sat_Info_Nav_item = -1;  /* GANSS_Sat_Info_Nav_item */
static int hf_nbap_svHealth_01 = -1;              /* BIT_STRING_SIZE_5 */
static int hf_nbap_iod_01 = -1;                   /* BIT_STRING_SIZE_10 */
static int hf_nbap_ganssClockModel = -1;          /* GANSS_Clock_Model */
static int hf_nbap_ganssOrbitModel = -1;          /* GANSS_Orbit_Model */
static int hf_nbap_sbasAgfo = -1;                 /* BIT_STRING_SIZE_12 */
static int hf_nbap_sbasAgf1 = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_nbap_ganss_time_model_Ref_Time = -1;  /* INTEGER_0_37799 */
static int hf_nbap_ganss_t_a0 = -1;               /* INTEGER_M2147483648_2147483647 */
static int hf_nbap_ganss_t_a1 = -1;               /* INTEGER_M8388608_8388607 */
static int hf_nbap_ganss_t_a2 = -1;               /* INTEGER_M64_63 */
static int hf_nbap_gnss_to_id = -1;               /* T_gnss_to_id */
static int hf_nbap_ganss_wk_number_01 = -1;       /* INTEGER_0_8191 */
static int hf_nbap_ganssDay = -1;                 /* INTEGER_0_8191 */
static int hf_nbap_a_one_utc = -1;                /* BIT_STRING_SIZE_24 */
static int hf_nbap_a_zero_utc = -1;               /* BIT_STRING_SIZE_32 */
static int hf_nbap_t_ot_utc = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_nbap_w_n_t_utc = -1;                /* BIT_STRING_SIZE_8 */
static int hf_nbap_delta_t_ls_utc = -1;           /* BIT_STRING_SIZE_8 */
static int hf_nbap_w_n_lsf_utc = -1;              /* BIT_STRING_SIZE_8 */
static int hf_nbap_dn_utc = -1;                   /* BIT_STRING_SIZE_8 */
static int hf_nbap_delta_t_lsf_utc = -1;          /* BIT_STRING_SIZE_8 */
static int hf_nbap_utcA0 = -1;                    /* BIT_STRING_SIZE_16 */
static int hf_nbap_utcA1 = -1;                    /* BIT_STRING_SIZE_13 */
static int hf_nbap_utcA2 = -1;                    /* BIT_STRING_SIZE_7 */
static int hf_nbap_utcDeltaTls = -1;              /* BIT_STRING_SIZE_8 */
static int hf_nbap_utcTot = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_nbap_utcWNot = -1;                  /* BIT_STRING_SIZE_13 */
static int hf_nbap_utcWNlsf = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_nbap_utcDN = -1;                    /* BIT_STRING_SIZE_4 */
static int hf_nbap_utcDeltaTlsf = -1;             /* BIT_STRING_SIZE_8 */
static int hf_nbap_nA = -1;                       /* BIT_STRING_SIZE_11 */
static int hf_nbap_tauC = -1;                     /* BIT_STRING_SIZE_32 */
static int hf_nbap_deltaUT1_01 = -1;              /* GANSS_DeltaUT1 */
static int hf_nbap_kp = -1;                       /* BIT_STRING_SIZE_2 */
static int hf_nbap_utcA1wnt = -1;                 /* BIT_STRING_SIZE_24 */
static int hf_nbap_utcA0wnt = -1;                 /* BIT_STRING_SIZE_32 */
static int hf_nbap_utcTot_01 = -1;                /* BIT_STRING_SIZE_8 */
static int hf_nbap_utcWNt = -1;                   /* BIT_STRING_SIZE_8 */
static int hf_nbap_utcDN_01 = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_nbap_utcStandardID = -1;            /* BIT_STRING_SIZE_3 */
static int hf_nbap_wna_alm = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_nbap_sat_info_almanac = -1;         /* SAT_Info_Almanac */
static int hf_nbap_sVGlobalHealth_alm = -1;       /* BIT_STRING_SIZE_364 */
static int hf_nbap_alpha_zero_ionos_01 = -1;      /* BIT_STRING_SIZE_8 */
static int hf_nbap_alpha_one_ionos_01 = -1;       /* BIT_STRING_SIZE_8 */
static int hf_nbap_alpha_two_ionos_01 = -1;       /* BIT_STRING_SIZE_8 */
static int hf_nbap_alpha_three_ionos = -1;        /* BIT_STRING_SIZE_8 */
static int hf_nbap_beta_zero_ionos = -1;          /* BIT_STRING_SIZE_8 */
static int hf_nbap_beta_one_ionos = -1;           /* BIT_STRING_SIZE_8 */
static int hf_nbap_beta_two_ionos = -1;           /* BIT_STRING_SIZE_8 */
static int hf_nbap_beta_three_ionos = -1;         /* BIT_STRING_SIZE_8 */
static int hf_nbap_GPS_Information_item = -1;     /* GPS_Information_Item */
static int hf_nbap_bad_satellites = -1;           /* GPSBadSat_Info_RealTime_Integrity */
static int hf_nbap_no_bad_satellites = -1;        /* NULL */
static int hf_nbap_sat_info = -1;                 /* SATInfo_RealTime_Integrity */
static int hf_nbap_GPS_NavigationModel_and_TimeRecovery_item = -1;  /* GPS_NavandRecovery_Item */
static int hf_nbap_tx_tow_nav = -1;               /* INTEGER_0_1048575 */
static int hf_nbap_sat_id_nav = -1;               /* SAT_ID */
static int hf_nbap_tlm_message_nav = -1;          /* BIT_STRING_SIZE_14 */
static int hf_nbap_tlm_revd_c_nav = -1;           /* BIT_STRING_SIZE_2 */
static int hf_nbap_ho_word_nav = -1;              /* BIT_STRING_SIZE_22 */
static int hf_nbap_w_n_nav = -1;                  /* BIT_STRING_SIZE_10 */
static int hf_nbap_ca_or_p_on_l2_nav = -1;        /* BIT_STRING_SIZE_2 */
static int hf_nbap_user_range_accuracy_index_nav = -1;  /* BIT_STRING_SIZE_4 */
static int hf_nbap_sv_health_nav = -1;            /* BIT_STRING_SIZE_6 */
static int hf_nbap_iodc_nav = -1;                 /* BIT_STRING_SIZE_10 */
static int hf_nbap_l2_p_dataflag_nav = -1;        /* BIT_STRING_SIZE_1 */
static int hf_nbap_sf1_reserved_nav = -1;         /* BIT_STRING_SIZE_87 */
static int hf_nbap_t_gd_nav = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_nbap_t_oc_nav = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_nbap_a_f_2_nav = -1;                /* BIT_STRING_SIZE_8 */
static int hf_nbap_a_f_1_nav = -1;                /* BIT_STRING_SIZE_16 */
static int hf_nbap_a_f_zero_nav = -1;             /* BIT_STRING_SIZE_22 */
static int hf_nbap_gps_e_nav = -1;                /* BIT_STRING_SIZE_32 */
static int hf_nbap_t_oe_nav = -1;                 /* BIT_STRING_SIZE_16 */
static int hf_nbap_fit_interval_flag_nav = -1;    /* BIT_STRING_SIZE_1 */
static int hf_nbap_aodo_nav = -1;                 /* BIT_STRING_SIZE_5 */
static int hf_nbap_gps_omega_nav = -1;            /* BIT_STRING_SIZE_32 */
static int hf_nbap_spare_zero_fill = -1;          /* BIT_STRING_SIZE_20 */
static int hf_nbap_latitudeSign_01 = -1;          /* T_latitudeSign_01 */
static int hf_nbap_latitude = -1;                 /* INTEGER_0_8388607 */
static int hf_nbap_longitude = -1;                /* INTEGER_M8388608_8388607 */
static int hf_nbap_directionOfAltitude_01 = -1;   /* T_directionOfAltitude_01 */
static int hf_nbap_implicit = -1;                 /* HARQ_MemoryPartitioning_Implicit */
static int hf_nbap_explicit = -1;                 /* HARQ_MemoryPartitioning_Explicit */
static int hf_nbap_number_of_Processes = -1;      /* INTEGER_1_8_ */
static int hf_nbap_hARQ_MemoryPartitioningList = -1;  /* HARQ_MemoryPartitioningList */
static int hf_nbap_HARQ_MemoryPartitioningList_item = -1;  /* HARQ_MemoryPartitioningItem */
static int hf_nbap_HARQ_MemoryPartitioningInfoExtForMIMO_item = -1;  /* HARQ_MemoryPartitioningItem */
static int hf_nbap_process_Memory_Size = -1;      /* T_process_Memory_Size */
static int hf_nbap_HS_DSCHProvidedBitRate_item = -1;  /* HS_DSCHProvidedBitRate_Item */
static int hf_nbap_hS_DSCHProvidedBitRateValue = -1;  /* HS_DSCHProvidedBitRateValue */
static int hf_nbap_HS_DSCHProvidedBitRateValueInformation_For_CellPortion_item = -1;  /* HS_DSCHProvidedBitRateValueInformation_For_CellPortion_Item */
static int hf_nbap_hS_DSCHProvidedBitRateValue_01 = -1;  /* HS_DSCHProvidedBitRate */
static int hf_nbap_HS_DSCHProvidedBitRateValueInformation_For_CellPortionLCR_item = -1;  /* HS_DSCHProvidedBitRateValueInformation_For_CellPortionLCR_Item */
static int hf_nbap_HS_DSCHRequiredPower_item = -1;  /* HS_DSCHRequiredPower_Item */
static int hf_nbap_hS_DSCHRequiredPowerValue = -1;  /* HS_DSCHRequiredPowerValue */
static int hf_nbap_hS_DSCHRequiredPowerPerUEInformation = -1;  /* HS_DSCHRequiredPowerPerUEInformation */
static int hf_nbap_HS_DSCHRequiredPowerPerUEInformation_item = -1;  /* HS_DSCHRequiredPowerPerUEInformation_Item */
static int hf_nbap_cRNC_CommunicationContextID = -1;  /* CRNC_CommunicationContextID */
static int hf_nbap_hS_DSCHRequiredPowerPerUEWeight = -1;  /* HS_DSCHRequiredPowerPerUEWeight */
static int hf_nbap_HS_DSCHRequiredPowerValueInformation_For_CellPortion_item = -1;  /* HS_DSCHRequiredPowerValueInformation_For_CellPortion_Item */
static int hf_nbap_hS_DSCHRequiredPowerValue_01 = -1;  /* HS_DSCHRequiredPower */
static int hf_nbap_HS_DSCHRequiredPowerValueInformation_For_CellPortionLCR_item = -1;  /* HS_DSCHRequiredPowerValueInformation_For_CellPortionLCR_Item */
static int hf_nbap_hsdpa_PICH_Shared_with_PCH = -1;  /* HSDPA_PICH_Shared_with_PCH */
static int hf_nbap_hsdpa_PICH_notShared_with_PCH = -1;  /* HSDPA_PICH_notShared_with_PCH */
static int hf_nbap_hsdpa_PICH_SharedPCH_ID = -1;  /* CommonPhysicalChannelID */
static int hf_nbap_hSDPA_PICH_notShared_ID = -1;  /* CommonPhysicalChannelID */
static int hf_nbap_fdd_DL_Channelisation_CodeNumber = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_pich_Power = -1;               /* PICH_Power */
static int hf_nbap_pich_Mode = -1;                /* PICH_Mode */
static int hf_nbap_sttd_Indicator = -1;           /* STTD_Indicator */
static int hf_nbap_hsdsch_Common_Information = -1;  /* HSDSCH_Common_Information */
static int hf_nbap_commonMACFlow_Specific_Information = -1;  /* CommonMACFlow_Specific_InfoList */
static int hf_nbap_hsSCCH_Specific_Information_ResponseFDD = -1;  /* HSSCCH_Specific_InformationRespListFDD */
static int hf_nbap_hARQ_MemoryPartitioning = -1;  /* HARQ_MemoryPartitioning */
static int hf_nbap_commonMACFlow_Specific_Info_Response = -1;  /* CommonMACFlow_Specific_InfoList_Response */
static int hf_nbap_cCCH_PriorityQueue_Id = -1;    /* PriorityQueue_Id */
static int hf_nbap_sRB1_PriorityQueue_Id = -1;    /* PriorityQueue_Id */
static int hf_nbap_associatedCommon_MACFlow = -1;  /* Common_MACFlow_ID */
static int hf_nbap_fACH_Measurement_Occasion_Cycle_Length_Coefficient = -1;  /* FACH_Measurement_Occasion_Cycle_Length_Coefficient */
static int hf_nbap_rACH_Measurement_Result = -1;  /* RACH_Measurement_Result */
static int hf_nbap_bCCH_Specific_HSDSCH_RNTI_Information = -1;  /* BCCH_Specific_HSDSCH_RNTI_Information */
static int hf_nbap_hSDSCH_MACdFlows_Information = -1;  /* HSDSCH_MACdFlows_Information */
static int hf_nbap_ueCapability_Info = -1;        /* UE_Capability_Information */
static int hf_nbap_mAChs_Reordering_Buffer_Size_for_RLC_UM = -1;  /* MAChsReorderingBufferSize_for_RLC_UM */
static int hf_nbap_hsscch_PowerOffset = -1;       /* HSSCCH_PowerOffset */
static int hf_nbap_tDD_AckNack_Power_Offset = -1;  /* TDD_AckNack_Power_Offset */
static int hf_nbap_hsDSCH_MACdFlow_Specific_Info_to_Modify = -1;  /* HSDSCH_MACdFlow_Specific_InfoList_to_Modify */
static int hf_nbap_priorityQueueInfotoModify = -1;  /* PriorityQueue_InfoList_to_Modify */
static int hf_nbap_hSSCCHCodeChangeGrant = -1;    /* HSSCCH_Code_Change_Grant */
static int hf_nbap_tDDAckNackPowerOffset = -1;    /* TDD_AckNack_Power_Offset */
static int hf_nbap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify_item = -1;  /* HSDSCH_MACdFlow_Specific_InfoItem_to_Modify */
static int hf_nbap_hsDSCH_MACdFlow_ID = -1;       /* HSDSCH_MACdFlow_ID */
static int hf_nbap_priorityQueueInfotoModifyUnsynchronised = -1;  /* PriorityQueue_InfoList_to_Modify_Unsynchronised */
static int hf_nbap_hsDSCH_MACdFlow_Specific_InformationResp = -1;  /* HSDSCH_MACdFlow_Specific_InformationResp */
static int hf_nbap_sixtyfourQAM_UsageAllowedIndicator = -1;  /* SixtyfourQAM_UsageAllowedIndicator */
static int hf_nbap_hSDSCH_RNTI = -1;              /* HSDSCH_RNTI */
static int hf_nbap_sixtyfourQAM_DL_UsageIndicator = -1;  /* SixtyfourQAM_DL_UsageIndicator */
static int hf_nbap_hSDSCH_TBSizeTableIndicator = -1;  /* HSDSCH_TBSizeTableIndicator */
static int hf_nbap_hSSCCH_CodeChangeGrant = -1;   /* HSSCCH_Code_Change_Grant */
static int hf_nbap_hsSCCHCodeChangeIndicator = -1;  /* HSSCCH_CodeChangeIndicator */
static int hf_nbap_hS_PDSCH_Code_Change_Indicator = -1;  /* HS_PDSCH_Code_Change_Indicator */
static int hf_nbap_hS_DSCH_Secondary_Serving_cell_choice = -1;  /* HS_DSCH_Secondary_Serving_cell_change_choice */
static int hf_nbap_hS_Secondary_Serving_cell_change_successful = -1;  /* HS_Secondary_Serving_cell_change_successful */
static int hf_nbap_hS_Secondary_Serving_cell_change_unsuccessful = -1;  /* HS_Secondary_Serving_cell_change_unsuccessful */
static int hf_nbap_hS_DSCH_FDD_Secondary_Serving_Information_Response = -1;  /* HS_DSCH_FDD_Secondary_Serving_Information_Response */
static int hf_nbap_paging_MACFlow_Specific_Information = -1;  /* Paging_MACFlow_Specific_Information */
static int hf_nbap_number_of_PCCH_transmission = -1;  /* Number_of_PCCH_transmission */
static int hf_nbap_transport_Block_Size_List = -1;  /* Transport_Block_Size_List */
static int hf_nbap_HSDSCH_Paging_System_Information_ResponseFDD_item = -1;  /* HSDSCH_Paging_System_Information_ResponseList */
static int hf_nbap_pagingMACFlow_ID = -1;         /* Paging_MACFlow_ID */
static int hf_nbap_hSPDSCH_Code_Index = -1;       /* HSPDSCH_Code_Index */
static int hf_nbap_hsSCCH_Specific_Information_ResponseTDD = -1;  /* HSSCCH_Specific_InformationRespListTDD */
static int hf_nbap_hsSCCH_Specific_Information_ResponseTDDLCR = -1;  /* HSSCCH_Specific_InformationRespListTDDLCR */
static int hf_nbap_HSDSCH_MACdFlow_Specific_InformationResp_item = -1;  /* HSDSCH_MACdFlow_Specific_InformationResp_Item */
static int hf_nbap_hsDSCHMacdFlow_Id = -1;        /* HSDSCH_MACdFlow_ID */
static int hf_nbap_hSDSCH_MACdFlow_Specific_Info = -1;  /* HSDSCH_MACdFlow_Specific_InfoList */
static int hf_nbap_priorityQueue_Info = -1;       /* PriorityQueue_InfoList */
static int hf_nbap_HSDSCH_MACdFlow_Specific_InfoList_item = -1;  /* HSDSCH_MACdFlow_Specific_InfoItem */
static int hf_nbap_HSDSCH_MACdFlows_to_Delete_item = -1;  /* HSDSCH_MACdFlows_to_Delete_Item */
static int hf_nbap_HSDSCH_Initial_Capacity_Allocation_item = -1;  /* HSDSCH_Initial_Capacity_AllocationItem */
static int hf_nbap_maximum_MACdPDU_Size = -1;     /* MACdPDU_Size */
static int hf_nbap_hSDSCH_InitialWindowSize = -1;  /* HSDSCH_InitialWindowSize */
static int hf_nbap_setsOfHS_SCCH_Codes = -1;      /* SetsOfHS_SCCH_Codes */
static int hf_nbap_hARQ_Preamble_Mode_Activation_Indicator = -1;  /* HARQ_Preamble_Mode_Activation_Indicator */
static int hf_nbap_mIMO_N_M_Ratio = -1;           /* MIMO_N_M_Ratio */
static int hf_nbap_continuousPacketConnectivityHS_SCCH_less_Information_Response = -1;  /* ContinuousPacketConnectivityHS_SCCH_less_Information_Response */
static int hf_nbap_Additional_EDCH_Preconfiguration_Information_item = -1;  /* Additional_EDCH_Preconfiguration_Information_ItemIEs */
static int hf_nbap_mAChsResetScheme = -1;         /* MAChsResetScheme */
static int hf_nbap_hSDSCH_Physical_Layer_Category = -1;  /* INTEGER_1_64_ */
static int hf_nbap_secondaryServingCells = -1;    /* SecondaryServingCells */
static int hf_nbap_numPrimaryHS_SCCH_Codes = -1;  /* NumHS_SCCH_Codes */
static int hf_nbap_hARQ_Preamble_Mode = -1;       /* HARQ_Preamble_Mode */
static int hf_nbap_mIMO_ActivationIndicator = -1;  /* MIMO_ActivationIndicator */
static int hf_nbap_hSDSCH_MACdPDUSizeFormat = -1;  /* HSDSCH_MACdPDUSizeFormat */
static int hf_nbap_uE_with_enhanced_HS_SCCH_support_indicator = -1;  /* NULL */
static int hf_nbap_HS_SCCH_PreconfiguredCodes_item = -1;  /* HS_SCCH_PreconfiguredCodesItem */
static int hf_nbap_hS_SCCH_CodeNumber = -1;       /* HS_SCCH_CodeNumber */
static int hf_nbap_HSSCCH_Specific_InformationRespListFDD_item = -1;  /* HSSCCH_Codes */
static int hf_nbap_codeNumber = -1;               /* INTEGER_0_127 */
static int hf_nbap_HSSCCH_Specific_InformationRespListTDD_item = -1;  /* HSSCCH_Specific_InformationRespItemTDD */
static int hf_nbap_timeslot = -1;                 /* TimeSlot */
static int hf_nbap_tDD_ChannelisationCode = -1;   /* TDD_ChannelisationCode */
static int hf_nbap_hSSICH_Info = -1;              /* HSSICH_Info */
static int hf_nbap_HSSCCH_Specific_InformationRespListTDDLCR_item = -1;  /* HSSCCH_Specific_InformationRespItemTDDLCR */
static int hf_nbap_timeslotLCR = -1;              /* TimeSlotLCR */
static int hf_nbap_first_TDD_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_nbap_second_TDD_ChannelisationCode = -1;  /* TDD_ChannelisationCode */
static int hf_nbap_hSSICH_InfoLCR = -1;           /* HSSICH_InfoLCR */
static int hf_nbap_HSSCCH_Specific_InformationRespListTDD768_item = -1;  /* HSSCCH_Specific_InformationRespItemTDD768 */
static int hf_nbap_tDD_ChannelisationCode768 = -1;  /* TDD_ChannelisationCode768 */
static int hf_nbap_hSSICH_Info768 = -1;           /* HSSICH_Info768 */
static int hf_nbap_hsSICH_ID = -1;                /* HS_SICH_ID */
static int hf_nbap_failed_HS_SICH = -1;           /* HS_SICH_failed */
static int hf_nbap_missed_HS_SICH = -1;           /* HS_SICH_missed */
static int hf_nbap_total_HS_SICH = -1;            /* HS_SICH_total */
static int hf_nbap_number_of_HS_PDSCH_codes = -1;  /* INTEGER_0_maxHS_PDSCHCodeNrComp_1 */
static int hf_nbap_hS_PDSCH_Start_code_number = -1;  /* HS_PDSCH_Start_code_number */
static int hf_nbap_replace_02 = -1;               /* HS_SCCH_FDD_Code_List */
static int hf_nbap_HS_SCCH_FDD_Code_List_item = -1;  /* HS_SCCH_FDD_Code_Information_Item */
static int hf_nbap_hspdsch_RL_ID = -1;            /* RL_ID */
static int hf_nbap_hSDSCH_FDD_Information = -1;   /* HSDSCH_FDD_Information */
static int hf_nbap_hsdsch_RNTI = -1;              /* HSDSCH_RNTI */
static int hf_nbap_hS_DSCH_serving_cell_choice = -1;  /* HS_DSCH_serving_cell_choice */
static int hf_nbap_hS_serving_cell_change_successful = -1;  /* HS_serving_cell_change_successful */
static int hf_nbap_hS_serving_cell_change_unsuccessful = -1;  /* HS_serving_cell_change_unsuccessful */
static int hf_nbap_hSDSCH_FDD_Information_Response = -1;  /* HSDSCH_FDD_Information_Response */
static int hf_nbap_hsdpa_PICH_notShared_with_PCHLCR = -1;  /* HSDPA_PICH_notShared_with_PCHLCR */
static int hf_nbap_tdd_ChannelisationCodeLCR = -1;  /* TDD_ChannelisationCodeLCR */
static int hf_nbap_tdd_PhysicalChannelOffset = -1;  /* TDD_PhysicalChannelOffset */
static int hf_nbap_pagingIndicatorLength = -1;    /* PagingIndicatorLength */
static int hf_nbap_pICH_Power = -1;               /* PICH_Power */
static int hf_nbap_second_TDD_ChannelisationCodeLCR = -1;  /* TDD_ChannelisationCodeLCR */
static int hf_nbap_hsdsch_Common_InformationLCR = -1;  /* HSDSCH_Common_InformationLCR */
static int hf_nbap_commonMACFlow_Specific_InformationLCR = -1;  /* CommonMACFlow_Specific_InfoListLCR */
static int hf_nbap_common_H_RNTI_InformationLCR = -1;  /* Common_H_RNTI_InformationLCR */
static int hf_nbap_sync_InformationLCR = -1;      /* Sync_InformationLCR */
static int hf_nbap_hSSICH_SIRTarget = -1;         /* UL_SIR */
static int hf_nbap_hSSICH_TPC_StepSize = -1;      /* TDD_TPC_UplinkStepSize_LCR */
static int hf_nbap_hsSCCH_Specific_Information_ResponseLCR = -1;  /* HSSCCH_Specific_InformationRespListLCR */
static int hf_nbap_commonMACFlow_Specific_Info_ResponseLCR = -1;  /* CommonMACFlow_Specific_InfoList_ResponseLCR */
static int hf_nbap_associatedCommon_MACFlowLCR = -1;  /* Common_MACFlow_ID_LCR */
static int hf_nbap_bCCH_Specific_HSDSCH_RNTI_InformationLCR = -1;  /* BCCH_Specific_HSDSCH_RNTI_InformationLCR */
static int hf_nbap_paging_MACFlow_Specific_InformationLCR = -1;  /* Paging_MACFlow_Specific_InformationLCR */
static int hf_nbap_reception_Window_Size = -1;    /* INTEGER_1_16 */
static int hf_nbap_n_PCH = -1;                    /* INTEGER_1_8 */
static int hf_nbap_paging_Subchannel_Size = -1;   /* INTEGER_1_3 */
static int hf_nbap_HSDSCH_Paging_System_Information_ResponseLCR_item = -1;  /* HSDSCH_Paging_System_Information_ResponseListLCR */
static int hf_nbap_dL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst = -1;  /* DL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst */
static int hf_nbap_HSSCCH_Specific_InformationRespListLCR_item = -1;  /* HSSCCH_Specific_InformationRespItemLCR */
static int hf_nbap_hS_SCCH_ID_LCR = -1;           /* HS_SCCH_ID_LCR */
static int hf_nbap_transport_Block_Size_List_01 = -1;  /* Transport_Block_Size_List_LCR */
static int hf_nbap_hS_DSCH_SPS_Reservation_Indicator = -1;  /* SPS_Reservation_Indicator */
static int hf_nbap_hS_DSCH_SPS_Operation_Indicator = -1;  /* HS_DSCH_SPS_Operation_Indicator */
static int hf_nbap_Transport_Block_Size_List_LCR_item = -1;  /* Transport_Block_Size_Item_LCR */
static int hf_nbap_transport_Block_Size_maping_Index_LCR = -1;  /* Transport_Block_Size_maping_Index_LCR */
static int hf_nbap_transport_Block_Size_Index_LCR = -1;  /* Transport_Block_Size_Index_LCR */
static int hf_nbap_Repetition_Period_List_LCR_item = -1;  /* Repetition_Period_Item_LCR */
static int hf_nbap_repetitionPeriodIndex = -1;    /* RepetitionPeriodIndex */
static int hf_nbap_logicalChannellevel = -1;      /* LogicalChannellevel */
static int hf_nbap_priorityQueuelevel = -1;       /* PriorityQueuelevel */
static int hf_nbap_hS_SICH_InformationList_for_HS_DSCH_SPS = -1;  /* HS_SICH_InformationList_for_HS_DSCH_SPS */
static int hf_nbap_initial_HS_PDSCH_SPS_Resource = -1;  /* Initial_HS_PDSCH_SPS_Resource */
static int hf_nbap_buffer_Size_for_HS_DSCH_SPS = -1;  /* Process_Memory_Size */
static int hf_nbap_number_of_Processes_for_HS_DSCH_SPS = -1;  /* Number_of_Processes_for_HS_DSCH_SPS */
static int hf_nbap_HS_SICH_InformationList_for_HS_DSCH_SPS_item = -1;  /* HS_SICH_InformationItem_for_HS_DSCH_SPS */
static int hf_nbap_hS_SICH_Mapping_Index = -1;    /* HS_SICH_Mapping_Index */
static int hf_nbap_hS_SICH_Type = -1;             /* HS_SICH_Type */
static int hf_nbap_hS_SCCH_Associated_HS_SICH = -1;  /* HS_SCCH_Associated_HS_SICH */
static int hf_nbap_non_HS_SCCH_Associated_HS_SICH = -1;  /* Non_HS_SCCH_Associated_HS_SICH */
static int hf_nbap_extended_HS_SICH_ID = -1;      /* Extended_HS_SICH_ID */
static int hf_nbap_non_HS_SCCH_Aassociated_HS_SICH_ID = -1;  /* Non_HS_SCCH_Aassociated_HS_SICH_ID */
static int hf_nbap_hS_PDSCH_Offset = -1;          /* TDD_PhysicalChannelOffset */
static int hf_nbap_timeslot_Resource_Related_Information_01 = -1;  /* HS_DSCH_TimeslotResourceLCR */
static int hf_nbap_startCode = -1;                /* TDD_ChannelisationCode */
static int hf_nbap_endCode = -1;                  /* TDD_ChannelisationCode */
static int hf_nbap_transport_Block_Size_Index_01 = -1;  /* Transport_Block_Size_Index_LCR */
static int hf_nbap_modulationType = -1;           /* ModulationSPS_LCR */
static int hf_nbap_non_HS_SCCH_Associated_HS_SICH_InformationList = -1;  /* Non_HS_SCCH_Associated_HS_SICH_InformationList */
static int hf_nbap_Non_HS_SCCH_Associated_HS_SICH_InformationList_item = -1;  /* Non_HS_SCCH_Associated_HS_SICH_InformationItem */
static int hf_nbap_Non_HS_SCCH_Associated_HS_SICH_InformationList_Ext_item = -1;  /* Non_HS_SCCH_Associated_HS_SICH_InformationItem */
static int hf_nbap_modify_non_HS_SCCH_Associated_HS_SICH_InformationList = -1;  /* Modify_Non_HS_SCCH_Associated_HS_SICH_InformationList */
static int hf_nbap_Modify_Non_HS_SCCH_Associated_HS_SICH_InformationList_item = -1;  /* Modify_Non_HS_SCCH_Associated_HS_SICH_InformationItem */
static int hf_nbap_Modify_Non_HS_SCCH_Associated_HS_SICH_InformationList_Ext_item = -1;  /* Modify_Non_HS_SCCH_Associated_HS_SICH_InformationItem */
static int hf_nbap_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_item = -1;  /* Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqstItem */
static int hf_nbap_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext_item = -1;  /* Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqstItem */
static int hf_nbap_MIMO_ReferenceSignal_InformationListLCR_item = -1;  /* HSSICH_ReferenceSignal_InformationLCR */
static int hf_nbap_midambleConfigurationLCR = -1;  /* MidambleConfigurationLCR */
static int hf_nbap_midambleShift = -1;            /* INTEGER_0_15 */
static int hf_nbap_hSSICH_ReferenceSignal_InformationLCR = -1;  /* HSSICH_ReferenceSignal_InformationLCR */
static int hf_nbap_sub_Frame_Number = -1;         /* Sub_Frame_Number */
static int hf_nbap_onDemand = -1;                 /* NULL */
static int hf_nbap_periodic = -1;                 /* InformationReportCharacteristicsType_ReportPeriodicity */
static int hf_nbap_onModification = -1;           /* InformationReportCharacteristicsType_OnModification */
static int hf_nbap_min = -1;                      /* ReportPeriodicity_Scaledmin */
static int hf_nbap_hours = -1;                    /* ReportPeriodicity_Scaledhour */
static int hf_nbap_information_thresholds = -1;   /* InformationThresholds */
static int hf_nbap_dgps = -1;                     /* DGPSThresholds */
static int hf_nbap_dGANSSThreshold = -1;          /* DGANSSThreshold */
static int hf_nbap_information_Type_Item = -1;    /* Information_Type_Item */
static int hf_nbap_gPSInformation = -1;           /* GPS_Information */
static int hf_nbap_iP_SpacingFDD = -1;            /* T_iP_SpacingFDD */
static int hf_nbap_iP_Length = -1;                /* T_iP_Length */
static int hf_nbap_seed = -1;                     /* INTEGER_0_63 */
static int hf_nbap_burstModeParams = -1;          /* BurstModeParams */
static int hf_nbap_iP_Offset = -1;                /* INTEGER_0_9 */
static int hf_nbap_iP_SpacingTDD = -1;            /* T_iP_SpacingTDD */
static int hf_nbap_iP_Start = -1;                 /* INTEGER_0_4095 */
static int hf_nbap_iP_Slot = -1;                  /* INTEGER_0_14 */
static int hf_nbap_iP_PCCPCH = -1;                /* T_iP_PCCPCH */
static int hf_nbap_iP_SpacingTDD_01 = -1;         /* T_iP_SpacingTDD_01 */
static int hf_nbap_iP_Sub = -1;                   /* T_iP_Sub */
static int hf_nbap_cFNOffset = -1;                /* INTEGER_0_255 */
static int hf_nbap_burstStart = -1;               /* INTEGER_0_15 */
static int hf_nbap_burstLength = -1;              /* INTEGER_10_25 */
static int hf_nbap_burstFreq = -1;                /* INTEGER_1_16 */
static int hf_nbap_idleIntervalInfo_k = -1;       /* T_idleIntervalInfo_k */
static int hf_nbap_idleIntervalInfo_offset = -1;  /* INTEGER_0_7 */
static int hf_nbap_maxTimeslotsPerSubFrame = -1;  /* INTEGER_1_6 */
static int hf_nbap_maxPhysChPerTimeslot = -1;     /* T_maxPhysChPerTimeslot */
static int hf_nbap_MACdPDU_Size_Indexlist_item = -1;  /* MACdPDU_Size_IndexItem */
static int hf_nbap_sID = -1;                      /* SID */
static int hf_nbap_macdPDU_Size = -1;             /* MACdPDU_Size */
static int hf_nbap_MACdPDU_Size_Indexlist_to_Modify_item = -1;  /* MACdPDU_Size_IndexItem_to_Modify */
static int hf_nbap_maximum_TB_Size_cell_edge_users = -1;  /* INTEGER_0_5000_ */
static int hf_nbap_maximum_TB_Size_other_users = -1;  /* INTEGER_0_5000_ */
static int hf_nbap_MessageStructure_item = -1;    /* MessageStructure_item */
static int hf_nbap_repetitionNumber_01 = -1;      /* RepetitionNumber1 */
static int hf_nbap_type1 = -1;                    /* Type1 */
static int hf_nbap_midambleConfigurationBurstType1And3 = -1;  /* MidambleConfigurationBurstType1And3 */
static int hf_nbap_midambleAllocationMode = -1;   /* MidambleAllocationMode1 */
static int hf_nbap_defaultMidamble = -1;          /* NULL */
static int hf_nbap_commonMidamble = -1;           /* NULL */
static int hf_nbap_ueSpecificMidamble = -1;       /* MidambleShiftLong */
static int hf_nbap_type2 = -1;                    /* Type2 */
static int hf_nbap_midambleConfigurationBurstType2 = -1;  /* MidambleConfigurationBurstType2 */
static int hf_nbap_midambleAllocationMode_01 = -1;  /* MidambleAllocationMode2 */
static int hf_nbap_ueSpecificMidamble_01 = -1;    /* MidambleShiftShort */
static int hf_nbap_type3 = -1;                    /* Type3 */
static int hf_nbap_midambleAllocationMode_02 = -1;  /* MidambleAllocationMode3 */
static int hf_nbap_midambleAllocationMode_03 = -1;  /* MidambleAllocationMode */
static int hf_nbap_midambleShift_01 = -1;         /* MidambleShiftLong */
static int hf_nbap_type1_01 = -1;                 /* Type7681 */
static int hf_nbap_midambleAllocationMode_04 = -1;  /* MidambleAllocationMode7681 */
static int hf_nbap_type2_01 = -1;                 /* Type7682 */
static int hf_nbap_midambleConfigurationBurstType2_768 = -1;  /* MidambleConfigurationBurstType2_768 */
static int hf_nbap_midambleAllocationMode_05 = -1;  /* MidambleAllocationMode7682 */
static int hf_nbap_ueSpecificMidamble_02 = -1;    /* MidambleShiftShort768 */
static int hf_nbap_type3_01 = -1;                 /* Type7683 */
static int hf_nbap_midambleAllocationMode_06 = -1;  /* MidambleAllocationMode7683 */
static int hf_nbap_primary_and_secondary_CPICH = -1;  /* CommonPhysicalChannelID */
static int hf_nbap_normal_and_diversity_primary_CPICH = -1;  /* NULL */
static int hf_nbap_primary_and_secondary_CPICH_01 = -1;  /* PrimaryAndSecondaryCPICHContainer */
static int hf_nbap_normal_and_diversity_primary_CPICH_01 = -1;  /* NormalAndDiversityPrimaryCPICHContainer */
static int hf_nbap_addPriorityQueue = -1;         /* PriorityQueue_InfoItem_to_Add */
static int hf_nbap_modifyPriorityQueue = -1;      /* PriorityQueue_InfoItem_to_Modify */
static int hf_nbap_deletePriorityQueue = -1;      /* PriorityQueue_Id */
static int hf_nbap_qPSK = -1;                     /* NULL */
static int hf_nbap_sixteenQAM = -1;               /* MBSFN_CPICH_secondary_CCPCH_power_offset */
static int hf_nbap_MultipleFreq_HARQ_MemoryPartitioning_InformationList_item = -1;  /* MultipleFreq_HARQ_MemoryPartitioning_InformationItem */
static int hf_nbap_MultipleFreq_HSPDSCH_InformationList_ResponseTDDLCR_item = -1;  /* MultipleFreq_HSPDSCH_InformationItem_ResponseTDDLCR */
static int hf_nbap_multi_Cell_Capability = -1;    /* Multi_Cell_Capability */
static int hf_nbap_dL_PowerBalancing_Information = -1;  /* DL_PowerBalancing_Information */
static int hf_nbap_minimumReducedE_DPDCH_GainFactor = -1;  /* MinimumReducedE_DPDCH_GainFactor */
static int hf_nbap_secondary_UL_Frequency_Activation_State = -1;  /* Secondary_UL_Frequency_Activation_State */
static int hf_nbap_extendedPropagationDelay = -1;  /* ExtendedPropagationDelay */
static int hf_nbap_primary_CPICH_Usage_for_Channel_Estimation = -1;  /* Primary_CPICH_Usage_for_Channel_Estimation */
static int hf_nbap_secondary_CPICH_Information = -1;  /* CommonPhysicalChannelID */
static int hf_nbap_secondary_CPICH_Information_Change = -1;  /* Secondary_CPICH_Information_Change */
static int hf_nbap_e_AGCH_PowerOffset = -1;       /* E_AGCH_PowerOffset */
static int hf_nbap_e_RGCH_PowerOffset = -1;       /* E_RGCH_PowerOffset */
static int hf_nbap_e_HICH_PowerOffset = -1;       /* E_HICH_PowerOffset */
static int hf_nbap_e_DCH_DL_Control_Channel_Grant = -1;  /* NULL */
static int hf_nbap_NeighbouringCellMeasurementInformation_item = -1;  /* NeighbouringCellMeasurementInformation_item */
static int hf_nbap_neighbouringFDDCellMeasurementInformation = -1;  /* NeighbouringFDDCellMeasurementInformation */
static int hf_nbap_neighbouringTDDCellMeasurementInformation = -1;  /* NeighbouringTDDCellMeasurementInformation */
static int hf_nbap_extension_neighbouringCellMeasurementInformation = -1;  /* Extension_neighbouringCellMeasurementInformation */
static int hf_nbap_uC_Id = -1;                    /* UC_Id */
static int hf_nbap_primaryScramblingCode = -1;    /* PrimaryScramblingCode */
static int hf_nbap_cellParameterID = -1;          /* CellParameterID */
static int hf_nbap_NI_Information_item = -1;      /* Notification_Indicator */
static int hf_nbap_Paging_MACFlows_to_DeleteFDD_item = -1;  /* Paging_MACFlows_to_DeleteFDD_Item */
static int hf_nbap_paging_MACFlow_ID = -1;        /* Paging_MACFlow_ID */
static int hf_nbap_Paging_MACFlow_Specific_Information_item = -1;  /* Paging_MAC_Flow_Specific_Information_Item */
static int hf_nbap_paging_MACFlow_Id = -1;        /* Paging_MACFlow_ID */
static int hf_nbap_hSDPA_associated_PICH_Info = -1;  /* HSDPA_Associated_PICH_Information */
static int hf_nbap_paging_MACFlow_PriorityQueue_Information = -1;  /* Paging_MACFlow_PriorityQueue_Information */
static int hf_nbap_Paging_MACFlow_PriorityQueue_Information_item = -1;  /* Paging_MACFlow_PriorityQueue_Item */
static int hf_nbap_priority_Queue_Information_for_Enhanced_PCH = -1;  /* Priority_Queue_Information_for_Enhanced_FACH_PCH */
static int hf_nbap_sequenceNumber = -1;           /* PLCCHsequenceNumber */
static int hf_nbap_Possible_Secondary_Serving_Cell_List_item = -1;  /* Possible_Secondary_Serving_Cell */
static int hf_nbap_local_Cell_ID = -1;            /* Local_Cell_ID */
static int hf_nbap_power_Offset_For_Secondary_CPICH_for_MIMO = -1;  /* PowerOffsetForSecondaryCPICHforMIMO */
static int hf_nbap_priorityQueue_Id = -1;         /* PriorityQueue_Id */
static int hf_nbap_t1 = -1;                       /* T1 */
static int hf_nbap_mAC_ehs_Reset_Timer = -1;      /* MAC_ehs_Reset_Timer */
static int hf_nbap_discardTimer = -1;             /* DiscardTimer */
static int hf_nbap_mAC_hsWindowSize = -1;         /* MAC_hsWindowSize */
static int hf_nbap_maximum_MACcPDU_Size = -1;     /* MAC_PDU_SizeExtended */
static int hf_nbap_PriorityQueue_InfoList_item = -1;  /* PriorityQueue_InfoItem */
static int hf_nbap_priorityQueueId = -1;          /* PriorityQueue_Id */
static int hf_nbap_associatedHSDSCH_MACdFlow = -1;  /* HSDSCH_MACdFlow_ID */
static int hf_nbap_mAChsGuaranteedBitRate = -1;   /* MAChsGuaranteedBitRate */
static int hf_nbap_macdPDU_Size_Index = -1;       /* MACdPDU_Size_Indexlist */
static int hf_nbap_rLC_Mode = -1;                 /* RLC_Mode */
static int hf_nbap_PriorityQueue_InfoList_to_Modify_item = -1;  /* ModifyPriorityQueue */
static int hf_nbap_macdPDU_Size_Index_to_Modify = -1;  /* MACdPDU_Size_Indexlist_to_Modify */
static int hf_nbap_PriorityQueue_InfoList_to_Modify_Unsynchronised_item = -1;  /* PriorityQueue_InfoItem_to_Modify_Unsynchronised */
static int hf_nbap_none = -1;                     /* NULL */
static int hf_nbap_selected_MBMS_Service = -1;    /* Selected_MBMS_Service */
static int hf_nbap_selected_MBMS_Service_List = -1;  /* Selected_MBMS_Service_List */
static int hf_nbap_Selected_MBMS_Service_List_item = -1;  /* Selected_MBMS_Service_Item */
static int hf_nbap_selected_MBMS_Service_TimeSlot_Information_LCR = -1;  /* Selected_MBMS_Service_TimeSlot_Information_LCR */
static int hf_nbap_mBMS_Service_TDM_Information = -1;  /* MBMS_Service_TDM_Information */
static int hf_nbap_Selected_MBMS_Service_TimeSlot_Information_LCR_item = -1;  /* TimeSlotLCR */
static int hf_nbap_transmission_Time_Interval = -1;  /* T_transmission_Time_Interval */
static int hf_nbap_tDM_Rep = -1;                  /* INTEGER_2_9 */
static int hf_nbap_tDM_Offset = -1;               /* INTEGER_0_8 */
static int hf_nbap_tDM_Length = -1;               /* INTEGER_1_8 */
static int hf_nbap_Paging_MACFlow_Specific_InformationLCR_item = -1;  /* Paging_MAC_Flow_Specific_Information_ItemLCR */
static int hf_nbap_hSDPA_associated_PICH_InfoLCR = -1;  /* HSDPA_Associated_PICH_InformationLCR */
static int hf_nbap_paging_MACFlow_PriorityQueue_InformationLCR = -1;  /* Paging_MACFlow_PriorityQueue_Information */
static int hf_nbap_Paging_MACFlows_to_DeleteLCR_item = -1;  /* Paging_MACFlows_to_DeleteLCR_Item */
static int hf_nbap_RL_Specific_DCH_Info_item = -1;  /* RL_Specific_DCH_Info_Item */
static int hf_nbap_dCH_id = -1;                   /* T_dCH_id */
static int hf_nbap_transportlayeraddress = -1;    /* TransportLayerAddress */
static int hf_nbap_rL_Specific_E_DCH_Information = -1;  /* RL_Specific_E_DCH_Information */
static int hf_nbap_RL_Specific_E_DCH_Information_item = -1;  /* RL_Specific_E_DCH_Information_Item */
static int hf_nbap_Reference_E_TFCI_Information_item = -1;  /* Reference_E_TFCI_Information_Item */
static int hf_nbap_reference_E_TFCI = -1;         /* E_TFCI */
static int hf_nbap_reference_E_TFCI_PO = -1;      /* Reference_E_TFCI_PO */
static int hf_nbap_periodic_01 = -1;              /* ReportCharacteristicsType_ReportPeriodicity */
static int hf_nbap_event_a = -1;                  /* ReportCharacteristicsType_EventA */
static int hf_nbap_event_b = -1;                  /* ReportCharacteristicsType_EventB */
static int hf_nbap_event_c = -1;                  /* ReportCharacteristicsType_EventC */
static int hf_nbap_event_d = -1;                  /* ReportCharacteristicsType_EventD */
static int hf_nbap_event_e = -1;                  /* ReportCharacteristicsType_EventE */
static int hf_nbap_event_f = -1;                  /* ReportCharacteristicsType_EventF */
static int hf_nbap_extension_ReportCharacteristics = -1;  /* Extension_ReportCharacteristics */
static int hf_nbap_measurementThreshold = -1;     /* ReportCharacteristicsType_MeasurementThreshold */
static int hf_nbap_measurementHysteresisTime = -1;  /* ReportCharacteristicsType_ScaledMeasurementHysteresisTime */
static int hf_nbap_measurementIncreaseThreshold = -1;  /* ReportCharacteristicsType_MeasurementIncreaseDecreaseThreshold */
static int hf_nbap_measurementChangeTime = -1;    /* ReportCharacteristicsType_ScaledMeasurementChangeTime */
static int hf_nbap_measurementDecreaseThreshold = -1;  /* ReportCharacteristicsType_MeasurementIncreaseDecreaseThreshold */
static int hf_nbap_measurementThreshold1 = -1;    /* ReportCharacteristicsType_MeasurementThreshold */
static int hf_nbap_measurementThreshold2 = -1;    /* ReportCharacteristicsType_MeasurementThreshold */
static int hf_nbap_reportPeriodicity = -1;        /* ReportCharacteristicsType_ReportPeriodicity */
static int hf_nbap_received_total_wide_band_power_01 = -1;  /* Received_total_wide_band_power_Value_IncrDecrThres */
static int hf_nbap_uL_TimeslotISCP_01 = -1;       /* UL_TimeslotISCP_Value_IncrDecrThres */
static int hf_nbap_sir = -1;                      /* SIR_Value_IncrDecrThres */
static int hf_nbap_sir_error = -1;                /* SIR_Error_Value_IncrDecrThres */
static int hf_nbap_transmitted_code_power = -1;   /* Transmitted_Code_Power_Value_IncrDecrThres */
static int hf_nbap_rscp = -1;                     /* RSCP_Value_IncrDecrThres */
static int hf_nbap_round_trip_time = -1;          /* Round_Trip_Time_IncrDecrThres */
static int hf_nbap_extension_ReportCharacteristicsType_MeasurementIncreaseDecreaseThreshold = -1;  /* Extension_ReportCharacteristicsType_MeasurementIncreaseDecreaseThreshold */
static int hf_nbap_sir_01 = -1;                   /* SIR_Value */
static int hf_nbap_sir_error_01 = -1;             /* SIR_Error_Value */
static int hf_nbap_transmitted_code_power_01 = -1;  /* Transmitted_Code_Power_Value */
static int hf_nbap_rscp_01 = -1;                  /* RSCP_Value */
static int hf_nbap_rx_timing_deviation = -1;      /* Rx_Timing_Deviation_Value */
static int hf_nbap_round_trip_time_01 = -1;       /* Round_Trip_Time_Value */
static int hf_nbap_extension_ReportCharacteristicsType_MeasurementThreshold = -1;  /* Extension_ReportCharacteristicsType_MeasurementThreshold */
static int hf_nbap_msec = -1;                     /* MeasurementChangeTime_Scaledmsec */
static int hf_nbap_msec_01 = -1;                  /* MeasurementHysteresisTime_Scaledmsec */
static int hf_nbap_msec_02 = -1;                  /* ReportPeriodicity_Scaledmsec */
static int hf_nbap_Received_total_wide_band_power_For_CellPortion_Value_item = -1;  /* Received_total_wide_band_power_For_CellPortion_Value_Item */
static int hf_nbap_received_total_wide_band_power_value = -1;  /* Received_total_wide_band_power_Value */
static int hf_nbap_Received_total_wide_band_power_For_CellPortion_ValueLCR_item = -1;  /* Received_total_wide_band_power_For_CellPortion_ValueLCR_Item */
static int hf_nbap_Received_Scheduled_EDCH_Power_Share_For_CellPortion_Value_item = -1;  /* Received_Scheduled_EDCH_Power_Share_For_CellPortion_Value_Item */
static int hf_nbap_received_Scheduled_power_share_value = -1;  /* RSEPS_Value */
static int hf_nbap_informationAvailable = -1;     /* InformationAvailable */
static int hf_nbap_informationnotAvailable = -1;  /* InformationnotAvailable */
static int hf_nbap_requesteddataValue = -1;       /* RequestedDataValue */
static int hf_nbap_dgps_corrections = -1;         /* DGPSCorrections */
static int hf_nbap_gps_navandrecovery = -1;       /* GPS_NavigationModel_and_TimeRecovery */
static int hf_nbap_gps_ionos_model = -1;          /* GPS_Ionospheric_Model */
static int hf_nbap_gps_utc_model = -1;            /* GPS_UTC_Model */
static int hf_nbap_gps_almanac = -1;              /* GPS_Almanac */
static int hf_nbap_gps_rt_integrity = -1;         /* GPS_RealTime_Integrity */
static int hf_nbap_gpsrxpos = -1;                 /* GPS_RX_POS */
static int hf_nbap_SAT_Info_Almanac_item = -1;    /* SAT_Info_Almanac_Item */
static int hf_nbap_data_id = -1;                  /* DATA_ID */
static int hf_nbap_sat_id = -1;                   /* SAT_ID */
static int hf_nbap_gps_e_alm = -1;                /* BIT_STRING_SIZE_16 */
static int hf_nbap_gps_toa_alm = -1;              /* BIT_STRING_SIZE_8 */
static int hf_nbap_gps_delta_I_alm = -1;          /* BIT_STRING_SIZE_16 */
static int hf_nbap_omegadot_alm = -1;             /* BIT_STRING_SIZE_16 */
static int hf_nbap_svhealth_alm = -1;             /* BIT_STRING_SIZE_8 */
static int hf_nbap_gps_a_sqrt_alm = -1;           /* BIT_STRING_SIZE_24 */
static int hf_nbap_omegazero_alm = -1;            /* BIT_STRING_SIZE_24 */
static int hf_nbap_m_zero_alm = -1;               /* BIT_STRING_SIZE_24 */
static int hf_nbap_gps_omega_alm = -1;            /* BIT_STRING_SIZE_24 */
static int hf_nbap_gps_af_zero_alm = -1;          /* BIT_STRING_SIZE_11 */
static int hf_nbap_gps_af_one_alm = -1;           /* BIT_STRING_SIZE_11 */
static int hf_nbap_SAT_Info_Almanac_ExtList_item = -1;  /* SAT_Info_Almanac_ExtItem */
static int hf_nbap_SAT_Info_DGPSCorrections_item = -1;  /* SAT_Info_DGPSCorrections_Item */
static int hf_nbap_iode_dgps = -1;                /* BIT_STRING_SIZE_8 */
static int hf_nbap_prc = -1;                      /* PRC */
static int hf_nbap_range_correction_rate = -1;    /* Range_Correction_Rate */
static int hf_nbap_SATInfo_RealTime_Integrity_item = -1;  /* SAT_Info_RealTime_Integrity_Item */
static int hf_nbap_bad_sat_id = -1;               /* SAT_ID */
static int hf_nbap_SecondaryServingCells_item = -1;  /* SecondaryServingCellsItem */
static int hf_nbap_secondaryC_ID = -1;            /* C_ID */
static int hf_nbap_numSecondaryHS_SCCH_Codes = -1;  /* NumHS_SCCH_Codes */
static int hf_nbap_new_secondary_CPICH = -1;      /* CommonPhysicalChannelID */
static int hf_nbap_secondary_CPICH_shall_not_be_used = -1;  /* NULL */
static int hf_nbap_serving_E_DCH_RL_in_this_NodeB = -1;  /* Serving_E_DCH_RL_in_this_NodeB */
static int hf_nbap_serving_E_DCH_RL_not_in_this_NodeB = -1;  /* NULL */
static int hf_nbap_SetsOfHS_SCCH_Codes_item = -1;  /* SetsOfHS_SCCH_CodesItem */
static int hf_nbap_hS_SCCH_PreconfiguredCodes = -1;  /* HS_SCCH_PreconfiguredCodes */
static int hf_nbap_setup = -1;                    /* Additional_EDCH_Setup_Info */
static int hf_nbap_configurationChange = -1;      /* Additional_EDCH_Cell_Information_ConfigurationChange_List */
static int hf_nbap_removal = -1;                  /* Additional_EDCH_Cell_Information_Removal_List */
static int hf_nbap_sFNSFNChangeLimit = -1;        /* SFNSFNChangeLimit */
static int hf_nbap_predictedSFNSFNDeviationLimit = -1;  /* PredictedSFNSFNDeviationLimit */
static int hf_nbap_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;  /* T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation */
static int hf_nbap_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;  /* T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item */
static int hf_nbap_sFNSFNValue = -1;              /* SFNSFNValue */
static int hf_nbap_sFNSFNQuality = -1;            /* SFNSFNQuality */
static int hf_nbap_sFNSFNDriftRate = -1;          /* SFNSFNDriftRate */
static int hf_nbap_sFNSFNDriftRateQuality = -1;   /* SFNSFNDriftRateQuality */
static int hf_nbap_sFNSFNTimeStampInformation = -1;  /* SFNSFNTimeStampInformation */
static int hf_nbap_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;  /* T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation */
static int hf_nbap_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;  /* T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item */
static int hf_nbap_sFNSFNTimeStamp_FDD = -1;      /* SFN */
static int hf_nbap_sFNSFNTimeStamp_TDD = -1;      /* SFNSFNTimeStamp_TDD */
static int hf_nbap_sFN = -1;                      /* SFN */
static int hf_nbap_sFNSFN_FDD = -1;               /* SFNSFN_FDD */
static int hf_nbap_sFNSFN_TDD = -1;               /* SFNSFN_TDD */
static int hf_nbap_sFNSFN_TDD768 = -1;            /* SFNSFN_TDD768 */
static int hf_nbap_synchronisationReportCharacteristicsType = -1;  /* SynchronisationReportCharacteristicsType */
static int hf_nbap_synchronisationReportCharactThreExc = -1;  /* SynchronisationReportCharactThreExc */
static int hf_nbap_SynchronisationReportCharactThreExc_item = -1;  /* SynchronisationReportCharactThreInfoItem */
static int hf_nbap_syncFrameNumber = -1;          /* SyncFrameNumber */
static int hf_nbap_cellSyncBurstInformation = -1;  /* SEQUENCE_SIZE_1_maxNrOfReceptsPerSyncFrame_OF_SynchronisationReportCharactCellSyncBurstInfoItem */
static int hf_nbap_cellSyncBurstInformation_item = -1;  /* SynchronisationReportCharactCellSyncBurstInfoItem */
static int hf_nbap_cellSyncBurstCode = -1;        /* CellSyncBurstCode */
static int hf_nbap_cellSyncBurstCodeShift = -1;   /* CellSyncBurstCodeShift */
static int hf_nbap_cellSyncBurstTiming = -1;      /* CellSyncBurstTiming */
static int hf_nbap_cellSyncBurstTimingThreshold = -1;  /* CellSyncBurstTimingThreshold */
static int hf_nbap_SyncDLCodeIdThreInfoLCR_item = -1;  /* SyncDLCodeIdThreInfoList */
static int hf_nbap_syncFrameNoToReceive = -1;     /* SyncFrameNumber */
static int hf_nbap_syncDLCodeIdInfoLCR = -1;      /* SyncDLCodeInfoListLCR */
static int hf_nbap_SyncDLCodeInfoListLCR_item = -1;  /* SyncDLCodeInfoItemLCR */
static int hf_nbap_syncDLCodeId = -1;             /* SYNCDlCodeId */
static int hf_nbap_syncDLCodeIdArrivTime = -1;    /* CellSyncBurstTimingLCR */
static int hf_nbap_syncDLCodeIdTimingThre = -1;   /* CellSyncBurstTimingThreshold */
static int hf_nbap_modulation = -1;               /* Modulation */
static int hf_nbap_TDD_DL_Code_Information_item = -1;  /* TDD_DL_Code_InformationItem */
static int hf_nbap_dPCH_ID = -1;                  /* DPCH_ID */
static int hf_nbap_TDD_DL_Code_LCR_Information_item = -1;  /* TDD_DL_Code_LCR_InformationItem */
static int hf_nbap_tdd_DL_DPCH_TimeSlotFormat_LCR = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_nbap_TDD_DL_Code_768_Information_item = -1;  /* TDD_DL_Code_768_InformationItem */
static int hf_nbap_qPSK_01 = -1;                  /* QPSK_DL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_nbap_eightPSK = -1;                 /* EightPSK_DL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_nbap_initialOffset = -1;            /* INTEGER_0_255 */
static int hf_nbap_noinitialOffset = -1;          /* INTEGER_0_63 */
static int hf_nbap_signalledGainFactors = -1;     /* T_signalledGainFactors */
static int hf_nbap_gainFactor = -1;               /* T_gainFactor */
static int hf_nbap_fdd = -1;                      /* T_fdd */
static int hf_nbap_betaC = -1;                    /* BetaCD */
static int hf_nbap_betaD = -1;                    /* BetaCD */
static int hf_nbap_tdd = -1;                      /* BetaCD */
static int hf_nbap_refTFCNumber = -1;             /* RefTFCNumber */
static int hf_nbap_computedGainFactors = -1;      /* RefTFCNumber */
static int hf_nbap_TDD_UL_Code_Information_item = -1;  /* TDD_UL_Code_InformationItem */
static int hf_nbap_TDD_UL_Code_LCR_Information_item = -1;  /* TDD_UL_Code_LCR_InformationItem */
static int hf_nbap_tdd_UL_DPCH_TimeSlotFormat_LCR = -1;  /* TDD_UL_DPCH_TimeSlotFormat_LCR */
static int hf_nbap_TDD_UL_Code_768_Information_item = -1;  /* TDD_UL_Code_768_InformationItem */
static int hf_nbap_qPSK_02 = -1;                  /* QPSK_UL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_nbap_eightPSK_01 = -1;              /* EightPSK_UL_DPCH_TimeSlotFormatTDD_LCR */
static int hf_nbap_tFCI_SignallingOption = -1;    /* TFCI_SignallingMode_TFCI_SignallingOption */
static int hf_nbap_not_Used_splitType = -1;       /* NULL */
static int hf_nbap_not_Used_lengthOfTFCI2 = -1;   /* NULL */
static int hf_nbap_TimeSlot_InitiatedListLCR_item = -1;  /* TimeSlotLCR */
static int hf_nbap_TimeSlotMeasurementValueListLCR_item = -1;  /* TimeSlotMeasurementValueLCR */
static int hf_nbap_commonMeasurementValue = -1;   /* CommonMeasurementValue */
static int hf_nbap_initialPhase_01 = -1;          /* INTEGER_0_1048575_ */
static int hf_nbap_dsField = -1;                  /* DsField */
static int hf_nbap_genericTrafficCategory = -1;   /* GenericTrafficCategory */
static int hf_nbap_Transmission_Gap_Pattern_Sequence_Information_item = -1;  /* Transmission_Gap_Pattern_Sequence_Information_item */
static int hf_nbap_tGSN = -1;                     /* TGSN */
static int hf_nbap_tGL1 = -1;                     /* GapLength */
static int hf_nbap_tGL2 = -1;                     /* GapLength */
static int hf_nbap_tGD = -1;                      /* TGD */
static int hf_nbap_tGPL1 = -1;                    /* GapDuration */
static int hf_nbap_not_to_be_used_1 = -1;         /* GapDuration */
static int hf_nbap_uL_DL_mode = -1;               /* UL_DL_mode */
static int hf_nbap_downlink_Compressed_Mode_Method = -1;  /* Downlink_Compressed_Mode_Method */
static int hf_nbap_uplink_Compressed_Mode_Method = -1;  /* Uplink_Compressed_Mode_Method */
static int hf_nbap_dL_FrameType = -1;             /* DL_FrameType */
static int hf_nbap_delta_SIR1 = -1;               /* DeltaSIR */
static int hf_nbap_delta_SIR_after1 = -1;         /* DeltaSIR */
static int hf_nbap_delta_SIR2 = -1;               /* DeltaSIR */
static int hf_nbap_delta_SIR_after2 = -1;         /* DeltaSIR */
static int hf_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue_item = -1;  /* TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue_Item */
static int hf_nbap_transmittedCarrierPowerOfAllCodesNotUsedForHSTransmissionValue = -1;  /* TransmittedCarrierPowerOfAllCodesNotUsedForHSTransmissionValue */
static int hf_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortionValue_item = -1;  /* TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortionValue_Item */
static int hf_nbap_Transmitted_Carrier_Power_For_CellPortion_Value_item = -1;  /* Transmitted_Carrier_Power_For_CellPortion_Value_Item */
static int hf_nbap_transmitted_Carrier_Power_Value = -1;  /* Transmitted_Carrier_Power_Value */
static int hf_nbap_Transmitted_Carrier_Power_For_CellPortion_ValueLCR_item = -1;  /* Transmitted_Carrier_Power_For_CellPortion_ValueLCR_Item */
static int hf_nbap_tFCSvalues = -1;               /* T_tFCSvalues */
static int hf_nbap_no_Split_in_TFCI = -1;         /* TFCS_TFCSList */
static int hf_nbap_not_Used_split_in_TFCI = -1;   /* NULL */
static int hf_nbap_TFCS_TFCSList_item = -1;       /* TFCS_TFCSList_item */
static int hf_nbap_cTFC = -1;                     /* TFCS_CTFC */
static int hf_nbap_tFC_Beta = -1;                 /* TransportFormatCombination_Beta */
static int hf_nbap_ctfc2bit = -1;                 /* INTEGER_0_3 */
static int hf_nbap_ctfc4bit = -1;                 /* INTEGER_0_15 */
static int hf_nbap_ctfc6bit = -1;                 /* INTEGER_0_63 */
static int hf_nbap_ctfc8bit = -1;                 /* INTEGER_0_255 */
static int hf_nbap_ctfc12bit = -1;                /* INTEGER_0_4095 */
static int hf_nbap_ctfc16bit = -1;                /* INTEGER_0_65535 */
static int hf_nbap_ctfcmaxbit = -1;               /* INTEGER_0_maxCTFC */
static int hf_nbap_Transport_Block_Size_List_item = -1;  /* Transport_Block_Size_List_item */
static int hf_nbap_transport_Block_Size_Index_for_Enhanced_PCH = -1;  /* Transport_Block_Size_Index_for_Enhanced_PCH */
static int hf_nbap_dynamicParts = -1;             /* TransportFormatSet_DynamicPartList */
static int hf_nbap_semi_staticPart = -1;          /* TransportFormatSet_Semi_staticPart */
static int hf_nbap_TransportFormatSet_DynamicPartList_item = -1;  /* TransportFormatSet_DynamicPartList_item */
static int hf_nbap_nrOfTransportBlocks = -1;      /* TransportFormatSet_NrOfTransportBlocks */
static int hf_nbap_transportBlockSize = -1;       /* TransportFormatSet_TransportBlockSize */
static int hf_nbap_mode = -1;                     /* TransportFormatSet_ModeDP */
static int hf_nbap_transmissionTimeIntervalInformation = -1;  /* TransmissionTimeIntervalInformation */
static int hf_nbap_TransmissionTimeIntervalInformation_item = -1;  /* TransmissionTimeIntervalInformation_item */
static int hf_nbap_transmissionTimeInterval = -1;  /* TransportFormatSet_TransmissionTimeIntervalDynamic */
static int hf_nbap_transmissionTimeInterval_01 = -1;  /* TransportFormatSet_TransmissionTimeIntervalSemiStatic */
static int hf_nbap_channelCoding = -1;            /* TransportFormatSet_ChannelCodingType */
static int hf_nbap_codingRate = -1;               /* TransportFormatSet_CodingRate */
static int hf_nbap_rateMatchingAttribute = -1;    /* TransportFormatSet_RateMatchingAttribute */
static int hf_nbap_cRC_Size = -1;                 /* TransportFormatSet_CRC_Size */
static int hf_nbap_mode_01 = -1;                  /* TransportFormatSet_ModeSSP */
static int hf_nbap_tdd_01 = -1;                   /* TDD_TransportFormatSet_ModeDP */
static int hf_nbap_notApplicable = -1;            /* NULL */
static int hf_nbap_tdd_02 = -1;                   /* TransportFormatSet_SecondInterleavingMode */
static int hf_nbap_mS = -1;                       /* INTEGER_0_16383 */
static int hf_nbap_lS = -1;                       /* INTEGER_0_4294967295 */
static int hf_nbap_tUTRANGANSSChangeLimit = -1;   /* INTEGER_1_256 */
static int hf_nbap_predictedTUTRANGANSSDeviationLimit = -1;  /* INTEGER_1_256 */
static int hf_nbap_tUTRANGANSS = -1;              /* TUTRANGANSS */
static int hf_nbap_tUTRANGANSSQuality = -1;       /* INTEGER_0_255 */
static int hf_nbap_tUTRANGANSSDriftRate = -1;     /* INTEGER_M50_50 */
static int hf_nbap_tUTRANGANSSDriftRateQuality = -1;  /* INTEGER_0_50 */
static int hf_nbap_ms_part = -1;                  /* INTEGER_0_16383 */
static int hf_nbap_ls_part = -1;                  /* INTEGER_0_4294967295 */
static int hf_nbap_tUTRANGPSChangeLimit = -1;     /* TUTRANGPSChangeLimit */
static int hf_nbap_predictedTUTRANGPSDeviationLimit = -1;  /* PredictedTUTRANGPSDeviationLimit */
static int hf_nbap_tUTRANGPS = -1;                /* TUTRANGPS */
static int hf_nbap_tUTRANGPSQuality = -1;         /* TUTRANGPSQuality */
static int hf_nbap_tUTRANGPSDriftRate = -1;       /* TUTRANGPSDriftRate */
static int hf_nbap_tUTRANGPSDriftRateQuality = -1;  /* TUTRANGPSDriftRateQuality */
static int hf_nbap_rNC_ID = -1;                   /* RNC_ID */
static int hf_nbap_uE_AggregateMaximumBitRateDownlink = -1;  /* UE_AggregateMaximumBitRateDownlink */
static int hf_nbap_uE_AggregateMaximumBitRateUplink = -1;  /* UE_AggregateMaximumBitRateUplink */
static int hf_nbap_hSDSCH_Physical_Layer_Category_01 = -1;  /* T_hSDSCH_Physical_Layer_Category */
static int hf_nbap_UL_Timeslot_Information_item = -1;  /* UL_Timeslot_InformationItem */
static int hf_nbap_uL_Code_InformationList = -1;  /* TDD_UL_Code_Information */
static int hf_nbap_UL_TimeslotLCR_Information_item = -1;  /* UL_TimeslotLCR_InformationItem */
static int hf_nbap_uL_Code_InformationList_01 = -1;  /* TDD_UL_Code_LCR_Information */
static int hf_nbap_UL_Timeslot768_Information_item = -1;  /* UL_Timeslot768_InformationItem */
static int hf_nbap_uL_Code_InformationList_02 = -1;  /* TDD_UL_Code_768_Information */
static int hf_nbap_uL_ScramblingCodeNumber = -1;  /* UL_ScramblingCodeNumber */
static int hf_nbap_uL_ScramblingCodeLength = -1;  /* UL_ScramblingCodeLength */
static int hf_nbap_uL_Synchronisation_StepSize = -1;  /* UL_Synchronisation_StepSize */
static int hf_nbap_uL_Synchronisation_Frequency = -1;  /* UL_Synchronisation_Frequency */
static int hf_nbap_UL_TimeSlot_ISCP_Info_item = -1;  /* UL_TimeSlot_ISCP_InfoItem */
static int hf_nbap_iSCP = -1;                     /* UL_TimeslotISCP_Value */
static int hf_nbap_UL_TimeSlot_ISCP_LCR_Info_item = -1;  /* UL_TimeSlot_ISCP_LCR_InfoItem */
static int hf_nbap_UpPTSInterference_For_CellPortion_Value_item = -1;  /* UpPTSInterference_For_CellPortion_Value_Item */
static int hf_nbap_upPTSInterferenceValue = -1;   /* UpPTSInterferenceValue */
static int hf_nbap_USCH_Information_item = -1;    /* USCH_InformationItem */
static int hf_nbap_uSCH_ID = -1;                  /* USCH_ID */
static int hf_nbap_USCH_InformationResponse_item = -1;  /* USCH_InformationResponseItem */
static int hf_nbap_UL_TimeslotISCP_For_CellPortion_Value_item = -1;  /* UL_TimeslotISCP_For_CellPortion_Value_Item */
static int hf_nbap_uL_TimeslotISCP_Value = -1;    /* UL_TimeslotISCP_Value */
static int hf_nbap_protocolIEs = -1;              /* ProtocolIE_Container */
static int hf_nbap_protocolExtensions = -1;       /* ProtocolExtensionContainer */
static int hf_nbap_secondary_CCPCH_parameters = -1;  /* Secondary_CCPCH_CTCH_SetupRqstFDD */
static int hf_nbap_pRACH_parameters = -1;         /* PRACH_CTCH_SetupRqstFDD */
static int hf_nbap_notUsed_pCPCHes_parameters = -1;  /* NULL */
static int hf_nbap_fdd_S_CCPCH_Offset = -1;       /* FDD_S_CCPCH_Offset */
static int hf_nbap_tFCS = -1;                     /* TFCS */
static int hf_nbap_secondary_CCPCH_SlotFormat = -1;  /* SecondaryCCPCH_SlotFormat */
static int hf_nbap_multiplexingPosition = -1;     /* MultiplexingPosition */
static int hf_nbap_powerOffsetInformation = -1;   /* PowerOffsetInformation_CTCH_SetupRqstFDD */
static int hf_nbap_fACH_Parameters = -1;          /* FACH_ParametersList_CTCH_SetupRqstFDD */
static int hf_nbap_pCH_Parameters = -1;           /* PCH_Parameters_CTCH_SetupRqstFDD */
static int hf_nbap_pO1_ForTFCI_Bits = -1;         /* PowerOffset */
static int hf_nbap_pO3_ForPilotBits = -1;         /* PowerOffset */
static int hf_nbap_FACH_ParametersListIE_CTCH_SetupRqstFDD_item = -1;  /* FACH_ParametersItem_CTCH_SetupRqstFDD */
static int hf_nbap_maxFACH_Power = -1;            /* DL_Power */
static int hf_nbap_transportFormatSet_01 = -1;    /* T_transportFormatSet */
static int hf_nbap_pCH_Power = -1;                /* DL_Power */
static int hf_nbap_pICH_Parameters = -1;          /* PICH_Parameters_CTCH_SetupRqstFDD */
static int hf_nbap_pICH_Mode = -1;                /* PICH_Mode */
static int hf_nbap_mICH_Power = -1;               /* PICH_Power */
static int hf_nbap_mICH_Mode = -1;                /* MICH_Mode */
static int hf_nbap_preambleSignatures = -1;       /* PreambleSignatures */
static int hf_nbap_allowedSlotFormatInformation = -1;  /* AllowedSlotFormatInformationList_CTCH_SetupRqstFDD */
static int hf_nbap_rACH_SubChannelNumbers = -1;   /* RACH_SubChannelNumbers */
static int hf_nbap_ul_punctureLimit = -1;         /* PunctureLimit */
static int hf_nbap_rACH_Parameters = -1;          /* RACH_Parameters_CTCH_SetupRqstFDD */
static int hf_nbap_aICH_Parameters = -1;          /* AICH_Parameters_CTCH_SetupRqstFDD */
static int hf_nbap_AllowedSlotFormatInformationList_CTCH_SetupRqstFDD_item = -1;  /* AllowedSlotFormatInformationItem_CTCH_SetupRqstFDD */
static int hf_nbap_rACHSlotFormat = -1;           /* RACH_SlotFormat */
static int hf_nbap_secondary_CCPCH_parameters_01 = -1;  /* Secondary_CCPCH_CTCH_SetupRqstTDD */
static int hf_nbap_pRACH_parameters_01 = -1;      /* PRACH_CTCH_SetupRqstTDD */
static int hf_nbap_extension_CommonPhysicalChannelType_CTCH_SetupRqstTDD = -1;  /* Extension_CommonPhysicalChannelType_CTCH_SetupRqstTDD */
static int hf_nbap_sCCPCH_CCTrCH_ID = -1;         /* CCTrCH_ID */
static int hf_nbap_tFCI_Coding = -1;              /* TFCI_Coding */
static int hf_nbap_punctureLimit = -1;            /* PunctureLimit */
static int hf_nbap_secondaryCCPCH_parameterList = -1;  /* Secondary_CCPCH_parameterList_CTCH_SetupRqstTDD */
static int hf_nbap_fACH_ParametersList = -1;      /* FACH_ParametersList_CTCH_SetupRqstTDD */
static int hf_nbap_pCH_Parameters_01 = -1;        /* PCH_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_Secondary_CCPCH_parameterListIE_CTCH_SetupRqstTDD_item = -1;  /* Secondary_CCPCH_parameterItem_CTCH_SetupRqstTDD */
static int hf_nbap_midambleShiftandBurstType = -1;  /* MidambleShiftAndBurstType */
static int hf_nbap_s_CCPCH_Power = -1;            /* DL_Power */
static int hf_nbap_Secondary_CCPCH_LCR_parameterList_CTCH_SetupRqstTDD_item = -1;  /* Secondary_CCPCH_LCR_parameterItem_CTCH_SetupRqstTDD */
static int hf_nbap_s_CCPCH_TimeSlotFormat_LCR = -1;  /* TDD_DL_DPCH_TimeSlotFormat_LCR */
static int hf_nbap_Secondary_CCPCH_768_parameterList_CTCH_SetupRqstTDD_item = -1;  /* Secondary_CCPCH_768_parameterItem_CTCH_SetupRqstTDD */
static int hf_nbap_tFCI_Presence768 = -1;         /* TFCI_Presence */
static int hf_nbap_midambleShiftandBurstType768 = -1;  /* MidambleShiftAndBurstType768 */
static int hf_nbap_FACH_ParametersListIE_CTCH_SetupRqstTDD_item = -1;  /* FACH_ParametersItem_CTCH_SetupRqstTDD */
static int hf_nbap_fACH_CCTrCH_ID = -1;           /* CCTrCH_ID */
static int hf_nbap_pCH_CCTrCH_ID = -1;            /* CCTrCH_ID */
static int hf_nbap_pICH_Parameters_01 = -1;       /* PICH_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_midambleshiftAndBurstType = -1;  /* MidambleShiftAndBurstType */
static int hf_nbap_midambleshiftAndBurstType78 = -1;  /* MidambleShiftAndBurstType768 */
static int hf_nbap_notificationIndicatorLength = -1;  /* NotificationIndicatorLength */
static int hf_nbap_mICH_TDDOption_Specific_Parameters = -1;  /* MICH_TDDOption_Specific_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_hCR_TDD = -1;                  /* MICH_HCR_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_lCR_TDD = -1;                  /* MICH_LCR_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_cHipRate768_TDD = -1;          /* MICH_768_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_tSTD_Indicator = -1;           /* TSTD_Indicator */
static int hf_nbap_midambleshiftAndBurstType768 = -1;  /* MidambleShiftAndBurstType768 */
static int hf_nbap_TimeSlotConfigurationList_LCR_CTCH_SetupRqstTDD_item = -1;  /* TimeSlotConfigurationItem_LCR_CTCH_SetupRqstTDD */
static int hf_nbap_timeslotLCR_Parameter_ID = -1;  /* CellParameterID */
static int hf_nbap_Secondary_CCPCH_parameterExtendedList_CTCH_SetupRqstTDD_item = -1;  /* Secondary_CCPCH_parameterItem_CTCH_SetupRqstTDD */
static int hf_nbap_Secondary_CCPCH_LCR_parameterExtendedList_CTCH_SetupRqstTDD_item = -1;  /* Secondary_CCPCH_LCR_parameterItem_CTCH_SetupRqstTDD */
static int hf_nbap_pRACH_Parameters_CTCH_SetupRqstTDD = -1;  /* PRACH_Parameters_CTCH_SetupRqstTDD */
static int hf_nbap_maxPRACH_MidambleShifts = -1;  /* MaxPRACH_MidambleShifts */
static int hf_nbap_pRACH_Midamble = -1;           /* PRACH_Midamble */
static int hf_nbap_rACH = -1;                     /* RACH_Parameter_CTCH_SetupRqstTDD */
static int hf_nbap_uL_TransportFormatSet = -1;    /* TransportFormatSet */
static int hf_nbap_PRACH_LCR_ParametersList_CTCH_SetupRqstTDD_item = -1;  /* PRACH_LCR_ParametersItem_CTCH_SetupRqstTDD */
static int hf_nbap_fPACH_Power = -1;              /* FPACH_Power */
static int hf_nbap_maxPowerPLCCH = -1;            /* DL_Power */
static int hf_nbap_maxE_RUCCH_MidambleShifts = -1;  /* MaxPRACH_MidambleShifts */
static int hf_nbap_e_RUCCH_Midamble = -1;         /* PRACH_Midamble */
static int hf_nbap_FACH_CommonTransportChannel_InformationResponse_item = -1;  /* CommonTransportChannel_InformationResponse */
static int hf_nbap_secondary_CCPCH_parameters_02 = -1;  /* Secondary_CCPCHList_CTCH_ReconfRqstFDD */
static int hf_nbap_pRACH_parameters_02 = -1;      /* PRACHList_CTCH_ReconfRqstFDD */
static int hf_nbap_notUsed_cPCH_parameters = -1;  /* NULL */
static int hf_nbap_fACH_ParametersList_CTCH_ReconfRqstFDD = -1;  /* FACH_ParametersList_CTCH_ReconfRqstFDD */
static int hf_nbap_pCH_Parameters_CTCH_ReconfRqstFDD = -1;  /* PCH_Parameters_CTCH_ReconfRqstFDD */
static int hf_nbap_pICH_Parameters_CTCH_ReconfRqstFDD = -1;  /* PICH_Parameters_CTCH_ReconfRqstFDD */
static int hf_nbap_FACH_ParametersListIE_CTCH_ReconfRqstFDD_item = -1;  /* FACH_ParametersItem_CTCH_ReconfRqstFDD */
static int hf_nbap_pRACH_ParametersList_CTCH_ReconfRqstFDD = -1;  /* PRACH_ParametersList_CTCH_ReconfRqstFDD */
static int hf_nbap_aICH_ParametersList_CTCH_ReconfRqstFDD = -1;  /* AICH_ParametersList_CTCH_ReconfRqstFDD */
static int hf_nbap_PRACH_ParametersListIE_CTCH_ReconfRqstFDD_item = -1;  /* PRACH_ParametersItem_CTCH_ReconfRqstFDD */
static int hf_nbap_allowedSlotFormatInformation_01 = -1;  /* AllowedSlotFormatInformationList_CTCH_ReconfRqstFDD */
static int hf_nbap_AllowedSlotFormatInformationList_CTCH_ReconfRqstFDD_item = -1;  /* AllowedSlotFormatInformationItem_CTCH_ReconfRqstFDD */
static int hf_nbap_rACH_SlotFormat = -1;          /* RACH_SlotFormat */
static int hf_nbap_AICH_ParametersListIE_CTCH_ReconfRqstFDD_item = -1;  /* AICH_ParametersItem_CTCH_ReconfRqstFDD */
static int hf_nbap_secondaryCCPCHList = -1;       /* Secondary_CCPCHList_CTCH_ReconfRqstTDD */
static int hf_nbap_Secondary_CCPCHListIE_CTCH_ReconfRqstTDD_item = -1;  /* Secondary_CCPCHItem_CTCH_ReconfRqstTDD */
static int hf_nbap_sCCPCH_Power = -1;             /* DL_Power */
static int hf_nbap_Secondary_CCPCH_parameterExtendedList_CTCH_ReconfRqstTDD_item = -1;  /* Secondary_CCPCHItem_CTCH_ReconfRqstTDD */
static int hf_nbap_Secondary_CCPCH_LCR_parameterExtendedList_CTCH_ReconfRqstTDD_item = -1;  /* Secondary_CCPCHItem_CTCH_ReconfRqstTDD */
static int hf_nbap_FACH_ParametersList_CTCH_ReconfRqstTDD_item = -1;  /* FACH_ParametersItem_CTCH_ReconfRqstTDD */
static int hf_nbap_commonPhysicalChannelId = -1;  /* CommonPhysicalChannelID */
static int hf_nbap_fPACHPower = -1;               /* FPACH_Power */
static int hf_nbap_secondaryCCPCH768List = -1;    /* Secondary_CCPCH_768_List_CTCH_ReconfRqstTDD */
static int hf_nbap_Secondary_CCPCH_768_List_CTCH_ReconfRqstTDD_item = -1;  /* Secondary_CCPCH_768_Item_CTCH_ReconfRqstTDD */
static int hf_nbap_uPPCHPositionLCR = -1;         /* UPPCHPositionLCR */
static int hf_nbap_Cell_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_configurationGenerationID = -1;  /* ConfigurationGenerationID */
static int hf_nbap_primary_SCH_Information = -1;  /* P_SCH_Information_AuditRsp */
static int hf_nbap_secondary_SCH_Information = -1;  /* S_SCH_Information_AuditRsp */
static int hf_nbap_primary_CPICH_Information = -1;  /* P_CPICH_Information_AuditRsp */
static int hf_nbap_secondary_CPICH_InformationList = -1;  /* S_CPICH_InformationList_AuditRsp */
static int hf_nbap_primary_CCPCH_Information = -1;  /* P_CCPCH_Information_AuditRsp */
static int hf_nbap_bCH_Information = -1;          /* BCH_Information_AuditRsp */
static int hf_nbap_secondary_CCPCH_InformationList = -1;  /* S_CCPCH_InformationList_AuditRsp */
static int hf_nbap_pCH_Information = -1;          /* PCH_Information_AuditRsp */
static int hf_nbap_pICH_Information = -1;         /* PICH_Information_AuditRsp */
static int hf_nbap_fACH_InformationList = -1;     /* FACH_InformationList_AuditRsp */
static int hf_nbap_pRACH_InformationList = -1;    /* PRACH_InformationList_AuditRsp */
static int hf_nbap_rACH_InformationList = -1;     /* RACH_InformationList_AuditRsp */
static int hf_nbap_aICH_InformationList = -1;     /* AICH_InformationList_AuditRsp */
static int hf_nbap_notUsed_1_pCPCH_InformationList = -1;  /* NULL */
static int hf_nbap_notUsed_2_cPCH_InformationList = -1;  /* NULL */
static int hf_nbap_notUsed_3_aP_AICH_InformationList = -1;  /* NULL */
static int hf_nbap_notUsed_4_cDCA_ICH_InformationList = -1;  /* NULL */
static int hf_nbap_sCH_Information = -1;          /* SCH_Information_AuditRsp */
static int hf_nbap_S_CPICH_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_S_CCPCH_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_FACH_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_PRACH_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_RACH_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_AICH_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_FPACH_LCR_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_S_CCPCH_InformationListExt_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_S_CCPCH_LCR_InformationListExt_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_PLCCH_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_S_CCPCH_768_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_PRACH_768_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_E_RUCCH_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_E_RUCCH_768_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Cell_Frequency_List_Information_LCR_MulFreq_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_UPPCH_LCR_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_MultipleFreq_HS_DSCH_Resources_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_MultipleFreq_E_DCH_Resources_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_CCP_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_communicationControlPortID = -1;  /* CommunicationControlPortID */
static int hf_nbap_Local_Cell_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_dl_or_global_capacityCredit = -1;  /* DL_or_Global_CapacityCredit */
static int hf_nbap_ul_capacityCredit = -1;        /* UL_CapacityCredit */
static int hf_nbap_commonChannelsCapacityConsumptionLaw = -1;  /* CommonChannelsCapacityConsumptionLaw */
static int hf_nbap_dedicatedChannelsCapacityConsumptionLaw = -1;  /* DedicatedChannelsCapacityConsumptionLaw */
static int hf_nbap_maximumDL_PowerCapability = -1;  /* MaximumDL_PowerCapability */
static int hf_nbap_minSpreadingFactor = -1;       /* MinSpreadingFactor */
static int hf_nbap_minimumDL_PowerCapability = -1;  /* MinimumDL_PowerCapability */
static int hf_nbap_local_Cell_Group_ID = -1;      /* Local_Cell_ID */
static int hf_nbap_Local_Cell_Group_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Power_Local_Cell_Group_InformationList_AuditRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_power_Local_Cell_Group_ID = -1;  /* Local_Cell_ID */
static int hf_nbap_cell = -1;                     /* Cell_CM_Rqst */
static int hf_nbap_rACH_01 = -1;                  /* RACH_CM_Rqst */
static int hf_nbap_notUsed_cPCH = -1;             /* NULL */
static int hf_nbap_extension_CommonMeasurementObjectType_CM_Rqst = -1;  /* Extension_CommonMeasurementObjectType_CM_Rqst */
static int hf_nbap_powerLocalCellGroupID = -1;    /* Local_Cell_ID */
static int hf_nbap_cell_01 = -1;                  /* Cell_CM_Rsp */
static int hf_nbap_rACH_02 = -1;                  /* RACH_CM_Rsp */
static int hf_nbap_extension_CommonMeasurementObjectType_CM_Rsp = -1;  /* Extension_CommonMeasurementObjectType_CM_Rsp */
static int hf_nbap_cell_02 = -1;                  /* Cell_CM_Rprt */
static int hf_nbap_rACH_03 = -1;                  /* RACH_CM_Rprt */
static int hf_nbap_extension_CommonMeasurementObjectType_CM_Rprt = -1;  /* Extension_CommonMeasurementObjectType_CM_Rprt */
static int hf_nbap_commonMeasurementValueInformation = -1;  /* CommonMeasurementValueInformation */
static int hf_nbap_n_INSYNC_IND = -1;             /* N_INSYNC_IND */
static int hf_nbap_n_OUTSYNC_IND = -1;            /* N_OUTSYNC_IND */
static int hf_nbap_t_RLFAILURE = -1;              /* T_RLFAILURE */
static int hf_nbap_primarySCH_Power = -1;         /* DL_Power */
static int hf_nbap_secondarySCH_Power = -1;       /* DL_Power */
static int hf_nbap_primaryCPICH_Power = -1;       /* PrimaryCPICH_Power */
static int hf_nbap_transmitDiversityIndicator = -1;  /* TransmitDiversityIndicator */
static int hf_nbap_SecondaryCPICH_InformationList_Cell_SetupRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_fDD_DL_ChannelisationCodeNumber = -1;  /* FDD_DL_ChannelisationCodeNumber */
static int hf_nbap_secondaryCPICH_Power = -1;     /* DL_Power */
static int hf_nbap_bCH_information = -1;          /* BCH_Information_Cell_SetupRqstFDD */
static int hf_nbap_bCH_Power = -1;                /* DL_Power */
static int hf_nbap_powerRaiseLimit = -1;          /* PowerRaiseLimit */
static int hf_nbap_dLPowerAveragingWindowSize = -1;  /* DLPowerAveragingWindowSize */
static int hf_nbap_iPDL_FDD_Parameters = -1;      /* IPDL_FDD_Parameters */
static int hf_nbap_iPDL_Indicator = -1;           /* IPDL_Indicator */
static int hf_nbap_CellPortion_InformationList_Cell_SetupRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_associatedSecondaryCPICH = -1;  /* CommonPhysicalChannelID */
static int hf_nbap_maximumTransmissionPowerforCellPortion = -1;  /* MaximumTransmissionPower */
static int hf_nbap_syncCaseIndicator = -1;        /* SyncCaseIndicator_Cell_SetupRqstTDD_PSCH */
static int hf_nbap_sCH_Power = -1;                /* DL_Power */
static int hf_nbap_case1 = -1;                    /* Case1_Cell_SetupRqstTDD */
static int hf_nbap_case2 = -1;                    /* Case2_Cell_SetupRqstTDD */
static int hf_nbap_sCH_TimeSlot = -1;             /* SCH_TimeSlot */
static int hf_nbap_pCCPCH_Power = -1;             /* PCCPCH_Power */
static int hf_nbap_sCTD_Indicator = -1;           /* SCTD_Indicator */
static int hf_nbap_TimeSlotConfigurationList_Cell_SetupRqstTDD_item = -1;  /* TimeSlotConfigurationItem_Cell_SetupRqstTDD */
static int hf_nbap_timeSlotStatus = -1;           /* TimeSlotStatus */
static int hf_nbap_timeSlotDirection = -1;        /* TimeSlotDirection */
static int hf_nbap_TimeSlotConfigurationList_LCR_Cell_SetupRqstTDD_item = -1;  /* TimeSlotConfigurationItem_LCR_Cell_SetupRqstTDD */
static int hf_nbap_dwPCH_Power = -1;              /* DwPCH_Power */
static int hf_nbap_iPDL_TDD_Parameters = -1;      /* IPDL_TDD_Parameters */
static int hf_nbap_iPDL_TDD_Parameters_LCR = -1;  /* IPDL_TDD_Parameters_LCR */
static int hf_nbap_Cell_Frequency_List_LCR_MulFreq_Cell_SetupRqstTDD_item = -1;  /* Cell_Frequency_Item_LCR_MulFreq_Cell_SetupRqstTDD */
static int hf_nbap_timeSlotConfigurationList_LCR_Cell_SetupRqstTDD = -1;  /* TimeSlotConfigurationList_LCR_Cell_SetupRqstTDD */
static int hf_nbap_SecondaryCPICH_InformationList_Cell_ReconfRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_bCH_information_01 = -1;       /* BCH_information_Cell_ReconfRqstFDD */
static int hf_nbap_CellPortion_InformationList_Cell_ReconfRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_TimeSlotConfigurationList_Cell_ReconfRqstTDD_item = -1;  /* TimeSlotConfigurationItem_Cell_ReconfRqstTDD */
static int hf_nbap_TimeSlotConfigurationList_LCR_Cell_ReconfRqstTDD_item = -1;  /* TimeSlotConfigurationItem_LCR_Cell_ReconfRqstTDD */
static int hf_nbap_cell_Frequency_Add_LCR_MulFreq_Cell_ReconfRqstTDD = -1;  /* Cell_Frequency_Add_LCR_MulFreq_Cell_ReconfRqstTDD */
static int hf_nbap_cell_Frequency_ModifyList_LCR_MulFreq_Cell_ReconfRqstTDD = -1;  /* Cell_Frequency_ModifyList_LCR_MulFreq_Cell_ReconfRqstTDD */
static int hf_nbap_cell_Frequency_Delete_LCR_MulFreq_Cell_ReconfRqstTDD = -1;  /* Cell_Frequency_Delete_LCR_MulFreq_Cell_ReconfRqstTDD */
static int hf_nbap_timeSlotConfigurationList_LCR_Cell_ReconfRqstTDD = -1;  /* TimeSlotConfigurationList_LCR_Cell_ReconfRqstTDD */
static int hf_nbap_Cell_Frequency_ModifyList_LCR_MulFreq_Cell_ReconfRqstTDD_item = -1;  /* Cell_Frequency_ModifyItem_LCR_MulFreq_Cell_ReconfRqstTDD */
static int hf_nbap_no_Failure = -1;               /* No_Failure_ResourceStatusInd */
static int hf_nbap_serviceImpacting = -1;         /* ServiceImpacting_ResourceStatusInd */
static int hf_nbap_local_Cell_InformationList = -1;  /* Local_Cell_InformationList_ResourceStatusInd */
static int hf_nbap_local_Cell_Group_InformationList = -1;  /* Local_Cell_Group_InformationList_ResourceStatusInd */
static int hf_nbap_Local_Cell_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_local_CellID = -1;             /* Local_Cell_ID */
static int hf_nbap_addorDeleteIndicator = -1;     /* AddorDeleteIndicator */
static int hf_nbap_Local_Cell_Group_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Power_Local_Cell_Group_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_local_Cell_InformationList_01 = -1;  /* Local_Cell_InformationList2_ResourceStatusInd */
static int hf_nbap_local_Cell_Group_InformationList_01 = -1;  /* Local_Cell_Group_InformationList2_ResourceStatusInd */
static int hf_nbap_cCP_InformationList = -1;      /* CCP_InformationList_ResourceStatusInd */
static int hf_nbap_cell_InformationList = -1;     /* Cell_InformationList_ResourceStatusInd */
static int hf_nbap_Local_Cell_InformationList2_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_maximum_DL_PowerCapability = -1;  /* MaximumDL_PowerCapability */
static int hf_nbap_Local_Cell_Group_InformationList2_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_CCP_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Cell_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_primary_SCH_Information_01 = -1;  /* P_SCH_Information_ResourceStatusInd */
static int hf_nbap_secondary_SCH_Information_01 = -1;  /* S_SCH_Information_ResourceStatusInd */
static int hf_nbap_primary_CPICH_Information_01 = -1;  /* P_CPICH_Information_ResourceStatusInd */
static int hf_nbap_secondary_CPICH_Information_01 = -1;  /* S_CPICH_InformationList_ResourceStatusInd */
static int hf_nbap_primary_CCPCH_Information_01 = -1;  /* P_CCPCH_Information_ResourceStatusInd */
static int hf_nbap_bCH_Information_01 = -1;       /* BCH_Information_ResourceStatusInd */
static int hf_nbap_secondary_CCPCH_InformationList_01 = -1;  /* S_CCPCH_InformationList_ResourceStatusInd */
static int hf_nbap_pCH_Information_01 = -1;       /* PCH_Information_ResourceStatusInd */
static int hf_nbap_pICH_Information_01 = -1;      /* PICH_Information_ResourceStatusInd */
static int hf_nbap_fACH_InformationList_01 = -1;  /* FACH_InformationList_ResourceStatusInd */
static int hf_nbap_pRACH_InformationList_01 = -1;  /* PRACH_InformationList_ResourceStatusInd */
static int hf_nbap_rACH_InformationList_01 = -1;  /* RACH_InformationList_ResourceStatusInd */
static int hf_nbap_aICH_InformationList_01 = -1;  /* AICH_InformationList_ResourceStatusInd */
static int hf_nbap_sCH_Information_01 = -1;       /* SCH_Information_ResourceStatusInd */
static int hf_nbap_S_CPICH_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_S_CCPCH_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_FACH_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_PRACH_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_RACH_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_AICH_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_FPACH_LCR_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_S_CCPCH_InformationListExt_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_S_CCPCH_LCR_InformationListExt_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_PLCCH_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_S_CCPCH_768_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_PRACH_768_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_E_RUCCH_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_E_RUCCH_768_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Cell_Frequency_List_Information_LCR_MulFreq_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_UPPCH_LCR_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_MultipleFreq_HS_DSCH_Resources_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Power_Local_Cell_Group_InformationList2_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_MultipleFreq_E_DCH_Resources_InformationList_ResourceStatusInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_MIB_SB_SIB_InformationList_SystemInfoUpdateRqst_item = -1;  /* MIB_SB_SIB_InformationItem_SystemInfoUpdateRqst */
static int hf_nbap_iB_Type = -1;                  /* IB_Type */
static int hf_nbap_iB_OC_ID = -1;                 /* IB_OC_ID */
static int hf_nbap_deletionIndicator = -1;        /* DeletionIndicator_SystemInfoUpdate */
static int hf_nbap_no_Deletion = -1;              /* No_Deletion_SystemInfoUpdate */
static int hf_nbap_yes_Deletion = -1;             /* NULL */
static int hf_nbap_sIB_Originator = -1;           /* SIB_Originator */
static int hf_nbap_iB_SG_REP = -1;                /* IB_SG_REP */
static int hf_nbap_segmentInformationList = -1;   /* SegmentInformationList_SystemInfoUpdate */
static int hf_nbap_SegmentInformationListIE_SystemInfoUpdate_item = -1;  /* SegmentInformationItem_SystemInfoUpdate */
static int hf_nbap_iB_SG_POS = -1;                /* IB_SG_POS */
static int hf_nbap_segment_Type = -1;             /* Segment_Type */
static int hf_nbap_iB_SG_DATA = -1;               /* IB_SG_DATA */
static int hf_nbap_Additional_HS_Cell_Information_RL_Setup_List_item = -1;  /* Additional_HS_Cell_Information_RL_Setup_ItemIEs */
static int hf_nbap_hSPDSCH_RL_ID = -1;            /* RL_ID */
static int hf_nbap_hS_DSCH_FDD_Secondary_Serving_Information = -1;  /* HS_DSCH_FDD_Secondary_Serving_Information */
static int hf_nbap_minUL_ChannelisationCodeLength = -1;  /* MinUL_ChannelisationCodeLength */
static int hf_nbap_maxNrOfUL_DPDCHs = -1;         /* MaxNrOfUL_DPDCHs */
static int hf_nbap_ul_DPCCH_SlotFormat = -1;      /* UL_DPCCH_SlotFormat */
static int hf_nbap_diversityMode = -1;            /* DiversityMode */
static int hf_nbap_not_Used_sSDT_CellID_Length = -1;  /* NULL */
static int hf_nbap_not_Used_s_FieldLength = -1;   /* NULL */
static int hf_nbap_dl_DPCH_SlotFormat = -1;       /* DL_DPCH_SlotFormat */
static int hf_nbap_tFCI_SignallingMode = -1;      /* TFCI_SignallingMode */
static int hf_nbap_not_Used_pDSCH_RL_ID = -1;     /* NULL */
static int hf_nbap_not_Used_pDSCH_CodeMapping = -1;  /* NULL */
static int hf_nbap_powerOffsetInformation_01 = -1;  /* PowerOffsetInformation_RL_SetupRqstFDD */
static int hf_nbap_pO2_ForTPC_Bits = -1;          /* PowerOffset */
static int hf_nbap_RL_InformationList_RL_SetupRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_frameOffset = -1;              /* FrameOffset */
static int hf_nbap_chipOffset = -1;               /* ChipOffset */
static int hf_nbap_diversityControlField = -1;    /* DiversityControlField */
static int hf_nbap_not_Used_sSDT_Cell_Identity = -1;  /* NULL */
static int hf_nbap_hSDSCH_Configured_Indicator = -1;  /* HSDSCH_Configured_Indicator */
static int hf_nbap_powerOffsetInformation_02 = -1;  /* PowerOffsetInformation_F_DPCH_RL_SetupRqstFDD */
static int hf_nbap_UL_CCTrCH_InformationList_RL_SetupRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_uL_DPCH_Information = -1;      /* UL_DPCH_Information_RL_SetupRqstTDD */
static int hf_nbap_tdd_DPCHOffset = -1;           /* TDD_DPCHOffset */
static int hf_nbap_uL_Timeslot_Information = -1;  /* UL_Timeslot_Information */
static int hf_nbap_uL_TimeslotLCR_Information = -1;  /* UL_TimeslotLCR_Information */
static int hf_nbap_uL_Timeslot768_Information = -1;  /* UL_Timeslot768_Information */
static int hf_nbap_DL_CCTrCH_InformationList_RL_SetupRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_tdd_TPC_DownlinkStepSize = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_nbap_cCTrCH_TPCList = -1;           /* CCTrCH_TPCList_RL_SetupRqstTDD */
static int hf_nbap_dL_DPCH_Information = -1;      /* DL_DPCH_Information_RL_SetupRqstTDD */
static int hf_nbap_CCTrCH_TPCList_RL_SetupRqstTDD_item = -1;  /* CCTrCH_TPCItem_RL_SetupRqstTDD */
static int hf_nbap_dL_Timeslot_Information = -1;  /* DL_Timeslot_Information */
static int hf_nbap_dL_TimeslotLCR_Information = -1;  /* DL_TimeslotLCR_Information */
static int hf_nbap_tstdIndicator = -1;            /* TSTD_Indicator */
static int hf_nbap_dL_Timeslot768_Information = -1;  /* DL_Timeslot768_Information */
static int hf_nbap_specialBurstScheduling = -1;   /* SpecialBurstScheduling */
static int hf_nbap_dL_TimeSlotISCPInfo = -1;      /* DL_TimeslotISCPInfo */
static int hf_nbap_Additional_HS_Cell_Information_Response_List_item = -1;  /* Additional_HS_Cell_Information_Response_ItemIEs */
static int hf_nbap_RL_InformationResponseList_RL_SetupRspFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_diversityIndication = -1;      /* DiversityIndication_RL_SetupRspFDD */
static int hf_nbap_not_Used_dSCH_InformationResponseList = -1;  /* NULL */
static int hf_nbap_sSDT_SupportIndicator = -1;    /* SSDT_SupportIndicator */
static int hf_nbap_combining = -1;                /* Combining_RL_SetupRspFDD */
static int hf_nbap_nonCombiningOrFirstRL = -1;    /* NonCombiningOrFirstRL_RL_SetupRspFDD */
static int hf_nbap_dCH_InformationResponse = -1;  /* DCH_InformationResponse */
static int hf_nbap_uL_TimeSlot_ISCP_Info = -1;    /* UL_TimeSlot_ISCP_Info */
static int hf_nbap_ul_PhysCH_SF_Variation = -1;   /* UL_PhysCH_SF_Variation */
static int hf_nbap_dCH_InformationResponseList = -1;  /* DCH_InformationResponseList_RL_SetupRspTDD */
static int hf_nbap_dSCH_InformationResponseList = -1;  /* DSCH_InformationResponseList_RL_SetupRspTDD */
static int hf_nbap_uSCH_InformationResponseList = -1;  /* USCH_InformationResponseList_RL_SetupRspTDD */
static int hf_nbap_uL_TimeSlot_ISCP_LCR_Info = -1;  /* UL_TimeSlot_ISCP_LCR_Info */
static int hf_nbap_generalCause = -1;             /* GeneralCauseList_RL_SetupFailureFDD */
static int hf_nbap_rLSpecificCause = -1;          /* RLSpecificCauseList_RL_SetupFailureFDD */
static int hf_nbap_unsuccessful_RL_InformationRespList_RL_SetupFailureFDD = -1;  /* Unsuccessful_RL_InformationRespList_RL_SetupFailureFDD */
static int hf_nbap_successful_RL_InformationRespList_RL_SetupFailureFDD = -1;  /* Successful_RL_InformationRespList_RL_SetupFailureFDD */
static int hf_nbap_Unsuccessful_RL_InformationRespList_RL_SetupFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Successful_RL_InformationRespList_RL_SetupFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_diversityIndication_01 = -1;   /* DiversityIndication_RL_SetupFailureFDD */
static int hf_nbap_not_Used_tFCI2_BearerInformationResponse = -1;  /* NULL */
static int hf_nbap_combining_01 = -1;             /* Combining_RL_SetupFailureFDD */
static int hf_nbap_nonCombiningOrFirstRL_01 = -1;  /* NonCombiningOrFirstRL_RL_SetupFailureFDD */
static int hf_nbap_generalCause_01 = -1;          /* GeneralCauseList_RL_SetupFailureTDD */
static int hf_nbap_rLSpecificCause_01 = -1;       /* RLSpecificCauseList_RL_SetupFailureTDD */
static int hf_nbap_unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD = -1;  /* Unsuccessful_RL_InformationRespItem_RL_SetupFailureTDD */
static int hf_nbap_Additional_HS_Cell_Information_RL_Addition_List_item = -1;  /* Additional_HS_Cell_Information_RL_Addition_ItemIEs */
static int hf_nbap_setup_Or_Addition_Of_EDCH_On_secondary_UL_Frequency = -1;  /* Setup_Or_Addition_Of_EDCH_On_secondary_UL_Frequency */
static int hf_nbap_addition = -1;                 /* Additional_EDCH_Cell_Information_To_Add_List */
static int hf_nbap_RL_InformationList_RL_AdditionRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_initialDL_TransmissionPower = -1;  /* DL_Power */
static int hf_nbap_maximumDL_Power = -1;          /* DL_Power */
static int hf_nbap_minimumDL_Power = -1;          /* DL_Power */
static int hf_nbap_not_Used_sSDT_CellIdentity = -1;  /* NULL */
static int hf_nbap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD_item = -1;  /* UL_CCTrCH_InformationItem_RL_AdditionRqstTDD */
static int hf_nbap_uL_DPCH_Information_01 = -1;   /* UL_DPCH_InformationList_RL_AdditionRqstTDD */
static int hf_nbap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD_item = -1;  /* DL_CCTrCH_InformationItem_RL_AdditionRqstTDD */
static int hf_nbap_dL_DPCH_Information_01 = -1;   /* DL_DPCH_InformationList_RL_AdditionRqstTDD */
static int hf_nbap_initial_DL_Transmission_Power = -1;  /* DL_Power */
static int hf_nbap_Additional_HS_Cell_Change_Information_Response_List_item = -1;  /* Additional_HS_Cell_Change_Information_Response_ItemIEs */
static int hf_nbap_hS_DSCH_Secondary_Serving_Cell_Change_Information_Response = -1;  /* HS_DSCH_Secondary_Serving_Cell_Change_Information_Response */
static int hf_nbap_RL_InformationResponseList_RL_AdditionRspFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_diversityIndication_02 = -1;   /* DiversityIndication_RL_AdditionRspFDD */
static int hf_nbap_combining_02 = -1;             /* Combining_RL_AdditionRspFDD */
static int hf_nbap_non_combining = -1;            /* Non_Combining_RL_AdditionRspFDD */
static int hf_nbap_dCH_Information = -1;          /* DCH_Information_RL_AdditionRspTDD */
static int hf_nbap_dSCH_InformationResponseList_01 = -1;  /* DSCH_InformationResponseList_RL_AdditionRspTDD */
static int hf_nbap_uSCH_InformationResponseList_01 = -1;  /* USCH_InformationResponseList_RL_AdditionRspTDD */
static int hf_nbap_diversityIndication_03 = -1;   /* DiversityIndication_RL_AdditionRspTDD */
static int hf_nbap_combining_03 = -1;             /* Combining_RL_AdditionRspTDD */
static int hf_nbap_non_Combining = -1;            /* Non_Combining_RL_AdditionRspTDD */
static int hf_nbap_uL_TimeSlot_ISCP_InfoLCR = -1;  /* UL_TimeSlot_ISCP_LCR_Info */
static int hf_nbap_generalCause_02 = -1;          /* GeneralCauseList_RL_AdditionFailureFDD */
static int hf_nbap_rLSpecificCause_02 = -1;       /* RLSpecificCauseList_RL_AdditionFailureFDD */
static int hf_nbap_unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD = -1;  /* Unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD */
static int hf_nbap_successful_RL_InformationRespList_RL_AdditionFailureFDD = -1;  /* Successful_RL_InformationRespList_RL_AdditionFailureFDD */
static int hf_nbap_Unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Successful_RL_InformationRespList_RL_AdditionFailureFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_diversityIndication_04 = -1;   /* DiversityIndication_RL_AdditionFailureFDD */
static int hf_nbap_combining_04 = -1;             /* Combining_RL_AdditionFailureFDD */
static int hf_nbap_non_Combining_01 = -1;         /* Non_Combining_RL_AdditionFailureFDD */
static int hf_nbap_generalCause_03 = -1;          /* GeneralCauseList_RL_AdditionFailureTDD */
static int hf_nbap_rLSpecificCause_03 = -1;       /* RLSpecificCauseList_RL_AdditionFailureTDD */
static int hf_nbap_unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD = -1;  /* Unsuccessful_RL_InformationRespItem_RL_AdditionFailureTDD */
static int hf_nbap_Additional_HS_Cell_Information_RL_Reconf_Prep_item = -1;  /* Additional_HS_Cell_Information_RL_Reconf_Prep_ItemIEs */
static int hf_nbap_hS_DSCH_Secondary_Serving_Information_To_Modify = -1;  /* HS_DSCH_Secondary_Serving_Information_To_Modify */
static int hf_nbap_hS_HS_DSCH_Secondary_Serving_Remove = -1;  /* HS_DSCH_Secondary_Serving_Remove */
static int hf_nbap_setup_Or_ConfigurationChange_Or_Removal_Of_EDCH_On_secondary_UL_Frequency = -1;  /* Setup_Or_ConfigurationChange_Or_Removal_Of_EDCH_On_secondary_UL_Frequency */
static int hf_nbap_not_Used_sSDT_CellIDLength = -1;  /* NULL */
static int hf_nbap_powerOffsetInformation_03 = -1;  /* PowerOffsetInformation_RL_ReconfPrepFDD */
static int hf_nbap_DCH_DeleteList_RL_ReconfPrepFDD_item = -1;  /* DCH_DeleteItem_RL_ReconfPrepFDD */
static int hf_nbap_RL_InformationList_RL_ReconfPrepFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_maxDL_Power = -1;              /* DL_Power */
static int hf_nbap_minDL_Power = -1;              /* DL_Power */
static int hf_nbap_not_Used_sSDT_Indication = -1;  /* NULL */
static int hf_nbap_powerOffsetInformation_04 = -1;  /* PowerOffsetInformation_F_DPCH_RL_ReconfPrepFDD */
static int hf_nbap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item = -1;  /* UL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD */
static int hf_nbap_ul_DPCH_InformationList = -1;  /* UL_DPCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_uL_Timeslot_InformationLCR = -1;  /* UL_TimeslotLCR_Information */
static int hf_nbap_MultipleRL_UL_DPCH_InformationAddList_RL_ReconfPrepTDD_item = -1;  /* MultipleRL_UL_DPCH_InformationAddListIE_RL_ReconfPrepTDD */
static int hf_nbap_ul_DPCH_InformationListLCR = -1;  /* UL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_ul_sir_target = -1;            /* UL_SIR */
static int hf_nbap_tDD_TPC_UplinkStepSize_LCR = -1;  /* TDD_TPC_UplinkStepSize_LCR */
static int hf_nbap_uL_Timeslot_Information768 = -1;  /* UL_Timeslot768_Information */
static int hf_nbap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item = -1;  /* UL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_ul_DPCH_InformationAddList = -1;  /* UL_DPCH_InformationModify_AddList_RL_ReconfPrepTDD */
static int hf_nbap_ul_DPCH_InformationModifyList = -1;  /* UL_DPCH_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_ul_DPCH_InformationDeleteList = -1;  /* UL_DPCH_InformationModify_DeleteList_RL_ReconfPrepTDD */
static int hf_nbap_uL_Timeslot_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;  /* UL_Timeslot_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_UL_Timeslot_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* UL_Timeslot_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_uL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;  /* UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* UL_Code_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_UL_TimeslotLCR_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* UL_Timeslot_LCR_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_uL_Code_InformationModify_ModifyList_RL_ReconfPrepTDDLCR = -1;  /* UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDDLCR */
static int hf_nbap_UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDDLCR_item = -1;  /* UL_Code_InformationModify_ModifyItem_RL_ReconfPrepTDDLCR */
static int hf_nbap_UL_Timeslot768_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* UL_Timeslot_768_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_uL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD768 = -1;  /* UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD768 */
static int hf_nbap_UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD768_item = -1;  /* UL_Code_InformationModify_ModifyItem_RL_ReconfPrepTDD768 */
static int hf_nbap_UL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD_item = -1;  /* UL_DPCH_InformationModify_DeleteItem_RL_ReconfPrepTDD */
static int hf_nbap_MultipleRL_UL_DPCH_InformationModifyList_RL_ReconfPrepTDD_item = -1;  /* MultipleRL_UL_DPCH_InformationModifyListIE_RL_ReconfPrepTDD */
static int hf_nbap_ul_DPCH_InformationAddListLCR = -1;  /* UL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD */
static int hf_nbap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item = -1;  /* UL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD */
static int hf_nbap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD_item = -1;  /* DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD */
static int hf_nbap_cCTrCH_TPCList_01 = -1;        /* CCTrCH_TPCAddList_RL_ReconfPrepTDD */
static int hf_nbap_dl_DPCH_InformationList = -1;  /* DL_DPCH_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_CCTrCH_TPCAddList_RL_ReconfPrepTDD_item = -1;  /* CCTrCH_TPCAddItem_RL_ReconfPrepTDD */
static int hf_nbap_dL_Timeslot_InformationLCR = -1;  /* DL_TimeslotLCR_Information */
static int hf_nbap_MultipleRL_DL_DPCH_InformationAddList_RL_ReconfPrepTDD_item = -1;  /* MultipleRL_DL_DPCH_InformationAddListIE_RL_ReconfPrepTDD */
static int hf_nbap_dl_DPCH_InformationListLCR = -1;  /* DL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD */
static int hf_nbap_cCTrCH_Initial_DL_Power = -1;  /* DL_Power */
static int hf_nbap_tDD_TPC_DownlinkStepSize = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_nbap_cCTrCH_Maximum_DL_Power_InformationAdd_RL_ReconfPrepTDD = -1;  /* DL_Power */
static int hf_nbap_cCTrCH_Minimum_DL_Power_InformationAdd_RL_ReconfPrepTDD = -1;  /* DL_Power */
static int hf_nbap_dL_Timeslot_Information768 = -1;  /* DL_Timeslot768_Information */
static int hf_nbap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD_item = -1;  /* DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_cCTrCH_TPCList_02 = -1;        /* CCTrCH_TPCModifyList_RL_ReconfPrepTDD */
static int hf_nbap_dl_DPCH_InformationAddList = -1;  /* DL_DPCH_InformationModify_AddList_RL_ReconfPrepTDD */
static int hf_nbap_dl_DPCH_InformationModifyList = -1;  /* DL_DPCH_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_dl_DPCH_InformationDeleteList = -1;  /* DL_DPCH_InformationModify_DeleteList_RL_ReconfPrepTDD */
static int hf_nbap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD_item = -1;  /* CCTrCH_TPCModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_dL_Timeslot_InformationAddModify_ModifyList_RL_ReconfPrepTDD = -1;  /* DL_Timeslot_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DL_Timeslot_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DL_Timeslot_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_dL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;  /* DL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DL_Code_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DL_Timeslot_LCR_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_dL_Code_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;  /* DL_Code_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DL_Code_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DL_Code_LCR_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_DL_Timeslot_768_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DL_Timeslot_768_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_dL_Code_768_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;  /* DL_Code_768_InformationModify_ModifyList_RL_ReconfPrepTDD */
static int hf_nbap_DL_Code_768_InformationModify_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DL_Code_768_InformationModify_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_dPCH_ID768 = -1;               /* DPCH_ID768 */
static int hf_nbap_DL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD_item = -1;  /* DL_DPCH_InformationModify_DeleteItem_RL_ReconfPrepTDD */
static int hf_nbap_MultipleRL_DL_DPCH_InformationModifyList_RL_ReconfPrepTDD_item = -1;  /* MultipleRL_DL_DPCH_InformationModifyListIE_RL_ReconfPrepTDD */
static int hf_nbap_dl_DPCH_InformationAddListLCR = -1;  /* DL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD */
static int hf_nbap_tDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD = -1;  /* TDD_TPC_DownlinkStepSize */
static int hf_nbap_cCTrCH_Maximum_DL_Power_InformationModify_RL_ReconfPrepTDD = -1;  /* DL_Power */
static int hf_nbap_cCTrCH_Minimum_DL_Power_InformationModify_RL_ReconfPrepTDD = -1;  /* DL_Power */
static int hf_nbap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD_item = -1;  /* DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD */
static int hf_nbap_DCH_DeleteList_RL_ReconfPrepTDD_item = -1;  /* DCH_DeleteItem_RL_ReconfPrepTDD */
static int hf_nbap_DSCH_Information_ModifyList_RL_ReconfPrepTDD_item = -1;  /* DSCH_Information_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_DSCH_Information_DeleteList_RL_ReconfPrepTDD_item = -1;  /* DSCH_Information_DeleteItem_RL_ReconfPrepTDD */
static int hf_nbap_USCH_Information_ModifyList_RL_ReconfPrepTDD_item = -1;  /* USCH_Information_ModifyItem_RL_ReconfPrepTDD */
static int hf_nbap_USCH_Information_DeleteList_RL_ReconfPrepTDD_item = -1;  /* USCH_Information_DeleteItem_RL_ReconfPrepTDD */
static int hf_nbap_MultipleRL_Information_RL_ReconfPrepTDD_item = -1;  /* RL_Information_RL_ReconfPrepTDD */
static int hf_nbap_RL_InformationResponseList_RL_ReconfReady_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_dCH_InformationResponseList_RL_ReconfReady = -1;  /* DCH_InformationResponseList_RL_ReconfReady */
static int hf_nbap_dSCH_InformationResponseList_RL_ReconfReady = -1;  /* DSCH_InformationResponseList_RL_ReconfReady */
static int hf_nbap_uSCH_InformationResponseList_RL_ReconfReady = -1;  /* USCH_InformationResponseList_RL_ReconfReady */
static int hf_nbap_generalCause_04 = -1;          /* GeneralCauseList_RL_ReconfFailure */
static int hf_nbap_rLSpecificCause_04 = -1;       /* RLSpecificCauseList_RL_ReconfFailure */
static int hf_nbap_rL_ReconfigurationFailureList_RL_ReconfFailure = -1;  /* RL_ReconfigurationFailureList_RL_ReconfFailure */
static int hf_nbap_RL_ReconfigurationFailureList_RL_ReconfFailure_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Additional_HS_Cell_Information_RL_Reconf_Req_item = -1;  /* Additional_HS_Cell_Information_RL_Reconf_Req_ItemIEs */
static int hf_nbap_hS_DSCH_FDD_Secondary_Serving_Information_To_Modify_Unsynchronised = -1;  /* HS_DSCH_FDD_Secondary_Serving_Information_To_Modify_Unsynchronised */
static int hf_nbap_hS_DSCH_Secondary_Serving_Remove = -1;  /* HS_DSCH_Secondary_Serving_Remove */
static int hf_nbap_ul_TFCS = -1;                  /* TFCS */
static int hf_nbap_dl_TFCS = -1;                  /* TFCS */
static int hf_nbap_DCH_DeleteList_RL_ReconfRqstFDD_item = -1;  /* DCH_DeleteItem_RL_ReconfRqstFDD */
static int hf_nbap_RL_InformationList_RL_ReconfRqstFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_MultipleRL_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD_item = -1;  /* MultipleRL_DL_CCTrCH_InformationModifyListIE_RL_ReconfRqstTDD */
static int hf_nbap_dl_DPCH_LCR_InformationModifyList = -1;  /* DL_DPCH_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD */
static int hf_nbap_cCTrCH_Maximum_DL_Power_InformationModify_RL_ReconfRqstTDD = -1;  /* DL_Power */
static int hf_nbap_cCTrCH_Minimum_DL_Power_InformationModify_RL_ReconfRqstTDD = -1;  /* DL_Power */
static int hf_nbap_dL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD = -1;  /* DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD */
static int hf_nbap_DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD_item = -1;  /* DL_Timeslot_LCR_InformationModify_ModifyItem_RL_ReconfRqstTDD */
static int hf_nbap_maxPowerLCR = -1;              /* DL_Power */
static int hf_nbap_minPowerLCR = -1;              /* DL_Power */
static int hf_nbap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_DCH_DeleteList_RL_ReconfRqstTDD_item = -1;  /* DCH_DeleteItem_RL_ReconfRqstTDD */
static int hf_nbap_Multiple_RL_Information_RL_ReconfRqstTDD_item = -1;  /* RL_Information_RL_ReconfRqstTDD */
static int hf_nbap_RL_InformationResponseList_RL_ReconfRsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_dCH_InformationResponseList_RL_ReconfRsp = -1;  /* DCH_InformationResponseList_RL_ReconfRsp */
static int hf_nbap_RL_informationList_RL_DeletionRqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_DL_ReferencePowerInformationList_DL_PC_Rqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_dl_ReferencePower = -1;        /* DL_Power */
static int hf_nbap_rL = -1;                       /* RL_DM_Rqst */
static int hf_nbap_rLS = -1;                      /* RL_Set_DM_Rqst */
static int hf_nbap_all_RL = -1;                   /* AllRL_DM_Rqst */
static int hf_nbap_all_RLS = -1;                  /* AllRL_Set_DM_Rqst */
static int hf_nbap_rL_InformationList = -1;       /* RL_InformationList_DM_Rqst */
static int hf_nbap_RL_InformationList_DM_Rqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_PUSCH_Info_DM_Rqst_item = -1;  /* PUSCH_ID */
static int hf_nbap_HSSICH_Info_DM_Rqst_item = -1;  /* HS_SICH_ID */
static int hf_nbap_HSSICH_InfoExt_DM_Rqst_item = -1;  /* Extended_HS_SICH_ID */
static int hf_nbap_rL_Set_InformationList_DM_Rqst = -1;  /* RL_Set_InformationList_DM_Rqst */
static int hf_nbap_RL_Set_InformationList_DM_Rqst_item = -1;  /* RL_Set_InformationItem_DM_Rqst */
static int hf_nbap_rL_01 = -1;                    /* RL_DM_Rsp */
static int hf_nbap_rLS_01 = -1;                   /* RL_Set_DM_Rsp */
static int hf_nbap_all_RL_01 = -1;                /* RL_DM_Rsp */
static int hf_nbap_all_RLS_01 = -1;               /* RL_Set_DM_Rsp */
static int hf_nbap_rL_InformationList_DM_Rsp = -1;  /* RL_InformationList_DM_Rsp */
static int hf_nbap_RL_InformationList_DM_Rsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_dedicatedMeasurementValue = -1;  /* DedicatedMeasurementValue */
static int hf_nbap_PUSCH_Info_DM_Rsp_item = -1;   /* PUSCH_ID */
static int hf_nbap_Multiple_PUSCH_InfoList_DM_Rsp_item = -1;  /* Multiple_PUSCH_InfoListIE_DM_Rsp */
static int hf_nbap_pUSCH_ID = -1;                 /* PUSCH_ID */
static int hf_nbap_Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp_item = -1;  /* Multiple_DedicatedMeasurementValueItem_TDD_DM_Rsp */
static int hf_nbap_Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp_item = -1;  /* Multiple_DedicatedMeasurementValueItem_LCR_TDD_DM_Rsp */
static int hf_nbap_Multiple_HSSICHMeasurementValueList_TDD_DM_Rsp_item = -1;  /* Multiple_HSSICHMeasurementValueItem_TDD_DM_Rsp */
static int hf_nbap_Multiple_DedicatedMeasurementValueList_768_TDD_DM_Rsp_item = -1;  /* Multiple_DedicatedMeasurementValueItem_768_TDD_DM_Rsp */
static int hf_nbap_rL_Set_InformationList_DM_Rsp = -1;  /* RL_Set_InformationList_DM_Rsp */
static int hf_nbap_RL_Set_InformationList_DM_Rsp_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_rL_02 = -1;                    /* RL_DM_Rprt */
static int hf_nbap_rLS_02 = -1;                   /* RL_Set_DM_Rprt */
static int hf_nbap_all_RL_02 = -1;                /* RL_DM_Rprt */
static int hf_nbap_all_RLS_02 = -1;               /* RL_Set_DM_Rprt */
static int hf_nbap_rL_InformationList_DM_Rprt = -1;  /* RL_InformationList_DM_Rprt */
static int hf_nbap_RL_InformationList_DM_Rprt_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_dedicatedMeasurementValueInformation = -1;  /* DedicatedMeasurementValueInformation */
static int hf_nbap_PUSCH_Info_DM_Rprt_item = -1;  /* PUSCH_ID */
static int hf_nbap_Multiple_PUSCH_InfoList_DM_Rprt_item = -1;  /* Multiple_PUSCH_InfoListIE_DM_Rprt */
static int hf_nbap_rL_Set_InformationList_DM_Rprt = -1;  /* RL_Set_InformationList_DM_Rprt */
static int hf_nbap_RL_Set_InformationList_DM_Rprt_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_rL_03 = -1;                    /* RL_RL_FailureInd */
static int hf_nbap_rL_Set = -1;                   /* RL_Set_RL_FailureInd */
static int hf_nbap_cCTrCH = -1;                   /* CCTrCH_RL_FailureInd */
static int hf_nbap_rL_InformationList_RL_FailureInd = -1;  /* RL_InformationList_RL_FailureInd */
static int hf_nbap_RL_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_rL_Set_InformationList_RL_FailureInd = -1;  /* RL_Set_InformationList_RL_FailureInd */
static int hf_nbap_RL_Set_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_cCTrCH_InformationList_RL_FailureInd = -1;  /* CCTrCH_InformationList_RL_FailureInd */
static int hf_nbap_CCTrCH_InformationList_RL_FailureInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_RL_InformationList_RL_PreemptRequiredInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_rL_04 = -1;                    /* RL_RL_RestoreInd */
static int hf_nbap_rL_Set_01 = -1;                /* RL_Set_RL_RestoreInd */
static int hf_nbap_cCTrCH_01 = -1;                /* CCTrCH_RL_RestoreInd */
static int hf_nbap_rL_InformationList_RL_RestoreInd = -1;  /* RL_InformationList_RL_RestoreInd */
static int hf_nbap_RL_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_rL_Set_InformationList_RL_RestoreInd = -1;  /* RL_Set_InformationList_RL_RestoreInd */
static int hf_nbap_RL_Set_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_cCTrCH_InformationList_RL_RestoreInd = -1;  /* CCTrCH_InformationList_RL_RestoreInd */
static int hf_nbap_CCTrCH_InformationList_RL_RestoreInd_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_privateIEs = -1;               /* PrivateIE_Container */
static int hf_nbap_HSDPA_And_EDCH_CellPortion_InformationList_PSCH_ReconfRqst_item = -1;  /* HSDPA_And_EDCH_CellPortion_InformationItem_PSCH_ReconfRqst */
static int hf_nbap_hS_PDSCH_HS_SCCH_ScramblingCode_PSCH_ReconfRqst = -1;  /* DL_ScramblingCode */
static int hf_nbap_hS_PDSCH_FDD_Code_Information_PSCH_ReconfRqst = -1;  /* HS_PDSCH_FDD_Code_Information */
static int hf_nbap_hS_SCCH_FDD_Code_Information_PSCH_ReconfRqst = -1;  /* HS_SCCH_FDD_Code_Information */
static int hf_nbap_hS_PDSCH_HS_SCCH_E_AGCH_E_RGCH_E_HICH_MaxPower_PSCH_ReconfRqst = -1;  /* MaximumTransmissionPower */
static int hf_nbap_e_AGCH_FDD_Code_Information = -1;  /* E_AGCH_FDD_Code_Information */
static int hf_nbap_e_RGCH_E_HICH_FDD_Code_Information = -1;  /* E_RGCH_E_HICH_FDD_Code_Information */
static int hf_nbap_PDSCHSets_AddList_PSCH_ReconfRqst_item = -1;  /* PDSCHSets_AddItem_PSCH_ReconfRqst */
static int hf_nbap_pDSCHSet_ID = -1;              /* PDSCHSet_ID */
static int hf_nbap_pDSCH_InformationList = -1;    /* PDSCH_Information_AddList_PSCH_ReconfRqst */
static int hf_nbap_dL_Timeslot_InformationAddList_PSCH_ReconfRqst = -1;  /* DL_Timeslot_InformationAddList_PSCH_ReconfRqst */
static int hf_nbap_DL_Timeslot_InformationAddList_PSCH_ReconfRqst_item = -1;  /* DL_Timeslot_InformationAddItem_PSCH_ReconfRqst */
static int hf_nbap_dL_Code_InformationAddList_PSCH_ReconfRqst = -1;  /* DL_Code_InformationAddList_PSCH_ReconfRqst */
static int hf_nbap_DL_Code_InformationAddList_PSCH_ReconfRqst_item = -1;  /* DL_Code_InformationAddItem_PSCH_ReconfRqst */
static int hf_nbap_pDSCH_ID = -1;                 /* PDSCH_ID */
static int hf_nbap_dL_Timeslot_InformationAddList_LCR_PSCH_ReconfRqst = -1;  /* DL_Timeslot_InformationAddList_LCR_PSCH_ReconfRqst */
static int hf_nbap_DL_Timeslot_InformationAddList_LCR_PSCH_ReconfRqst_item = -1;  /* DL_Timeslot_InformationAddItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_dL_Code_InformationAddList_LCR_PSCH_ReconfRqst = -1;  /* DL_Code_InformationAddList_LCR_PSCH_ReconfRqst */
static int hf_nbap_DL_Code_InformationAddList_LCR_PSCH_ReconfRqst_item = -1;  /* DL_Code_InformationAddItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_dL_Timeslot_InformationAddList_768_PSCH_ReconfRqst = -1;  /* DL_Timeslot_InformationAddList_768_PSCH_ReconfRqst */
static int hf_nbap_DL_Timeslot_InformationAddList_768_PSCH_ReconfRqst_item = -1;  /* DL_Timeslot_InformationAddItem_768_PSCH_ReconfRqst */
static int hf_nbap_dL_Code_InformationAddList_768_PSCH_ReconfRqst = -1;  /* DL_Code_InformationAddList_768_PSCH_ReconfRqst */
static int hf_nbap_DL_Code_InformationAddList_768_PSCH_ReconfRqst_item = -1;  /* DL_Code_InformationAddItem_768_PSCH_ReconfRqst */
static int hf_nbap_pDSCH_ID768 = -1;              /* PDSCH_ID768 */
static int hf_nbap_PDSCHSets_ModifyList_PSCH_ReconfRqst_item = -1;  /* PDSCHSets_ModifyItem_PSCH_ReconfRqst */
static int hf_nbap_pDSCH_InformationList_01 = -1;  /* PDSCH_Information_ModifyList_PSCH_ReconfRqst */
static int hf_nbap_dL_Timeslot_InformationModifyList_PSCH_ReconfRqst = -1;  /* DL_Timeslot_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_DL_Timeslot_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* DL_Timeslot_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_dL_Code_InformationModifyList_PSCH_ReconfRqst = -1;  /* DL_Code_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_DL_Code_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* DL_Code_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_dL_Timeslot_LCR_InformationModifyList_PSCH_ReconfRqst = -1;  /* DL_Timeslot_LCR_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_DL_Timeslot_LCR_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* DL_Timeslot_LCR_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_dL_Code_LCR_InformationModifyList_PSCH_ReconfRqst = -1;  /* DL_Code_LCR_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_DL_Code_LCR_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* DL_Code_LCR_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_dL_Timeslot_768_InformationModifyList_PSCH_ReconfRqst = -1;  /* DL_Timeslot_768_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_DL_Timeslot_768_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* DL_Timeslot_768_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_dL_Code_768_InformationModifyList_PSCH_ReconfRqst = -1;  /* DL_Code_768_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_DL_Code_768_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* DL_Code_768_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_PDSCHSets_DeleteList_PSCH_ReconfRqst_item = -1;  /* PDSCHSets_DeleteItem_PSCH_ReconfRqst */
static int hf_nbap_PUSCHSets_AddList_PSCH_ReconfRqst_item = -1;  /* PUSCHSets_AddItem_PSCH_ReconfRqst */
static int hf_nbap_pUSCHSet_ID = -1;              /* PUSCHSet_ID */
static int hf_nbap_pUSCH_InformationList = -1;    /* PUSCH_Information_AddList_PSCH_ReconfRqst */
static int hf_nbap_uL_Timeslot_InformationAddList_PSCH_ReconfRqst = -1;  /* UL_Timeslot_InformationAddList_PSCH_ReconfRqst */
static int hf_nbap_UL_Timeslot_InformationAddList_PSCH_ReconfRqst_item = -1;  /* UL_Timeslot_InformationAddItem_PSCH_ReconfRqst */
static int hf_nbap_uL_Code_InformationAddList_PSCH_ReconfRqst = -1;  /* UL_Code_InformationAddList_PSCH_ReconfRqst */
static int hf_nbap_UL_Code_InformationAddList_PSCH_ReconfRqst_item = -1;  /* UL_Code_InformationAddItem_PSCH_ReconfRqst */
static int hf_nbap_uL_Timeslot_InformationAddList_LCR_PSCH_ReconfRqst = -1;  /* UL_Timeslot_InformationAddList_LCR_PSCH_ReconfRqst */
static int hf_nbap_UL_Timeslot_InformationAddList_LCR_PSCH_ReconfRqst_item = -1;  /* UL_Timeslot_InformationAddItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_uL_Code_InformationAddList_LCR_PSCH_ReconfRqst = -1;  /* UL_Code_InformationAddList_LCR_PSCH_ReconfRqst */
static int hf_nbap_UL_Code_InformationAddList_LCR_PSCH_ReconfRqst_item = -1;  /* UL_Code_InformationAddItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_uL_Timeslot_InformationAddList_768_PSCH_ReconfRqst = -1;  /* UL_Timeslot_InformationAddList_768_PSCH_ReconfRqst */
static int hf_nbap_UL_Timeslot_InformationAddList_768_PSCH_ReconfRqst_item = -1;  /* UL_Timeslot_InformationAddItem_768_PSCH_ReconfRqst */
static int hf_nbap_uL_Code_InformationAddList_768_PSCH_ReconfRqst = -1;  /* UL_Code_InformationAddList_768_PSCH_ReconfRqst */
static int hf_nbap_UL_Code_InformationAddList_768_PSCH_ReconfRqst_item = -1;  /* UL_Code_InformationAddItem_768_PSCH_ReconfRqst */
static int hf_nbap_PUSCHSets_ModifyList_PSCH_ReconfRqst_item = -1;  /* PUSCHSets_ModifyItem_PSCH_ReconfRqst */
static int hf_nbap_pUSCH_InformationList_01 = -1;  /* PUSCH_Information_ModifyList_PSCH_ReconfRqst */
static int hf_nbap_uL_Timeslot_InformationModifyList_PSCH_ReconfRqst = -1;  /* UL_Timeslot_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_UL_Timeslot_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* UL_Timeslot_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_uL_Code_InformationModifyList_PSCH_ReconfRqst = -1;  /* UL_Code_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_UL_Code_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* UL_Code_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_uL_Timeslot_InformationModifyList_LCR_PSCH_ReconfRqst = -1;  /* UL_Timeslot_LCR_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_UL_Timeslot_LCR_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* UL_Timeslot_LCR_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_uL_Code_LCR_InformationModifyList_PSCH_ReconfRqst = -1;  /* UL_Code_LCR_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_UL_Code_LCR_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* UL_Code_LCR_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_uL_Timeslot_InformationModifyList_768_PSCH_ReconfRqst = -1;  /* UL_Timeslot_768_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_UL_Timeslot_768_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* UL_Timeslot_768_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_uL_Code_768_InformationModifyList_PSCH_ReconfRqst = -1;  /* UL_Code_768_InformationModifyList_PSCH_ReconfRqst */
static int hf_nbap_UL_Code_768_InformationModifyList_PSCH_ReconfRqst_item = -1;  /* UL_Code_768_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_PUSCHSets_DeleteList_PSCH_ReconfRqst_item = -1;  /* PUSCHSets_DeleteItem_PSCH_ReconfRqst */
static int hf_nbap_dL_HS_PDSCH_Timeslot_Information_PSCH_ReconfRqst = -1;  /* DL_HS_PDSCH_Timeslot_Information_PSCH_ReconfRqst */
static int hf_nbap_DL_HS_PDSCH_Timeslot_Information_PSCH_ReconfRqst_item = -1;  /* DL_HS_PDSCH_Timeslot_InformationItem_PSCH_ReconfRqst */
static int hf_nbap_dl_HS_PDSCH_Codelist_PSCH_ReconfRqst = -1;  /* DL_HS_PDSCH_Codelist_PSCH_ReconfRqst */
static int hf_nbap_DL_HS_PDSCH_Codelist_PSCH_ReconfRqst_item = -1;  /* TDD_ChannelisationCode */
static int hf_nbap_DL_HS_PDSCH_Timeslot_Information_768_PSCH_ReconfRqst_item = -1;  /* DL_HS_PDSCH_Timeslot_InformationItem_768_PSCH_ReconfRqst */
static int hf_nbap_dl_HS_PDSCH_Codelist_768_PSCH_ReconfRqst = -1;  /* DL_HS_PDSCH_Codelist_768_PSCH_ReconfRqst */
static int hf_nbap_DL_HS_PDSCH_Codelist_768_PSCH_ReconfRqst_item = -1;  /* TDD_ChannelisationCode768 */
static int hf_nbap_MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_hS_SCCH_Information_PSCH_ReconfRqst = -1;  /* HS_SCCH_Information_PSCH_ReconfRqst */
static int hf_nbap_hS_SCCH_Information_LCR_PSCH_ReconfRqst = -1;  /* HS_SCCH_Information_LCR_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_Information_PSCH_ReconfRqst_item = -1;  /* HS_SCCH_InformationItem_PSCH_ReconfRqst */
static int hf_nbap_hS_SCCH_ID = -1;               /* HS_SCCH_ID */
static int hf_nbap_hS_SCCH_MaxPower = -1;         /* DL_Power */
static int hf_nbap_hS_SICH_Information = -1;      /* HS_SICH_Information_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_Information_LCR_PSCH_ReconfRqst_item = -1;  /* HS_SCCH_InformationItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_hS_SICH_Information_LCR = -1;  /* HS_SICH_Information_LCR_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_Information_768_PSCH_ReconfRqst_item = -1;  /* HS_SCCH_InformationItem_768_PSCH_ReconfRqst */
static int hf_nbap_hS_SICH_Information_768 = -1;  /* HS_SICH_Information_768_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_InformationExt_LCR_PSCH_ReconfRqst_item = -1;  /* HS_SCCH_InformationItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_hS_SCCH_InformationModify_PSCH_ReconfRqst = -1;  /* HS_SCCH_InformationModify_PSCH_ReconfRqst */
static int hf_nbap_hS_SCCH_InformationModify_LCR_PSCH_ReconfRqst = -1;  /* HS_SCCH_InformationModify_LCR_PSCH_ReconfRqst */
static int hf_nbap_hS_SICH_Information_01 = -1;   /* HS_SICH_InformationModify_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_InformationModify_LCR_PSCH_ReconfRqst_item = -1;  /* HS_SCCH_InformationModifyItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_hS_SICH_Information_LCR_01 = -1;  /* HS_SICH_InformationModify_LCR_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_InformationModifyExt_LCR_PSCH_ReconfRqst_item = -1;  /* HS_SCCH_InformationModifyItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_InformationModify_768_PSCH_ReconfRqst_item = -1;  /* HS_SCCH_InformationModifyItem_768_PSCH_ReconfRqst */
static int hf_nbap_hS_SICH_Information_768_01 = -1;  /* HS_SICH_InformationModify_768_PSCH_ReconfRqst */
static int hf_nbap_HS_SCCH_InformationModify_PSCH_ReconfRqst_item = -1;  /* HS_SCCH_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_Delete_From_HS_SCCH_Resource_Pool_PSCH_ReconfRqst_item = -1;  /* Delete_From_HS_SCCH_Resource_PoolItem_PSCH_ReconfRqst */
static int hf_nbap_lTGI_Presence = -1;            /* LTGI_Presence */
static int hf_nbap_sNPL_Reporting_Type = -1;      /* SNPL_Reporting_Type */
static int hf_nbap_e_PUCH_Timeslot_Info = -1;     /* E_PUCH_Timeslot_Info */
static int hf_nbap_E_PUCH_Timeslot_Info_item = -1;  /* TimeSlot */
static int hf_nbap_e_AGCH_Information_PSCH_ReconfRqst = -1;  /* E_AGCH_Information_PSCH_ReconfRqst */
static int hf_nbap_E_AGCH_Information_PSCH_ReconfRqst_item = -1;  /* E_AGCH_InformationItem_PSCH_ReconfRqst */
static int hf_nbap_e_AGCH_MaxPower = -1;          /* DL_Power */
static int hf_nbap_e_AGCH_InformationModify_PSCH_ReconfRqst = -1;  /* E_AGCH_InformationModify_PSCH_ReconfRqst */
static int hf_nbap_E_AGCH_InformationModify_PSCH_ReconfRqst_item = -1;  /* E_AGCH_InformationModifyItem_PSCH_ReconfRqst */
static int hf_nbap_Delete_From_E_AGCH_Resource_Pool_PSCH_ReconfRqst_item = -1;  /* Delete_From_E_AGCH_Resource_PoolItem_PSCH_ReconfRqst */
static int hf_nbap_e_HICH_MaxPower = -1;          /* DL_Power */
static int hf_nbap_e_AGCH_Information_768_PSCH_ReconfRqst = -1;  /* E_AGCH_Information_768_PSCH_ReconfRqst */
static int hf_nbap_E_AGCH_Information_768_PSCH_ReconfRqst_item = -1;  /* E_AGCH_InformationItem_768_PSCH_ReconfRqst */
static int hf_nbap_e_AGCH_InformationModify_768_PSCH_ReconfRqst = -1;  /* E_AGCH_InformationModify_768_PSCH_ReconfRqst */
static int hf_nbap_E_AGCH_InformationModify_768_PSCH_ReconfRqst_item = -1;  /* E_AGCH_InformationModifyItem_768_PSCH_ReconfRqst */
static int hf_nbap_e_PUCH_Timeslot_InfoLCR = -1;  /* E_PUCH_Timeslot_InfoLCR */
static int hf_nbap_E_PUCH_Timeslot_InfoLCR_item = -1;  /* E_PUCH_Timeslot_Item_InfoLCR */
static int hf_nbap_e_PUCH_Codelist_LCR = -1;      /* E_PUCH_Codelist_LCR */
static int hf_nbap_E_PUCH_Codelist_LCR_item = -1;  /* TDD_ChannelisationCode */
static int hf_nbap_e_AGCH_Information_LCR_PSCH_ReconfRqst = -1;  /* E_AGCH_Information_LCR_PSCH_ReconfRqst */
static int hf_nbap_E_AGCH_Information_LCR_PSCH_ReconfRqst_item = -1;  /* E_AGCH_InformationItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_e_AGCH_InformationModify_LCR_PSCH_ReconfRqst = -1;  /* E_AGCH_InformationModify_LCR_PSCH_ReconfRqst */
static int hf_nbap_E_AGCH_InformationModify_LCR_PSCH_ReconfRqst_item = -1;  /* E_AGCH_InformationModifyItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_e_HICH_Information_LCR_PSCH_ReconfRqst = -1;  /* E_HICH_Information_LCR_PSCH_ReconfRqst */
static int hf_nbap_E_HICH_Information_LCR_PSCH_ReconfRqst_item = -1;  /* E_HICH_InformationItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_e_HICH_Type = -1;              /* E_HICH_Type */
static int hf_nbap_e_HICH_InformationModify_LCR_PSCH_ReconfRqst = -1;  /* E_HICH_InformationModify_LCR_PSCH_ReconfRqst */
static int hf_nbap_E_HICH_InformationModify_LCR_PSCH_ReconfRqst_item = -1;  /* E_HICH_InformationModifyItem_LCR_PSCH_ReconfRqst */
static int hf_nbap_Delete_From_E_HICH_Resource_Pool_PSCH_ReconfRqst_item = -1;  /* Delete_From_E_HICH_Resource_PoolItem_PSCH_ReconfRqst */
static int hf_nbap_eRUCCH_SYNC_UL_codes_bitmap = -1;  /* BIT_STRING_SIZE_8 */
static int hf_nbap_Delete_From_HS_SCCH_Resource_PoolExt_PSCH_ReconfRqst_item = -1;  /* Delete_From_HS_SCCH_Resource_PoolItem_PSCH_ReconfRqst */
static int hf_nbap_MultipleFreq_E_PUCH_Timeslot_InformationList_LCR_PSCH_ReconfRqst_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Max_RTWP_perUARFCN_Information_LCR_PSCH_ReconfRqst_item = -1;  /* Max_RTWP_perUARFCN_Information_LCR_PSCH_ReconfRqst_Item */
static int hf_nbap_maximum_Target_ReceivedTotalWideBandPower_LCR = -1;  /* Maximum_Target_ReceivedTotalWideBandPower_LCR */
static int hf_nbap_E_HICH_TimeOffset_ExtensionLCR_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_e_HICH_TimeOffsetLCR = -1;     /* E_HICH_TimeOffsetLCR */
static int hf_nbap_generalCause_05 = -1;          /* GeneralCauseList_PSCH_ReconfFailure */
static int hf_nbap_setSpecificCause = -1;         /* SetSpecificCauseList_PSCH_ReconfFailureTDD */
static int hf_nbap_extension_CauseLevel_PSCH_ReconfFailure = -1;  /* Extension_CauseLevel_PSCH_ReconfFailure */
static int hf_nbap_unsuccessful_PDSCHSetList_PSCH_ReconfFailureTDD = -1;  /* Unsuccessful_PDSCHSetList_PSCH_ReconfFailureTDD */
static int hf_nbap_unsuccessful_PUSCHSetList_PSCH_ReconfFailureTDD = -1;  /* Unsuccessful_PUSCHSetList_PSCH_ReconfFailureTDD */
static int hf_nbap_Unsuccessful_PDSCHSetList_PSCH_ReconfFailureTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Unsuccessful_PUSCHSetList_PSCH_ReconfFailureTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_UARFCNSpecificCauseList_PSCH_ReconfFailureTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_E_HICH_TimeOffset_ReconfFailureTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_hSDSCH_Common_System_Information_ResponseLCR = -1;  /* HSDSCH_Common_System_Information_ResponseLCR */
static int hf_nbap_hSDSCH_Paging_System_Information_ResponseLCR = -1;  /* HSDSCH_Paging_System_Information_ResponseLCR */
static int hf_nbap_common_EDCH_System_Information_ResponseLCR = -1;  /* Common_EDCH_System_Information_ResponseLCR */
static int hf_nbap_communicationContext = -1;     /* CommunicationContextList_Reset */
static int hf_nbap_communicationControlPort = -1;  /* CommunicationControlPortList_Reset */
static int hf_nbap_nodeB = -1;                    /* NULL */
static int hf_nbap_communicationContextInfoList_Reset = -1;  /* CommunicationContextInfoList_Reset */
static int hf_nbap_CommunicationContextInfoList_Reset_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_communicationContextType_Reset = -1;  /* CommunicationContextType_Reset */
static int hf_nbap_nodeB_CommunicationContextID = -1;  /* NodeB_CommunicationContextID */
static int hf_nbap_communicationControlPortInfoList_Reset = -1;  /* CommunicationControlPortInfoList_Reset */
static int hf_nbap_CommunicationControlPortInfoList_Reset_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_cell_03 = -1;                  /* Cell_InfEx_Rqst */
static int hf_nbap_cell_04 = -1;                  /* Cell_InfEx_Rsp */
static int hf_nbap_requestedDataValue = -1;       /* RequestedDataValue */
static int hf_nbap_cell_05 = -1;                  /* Cell_Inf_Rprt */
static int hf_nbap_requestedDataValueInformation = -1;  /* RequestedDataValueInformation */
static int hf_nbap_TimeslotInfo_CellSyncInitiationRqstTDD_item = -1;  /* TimeSlot */
static int hf_nbap_cSBTransmissionID = -1;        /* CSBTransmissionID */
static int hf_nbap_sfn = -1;                      /* SFN */
static int hf_nbap_initialDLTransPower = -1;      /* DL_Power */
static int hf_nbap_cSBMeasurementID = -1;         /* CSBMeasurementID */
static int hf_nbap_synchronisationReportType = -1;  /* SynchronisationReportType */
static int hf_nbap_synchronisationReportCharacteristics = -1;  /* SynchronisationReportCharacteristics */
static int hf_nbap_sYNCDlCodeId = -1;             /* SYNCDlCodeId */
static int hf_nbap_CellSyncBurstTransReconfInfo_CellSyncReconfRqstTDD_item = -1;  /* CellSyncBurstTransInfoItem_CellSyncReconfRqstTDD */
static int hf_nbap_syncFrameNumberToTransmit = -1;  /* SyncFrameNumber */
static int hf_nbap_dlTransPower = -1;             /* DL_Power */
static int hf_nbap_cellSyncBurstMeasInfoList_CellSyncReconfRqstTDD = -1;  /* CellSyncBurstMeasInfoList_CellSyncReconfRqstTDD */
static int hf_nbap_synchronisationReportType_01 = -1;  /* SynchronisationReportTypeIE */
static int hf_nbap_synchronisationReportCharacteristics_01 = -1;  /* SynchronisationReportCharacteristicsIE */
static int hf_nbap_CellSyncBurstMeasInfoListIE_CellSyncReconfRqstTDD_item = -1;  /* CellSyncBurstMeasInfoItem_CellSyncReconfRqstTDD */
static int hf_nbap_syncFrameNrToReceive = -1;     /* SyncFrameNumber */
static int hf_nbap_syncBurstInfo = -1;            /* CellSyncBurstInfoList_CellSyncReconfRqstTDD */
static int hf_nbap_CellSyncBurstInfoList_CellSyncReconfRqstTDD_item = -1;  /* CellSyncBurstInfoItem_CellSyncReconfRqstTDD */
static int hf_nbap_SYNCDlCodeIdTransReconfInfoLCR_CellSyncReconfRqstTDD_item = -1;  /* SYNCDlCodeIdTransReconfItemLCR_CellSyncReconfRqstTDD */
static int hf_nbap_syncFrameNumberforTransmit = -1;  /* SyncFrameNumber */
static int hf_nbap_sYNCDlCodeIdMeasInfoList = -1;  /* SYNCDlCodeIdMeasInfoList_CellSyncReconfRqstTDD */
static int hf_nbap_SYNCDlCodeIdMeasInfoList_CellSyncReconfRqstTDD_item = -1;  /* SYNCDlCodeIdMeasInfoItem_CellSyncReconfRqstTDD */
static int hf_nbap_sYNCDlCodeIdInfoLCR = -1;      /* SYNCDlCodeIdInfoListLCR_CellSyncReconfRqstTDD */
static int hf_nbap_SYNCDlCodeIdInfoListLCR_CellSyncReconfRqstTDD_item = -1;  /* SYNCDlCodeIdInfoItemLCR_CellSyncReconfRqstTDD */
static int hf_nbap_propagationDelayCompensation = -1;  /* TimingAdjustmentValueLCR */
static int hf_nbap_CellAdjustmentInfo_SyncAdjustmentRqstTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_frameAdjustmentValue = -1;     /* FrameAdjustmentValue */
static int hf_nbap_timingAdjustmentValue = -1;    /* TimingAdjustmentValue */
static int hf_nbap_dLTransPower = -1;             /* DL_Power */
static int hf_nbap_generalCause_06 = -1;          /* GeneralCauseList_SyncAdjustmntFailureTDD */
static int hf_nbap_cellSpecificCause = -1;        /* CellSpecificCauseList_SyncAdjustmntFailureTDD */
static int hf_nbap_unsuccessful_cell_InformationRespList_SyncAdjustmntFailureTDD = -1;  /* Unsuccessful_cell_InformationRespList_SyncAdjustmntFailureTDD */
static int hf_nbap_Unsuccessful_cell_InformationRespList_SyncAdjustmntFailureTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_CellSyncInfo_CellSyncReprtTDD_item = -1;  /* CellSyncInfoItemIE_CellSyncReprtTDD */
static int hf_nbap_c_ID_CellSyncReprtTDD = -1;    /* C_ID_IE_CellSyncReprtTDD */
static int hf_nbap_syncReportType_CellSyncReprtTDD = -1;  /* SyncReportTypeIE_CellSyncReprtTDD */
static int hf_nbap_intStdPhSyncInfo_CellSyncReprtTDD = -1;  /* IntStdPhCellSyncInfo_CellSyncReprtTDD */
static int hf_nbap_lateEntrantCell = -1;          /* NULL */
static int hf_nbap_frequencyAcquisition = -1;     /* NULL */
static int hf_nbap_cellSyncBurstMeasuredInfo = -1;  /* CellSyncBurstMeasInfoList_CellSyncReprtTDD */
static int hf_nbap_CellSyncBurstMeasInfoList_CellSyncReprtTDD_item = -1;  /* CellSyncBurstMeasInfoItem_CellSyncReprtTDD */
static int hf_nbap_cellSyncBurstInfo_CellSyncReprtTDD = -1;  /* SEQUENCE_SIZE_1_maxNrOfReceptsPerSyncFrame_OF_CellSyncBurstInfo_CellSyncReprtTDD */
static int hf_nbap_cellSyncBurstInfo_CellSyncReprtTDD_item = -1;  /* CellSyncBurstInfo_CellSyncReprtTDD */
static int hf_nbap_cellSyncBurstAvailable = -1;   /* CellSyncBurstAvailable_CellSyncReprtTDD */
static int hf_nbap_cellSyncBurstNotAvailable = -1;  /* NULL */
static int hf_nbap_cellSyncBurstSIR = -1;         /* CellSyncBurstSIR */
static int hf_nbap_SyncDLCodeIdsMeasInfoList_CellSyncReprtTDD_item = -1;  /* SyncDLCodeIdsMeasInfoItem_CellSyncReprtTDD */
static int hf_nbap_syncDLCodeIdInfo_CellSyncReprtTDD = -1;  /* SyncDLCodeIdInfo_CellSyncReprtTDD */
static int hf_nbap_SyncDLCodeIdInfo_CellSyncReprtTDD_item = -1;  /* SyncDLCodeIdItem_CellSyncReprtTDD */
static int hf_nbap_syncDLCodeIdAvailable = -1;    /* SyncDLCodeIdAvailable_CellSyncReprtTDD */
static int hf_nbap_syncDLCodeIDNotAvailable = -1;  /* NULL */
static int hf_nbap_syncDLCodeIdTiming = -1;       /* CellSyncBurstTimingLCR */
static int hf_nbap_syncDLCodeIdSIR = -1;          /* CellSyncBurstSIR */
static int hf_nbap_DCH_RearrangeList_Bearer_RearrangeInd_item = -1;  /* DCH_RearrangeItem_Bearer_RearrangeInd */
static int hf_nbap_DSCH_RearrangeList_Bearer_RearrangeInd_item = -1;  /* DSCH_RearrangeItem_Bearer_RearrangeInd */
static int hf_nbap_USCH_RearrangeList_Bearer_RearrangeInd_item = -1;  /* USCH_RearrangeItem_Bearer_RearrangeInd */
static int hf_nbap_HSDSCH_RearrangeList_Bearer_RearrangeInd_item = -1;  /* HSDSCH_RearrangeItem_Bearer_RearrangeInd */
static int hf_nbap_E_DCH_RearrangeList_Bearer_RearrangeInd_item = -1;  /* E_DCH_RearrangeItem_Bearer_RearrangeInd */
static int hf_nbap_Additional_EDCH_Cell_Information_Bearer_Rearrangement_List_item = -1;  /* Additional_EDCH_Cell_Information_Bearer_Rearrangement_ItemIEs */
static int hf_nbap_transport_Bearer_Rearrangement_Indicator_for_Additional_EDCH_Separate_Mode = -1;  /* Transport_Bearer_Rearrangement_Indicator_for_Additional_EDCH_Separate_Mode */
static int hf_nbap_DelayedActivationInformationList_RL_ActivationCmdFDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_delayed_activation_update = -1;  /* DelayedActivationUpdate */
static int hf_nbap_DelayedActivationInformationList_RL_ActivationCmdTDD_item = -1;  /* ProtocolIE_Single_Container */
static int hf_nbap_Additional_HS_Cell_Information_RL_Param_Upd_item = -1;  /* Additional_HS_Cell_Information_RL_Param_Upd_ItemIEs */
static int hf_nbap_hS_DSCH_FDD_Secondary_Serving_Update_Information = -1;  /* HS_DSCH_FDD_Secondary_Serving_Update_Information */
static int hf_nbap_Additional_EDCH_Cell_Information_RL_Param_Upd_item = -1;  /* Additional_EDCH_Cell_Information_RL_Param_Upd_ItemIEs */
static int hf_nbap_additional_EDCH_FDD_Update_Information = -1;  /* Additional_EDCH_FDD_Update_Information */
static int hf_nbap_initiatingMessage = -1;        /* InitiatingMessage */
static int hf_nbap_succesfulOutcome = -1;         /* SuccessfulOutcome */
static int hf_nbap_unsuccesfulOutcome = -1;       /* UnsuccessfulOutcome */
static int hf_nbap_outcome = -1;                  /* Outcome */
static int hf_nbap_messageDiscriminator = -1;     /* MessageDiscriminator */
static int hf_nbap_initiatingMessagevalue = -1;   /* InitiatingMessage_value */
static int hf_nbap_successfulOutcome_value = -1;  /* SuccessfulOutcome_value */
static int hf_nbap_unsuccessfulOutcome_value = -1;  /* UnsuccessfulOutcome_value */
static int hf_nbap_outcome_value = -1;            /* Outcome_value */
/* named bits */
static int hf_nbap_PreambleSignatures_signature15 = -1;
static int hf_nbap_PreambleSignatures_signature14 = -1;
static int hf_nbap_PreambleSignatures_signature13 = -1;
static int hf_nbap_PreambleSignatures_signature12 = -1;
static int hf_nbap_PreambleSignatures_signature11 = -1;
static int hf_nbap_PreambleSignatures_signature10 = -1;
static int hf_nbap_PreambleSignatures_signature9 = -1;
static int hf_nbap_PreambleSignatures_signature8 = -1;
static int hf_nbap_PreambleSignatures_signature7 = -1;
static int hf_nbap_PreambleSignatures_signature6 = -1;
static int hf_nbap_PreambleSignatures_signature5 = -1;
static int hf_nbap_PreambleSignatures_signature4 = -1;
static int hf_nbap_PreambleSignatures_signature3 = -1;
static int hf_nbap_PreambleSignatures_signature2 = -1;
static int hf_nbap_PreambleSignatures_signature1 = -1;
static int hf_nbap_PreambleSignatures_signature0 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh11 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh10 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh9 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh8 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh7 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh6 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh5 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh4 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh3 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh2 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh1 = -1;
static int hf_nbap_RACH_SubChannelNumbers_subCh0 = -1;

/*--- End of included file: packet-nbap-hf.c ---*/
#line 72 "./asn1/nbap/packet-nbap-template.c"

/* Initialize the subtree pointers */
static int ett_nbap = -1;
static int ett_nbap_TransportLayerAddress = -1;
static int ett_nbap_TransportLayerAddress_nsap = -1;
static int ett_nbap_ib_sg_data = -1;


/*--- Included file: packet-nbap-ett.c ---*/
#line 1 "./asn1/nbap/packet-nbap-ett.c"
static gint ett_nbap_PrivateIE_ID = -1;
static gint ett_nbap_ProcedureID = -1;
static gint ett_nbap_TransactionID = -1;
static gint ett_nbap_ProtocolIE_Container = -1;
static gint ett_nbap_ProtocolIE_Field = -1;
static gint ett_nbap_ProtocolExtensionContainer = -1;
static gint ett_nbap_ProtocolExtensionField = -1;
static gint ett_nbap_PrivateIE_Container = -1;
static gint ett_nbap_PrivateIE_Field = -1;
static gint ett_nbap_ActivationInformation = -1;
static gint ett_nbap_ActivationInformationItem = -1;
static gint ett_nbap_Additional_EDCH_Setup_Info = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Setup = -1;
static gint ett_nbap_Additional_EDCH_FDD_Setup_Cell_Information = -1;
static gint ett_nbap_Additional_EDCH_UL_DPCH_Information_Setup = -1;
static gint ett_nbap_Additional_EDCH_F_DPCH_Information = -1;
static gint ett_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_List = -1;
static gint ett_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_To_Add_List = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_To_Add_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs = -1;
static gint ett_nbap_EDCH_Additional_RL_Specific_Information_To_Add_List = -1;
static gint ett_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_List = -1;
static gint ett_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_FDD_Information = -1;
static gint ett_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_List = -1;
static gint ett_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Response_List = -1;
static gint ett_nbap_Additional_EDCH_FDD_Information_Response_ItemIEs = -1;
static gint ett_nbap_EDCH_Additional_RL_Specific_Information_Response_List = -1;
static gint ett_nbap_EDCH_Additional_RL_Specific_Information_Response_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Response_RLReconf_List = -1;
static gint ett_nbap_Additional_EDCH_FDD_Information_Response_RLReconf_Items = -1;
static gint ett_nbap_Additional_Modififed_EDCH_FDD_Information_Response_ItemIEs = -1;
static gint ett_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List = -1;
static gint ett_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List_Items = -1;
static gint ett_nbap_Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List = -1;
static gint ett_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_Response = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_List = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_ConfigurationChange_List = -1;
static gint ett_nbap_Additional_EDCH_ConfigurationChange_Info_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_UL_DPCH_Information_Modify = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Removal_List = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Removal_Info_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_FDD_Update_Information = -1;
static gint ett_nbap_Additional_EDCH_DL_Control_Channel_Change_Information_List = -1;
static gint ett_nbap_Additional_EDCH_DL_Control_Channel_Change_Info_ItemIEs = -1;
static gint ett_nbap_AdditionalMeasurementValueList = -1;
static gint ett_nbap_AdditionalMeasurementValue = -1;
static gint ett_nbap_AdditionalTimeSlotListLCR = -1;
static gint ett_nbap_AdditionalTimeSlotLCR = -1;
static gint ett_nbap_Active_Pattern_Sequence_Information = -1;
static gint ett_nbap_Transmission_Gap_Pattern_Sequence_Status_List = -1;
static gint ett_nbap_Transmission_Gap_Pattern_Sequence_Status_List_item = -1;
static gint ett_nbap_AllocationRetentionPriority = -1;
static gint ett_nbap_Angle_Of_Arrival_Value_LCR = -1;
static gint ett_nbap_BCCH_Specific_HSDSCH_RNTI_Information = -1;
static gint ett_nbap_BCCH_Specific_HSDSCH_RNTI_InformationLCR = -1;
static gint ett_nbap_Best_Cell_Portions_Value = -1;
static gint ett_nbap_Best_Cell_Portions_Item = -1;
static gint ett_nbap_Best_Cell_Portions_ValueLCR = -1;
static gint ett_nbap_Best_Cell_Portions_ItemLCR = -1;
static gint ett_nbap_BroadcastCommonTransportBearerIndication = -1;
static gint ett_nbap_Cause = -1;
static gint ett_nbap_Cell_ERNTI_Status_Information = -1;
static gint ett_nbap_Cell_ERNTI_Status_Information_Item = -1;
static gint ett_nbap_Vacant_ERNTI = -1;
static gint ett_nbap_CellSyncBurstTiming = -1;
static gint ett_nbap_CellSyncBurstTimingLCR = -1;
static gint ett_nbap_CommonChannelsCapacityConsumptionLaw = -1;
static gint ett_nbap_CommonChannelsCapacityConsumptionLaw_item = -1;
static gint ett_nbap_Common_EDCH_System_InformationFDD = -1;
static gint ett_nbap_Common_E_DCH_UL_DPCH_InfoItem = -1;
static gint ett_nbap_Common_E_DCH_EDPCH_InfoItem = -1;
static gint ett_nbap_Common_E_DCH_InfoItem = -1;
static gint ett_nbap_Common_E_DCH_HSDPCCH_InfoItem = -1;
static gint ett_nbap_Common_E_DCH_CQI_Info = -1;
static gint ett_nbap_Common_E_DCH_Preamble_Control_InfoItem = -1;
static gint ett_nbap_Common_E_DCH_AICH_Information = -1;
static gint ett_nbap_Common_E_DCH_FDPCH_InfoItem = -1;
static gint ett_nbap_Common_E_DCH_Resource_Combination_InfoList = -1;
static gint ett_nbap_Common_E_DCH_Resource_Combination_InfoList_Item = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_Item = -1;
static gint ett_nbap_Common_E_DCH_MACdFlow_Specific_InfoList = -1;
static gint ett_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_Item = -1;
static gint ett_nbap_Common_E_DCH_LogicalChannel_InfoList = -1;
static gint ett_nbap_Common_E_DCH_LogicalChannel_InfoList_Item = -1;
static gint ett_nbap_Common_EDCH_System_Information_ResponseFDD = -1;
static gint ett_nbap_E_RNTI_List = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_Item = -1;
static gint ett_nbap_Common_MACFlows_to_DeleteFDD = -1;
static gint ett_nbap_Common_MACFlows_to_DeleteFDD_Item = -1;
static gint ett_nbap_CommonMACFlow_Specific_InfoList = -1;
static gint ett_nbap_CommonMACFlow_Specific_InfoItem = -1;
static gint ett_nbap_CommonMACFlow_Specific_InfoList_Response = -1;
static gint ett_nbap_CommonMACFlow_Specific_InfoItem_Response = -1;
static gint ett_nbap_Common_MACFlow_PriorityQueue_Information = -1;
static gint ett_nbap_Common_MACFlow_PriorityQueue_Item = -1;
static gint ett_nbap_CommonMeasurementAccuracy = -1;
static gint ett_nbap_CommonMeasurementValue = -1;
static gint ett_nbap_CommonMeasurementValueInformation = -1;
static gint ett_nbap_CommonMeasurementAvailable = -1;
static gint ett_nbap_Common_PhysicalChannel_Status_Information = -1;
static gint ett_nbap_Common_PhysicalChannel_Status_Information768 = -1;
static gint ett_nbap_CommonTransportChannel_InformationResponse = -1;
static gint ett_nbap_Common_TransportChannel_Status_Information = -1;
static gint ett_nbap_ContinuousPacketConnectivityDTX_DRX_Information = -1;
static gint ett_nbap_ContinuousPacketConnectivityDTX_DRX_Information_to_Modify = -1;
static gint ett_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information = -1;
static gint ett_nbap_ContinuousPacketConnectivityHS_SCCH_less_InformationItem = -1;
static gint ett_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information_Response = -1;
static gint ett_nbap_CPC_Information = -1;
static gint ett_nbap_CriticalityDiagnostics = -1;
static gint ett_nbap_CriticalityDiagnostics_IE_List = -1;
static gint ett_nbap_CriticalityDiagnostics_IE_List_item = -1;
static gint ett_nbap_Common_EDCH_System_InformationLCR = -1;
static gint ett_nbap_Common_E_PUCH_InformationLCR = -1;
static gint ett_nbap_PRXdes_base_perURAFCN = -1;
static gint ett_nbap_PRXdes_base_Item = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoListLCR = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_ItemLCR = -1;
static gint ett_nbap_Common_E_DCH_MACdFlow_Specific_InfoListLCR = -1;
static gint ett_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_ItemLCR = -1;
static gint ett_nbap_Common_EDCH_System_Information_ResponseLCR = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext = -1;
static gint ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR = -1;
static gint ett_nbap_Common_E_AGCH_ListLCR = -1;
static gint ett_nbap_Common_E_AGCH_ItemLCR = -1;
static gint ett_nbap_Common_E_HICH_ListLCR = -1;
static gint ett_nbap_Common_E_HICH_ItemLCR = -1;
static gint ett_nbap_Common_E_RNTI_Info_LCR = -1;
static gint ett_nbap_Common_E_RNTI_Info_ItemLCR = -1;
static gint ett_nbap_Common_MACFlows_to_DeleteLCR = -1;
static gint ett_nbap_Common_MACFlows_to_DeleteLCR_Item = -1;
static gint ett_nbap_CommonMACFlow_Specific_InfoListLCR = -1;
static gint ett_nbap_CommonMACFlow_Specific_InfoItemLCR = -1;
static gint ett_nbap_Common_H_RNTI_InformationLCR = -1;
static gint ett_nbap_Common_H_RNTI_InfoItemLCR = -1;
static gint ett_nbap_Sync_InformationLCR = -1;
static gint ett_nbap_CommonMACFlow_Specific_InfoList_ResponseLCR = -1;
static gint ett_nbap_CommonMACFlow_Specific_InfoItem_ResponseLCR = -1;
static gint ett_nbap_CPC_InformationLCR = -1;
static gint ett_nbap_ContinuousPacketConnectivity_DRX_InformationLCR = -1;
static gint ett_nbap_HS_SCCH_DRX_Information_LCR = -1;
static gint ett_nbap_E_AGCH_DRX_Information_LCR = -1;
static gint ett_nbap_E_AGCH_DRX_Parameters = -1;
static gint ett_nbap_ContinuousPacketConnectivity_DRX_Information_to_Modify_LCR = -1;
static gint ett_nbap_DRX_Information_to_Modify_LCR = -1;
static gint ett_nbap_DRX_Information_to_Modify_Items_LCR = -1;
static gint ett_nbap_ContinuousPacketConnectivity_DRX_Information_ResponseLCR = -1;
static gint ett_nbap_HS_SCCH_DRX_Information_ResponseLCR = -1;
static gint ett_nbap_E_AGCH_DRX_Information_ResponseLCR = -1;
static gint ett_nbap_E_AGCH_DRX_Parameters_Response = -1;
static gint ett_nbap_DCH_FDD_Information = -1;
static gint ett_nbap_DCH_FDD_InformationItem = -1;
static gint ett_nbap_DCH_Specific_FDD_InformationList = -1;
static gint ett_nbap_DCH_Specific_FDD_Item = -1;
static gint ett_nbap_DCH_InformationResponse = -1;
static gint ett_nbap_DCH_InformationResponseItem = -1;
static gint ett_nbap_DCH_MeasurementOccasion_Information = -1;
static gint ett_nbap_DchMeasurementOccasionInformation_Item = -1;
static gint ett_nbap_Measurement_Occasion_Pattern_Sequence_parameters = -1;
static gint ett_nbap_DCH_TDD_Information = -1;
static gint ett_nbap_DCH_TDD_InformationItem = -1;
static gint ett_nbap_DCH_Specific_TDD_InformationList = -1;
static gint ett_nbap_DCH_Specific_TDD_Item = -1;
static gint ett_nbap_FDD_DCHs_to_Modify = -1;
static gint ett_nbap_FDD_DCHs_to_ModifyItem = -1;
static gint ett_nbap_DCH_ModifySpecificInformation_FDD = -1;
static gint ett_nbap_DCH_ModifySpecificItem_FDD = -1;
static gint ett_nbap_TDD_DCHs_to_Modify = -1;
static gint ett_nbap_DCH_ModifyItem_TDD = -1;
static gint ett_nbap_DCH_ModifySpecificInformation_TDD = -1;
static gint ett_nbap_DCH_ModifySpecificItem_TDD = -1;
static gint ett_nbap_DedicatedChannelsCapacityConsumptionLaw = -1;
static gint ett_nbap_DedicatedChannelsCapacityConsumptionLaw_item = -1;
static gint ett_nbap_DedicatedMeasurementValue = -1;
static gint ett_nbap_DedicatedMeasurementValueInformation = -1;
static gint ett_nbap_DedicatedMeasurementAvailable = -1;
static gint ett_nbap_DelayedActivation = -1;
static gint ett_nbap_DelayedActivationUpdate = -1;
static gint ett_nbap_Activate_Info = -1;
static gint ett_nbap_Deactivate_Info = -1;
static gint ett_nbap_Execution_Type = -1;
static gint ett_nbap_DGANSSCorrections = -1;
static gint ett_nbap_DGANSS_Corrections_Req = -1;
static gint ett_nbap_DGANSS_Information = -1;
static gint ett_nbap_DGANSS_InformationItem = -1;
static gint ett_nbap_DGANSS_SignalInformation = -1;
static gint ett_nbap_DGANSS_SignalInformationItem = -1;
static gint ett_nbap_DGANSSThreshold = -1;
static gint ett_nbap_DGNSS_ValidityPeriod = -1;
static gint ett_nbap_DGPSCorrections = -1;
static gint ett_nbap_DGPSThresholds = -1;
static gint ett_nbap_DL_Timeslot_Information = -1;
static gint ett_nbap_DL_Timeslot_InformationItem = -1;
static gint ett_nbap_DL_TimeslotLCR_Information = -1;
static gint ett_nbap_DL_TimeslotLCR_InformationItem = -1;
static gint ett_nbap_DL_Timeslot768_Information = -1;
static gint ett_nbap_DL_Timeslot768_InformationItem = -1;
static gint ett_nbap_DL_PowerBalancing_Information = -1;
static gint ett_nbap_DL_ReferencePowerInformationList = -1;
static gint ett_nbap_DL_ReferencePowerInformationItem = -1;
static gint ett_nbap_DL_TimeslotISCPInfo = -1;
static gint ett_nbap_DL_TimeslotISCPInfoItem = -1;
static gint ett_nbap_DL_TimeslotISCPInfoLCR = -1;
static gint ett_nbap_DL_TimeslotISCPInfoItemLCR = -1;
static gint ett_nbap_DL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_HS_PDSCH_Timeslot_InformationItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_MaxHSDSCH_HSSCCH_Power_per_CELLPORTION = -1;
static gint ett_nbap_MaxHSDSCH_HSSCCH_Power_per_CELLPORTION_Item = -1;
static gint ett_nbap_DL_HS_PDSCH_Codelist_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_DRX_Information = -1;
static gint ett_nbap_DRX_Information_to_Modify = -1;
static gint ett_nbap_DRX_Information_to_Modify_Items = -1;
static gint ett_nbap_DSCH_InformationResponse = -1;
static gint ett_nbap_DSCH_InformationResponseItem = -1;
static gint ett_nbap_DSCH_TDD_Information = -1;
static gint ett_nbap_DSCH_TDD_InformationItem = -1;
static gint ett_nbap_DTX_Cycle_2ms_Items = -1;
static gint ett_nbap_DTX_Cycle_2ms_to_Modify_Items = -1;
static gint ett_nbap_DTX_Cycle_10ms_Items = -1;
static gint ett_nbap_DTX_Cycle_10ms_to_Modify_Items = -1;
static gint ett_nbap_DTX_Information = -1;
static gint ett_nbap_DTX_Information_to_Modify = -1;
static gint ett_nbap_DTX_Information_to_Modify_Items = -1;
static gint ett_nbap_Dual_Band_Capability_Info = -1;
static gint ett_nbap_E_AGCH_FDD_Code_Information = -1;
static gint ett_nbap_E_AGCH_FDD_Code_List = -1;
static gint ett_nbap_E_DCHCapacityConsumptionLaw = -1;
static gint ett_nbap_E_DCH_TDD_CapacityConsumptionLaw = -1;
static gint ett_nbap_E_DCH_SF_allocation = -1;
static gint ett_nbap_E_DCH_SF_allocation_item = -1;
static gint ett_nbap_E_DCH_FDD_DL_Control_Channel_Information = -1;
static gint ett_nbap_E_DCH_FDD_Information = -1;
static gint ett_nbap_E_DCH_FDD_Information_Response = -1;
static gint ett_nbap_E_DCH_FDD_Information_to_Modify = -1;
static gint ett_nbap_E_DCH_FDD_Update_Information = -1;
static gint ett_nbap_E_DCH_MACdFlow_Specific_UpdateInformation = -1;
static gint ett_nbap_E_DCH_MACdFlow_Specific_UpdateInformation_Item = -1;
static gint ett_nbap_E_DCH_DL_Control_Channel_Change_Information = -1;
static gint ett_nbap_E_DCH_DL_Control_Channel_Change_Information_Item = -1;
static gint ett_nbap_E_DCH_DL_Control_Channel_Grant_Information = -1;
static gint ett_nbap_E_DCH_DL_Control_Channel_Grant_Information_Item = -1;
static gint ett_nbap_E_DCH_Grant_Type_Information = -1;
static gint ett_nbap_E_DCH_LogicalChannelInformation = -1;
static gint ett_nbap_E_DCH_LogicalChannelInformationItem = -1;
static gint ett_nbap_E_DCH_MACdPDU_SizeList = -1;
static gint ett_nbap_E_DCH_MACdPDU_SizeListItem = -1;
static gint ett_nbap_E_DCH_LogicalChannelToModify = -1;
static gint ett_nbap_E_DCH_LogicalChannelToModifyItem = -1;
static gint ett_nbap_E_DCH_MACdPDU_SizeToModifyList = -1;
static gint ett_nbap_E_DCH_LogicalChannelToDelete = -1;
static gint ett_nbap_E_DCH_LogicalChannelToDeleteItem = -1;
static gint ett_nbap_E_DCH_MACdFlows_Information = -1;
static gint ett_nbap_E_DCH_MACdFlow_Specific_InfoList = -1;
static gint ett_nbap_E_DCH_MACdFlow_Specific_InfoItem = -1;
static gint ett_nbap_E_DCH_MACdFlow_Specific_InformationResp = -1;
static gint ett_nbap_E_DCH_MACdFlow_Specific_InformationResp_Item = -1;
static gint ett_nbap_E_DCH_MACdFlow_Specific_InfoList_to_Modify = -1;
static gint ett_nbap_E_DCH_MACdFlow_Specific_InfoItem_to_Modify = -1;
static gint ett_nbap_E_DCH_MACdFlows_to_Delete = -1;
static gint ett_nbap_E_DCH_MACdFlow_to_Delete_Item = -1;
static gint ett_nbap_E_DCH_Non_Scheduled_Transmission_Grant_Items = -1;
static gint ett_nbap_E_DCH_Serving_Cell_Change_Info_Response = -1;
static gint ett_nbap_E_DCH_serving_cell_choice = -1;
static gint ett_nbap_E_DCH_serving_cell_change_successful = -1;
static gint ett_nbap_E_DCH_RL_InformationList_Rsp = -1;
static gint ett_nbap_E_DCH_RL_InformationList_Rsp_Item = -1;
static gint ett_nbap_E_DCH_serving_cell_change_unsuccessful = -1;
static gint ett_nbap_EDCH_RACH_Report_Value = -1;
static gint ett_nbap_EDCH_RACH_Report_Value_item = -1;
static gint ett_nbap_E_DCH_TTI_Length = -1;
static gint ett_nbap_E_DCH_TTI_Length_to_Modify = -1;
static gint ett_nbap_E_DCH_MACdFlows_to_DeleteLCR = -1;
static gint ett_nbap_E_DCH_MACdFlow_to_Delete_ItemLCR = -1;
static gint ett_nbap_Enhanced_UE_DRX_InformationLCR = -1;
static gint ett_nbap_E_RGCH_E_HICH_FDD_Code_Information = -1;
static gint ett_nbap_E_RGCH_E_HICH_FDD_Code_List = -1;
static gint ett_nbap_E_TFCI_Boost_Information = -1;
static gint ett_nbap_E_TFCS_Information = -1;
static gint ett_nbap_E_DCHProvidedBitRate = -1;
static gint ett_nbap_E_DCHProvidedBitRate_Item = -1;
static gint ett_nbap_E_DCHProvidedBitRateValueInformation_For_CellPortion = -1;
static gint ett_nbap_E_DCHProvidedBitRateValueInformation_For_CellPortion_Item = -1;
static gint ett_nbap_E_DCH_Information = -1;
static gint ett_nbap_E_PUCH_Information = -1;
static gint ett_nbap_E_TFCS_Information_TDD = -1;
static gint ett_nbap_E_DCH_QPSK_RefBetaInfo = -1;
static gint ett_nbap_E_DCH_sixteenQAM_RefBetaInfo = -1;
static gint ett_nbap_E_DCH_RefBeta_Item = -1;
static gint ett_nbap_E_DCH_MACdFlows_Information_TDD = -1;
static gint ett_nbap_E_DCH_MACdFlow_InfoTDDItem = -1;
static gint ett_nbap_E_DCH_Non_Scheduled_Grant_Info = -1;
static gint ett_nbap_E_DCH_TDD_Information = -1;
static gint ett_nbap_E_DCH_Information_Response = -1;
static gint ett_nbap_Scheduled_E_HICH_Specific_Information_ResponseLCRTDD = -1;
static gint ett_nbap_Scheduled_E_HICH_Specific_InformationItem_ResponseLCRTDD = -1;
static gint ett_nbap_E_DCH_TDD_MACdFlow_Specific_InformationResp = -1;
static gint ett_nbap_E_DCH_TDD_MACdFlow_Specific_InformationResp_Item = -1;
static gint ett_nbap_E_AGCH_Specific_InformationRespListTDD = -1;
static gint ett_nbap_E_AGCH_Specific_InformationResp_ItemTDD = -1;
static gint ett_nbap_E_DCH_Information_Reconfig = -1;
static gint ett_nbap_E_DCH_TDD_Information_to_Modify = -1;
static gint ett_nbap_E_DCH_TDD_Information_to_Modify_List = -1;
static gint ett_nbap_E_DCH_MACdFlow_ModifyTDDItem = -1;
static gint ett_nbap_E_DCH_768_Information = -1;
static gint ett_nbap_E_DCH_Non_Scheduled_Grant_Info768 = -1;
static gint ett_nbap_E_DCH_TDD_Information768 = -1;
static gint ett_nbap_E_DCH_768_Information_Reconfig = -1;
static gint ett_nbap_E_DCH_LCR_Information = -1;
static gint ett_nbap_E_PUCH_LCR_Information = -1;
static gint ett_nbap_E_DCH_Non_Scheduled_Grant_LCR_Info = -1;
static gint ett_nbap_E_HICH_LCR_Information = -1;
static gint ett_nbap_E_DCH_LCRTDD_Information = -1;
static gint ett_nbap_E_DCH_LCR_Information_Reconfig = -1;
static gint ett_nbap_Enhanced_UE_DRX_InformationFDD = -1;
static gint ett_nbap_E_DCH_Semi_PersistentScheduling_Information_LCR = -1;
static gint ett_nbap_E_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR = -1;
static gint ett_nbap_E_DCH_Semi_PersistentScheduling_Information_ResponseLCR = -1;
static gint ett_nbap_FDD_DL_CodeInformation = -1;
static gint ett_nbap_FDD_DL_CodeInformationItem = -1;
static gint ett_nbap_GANSS_AddClockModels = -1;
static gint ett_nbap_GANSS_AddOrbitModels = -1;
static gint ett_nbap_GANSS_Additional_Ionospheric_Model = -1;
static gint ett_nbap_GANSS_Additional_Navigation_Models = -1;
static gint ett_nbap_GANSS_Additional_Time_Models = -1;
static gint ett_nbap_GANSS_Additional_UTC_Models = -1;
static gint ett_nbap_GANSS_Almanac = -1;
static gint ett_nbap_GANSS_AlmanacModel = -1;
static gint ett_nbap_GANSS_ALM_ECEFsbasAlmanacSet = -1;
static gint ett_nbap_GANSS_ALM_GlonassAlmanacSet = -1;
static gint ett_nbap_GANSS_ALM_MidiAlmanacSet = -1;
static gint ett_nbap_GANSS_ALM_NAVKeplerianSet = -1;
static gint ett_nbap_GANSS_ALM_ReducedKeplerianSet = -1;
static gint ett_nbap_GANSS_Auxiliary_Information = -1;
static gint ett_nbap_GANSS_AuxInfoGANSS_ID1 = -1;
static gint ett_nbap_GANSS_AuxInfoGANSS_ID1_element = -1;
static gint ett_nbap_GANSS_AuxInfoGANSS_ID3 = -1;
static gint ett_nbap_GANSS_AuxInfoGANSS_ID3_element = -1;
static gint ett_nbap_GANSS_Clock_Model = -1;
static gint ett_nbap_GANSS_CNAVclockModel = -1;
static gint ett_nbap_GANSS_Common_Data = -1;
static gint ett_nbap_GANSS_CommonDataInfoReq = -1;
static gint ett_nbap_GANSS_Data_Bit_Assistance = -1;
static gint ett_nbap_GANSS_DataBitAssistanceList = -1;
static gint ett_nbap_GANSS_DataBitAssistanceItem = -1;
static gint ett_nbap_GANSS_DataBitAssistanceSgnList = -1;
static gint ett_nbap_GANSS_DataBitAssistanceSgnItem = -1;
static gint ett_nbap_GANSS_Data_Bit_Assistance_ReqItem = -1;
static gint ett_nbap_GANSS_Data_Bit_Assistance_ReqList = -1;
static gint ett_nbap_T_ganss_SatelliteInfo = -1;
static gint ett_nbap_GANSS_DeltaUT1 = -1;
static gint ett_nbap_GANSS_Earth_Orientation_Parameters = -1;
static gint ett_nbap_GANSS_GenericDataInfoReqList = -1;
static gint ett_nbap_GANSS_GenericDataInfoReqItem = -1;
static gint ett_nbap_GANSS_Generic_Data = -1;
static gint ett_nbap_GANSS_Generic_DataItem = -1;
static gint ett_nbap_GANSS_GLONASSclockModel = -1;
static gint ett_nbap_GANSS_Information = -1;
static gint ett_nbap_GANSS_Ionospheric_Model = -1;
static gint ett_nbap_GANSS_IonosphereRegionalStormFlags = -1;
static gint ett_nbap_GANSS_KeplerianParametersAlm = -1;
static gint ett_nbap_GANSS_KeplerianParametersOrb = -1;
static gint ett_nbap_GANSS_NAVclockModel = -1;
static gint ett_nbap_GANSS_Navigation_Model_And_Time_Recovery = -1;
static gint ett_nbap_GANSS_NavModel_CNAVKeplerianSet = -1;
static gint ett_nbap_GANSS_NavModel_GLONASSecef = -1;
static gint ett_nbap_GANSS_NavModel_NAVKeplerianSet = -1;
static gint ett_nbap_GANSS_NavModel_SBASecef = -1;
static gint ett_nbap_GANSS_Orbit_Model = -1;
static gint ett_nbap_GANSS_Real_Time_Integrity = -1;
static gint ett_nbap_GANSS_RealTimeInformationItem = -1;
static gint ett_nbap_GANSS_RX_Pos = -1;
static gint ett_nbap_GANSS_SatelliteClockModelItem = -1;
static gint ett_nbap_GANSS_SatelliteInformationKP = -1;
static gint ett_nbap_GANSS_SatelliteInformationKPItem = -1;
static gint ett_nbap_Ganss_Sat_Info_AddNavList = -1;
static gint ett_nbap_Ganss_Sat_Info_AddNavList_item = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_GLOkpList = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_GLOkp = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_MIDIkpList = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_MIDIkp = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_NAVkpList = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_NAVkp = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_REDkpList = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_REDkp = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_SBASecefList = -1;
static gint ett_nbap_GANSS_SAT_Info_Almanac_SBASecef = -1;
static gint ett_nbap_GANSS_Sat_Info_Nav = -1;
static gint ett_nbap_GANSS_Sat_Info_Nav_item = -1;
static gint ett_nbap_GANSS_SBASclockModel = -1;
static gint ett_nbap_GANSS_Time_Model = -1;
static gint ett_nbap_GANSS_Transmission_Time = -1;
static gint ett_nbap_GANSS_UTC_Model = -1;
static gint ett_nbap_GANSS_UTCmodelSet1 = -1;
static gint ett_nbap_GANSS_UTCmodelSet2 = -1;
static gint ett_nbap_GANSS_UTCmodelSet3 = -1;
static gint ett_nbap_GPS_Almanac = -1;
static gint ett_nbap_GPS_Ionospheric_Model = -1;
static gint ett_nbap_GPS_Information = -1;
static gint ett_nbap_GPS_RealTime_Integrity = -1;
static gint ett_nbap_GPSBadSat_Info_RealTime_Integrity = -1;
static gint ett_nbap_GPS_NavigationModel_and_TimeRecovery = -1;
static gint ett_nbap_GPS_NavandRecovery_Item = -1;
static gint ett_nbap_GPS_RX_POS = -1;
static gint ett_nbap_GPS_UTC_Model = -1;
static gint ett_nbap_HARQ_MemoryPartitioning = -1;
static gint ett_nbap_HARQ_MemoryPartitioning_Implicit = -1;
static gint ett_nbap_HARQ_MemoryPartitioning_Explicit = -1;
static gint ett_nbap_HARQ_MemoryPartitioningList = -1;
static gint ett_nbap_HARQ_MemoryPartitioningInfoExtForMIMO = -1;
static gint ett_nbap_HARQ_MemoryPartitioningItem = -1;
static gint ett_nbap_HS_DSCHProvidedBitRate = -1;
static gint ett_nbap_HS_DSCHProvidedBitRate_Item = -1;
static gint ett_nbap_HS_DSCHProvidedBitRateValueInformation_For_CellPortion = -1;
static gint ett_nbap_HS_DSCHProvidedBitRateValueInformation_For_CellPortion_Item = -1;
static gint ett_nbap_HS_DSCHProvidedBitRateValueInformation_For_CellPortionLCR = -1;
static gint ett_nbap_HS_DSCHProvidedBitRateValueInformation_For_CellPortionLCR_Item = -1;
static gint ett_nbap_HS_DSCHRequiredPower = -1;
static gint ett_nbap_HS_DSCHRequiredPower_Item = -1;
static gint ett_nbap_HS_DSCHRequiredPowerPerUEInformation = -1;
static gint ett_nbap_HS_DSCHRequiredPowerPerUEInformation_Item = -1;
static gint ett_nbap_HS_DSCHRequiredPowerValueInformation_For_CellPortion = -1;
static gint ett_nbap_HS_DSCHRequiredPowerValueInformation_For_CellPortion_Item = -1;
static gint ett_nbap_HS_DSCHRequiredPowerValueInformation_For_CellPortionLCR = -1;
static gint ett_nbap_HS_DSCHRequiredPowerValueInformation_For_CellPortionLCR_Item = -1;
static gint ett_nbap_HSDPA_Associated_PICH_Information = -1;
static gint ett_nbap_HSDPA_PICH_Shared_with_PCH = -1;
static gint ett_nbap_HSDPA_PICH_notShared_with_PCH = -1;
static gint ett_nbap_HSDSCH_Common_System_InformationFDD = -1;
static gint ett_nbap_HSDSCH_Common_System_Information_ResponseFDD = -1;
static gint ett_nbap_HSDSCH_Common_Information = -1;
static gint ett_nbap_HSDSCH_FDD_Information = -1;
static gint ett_nbap_HSDSCH_TDD_Information = -1;
static gint ett_nbap_HSDSCH_Information_to_Modify = -1;
static gint ett_nbap_HSDSCH_MACdFlow_Specific_InfoList_to_Modify = -1;
static gint ett_nbap_HSDSCH_MACdFlow_Specific_InfoItem_to_Modify = -1;
static gint ett_nbap_HSDSCH_Information_to_Modify_Unsynchronised = -1;
static gint ett_nbap_HSDSCH_FDD_Information_Response = -1;
static gint ett_nbap_HS_DSCH_FDD_Secondary_Serving_Information = -1;
static gint ett_nbap_HS_DSCH_FDD_Secondary_Serving_Information_Response = -1;
static gint ett_nbap_HS_DSCH_Secondary_Serving_Information_To_Modify = -1;
static gint ett_nbap_HS_DSCH_FDD_Secondary_Serving_Information_To_Modify_Unsynchronised = -1;
static gint ett_nbap_HS_DSCH_FDD_Secondary_Serving_Update_Information = -1;
static gint ett_nbap_HS_DSCH_Secondary_Serving_Cell_Change_Information_Response = -1;
static gint ett_nbap_HS_DSCH_Secondary_Serving_cell_change_choice = -1;
static gint ett_nbap_HS_Secondary_Serving_cell_change_successful = -1;
static gint ett_nbap_HS_Secondary_Serving_cell_change_unsuccessful = -1;
static gint ett_nbap_HSDSCH_Paging_System_InformationFDD = -1;
static gint ett_nbap_HSDSCH_Paging_System_Information_ResponseFDD = -1;
static gint ett_nbap_HSDSCH_Paging_System_Information_ResponseList = -1;
static gint ett_nbap_HSDSCH_TDD_Information_Response = -1;
static gint ett_nbap_HSDSCH_MACdFlow_Specific_InformationResp = -1;
static gint ett_nbap_HSDSCH_MACdFlow_Specific_InformationResp_Item = -1;
static gint ett_nbap_HSDSCH_MACdFlows_Information = -1;
static gint ett_nbap_HSDSCH_MACdFlow_Specific_InfoList = -1;
static gint ett_nbap_HSDSCH_MACdFlow_Specific_InfoItem = -1;
static gint ett_nbap_HSDSCH_MACdFlows_to_Delete = -1;
static gint ett_nbap_HSDSCH_MACdFlows_to_Delete_Item = -1;
static gint ett_nbap_HSDSCH_Initial_Capacity_Allocation = -1;
static gint ett_nbap_HSDSCH_Initial_Capacity_AllocationItem = -1;
static gint ett_nbap_HSDSCH_PreconfigurationInfo = -1;
static gint ett_nbap_Additional_EDCH_Preconfiguration_Information = -1;
static gint ett_nbap_Additional_EDCH_Preconfiguration_Information_ItemIEs = -1;
static gint ett_nbap_HSDSCH_PreconfigurationSetup = -1;
static gint ett_nbap_HS_SCCH_PreconfiguredCodes = -1;
static gint ett_nbap_HS_SCCH_PreconfiguredCodesItem = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespListFDD = -1;
static gint ett_nbap_HSSCCH_Codes = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespListTDD = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespItemTDD = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespListTDDLCR = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespItemTDDLCR = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespListTDD768 = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespItemTDD768 = -1;
static gint ett_nbap_HSSICH_Info = -1;
static gint ett_nbap_HSSICH_InfoLCR = -1;
static gint ett_nbap_HSSICH_Info768 = -1;
static gint ett_nbap_HS_SICH_Reception_Quality_Value = -1;
static gint ett_nbap_HS_PDSCH_FDD_Code_Information = -1;
static gint ett_nbap_HS_SCCH_FDD_Code_Information = -1;
static gint ett_nbap_HS_SCCH_FDD_Code_List = -1;
static gint ett_nbap_HS_DSCH_Serving_Cell_Change_Info = -1;
static gint ett_nbap_HS_DSCH_Serving_Cell_Change_Info_Response = -1;
static gint ett_nbap_HS_DSCH_serving_cell_choice = -1;
static gint ett_nbap_HS_serving_cell_change_successful = -1;
static gint ett_nbap_HS_serving_cell_change_unsuccessful = -1;
static gint ett_nbap_HSDSCH_FDD_Update_Information = -1;
static gint ett_nbap_HSDSCH_TDD_Update_Information = -1;
static gint ett_nbap_HSDPA_Associated_PICH_InformationLCR = -1;
static gint ett_nbap_HSDPA_PICH_notShared_with_PCHLCR = -1;
static gint ett_nbap_HSDSCH_Common_System_InformationLCR = -1;
static gint ett_nbap_HSDSCH_Common_System_Information_ResponseLCR = -1;
static gint ett_nbap_HSDSCH_Common_InformationLCR = -1;
static gint ett_nbap_HSDSCH_Paging_System_InformationLCR = -1;
static gint ett_nbap_HSDSCH_Paging_System_Information_ResponseLCR = -1;
static gint ett_nbap_HSDSCH_Paging_System_Information_ResponseListLCR = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespListLCR = -1;
static gint ett_nbap_HSSCCH_Specific_InformationRespItemLCR = -1;
static gint ett_nbap_HS_DSCH_Semi_PersistentScheduling_Information_LCR = -1;
static gint ett_nbap_Transport_Block_Size_List_LCR = -1;
static gint ett_nbap_Transport_Block_Size_Item_LCR = -1;
static gint ett_nbap_Repetition_Period_List_LCR = -1;
static gint ett_nbap_Repetition_Period_Item_LCR = -1;
static gint ett_nbap_HS_DSCH_SPS_Operation_Indicator = -1;
static gint ett_nbap_HS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR = -1;
static gint ett_nbap_HS_DSCH_Semi_PersistentScheduling_Information_ResponseLCR = -1;
static gint ett_nbap_HS_SICH_InformationList_for_HS_DSCH_SPS = -1;
static gint ett_nbap_HS_SICH_InformationItem_for_HS_DSCH_SPS = -1;
static gint ett_nbap_HS_SICH_Type = -1;
static gint ett_nbap_HS_SCCH_Associated_HS_SICH = -1;
static gint ett_nbap_Non_HS_SCCH_Associated_HS_SICH = -1;
static gint ett_nbap_Initial_HS_PDSCH_SPS_Resource = -1;
static gint ett_nbap_Add_To_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Non_HS_SCCH_Associated_HS_SICH_InformationList = -1;
static gint ett_nbap_Non_HS_SCCH_Associated_HS_SICH_InformationList_Ext = -1;
static gint ett_nbap_Non_HS_SCCH_Associated_HS_SICH_InformationItem = -1;
static gint ett_nbap_Modify_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Modify_Non_HS_SCCH_Associated_HS_SICH_InformationList = -1;
static gint ett_nbap_Modify_Non_HS_SCCH_Associated_HS_SICH_InformationList_Ext = -1;
static gint ett_nbap_Modify_Non_HS_SCCH_Associated_HS_SICH_InformationItem = -1;
static gint ett_nbap_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext = -1;
static gint ett_nbap_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqstItem = -1;
static gint ett_nbap_MIMO_ReferenceSignal_InformationListLCR = -1;
static gint ett_nbap_HSSICH_ReferenceSignal_InformationLCR = -1;
static gint ett_nbap_HSSICH_ReferenceSignal_InformationModifyLCR = -1;
static gint ett_nbap_IMB_Parameters = -1;
static gint ett_nbap_InformationReportCharacteristics = -1;
static gint ett_nbap_InformationReportCharacteristicsType_ReportPeriodicity = -1;
static gint ett_nbap_InformationReportCharacteristicsType_OnModification = -1;
static gint ett_nbap_InformationThresholds = -1;
static gint ett_nbap_InformationType = -1;
static gint ett_nbap_IPDL_FDD_Parameters = -1;
static gint ett_nbap_IPDL_TDD_Parameters = -1;
static gint ett_nbap_IPDL_TDD_Parameters_LCR = -1;
static gint ett_nbap_IPMulticastIndication = -1;
static gint ett_nbap_BurstModeParams = -1;
static gint ett_nbap_IdleIntervalInformation = -1;
static gint ett_nbap_LCRTDD_Uplink_Physical_Channel_Capability = -1;
static gint ett_nbap_MACdPDU_Size_Indexlist = -1;
static gint ett_nbap_MACdPDU_Size_IndexItem = -1;
static gint ett_nbap_MACdPDU_Size_Indexlist_to_Modify = -1;
static gint ett_nbap_MACdPDU_Size_IndexItem_to_Modify = -1;
static gint ett_nbap_Max_TB_Sizes = -1;
static gint ett_nbap_MessageStructure = -1;
static gint ett_nbap_MessageStructure_item = -1;
static gint ett_nbap_MidambleShiftAndBurstType = -1;
static gint ett_nbap_Type1 = -1;
static gint ett_nbap_MidambleAllocationMode1 = -1;
static gint ett_nbap_Type2 = -1;
static gint ett_nbap_MidambleAllocationMode2 = -1;
static gint ett_nbap_Type3 = -1;
static gint ett_nbap_MidambleAllocationMode3 = -1;
static gint ett_nbap_MidambleShiftLCR = -1;
static gint ett_nbap_MidambleShiftAndBurstType768 = -1;
static gint ett_nbap_Type7681 = -1;
static gint ett_nbap_MidambleAllocationMode7681 = -1;
static gint ett_nbap_Type7682 = -1;
static gint ett_nbap_MidambleAllocationMode7682 = -1;
static gint ett_nbap_Type7683 = -1;
static gint ett_nbap_MidambleAllocationMode7683 = -1;
static gint ett_nbap_MIMO_PilotConfiguration = -1;
static gint ett_nbap_MIMO_PilotConfigurationExtension = -1;
static gint ett_nbap_ModifyPriorityQueue = -1;
static gint ett_nbap_ModulationPO_MBSFN = -1;
static gint ett_nbap_MultipleFreq_HARQ_MemoryPartitioning_InformationList = -1;
static gint ett_nbap_MultipleFreq_HARQ_MemoryPartitioning_InformationItem = -1;
static gint ett_nbap_MultipleFreq_HSPDSCH_InformationList_ResponseTDDLCR = -1;
static gint ett_nbap_MultipleFreq_HSPDSCH_InformationItem_ResponseTDDLCR = -1;
static gint ett_nbap_Multi_Cell_Capability_Info = -1;
static gint ett_nbap_Multicell_EDCH_InformationItemIEs = -1;
static gint ett_nbap_Multicell_EDCH_RL_Specific_InformationItemIEs = -1;
static gint ett_nbap_NeighbouringCellMeasurementInformation = -1;
static gint ett_nbap_NeighbouringCellMeasurementInformation_item = -1;
static gint ett_nbap_NeighbouringFDDCellMeasurementInformation = -1;
static gint ett_nbap_NeighbouringTDDCellMeasurementInformation = -1;
static gint ett_nbap_NeighbouringTDDCellMeasurementInformationLCR = -1;
static gint ett_nbap_NeighbouringTDDCellMeasurementInformation768 = -1;
static gint ett_nbap_NI_Information = -1;
static gint ett_nbap_NormalAndDiversityPrimaryCPICHContainer = -1;
static gint ett_nbap_Paging_MACFlows_to_DeleteFDD = -1;
static gint ett_nbap_Paging_MACFlows_to_DeleteFDD_Item = -1;
static gint ett_nbap_Paging_MACFlow_Specific_Information = -1;
static gint ett_nbap_Paging_MAC_Flow_Specific_Information_Item = -1;
static gint ett_nbap_Paging_MACFlow_PriorityQueue_Information = -1;
static gint ett_nbap_Paging_MACFlow_PriorityQueue_Item = -1;
static gint ett_nbap_PLCCHinformation = -1;
static gint ett_nbap_Possible_Secondary_Serving_Cell_List = -1;
static gint ett_nbap_Possible_Secondary_Serving_Cell = -1;
static gint ett_nbap_PreambleSignatures = -1;
static gint ett_nbap_PrimaryAndSecondaryCPICHContainer = -1;
static gint ett_nbap_Priority_Queue_Information_for_Enhanced_FACH_PCH = -1;
static gint ett_nbap_PriorityQueue_InfoList = -1;
static gint ett_nbap_PriorityQueue_InfoItem = -1;
static gint ett_nbap_PriorityQueue_InfoList_to_Modify = -1;
static gint ett_nbap_PriorityQueue_InfoItem_to_Add = -1;
static gint ett_nbap_PriorityQueue_InfoItem_to_Modify = -1;
static gint ett_nbap_PriorityQueue_InfoList_to_Modify_Unsynchronised = -1;
static gint ett_nbap_PriorityQueue_InfoItem_to_Modify_Unsynchronised = -1;
static gint ett_nbap_UE_Selected_MBMS_Service_Information = -1;
static gint ett_nbap_Selected_MBMS_Service = -1;
static gint ett_nbap_Selected_MBMS_Service_List = -1;
static gint ett_nbap_Selected_MBMS_Service_Item = -1;
static gint ett_nbap_Selected_MBMS_Service_TimeSlot_Information_LCR = -1;
static gint ett_nbap_MBMS_Service_TDM_Information = -1;
static gint ett_nbap_Paging_MACFlow_Specific_InformationLCR = -1;
static gint ett_nbap_Paging_MAC_Flow_Specific_Information_ItemLCR = -1;
static gint ett_nbap_Paging_MACFlows_to_DeleteLCR = -1;
static gint ett_nbap_Paging_MACFlows_to_DeleteLCR_Item = -1;
static gint ett_nbap_RACH_SubChannelNumbers = -1;
static gint ett_nbap_RL_Specific_DCH_Info = -1;
static gint ett_nbap_RL_Specific_DCH_Info_Item = -1;
static gint ett_nbap_RL_Specific_E_DCH_Info = -1;
static gint ett_nbap_RL_Specific_E_DCH_Information = -1;
static gint ett_nbap_RL_Specific_E_DCH_Information_Item = -1;
static gint ett_nbap_Reference_E_TFCI_Information = -1;
static gint ett_nbap_Reference_E_TFCI_Information_Item = -1;
static gint ett_nbap_ReportCharacteristics = -1;
static gint ett_nbap_ReportCharacteristicsType_EventA = -1;
static gint ett_nbap_ReportCharacteristicsType_EventB = -1;
static gint ett_nbap_ReportCharacteristicsType_EventC = -1;
static gint ett_nbap_ReportCharacteristicsType_EventD = -1;
static gint ett_nbap_ReportCharacteristicsType_EventE = -1;
static gint ett_nbap_ReportCharacteristicsType_EventF = -1;
static gint ett_nbap_ReportCharacteristicsType_OnModification = -1;
static gint ett_nbap_ReportCharacteristicsType_MeasurementIncreaseDecreaseThreshold = -1;
static gint ett_nbap_EDCH_RACH_Report_IncrDecrThres = -1;
static gint ett_nbap_ReportCharacteristicsType_MeasurementThreshold = -1;
static gint ett_nbap_EDCH_RACH_Report_ThresholdInformation = -1;
static gint ett_nbap_ReportCharacteristicsType_ScaledMeasurementChangeTime = -1;
static gint ett_nbap_ReportCharacteristicsType_ScaledMeasurementHysteresisTime = -1;
static gint ett_nbap_ReportCharacteristicsType_ReportPeriodicity = -1;
static gint ett_nbap_Received_total_wide_band_power_For_CellPortion_Value = -1;
static gint ett_nbap_Received_total_wide_band_power_For_CellPortion_Value_Item = -1;
static gint ett_nbap_Received_total_wide_band_power_For_CellPortion_ValueLCR = -1;
static gint ett_nbap_Received_total_wide_band_power_For_CellPortion_ValueLCR_Item = -1;
static gint ett_nbap_Received_Scheduled_EDCH_Power_Share_For_CellPortion_Value = -1;
static gint ett_nbap_Received_Scheduled_EDCH_Power_Share_For_CellPortion_Value_Item = -1;
static gint ett_nbap_Received_Scheduled_EDCH_Power_Share_Value = -1;
static gint ett_nbap_RequestedDataValueInformation = -1;
static gint ett_nbap_InformationAvailable = -1;
static gint ett_nbap_RequestedDataValue = -1;
static gint ett_nbap_SAT_Info_Almanac = -1;
static gint ett_nbap_SAT_Info_Almanac_Item = -1;
static gint ett_nbap_SAT_Info_Almanac_ExtList = -1;
static gint ett_nbap_SAT_Info_Almanac_ExtItem = -1;
static gint ett_nbap_SAT_Info_DGPSCorrections = -1;
static gint ett_nbap_SAT_Info_DGPSCorrections_Item = -1;
static gint ett_nbap_SATInfo_RealTime_Integrity = -1;
static gint ett_nbap_SAT_Info_RealTime_Integrity_Item = -1;
static gint ett_nbap_SecondaryServingCells = -1;
static gint ett_nbap_SecondaryServingCellsItem = -1;
static gint ett_nbap_Secondary_CPICH_Information_Change = -1;
static gint ett_nbap_Serving_E_DCH_RL_ID = -1;
static gint ett_nbap_Serving_E_DCH_RL_in_this_NodeB = -1;
static gint ett_nbap_SetsOfHS_SCCH_Codes = -1;
static gint ett_nbap_SetsOfHS_SCCH_CodesItem = -1;
static gint ett_nbap_Setup_Or_ConfigurationChange_Or_Removal_Of_EDCH_On_secondary_UL_Frequency = -1;
static gint ett_nbap_SFNSFNMeasurementThresholdInformation = -1;
static gint ett_nbap_SFNSFNMeasurementValueInformation = -1;
static gint ett_nbap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;
static gint ett_nbap_T_successfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;
static gint ett_nbap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation = -1;
static gint ett_nbap_T_unsuccessfullNeighbouringCellSFNSFNObservedTimeDifferenceMeasurementInformation_item = -1;
static gint ett_nbap_SFNSFNTimeStampInformation = -1;
static gint ett_nbap_SFNSFNTimeStamp_TDD = -1;
static gint ett_nbap_SFNSFNValue = -1;
static gint ett_nbap_SynchronisationReportCharacteristics = -1;
static gint ett_nbap_SynchronisationReportCharactThreExc = -1;
static gint ett_nbap_SynchronisationReportCharactThreInfoItem = -1;
static gint ett_nbap_SEQUENCE_SIZE_1_maxNrOfReceptsPerSyncFrame_OF_SynchronisationReportCharactCellSyncBurstInfoItem = -1;
static gint ett_nbap_SynchronisationReportCharactCellSyncBurstInfoItem = -1;
static gint ett_nbap_SyncDLCodeIdThreInfoLCR = -1;
static gint ett_nbap_SyncDLCodeIdThreInfoList = -1;
static gint ett_nbap_SyncDLCodeInfoListLCR = -1;
static gint ett_nbap_SyncDLCodeInfoItemLCR = -1;
static gint ett_nbap_TDD_ChannelisationCodeLCR = -1;
static gint ett_nbap_TDD_DL_Code_Information = -1;
static gint ett_nbap_TDD_DL_Code_InformationItem = -1;
static gint ett_nbap_TDD_DL_Code_LCR_Information = -1;
static gint ett_nbap_TDD_DL_Code_LCR_InformationItem = -1;
static gint ett_nbap_TDD_DL_Code_768_Information = -1;
static gint ett_nbap_TDD_DL_Code_768_InformationItem = -1;
static gint ett_nbap_TDD_DL_DPCH_TimeSlotFormat_LCR = -1;
static gint ett_nbap_TDD_DPCHOffset = -1;
static gint ett_nbap_TransportFormatCombination_Beta = -1;
static gint ett_nbap_T_signalledGainFactors = -1;
static gint ett_nbap_T_gainFactor = -1;
static gint ett_nbap_T_fdd = -1;
static gint ett_nbap_TDD_UL_Code_Information = -1;
static gint ett_nbap_TDD_UL_Code_InformationItem = -1;
static gint ett_nbap_TDD_UL_Code_LCR_Information = -1;
static gint ett_nbap_TDD_UL_Code_LCR_InformationItem = -1;
static gint ett_nbap_TDD_UL_Code_768_Information = -1;
static gint ett_nbap_TDD_UL_Code_768_InformationItem = -1;
static gint ett_nbap_TDD_UL_DPCH_TimeSlotFormat_LCR = -1;
static gint ett_nbap_TFCI_SignallingMode = -1;
static gint ett_nbap_TimeSlot_InitiatedListLCR = -1;
static gint ett_nbap_TimeSlotMeasurementValueListLCR = -1;
static gint ett_nbap_TimeSlotMeasurementValueLCR = -1;
static gint ett_nbap_TimingAdjustmentValue = -1;
static gint ett_nbap_TimingAdjustmentValueLCR = -1;
static gint ett_nbap_TnlQos = -1;
static gint ett_nbap_Transmission_Gap_Pattern_Sequence_Information = -1;
static gint ett_nbap_Transmission_Gap_Pattern_Sequence_Information_item = -1;
static gint ett_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue = -1;
static gint ett_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue_Item = -1;
static gint ett_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortionValue = -1;
static gint ett_nbap_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortionValue_Item = -1;
static gint ett_nbap_Transmitted_Carrier_Power_For_CellPortion_Value = -1;
static gint ett_nbap_Transmitted_Carrier_Power_For_CellPortion_Value_Item = -1;
static gint ett_nbap_Transmitted_Carrier_Power_For_CellPortion_ValueLCR = -1;
static gint ett_nbap_Transmitted_Carrier_Power_For_CellPortion_ValueLCR_Item = -1;
static gint ett_nbap_TFCS = -1;
static gint ett_nbap_T_tFCSvalues = -1;
static gint ett_nbap_TFCS_TFCSList = -1;
static gint ett_nbap_TFCS_TFCSList_item = -1;
static gint ett_nbap_TFCS_CTFC = -1;
static gint ett_nbap_Transport_Block_Size_List = -1;
static gint ett_nbap_Transport_Block_Size_List_item = -1;
static gint ett_nbap_TransportFormatSet = -1;
static gint ett_nbap_TransportFormatSet_DynamicPartList = -1;
static gint ett_nbap_TransportFormatSet_DynamicPartList_item = -1;
static gint ett_nbap_TDD_TransportFormatSet_ModeDP = -1;
static gint ett_nbap_TransmissionTimeIntervalInformation = -1;
static gint ett_nbap_TransmissionTimeIntervalInformation_item = -1;
static gint ett_nbap_TransportFormatSet_Semi_staticPart = -1;
static gint ett_nbap_TransportFormatSet_ModeDP = -1;
static gint ett_nbap_TransportFormatSet_ModeSSP = -1;
static gint ett_nbap_TUTRANGANSS = -1;
static gint ett_nbap_TUTRANGANSSMeasurementThresholdInformation = -1;
static gint ett_nbap_TUTRANGANSSMeasurementValueInformation = -1;
static gint ett_nbap_TUTRANGPS = -1;
static gint ett_nbap_TUTRANGPSMeasurementThresholdInformation = -1;
static gint ett_nbap_TUTRANGPSMeasurementValueInformation = -1;
static gint ett_nbap_UC_Id = -1;
static gint ett_nbap_UE_AggregateMaximumBitRate = -1;
static gint ett_nbap_UE_Capability_Information = -1;
static gint ett_nbap_UL_Timeslot_Information = -1;
static gint ett_nbap_UL_Timeslot_InformationItem = -1;
static gint ett_nbap_UL_TimeslotLCR_Information = -1;
static gint ett_nbap_UL_TimeslotLCR_InformationItem = -1;
static gint ett_nbap_UL_Timeslot768_Information = -1;
static gint ett_nbap_UL_Timeslot768_InformationItem = -1;
static gint ett_nbap_UL_ScramblingCode = -1;
static gint ett_nbap_UL_Synchronisation_Parameters_LCR = -1;
static gint ett_nbap_UL_TimeSlot_ISCP_Info = -1;
static gint ett_nbap_UL_TimeSlot_ISCP_InfoItem = -1;
static gint ett_nbap_UL_TimeSlot_ISCP_LCR_Info = -1;
static gint ett_nbap_UL_TimeSlot_ISCP_LCR_InfoItem = -1;
static gint ett_nbap_UpPTSInterference_For_CellPortion_Value = -1;
static gint ett_nbap_UpPTSInterference_For_CellPortion_Value_Item = -1;
static gint ett_nbap_USCH_Information = -1;
static gint ett_nbap_USCH_InformationItem = -1;
static gint ett_nbap_USCH_InformationResponse = -1;
static gint ett_nbap_USCH_InformationResponseItem = -1;
static gint ett_nbap_UL_TimeslotISCP_For_CellPortion_Value = -1;
static gint ett_nbap_UL_TimeslotISCP_For_CellPortion_Value_Item = -1;
static gint ett_nbap_CommonTransportChannelSetupRequestFDD = -1;
static gint ett_nbap_CommonPhysicalChannelType_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_Secondary_CCPCH_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_PowerOffsetInformation_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_FACH_ParametersListIE_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_FACH_ParametersItem_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_PCH_ParametersItem_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_PICH_Parameters_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_MICH_Parameters_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_PRACH_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_AllowedSlotFormatInformationList_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_AllowedSlotFormatInformationItem_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_RACH_ParametersItem_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_AICH_Parameters_CTCH_SetupRqstFDD = -1;
static gint ett_nbap_CommonTransportChannelSetupRequestTDD = -1;
static gint ett_nbap_CommonPhysicalChannelType_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_parameterListIE_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_parameterItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_LCR_parameterList_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_LCR_parameterItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_768_parameterList_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_768_parameterItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_FACH_ParametersListIE_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_FACH_ParametersItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PCH_ParametersItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PICH_ParametersItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PICH_LCR_Parameters_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PICH_768_ParametersItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_MICH_Parameters_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_MICH_TDDOption_Specific_Parameters_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_MICH_HCR_Parameters_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_MICH_LCR_Parameters_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_MICH_768_Parameters_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationList_LCR_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationItem_LCR_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_parameterExtendedList_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_LCR_parameterExtendedList_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PRACH_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PRACH_ParametersItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_RACH_ParameterItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PRACH_LCR_ParametersList_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PRACH_LCR_ParametersItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PRACH_768_ParametersItem_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_FPACH_LCR_Parameters_CTCH_SetupRqstTDD = -1;
static gint ett_nbap_PLCCH_parameters = -1;
static gint ett_nbap_E_RUCCH_parameters = -1;
static gint ett_nbap_E_RUCCH_768_parameters = -1;
static gint ett_nbap_CommonTransportChannelSetupResponse = -1;
static gint ett_nbap_FACH_CommonTransportChannel_InformationResponse = -1;
static gint ett_nbap_CommonTransportChannelSetupFailure = -1;
static gint ett_nbap_CommonTransportChannelReconfigurationRequestFDD = -1;
static gint ett_nbap_CommonPhysicalChannelType_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_Secondary_CCPCHList_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_FACH_ParametersListIE_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_FACH_ParametersItem_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_PCH_ParametersItem_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_PICH_ParametersItem_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_MICH_Parameters_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_PRACHList_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_PRACH_ParametersListIE_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_PRACH_ParametersItem_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_AllowedSlotFormatInformationList_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_AllowedSlotFormatInformationItem_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_AICH_ParametersListIE_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_AICH_ParametersItem_CTCH_ReconfRqstFDD = -1;
static gint ett_nbap_CommonTransportChannelReconfigurationRequestTDD = -1;
static gint ett_nbap_Secondary_CCPCH_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCHListIE_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCHItem_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_parameterExtendedList_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_LCR_parameterExtendedList_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_PICH_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_FACH_ParametersList_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_FACH_ParametersItem_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_PCH_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_FPACH_LCR_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_MICH_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_PLCCH_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_768_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_768_List_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_Secondary_CCPCH_768_Item_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_PICH_768_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_MICH_768_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_UPPCH_LCR_Parameters_CTCH_ReconfRqstTDD = -1;
static gint ett_nbap_CommonTransportChannelReconfigurationResponse = -1;
static gint ett_nbap_CommonTransportChannelReconfigurationFailure = -1;
static gint ett_nbap_CommonTransportChannelDeletionRequest = -1;
static gint ett_nbap_CommonTransportChannelDeletionResponse = -1;
static gint ett_nbap_BlockResourceRequest = -1;
static gint ett_nbap_BlockResourceResponse = -1;
static gint ett_nbap_BlockResourceFailure = -1;
static gint ett_nbap_UnblockResourceIndication = -1;
static gint ett_nbap_AuditRequiredIndication = -1;
static gint ett_nbap_AuditRequest = -1;
static gint ett_nbap_AuditResponse = -1;
static gint ett_nbap_Cell_InformationList_AuditRsp = -1;
static gint ett_nbap_Cell_InformationItem_AuditRsp = -1;
static gint ett_nbap_S_CPICH_InformationList_AuditRsp = -1;
static gint ett_nbap_S_CCPCH_InformationList_AuditRsp = -1;
static gint ett_nbap_FACH_InformationList_AuditRsp = -1;
static gint ett_nbap_PRACH_InformationList_AuditRsp = -1;
static gint ett_nbap_RACH_InformationList_AuditRsp = -1;
static gint ett_nbap_AICH_InformationList_AuditRsp = -1;
static gint ett_nbap_FPACH_LCR_InformationList_AuditRsp = -1;
static gint ett_nbap_HS_DSCH_Resources_Information_AuditRsp = -1;
static gint ett_nbap_S_CCPCH_InformationListExt_AuditRsp = -1;
static gint ett_nbap_S_CCPCH_LCR_InformationListExt_AuditRsp = -1;
static gint ett_nbap_E_DCH_Resources_Information_AuditRsp = -1;
static gint ett_nbap_PLCCH_InformationList_AuditRsp = -1;
static gint ett_nbap_S_CCPCH_768_InformationList_AuditRsp = -1;
static gint ett_nbap_PRACH_768_InformationList_AuditRsp = -1;
static gint ett_nbap_E_RUCCH_InformationList_AuditRsp = -1;
static gint ett_nbap_E_RUCCH_768_InformationList_AuditRsp = -1;
static gint ett_nbap_Cell_Frequency_List_Information_LCR_MulFreq_AuditRsp = -1;
static gint ett_nbap_Cell_Frequency_List_InformationItem_LCR_MulFreq_AuditRsp = -1;
static gint ett_nbap_UPPCH_LCR_InformationList_AuditRsp = -1;
static gint ett_nbap_UPPCH_LCR_InformationItem_AuditRsp = -1;
static gint ett_nbap_MultipleFreq_HS_DSCH_Resources_InformationList_AuditRsp = -1;
static gint ett_nbap_MultipleFreq_E_DCH_Resources_InformationList_AuditRsp = -1;
static gint ett_nbap_CCP_InformationList_AuditRsp = -1;
static gint ett_nbap_CCP_InformationItem_AuditRsp = -1;
static gint ett_nbap_Local_Cell_InformationList_AuditRsp = -1;
static gint ett_nbap_Local_Cell_InformationItem_AuditRsp = -1;
static gint ett_nbap_Local_Cell_Group_InformationList_AuditRsp = -1;
static gint ett_nbap_Local_Cell_Group_InformationItem_AuditRsp = -1;
static gint ett_nbap_Power_Local_Cell_Group_InformationList_AuditRsp = -1;
static gint ett_nbap_Power_Local_Cell_Group_InformationItem_AuditRsp = -1;
static gint ett_nbap_AuditFailure = -1;
static gint ett_nbap_CommonMeasurementInitiationRequest = -1;
static gint ett_nbap_CommonMeasurementObjectType_CM_Rqst = -1;
static gint ett_nbap_ERACH_CM_Rqst = -1;
static gint ett_nbap_Cell_CM_Rqst = -1;
static gint ett_nbap_RACH_CM_Rqst = -1;
static gint ett_nbap_PowerLocalCellGroup_CM_Rqst = -1;
static gint ett_nbap_CommonMeasurementInitiationResponse = -1;
static gint ett_nbap_CommonMeasurementObjectType_CM_Rsp = -1;
static gint ett_nbap_ERACH_CM_Rsp = -1;
static gint ett_nbap_Cell_CM_Rsp = -1;
static gint ett_nbap_RACH_CM_Rsp = -1;
static gint ett_nbap_PowerLocalCellGroup_CM_Rsp = -1;
static gint ett_nbap_CommonMeasurementInitiationFailure = -1;
static gint ett_nbap_CommonMeasurementReport = -1;
static gint ett_nbap_CommonMeasurementObjectType_CM_Rprt = -1;
static gint ett_nbap_ERACH_CM_Rprt = -1;
static gint ett_nbap_Cell_CM_Rprt = -1;
static gint ett_nbap_RACH_CM_Rprt = -1;
static gint ett_nbap_PowerLocalCellGroup_CM_Rprt = -1;
static gint ett_nbap_CommonMeasurementTerminationRequest = -1;
static gint ett_nbap_CommonMeasurementFailureIndication = -1;
static gint ett_nbap_CellSetupRequestFDD = -1;
static gint ett_nbap_Synchronisation_Configuration_Cell_SetupRqst = -1;
static gint ett_nbap_PrimarySCH_Information_Cell_SetupRqstFDD = -1;
static gint ett_nbap_SecondarySCH_Information_Cell_SetupRqstFDD = -1;
static gint ett_nbap_PrimaryCPICH_Information_Cell_SetupRqstFDD = -1;
static gint ett_nbap_SecondaryCPICH_InformationList_Cell_SetupRqstFDD = -1;
static gint ett_nbap_SecondaryCPICH_InformationItem_Cell_SetupRqstFDD = -1;
static gint ett_nbap_PrimaryCCPCH_Information_Cell_SetupRqstFDD = -1;
static gint ett_nbap_BCH_Information_Cell_SetupRqstFDD = -1;
static gint ett_nbap_Limited_power_increase_information_Cell_SetupRqstFDD = -1;
static gint ett_nbap_IPDLParameter_Information_Cell_SetupRqstFDD = -1;
static gint ett_nbap_CellPortion_InformationList_Cell_SetupRqstFDD = -1;
static gint ett_nbap_CellPortion_InformationItem_Cell_SetupRqstFDD = -1;
static gint ett_nbap_CellSetupRequestTDD = -1;
static gint ett_nbap_SCH_Information_Cell_SetupRqstTDD = -1;
static gint ett_nbap_SyncCaseIndicatorItem_Cell_SetupRqstTDD_PSCH = -1;
static gint ett_nbap_Case1_Cell_SetupRqstTDD = -1;
static gint ett_nbap_Case2_Cell_SetupRqstTDD = -1;
static gint ett_nbap_PCCPCH_Information_Cell_SetupRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationList_Cell_SetupRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationItem_Cell_SetupRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationList_LCR_Cell_SetupRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationItem_LCR_Cell_SetupRqstTDD = -1;
static gint ett_nbap_PCCPCH_LCR_Information_Cell_SetupRqstTDD = -1;
static gint ett_nbap_DwPCH_LCR_Information_Cell_SetupRqstTDD = -1;
static gint ett_nbap_IPDLParameter_Information_Cell_SetupRqstTDD = -1;
static gint ett_nbap_IPDLParameter_Information_LCR_Cell_SetupRqstTDD = -1;
static gint ett_nbap_PCCPCH_768_Information_Cell_SetupRqstTDD = -1;
static gint ett_nbap_SCH_768_Information_Cell_SetupRqstTDD = -1;
static gint ett_nbap_Cell_Frequency_List_LCR_MulFreq_Cell_SetupRqstTDD = -1;
static gint ett_nbap_Cell_Frequency_Item_LCR_MulFreq_Cell_SetupRqstTDD = -1;
static gint ett_nbap_CellSetupResponse = -1;
static gint ett_nbap_CellSetupFailure = -1;
static gint ett_nbap_CellReconfigurationRequestFDD = -1;
static gint ett_nbap_Synchronisation_Configuration_Cell_ReconfRqst = -1;
static gint ett_nbap_PrimarySCH_Information_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_SecondarySCH_Information_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_PrimaryCPICH_Information_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_SecondaryCPICH_InformationList_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_SecondaryCPICH_InformationItem_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_PrimaryCCPCH_Information_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_BCH_information_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_IPDLParameter_Information_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_CellPortion_InformationList_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_CellPortion_InformationItem_Cell_ReconfRqstFDD = -1;
static gint ett_nbap_CellReconfigurationRequestTDD = -1;
static gint ett_nbap_SCH_Information_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_PCCPCH_Information_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationList_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationItem_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationList_LCR_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_TimeSlotConfigurationItem_LCR_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_DwPCH_LCR_Information_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_IPDLParameter_Information_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_IPDLParameter_Information_LCR_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_SCH_768_Information_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_PCCPCH_768_Information_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_UARFCN_Adjustment = -1;
static gint ett_nbap_Cell_Frequency_Add_LCR_MulFreq_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_Cell_Frequency_ModifyList_LCR_MulFreq_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_Cell_Frequency_ModifyItem_LCR_MulFreq_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_Cell_Frequency_Delete_LCR_MulFreq_Cell_ReconfRqstTDD = -1;
static gint ett_nbap_CellReconfigurationResponse = -1;
static gint ett_nbap_CellReconfigurationFailure = -1;
static gint ett_nbap_CellDeletionRequest = -1;
static gint ett_nbap_CellDeletionResponse = -1;
static gint ett_nbap_ResourceStatusIndication = -1;
static gint ett_nbap_IndicationType_ResourceStatusInd = -1;
static gint ett_nbap_No_Failure_ResourceStatusInd = -1;
static gint ett_nbap_Local_Cell_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_Local_Cell_InformationItem_ResourceStatusInd = -1;
static gint ett_nbap_Local_Cell_Group_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_Local_Cell_Group_InformationItem_ResourceStatusInd = -1;
static gint ett_nbap_Power_Local_Cell_Group_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_Power_Local_Cell_Group_InformationItem_ResourceStatusInd = -1;
static gint ett_nbap_ServiceImpacting_ResourceStatusInd = -1;
static gint ett_nbap_Local_Cell_InformationList2_ResourceStatusInd = -1;
static gint ett_nbap_Local_Cell_InformationItem2_ResourceStatusInd = -1;
static gint ett_nbap_Local_Cell_Group_InformationList2_ResourceStatusInd = -1;
static gint ett_nbap_Local_Cell_Group_InformationItem2_ResourceStatusInd = -1;
static gint ett_nbap_CCP_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_CCP_InformationItem_ResourceStatusInd = -1;
static gint ett_nbap_Cell_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_Cell_InformationItem_ResourceStatusInd = -1;
static gint ett_nbap_S_CPICH_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_S_CCPCH_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_FACH_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_PRACH_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_RACH_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_AICH_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_FPACH_LCR_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_HS_DSCH_Resources_Information_ResourceStatusInd = -1;
static gint ett_nbap_S_CCPCH_InformationListExt_ResourceStatusInd = -1;
static gint ett_nbap_S_CCPCH_LCR_InformationListExt_ResourceStatusInd = -1;
static gint ett_nbap_E_DCH_Resources_Information_ResourceStatusInd = -1;
static gint ett_nbap_PLCCH_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_S_CCPCH_768_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_PRACH_768_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_E_RUCCH_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_E_RUCCH_768_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_Cell_Frequency_List_Information_LCR_MulFreq_ResourceStatusInd = -1;
static gint ett_nbap_Cell_Frequency_List_InformationItem_LCR_MulFreq_ResourceStatusInd = -1;
static gint ett_nbap_UPPCH_LCR_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_UPPCH_LCR_InformationItem_ResourceStatusInd = -1;
static gint ett_nbap_MultipleFreq_HS_DSCH_Resources_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_Power_Local_Cell_Group_InformationList2_ResourceStatusInd = -1;
static gint ett_nbap_Power_Local_Cell_Group_InformationItem2_ResourceStatusInd = -1;
static gint ett_nbap_MultipleFreq_E_DCH_Resources_InformationList_ResourceStatusInd = -1;
static gint ett_nbap_SystemInformationUpdateRequest = -1;
static gint ett_nbap_MIB_SB_SIB_InformationList_SystemInfoUpdateRqst = -1;
static gint ett_nbap_MIB_SB_SIB_InformationItem_SystemInfoUpdateRqst = -1;
static gint ett_nbap_DeletionIndicator_SystemInfoUpdate = -1;
static gint ett_nbap_No_Deletion_SystemInfoUpdate = -1;
static gint ett_nbap_SegmentInformationListIE_SystemInfoUpdate = -1;
static gint ett_nbap_SegmentInformationItem_SystemInfoUpdate = -1;
static gint ett_nbap_SystemInformationUpdateResponse = -1;
static gint ett_nbap_SystemInformationUpdateFailure = -1;
static gint ett_nbap_RadioLinkSetupRequestFDD = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Setup_List = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Setup_ItemIEs = -1;
static gint ett_nbap_UL_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_nbap_DL_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_nbap_PowerOffsetInformation_RL_SetupRqstFDD = -1;
static gint ett_nbap_RL_InformationList_RL_SetupRqstFDD = -1;
static gint ett_nbap_RL_InformationItem_RL_SetupRqstFDD = -1;
static gint ett_nbap_E_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_nbap_F_DPCH_Information_RL_SetupRqstFDD = -1;
static gint ett_nbap_PowerOffsetInformation_F_DPCH_RL_SetupRqstFDD = -1;
static gint ett_nbap_RadioLinkSetupRequestTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationList_RL_SetupRqstTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationItem_RL_SetupRqstTDD = -1;
static gint ett_nbap_UL_DPCH_InformationItem_RL_SetupRqstTDD = -1;
static gint ett_nbap_UL_DPCH_LCR_Information_RL_SetupRqstTDD = -1;
static gint ett_nbap_UL_DPCH_768_Information_RL_SetupRqstTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationList_RL_SetupRqstTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationItem_RL_SetupRqstTDD = -1;
static gint ett_nbap_CCTrCH_TPCList_RL_SetupRqstTDD = -1;
static gint ett_nbap_CCTrCH_TPCItem_RL_SetupRqstTDD = -1;
static gint ett_nbap_DL_DPCH_InformationItem_RL_SetupRqstTDD = -1;
static gint ett_nbap_DL_DPCH_LCR_Information_RL_SetupRqstTDD = -1;
static gint ett_nbap_DL_DPCH_768_Information_RL_SetupRqstTDD = -1;
static gint ett_nbap_RL_Information_RL_SetupRqstTDD = -1;
static gint ett_nbap_RadioLinkSetupResponseFDD = -1;
static gint ett_nbap_Additional_HS_Cell_Information_Response_List = -1;
static gint ett_nbap_Additional_HS_Cell_Information_Response_ItemIEs = -1;
static gint ett_nbap_RL_InformationResponseList_RL_SetupRspFDD = -1;
static gint ett_nbap_RL_InformationResponseItem_RL_SetupRspFDD = -1;
static gint ett_nbap_DiversityIndication_RL_SetupRspFDD = -1;
static gint ett_nbap_Combining_RL_SetupRspFDD = -1;
static gint ett_nbap_NonCombiningOrFirstRL_RL_SetupRspFDD = -1;
static gint ett_nbap_RadioLinkSetupResponseTDD = -1;
static gint ett_nbap_RL_InformationResponse_RL_SetupRspTDD = -1;
static gint ett_nbap_RL_InformationResponse_LCR_RL_SetupRspTDD = -1;
static gint ett_nbap_RadioLinkSetupFailureFDD = -1;
static gint ett_nbap_CauseLevel_RL_SetupFailureFDD = -1;
static gint ett_nbap_GeneralCauseList_RL_SetupFailureFDD = -1;
static gint ett_nbap_RLSpecificCauseList_RL_SetupFailureFDD = -1;
static gint ett_nbap_Unsuccessful_RL_InformationRespList_RL_SetupFailureFDD = -1;
static gint ett_nbap_Unsuccessful_RL_InformationRespItem_RL_SetupFailureFDD = -1;
static gint ett_nbap_Successful_RL_InformationRespList_RL_SetupFailureFDD = -1;
static gint ett_nbap_Successful_RL_InformationRespItem_RL_SetupFailureFDD = -1;
static gint ett_nbap_DiversityIndication_RL_SetupFailureFDD = -1;
static gint ett_nbap_Combining_RL_SetupFailureFDD = -1;
static gint ett_nbap_NonCombiningOrFirstRL_RL_SetupFailureFDD = -1;
static gint ett_nbap_RadioLinkSetupFailureTDD = -1;
static gint ett_nbap_CauseLevel_RL_SetupFailureTDD = -1;
static gint ett_nbap_GeneralCauseList_RL_SetupFailureTDD = -1;
static gint ett_nbap_RLSpecificCauseList_RL_SetupFailureTDD = -1;
static gint ett_nbap_Unsuccessful_RL_InformationResp_RL_SetupFailureTDD = -1;
static gint ett_nbap_RadioLinkAdditionRequestFDD = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Addition_List = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_RL_Add_Req = -1;
static gint ett_nbap_Setup_Or_Addition_Of_EDCH_On_secondary_UL_Frequency = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Addition_ItemIEs = -1;
static gint ett_nbap_RL_InformationList_RL_AdditionRqstFDD = -1;
static gint ett_nbap_RL_InformationItem_RL_AdditionRqstFDD = -1;
static gint ett_nbap_E_DPCH_Information_RL_AdditionReqFDD = -1;
static gint ett_nbap_RadioLinkAdditionRequestTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationList_RL_AdditionRqstTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationItem_RL_AdditionRqstTDD = -1;
static gint ett_nbap_UL_DPCH_InformationItem_RL_AdditionRqstTDD = -1;
static gint ett_nbap_UL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD = -1;
static gint ett_nbap_UL_DPCH_InformationItem_768_RL_AdditionRqstTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationList_RL_AdditionRqstTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationItem_RL_AdditionRqstTDD = -1;
static gint ett_nbap_DL_DPCH_InformationItem_RL_AdditionRqstTDD = -1;
static gint ett_nbap_DL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD = -1;
static gint ett_nbap_DL_DPCH_InformationItem_768_RL_AdditionRqstTDD = -1;
static gint ett_nbap_RL_Information_RL_AdditionRqstTDD = -1;
static gint ett_nbap_RadioLinkAdditionResponseFDD = -1;
static gint ett_nbap_Additional_HS_Cell_Change_Information_Response_List = -1;
static gint ett_nbap_Additional_HS_Cell_Change_Information_Response_ItemIEs = -1;
static gint ett_nbap_RL_InformationResponseList_RL_AdditionRspFDD = -1;
static gint ett_nbap_RL_InformationResponseItem_RL_AdditionRspFDD = -1;
static gint ett_nbap_DiversityIndication_RL_AdditionRspFDD = -1;
static gint ett_nbap_Combining_RL_AdditionRspFDD = -1;
static gint ett_nbap_Non_Combining_RL_AdditionRspFDD = -1;
static gint ett_nbap_RadioLinkAdditionResponseTDD = -1;
static gint ett_nbap_RL_InformationResponse_RL_AdditionRspTDD = -1;
static gint ett_nbap_DCH_Information_RL_AdditionRspTDD = -1;
static gint ett_nbap_DiversityIndication_RL_AdditionRspTDD = -1;
static gint ett_nbap_Combining_RL_AdditionRspTDD = -1;
static gint ett_nbap_Non_Combining_RL_AdditionRspTDD = -1;
static gint ett_nbap_RL_InformationResponse_LCR_RL_AdditionRspTDD = -1;
static gint ett_nbap_RadioLinkAdditionFailureFDD = -1;
static gint ett_nbap_CauseLevel_RL_AdditionFailureFDD = -1;
static gint ett_nbap_GeneralCauseList_RL_AdditionFailureFDD = -1;
static gint ett_nbap_RLSpecificCauseList_RL_AdditionFailureFDD = -1;
static gint ett_nbap_Unsuccessful_RL_InformationRespList_RL_AdditionFailureFDD = -1;
static gint ett_nbap_Unsuccessful_RL_InformationRespItem_RL_AdditionFailureFDD = -1;
static gint ett_nbap_Successful_RL_InformationRespList_RL_AdditionFailureFDD = -1;
static gint ett_nbap_Successful_RL_InformationRespItem_RL_AdditionFailureFDD = -1;
static gint ett_nbap_DiversityIndication_RL_AdditionFailureFDD = -1;
static gint ett_nbap_Combining_RL_AdditionFailureFDD = -1;
static gint ett_nbap_Non_Combining_RL_AdditionFailureFDD = -1;
static gint ett_nbap_RadioLinkAdditionFailureTDD = -1;
static gint ett_nbap_CauseLevel_RL_AdditionFailureTDD = -1;
static gint ett_nbap_GeneralCauseList_RL_AdditionFailureTDD = -1;
static gint ett_nbap_RLSpecificCauseList_RL_AdditionFailureTDD = -1;
static gint ett_nbap_Unsuccessful_RL_InformationResp_RL_AdditionFailureTDD = -1;
static gint ett_nbap_RadioLinkReconfigurationPrepareFDD = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Reconf_Prep = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Reconf_Prep_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_RL_Reconf_Prep = -1;
static gint ett_nbap_UL_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_nbap_DL_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_nbap_DL_DPCH_Power_Information_RL_ReconfPrepFDD = -1;
static gint ett_nbap_PowerOffsetInformation_RL_ReconfPrepFDD = -1;
static gint ett_nbap_DCH_DeleteList_RL_ReconfPrepFDD = -1;
static gint ett_nbap_DCH_DeleteItem_RL_ReconfPrepFDD = -1;
static gint ett_nbap_RL_InformationList_RL_ReconfPrepFDD = -1;
static gint ett_nbap_RL_InformationItem_RL_ReconfPrepFDD = -1;
static gint ett_nbap_E_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_nbap_F_DPCH_Information_RL_ReconfPrepFDD = -1;
static gint ett_nbap_PowerOffsetInformation_F_DPCH_RL_ReconfPrepFDD = -1;
static gint ett_nbap_RadioLinkReconfigurationPrepareTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_DPCH_InformationAddItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_UL_DPCH_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_UL_DPCH_InformationAddListIE_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_DPCH_768_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_DPCH_InformationModify_AddItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_DPCH_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_Timeslot_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_Timeslot_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_Code_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_TimeslotLCR_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_Timeslot_LCR_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDDLCR = -1;
static gint ett_nbap_UL_Code_InformationModify_ModifyItem_RL_ReconfPrepTDDLCR = -1;
static gint ett_nbap_UL_Timeslot768_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_Timeslot_768_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD768 = -1;
static gint ett_nbap_UL_Code_InformationModify_ModifyItem_RL_ReconfPrepTDD768 = -1;
static gint ett_nbap_UL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_DPCH_InformationModify_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_UL_DPCH_InformationModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_UL_DPCH_InformationModifyListIE_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_DPCH_768_InformationModify_AddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationAddItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_CCTrCH_TPCAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_CCTrCH_TPCAddItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_InformationAddItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_DL_DPCH_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_DL_DPCH_InformationAddListIE_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_768_InformationAddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_CCTrCH_TPCModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_CCTrCH_TPCModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_InformationModify_AddItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Timeslot_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Timeslot_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Code_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Code_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Timeslot_LCR_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Code_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Code_LCR_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Timeslot_768_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Timeslot_768_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Code_768_InformationModify_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_Code_768_InformationModify_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_InformationModify_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_DL_DPCH_InformationModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_DL_DPCH_InformationModifyListIE_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_DPCH_768_InformationModify_AddList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationDeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DCH_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DCH_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DSCH_Information_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DSCH_Information_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DSCH_Information_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_DSCH_Information_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_USCH_Information_ModifyList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_USCH_Information_ModifyItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_USCH_Information_DeleteList_RL_ReconfPrepTDD = -1;
static gint ett_nbap_USCH_Information_DeleteItem_RL_ReconfPrepTDD = -1;
static gint ett_nbap_MultipleRL_Information_RL_ReconfPrepTDD = -1;
static gint ett_nbap_RL_Information_RL_ReconfPrepTDD = -1;
static gint ett_nbap_RadioLinkReconfigurationReady = -1;
static gint ett_nbap_RL_InformationResponseList_RL_ReconfReady = -1;
static gint ett_nbap_RL_InformationResponseItem_RL_ReconfReady = -1;
static gint ett_nbap_RadioLinkReconfigurationFailure = -1;
static gint ett_nbap_CauseLevel_RL_ReconfFailure = -1;
static gint ett_nbap_GeneralCauseList_RL_ReconfFailure = -1;
static gint ett_nbap_RLSpecificCauseList_RL_ReconfFailure = -1;
static gint ett_nbap_RL_ReconfigurationFailureList_RL_ReconfFailure = -1;
static gint ett_nbap_RL_ReconfigurationFailureItem_RL_ReconfFailure = -1;
static gint ett_nbap_RadioLinkReconfigurationCommit = -1;
static gint ett_nbap_RadioLinkReconfigurationCancel = -1;
static gint ett_nbap_RadioLinkReconfigurationRequestFDD = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Reconf_Req = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Reconf_Req_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_RL_Reconf_Req = -1;
static gint ett_nbap_UL_DPCH_Information_RL_ReconfRqstFDD = -1;
static gint ett_nbap_DL_DPCH_Information_RL_ReconfRqstFDD = -1;
static gint ett_nbap_DCH_DeleteList_RL_ReconfRqstFDD = -1;
static gint ett_nbap_DCH_DeleteItem_RL_ReconfRqstFDD = -1;
static gint ett_nbap_RL_InformationList_RL_ReconfRqstFDD = -1;
static gint ett_nbap_RL_InformationItem_RL_ReconfRqstFDD = -1;
static gint ett_nbap_E_DPCH_Information_RL_ReconfRqstFDD = -1;
static gint ett_nbap_RadioLinkReconfigurationRequestTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = -1;
static gint ett_nbap_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD = -1;
static gint ett_nbap_MultipleRL_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD = -1;
static gint ett_nbap_MultipleRL_DL_CCTrCH_InformationModifyListIE_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DL_DPCH_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DL_Timeslot_LCR_InformationModify_ModifyItem_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DCH_DeleteList_RL_ReconfRqstTDD = -1;
static gint ett_nbap_DCH_DeleteItem_RL_ReconfRqstTDD = -1;
static gint ett_nbap_Multiple_RL_Information_RL_ReconfRqstTDD = -1;
static gint ett_nbap_RL_Information_RL_ReconfRqstTDD = -1;
static gint ett_nbap_RadioLinkReconfigurationResponse = -1;
static gint ett_nbap_RL_InformationResponseList_RL_ReconfRsp = -1;
static gint ett_nbap_RL_InformationResponseItem_RL_ReconfRsp = -1;
static gint ett_nbap_RadioLinkDeletionRequest = -1;
static gint ett_nbap_RL_informationList_RL_DeletionRqst = -1;
static gint ett_nbap_RL_informationItem_RL_DeletionRqst = -1;
static gint ett_nbap_RadioLinkDeletionResponse = -1;
static gint ett_nbap_DL_PowerControlRequest = -1;
static gint ett_nbap_DL_ReferencePowerInformationList_DL_PC_Rqst = -1;
static gint ett_nbap_DL_ReferencePowerInformationItem_DL_PC_Rqst = -1;
static gint ett_nbap_DL_PowerTimeslotControlRequest = -1;
static gint ett_nbap_DedicatedMeasurementInitiationRequest = -1;
static gint ett_nbap_DedicatedMeasurementObjectType_DM_Rqst = -1;
static gint ett_nbap_RL_DM_Rqst = -1;
static gint ett_nbap_RL_InformationList_DM_Rqst = -1;
static gint ett_nbap_RL_InformationItem_DM_Rqst = -1;
static gint ett_nbap_PUSCH_Info_DM_Rqst = -1;
static gint ett_nbap_HSSICH_Info_DM_Rqst = -1;
static gint ett_nbap_HSSICH_InfoExt_DM_Rqst = -1;
static gint ett_nbap_RL_Set_DM_Rqst = -1;
static gint ett_nbap_RL_Set_InformationList_DM_Rqst = -1;
static gint ett_nbap_RL_Set_InformationItem_DM_Rqst = -1;
static gint ett_nbap_DedicatedMeasurementInitiationResponse = -1;
static gint ett_nbap_DedicatedMeasurementObjectType_DM_Rsp = -1;
static gint ett_nbap_RL_DM_Rsp = -1;
static gint ett_nbap_RL_InformationList_DM_Rsp = -1;
static gint ett_nbap_RL_InformationItem_DM_Rsp = -1;
static gint ett_nbap_PUSCH_Info_DM_Rsp = -1;
static gint ett_nbap_Multiple_PUSCH_InfoList_DM_Rsp = -1;
static gint ett_nbap_Multiple_PUSCH_InfoListIE_DM_Rsp = -1;
static gint ett_nbap_Multiple_DedicatedMeasurementValueList_TDD_DM_Rsp = -1;
static gint ett_nbap_Multiple_DedicatedMeasurementValueItem_TDD_DM_Rsp = -1;
static gint ett_nbap_Multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp = -1;
static gint ett_nbap_Multiple_DedicatedMeasurementValueItem_LCR_TDD_DM_Rsp = -1;
static gint ett_nbap_Multiple_HSSICHMeasurementValueList_TDD_DM_Rsp = -1;
static gint ett_nbap_Multiple_HSSICHMeasurementValueItem_TDD_DM_Rsp = -1;
static gint ett_nbap_Multiple_DedicatedMeasurementValueList_768_TDD_DM_Rsp = -1;
static gint ett_nbap_Multiple_DedicatedMeasurementValueItem_768_TDD_DM_Rsp = -1;
static gint ett_nbap_RL_Set_DM_Rsp = -1;
static gint ett_nbap_RL_Set_InformationList_DM_Rsp = -1;
static gint ett_nbap_RL_Set_InformationItem_DM_Rsp = -1;
static gint ett_nbap_DedicatedMeasurementInitiationFailure = -1;
static gint ett_nbap_DedicatedMeasurementReport = -1;
static gint ett_nbap_DedicatedMeasurementObjectType_DM_Rprt = -1;
static gint ett_nbap_RL_DM_Rprt = -1;
static gint ett_nbap_RL_InformationList_DM_Rprt = -1;
static gint ett_nbap_RL_InformationItem_DM_Rprt = -1;
static gint ett_nbap_PUSCH_Info_DM_Rprt = -1;
static gint ett_nbap_Multiple_PUSCH_InfoList_DM_Rprt = -1;
static gint ett_nbap_Multiple_PUSCH_InfoListIE_DM_Rprt = -1;
static gint ett_nbap_RL_Set_DM_Rprt = -1;
static gint ett_nbap_RL_Set_InformationList_DM_Rprt = -1;
static gint ett_nbap_RL_Set_InformationItem_DM_Rprt = -1;
static gint ett_nbap_DedicatedMeasurementTerminationRequest = -1;
static gint ett_nbap_DedicatedMeasurementFailureIndication = -1;
static gint ett_nbap_RadioLinkFailureIndication = -1;
static gint ett_nbap_Reporting_Object_RL_FailureInd = -1;
static gint ett_nbap_RL_RL_FailureInd = -1;
static gint ett_nbap_RL_InformationList_RL_FailureInd = -1;
static gint ett_nbap_RL_InformationItem_RL_FailureInd = -1;
static gint ett_nbap_RL_Set_RL_FailureInd = -1;
static gint ett_nbap_RL_Set_InformationList_RL_FailureInd = -1;
static gint ett_nbap_RL_Set_InformationItem_RL_FailureInd = -1;
static gint ett_nbap_CCTrCH_RL_FailureInd = -1;
static gint ett_nbap_CCTrCH_InformationList_RL_FailureInd = -1;
static gint ett_nbap_CCTrCH_InformationItem_RL_FailureInd = -1;
static gint ett_nbap_RadioLinkPreemptionRequiredIndication = -1;
static gint ett_nbap_RL_InformationList_RL_PreemptRequiredInd = -1;
static gint ett_nbap_RL_InformationItem_RL_PreemptRequiredInd = -1;
static gint ett_nbap_RadioLinkRestoreIndication = -1;
static gint ett_nbap_Reporting_Object_RL_RestoreInd = -1;
static gint ett_nbap_RL_RL_RestoreInd = -1;
static gint ett_nbap_RL_InformationList_RL_RestoreInd = -1;
static gint ett_nbap_RL_InformationItem_RL_RestoreInd = -1;
static gint ett_nbap_RL_Set_RL_RestoreInd = -1;
static gint ett_nbap_RL_Set_InformationList_RL_RestoreInd = -1;
static gint ett_nbap_RL_Set_InformationItem_RL_RestoreInd = -1;
static gint ett_nbap_CCTrCH_RL_RestoreInd = -1;
static gint ett_nbap_CCTrCH_InformationList_RL_RestoreInd = -1;
static gint ett_nbap_CCTrCH_InformationItem_RL_RestoreInd = -1;
static gint ett_nbap_CompressedModeCommand = -1;
static gint ett_nbap_ErrorIndication = -1;
static gint ett_nbap_PrivateMessage = -1;
static gint ett_nbap_PhysicalSharedChannelReconfigurationRequestFDD = -1;
static gint ett_nbap_HSDPA_And_EDCH_CellPortion_InformationList_PSCH_ReconfRqst = -1;
static gint ett_nbap_HSDPA_And_EDCH_CellPortion_InformationItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PhysicalSharedChannelReconfigurationRequestTDD = -1;
static gint ett_nbap_PDSCHSets_AddList_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCHSets_AddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCH_Information_AddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_InformationAddList_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_InformationAddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_InformationAddList_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_InformationAddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCH_AddInformation_LCR_AddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_InformationAddList_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_InformationAddItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_InformationAddList_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_InformationAddItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCH_AddInformation_768_AddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_InformationAddList_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_InformationAddItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_InformationAddList_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_InformationAddItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCHSets_ModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCHSets_ModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCH_Information_ModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCH_ModifyInformation_LCR_ModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_LCR_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_LCR_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_LCR_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_LCR_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCH_ModifyInformation_768_ModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_768_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Timeslot_768_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_768_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_Code_768_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCHSets_DeleteList_PSCH_ReconfRqst = -1;
static gint ett_nbap_PDSCHSets_DeleteItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCHSets_AddList_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCHSets_AddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCH_Information_AddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_InformationAddList_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_InformationAddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_InformationAddList_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_InformationAddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCH_AddInformation_LCR_AddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_InformationAddList_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_InformationAddItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_InformationAddList_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_InformationAddItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCH_AddInformation_768_AddItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_InformationAddList_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_InformationAddItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_InformationAddList_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_InformationAddItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCHSets_ModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCHSets_ModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCH_Information_ModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCH_ModifyInformation_LCR_ModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_LCR_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_LCR_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_LCR_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_LCR_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCH_ModifyInformation_768_ModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_768_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Timeslot_768_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_768_InformationModifyList_PSCH_ReconfRqst = -1;
static gint ett_nbap_UL_Code_768_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCHSets_DeleteList_PSCH_ReconfRqst = -1;
static gint ett_nbap_PUSCHSets_DeleteItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_PDSCH_TDD_Information_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_HS_PDSCH_Timeslot_Information_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_HS_PDSCH_Timeslot_InformationItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_HS_PDSCH_Codelist_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_HS_PDSCH_Timeslot_Information_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_HS_PDSCH_Timeslot_InformationItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_DL_HS_PDSCH_Codelist_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_Add_To_HS_SCCH_Resource_Pool_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_Information_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SICH_Information_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_Information_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SICH_Information_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_Information_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SICH_Information_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationExt_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Modify_HS_SCCH_Resource_Pool_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SICH_InformationModify_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationModify_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationModifyItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationModifyExt_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SICH_InformationModify_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationModify_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationModifyItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SICH_InformationModify_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_HS_SCCH_InformationModify_PSCH_ReconfRqst = -1;
static gint ett_nbap_Delete_From_HS_SCCH_Resource_Pool_PSCH_ReconfRqst = -1;
static gint ett_nbap_Delete_From_HS_SCCH_Resource_PoolItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_PUCH_Information_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_PUCH_Timeslot_Info = -1;
static gint ett_nbap_Add_To_E_AGCH_Resource_Pool_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_Information_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_Modify_E_AGCH_Resource_Pool_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationModify_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationModifyItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_Delete_From_E_AGCH_Resource_Pool_PSCH_ReconfRqst = -1;
static gint ett_nbap_Delete_From_E_AGCH_Resource_PoolItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_HICH_Information_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_PUCH_Information_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_Add_To_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_Information_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_Modify_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationModify_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationModifyItem_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_HICH_Information_768_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_PUCH_Information_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_PUCH_Timeslot_InfoLCR = -1;
static gint ett_nbap_E_PUCH_Timeslot_Item_InfoLCR = -1;
static gint ett_nbap_E_PUCH_Codelist_LCR = -1;
static gint ett_nbap_Add_To_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_Information_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Modify_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationModify_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_AGCH_InformationModifyItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Add_To_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_HICH_Information_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_HICH_InformationItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Modify_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_HICH_InformationModify_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_E_HICH_InformationModifyItem_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Delete_From_E_HICH_Resource_Pool_PSCH_ReconfRqst = -1;
static gint ett_nbap_Delete_From_E_HICH_Resource_PoolItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_SYNC_UL_Partition_LCR = -1;
static gint ett_nbap_Delete_From_HS_SCCH_Resource_PoolExt_PSCH_ReconfRqst = -1;
static gint ett_nbap_MultipleFreq_E_PUCH_Timeslot_InformationList_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_MultipleFreq_E_PUCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst = -1;
static gint ett_nbap_Max_RTWP_perUARFCN_Information_LCR_PSCH_ReconfRqst = -1;
static gint ett_nbap_Max_RTWP_perUARFCN_Information_LCR_PSCH_ReconfRqst_Item = -1;
static gint ett_nbap_PhysicalSharedChannelReconfigurationResponse = -1;
static gint ett_nbap_E_HICH_TimeOffset_ExtensionLCR = -1;
static gint ett_nbap_MultipleFreq_E_HICH_TimeOffsetLCR = -1;
static gint ett_nbap_PhysicalSharedChannelReconfigurationFailure = -1;
static gint ett_nbap_CauseLevel_PSCH_ReconfFailure = -1;
static gint ett_nbap_GeneralCauseList_PSCH_ReconfFailure = -1;
static gint ett_nbap_SetSpecificCauseList_PSCH_ReconfFailureTDD = -1;
static gint ett_nbap_Unsuccessful_PDSCHSetList_PSCH_ReconfFailureTDD = -1;
static gint ett_nbap_Unsuccessful_PDSCHSetItem_PSCH_ReconfFailureTDD = -1;
static gint ett_nbap_Unsuccessful_PUSCHSetList_PSCH_ReconfFailureTDD = -1;
static gint ett_nbap_Unsuccessful_PUSCHSetItem_PSCH_ReconfFailureTDD = -1;
static gint ett_nbap_UARFCNSpecificCauseList_PSCH_ReconfFailureTDD = -1;
static gint ett_nbap_Unsuccessful_UARFCNItem_PSCH_ReconfFailureTDD = -1;
static gint ett_nbap_E_HICH_TimeOffset_ReconfFailureTDD = -1;
static gint ett_nbap_Common_System_Information_ResponseLCR = -1;
static gint ett_nbap_ResetRequest = -1;
static gint ett_nbap_ResetIndicator = -1;
static gint ett_nbap_CommunicationContextList_Reset = -1;
static gint ett_nbap_CommunicationContextInfoList_Reset = -1;
static gint ett_nbap_CommunicationContextInfoItem_Reset = -1;
static gint ett_nbap_CommunicationContextType_Reset = -1;
static gint ett_nbap_CommunicationControlPortList_Reset = -1;
static gint ett_nbap_CommunicationControlPortInfoList_Reset = -1;
static gint ett_nbap_CommunicationControlPortInfoItem_Reset = -1;
static gint ett_nbap_ResetResponse = -1;
static gint ett_nbap_InformationExchangeInitiationRequest = -1;
static gint ett_nbap_InformationExchangeObjectType_InfEx_Rqst = -1;
static gint ett_nbap_Cell_InfEx_Rqst = -1;
static gint ett_nbap_InformationExchangeInitiationResponse = -1;
static gint ett_nbap_InformationExchangeObjectType_InfEx_Rsp = -1;
static gint ett_nbap_Cell_InfEx_Rsp = -1;
static gint ett_nbap_InformationExchangeInitiationFailure = -1;
static gint ett_nbap_InformationReport = -1;
static gint ett_nbap_InformationExchangeObjectType_InfEx_Rprt = -1;
static gint ett_nbap_Cell_Inf_Rprt = -1;
static gint ett_nbap_InformationExchangeTerminationRequest = -1;
static gint ett_nbap_InformationExchangeFailureIndication = -1;
static gint ett_nbap_CellSynchronisationInitiationRequestTDD = -1;
static gint ett_nbap_TimeslotInfo_CellSyncInitiationRqstTDD = -1;
static gint ett_nbap_CellSyncBurstTransInit_CellSyncInitiationRqstTDD = -1;
static gint ett_nbap_CellSyncBurstMeasureInit_CellSyncInitiationRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeId_TransInitLCR_CellSyncInitiationRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeId_MeasureInitLCR_CellSyncInitiationRqstTDD = -1;
static gint ett_nbap_CellSynchronisationInitiationResponseTDD = -1;
static gint ett_nbap_CellSynchronisationInitiationFailureTDD = -1;
static gint ett_nbap_CellSynchronisationReconfigurationRequestTDD = -1;
static gint ett_nbap_CellSyncBurstTransReconfInfo_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_CellSyncBurstTransInfoItem_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_CellSyncBurstMeasInfo_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_CellSyncBurstMeasInfoListIE_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_CellSyncBurstMeasInfoItem_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_CellSyncBurstInfoList_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_CellSyncBurstInfoItem_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeIdTransReconfInfoLCR_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeIdTransReconfItemLCR_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeIdMeasInfoLCR_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeIdMeasInfoList_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeIdMeasInfoItem_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeIdInfoListLCR_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_SYNCDlCodeIdInfoItemLCR_CellSyncReconfRqstTDD = -1;
static gint ett_nbap_CellSynchronisationReconfigurationResponseTDD = -1;
static gint ett_nbap_CellSynchronisationReconfigurationFailureTDD = -1;
static gint ett_nbap_CellSynchronisationAdjustmentRequestTDD = -1;
static gint ett_nbap_CellAdjustmentInfo_SyncAdjustmentRqstTDD = -1;
static gint ett_nbap_CellAdjustmentInfoItem_SyncAdjustmentRqstTDD = -1;
static gint ett_nbap_CellSynchronisationAdjustmentResponseTDD = -1;
static gint ett_nbap_CellSynchronisationAdjustmentFailureTDD = -1;
static gint ett_nbap_CauseLevel_SyncAdjustmntFailureTDD = -1;
static gint ett_nbap_GeneralCauseList_SyncAdjustmntFailureTDD = -1;
static gint ett_nbap_CellSpecificCauseList_SyncAdjustmntFailureTDD = -1;
static gint ett_nbap_Unsuccessful_cell_InformationRespList_SyncAdjustmntFailureTDD = -1;
static gint ett_nbap_Unsuccessful_cell_InformationRespItem_SyncAdjustmntFailureTDD = -1;
static gint ett_nbap_CellSynchronisationTerminationRequestTDD = -1;
static gint ett_nbap_CellSynchronisationFailureIndicationTDD = -1;
static gint ett_nbap_CellSynchronisationReportTDD = -1;
static gint ett_nbap_CellSyncInfo_CellSyncReprtTDD = -1;
static gint ett_nbap_CellSyncInfoItemIE_CellSyncReprtTDD = -1;
static gint ett_nbap_SyncReportType_CellSyncReprtTDD = -1;
static gint ett_nbap_IntStdPhCellSyncInfo_CellSyncReprtTDD = -1;
static gint ett_nbap_CellSyncBurstMeasInfoList_CellSyncReprtTDD = -1;
static gint ett_nbap_CellSyncBurstMeasInfoItem_CellSyncReprtTDD = -1;
static gint ett_nbap_SEQUENCE_SIZE_1_maxNrOfReceptsPerSyncFrame_OF_CellSyncBurstInfo_CellSyncReprtTDD = -1;
static gint ett_nbap_CellSyncBurstInfo_CellSyncReprtTDD = -1;
static gint ett_nbap_CellSyncBurstAvailable_CellSyncReprtTDD = -1;
static gint ett_nbap_SyncDLCodeIdsMeasInfoList_CellSyncReprtTDD = -1;
static gint ett_nbap_SyncDLCodeIdsMeasInfoItem_CellSyncReprtTDD = -1;
static gint ett_nbap_SyncDLCodeIdInfo_CellSyncReprtTDD = -1;
static gint ett_nbap_SyncDLCodeIdItem_CellSyncReprtTDD = -1;
static gint ett_nbap_SyncDLCodeIdAvailable_CellSyncReprtTDD = -1;
static gint ett_nbap_BearerRearrangementIndication = -1;
static gint ett_nbap_DCH_RearrangeList_Bearer_RearrangeInd = -1;
static gint ett_nbap_DCH_RearrangeItem_Bearer_RearrangeInd = -1;
static gint ett_nbap_DSCH_RearrangeList_Bearer_RearrangeInd = -1;
static gint ett_nbap_DSCH_RearrangeItem_Bearer_RearrangeInd = -1;
static gint ett_nbap_USCH_RearrangeList_Bearer_RearrangeInd = -1;
static gint ett_nbap_USCH_RearrangeItem_Bearer_RearrangeInd = -1;
static gint ett_nbap_HSDSCH_RearrangeList_Bearer_RearrangeInd = -1;
static gint ett_nbap_HSDSCH_RearrangeItem_Bearer_RearrangeInd = -1;
static gint ett_nbap_E_DCH_RearrangeList_Bearer_RearrangeInd = -1;
static gint ett_nbap_E_DCH_RearrangeItem_Bearer_RearrangeInd = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Bearer_Rearrangement_List = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_Bearer_Rearrangement_ItemIEs = -1;
static gint ett_nbap_RadioLinkActivationCommandFDD = -1;
static gint ett_nbap_DelayedActivationInformationList_RL_ActivationCmdFDD = -1;
static gint ett_nbap_DelayedActivationInformation_RL_ActivationCmdFDD = -1;
static gint ett_nbap_RadioLinkActivationCommandTDD = -1;
static gint ett_nbap_DelayedActivationInformationList_RL_ActivationCmdTDD = -1;
static gint ett_nbap_DelayedActivationInformation_RL_ActivationCmdTDD = -1;
static gint ett_nbap_RadioLinkParameterUpdateIndicationFDD = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Param_Upd = -1;
static gint ett_nbap_Additional_HS_Cell_Information_RL_Param_Upd_ItemIEs = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_RL_Param_Upd = -1;
static gint ett_nbap_Additional_EDCH_Cell_Information_RL_Param_Upd_ItemIEs = -1;
static gint ett_nbap_RadioLinkParameterUpdateIndicationTDD = -1;
static gint ett_nbap_MBMSNotificationUpdateCommand = -1;
static gint ett_nbap_UEStatusUpdateCommand = -1;
static gint ett_nbap_SecondaryULFrequencyReport = -1;
static gint ett_nbap_SecondaryULFrequencyUpdateIndication = -1;
static gint ett_nbap_NBAP_PDU = -1;
static gint ett_nbap_InitiatingMessage = -1;
static gint ett_nbap_SuccessfulOutcome = -1;
static gint ett_nbap_UnsuccessfulOutcome = -1;
static gint ett_nbap_Outcome = -1;

/*--- End of included file: packet-nbap-ett.c ---*/
#line 80 "./asn1/nbap/packet-nbap-template.c"

static expert_field ei_nbap_no_find_comm_context_id = EI_INIT;
static expert_field ei_nbap_no_find_port_info = EI_INIT;
static expert_field ei_nbap_no_set_comm_context_id = EI_INIT;
static expert_field ei_nbap_hsdsch_entity_not_specified = EI_INIT;

extern int proto_fp;

static dissector_handle_t nbap_handle;

/*
 * Structure to hold Setup Request/Response message conversation
 * we add all src add/port declared in SetupRequest msg
 * to match it with dst add/port declared in SetupResponse msg
 * so we gonna have conversation with exact match (src and dst addr and port)
 */
typedef struct nbap_setup_conv
{
  guint32 transaction_id;
  guint32 dd_mode;
  guint32 channel_id;
  guint32 request_frame_number;
  address addr;
  guint32 port;
  umts_fp_conversation_info_t *umts_fp_conversation_info;
  conversation_t *conv;
}nbap_setup_conv_t;

/*
 * Hash table to manage Setup Request/Response message conversation
 * we can look in table for proper conversation
 */
static wmem_map_t *nbap_setup_conv_table;

typedef struct
{
  gint num_dch_in_flow;
  gint next_dch;
  gint num_ul_chans;
  gint ul_chan_tf_size[MAX_FP_CHANS];
  gint ul_chan_num_tbs[MAX_FP_CHANS];
  gint num_dl_chans;
  gint dl_chan_tf_size[MAX_FP_CHANS];
  gint dl_chan_num_tbs[MAX_FP_CHANS];
}nbap_dch_channel_info_t;

/* Struct to collect E-DCH data in a packet
 * As the address data comes before the ddi entries
 * we save the address to be able to find the conversation and update the
 * conversation data.
 */
typedef struct
{
  address crnc_address;
  guint16 crnc_port;
  gint no_ddi_entries;
  guint8 edch_ddi[MAX_EDCH_DDIS];
  guint edch_macd_pdu_size[MAX_EDCH_DDIS];
  guint8 edch_type;  /* 1 means T2 */
  guint8 lchId[MAX_EDCH_DDIS]; /*Logical channel ids.*/
} nbap_edch_channel_info_t;


typedef struct
{
  guint32 crnc_address;
  guint16 crnc_port[maxNrOfEDCHMACdFlows];
} nbap_edch_port_info_t;

typedef struct
{
  address crnc_address;
  guint16 crnc_port;
  enum fp_rlc_mode rlc_mode;
  guint32 hsdsch_physical_layer_category;
  guint8 entity;  /* "ns" means type 1 and "ehs" means type 2, type 3 == ?*/
} nbap_hsdsch_channel_info_t;

typedef struct
{
 address crnc_address;
 guint16 crnc_port;
 enum fp_rlc_mode rlc_mode;
} nbap_common_channel_info_t;

/*Stuff for mapping NodeB-Comuncation Context ID to CRNC Communication Context ID*/
typedef struct com_ctxt_{
  /*guint   nodeb_context;*/
  guint crnc_context;
  guint frame_num;
}nbap_com_context_id_t;

enum TransportFormatSet_type_enum
{
  NBAP_DCH_UL,
  NBAP_DCH_DL,
  NBAP_CPCH,
  NBAP_FACH,
  NBAP_PCH
};

#define NBAP_MAX_IB_SEGMENT_LENGTH 222

typedef struct nbap_ib_segment_t {
  guint32 bit_length;
  guint8* data;
} nbap_ib_segment_t;

static nbap_ib_segment_t* nbap_parse_ib_segment_t(tvbuff_t *tvb,gboolean is_short)
{
  guint8 bit_length;
  guint8* data;
  nbap_ib_segment_t* output;
  if ( tvb_captured_length(tvb) < 2 ) {
    return NULL;
  }
  if (is_short) {
    bit_length = tvb_get_guint8(tvb,0) + 1;
    data = (guint8*)tvb_memdup(wmem_packet_scope(),tvb,1,(bit_length+7)/8);
  }
  else {
    bit_length = NBAP_MAX_IB_SEGMENT_LENGTH;
    data = (guint8*)tvb_memdup(wmem_packet_scope(),tvb,0,(bit_length+7)/8);
  }
  output = wmem_new(wmem_packet_scope(), nbap_ib_segment_t);
  output->bit_length = bit_length;
  output->data = data;
  return output;
}

/*****************************************************************************/
/* Packet private data                                                       */
/* For this dissector, all information passed between different ASN.1 nodes  */
/* should be done only through this API!                                     */
/*****************************************************************************/


typedef struct nbap_private_data_t
{
  guint32 transportLayerAddress_ipv4;
  guint16 binding_id_port;
  enum TransportFormatSet_type_enum transport_format_set_type;
  guint32 procedure_code;
  guint num_items;
  guint32 ul_scrambling_code;
  guint32 com_context_id;
  gint num_dch_in_flow;
  gint hrnti;
  guint32 protocol_ie_id;
  guint32 dd_mode;
  guint32 transaction_id;
  guint32 t_dch_id;
  guint32 dch_id;
  guint32 prev_dch_id;
  guint32 common_physical_channel_id;
  guint32 e_dch_macdflow_id;
  guint32 hsdsch_macdflow_id;
  guint32 e_dch_ddi_value;
  guint32 logical_channel_id;
  guint32 common_macdflow_id;
  guint32 mac_d_pdu_size;
  guint32 common_transport_channel_id;
  gint paging_indications;
  guint32 ib_type;
  guint32 segment_type;
  gboolean crnc_context_present; /* Whether 'com_context_id' is set */
  guint8 dch_crc_present;
  /* Arrays */
  nbap_dch_channel_info_t nbap_dch_chnl_info[256];
  nbap_edch_channel_info_t nbap_edch_channel_info[maxNrOfEDCHMACdFlows];
  gint hsdsch_macdflow_ids[maxNrOfMACdFlows];
  nbap_hsdsch_channel_info_t nbap_hsdsch_channel_info[maxNrOfMACdFlows];
  nbap_common_channel_info_t nbap_common_channel_info[maxNrOfMACdFlows];	/*TODO: Fix this!*/
  wmem_list_t* ib_segments; /* Information block segments */
} nbap_private_data_t;


/* Helper function to get or create a private_data struct */
static nbap_private_data_t* nbap_get_private_data(packet_info *pinfo)
{
  guint8 i;
  /* NOTE: Unlike other ASN.1 dissectors which store information in
  * actx->private_data the NBAP dissector can't do so because some fields
  * are defined as their own 'PDU' (Like BindingID and TransportLayerAddress)
  * in those cases, the generic ASN.1 dissector creates a NEW 'ASN.1 context'
  * (asn1_ctx_t) and hence a new 'private data' field for them so information
  * can't be passes to/from them.
  */
  nbap_private_data_t *private_data = (nbap_private_data_t *)p_get_proto_data(pinfo->pool, pinfo, proto_nbap, 0);
  if(private_data != NULL ) {
    return private_data;
  }
  else {
    private_data = wmem_new0(pinfo->pool, nbap_private_data_t);
    p_add_proto_data(pinfo->pool, pinfo, proto_nbap, 0, private_data);
    /* Setting  default values */
    private_data->hsdsch_macdflow_id = 3;
    private_data->crnc_context_present = FALSE;
    private_data->procedure_code = 0xFFFF;
    private_data->dd_mode = 0xFFFF;
    private_data->dch_crc_present = 2; /* Unknown */
    for (i = 0; i < maxNrOfMACdFlows; i++) {
        private_data->nbap_hsdsch_channel_info[i].entity = hs;
    }
    return private_data;
  }
}

/* Helper function to reset the private data struct*/
static void nbap_reset_private_data(packet_info *pinfo)
{
  p_remove_proto_data(pinfo->pool, pinfo, proto_nbap, 0);
}

static guint32 private_data_get_transportLayerAddress_ipv4(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->transportLayerAddress_ipv4;
}

static void private_data_set_transportLayerAddress_ipv4(packet_info *pinfo, guint32 transportLayerAddress_ipv4)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->transportLayerAddress_ipv4 = transportLayerAddress_ipv4;
}

static guint16 private_data_get_binding_id_port(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->binding_id_port;
}

static void private_data_set_binding_id_port(packet_info *pinfo, guint16 binding_id_port)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->binding_id_port = binding_id_port;
}

static guint32 private_data_get_ul_scrambling_code(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->ul_scrambling_code;
}

static void private_data_set_ul_scrambling_code(packet_info *pinfo, guint32 ul_scrambling_code)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->ul_scrambling_code = ul_scrambling_code;
}

static enum TransportFormatSet_type_enum private_data_get_transport_format_set_type(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->transport_format_set_type;
}

static void private_data_set_transport_format_set_type(packet_info *pinfo, enum TransportFormatSet_type_enum transport_format_set_type)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->transport_format_set_type = transport_format_set_type;
}

static guint32 private_data_get_procedure_code(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->procedure_code;
}

static void private_data_set_procedure_code(packet_info *pinfo, guint32 procedure_code)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->procedure_code = procedure_code;
}

static guint private_data_get_num_items(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->num_items;
}

static void private_data_set_num_items(packet_info *pinfo, guint num_items)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->num_items = num_items;
}

static guint private_data_increment_num_items(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->num_items++;
  return private_data->num_items;
}

static guint32 private_data_get_com_context_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->com_context_id;
}

static void private_data_set_com_context_id(packet_info *pinfo, guint32 com_context_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->com_context_id = com_context_id;
}

static gint private_data_get_num_dch_in_flow(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->num_dch_in_flow;
}

static void private_data_set_num_dch_in_flow(packet_info *pinfo, gint num_dch_in_flow)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->num_dch_in_flow = num_dch_in_flow;
}

static gint private_data_increment_num_dch_in_flow(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->num_dch_in_flow++;
  return private_data->num_dch_in_flow;
}

static gint private_data_get_hrnti(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->hrnti;
}

static void private_data_set_hrnti(packet_info *pinfo, gint hrnti)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->hrnti = hrnti;
}

static guint32 private_data_get_protocol_ie_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->protocol_ie_id;
}

static void private_data_set_protocol_ie_id(packet_info *pinfo, guint32 protocol_ie_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->protocol_ie_id = protocol_ie_id;
}

static guint32 private_data_get_dd_mode(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->dd_mode;
}

static void private_data_set_dd_mode(packet_info *pinfo, guint32 dd_mode)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->dd_mode = dd_mode;
}

static guint32 private_data_get_transaction_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->transaction_id;
}

static void private_data_set_transaction_id(packet_info *pinfo, guint32 transaction_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->transaction_id = transaction_id;
}

static guint32 private_data_get_t_dch_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->t_dch_id;
}

static void private_data_set_t_dch_id(packet_info *pinfo, guint32 t_dch_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->t_dch_id = t_dch_id;
}

static guint32 private_data_get_dch_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->dch_id;
}

static void private_data_set_dch_id(packet_info *pinfo, guint32 dch_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->dch_id = dch_id;
}

static guint32 private_data_get_prev_dch_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->prev_dch_id;
}

static void private_data_set_prev_dch_id(packet_info *pinfo, guint32 prev_dch_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->prev_dch_id = prev_dch_id;
}

static guint32 private_data_get_common_physical_channel_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->common_physical_channel_id;
}

static void private_data_set_common_physical_channel_id(packet_info *pinfo, guint32 common_physical_channel_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->common_physical_channel_id = common_physical_channel_id;
}

static guint32 private_data_get_e_dch_macdflow_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->e_dch_macdflow_id;
}

static void private_data_set_e_dch_macdflow_id(packet_info *pinfo, guint32 e_dch_macdflow_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->e_dch_macdflow_id = e_dch_macdflow_id;
}

static guint32 private_data_get_hsdsch_macdflow_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->hsdsch_macdflow_id;
}

static void private_data_set_hsdsch_macdflow_id(packet_info *pinfo, guint32 hsdsch_macdflow_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->hsdsch_macdflow_id = hsdsch_macdflow_id;
}

static guint32 private_data_get_e_dch_ddi_value(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->e_dch_ddi_value;
}

static void private_data_set_e_dch_ddi_value(packet_info *pinfo, guint32 e_dch_ddi_value)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->e_dch_ddi_value = e_dch_ddi_value;
}

static guint32 private_data_get_logical_channel_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->logical_channel_id;
}

static void private_data_set_logical_channel_id(packet_info *pinfo, guint32 logical_channel_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->logical_channel_id = logical_channel_id;
}

static guint32 private_data_get_common_macdflow_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->common_macdflow_id;
}

static void private_data_set_common_macdflow_id(packet_info *pinfo, guint32 common_macdflow_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->common_macdflow_id = common_macdflow_id;
}

static guint32 private_data_get_mac_d_pdu_size(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->mac_d_pdu_size;
}

static void private_data_set_mac_d_pdu_size(packet_info *pinfo, guint32 mac_d_pdu_size)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->mac_d_pdu_size = mac_d_pdu_size;
}

static guint32 private_data_get_common_transport_channel_id(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->common_transport_channel_id;
}

static void private_data_set_common_transport_channel_id(packet_info *pinfo, guint32 common_transport_channel_id)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->common_transport_channel_id = common_transport_channel_id;
}

static gint private_data_get_paging_indications(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->paging_indications;
}

static void private_data_set_paging_indications(packet_info *pinfo, gint paging_indications)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->paging_indications = paging_indications;
}

static guint32 private_data_get_ib_type(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->ib_type;
}

static void private_data_set_ib_type(packet_info *pinfo, guint32 ib_type)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->ib_type = ib_type;
}

static guint32 private_data_get_segment_type(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->segment_type;
}

static void private_data_set_segment_type(packet_info *pinfo, guint32 segment_type)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->segment_type = segment_type;
}

static gboolean private_data_get_crnc_context_present(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->crnc_context_present;
}

static void private_data_set_crnc_context_present(packet_info *pinfo, gboolean crnc_context_present)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->crnc_context_present = crnc_context_present;
}

static guint8 private_data_get_dch_crc_present(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->dch_crc_present;
}

static void private_data_set_dch_crc_present(packet_info *pinfo, guint8 dch_crc_present)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->dch_crc_present = dch_crc_present;
}

static nbap_dch_channel_info_t* private_data_get_nbap_dch_chnl_info(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->nbap_dch_chnl_info;
}

static nbap_edch_channel_info_t* private_data_get_nbap_edch_channel_info(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->nbap_edch_channel_info;
}

static gint* private_data_get_hsdsch_macdflow_ids(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->hsdsch_macdflow_ids;
}

static nbap_hsdsch_channel_info_t* private_data_get_nbap_hsdsch_channel_info(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->nbap_hsdsch_channel_info;
}

static nbap_common_channel_info_t* private_data_get_nbap_common_channel_info(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->nbap_common_channel_info;
}

static wmem_list_t* private_data_get_ib_segments(packet_info *pinfo)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  return private_data->ib_segments;
}

static void private_data_set_ib_segments(packet_info *pinfo, wmem_list_t* ib_segments)
{
  nbap_private_data_t *private_data = (nbap_private_data_t*)nbap_get_private_data(pinfo);
  private_data->ib_segments = ib_segments;
}

/*****************************************************************************/


/* Global Variables */

/* Variables for sub elements dissection */
static  const gchar *ProcedureID;
/* Trees */
static wmem_tree_t* edch_flow_port_map = NULL;
wmem_tree_t *nbap_scrambling_code_crncc_map = NULL;
wmem_tree_t *nbap_crncc_urnti_map = NULL;
static wmem_tree_t* com_context_map;

/* This table is used externally from FP, MAC and such, TODO: merge this with
 * lch_contents[] */
guint8 lchId_type_table[]= {
  MAC_CONTENT_UNKNOWN,  /* Shouldn't happen*/
  MAC_CONTENT_DCCH,  /* 1 to 4 SRB => DCCH*/
  MAC_CONTENT_DCCH,
  MAC_CONTENT_DCCH,
  MAC_CONTENT_DCCH,
  MAC_CONTENT_CS_DTCH,  /* 5 to 7 Conv CS speech => ?*/
  MAC_CONTENT_CS_DTCH,
  MAC_CONTENT_CS_DTCH,
  MAC_CONTENT_DCCH, /* 8 SRB => DCCH*/
  MAC_CONTENT_PS_DTCH,  /* 9 maps to DTCH*/
  MAC_CONTENT_UNKNOWN,  /* 10 Conv CS unknown*/
  MAC_CONTENT_PS_DTCH,  /* 11 Interactive PS => DTCH*/
  MAC_CONTENT_PS_DTCH,  /* 12 Streaming PS => DTCH*/
  MAC_CONTENT_CS_DTCH,  /* 13 Streaming CS*/
  MAC_CONTENT_PS_DTCH,  /* 14 Interactive PS => DTCH*/
  MAC_CONTENT_CCCH  /* This is CCCH? */
};

/* Mapping logicalchannel id to RLC_MODE */
guint8 lchId_rlc_map[] = {
  0,
  RLC_UM, /* Logical channel id = 1 is SRB1 which uses RLC_UM*/
  RLC_AM,
  RLC_AM,
  RLC_AM,
  RLC_TM, /*5 to 7 Conv CS Speech*/
  RLC_TM,
  RLC_TM, /*...*/
  RLC_AM,
  RLC_AM,
  RLC_AM,
  RLC_AM,
  RLC_AM,
  RLC_AM,
  RLC_AM,
  RLC_AM, /* This is CCCH which is UM?, probably not */
};

/* Preference variables */
/* Array with preference variables for easy looping, TODO: merge this with
 * lchId_type_table[] */
static int lch_contents[16] = {
  MAC_CONTENT_DCCH,
  MAC_CONTENT_DCCH,
  MAC_CONTENT_DCCH,
  MAC_CONTENT_DCCH,
  MAC_CONTENT_CS_DTCH,
  MAC_CONTENT_CS_DTCH,
  MAC_CONTENT_CS_DTCH,
  MAC_CONTENT_DCCH,
  MAC_CONTENT_PS_DTCH,
  MAC_CONTENT_UNKNOWN,
  MAC_CONTENT_PS_DTCH,
  MAC_CONTENT_PS_DTCH,
  MAC_CONTENT_CS_DTCH,
  MAC_CONTENT_PS_DTCH,
  MAC_CONTENT_CCCH,
  MAC_CONTENT_DCCH
};

static const enum_val_t content_types[] = {
  {"MAC_CONTENT_UNKNOWN", "MAC_CONTENT_UNKNOWN", MAC_CONTENT_UNKNOWN},
  {"MAC_CONTENT_DCCH", "MAC_CONTENT_DCCH", MAC_CONTENT_DCCH},
  {"MAC_CONTENT_PS_DTCH", "MAC_CONTENT_PS_DTCH", MAC_CONTENT_PS_DTCH},
  {"MAC_CONTENT_CS_DTCH", "MAC_CONTENT_CS_DTCH", MAC_CONTENT_CS_DTCH},
  {"MAC_CONTENT_CCCH", "MAC_CONTENT_CCCH", MAC_CONTENT_CCCH},
  {NULL, NULL, -1}};

typedef struct {
  const char *name;
  const char *title;
  const char *description;
} preference_strings;

/* This is used when registering preferences, name, title, description */
static const preference_strings ch_strings[] = {
  {"lch1_content", "Logical Channel 1 Content", "foo"},
  {"lch2_content", "Logical Channel 2 Content", "foo"},
  {"lch3_content", "Logical Channel 3 Content", "foo"},
  {"lch4_content", "Logical Channel 4 Content", "foo"},
  {"lch5_content", "Logical Channel 5 Content", "foo"},
  {"lch6_content", "Logical Channel 6 Content", "foo"},
  {"lch7_content", "Logical Channel 7 Content", "foo"},
  {"lch8_content", "Logical Channel 8 Content", "foo"},
  {"lch9_content", "Logical Channel 9 Content", "foo"},
  {"lch10_content", "Logical Channel 10 Content", "foo"},
  {"lch11_content", "Logical Channel 11 Content", "foo"},
  {"lch12_content", "Logical Channel 12 Content", "foo"},
  {"lch13_content", "Logical Channel 13 Content", "foo"},
  {"lch14_content", "Logical Channel 14 Content", "foo"},
  {"lch15_content", "Logical Channel 15 Content", "foo"},
  {"lch16_content", "Logical Channel 16 Content", "foo"}};

/* Dissector tables */
static dissector_table_t nbap_ies_dissector_table;
static dissector_table_t nbap_extension_dissector_table;
static dissector_table_t nbap_proc_imsg_dissector_table;
static dissector_table_t nbap_proc_sout_dissector_table;
static dissector_table_t nbap_proc_uout_dissector_table;

static int dissect_ProtocolIEFieldValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_ProtocolExtensionFieldExtensionValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_InitiatingMessageValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_SuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);
static int dissect_UnsuccessfulOutcomeValue(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree, void *);

static guint32 calculate_setup_conv_key(const guint32 transaction_id, const guint32 dd_mode, const guint32 channel_id);
static void add_setup_conv(const guint32 transaction_id, const guint32 dd_mode, const guint32 channel_id, const guint32 req_frame_number,
           const address *addr, const guint32 port, umts_fp_conversation_info_t * umts_fp_conversation_info, conversation_t *conv);
static nbap_setup_conv_t* find_setup_conv(const guint32 transaction_id, const guint32 dd_mode, const guint32 channel_id);
static void delete_setup_conv(nbap_setup_conv_t *conv);

/*Easy way to add hsdhsch binds for corner cases*/
static void add_hsdsch_bind(packet_info * pinfo);


/*--- Included file: packet-nbap-fn.c ---*/
#line 1 "./asn1/nbap/packet-nbap-fn.c"

static const value_string nbap_Criticality_vals[] = {
  {   0, "reject" },
  {   1, "ignore" },
  {   2, "notify" },
  { 0, NULL }
};


static int
dissect_nbap_Criticality(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_MessageDiscriminator_vals[] = {
  {   0, "common" },
  {   1, "dedicated" },
  { 0, NULL }
};


static int
dissect_nbap_MessageDiscriminator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_INTEGER_0_maxPrivateIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxPrivateIEs, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_OBJECT_IDENTIFIER(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_object_identifier(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string nbap_PrivateIE_ID_vals[] = {
  {   0, "local" },
  {   1, "global" },
  { 0, NULL }
};

static const per_choice_t PrivateIE_ID_choice[] = {
  {   0, &hf_nbap_local          , ASN1_NO_EXTENSIONS     , dissect_nbap_INTEGER_0_maxPrivateIEs },
  {   1, &hf_nbap_global         , ASN1_NO_EXTENSIONS     , dissect_nbap_OBJECT_IDENTIFIER },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_PrivateIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_PrivateIE_ID, PrivateIE_ID_choice,
                                 NULL);

  return offset;
}


static const value_string nbap_ProcedureCode_vals[] = {
  { NBAP_ID_AUDIT, "id-audit" },
  { NBAP_ID_AUDITREQUIRED, "id-auditRequired" },
  { NBAP_ID_BLOCKRESOURCE, "id-blockResource" },
  { NBAP_ID_CELLDELETION, "id-cellDeletion" },
  { NBAP_ID_CELLRECONFIGURATION, "id-cellReconfiguration" },
  { NBAP_ID_CELLSETUP, "id-cellSetup" },
  { NBAP_ID_CELLSYNCHRONISATIONINITIATION, "id-cellSynchronisationInitiation" },
  { NBAP_ID_CELLSYNCHRONISATIONRECONFIGURATION, "id-cellSynchronisationReconfiguration" },
  { NBAP_ID_CELLSYNCHRONISATIONREPORTING, "id-cellSynchronisationReporting" },
  { NBAP_ID_CELLSYNCHRONISATIONTERMINATION, "id-cellSynchronisationTermination" },
  { NBAP_ID_CELLSYNCHRONISATIONFAILURE, "id-cellSynchronisationFailure" },
  { NBAP_ID_COMMONMEASUREMENTFAILURE, "id-commonMeasurementFailure" },
  { NBAP_ID_COMMONMEASUREMENTINITIATION, "id-commonMeasurementInitiation" },
  { NBAP_ID_COMMONMEASUREMENTREPORT, "id-commonMeasurementReport" },
  { NBAP_ID_COMMONMEASUREMENTTERMINATION, "id-commonMeasurementTermination" },
  { NBAP_ID_COMMONTRANSPORTCHANNELDELETE, "id-commonTransportChannelDelete" },
  { NBAP_ID_COMMONTRANSPORTCHANNELRECONFIGURE, "id-commonTransportChannelReconfigure" },
  { NBAP_ID_COMMONTRANSPORTCHANNELSETUP, "id-commonTransportChannelSetup" },
  { NBAP_ID_COMPRESSEDMODECOMMAND, "id-compressedModeCommand" },
  { NBAP_ID_DEDICATEDMEASUREMENTFAILURE, "id-dedicatedMeasurementFailure" },
  { NBAP_ID_DEDICATEDMEASUREMENTINITIATION, "id-dedicatedMeasurementInitiation" },
  { NBAP_ID_DEDICATEDMEASUREMENTREPORT, "id-dedicatedMeasurementReport" },
  { NBAP_ID_DEDICATEDMEASUREMENTTERMINATION, "id-dedicatedMeasurementTermination" },
  { NBAP_ID_DOWNLINKPOWERCONTROL, "id-downlinkPowerControl" },
  { NBAP_ID_DOWNLINKPOWERTIMESLOTCONTROL, "id-downlinkPowerTimeslotControl" },
  { NBAP_ID_ERRORINDICATIONFORCOMMON, "id-errorIndicationForCommon" },
  { NBAP_ID_ERRORINDICATIONFORDEDICATED, "id-errorIndicationForDedicated" },
  { NBAP_ID_INFORMATIONEXCHANGEFAILURE, "id-informationExchangeFailure" },
  { NBAP_ID_INFORMATIONEXCHANGEINITIATION, "id-informationExchangeInitiation" },
  { NBAP_ID_INFORMATIONEXCHANGETERMINATION, "id-informationExchangeTermination" },
  { NBAP_ID_INFORMATIONREPORTING, "id-informationReporting" },
  { NBAP_ID_BEARERREARRANGEMENT, "id-BearerRearrangement" },
  { NBAP_ID_MBMSNOTIFICATIONUPDATE, "id-mBMSNotificationUpdate" },
  { NBAP_ID_PHYSICALSHAREDCHANNELRECONFIGURATION, "id-physicalSharedChannelReconfiguration" },
  { NBAP_ID_PRIVATEMESSAGEFORCOMMON, "id-privateMessageForCommon" },
  { NBAP_ID_PRIVATEMESSAGEFORDEDICATED, "id-privateMessageForDedicated" },
  { NBAP_ID_RADIOLINKADDITION, "id-radioLinkAddition" },
  { NBAP_ID_RADIOLINKDELETION, "id-radioLinkDeletion" },
  { NBAP_ID_RADIOLINKFAILURE, "id-radioLinkFailure" },
  { NBAP_ID_RADIOLINKPREEMPTION, "id-radioLinkPreemption" },
  { NBAP_ID_RADIOLINKRESTORATION, "id-radioLinkRestoration" },
  { NBAP_ID_RADIOLINKSETUP, "id-radioLinkSetup" },
  { NBAP_ID_RESET, "id-reset" },
  { NBAP_ID_RESOURCESTATUSINDICATION, "id-resourceStatusIndication" },
  { NBAP_ID_CELLSYNCHRONISATIONADJUSTMENT, "id-cellSynchronisationAdjustment" },
  { NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCANCELLATION, "id-synchronisedRadioLinkReconfigurationCancellation" },
  { NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONCOMMIT, "id-synchronisedRadioLinkReconfigurationCommit" },
  { NBAP_ID_SYNCHRONISEDRADIOLINKRECONFIGURATIONPREPARATION, "id-synchronisedRadioLinkReconfigurationPreparation" },
  { NBAP_ID_SYSTEMINFORMATIONUPDATE, "id-systemInformationUpdate" },
  { NBAP_ID_UNBLOCKRESOURCE, "id-unblockResource" },
  { NBAP_ID_UNSYNCHRONISEDRADIOLINKRECONFIGURATION, "id-unSynchronisedRadioLinkReconfiguration" },
  { NBAP_ID_RADIOLINKACTIVATION, "id-radioLinkActivation" },
  { NBAP_ID_RADIOLINKPARAMETERUPDATE, "id-radioLinkParameterUpdate" },
  { NBAP_ID_UESTATUSUPDATE, "id-uEStatusUpdate" },
  { NBAP_ID_SECONDARYULFREQUENCYREPORTING, "id-secondaryULFrequencyReporting" },
  { NBAP_ID_SECONDARYULFREQUENCYUPDATE, "id-secondaryULFrequencyUpdate" },
  { 0, NULL }
};


static int
dissect_nbap_ProcedureCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 94 "./asn1/nbap/nbap.cnf"
  guint32 procedure_code;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &procedure_code, FALSE);

  private_data_set_procedure_code(actx->pinfo, procedure_code);
  col_add_fstr(actx->pinfo->cinfo, COL_INFO, "%s ",
                 val_to_str(procedure_code, nbap_ProcedureCode_vals,
                            "unknown message"));



  return offset;
}


static const value_string nbap_DdMode_vals[] = {
  { tdd, "tdd" },
  { fdd, "fdd" },
  { common, "common" },
  { 0, NULL }
};


static int
dissect_nbap_DdMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 102 "./asn1/nbap/nbap.cnf"
  guint32 dd_mode;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, &dd_mode, TRUE, 0, NULL);

  private_data_set_dd_mode(actx->pinfo, dd_mode);




  return offset;
}


static const per_sequence_t ProcedureID_sequence[] = {
  { &hf_nbap_procedureCode  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_ProcedureCode },
  { &hf_nbap_ddMode         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DdMode },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ProcedureID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 108 "./asn1/nbap/nbap.cnf"
  ProcedureID = NULL;
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ProcedureID, ProcedureID_sequence);

  ProcedureID = wmem_strdup_printf(wmem_packet_scope(), "%s/%s",
                                 val_to_str(private_data_get_procedure_code(actx->pinfo), VALS(nbap_ProcedureCode_vals), "unknown(%u)"),
                                 val_to_str(private_data_get_dd_mode(actx->pinfo), VALS(nbap_DdMode_vals), "unknown(%u)"));
  private_data_set_crnc_context_present(actx->pinfo, FALSE); /*Reset CRNC Com context present flag.*/



  return offset;
}


static const value_string nbap_ProtocolIE_ID_vals[] = {
  { id_AICH_Information, "id-AICH-Information" },
  { id_AICH_InformationItem_ResourceStatusInd, "id-AICH-InformationItem-ResourceStatusInd" },
  { id_Local_Cell_Group_InformationItem_AuditRsp, "id-Local-Cell-Group-InformationItem-AuditRsp" },
  { id_Local_Cell_Group_InformationItem_ResourceStatusInd, "id-Local-Cell-Group-InformationItem-ResourceStatusInd" },
  { id_Local_Cell_Group_InformationItem2_ResourceStatusInd, "id-Local-Cell-Group-InformationItem2-ResourceStatusInd" },
  { id_Local_Cell_Group_InformationList_AuditRsp, "id-Local-Cell-Group-InformationList-AuditRsp" },
  { id_CFNReportingIndicator, "id-CFNReportingIndicator" },
  { id_BCH_Information, "id-BCH-Information" },
  { id_BCH_InformationItem_ResourceStatusInd, "id-BCH-InformationItem-ResourceStatusInd" },
  { id_BCCH_ModificationTime, "id-BCCH-ModificationTime" },
  { id_BlockingPriorityIndicator, "id-BlockingPriorityIndicator" },
  { id_SFNReportingIndicator, "id-SFNReportingIndicator" },
  { id_InnerLoopDLPCStatus, "id-InnerLoopDLPCStatus" },
  { id_Cause, "id-Cause" },
  { id_CCP_InformationItem_AuditRsp, "id-CCP-InformationItem-AuditRsp" },
  { id_CCP_InformationList_AuditRsp, "id-CCP-InformationList-AuditRsp" },
  { id_CCP_InformationItem_ResourceStatusInd, "id-CCP-InformationItem-ResourceStatusInd" },
  { id_Cell_InformationItem_AuditRsp, "id-Cell-InformationItem-AuditRsp" },
  { id_Cell_InformationItem_ResourceStatusInd, "id-Cell-InformationItem-ResourceStatusInd" },
  { id_Cell_InformationList_AuditRsp, "id-Cell-InformationList-AuditRsp" },
  { id_PRACH_ParametersItem_CTCH_SetupRqstTDD, "id-PRACH-ParametersItem-CTCH-SetupRqstTDD" },
  { id_DL_DPCH_TimingAdjustment, "id-DL-DPCH-TimingAdjustment" },
  { id_FPACH_LCR_InformationList_AuditRsp, "id-FPACH-LCR-InformationList-AuditRsp" },
  { id_CellParameterID, "id-CellParameterID" },
  { id_CFN, "id-CFN" },
  { id_C_ID, "id-C-ID" },
  { id_Unused_ProtocolIE_ID_26, "id-Unused-ProtocolIE-ID-26" },
  { id_Unused_ProtocolIE_ID_27, "id-Unused-ProtocolIE-ID-27" },
  { id_DL_PowerBalancing_Information, "id-DL-PowerBalancing-Information" },
  { id_DL_PowerBalancing_ActivationIndicator, "id-DL-PowerBalancing-ActivationIndicator" },
  { id_DL_PowerBalancing_UpdatedIndicator, "id-DL-PowerBalancing-UpdatedIndicator" },
  { id_CommonMeasurementObjectType_CM_Rprt, "id-CommonMeasurementObjectType-CM-Rprt" },
  { id_CommonMeasurementObjectType_CM_Rqst, "id-CommonMeasurementObjectType-CM-Rqst" },
  { id_CommonMeasurementObjectType_CM_Rsp, "id-CommonMeasurementObjectType-CM-Rsp" },
  { id_CommonMeasurementType, "id-CommonMeasurementType" },
  { id_CommonPhysicalChannelID, "id-CommonPhysicalChannelID" },
  { id_CommonPhysicalChannelType_CTCH_SetupRqstFDD, "id-CommonPhysicalChannelType-CTCH-SetupRqstFDD" },
  { id_CommonPhysicalChannelType_CTCH_SetupRqstTDD, "id-CommonPhysicalChannelType-CTCH-SetupRqstTDD" },
  { id_Unknown_38, "id-Unknown-38" },
  { id_CommonMeasurementAccuracy, "id-CommonMeasurementAccuracy" },
  { id_CommunicationControlPortID, "id-CommunicationControlPortID" },
  { id_IPDLParameter_Information_LCR_Cell_SetupRqstTDD, "id-IPDLParameter-Information-LCR-Cell-SetupRqstTDD" },
  { id_IPDLParameter_Information_LCR_Cell_ReconfRqstTDD, "id-IPDLParameter-Information-LCR-Cell-ReconfRqstTDD" },
  { id_ConfigurationGenerationID, "id-ConfigurationGenerationID" },
  { id_CRNC_CommunicationContextID, "id-CRNC-CommunicationContextID" },
  { id_CriticalityDiagnostics, "id-CriticalityDiagnostics" },
  { id_CCTrCH_InformationItem_RL_FailureInd, "id-CCTrCH-InformationItem-RL-FailureInd" },
  { id_CCTrCH_InformationItem_RL_RestoreInd, "id-CCTrCH-InformationItem-RL-RestoreInd" },
  { id_DCHs_to_Add_FDD, "id-DCHs-to-Add-FDD" },
  { id_DCH_AddList_RL_ReconfPrepTDD, "id-DCH-AddList-RL-ReconfPrepTDD" },
  { id_DCHs_to_Add_TDD, "id-DCHs-to-Add-TDD" },
  { id_RL_InformationResponse_LCR_RL_AdditionRspTDD, "id-RL-InformationResponse-LCR-RL-AdditionRspTDD" },
  { id_DCH_DeleteList_RL_ReconfPrepFDD, "id-DCH-DeleteList-RL-ReconfPrepFDD" },
  { id_DCH_DeleteList_RL_ReconfPrepTDD, "id-DCH-DeleteList-RL-ReconfPrepTDD" },
  { id_DCH_DeleteList_RL_ReconfRqstFDD, "id-DCH-DeleteList-RL-ReconfRqstFDD" },
  { id_DCH_DeleteList_RL_ReconfRqstTDD, "id-DCH-DeleteList-RL-ReconfRqstTDD" },
  { id_DCH_FDD_Information, "id-DCH-FDD-Information" },
  { id_DCH_TDD_Information, "id-DCH-TDD-Information" },
  { id_neighbouringTDDCellMeasurementInformationLCR, "id-neighbouringTDDCellMeasurementInformationLCR" },
  { id_DCH_InformationResponse, "id-DCH-InformationResponse" },
  { id_Unknown_60, "id-Unknown-60" },
  { id_Unknown_61, "id-Unknown-61" },
  { id_FDD_DCHs_to_Modify, "id-FDD-DCHs-to-Modify" },
  { id_TDD_DCHs_to_Modify, "id-TDD-DCHs-to-Modify" },
  { id_Unused_ProtocolIE_ID_64, "id-Unused-ProtocolIE-ID-64" },
  { id_DCH_ModifyList_RL_ReconfRqstTDD, "id-DCH-ModifyList-RL-ReconfRqstTDD" },
  { id_PDSCH_RL_ID, "id-PDSCH-RL-ID" },
  { id_DedicatedMeasurementObjectType_DM_Rprt, "id-DedicatedMeasurementObjectType-DM-Rprt" },
  { id_DedicatedMeasurementObjectType_DM_Rqst, "id-DedicatedMeasurementObjectType-DM-Rqst" },
  { id_DedicatedMeasurementObjectType_DM_Rsp, "id-DedicatedMeasurementObjectType-DM-Rsp" },
  { id_DedicatedMeasurementType, "id-DedicatedMeasurementType" },
  { id_Unknown_71, "id-Unknown-71" },
  { id_DL_CCTrCH_InformationItem_RL_SetupRqstTDD, "id-DL-CCTrCH-InformationItem-RL-SetupRqstTDD" },
  { id_DL_CCTrCH_InformationList_RL_AdditionRqstTDD, "id-DL-CCTrCH-InformationList-RL-AdditionRqstTDD" },
  { id_DL_DPCH_LCR_Information_RL_SetupRqstTDD, "id-DL-DPCH-LCR-Information-RL-SetupRqstTDD" },
  { id_Unknown_75, "id-Unknown-75" },
  { id_DL_CCTrCH_InformationList_RL_SetupRqstTDD, "id-DL-CCTrCH-InformationList-RL-SetupRqstTDD" },
  { id_DL_DPCH_InformationItem_RL_AdditionRqstTDD, "id-DL-DPCH-InformationItem-RL-AdditionRqstTDD" },
  { id_DwPCH_LCR_Information, "id-DwPCH-LCR-Information" },
  { id_DL_DPCH_InformationList_RL_SetupRqstTDD, "id-DL-DPCH-InformationList-RL-SetupRqstTDD" },
  { id_Unknown_80, "id-Unknown-80" },
  { id_DL_DPCH_Information_RL_ReconfPrepFDD, "id-DL-DPCH-Information-RL-ReconfPrepFDD" },
  { id_DL_DPCH_Information_RL_ReconfRqstFDD, "id-DL-DPCH-Information-RL-ReconfRqstFDD" },
  { id_DL_DPCH_Information_RL_SetupRqstFDD, "id-DL-DPCH-Information-RL-SetupRqstFDD" },
  { id_DL_ReferencePowerInformationItem_DL_PC_Rqst, "id-DL-ReferencePowerInformationItem-DL-PC-Rqst" },
  { id_DLReferencePower, "id-DLReferencePower" },
  { id_DLReferencePowerList_DL_PC_Rqst, "id-DLReferencePowerList-DL-PC-Rqst" },
  { id_Unused_ProtocolIE_ID_87, "id-Unused-ProtocolIE-ID-87" },
  { id_Unknown_88, "id-Unknown-88" },
  { id_Unused_ProtocolIE_ID_89, "id-Unused-ProtocolIE-ID-89" },
  { id_DwPCH_LCR_InformationList_AuditRsp, "id-DwPCH-LCR-InformationList-AuditRsp" },
  { id_Unused_ProtocolIE_ID_91, "id-Unused-ProtocolIE-ID-91" },
  { id_Unknown_92, "id-Unknown-92" },
  { id_Unused_ProtocolIE_ID_93, "id-Unused-ProtocolIE-ID-93" },
  { id_Unused_ProtocolIE_ID_94, "id-Unused-ProtocolIE-ID-94" },
  { id_Unknown_95, "id-Unknown-95" },
  { id_DSCHs_to_Add_TDD, "id-DSCHs-to-Add-TDD" },
  { id_DwPCH_LCR_Information_Cell_SetupRqstTDD, "id-DwPCH-LCR-Information-Cell-SetupRqstTDD" },
  { id_DSCH_Information_DeleteList_RL_ReconfPrepTDD, "id-DSCH-Information-DeleteList-RL-ReconfPrepTDD" },
  { id_DwPCH_LCR_Information_Cell_ReconfRqstTDD, "id-DwPCH-LCR-Information-Cell-ReconfRqstTDD" },
  { id_DSCH_Information_ModifyList_RL_ReconfPrepTDD, "id-DSCH-Information-ModifyList-RL-ReconfPrepTDD" },
  { id_DwPCH_LCR_Information_ResourceStatusInd, "id-DwPCH-LCR-Information-ResourceStatusInd" },
  { id_bindingID, "id-bindingID" },
  { id_RL_Specific_DCH_Info, "id-RL-Specific-DCH-Info" },
  { id_transportlayeraddress, "id-transportlayeraddress" },
  { id_DSCH_InformationResponse, "id-DSCH-InformationResponse" },
  { id_Unused_ProtocolIE_ID_106, "id-Unused-ProtocolIE-ID-106" },
  { id_DSCH_TDD_Information, "id-DSCH-TDD-Information" },
  { id_Unused_ProtocolIE_ID_108, "id-Unused-ProtocolIE-ID-108" },
  { id_Unknown_109, "id-Unknown-109" },
  { id_Unused_ProtocolIE_ID_110, "id-Unused-ProtocolIE-ID-110" },
  { id_Unused_ProtocolIE_ID_111, "id-Unused-ProtocolIE-ID-111" },
  { id_Unused_ProtocolIE_ID_112, "id-Unused-ProtocolIE-ID-112" },
  { id_End_Of_Audit_Sequence_Indicator, "id-End-Of-Audit-Sequence-Indicator" },
  { id_Start_Of_Audit_Sequence_Indicator, "id-Start-Of-Audit-Sequence-Indicator" },
  { id_MessageStructure, "id-MessageStructure" },
  { id_FACH_Information, "id-FACH-Information" },
  { id_FACH_InformationItem_ResourceStatusInd, "id-FACH-InformationItem-ResourceStatusInd" },
  { id_Unknown_118, "id-Unknown-118" },
  { id_LateEntranceCellSyncInfoItem_CellSyncReprtTDD, "id-LateEntranceCellSyncInfoItem-CellSyncReprtTDD" },
  { id_FACH_ParametersList_CTCH_ReconfRqstTDD, "id-FACH-ParametersList-CTCH-ReconfRqstTDD" },
  { id_FACH_ParametersListIE_CTCH_SetupRqstFDD, "id-FACH-ParametersListIE-CTCH-SetupRqstFDD" },
  { id_FACH_ParametersListIE_CTCH_SetupRqstTDD, "id-FACH-ParametersListIE-CTCH-SetupRqstTDD" },
  { id_IndicationType_ResourceStatusInd, "id-IndicationType-ResourceStatusInd" },
  { id_Local_Cell_ID, "id-Local-Cell-ID" },
  { id_Local_Cell_InformationItem_AuditRsp, "id-Local-Cell-InformationItem-AuditRsp" },
  { id_Local_Cell_InformationItem_ResourceStatusInd, "id-Local-Cell-InformationItem-ResourceStatusInd" },
  { id_Local_Cell_InformationItem2_ResourceStatusInd, "id-Local-Cell-InformationItem2-ResourceStatusInd" },
  { id_Local_Cell_InformationList_AuditRsp, "id-Local-Cell-InformationList-AuditRsp" },
  { id_AdjustmentPeriod, "id-AdjustmentPeriod" },
  { id_MaxAdjustmentStep, "id-MaxAdjustmentStep" },
  { id_MaximumTransmissionPower, "id-MaximumTransmissionPower" },
  { id_MeasurementFilterCoefficient, "id-MeasurementFilterCoefficient" },
  { id_MeasurementID, "id-MeasurementID" },
  { id_MIB_SB_SIB_InformationList_SystemInfoUpdateRqst, "id-MIB-SB-SIB-InformationList-SystemInfoUpdateRqst" },
  { id_DCH_RearrangeList_Bearer_RearrangeInd, "id-DCH-RearrangeList-Bearer-RearrangeInd" },
  { id_DSCH_RearrangeList_Bearer_RearrangeInd, "id-DSCH-RearrangeList-Bearer-RearrangeInd" },
  { id_Unknown_137, "id-Unknown-137" },
  { id_SignallingBearerRequestIndicator, "id-SignallingBearerRequestIndicator" },
  { id_TargetCommunicationControlPortID, "id-TargetCommunicationControlPortID" },
  { id_Unknown_140, "id-Unknown-140" },
  { id_USCH_RearrangeList_Bearer_RearrangeInd, "id-USCH-RearrangeList-Bearer-RearrangeInd" },
  { id_Unused_ProtocolIE_ID_142, "id-Unused-ProtocolIE-ID-142" },
  { id_NodeB_CommunicationContextID, "id-NodeB-CommunicationContextID" },
  { id_P_CCPCH_Information, "id-P-CCPCH-Information" },
  { id_P_CCPCH_InformationItem_ResourceStatusInd, "id-P-CCPCH-InformationItem-ResourceStatusInd" },
  { id_P_CPICH_Information, "id-P-CPICH-Information" },
  { id_P_CPICH_InformationItem_ResourceStatusInd, "id-P-CPICH-InformationItem-ResourceStatusInd" },
  { id_P_SCH_Information, "id-P-SCH-Information" },
  { id_Unknown_149, "id-Unknown-149" },
  { id_PCCPCH_Information_Cell_ReconfRqstTDD, "id-PCCPCH-Information-Cell-ReconfRqstTDD" },
  { id_PCCPCH_Information_Cell_SetupRqstTDD, "id-PCCPCH-Information-Cell-SetupRqstTDD" },
  { id_Unknown_152, "id-Unknown-152" },
  { id_Unknown_153, "id-Unknown-153" },
  { id_maxFACH_Power_LCR_CTCH_SetupRqstTDD, "id-maxFACH-Power-LCR-CTCH-SetupRqstTDD" },
  { id_PCH_Parameters_CTCH_ReconfRqstTDD, "id-PCH-Parameters-CTCH-ReconfRqstTDD" },
  { id_PCH_ParametersItem_CTCH_SetupRqstFDD, "id-PCH-ParametersItem-CTCH-SetupRqstFDD" },
  { id_PCH_ParametersItem_CTCH_SetupRqstTDD, "id-PCH-ParametersItem-CTCH-SetupRqstTDD" },
  { id_PCH_Information, "id-PCH-Information" },
  { id_Unknown_159, "id-Unknown-159" },
  { id_Unknown_160, "id-Unknown-160" },
  { id_PDSCH_Information_AddListIE_PSCH_ReconfRqst, "id-PDSCH-Information-AddListIE-PSCH-ReconfRqst" },
  { id_PDSCH_Information_ModifyListIE_PSCH_ReconfRqst, "id-PDSCH-Information-ModifyListIE-PSCH-ReconfRqst" },
  { id_PDSCHSets_AddList_PSCH_ReconfRqst, "id-PDSCHSets-AddList-PSCH-ReconfRqst" },
  { id_PDSCHSets_DeleteList_PSCH_ReconfRqst, "id-PDSCHSets-DeleteList-PSCH-ReconfRqst" },
  { id_PDSCHSets_ModifyList_PSCH_ReconfRqst, "id-PDSCHSets-ModifyList-PSCH-ReconfRqst" },
  { id_PICH_Information, "id-PICH-Information" },
  { id_PICH_ParametersItem_CTCH_SetupRqstTDD, "id-PICH-ParametersItem-CTCH-SetupRqstTDD" },
  { id_PICH_Parameters_CTCH_ReconfRqstTDD, "id-PICH-Parameters-CTCH-ReconfRqstTDD" },
  { id_PowerAdjustmentType, "id-PowerAdjustmentType" },
  { id_PRACH_Information, "id-PRACH-Information" },
  { id_Unknown_171, "id-Unknown-171" },
  { id_Unknown_172, "id-Unknown-172" },
  { id_Unknown_173, "id-Unknown-173" },
  { id_maxFACH_Power_LCR_CTCH_ReconfRqstTDD, "id-maxFACH-Power-LCR-CTCH-ReconfRqstTDD" },
  { id_PrimaryCCPCH_Information_Cell_ReconfRqstFDD, "id-PrimaryCCPCH-Information-Cell-ReconfRqstFDD" },
  { id_PrimaryCCPCH_Information_Cell_SetupRqstFDD, "id-PrimaryCCPCH-Information-Cell-SetupRqstFDD" },
  { id_PrimaryCPICH_Information_Cell_ReconfRqstFDD, "id-PrimaryCPICH-Information-Cell-ReconfRqstFDD" },
  { id_PrimaryCPICH_Information_Cell_SetupRqstFDD, "id-PrimaryCPICH-Information-Cell-SetupRqstFDD" },
  { id_PrimarySCH_Information_Cell_ReconfRqstFDD, "id-PrimarySCH-Information-Cell-ReconfRqstFDD" },
  { id_PrimarySCH_Information_Cell_SetupRqstFDD, "id-PrimarySCH-Information-Cell-SetupRqstFDD" },
  { id_PrimaryScramblingCode, "id-PrimaryScramblingCode" },
  { id_Unknown_182, "id-Unknown-182" },
  { id_SCH_Information_Cell_ReconfRqstTDD, "id-SCH-Information-Cell-ReconfRqstTDD" },
  { id_SCH_Information_Cell_SetupRqstTDD, "id-SCH-Information-Cell-SetupRqstTDD" },
  { id_PUSCH_Information_AddListIE_PSCH_ReconfRqst, "id-PUSCH-Information-AddListIE-PSCH-ReconfRqst" },
  { id_PUSCH_Information_ModifyListIE_PSCH_ReconfRqst, "id-PUSCH-Information-ModifyListIE-PSCH-ReconfRqst" },
  { id_PUSCHSets_AddList_PSCH_ReconfRqst, "id-PUSCHSets-AddList-PSCH-ReconfRqst" },
  { id_PUSCHSets_DeleteList_PSCH_ReconfRqst, "id-PUSCHSets-DeleteList-PSCH-ReconfRqst" },
  { id_PUSCHSets_ModifyList_PSCH_ReconfRqst, "id-PUSCHSets-ModifyList-PSCH-ReconfRqst" },
  { id_RACH_Information, "id-RACH-Information" },
  { id_Unknown_191, "id-Unknown-191" },
  { id_Unknown_192, "id-Unknown-192" },
  { id_Unknown_193, "id-Unknown-193" },
  { id_Unknown_194, "id-Unknown-194" },
  { id_Unknown_195, "id-Unknown-195" },
  { id_RACH_ParametersItem_CTCH_SetupRqstFDD, "id-RACH-ParametersItem-CTCH-SetupRqstFDD" },
  { id_RACH_ParameterItem_CTCH_SetupRqstTDD, "id-RACH-ParameterItem-CTCH-SetupRqstTDD" },
  { id_ReportCharacteristics, "id-ReportCharacteristics" },
  { id_Reporting_Object_RL_FailureInd, "id-Reporting-Object-RL-FailureInd" },
  { id_Reporting_Object_RL_RestoreInd, "id-Reporting-Object-RL-RestoreInd" },
  { id_Unknown_201, "id-Unknown-201" },
  { id_RL_InformationItem_DM_Rprt, "id-RL-InformationItem-DM-Rprt" },
  { id_RL_InformationItem_DM_Rqst, "id-RL-InformationItem-DM-Rqst" },
  { id_RL_InformationItem_DM_Rsp, "id-RL-InformationItem-DM-Rsp" },
  { id_RL_InformationItem_RL_AdditionRqstFDD, "id-RL-InformationItem-RL-AdditionRqstFDD" },
  { id_RL_informationItem_RL_DeletionRqst, "id-RL-informationItem-RL-DeletionRqst" },
  { id_RL_InformationItem_RL_FailureInd, "id-RL-InformationItem-RL-FailureInd" },
  { id_RL_InformationItem_RL_ReconfPrepFDD, "id-RL-InformationItem-RL-ReconfPrepFDD" },
  { id_RL_InformationItem_RL_ReconfRqstFDD, "id-RL-InformationItem-RL-ReconfRqstFDD" },
  { id_RL_InformationItem_RL_RestoreInd, "id-RL-InformationItem-RL-RestoreInd" },
  { id_RL_InformationItem_RL_SetupRqstFDD, "id-RL-InformationItem-RL-SetupRqstFDD" },
  { id_RL_InformationList_RL_AdditionRqstFDD, "id-RL-InformationList-RL-AdditionRqstFDD" },
  { id_RL_informationList_RL_DeletionRqst, "id-RL-informationList-RL-DeletionRqst" },
  { id_RL_InformationList_RL_ReconfPrepFDD, "id-RL-InformationList-RL-ReconfPrepFDD" },
  { id_RL_InformationList_RL_ReconfRqstFDD, "id-RL-InformationList-RL-ReconfRqstFDD" },
  { id_RL_InformationList_RL_SetupRqstFDD, "id-RL-InformationList-RL-SetupRqstFDD" },
  { id_RL_InformationResponseItem_RL_AdditionRspFDD, "id-RL-InformationResponseItem-RL-AdditionRspFDD" },
  { id_RL_InformationResponseItem_RL_ReconfReady, "id-RL-InformationResponseItem-RL-ReconfReady" },
  { id_RL_InformationResponseItem_RL_ReconfRsp, "id-RL-InformationResponseItem-RL-ReconfRsp" },
  { id_RL_InformationResponseItem_RL_SetupRspFDD, "id-RL-InformationResponseItem-RL-SetupRspFDD" },
  { id_RL_InformationResponseList_RL_AdditionRspFDD, "id-RL-InformationResponseList-RL-AdditionRspFDD" },
  { id_RL_InformationResponseList_RL_ReconfReady, "id-RL-InformationResponseList-RL-ReconfReady" },
  { id_RL_InformationResponseList_RL_ReconfRsp, "id-RL-InformationResponseList-RL-ReconfRsp" },
  { id_RL_InformationResponseList_RL_SetupRspFDD, "id-RL-InformationResponseList-RL-SetupRspFDD" },
  { id_RL_InformationResponse_RL_AdditionRspTDD, "id-RL-InformationResponse-RL-AdditionRspTDD" },
  { id_RL_InformationResponse_RL_SetupRspTDD, "id-RL-InformationResponse-RL-SetupRspTDD" },
  { id_RL_Information_RL_AdditionRqstTDD, "id-RL-Information-RL-AdditionRqstTDD" },
  { id_RL_Information_RL_ReconfRqstTDD, "id-RL-Information-RL-ReconfRqstTDD" },
  { id_RL_Information_RL_ReconfPrepTDD, "id-RL-Information-RL-ReconfPrepTDD" },
  { id_RL_Information_RL_SetupRqstTDD, "id-RL-Information-RL-SetupRqstTDD" },
  { id_DelayedActivation, "id-DelayedActivation" },
  { id_DelayedActivationList_RL_ActivationCmdFDD, "id-DelayedActivationList-RL-ActivationCmdFDD" },
  { id_DelayedActivationInformation_RL_ActivationCmdFDD, "id-DelayedActivationInformation-RL-ActivationCmdFDD" },
  { id_DelayedActivationList_RL_ActivationCmdTDD, "id-DelayedActivationList-RL-ActivationCmdTDD" },
  { id_DelayedActivationInformation_RL_ActivationCmdTDD, "id-DelayedActivationInformation-RL-ActivationCmdTDD" },
  { id_RL_ReconfigurationFailureItem_RL_ReconfFailure, "id-RL-ReconfigurationFailureItem-RL-ReconfFailure" },
  { id_RL_InformationList_RL_PreemptRequiredInd, "id-RL-InformationList-RL-PreemptRequiredInd" },
  { id_RL_Set_InformationItem_DM_Rprt, "id-RL-Set-InformationItem-DM-Rprt" },
  { id_Unknown_239, "id-Unknown-239" },
  { id_RL_Set_InformationItem_DM_Rsp, "id-RL-Set-InformationItem-DM-Rsp" },
  { id_RL_Set_InformationItem_RL_FailureInd, "id-RL-Set-InformationItem-RL-FailureInd" },
  { id_RL_Set_InformationItem_RL_RestoreInd, "id-RL-Set-InformationItem-RL-RestoreInd" },
  { id_Unknown_243, "id-Unknown-243" },
  { id_Unknown_244, "id-Unknown-244" },
  { id_Unknown_245, "id-Unknown-245" },
  { id_Unknown_246, "id-Unknown-246" },
  { id_S_CCPCH_Information, "id-S-CCPCH-Information" },
  { id_Unknown_248, "id-Unknown-248" },
  { id_S_CPICH_Information, "id-S-CPICH-Information" },
  { id_Unknown_250, "id-Unknown-250" },
  { id_SCH_Information, "id-SCH-Information" },
  { id_Unknown_252, "id-Unknown-252" },
  { id_S_SCH_Information, "id-S-SCH-Information" },
  { id_Unknown_254, "id-Unknown-254" },
  { id_Unknown_255, "id-Unknown-255" },
  { id_Unknown_256, "id-Unknown-256" },
  { id_Secondary_CCPCHListIE_CTCH_ReconfRqstTDD, "id-Secondary-CCPCHListIE-CTCH-ReconfRqstTDD" },
  { id_Secondary_CCPCH_parameterListIE_CTCH_SetupRqstTDD, "id-Secondary-CCPCH-parameterListIE-CTCH-SetupRqstTDD" },
  { id_Secondary_CCPCH_Parameters_CTCH_ReconfRqstTDD, "id-Secondary-CCPCH-Parameters-CTCH-ReconfRqstTDD" },
  { id_SecondaryCPICH_InformationItem_Cell_ReconfRqstFDD, "id-SecondaryCPICH-InformationItem-Cell-ReconfRqstFDD" },
  { id_SecondaryCPICH_InformationItem_Cell_SetupRqstFDD, "id-SecondaryCPICH-InformationItem-Cell-SetupRqstFDD" },
  { id_SecondaryCPICH_InformationList_Cell_ReconfRqstFDD, "id-SecondaryCPICH-InformationList-Cell-ReconfRqstFDD" },
  { id_SecondaryCPICH_InformationList_Cell_SetupRqstFDD, "id-SecondaryCPICH-InformationList-Cell-SetupRqstFDD" },
  { id_SecondarySCH_Information_Cell_ReconfRqstFDD, "id-SecondarySCH-Information-Cell-ReconfRqstFDD" },
  { id_SecondarySCH_Information_Cell_SetupRqstFDD, "id-SecondarySCH-Information-Cell-SetupRqstFDD" },
  { id_SegmentInformationListIE_SystemInfoUpdate, "id-SegmentInformationListIE-SystemInfoUpdate" },
  { id_Unknown_267, "id-Unknown-267" },
  { id_SFN, "id-SFN" },
  { id_ShutdownTimer, "id-ShutdownTimer" },
  { id_Successful_RL_InformationRespItem_RL_AdditionFailureFDD, "id-Successful-RL-InformationRespItem-RL-AdditionFailureFDD" },
  { id_Successful_RL_InformationRespItem_RL_SetupFailureFDD, "id-Successful-RL-InformationRespItem-RL-SetupFailureFDD" },
  { id_Unknown_272, "id-Unknown-272" },
  { id_Unknown_273, "id-Unknown-273" },
  { id_SyncCase, "id-SyncCase" },
  { id_SyncCaseIndicatorItem_Cell_SetupRqstTDD_PSCH, "id-SyncCaseIndicatorItem-Cell-SetupRqstTDD-PSCH" },
  { id_T_Cell, "id-T-Cell" },
  { id_TimeSlotConfigurationList_Cell_ReconfRqstTDD, "id-TimeSlotConfigurationList-Cell-ReconfRqstTDD" },
  { id_TimeSlotConfigurationList_Cell_SetupRqstTDD, "id-TimeSlotConfigurationList-Cell-SetupRqstTDD" },
  { id_TransmissionDiversityApplied, "id-TransmissionDiversityApplied" },
  { id_UARFCNforNt, "id-UARFCNforNt" },
  { id_UARFCNforNd, "id-UARFCNforNd" },
  { id_UARFCNforNu, "id-UARFCNforNu" },
  { id_TimeslotISCPInfo, "id-TimeslotISCPInfo" },
  { id_UL_CCTrCH_InformationItem_RL_SetupRqstTDD, "id-UL-CCTrCH-InformationItem-RL-SetupRqstTDD" },
  { id_UL_CCTrCH_InformationList_RL_AdditionRqstTDD, "id-UL-CCTrCH-InformationList-RL-AdditionRqstTDD" },
  { id_RL_InformationItem_RL_PreemptRequiredInd, "id-RL-InformationItem-RL-PreemptRequiredInd" },
  { id_TimingAdvanceApplied, "id-TimingAdvanceApplied" },
  { id_UL_CCTrCH_InformationList_RL_SetupRqstTDD, "id-UL-CCTrCH-InformationList-RL-SetupRqstTDD" },
  { id_UL_DPCH_InformationItem_RL_AdditionRqstTDD, "id-UL-DPCH-InformationItem-RL-AdditionRqstTDD" },
  { id_FPACH_LCR_Information, "id-FPACH-LCR-Information" },
  { id_UL_DPCH_InformationList_RL_SetupRqstTDD, "id-UL-DPCH-InformationList-RL-SetupRqstTDD" },
  { id_FPACH_LCR_Information_AuditRsp, "id-FPACH-LCR-Information-AuditRsp" },
  { id_UL_DPCH_Information_RL_ReconfPrepFDD, "id-UL-DPCH-Information-RL-ReconfPrepFDD" },
  { id_UL_DPCH_Information_RL_ReconfRqstFDD, "id-UL-DPCH-Information-RL-ReconfRqstFDD" },
  { id_UL_DPCH_Information_RL_SetupRqstFDD, "id-UL-DPCH-Information-RL-SetupRqstFDD" },
  { id_Unsuccessful_RL_InformationRespItem_RL_AdditionFailureFDD, "id-Unsuccessful-RL-InformationRespItem-RL-AdditionFailureFDD" },
  { id_Unsuccessful_RL_InformationRespItem_RL_SetupFailureFDD, "id-Unsuccessful-RL-InformationRespItem-RL-SetupFailureFDD" },
  { id_Unknown_298, "id-Unknown-298" },
  { id_Unknown_299, "id-Unknown-299" },
  { id_Unsuccessful_RL_InformationResp_RL_AdditionFailureTDD, "id-Unsuccessful-RL-InformationResp-RL-AdditionFailureTDD" },
  { id_Unsuccessful_RL_InformationResp_RL_SetupFailureTDD, "id-Unsuccessful-RL-InformationResp-RL-SetupFailureTDD" },
  { id_USCH_Information_Add, "id-USCH-Information-Add" },
  { id_Unknown_303, "id-Unknown-303" },
  { id_USCH_Information_DeleteList_RL_ReconfPrepTDD, "id-USCH-Information-DeleteList-RL-ReconfPrepTDD" },
  { id_Unknown_305, "id-Unknown-305" },
  { id_USCH_Information_ModifyList_RL_ReconfPrepTDD, "id-USCH-Information-ModifyList-RL-ReconfPrepTDD" },
  { id_Unknown_307, "id-Unknown-307" },
  { id_Unknown_308, "id-Unknown-308" },
  { id_USCH_InformationResponse, "id-USCH-InformationResponse" },
  { id_USCH_Information, "id-USCH-Information" },
  { id_FPACH_LCR_InformationList_ResourceStatusInd, "id-FPACH-LCR-InformationList-ResourceStatusInd" },
  { id_FPACH_LCR_Parameters_CTCH_SetupRqstTDD, "id-FPACH-LCR-Parameters-CTCH-SetupRqstTDD" },
  { id_Unknown_313, "id-Unknown-313" },
  { id_FPACH_LCR_Parameters_CTCH_ReconfRqstTDD, "id-FPACH-LCR-Parameters-CTCH-ReconfRqstTDD" },
  { id_Active_Pattern_Sequence_Information, "id-Active-Pattern-Sequence-Information" },
  { id_AICH_ParametersListIE_CTCH_ReconfRqstFDD, "id-AICH-ParametersListIE-CTCH-ReconfRqstFDD" },
  { id_AdjustmentRatio, "id-AdjustmentRatio" },
  { id_Unknown_318, "id-Unknown-318" },
  { id_Unknown_319, "id-Unknown-319" },
  { id_Not_Used_320, "id-Not-Used-320" },
  { id_Unknown_321, "id-Unknown-321" },
  { id_Not_Used_322, "id-Not-Used-322" },
  { id_FACH_ParametersListIE_CTCH_ReconfRqstFDD, "id-FACH-ParametersListIE-CTCH-ReconfRqstFDD" },
  { id_CauseLevel_PSCH_ReconfFailure, "id-CauseLevel-PSCH-ReconfFailure" },
  { id_CauseLevel_RL_AdditionFailureFDD, "id-CauseLevel-RL-AdditionFailureFDD" },
  { id_CauseLevel_RL_AdditionFailureTDD, "id-CauseLevel-RL-AdditionFailureTDD" },
  { id_CauseLevel_RL_ReconfFailure, "id-CauseLevel-RL-ReconfFailure" },
  { id_CauseLevel_RL_SetupFailureFDD, "id-CauseLevel-RL-SetupFailureFDD" },
  { id_CauseLevel_RL_SetupFailureTDD, "id-CauseLevel-RL-SetupFailureTDD" },
  { id_Not_Used_330, "id-Not-Used-330" },
  { id_Unknown_331, "id-Unknown-331" },
  { id_Not_Used_332, "id-Not-Used-332" },
  { id_Closed_Loop_Timing_Adjustment_Mode, "id-Closed-Loop-Timing-Adjustment-Mode" },
  { id_CommonPhysicalChannelType_CTCH_ReconfRqstFDD, "id-CommonPhysicalChannelType-CTCH-ReconfRqstFDD" },
  { id_Compressed_Mode_Deactivation_Flag, "id-Compressed-Mode-Deactivation-Flag" },
  { id_Not_Used_336, "id-Not-Used-336" },
  { id_Unknown_337, "id-Unknown-337" },
  { id_Unknown_338, "id-Unknown-338" },
  { id_Unknown_339, "id-Unknown-339" },
  { id_Unknown_340, "id-Unknown-340" },
  { id_Unknown_341, "id-Unknown-341" },
  { id_Not_Used_342, "id-Not-Used-342" },
  { id_Not_Used_343, "id-Not-Used-343" },
  { id_Unknown_344, "id-Unknown-344" },
  { id_Unknown_345, "id-Unknown-345" },
  { id_DL_CCTrCH_InformationAddList_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationAddList-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD, "id-DL-CCTrCH-InformationDeleteItem-RL-ReconfRqstTDD" },
  { id_DL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationDeleteList-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD, "id-DL-CCTrCH-InformationDeleteList-RL-ReconfRqstTDD" },
  { id_DL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD, "id-DL-CCTrCH-InformationModifyItem-RL-ReconfRqstTDD" },
  { id_DL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD, "id-DL-CCTrCH-InformationModifyList-RL-ReconfPrepTDD" },
  { id_DL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD, "id-DL-CCTrCH-InformationModifyList-RL-ReconfRqstTDD" },
  { id_DL_DPCH_InformationAddListIE_RL_ReconfPrepTDD, "id-DL-DPCH-InformationAddListIE-RL-ReconfPrepTDD" },
  { id_Unknown_354, "id-Unknown-354" },
  { id_DL_DPCH_InformationModify_AddListIE_RL_ReconfPrepTDD, "id-DL-DPCH-InformationModify-AddListIE-RL-ReconfPrepTDD" },
  { id_DL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD, "id-DL-DPCH-InformationModify-DeleteListIE-RL-ReconfPrepTDD" },
  { id_DL_DPCH_InformationModify_ModifyListIE_RL_ReconfPrepTDD, "id-DL-DPCH-InformationModify-ModifyListIE-RL-ReconfPrepTDD" },
  { id_DL_TPC_Pattern01Count, "id-DL-TPC-Pattern01Count" },
  { id_DPCHConstant, "id-DPCHConstant" },
  { id_Unknown_360, "id-Unknown-360" },
  { id_Unknown_361, "id-Unknown-361" },
  { id_FACH_ParametersList_CTCH_SetupRsp, "id-FACH-ParametersList-CTCH-SetupRsp" },
  { id_Unknown_363, "id-Unknown-363" },
  { id_Unknown_364, "id-Unknown-364" },
  { id_Unknown_365, "id-Unknown-365" },
  { id_Unknown_366, "id-Unknown-366" },
  { id_Unknown_367, "id-Unknown-367" },
  { id_Unknown_368, "id-Unknown-368" },
  { id_Limited_power_increase_information_Cell_SetupRqstFDD, "id-Limited-power-increase-information-Cell-SetupRqstFDD" },
  { id_Unknown_370, "id-Unknown-370" },
  { id_Unknown_371, "id-Unknown-371" },
  { id_Unknown_372, "id-Unknown-372" },
  { id_Unknown_373, "id-Unknown-373" },
  { id_PCH_Parameters_CTCH_SetupRsp, "id-PCH-Parameters-CTCH-SetupRsp" },
  { id_PCH_ParametersItem_CTCH_ReconfRqstFDD, "id-PCH-ParametersItem-CTCH-ReconfRqstFDD" },
  { id_Not_Used_376, "id-Not-Used-376" },
  { id_Unknown_377, "id-Unknown-377" },
  { id_Unknown_378, "id-Unknown-378" },
  { id_Unknown_379, "id-Unknown-379" },
  { id_PICH_ParametersItem_CTCH_ReconfRqstFDD, "id-PICH-ParametersItem-CTCH-ReconfRqstFDD" },
  { id_PRACHConstant, "id-PRACHConstant" },
  { id_Unknown_382, "id-Unknown-382" },
  { id_PRACH_ParametersListIE_CTCH_ReconfRqstFDD, "id-PRACH-ParametersListIE-CTCH-ReconfRqstFDD" },
  { id_PUSCHConstant, "id-PUSCHConstant" },
  { id_RACH_Parameters_CTCH_SetupRsp, "id-RACH-Parameters-CTCH-SetupRsp" },
  { id_Unknown_386, "id-Unknown-386" },
  { id_Unknown_387, "id-Unknown-387" },
  { id_Unknown_388, "id-Unknown-388" },
  { id_Unknown_389, "id-Unknown-389" },
  { id_Unknown_390, "id-Unknown-390" },
  { id_Unknown_391, "id-Unknown-391" },
  { id_Unknown_392, "id-Unknown-392" },
  { id_Synchronisation_Configuration_Cell_ReconfRqst, "id-Synchronisation-Configuration-Cell-ReconfRqst" },
  { id_Synchronisation_Configuration_Cell_SetupRqst, "id-Synchronisation-Configuration-Cell-SetupRqst" },
  { id_Transmission_Gap_Pattern_Sequence_Information, "id-Transmission-Gap-Pattern-Sequence-Information" },
  { id_UL_CCTrCH_InformationAddList_RL_ReconfPrepTDD, "id-UL-CCTrCH-InformationAddList-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_InformationDeleteItem_RL_ReconfRqstTDD, "id-UL-CCTrCH-InformationDeleteItem-RL-ReconfRqstTDD" },
  { id_UL_CCTrCH_InformationDeleteList_RL_ReconfPrepTDD, "id-UL-CCTrCH-InformationDeleteList-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_InformationDeleteList_RL_ReconfRqstTDD, "id-UL-CCTrCH-InformationDeleteList-RL-ReconfRqstTDD" },
  { id_UL_CCTrCH_InformationModifyItem_RL_ReconfRqstTDD, "id-UL-CCTrCH-InformationModifyItem-RL-ReconfRqstTDD" },
  { id_UL_CCTrCH_InformationModifyList_RL_ReconfPrepTDD, "id-UL-CCTrCH-InformationModifyList-RL-ReconfPrepTDD" },
  { id_UL_CCTrCH_InformationModifyList_RL_ReconfRqstTDD, "id-UL-CCTrCH-InformationModifyList-RL-ReconfRqstTDD" },
  { id_UL_DPCH_InformationAddListIE_RL_ReconfPrepTDD, "id-UL-DPCH-InformationAddListIE-RL-ReconfPrepTDD" },
  { id_Unknown_404, "id-Unknown-404" },
  { id_UL_DPCH_InformationModify_AddListIE_RL_ReconfPrepTDD, "id-UL-DPCH-InformationModify-AddListIE-RL-ReconfPrepTDD" },
  { id_UL_DPCH_InformationModify_DeleteListIE_RL_ReconfPrepTDD, "id-UL-DPCH-InformationModify-DeleteListIE-RL-ReconfPrepTDD" },
  { id_UL_DPCH_InformationModify_ModifyListIE_RL_ReconfPrepTDD, "id-UL-DPCH-InformationModify-ModifyListIE-RL-ReconfPrepTDD" },
  { id_Unsuccessful_PDSCHSetItem_PSCH_ReconfFailureTDD, "id-Unsuccessful-PDSCHSetItem-PSCH-ReconfFailureTDD" },
  { id_Unsuccessful_PUSCHSetItem_PSCH_ReconfFailureTDD, "id-Unsuccessful-PUSCHSetItem-PSCH-ReconfFailureTDD" },
  { id_Unknown_410, "id-Unknown-410" },
  { id_Unknown_411, "id-Unknown-411" },
  { id_CommunicationContextInfoItem_Reset, "id-CommunicationContextInfoItem-Reset" },
  { id_Unknown_413, "id-Unknown-413" },
  { id_CommunicationControlPortInfoItem_Reset, "id-CommunicationControlPortInfoItem-Reset" },
  { id_Unknown_415, "id-Unknown-415" },
  { id_ResetIndicator, "id-ResetIndicator" },
  { id_Unused_ProtocolIE_ID_417, "id-Unused-ProtocolIE-ID-417" },
  { id_Unused_ProtocolIE_ID_418, "id-Unused-ProtocolIE-ID-418" },
  { id_Unused_ProtocolIE_ID_419, "id-Unused-ProtocolIE-ID-419" },
  { id_CauseLevel_SyncAdjustmntFailureTDD, "id-CauseLevel-SyncAdjustmntFailureTDD" },
  { id_CellAdjustmentInfo_SyncAdjustmntRqstTDD, "id-CellAdjustmentInfo-SyncAdjustmntRqstTDD" },
  { id_CellSyncBurstTransInit_CellSyncInitiationRqstTDD, "id-CellSyncBurstTransInit-CellSyncInitiationRqstTDD" },
  { id_CellSyncBurstMeasureInit_CellSyncInitiationRqstTDD, "id-CellSyncBurstMeasureInit-CellSyncInitiationRqstTDD" },
  { id_CellSyncBurstTransReconfiguration_CellSyncReconfRqstTDD, "id-CellSyncBurstTransReconfiguration-CellSyncReconfRqstTDD" },
  { id_CellSyncBurstMeasReconfiguration_CellSyncReconfRqstTDD, "id-CellSyncBurstMeasReconfiguration-CellSyncReconfRqstTDD" },
  { id_CellSyncBurstTransInfoList_CellSyncReconfRqstTDD, "id-CellSyncBurstTransInfoList-CellSyncReconfRqstTDD" },
  { id_CellSyncBurstMeasInfoList_CellSyncReconfRqstTDD, "id-CellSyncBurstMeasInfoList-CellSyncReconfRqstTDD" },
  { id_CellSyncBurstTransReconfInfo_CellSyncReconfRqstTDD, "id-CellSyncBurstTransReconfInfo-CellSyncReconfRqstTDD" },
  { id_CellSyncInfo_CellSyncReprtTDD, "id-CellSyncInfo-CellSyncReprtTDD" },
  { id_CSBTransmissionID, "id-CSBTransmissionID" },
  { id_CSBMeasurementID, "id-CSBMeasurementID" },
  { id_IntStdPhCellSyncInfoItem_CellSyncReprtTDD, "id-IntStdPhCellSyncInfoItem-CellSyncReprtTDD" },
  { id_NCyclesPerSFNperiod, "id-NCyclesPerSFNperiod" },
  { id_NRepetitionsPerCyclePeriod, "id-NRepetitionsPerCyclePeriod" },
  { id_ReferenceClockAvailability, "id-ReferenceClockAvailability" },
  { id_ReferenceSFNoffset, "id-ReferenceSFNoffset" },
  { id_SyncFrameNumber, "id-SyncFrameNumber" },
  { id_SynchronisationReportType, "id-SynchronisationReportType" },
  { id_SynchronisationReportCharacteristics, "id-SynchronisationReportCharacteristics" },
  { id_Unsuccessful_cell_InformationRespItem_SyncAdjustmntFailureTDD, "id-Unsuccessful-cell-InformationRespItem-SyncAdjustmntFailureTDD" },
  { id_Unknown_441, "id-Unknown-441" },
  { id_Unknown_442, "id-Unknown-442" },
  { id_Unused_ProtocolIE_ID_443, "id-Unused-ProtocolIE-ID-443" },
  { id_InformationExchangeID, "id-InformationExchangeID" },
  { id_InformationExchangeObjectType_InfEx_Rqst, "id-InformationExchangeObjectType-InfEx-Rqst" },
  { id_InformationType, "id-InformationType" },
  { id_InformationReportCharacteristics, "id-InformationReportCharacteristics" },
  { id_InformationExchangeObjectType_InfEx_Rsp, "id-InformationExchangeObjectType-InfEx-Rsp" },
  { id_InformationExchangeObjectType_InfEx_Rprt, "id-InformationExchangeObjectType-InfEx-Rprt" },
  { id_DPC_Mode, "id-DPC-Mode" },
  { id_IPDLParameter_Information_Cell_ReconfRqstFDD, "id-IPDLParameter-Information-Cell-ReconfRqstFDD" },
  { id_IPDLParameter_Information_Cell_SetupRqstFDD, "id-IPDLParameter-Information-Cell-SetupRqstFDD" },
  { id_IPDLParameter_Information_Cell_ReconfRqstTDD, "id-IPDLParameter-Information-Cell-ReconfRqstTDD" },
  { id_IPDLParameter_Information_Cell_SetupRqstTDD, "id-IPDLParameter-Information-Cell-SetupRqstTDD" },
  { id_NeighbouringCellMeasurementInformation, "id-NeighbouringCellMeasurementInformation" },
  { id_PCCPCH_LCR_Information_Cell_SetupRqstTDD, "id-PCCPCH-LCR-Information-Cell-SetupRqstTDD" },
  { id_PCH_Power_LCR_CTCH_SetupRqstTDD, "id-PCH-Power-LCR-CTCH-SetupRqstTDD" },
  { id_PCH_Power_LCR_CTCH_ReconfRqstTDD, "id-PCH-Power-LCR-CTCH-ReconfRqstTDD" },
  { id_PICH_LCR_Parameters_CTCH_SetupRqstTDD, "id-PICH-LCR-Parameters-CTCH-SetupRqstTDD" },
  { id_Unknown_460, "id-Unknown-460" },
  { id_PRACH_LCR_ParametersList_CTCH_SetupRqstTDD, "id-PRACH-LCR-ParametersList-CTCH-SetupRqstTDD" },
  { id_Unknown_462, "id-Unknown-462" },
  { id_RL_InformationResponse_LCR_RL_SetupRspTDD, "id-RL-InformationResponse-LCR-RL-SetupRspTDD" },
  { id_Unknown_464, "id-Unknown-464" },
  { id_Secondary_CCPCH_LCR_parameterList_CTCH_SetupRqstTDD, "id-Secondary-CCPCH-LCR-parameterList-CTCH-SetupRqstTDD" },
  { id_TimeSlotConfigurationList_LCR_Cell_ReconfRqstTDD, "id-TimeSlotConfigurationList-LCR-Cell-ReconfRqstTDD" },
  { id_TimeSlotConfigurationList_LCR_Cell_SetupRqstTDD, "id-TimeSlotConfigurationList-LCR-Cell-SetupRqstTDD" },
  { id_TimeslotISCP_LCR_InfoList_RL_SetupRqstTDD, "id-TimeslotISCP-LCR-InfoList-RL-SetupRqstTDD" },
  { id_TimeSlotLCR_CM_Rqst, "id-TimeSlotLCR-CM-Rqst" },
  { id_UL_DPCH_LCR_Information_RL_SetupRqstTDD, "id-UL-DPCH-LCR-Information-RL-SetupRqstTDD" },
  { id_Unknown_471, "id-Unknown-471" },
  { id_DL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD, "id-DL-DPCH-InformationItem-LCR-RL-AdditionRqstTDD" },
  { id_UL_DPCH_InformationItem_LCR_RL_AdditionRqstTDD, "id-UL-DPCH-InformationItem-LCR-RL-AdditionRqstTDD" },
  { id_TimeslotISCP_InformationList_LCR_RL_AdditionRqstTDD, "id-TimeslotISCP-InformationList-LCR-RL-AdditionRqstTDD" },
  { id_DL_DPCH_LCR_InformationAddList_RL_ReconfPrepTDD, "id-DL-DPCH-LCR-InformationAddList-RL-ReconfPrepTDD" },
  { id_Unknown_476, "id-Unknown-476" },
  { id_DL_DPCH_LCR_InformationModify_AddList_RL_ReconfPrepTDD, "id-DL-DPCH-LCR-InformationModify-AddList-RL-ReconfPrepTDD" },
  { id_Unknown_478, "id-Unknown-478" },
  { id_DL_Timeslot_LCR_InformationModify_ModifyList_RL_ReconfPrepTDD, "id-DL-Timeslot-LCR-InformationModify-ModifyList-RL-ReconfPrepTDD" },
  { id_TimeslotISCPInfoList_LCR_DL_PC_RqstTDD, "id-TimeslotISCPInfoList-LCR-DL-PC-RqstTDD" },
  { id_UL_DPCH_LCR_InformationAddListIE_RL_ReconfPrepTDD, "id-UL-DPCH-LCR-InformationAddListIE-RL-ReconfPrepTDD" },
  { id_CellSyncBurstInfoList_CellSyncReconfRqstTDD, "id-CellSyncBurstInfoList-CellSyncReconfRqstTDD" },
  { id_UL_DPCH_LCR_InformationModify_AddList, "id-UL-DPCH-LCR-InformationModify-AddList" },
  { id_Unknown_484, "id-Unknown-484" },
  { id_UL_TimeslotLCR_Information_RL_ReconfPrepTDD, "id-UL-TimeslotLCR-Information-RL-ReconfPrepTDD" },
  { id_PDSCH_AddInformation_LCR_PSCH_ReconfRqst, "id-PDSCH-AddInformation-LCR-PSCH-ReconfRqst" },
  { id_PDSCH_AddInformation_LCR_AddListIE_PSCH_ReconfRqst, "id-PDSCH-AddInformation-LCR-AddListIE-PSCH-ReconfRqst" },
  { id_PDSCH_ModifyInformation_LCR_PSCH_ReconfRqst, "id-PDSCH-ModifyInformation-LCR-PSCH-ReconfRqst" },
  { id_PDSCH_ModifyInformation_LCR_ModifyListIE_PSCH_ReconfRqst, "id-PDSCH-ModifyInformation-LCR-ModifyListIE-PSCH-ReconfRqst" },
  { id_PUSCH_AddInformation_LCR_PSCH_ReconfRqst, "id-PUSCH-AddInformation-LCR-PSCH-ReconfRqst" },
  { id_PUSCH_AddInformation_LCR_AddListIE_PSCH_ReconfRqst, "id-PUSCH-AddInformation-LCR-AddListIE-PSCH-ReconfRqst" },
  { id_PUSCH_ModifyInformation_LCR_PSCH_ReconfRqst, "id-PUSCH-ModifyInformation-LCR-PSCH-ReconfRqst" },
  { id_PUSCH_ModifyInformation_LCR_ModifyListIE_PSCH_ReconfRqst, "id-PUSCH-ModifyInformation-LCR-ModifyListIE-PSCH-ReconfRqst" },
  { id_CellAdjustmentInfoItem_SyncAdjustmentRqstTDD, "id-CellAdjustmentInfoItem-SyncAdjustmentRqstTDD" },
  { id_TimeSlot, "id-TimeSlot" },
  { id_timeslotInfo_CellSyncInitiationRqstTDD, "id-timeslotInfo-CellSyncInitiationRqstTDD" },
  { id_SyncReportType_CellSyncReprtTDD, "id-SyncReportType-CellSyncReprtTDD" },
  { id_Power_Local_Cell_Group_InformationItem_AuditRsp, "id-Power-Local-Cell-Group-InformationItem-AuditRsp" },
  { id_Power_Local_Cell_Group_InformationItem_ResourceStatusInd, "id-Power-Local-Cell-Group-InformationItem-ResourceStatusInd" },
  { id_Power_Local_Cell_Group_InformationItem2_ResourceStatusInd, "id-Power-Local-Cell-Group-InformationItem2-ResourceStatusInd" },
  { id_Power_Local_Cell_Group_InformationList_AuditRsp, "id-Power-Local-Cell-Group-InformationList-AuditRsp" },
  { id_Power_Local_Cell_Group_InformationList_ResourceStatusInd, "id-Power-Local-Cell-Group-InformationList-ResourceStatusInd" },
  { id_Power_Local_Cell_Group_InformationList2_ResourceStatusInd, "id-Power-Local-Cell-Group-InformationList2-ResourceStatusInd" },
  { id_Power_Local_Cell_Group_ID, "id-Power-Local-Cell-Group-ID" },
  { id_PUSCH_Info_DM_Rqst, "id-PUSCH-Info-DM-Rqst" },
  { id_PUSCH_Info_DM_Rsp, "id-PUSCH-Info-DM-Rsp" },
  { id_PUSCH_Info_DM_Rprt, "id-PUSCH-Info-DM-Rprt" },
  { id_TypeOfError, "id-TypeOfError" },
  { id_InitDL_Power, "id-InitDL-Power" },
  { id_UL_SIRTarget, "id-UL-SIRTarget" },
  { id_cellSyncBurstRepetitionPeriod, "id-cellSyncBurstRepetitionPeriod" },
  { id_ReportCharacteristicsType_OnModification, "id-ReportCharacteristicsType-OnModification" },
  { id_SFNSFNMeasurementValueInformation, "id-SFNSFNMeasurementValueInformation" },
  { id_SFNSFNMeasurementThresholdInformation, "id-SFNSFNMeasurementThresholdInformation" },
  { id_TUTRANGPSMeasurementValueInformation, "id-TUTRANGPSMeasurementValueInformation" },
  { id_TUTRANGPSMeasurementThresholdInformation, "id-TUTRANGPSMeasurementThresholdInformation" },
  { id_CCTrCH_Initial_DL_Power_RL_SetupRqstTDD, "id-CCTrCH-Initial-DL-Power-RL-SetupRqstTDD" },
  { id_CCTrCH_Initial_DL_Power_RL_AdditionRqstTDD, "id-CCTrCH-Initial-DL-Power-RL-AdditionRqstTDD" },
  { id_CCTrCH_Initial_DL_Power_RL_ReconfPrepTDD, "id-CCTrCH-Initial-DL-Power-RL-ReconfPrepTDD" },
  { id_Rx_Timing_Deviation_Value_LCR, "id-Rx-Timing-Deviation-Value-LCR" },
  { id_Angle_Of_Arrival_Value_LCR, "id-Angle-Of-Arrival-Value-LCR" },
  { id_HS_PDSCH_HS_SCCH_E_AGCH_E_RGCH_E_HICH_MaxPower_PSCH_ReconfRqst, "id-HS-PDSCH-HS-SCCH-E-AGCH-E-RGCH-E-HICH-MaxPower-PSCH-ReconfRqst" },
  { id_HS_PDSCH_HS_SCCH_ScramblingCode_PSCH_ReconfRqst, "id-HS-PDSCH-HS-SCCH-ScramblingCode-PSCH-ReconfRqst" },
  { id_HS_PDSCH_FDD_Code_Information_PSCH_ReconfRqst, "id-HS-PDSCH-FDD-Code-Information-PSCH-ReconfRqst" },
  { id_HS_SCCH_FDD_Code_Information_PSCH_ReconfRqst, "id-HS-SCCH-FDD-Code-Information-PSCH-ReconfRqst" },
  { id_HS_PDSCH_TDD_Information_PSCH_ReconfRqst, "id-HS-PDSCH-TDD-Information-PSCH-ReconfRqst" },
  { id_Add_To_HS_SCCH_Resource_Pool_PSCH_ReconfRqst, "id-Add-To-HS-SCCH-Resource-Pool-PSCH-ReconfRqst" },
  { id_Modify_HS_SCCH_Resource_Pool_PSCH_ReconfRqst, "id-Modify-HS-SCCH-Resource-Pool-PSCH-ReconfRqst" },
  { id_Delete_From_HS_SCCH_Resource_Pool_PSCH_ReconfRqst, "id-Delete-From-HS-SCCH-Resource-Pool-PSCH-ReconfRqst" },
  { id_HSDSCH_FDD_Information, "id-HSDSCH-FDD-Information" },
  { id_HSDSCH_FDD_Information_Response, "id-HSDSCH-FDD-Information-Response" },
  { id_Unknown_532, "id-Unknown-532" },
  { id_Unknown_533, "id-Unknown-533" },
  { id_HSDSCH_Information_to_Modify, "id-HSDSCH-Information-to-Modify" },
  { id_HSDSCH_RNTI, "id-HSDSCH-RNTI" },
  { id_HSDSCH_TDD_Information, "id-HSDSCH-TDD-Information" },
  { id_HSDSCH_TDD_Information_Response, "id-HSDSCH-TDD-Information-Response" },
  { id_Unknown_538, "id-Unknown-538" },
  { id_Unknown_539, "id-Unknown-539" },
  { id_Unknown_540, "id-Unknown-540" },
  { id_HSPDSCH_RL_ID, "id-HSPDSCH-RL-ID" },
  { id_PrimCCPCH_RSCP_DL_PC_RqstTDD, "id-PrimCCPCH-RSCP-DL-PC-RqstTDD" },
  { id_SYNCDlCodeId_TransInitLCR_CellSyncInitiationRqstTDD, "id-SYNCDlCodeId-TransInitLCR-CellSyncInitiationRqstTDD" },
  { id_SYNCDlCodeId_MeasureInitLCR_CellSyncInitiationRqstTDD, "id-SYNCDlCodeId-MeasureInitLCR-CellSyncInitiationRqstTDD" },
  { id_SYNCDlCodeIdTransReconfInfoLCR_CellSyncReconfRqstTDD, "id-SYNCDlCodeIdTransReconfInfoLCR-CellSyncReconfRqstTDD" },
  { id_SYNCDlCodeIdMeasReconfigurationLCR_CellSyncReconfRqstTDD, "id-SYNCDlCodeIdMeasReconfigurationLCR-CellSyncReconfRqstTDD" },
  { id_SYNCDlCodeIdMeasInfoList_CellSyncReconfRqstTDD, "id-SYNCDlCodeIdMeasInfoList-CellSyncReconfRqstTDD" },
  { id_SyncDLCodeIdsMeasInfoList_CellSyncReprtTDD, "id-SyncDLCodeIdsMeasInfoList-CellSyncReprtTDD" },
  { id_SyncDLCodeIdThreInfoLCR, "id-SyncDLCodeIdThreInfoLCR" },
  { id_NSubCyclesPerCyclePeriod_CellSyncReconfRqstTDD, "id-NSubCyclesPerCyclePeriod-CellSyncReconfRqstTDD" },
  { id_DwPCH_Power, "id-DwPCH-Power" },
  { id_AccumulatedClockupdate_CellSyncReprtTDD, "id-AccumulatedClockupdate-CellSyncReprtTDD" },
  { id_HSDSCH_RearrangeList_Bearer_RearrangeInd, "id-HSDSCH-RearrangeList-Bearer-RearrangeInd" },
  { id_UL_Synchronisation_Parameters_LCR, "id-UL-Synchronisation-Parameters-LCR" },
  { id_HSDSCH_FDD_Update_Information, "id-HSDSCH-FDD-Update-Information" },
  { id_HSDSCH_TDD_Update_Information, "id-HSDSCH-TDD-Update-Information" },
  { id_Unknown_557, "id-Unknown-557" },
  { id_DL_DPCH_TimeSlotFormat_LCR_ModifyItem_RL_ReconfPrepTDD, "id-DL-DPCH-TimeSlotFormat-LCR-ModifyItem-RL-ReconfPrepTDD" },
  { id_UL_DPCH_TimeSlotFormat_LCR_ModifyItem_RL_ReconfPrepTDD, "id-UL-DPCH-TimeSlotFormat-LCR-ModifyItem-RL-ReconfPrepTDD" },
  { id_TDD_TPC_UplinkStepSize_LCR_RL_SetupRqstTDD, "id-TDD-TPC-UplinkStepSize-LCR-RL-SetupRqstTDD" },
  { id_TDD_TPC_UplinkStepSize_LCR_RL_AdditionRqstTDD, "id-TDD-TPC-UplinkStepSize-LCR-RL-AdditionRqstTDD" },
  { id_TDD_TPC_DownlinkStepSize_RL_AdditionRqstTDD, "id-TDD-TPC-DownlinkStepSize-RL-AdditionRqstTDD" },
  { id_TDD_TPC_UplinkStepSize_InformationAdd_LCR_RL_ReconfPrepTDD, "id-TDD-TPC-UplinkStepSize-InformationAdd-LCR-RL-ReconfPrepTDD" },
  { id_TDD_TPC_UplinkStepSize_InformationModify_LCR_RL_ReconfPrepTDD, "id-TDD-TPC-UplinkStepSize-InformationModify-LCR-RL-ReconfPrepTDD" },
  { id_TDD_TPC_DownlinkStepSize_InformationModify_RL_ReconfPrepTDD, "id-TDD-TPC-DownlinkStepSize-InformationModify-RL-ReconfPrepTDD" },
  { id_TDD_TPC_DownlinkStepSize_InformationAdd_RL_ReconfPrepTDD, "id-TDD-TPC-DownlinkStepSize-InformationAdd-RL-ReconfPrepTDD" },
  { id_CCTrCH_Maximum_DL_Power_RL_SetupRqstTDD, "id-CCTrCH-Maximum-DL-Power-RL-SetupRqstTDD" },
  { id_CCTrCH_Minimum_DL_Power_RL_SetupRqstTDD, "id-CCTrCH-Minimum-DL-Power-RL-SetupRqstTDD" },
  { id_CCTrCH_Maximum_DL_Power_RL_AdditionRqstTDD, "id-CCTrCH-Maximum-DL-Power-RL-AdditionRqstTDD" },
  { id_CCTrCH_Minimum_DL_Power_RL_AdditionRqstTDD, "id-CCTrCH-Minimum-DL-Power-RL-AdditionRqstTDD" },
  { id_CCTrCH_Maximum_DL_Power_InformationAdd_RL_ReconfPrepTDD, "id-CCTrCH-Maximum-DL-Power-InformationAdd-RL-ReconfPrepTDD" },
  { id_CCTrCH_Minimum_DL_Power_InformationAdd_RL_ReconfPrepTDD, "id-CCTrCH-Minimum-DL-Power-InformationAdd-RL-ReconfPrepTDD" },
  { id_CCTrCH_Maximum_DL_Power_InformationModify_RL_ReconfPrepTDD, "id-CCTrCH-Maximum-DL-Power-InformationModify-RL-ReconfPrepTDD" },
  { id_CCTrCH_Minimum_DL_Power_InformationModify_RL_ReconfPrepTDD, "id-CCTrCH-Minimum-DL-Power-InformationModify-RL-ReconfPrepTDD" },
  { id_Maximum_DL_Power_Modify_LCR_InformationModify_RL_ReconfPrepTDD, "id-Maximum-DL-Power-Modify-LCR-InformationModify-RL-ReconfPrepTDD" },
  { id_Minimum_DL_Power_Modify_LCR_InformationModify_RL_ReconfPrepTDD, "id-Minimum-DL-Power-Modify-LCR-InformationModify-RL-ReconfPrepTDD" },
  { id_DL_DPCH_LCR_InformationModify_ModifyList_RL_ReconfRqstTDD, "id-DL-DPCH-LCR-InformationModify-ModifyList-RL-ReconfRqstTDD" },
  { id_CCTrCH_Maximum_DL_Power_InformationModify_RL_ReconfRqstTDD, "id-CCTrCH-Maximum-DL-Power-InformationModify-RL-ReconfRqstTDD" },
  { id_CCTrCH_Minimum_DL_Power_InformationModify_RL_ReconfRqstTDD, "id-CCTrCH-Minimum-DL-Power-InformationModify-RL-ReconfRqstTDD" },
  { id_Initial_DL_Power_TimeslotLCR_InformationItem, "id-Initial-DL-Power-TimeslotLCR-InformationItem" },
  { id_Maximum_DL_Power_TimeslotLCR_InformationItem, "id-Maximum-DL-Power-TimeslotLCR-InformationItem" },
  { id_Minimum_DL_Power_TimeslotLCR_InformationItem, "id-Minimum-DL-Power-TimeslotLCR-InformationItem" },
  { id_HS_DSCHProvidedBitRateValueInformation, "id-HS-DSCHProvidedBitRateValueInformation" },
  { id_Unknown_584, "id-Unknown-584" },
  { id_HS_DSCHRequiredPowerValueInformation, "id-HS-DSCHRequiredPowerValueInformation" },
  { id_HS_DSCHRequiredPowerValue, "id-HS-DSCHRequiredPowerValue" },
  { id_TransmittedCarrierPowerOfAllCodesNotUsedForHSTransmission, "id-TransmittedCarrierPowerOfAllCodesNotUsedForHSTransmission" },
  { id_HS_SICH_Reception_Quality, "id-HS-SICH-Reception-Quality" },
  { id_HS_SICH_Reception_Quality_Measurement_Value, "id-HS-SICH-Reception-Quality-Measurement-Value" },
  { id_HSSICH_Info_DM_Rprt, "id-HSSICH-Info-DM-Rprt" },
  { id_HSSICH_Info_DM_Rqst, "id-HSSICH-Info-DM-Rqst" },
  { id_HSSICH_Info_DM_Rsp, "id-HSSICH-Info-DM-Rsp" },
  { id_Best_Cell_Portions_Value, "id-Best-Cell-Portions-Value" },
  { id_Primary_CPICH_Usage_for_Channel_Estimation, "id-Primary-CPICH-Usage-for-Channel-Estimation" },
  { id_Secondary_CPICH_Information_Change, "id-Secondary-CPICH-Information-Change" },
  { id_NumberOfReportedCellPortions, "id-NumberOfReportedCellPortions" },
  { id_CellPortion_InformationItem_Cell_SetupRqstFDD, "id-CellPortion-InformationItem-Cell-SetupRqstFDD" },
  { id_CellPortion_InformationList_Cell_SetupRqstFDD, "id-CellPortion-InformationList-Cell-SetupRqstFDD" },
  { id_TimeslotISCP_LCR_InfoList_RL_ReconfPrepTDD, "id-TimeslotISCP-LCR-InfoList-RL-ReconfPrepTDD" },
  { id_Secondary_CPICH_Information, "id-Secondary-CPICH-Information" },
  { id_Received_total_wide_band_power_For_CellPortion, "id-Received-total-wide-band-power-For-CellPortion" },
  { id_Unidirectional_DCH_Indicator, "id-Unidirectional-DCH-Indicator" },
  { id_TimingAdjustmentValueLCR, "id-TimingAdjustmentValueLCR" },
  { id_multipleRL_dl_DPCH_InformationList, "id-multipleRL-dl-DPCH-InformationList" },
  { id_multipleRL_dl_DPCH_InformationModifyList, "id-multipleRL-dl-DPCH-InformationModifyList" },
  { id_multipleRL_ul_DPCH_InformationList, "id-multipleRL-ul-DPCH-InformationList" },
  { id_multipleRL_ul_DPCH_InformationModifyList, "id-multipleRL-ul-DPCH-InformationModifyList" },
  { id_RL_ID, "id-RL-ID" },
  { id_SAT_Info_Almanac_ExtItem, "id-SAT-Info-Almanac-ExtItem" },
  { id_HSDPA_Capability, "id-HSDPA-Capability" },
  { id_HSDSCH_Resources_Information_AuditRsp, "id-HSDSCH-Resources-Information-AuditRsp" },
  { id_HSDSCH_Resources_Information_ResourceStatusInd, "id-HSDSCH-Resources-Information-ResourceStatusInd" },
  { id_HSDSCH_MACdFlows_to_Add, "id-HSDSCH-MACdFlows-to-Add" },
  { id_HSDSCH_MACdFlows_to_Delete, "id-HSDSCH-MACdFlows-to-Delete" },
  { id_HSDSCH_Information_to_Modify_Unsynchronised, "id-HSDSCH-Information-to-Modify-Unsynchronised" },
  { id_TnlQos, "id-TnlQos" },
  { id_Received_total_wide_band_power_For_CellPortion_Value, "id-Received-total-wide-band-power-For-CellPortion-Value" },
  { id_Transmitted_Carrier_Power_For_CellPortion, "id-Transmitted-Carrier-Power-For-CellPortion" },
  { id_Transmitted_Carrier_Power_For_CellPortion_Value, "id-Transmitted-Carrier-Power-For-CellPortion-Value" },
  { id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortion, "id-TransmittedCarrierPowerOfAllCodesNotUsedForHS-PDSCH-HS-SCCH-E-AGCH-E-RGCHOrE-HICHTransmissionCellPortion" },
  { id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCH_E_RGCHOrE_HICHTransmissionCellPortionValue, "id-TransmittedCarrierPowerOfAllCodesNotUsedForHS-PDSCH-HS-SCCH-E-AGCH-E-RGCHOrE-HICHTransmissionCellPortionValue" },
  { id_UpPTSInterferenceValue, "id-UpPTSInterferenceValue" },
  { id_PrimaryCCPCH_RSCP_Delta, "id-PrimaryCCPCH-RSCP-Delta" },
  { id_MeasurementRecoveryBehavior, "id-MeasurementRecoveryBehavior" },
  { id_MeasurementRecoveryReportingIndicator, "id-MeasurementRecoveryReportingIndicator" },
  { id_MeasurementRecoverySupportIndicator, "id-MeasurementRecoverySupportIndicator" },
  { id_Tstd_indicator, "id-Tstd-indicator" },
  { id_multiple_RL_Information_RL_ReconfPrepTDD, "id-multiple-RL-Information-RL-ReconfPrepTDD" },
  { id_multiple_RL_Information_RL_ReconfRqstTDD, "id-multiple-RL-Information-RL-ReconfRqstTDD" },
  { id_DL_DPCH_Power_Information_RL_ReconfPrepFDD, "id-DL-DPCH-Power-Information-RL-ReconfPrepFDD" },
  { id_F_DPCH_Information_RL_ReconfPrepFDD, "id-F-DPCH-Information-RL-ReconfPrepFDD" },
  { id_F_DPCH_Information_RL_SetupRqstFDD, "id-F-DPCH-Information-RL-SetupRqstFDD" },
  { id_Additional_S_CCPCH_Parameters_CTCH_ReconfRqstTDD, "id-Additional-S-CCPCH-Parameters-CTCH-ReconfRqstTDD" },
  { id_Additional_S_CCPCH_Parameters_CTCH_SetupRqstTDD, "id-Additional-S-CCPCH-Parameters-CTCH-SetupRqstTDD" },
  { id_Additional_S_CCPCH_LCR_Parameters_CTCH_ReconfRqstTDD, "id-Additional-S-CCPCH-LCR-Parameters-CTCH-ReconfRqstTDD" },
  { id_Additional_S_CCPCH_LCR_Parameters_CTCH_SetupRqstTDD, "id-Additional-S-CCPCH-LCR-Parameters-CTCH-SetupRqstTDD" },
  { id_MICH_CFN, "id-MICH-CFN" },
  { id_MICH_Information_AuditRsp, "id-MICH-Information-AuditRsp" },
  { id_MICH_Information_ResourceStatusInd, "id-MICH-Information-ResourceStatusInd" },
  { id_MICH_Parameters_CTCH_ReconfRqstFDD, "id-MICH-Parameters-CTCH-ReconfRqstFDD" },
  { id_MICH_Parameters_CTCH_ReconfRqstTDD, "id-MICH-Parameters-CTCH-ReconfRqstTDD" },
  { id_MICH_Parameters_CTCH_SetupRqstFDD, "id-MICH-Parameters-CTCH-SetupRqstFDD" },
  { id_MICH_Parameters_CTCH_SetupRqstTDD, "id-MICH-Parameters-CTCH-SetupRqstTDD" },
  { id_Modification_Period, "id-Modification-Period" },
  { id_NI_Information_NotifUpdateCmd, "id-NI-Information-NotifUpdateCmd" },
  { id_S_CCPCH_InformationListExt_AuditRsp, "id-S-CCPCH-InformationListExt-AuditRsp" },
  { id_S_CCPCH_InformationListExt_ResourceStatusInd, "id-S-CCPCH-InformationListExt-ResourceStatusInd" },
  { id_S_CCPCH_LCR_InformationListExt_AuditRsp, "id-S-CCPCH-LCR-InformationListExt-AuditRsp" },
  { id_S_CCPCH_LCR_InformationListExt_ResourceStatusInd, "id-S-CCPCH-LCR-InformationListExt-ResourceStatusInd" },
  { id_HARQ_Preamble_Mode, "id-HARQ-Preamble-Mode" },
  { id_Initial_DL_DPCH_TimingAdjustment, "id-Initial-DL-DPCH-TimingAdjustment" },
  { id_Initial_DL_DPCH_TimingAdjustment_Allowed, "id-Initial-DL-DPCH-TimingAdjustment-Allowed" },
  { id_DLTransmissionBranchLoadValue, "id-DLTransmissionBranchLoadValue" },
  { id_Power_Local_Cell_Group_choice_CM_Rqst, "id-Power-Local-Cell-Group-choice-CM-Rqst" },
  { id_Power_Local_Cell_Group_choice_CM_Rsp, "id-Power-Local-Cell-Group-choice-CM-Rsp" },
  { id_Power_Local_Cell_Group_choice_CM_Rprt, "id-Power-Local-Cell-Group-choice-CM-Rprt" },
  { id_SynchronisationIndicator, "id-SynchronisationIndicator" },
  { id_HSDPA_And_EDCH_CellPortion_Information_PSCH_ReconfRqst, "id-HSDPA-And-EDCH-CellPortion-Information-PSCH-ReconfRqst" },
  { id_Unused_ProtocolIE_ID_659, "id-Unused-ProtocolIE-ID-659" },
  { id_HS_DSCHRequiredPowerValue_For_Cell_Portion, "id-HS-DSCHRequiredPowerValue-For-Cell-Portion" },
  { id_HS_DSCHRequiredPowerValueInformation_For_CellPortion, "id-HS-DSCHRequiredPowerValueInformation-For-CellPortion" },
  { id_HS_DSCHProvidedBitRateValueInformation_For_CellPortion, "id-HS-DSCHProvidedBitRateValueInformation-For-CellPortion" },
  { id_E_AGCH_And_E_RGCH_E_HICH_FDD_Scrambling_Code, "id-E-AGCH-And-E-RGCH-E-HICH-FDD-Scrambling-Code" },
  { id_E_AGCH_FDD_Code_Information, "id-E-AGCH-FDD-Code-Information" },
  { id_E_DCH_Capability, "id-E-DCH-Capability" },
  { id_E_DCH_FDD_DL_Control_Channel_Information, "id-E-DCH-FDD-DL-Control-Channel-Information" },
  { id_E_DCH_FDD_Information, "id-E-DCH-FDD-Information" },
  { id_E_DCH_FDD_Information_Response, "id-E-DCH-FDD-Information-Response" },
  { id_E_DCH_FDD_Information_to_Modify, "id-E-DCH-FDD-Information-to-Modify" },
  { id_E_DCH_MACdFlows_to_Add, "id-E-DCH-MACdFlows-to-Add" },
  { id_E_DCH_MACdFlows_to_Delete, "id-E-DCH-MACdFlows-to-Delete" },
  { id_E_DCH_Resources_Information_AuditRsp, "id-E-DCH-Resources-Information-AuditRsp" },
  { id_E_DCH_Resources_Information_ResourceStatusInd, "id-E-DCH-Resources-Information-ResourceStatusInd" },
  { id_E_DCH_RL_Indication, "id-E-DCH-RL-Indication" },
  { id_E_DCH_RL_Set_ID, "id-E-DCH-RL-Set-ID" },
  { id_E_DPCH_Information_RL_ReconfPrepFDD, "id-E-DPCH-Information-RL-ReconfPrepFDD" },
  { id_E_DPCH_Information_RL_SetupRqstFDD, "id-E-DPCH-Information-RL-SetupRqstFDD" },
  { id_E_RGCH_E_HICH_FDD_Code_Information, "id-E-RGCH-E-HICH-FDD-Code-Information" },
  { id_Serving_E_DCH_RL_ID, "id-Serving-E-DCH-RL-ID" },
  { id_UL_DPDCH_Indicator_For_E_DCH_Operation, "id-UL-DPDCH-Indicator-For-E-DCH-Operation" },
  { id_FDD_S_CCPCH_FrameOffset_CTCH_SetupRqstFDD, "id-FDD-S-CCPCH-FrameOffset-CTCH-SetupRqstFDD" },
  { id_E_DPCH_Information_RL_ReconfRqstFDD, "id-E-DPCH-Information-RL-ReconfRqstFDD" },
  { id_Maximum_Target_ReceivedTotalWideBandPower, "id-Maximum-Target-ReceivedTotalWideBandPower" },
  { id_E_DCHProvidedBitRateValueInformation, "id-E-DCHProvidedBitRateValueInformation" },
  { id_HARQ_Preamble_Mode_Activation_Indicator, "id-HARQ-Preamble-Mode-Activation-Indicator" },
  { id_RL_Specific_E_DCH_Info, "id-RL-Specific-E-DCH-Info" },
  { id_E_DCH_CapacityConsumptionLaw, "id-E-DCH-CapacityConsumptionLaw" },
  { id_multiple_DedicatedMeasurementValueList_TDD_DM_Rsp, "id-multiple-DedicatedMeasurementValueList-TDD-DM-Rsp" },
  { id_multiple_DedicatedMeasurementValueList_LCR_TDD_DM_Rsp, "id-multiple-DedicatedMeasurementValueList-LCR-TDD-DM-Rsp" },
  { id_E_DCH_RearrangeList_Bearer_RearrangeInd, "id-E-DCH-RearrangeList-Bearer-RearrangeInd" },
  { id_Unused_ProtocolIE_ID_691, "id-Unused-ProtocolIE-ID-691" },
  { id_multipleRL_dl_CCTrCH_InformationModifyList_RL_ReconfRqstTDD, "id-multipleRL-dl-CCTrCH-InformationModifyList-RL-ReconfRqstTDD" },
  { id_Target_NonServing_EDCH_To_Total_EDCH_Power_Ratio, "id-Target-NonServing-EDCH-To-Total-EDCH-Power-Ratio" },
  { id_CellPortion_InformationItem_Cell_ReconfRqstFDD, "id-CellPortion-InformationItem-Cell-ReconfRqstFDD" },
  { id_CellPortion_InformationList_Cell_ReconfRqstFDD, "id-CellPortion-InformationList-Cell-ReconfRqstFDD" },
  { id_multiple_PUSCH_InfoList_DM_Rsp, "id-multiple-PUSCH-InfoList-DM-Rsp" },
  { id_multiple_PUSCH_InfoList_DM_Rprt, "id-multiple-PUSCH-InfoList-DM-Rprt" },
  { id_Reference_ReceivedTotalWideBandPower, "id-Reference-ReceivedTotalWideBandPower" },
  { id_E_DCH_Serving_Cell_Change_Info_Response, "id-E-DCH-Serving-Cell-Change-Info-Response" },
  { id_HS_DSCH_Serving_Cell_Change_Info, "id-HS-DSCH-Serving-Cell-Change-Info" },
  { id_HS_DSCH_Serving_Cell_Change_Info_Response, "id-HS-DSCH-Serving-Cell-Change-Info-Response" },
  { id_Serving_Cell_Change_CFN, "id-Serving-Cell-Change-CFN" },
  { id_E_DCH_HARQ_Combining_Capability, "id-E-DCH-HARQ-Combining-Capability" },
  { id_E_DCH_TTI2ms_Capability, "id-E-DCH-TTI2ms-Capability" },
  { id_E_DCH_SF_Capability, "id-E-DCH-SF-Capability" },
  { id_E_DCH_FDD_Update_Information, "id-E-DCH-FDD-Update-Information" },
  { id_F_DPCH_Capability, "id-F-DPCH-Capability" },
  { id_E_DCH_Non_serving_Relative_Grant_Down_CommandsValue, "id-E-DCH-Non-serving-Relative-Grant-Down-CommandsValue" },
  { id_HSSICH_SIRTarget, "id-HSSICH-SIRTarget" },
  { id_multiple_HSSICHMeasurementValueList_TDD_DM_Rsp, "id-multiple-HSSICHMeasurementValueList-TDD-DM-Rsp" },
  { id_PLCCH_Information_AuditRsp, "id-PLCCH-Information-AuditRsp" },
  { id_PLCCH_Information_ResourceStatusInd, "id-PLCCH-Information-ResourceStatusInd" },
  { id_PLCCH_Information_RL_ReconfPrepTDDLCR, "id-PLCCH-Information-RL-ReconfPrepTDDLCR" },
  { id_PLCCH_Information_UL_TimeslotLCR_Info, "id-PLCCH-Information-UL-TimeslotLCR-Info" },
  { id_PLCCH_InformationList_AuditRsp, "id-PLCCH-InformationList-AuditRsp" },
  { id_PLCCH_InformationList_ResourceStatusInd, "id-PLCCH-InformationList-ResourceStatusInd" },
  { id_PLCCH_Parameters_CTCH_ReconfRqstTDD, "id-PLCCH-Parameters-CTCH-ReconfRqstTDD" },
  { id_S_CCPCH_768_Parameters_CTCH_SetupRqstTDD, "id-S-CCPCH-768-Parameters-CTCH-SetupRqstTDD" },
  { id_PICH_768_Parameters_CTCH_SetupRqstTDD, "id-PICH-768-Parameters-CTCH-SetupRqstTDD" },
  { id_PRACH_768_Parameters_CTCH_SetupRqstTDD, "id-PRACH-768-Parameters-CTCH-SetupRqstTDD" },
  { id_S_CCPCH_768_Parameters_CTCH_ReconfRqstTDD, "id-S-CCPCH-768-Parameters-CTCH-ReconfRqstTDD" },
  { id_PICH_768_Parameters_CTCH_ReconfRqstTDD, "id-PICH-768-Parameters-CTCH-ReconfRqstTDD" },
  { id_MICH_768_Parameters_CTCH_ReconfRqstTDD, "id-MICH-768-Parameters-CTCH-ReconfRqstTDD" },
  { id_CommonPhysicalChannelID768_CommonTrChDeletionReq, "id-CommonPhysicalChannelID768-CommonTrChDeletionReq" },
  { id_S_CCPCH_768_InformationList_AuditRsp, "id-S-CCPCH-768-InformationList-AuditRsp" },
  { id_S_CCPCH_768_Information_AuditRsp, "id-S-CCPCH-768-Information-AuditRsp" },
  { id_neighbouringTDDCellMeasurementInformation768, "id-neighbouringTDDCellMeasurementInformation768" },
  { id_PCCPCH_768_Information_Cell_SetupRqstTDD, "id-PCCPCH-768-Information-Cell-SetupRqstTDD" },
  { id_SCH_768_Information_Cell_SetupRqstTDD, "id-SCH-768-Information-Cell-SetupRqstTDD" },
  { id_SCH_768_Information_Cell_ReconfRqstTDD, "id-SCH-768-Information-Cell-ReconfRqstTDD" },
  { id_PCCPCH_768_Information_Cell_ReconfRqstTDD, "id-PCCPCH-768-Information-Cell-ReconfRqstTDD" },
  { id_P_CCPCH_768_Information_AuditRsp, "id-P-CCPCH-768-Information-AuditRsp" },
  { id_PICH_768_Information_AuditRsp, "id-PICH-768-Information-AuditRsp" },
  { id_PRACH_768_InformationList_AuditRsp, "id-PRACH-768-InformationList-AuditRsp" },
  { id_SCH_768_Information_AuditRsp, "id-SCH-768-Information-AuditRsp" },
  { id_MICH_768_Information_AuditRsp, "id-MICH-768-Information-AuditRsp" },
  { id_PRACH_768_Information, "id-PRACH-768-Information" },
  { id_S_CCPCH_768_Information_ResourceStatusInd, "id-S-CCPCH-768-Information-ResourceStatusInd" },
  { id_P_CCPCH_768_Information_ResourceStatusInd, "id-P-CCPCH-768-Information-ResourceStatusInd" },
  { id_PICH_768_Information_ResourceStatusInd, "id-PICH-768-Information-ResourceStatusInd" },
  { id_PRACH_768_InformationList_ResourceStatusInd, "id-PRACH-768-InformationList-ResourceStatusInd" },
  { id_SCH_768_Information_ResourceStatusInd, "id-SCH-768-Information-ResourceStatusInd" },
  { id_MICH_768_Information_ResourceStatusInd, "id-MICH-768-Information-ResourceStatusInd" },
  { id_S_CCPCH_768_InformationList_ResourceStatusInd, "id-S-CCPCH-768-InformationList-ResourceStatusInd" },
  { id_UL_DPCH_768_Information_RL_SetupRqstTDD, "id-UL-DPCH-768-Information-RL-SetupRqstTDD" },
  { id_DL_DPCH_768_Information_RL_SetupRqstTDD, "id-DL-DPCH-768-Information-RL-SetupRqstTDD" },
  { id_DL_DPCH_InformationItem_768_RL_AdditionRqstTDD, "id-DL-DPCH-InformationItem-768-RL-AdditionRqstTDD" },
  { id_UL_DPCH_InformationItem_768_RL_AdditionRqstTDD, "id-UL-DPCH-InformationItem-768-RL-AdditionRqstTDD" },
  { id_UL_DPCH_768_InformationAddItemIE_RL_ReconfPrepTDD, "id-UL-DPCH-768-InformationAddItemIE-RL-ReconfPrepTDD" },
  { id_UL_DPCH_768_InformationAddListIE_RL_ReconfPrepTDD, "id-UL-DPCH-768-InformationAddListIE-RL-ReconfPrepTDD" },
  { id_UL_DPCH_768_InformationModify_AddItem, "id-UL-DPCH-768-InformationModify-AddItem" },
  { id_UL_DPCH_768_InformationModify_AddList, "id-UL-DPCH-768-InformationModify-AddList" },
  { id_UL_Timeslot768_Information_RL_ReconfPrepTDD, "id-UL-Timeslot768-Information-RL-ReconfPrepTDD" },
  { id_DL_DPCH_768_InformationAddItem_RL_ReconfPrepTDD, "id-DL-DPCH-768-InformationAddItem-RL-ReconfPrepTDD" },
  { id_DL_DPCH_768_InformationAddList_RL_ReconfPrepTDD, "id-DL-DPCH-768-InformationAddList-RL-ReconfPrepTDD" },
  { id_DL_DPCH_768_InformationModify_AddItem_RL_ReconfPrepTDD, "id-DL-DPCH-768-InformationModify-AddItem-RL-ReconfPrepTDD" },
  { id_DL_DPCH_768_InformationModify_AddList_RL_ReconfPrepTDD, "id-DL-DPCH-768-InformationModify-AddList-RL-ReconfPrepTDD" },
  { id_DL_Timeslot_768_InformationModify_ModifyList_RL_ReconfPrepTDD, "id-DL-Timeslot-768-InformationModify-ModifyList-RL-ReconfPrepTDD" },
  { id_DPCH_ID768_DM_Rqst, "id-DPCH-ID768-DM-Rqst" },
  { id_multiple_DedicatedMeasurementValueList_768_TDD_DM_Rsp, "id-multiple-DedicatedMeasurementValueList-768-TDD-DM-Rsp" },
  { id_DPCH_ID768_DM_Rsp, "id-DPCH-ID768-DM-Rsp" },
  { id_Rx_Timing_Deviation_Value_768, "id-Rx-Timing-Deviation-Value-768" },
  { id_DPCH_ID768_DM_Rprt, "id-DPCH-ID768-DM-Rprt" },
  { id_PDSCH_AddInformation_768_PSCH_ReconfRqst, "id-PDSCH-AddInformation-768-PSCH-ReconfRqst" },
  { id_PDSCH_ModifyInformation_768_PSCH_ReconfRqst, "id-PDSCH-ModifyInformation-768-PSCH-ReconfRqst" },
  { id_PUSCH_AddInformation_768_PSCH_ReconfRqst, "id-PUSCH-AddInformation-768-PSCH-ReconfRqst" },
  { id_PUSCH_ModifyInformation_768_PSCH_ReconfRqst, "id-PUSCH-ModifyInformation-768-PSCH-ReconfRqst" },
  { id_dL_HS_PDSCH_Timeslot_Information_768_PSCH_ReconfRqst, "id-dL-HS-PDSCH-Timeslot-Information-768-PSCH-ReconfRqst" },
  { id_hS_SCCH_Information_768_PSCH_ReconfRqst, "id-hS-SCCH-Information-768-PSCH-ReconfRqst" },
  { id_hS_SCCH_InformationModify_768_PSCH_ReconfRqst, "id-hS-SCCH-InformationModify-768-PSCH-ReconfRqst" },
  { id_hsSCCH_Specific_Information_ResponseTDD768, "id-hsSCCH-Specific-Information-ResponseTDD768" },
  { id_E_DPCH_Information_RL_AdditionReqFDD, "id-E-DPCH-Information-RL-AdditionReqFDD" },
  { id_Unknown_773, "id-Unknown-773" },
  { id_Unknown_774, "id-Unknown-774" },
  { id_PDSCH_Timeslot_Format_PSCH_ReconfRqst_LCR, "id-PDSCH-Timeslot-Format-PSCH-ReconfRqst-LCR" },
  { id_Unknown_776, "id-Unknown-776" },
  { id_Unknown_777, "id-Unknown-777" },
  { id_Unknown_778, "id-Unknown-778" },
  { id_Unknown_779, "id-Unknown-779" },
  { id_PUSCH_Timeslot_Format_PSCH_ReconfRqst_LCR, "id-PUSCH-Timeslot-Format-PSCH-ReconfRqst-LCR" },
  { id_Unknown_781, "id-Unknown-781" },
  { id_E_DCH_PowerOffset_for_SchedulingInfo, "id-E-DCH-PowerOffset-for-SchedulingInfo" },
  { id_HSDSCH_Configured_Indicator, "id-HSDSCH-Configured-Indicator" },
  { id_Unknown_784, "id-Unknown-784" },
  { id_Unknown_785, "id-Unknown-785" },
  { id_Rx_Timing_Deviation_Value_384_ext, "id-Rx-Timing-Deviation-Value-384-ext" },
  { id_RTWP_ReportingIndicator, "id-RTWP-ReportingIndicator" },
  { id_RTWP_CellPortion_ReportingIndicator, "id-RTWP-CellPortion-ReportingIndicator" },
  { id_Received_Scheduled_EDCH_Power_Share_Value, "id-Received-Scheduled-EDCH-Power-Share-Value" },
  { id_Received_Scheduled_EDCH_Power_Share_For_CellPortion_Value, "id-Received-Scheduled-EDCH-Power-Share-For-CellPortion-Value" },
  { id_Received_Scheduled_EDCH_Power_Share, "id-Received-Scheduled-EDCH-Power-Share" },
  { id_Received_Scheduled_EDCH_Power_Share_For_CellPortion, "id-Received-Scheduled-EDCH-Power-Share-For-CellPortion" },
  { id_tFCI_Presence, "id-tFCI-Presence" },
  { id_HSSICH_TPC_StepSize, "id-HSSICH-TPC-StepSize" },
  { id_E_RUCCH_InformationList_AuditRsp, "id-E-RUCCH-InformationList-AuditRsp" },
  { id_E_RUCCH_InformationList_ResourceStatusInd, "id-E-RUCCH-InformationList-ResourceStatusInd" },
  { id_E_DCH_TDD_CapacityConsumptionLaw, "id-E-DCH-TDD-CapacityConsumptionLaw" },
  { id_E_RUCCH_Information, "id-E-RUCCH-Information" },
  { id_E_DCH_Information, "id-E-DCH-Information" },
  { id_E_DCH_Information_Response, "id-E-DCH-Information-Response" },
  { id_E_DCH_Information_Reconfig, "id-E-DCH-Information-Reconfig" },
  { id_E_PUCH_Information_PSCH_ReconfRqst, "id-E-PUCH-Information-PSCH-ReconfRqst" },
  { id_Add_To_E_AGCH_Resource_Pool_PSCH_ReconfRqst, "id-Add-To-E-AGCH-Resource-Pool-PSCH-ReconfRqst" },
  { id_Modify_E_AGCH_Resource_Pool_PSCH_ReconfRqst, "id-Modify-E-AGCH-Resource-Pool-PSCH-ReconfRqst" },
  { id_Delete_From_E_AGCH_Resource_Pool_PSCH_ReconfRqst, "id-Delete-From-E-AGCH-Resource-Pool-PSCH-ReconfRqst" },
  { id_E_HICH_Information_PSCH_ReconfRqst, "id-E-HICH-Information-PSCH-ReconfRqst" },
  { id_E_HICH_TimeOffset, "id-E-HICH-TimeOffset" },
  { id_Maximum_Generated_ReceivedTotalWideBandPowerInOtherCells, "id-Maximum-Generated-ReceivedTotalWideBandPowerInOtherCells" },
  { id_E_DCH_Serving_RL_ID, "id-E-DCH-Serving-RL-ID" },
  { id_E_RUCCH_768_InformationList_AuditRsp, "id-E-RUCCH-768-InformationList-AuditRsp" },
  { id_E_RUCCH_768_InformationList_ResourceStatusInd, "id-E-RUCCH-768-InformationList-ResourceStatusInd" },
  { id_E_RUCCH_768_Information, "id-E-RUCCH-768-Information" },
  { id_E_DCH_768_Information, "id-E-DCH-768-Information" },
  { id_E_DCH_768_Information_Reconfig, "id-E-DCH-768-Information-Reconfig" },
  { id_E_PUCH_Information_768_PSCH_ReconfRqst, "id-E-PUCH-Information-768-PSCH-ReconfRqst" },
  { id_Add_To_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst, "id-Add-To-E-AGCH-Resource-Pool-768-PSCH-ReconfRqst" },
  { id_Modify_E_AGCH_Resource_Pool_768_PSCH_ReconfRqst, "id-Modify-E-AGCH-Resource-Pool-768-PSCH-ReconfRqst" },
  { id_E_HICH_Information_768_PSCH_ReconfRqst, "id-E-HICH-Information-768-PSCH-ReconfRqst" },
  { id_ExtendedPropagationDelay, "id-ExtendedPropagationDelay" },
  { id_Extended_Round_Trip_Time_Value, "id-Extended-Round-Trip-Time-Value" },
  { id_AlternativeFormatReportingIndicator, "id-AlternativeFormatReportingIndicator" },
  { id_DCH_Indicator_For_E_DCH_HSDPA_Operation, "id-DCH-Indicator-For-E-DCH-HSDPA-Operation" },
  { id_Reference_ReceivedTotalWideBandPowerReporting, "id-Reference-ReceivedTotalWideBandPowerReporting" },
  { id_Reference_ReceivedTotalWideBandPowerSupportIndicator, "id-Reference-ReceivedTotalWideBandPowerSupportIndicator" },
  { id_ueCapability_Info, "id-ueCapability-Info" },
  { id_MAChs_ResetIndicator, "id-MAChs-ResetIndicator" },
  { id_Fast_Reconfiguration_Mode, "id-Fast-Reconfiguration-Mode" },
  { id_Fast_Reconfiguration_Permission, "id-Fast-Reconfiguration-Permission" },
  { id_BroadcastReference, "id-BroadcastReference" },
  { id_BroadcastCommonTransportBearerIndication, "id-BroadcastCommonTransportBearerIndication" },
  { id_ContinuousPacketConnectivityDTX_DRX_Capability, "id-ContinuousPacketConnectivityDTX-DRX-Capability" },
  { id_ContinuousPacketConnectivityDTX_DRX_Information, "id-ContinuousPacketConnectivityDTX-DRX-Information" },
  { id_ContinuousPacketConnectivityHS_SCCH_less_Capability, "id-ContinuousPacketConnectivityHS-SCCH-less-Capability" },
  { id_ContinuousPacketConnectivityHS_SCCH_less_Information, "id-ContinuousPacketConnectivityHS-SCCH-less-Information" },
  { id_ContinuousPacketConnectivityHS_SCCH_less_Information_Response, "id-ContinuousPacketConnectivityHS-SCCH-less-Information-Response" },
  { id_CPC_Information, "id-CPC-Information" },
  { id_MIMO_Capability, "id-MIMO-Capability" },
  { id_MIMO_PilotConfiguration, "id-MIMO-PilotConfiguration" },
  { id_Unknown_839, "id-Unknown-839" },
  { id_Unknown_840, "id-Unknown-840" },
  { id_MBSFN_Cell_ParameterID_Cell_SetupRqstTDD, "id-MBSFN-Cell-ParameterID-Cell-SetupRqstTDD" },
  { id_MBSFN_Cell_ParameterID_Cell_ReconfRqstTDD, "id-MBSFN-Cell-ParameterID-Cell-ReconfRqstTDD" },
  { id_S_CCPCH_Modulation, "id-S-CCPCH-Modulation" },
  { id_HS_PDSCH_Code_Change_Grant, "id-HS-PDSCH-Code-Change-Grant" },
  { id_HS_PDSCH_Code_Change_Indicator, "id-HS-PDSCH-Code-Change-Indicator" },
  { id_SYNC_UL_Partition_LCR, "id-SYNC-UL-Partition-LCR" },
  { id_E_DCH_LCR_Information, "id-E-DCH-LCR-Information" },
  { id_E_DCH_LCR_Information_Reconfig, "id-E-DCH-LCR-Information-Reconfig" },
  { id_Unknown_849, "id-Unknown-849" },
  { id_Unknown_850, "id-Unknown-850" },
  { id_Unknown_851, "id-Unknown-851" },
  { id_E_PUCH_Information_LCR_PSCH_ReconfRqst, "id-E-PUCH-Information-LCR-PSCH-ReconfRqst" },
  { id_Add_To_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst, "id-Add-To-E-AGCH-Resource-Pool-LCR-PSCH-ReconfRqst" },
  { id_Modify_E_AGCH_Resource_Pool_LCR_PSCH_ReconfRqst, "id-Modify-E-AGCH-Resource-Pool-LCR-PSCH-ReconfRqst" },
  { id_Add_To_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst, "id-Add-To-E-HICH-Resource-Pool-LCR-PSCH-ReconfRqst" },
  { id_Modify_E_HICH_Resource_Pool_LCR_PSCH_ReconfRqst, "id-Modify-E-HICH-Resource-Pool-LCR-PSCH-ReconfRqst" },
  { id_Delete_From_E_HICH_Resource_Pool_PSCH_ReconfRqst, "id-Delete-From-E-HICH-Resource-Pool-PSCH-ReconfRqst" },
  { id_E_HICH_TimeOffsetLCR, "id-E-HICH-TimeOffsetLCR" },
  { id_Unknown_859, "id-Unknown-859" },
  { id_SixtyfourQAM_DL_Capability, "id-SixtyfourQAM-DL-Capability" },
  { id_SixteenQAM_UL_Capability, "id-SixteenQAM-UL-Capability" },
  { id_Unknown_862, "id-Unknown-862" },
  { id_Unknown_863, "id-Unknown-863" },
  { id_HSDSCH_MACdPDU_SizeCapability, "id-HSDSCH-MACdPDU-SizeCapability" },
  { id_HSDSCH_MACdPDUSizeFormat, "id-HSDSCH-MACdPDUSizeFormat" },
  { id_MaximumMACdPDU_SizeExtended, "id-MaximumMACdPDU-SizeExtended" },
  { id_Unknown_867, "id-Unknown-867" },
  { id_Unknown_868, "id-Unknown-868" },
  { id_Unknown_869, "id-Unknown-869" },
  { id_F_DPCH_SlotFormat, "id-F-DPCH-SlotFormat" },
  { id_F_DPCH_SlotFormatCapability, "id-F-DPCH-SlotFormatCapability" },
  { id_LCRTDD_uplink_Physical_Channel_Capability, "id-LCRTDD-uplink-Physical-Channel-Capability" },
  { id_Extended_RNC_ID, "id-Extended-RNC-ID" },
  { id_Max_UE_DTX_Cycle, "id-Max-UE-DTX-Cycle" },
  { id_Unknown_875, "id-Unknown-875" },
  { id_Secondary_CCPCH_SlotFormat_Extended, "id-Secondary-CCPCH-SlotFormat-Extended" },
  { id_Unknown_877, "id-Unknown-877" },
  { id_MBSFN_Only_Mode_Indicator_Cell_SetupRqstTDD_LCR, "id-MBSFN-Only-Mode-Indicator-Cell-SetupRqstTDD-LCR" },
  { id_MBSFN_Only_Mode_Capability, "id-MBSFN-Only-Mode-Capability" },
  { id_Time_Slot_Parameter_ID, "id-Time-Slot-Parameter-ID" },
  { id_Additional_failed_HS_SICH, "id-Additional-failed-HS-SICH" },
  { id_Additional_missed_HS_SICH, "id-Additional-missed-HS-SICH" },
  { id_Additional_total_HS_SICH, "id-Additional-total-HS-SICH" },
  { id_Additional_HS_SICH_Reception_Quality_Measurement_Value, "id-Additional-HS-SICH-Reception-Quality-Measurement-Value" },
  { id_Unknown_885, "id-Unknown-885" },
  { id_Unknown_886, "id-Unknown-886" },
  { id_GANSS_Common_Data, "id-GANSS-Common-Data" },
  { id_GANSS_Information, "id-GANSS-Information" },
  { id_GANSS_Generic_Data, "id-GANSS-Generic-Data" },
  { id_TUTRANGANSSMeasurementThresholdInformation, "id-TUTRANGANSSMeasurementThresholdInformation" },
  { id_TUTRANGANSSMeasurementValueInformation, "id-TUTRANGANSSMeasurementValueInformation" },
  { id_ModulationPO_MBSFN, "id-ModulationPO-MBSFN" },
  { id_Unknown_893, "id-Unknown-893" },
  { id_Unknown_894, "id-Unknown-894" },
  { id_Enhanced_FACH_Capability, "id-Enhanced-FACH-Capability" },
  { id_Enhanced_PCH_Capability, "id-Enhanced-PCH-Capability" },
  { id_HSDSCH_Common_System_InformationFDD, "id-HSDSCH-Common-System-InformationFDD" },
  { id_HSDSCH_Common_System_Information_ResponseFDD, "id-HSDSCH-Common-System-Information-ResponseFDD" },
  { id_HSDSCH_Paging_System_InformationFDD, "id-HSDSCH-Paging-System-InformationFDD" },
  { id_HSDSCH_Paging_System_Information_ResponseFDD, "id-HSDSCH-Paging-System-Information-ResponseFDD" },
  { id_MBMS_Capability, "id-MBMS-Capability" },
  { id_Ext_Reference_E_TFCI_PO, "id-Ext-Reference-E-TFCI-PO" },
  { id_Ext_Max_Bits_MACe_PDU_non_scheduled, "id-Ext-Max-Bits-MACe-PDU-non-scheduled" },
  { id_HARQ_MemoryPartitioningInfoExtForMIMO, "id-HARQ-MemoryPartitioningInfoExtForMIMO" },
  { id_MIMO_ActivationIndicator, "id-MIMO-ActivationIndicator" },
  { id_MIMO_Mode_Indicator, "id-MIMO-Mode-Indicator" },
  { id_MIMO_N_M_Ratio, "id-MIMO-N-M-Ratio" },
  { id_IPMulticastIndication, "id-IPMulticastIndication" },
  { id_IPMulticastDataBearerIndication, "id-IPMulticastDataBearerIndication" },
  { id_TransportBearerNotSetupIndicator, "id-TransportBearerNotSetupIndicator" },
  { id_TransportBearerNotRequestedIndicator, "id-TransportBearerNotRequestedIndicator" },
  { id_TimeSlotConfigurationList_LCR_CTCH_SetupRqstTDD, "id-TimeSlotConfigurationList-LCR-CTCH-SetupRqstTDD" },
  { id_Cell_Frequency_List_Information_LCR_MulFreq_AuditRsp, "id-Cell-Frequency-List-Information-LCR-MulFreq-AuditRsp" },
  { id_Cell_Frequency_List_InformationItem_LCR_MulFreq_AuditRsp, "id-Cell-Frequency-List-InformationItem-LCR-MulFreq-AuditRsp" },
  { id_Cell_Frequency_List_LCR_MulFreq_Cell_SetupRqstTDD, "id-Cell-Frequency-List-LCR-MulFreq-Cell-SetupRqstTDD" },
  { id_UARFCN_Adjustment, "id-UARFCN-Adjustment" },
  { id_Cell_Frequency_List_Information_LCR_MulFreq_ResourceStatusInd, "id-Cell-Frequency-List-Information-LCR-MulFreq-ResourceStatusInd" },
  { id_Cell_Frequency_List_InformationItem_LCR_MulFreq_ResourceStatusInd, "id-Cell-Frequency-List-InformationItem-LCR-MulFreq-ResourceStatusInd" },
  { id_UPPCHPositionLCR, "id-UPPCHPositionLCR" },
  { id_UPPCH_LCR_Parameters_CTCH_ReconfRqstTDD, "id-UPPCH-LCR-Parameters-CTCH-ReconfRqstTDD" },
  { id_UPPCH_LCR_InformationList_AuditRsp, "id-UPPCH-LCR-InformationList-AuditRsp" },
  { id_UPPCH_LCR_InformationItem_AuditRsp, "id-UPPCH-LCR-InformationItem-AuditRsp" },
  { id_UPPCH_LCR_InformationList_ResourceStatusInd, "id-UPPCH-LCR-InformationList-ResourceStatusInd" },
  { id_UPPCH_LCR_InformationItem_ResourceStatusInd, "id-UPPCH-LCR-InformationItem-ResourceStatusInd" },
  { id_multipleFreq_dL_HS_PDSCH_Timeslot_Information_LCR_PSCH_ReconfRqst, "id-multipleFreq-dL-HS-PDSCH-Timeslot-Information-LCR-PSCH-ReconfRqst" },
  { id_number_Of_Supported_Carriers, "id-number-Of-Supported-Carriers" },
  { id_multipleFreq_HSPDSCH_InformationList_ResponseTDDLCR, "id-multipleFreq-HSPDSCH-InformationList-ResponseTDDLCR" },
  { id_Unsuccessful_UARFCNItem_PSCH_ReconfFailureTDD, "id-Unsuccessful-UARFCNItem-PSCH-ReconfFailureTDD" },
  { id_multipleFreq_HS_DSCH_Resources_InformationList_AuditRsp, "id-multipleFreq-HS-DSCH-Resources-InformationList-AuditRsp" },
  { id_multipleFreq_HS_DSCH_Resources_InformationList_ResourceStatusInd, "id-multipleFreq-HS-DSCH-Resources-InformationList-ResourceStatusInd" },
  { id_UARFCNSpecificCauseList, "id-UARFCNSpecificCauseList" },
  { id_tSN_Length, "id-tSN-Length" },
  { id_MultipleFreq_DL_HS_PDSCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst, "id-MultipleFreq-DL-HS-PDSCH-Timeslot-Information-LCRItem-PSCH-ReconfRqst" },
  { id_multicarrier_number, "id-multicarrier-number" },
  { id_Extended_HS_SCCH_ID, "id-Extended-HS-SCCH-ID" },
  { id_Extended_HS_SICH_ID, "id-Extended-HS-SICH-ID" },
  { id_HSSICH_InfoExt_DM_Rqst, "id-HSSICH-InfoExt-DM-Rqst" },
  { id_Delete_From_HS_SCCH_Resource_PoolExt_PSCH_ReconfRqst, "id-Delete-From-HS-SCCH-Resource-PoolExt-PSCH-ReconfRqst" },
  { id_HS_SCCH_InformationExt_LCR_PSCH_ReconfRqst, "id-HS-SCCH-InformationExt-LCR-PSCH-ReconfRqst" },
  { id_HS_SCCH_InformationModifyExt_LCR_PSCH_ReconfRqst, "id-HS-SCCH-InformationModifyExt-LCR-PSCH-ReconfRqst" },
  { id_PowerControlGAP, "id-PowerControlGAP" },
  { id_MBSFN_SpecialTimeSlot_LCR, "id-MBSFN-SpecialTimeSlot-LCR" },
  { id_Common_MACFlows_to_DeleteFDD, "id-Common-MACFlows-to-DeleteFDD" },
  { id_Paging_MACFlows_to_DeleteFDD, "id-Paging-MACFlows-to-DeleteFDD" },
  { id_E_TFCI_Boost_Information, "id-E-TFCI-Boost-Information" },
  { id_SixteenQAM_UL_Operation_Indicator, "id-SixteenQAM-UL-Operation-Indicator" },
  { id_SixtyfourQAM_UsageAllowedIndicator, "id-SixtyfourQAM-UsageAllowedIndicator" },
  { id_SixtyfourQAM_DL_UsageIndicator, "id-SixtyfourQAM-DL-UsageIndicator" },
  { id_Default_Serving_Grant_in_DTX_Cycle2, "id-Default-Serving-Grant-in-DTX-Cycle2" },
  { id_Maximum_Target_ReceivedTotalWideBandPower_LCR, "id-Maximum-Target-ReceivedTotalWideBandPower-LCR" },
  { id_E_DPDCH_PowerInterpolation, "id-E-DPDCH-PowerInterpolation" },
  { id_Extended_E_DCH_LCRTDD_PhysicalLayerCategory, "id-Extended-E-DCH-LCRTDD-PhysicalLayerCategory" },
  { id_MultipleFreq_E_DCH_Resources_InformationList_AuditRsp, "id-MultipleFreq-E-DCH-Resources-InformationList-AuditRsp" },
  { id_MultipleFreq_E_DCH_Resources_InformationList_ResourceStatusInd, "id-MultipleFreq-E-DCH-Resources-InformationList-ResourceStatusInd" },
  { id_MultipleFreq_E_PUCH_Timeslot_InformationList_LCR_PSCH_ReconfRqst, "id-MultipleFreq-E-PUCH-Timeslot-InformationList-LCR-PSCH-ReconfRqst" },
  { id_MultipleFreq_E_PUCH_Timeslot_Information_LCRItem_PSCH_ReconfRqst, "id-MultipleFreq-E-PUCH-Timeslot-Information-LCRItem-PSCH-ReconfRqst" },
  { id_Extended_E_HICH_ID_TDD, "id-Extended-E-HICH-ID-TDD" },
  { id_ContinuousPacketConnectivityHS_SCCH_less_Deactivate_Indicator, "id-ContinuousPacketConnectivityHS-SCCH-less-Deactivate-Indicator" },
  { id_E_DCH_MACdPDU_SizeCapability, "id-E-DCH-MACdPDU-SizeCapability" },
  { id_E_DCH_MACdPDUSizeFormat, "id-E-DCH-MACdPDUSizeFormat" },
  { id_MaximumNumber_Of_Retransmission_for_Scheduling_Info_LCRTDD, "id-MaximumNumber-Of-Retransmission-for-Scheduling-Info-LCRTDD" },
  { id_E_DCH_RetransmissionTimer_for_SchedulingInfo_LCRTDD, "id-E-DCH-RetransmissionTimer-for-SchedulingInfo-LCRTDD" },
  { id_E_HICH_TimeOffset_Extension, "id-E-HICH-TimeOffset-Extension" },
  { id_MultipleFreq_E_HICH_TimeOffsetLCR, "id-MultipleFreq-E-HICH-TimeOffsetLCR" },
  { id_E_PUCH_PowerControlGAP, "id-E-PUCH-PowerControlGAP" },
  { id_HSDSCH_TBSizeTableIndicator, "id-HSDSCH-TBSizeTableIndicator" },
  { id_E_DCH_DL_Control_Channel_Change_Information, "id-E-DCH-DL-Control-Channel-Change-Information" },
  { id_E_DCH_DL_Control_Channel_Grant_Information, "id-E-DCH-DL-Control-Channel-Grant-Information" },
  { id_DGANSS_Corrections_Req, "id-DGANSS-Corrections-Req" },
  { id_UE_with_enhanced_HS_SCCH_support_indicator, "id-UE-with-enhanced-HS-SCCH-support-indicator" },
  { id_AdditionalTimeSlotListLCR, "id-AdditionalTimeSlotListLCR" },
  { id_AdditionalMeasurementValueList, "id-AdditionalMeasurementValueList" },
  { id_Unknown_973, "id-Unknown-973" },
  { id_Unknown_974, "id-Unknown-974" },
  { id_Unknown_975, "id-Unknown-975" },
  { id_Unknown_976, "id-Unknown-976" },
  { id_Unknown_977, "id-Unknown-977" },
  { id_E_AGCH_Table_Choice, "id-E-AGCH-Table-Choice" },
  { id_Unknown_979, "id-Unknown-979" },
  { id_Unknown_980, "id-Unknown-980" },
  { id_PLCCH_parameters, "id-PLCCH-parameters" },
  { id_E_RUCCH_parameters, "id-E-RUCCH-parameters" },
  { id_E_RUCCH_768_parameters, "id-E-RUCCH-768-parameters" },
  { id_HS_Cause, "id-HS-Cause" },
  { id_E_Cause, "id-E-Cause" },
  { id_Unknown_986, "id-Unknown-986" },
  { id_Common_EDCH_Capability, "id-Common-EDCH-Capability" },
  { id_E_AI_Capability, "id-E-AI-Capability" },
  { id_Common_EDCH_System_InformationFDD, "id-Common-EDCH-System-InformationFDD" },
  { id_Common_UL_MACFlows_to_DeleteFDD, "id-Common-UL-MACFlows-to-DeleteFDD" },
  { id_Common_EDCH_MACdFlows_to_DeleteFDD, "id-Common-EDCH-MACdFlows-to-DeleteFDD" },
  { id_Common_EDCH_System_Information_ResponseFDD, "id-Common-EDCH-System-Information-ResponseFDD" },
  { id_Cell_ERNTI_Status_Information, "id-Cell-ERNTI-Status-Information" },
  { id_Enhanced_UE_DRX_Capability, "id-Enhanced-UE-DRX-Capability" },
  { id_Enhanced_UE_DRX_InformationFDD, "id-Enhanced-UE-DRX-InformationFDD" },
  { id_TransportBearerRequestIndicator, "id-TransportBearerRequestIndicator" },
  { id_SixtyfourQAM_DL_MIMO_Combined_Capability, "id-SixtyfourQAM-DL-MIMO-Combined-Capability" },
  { id_E_RNTI, "id-E-RNTI" },
  { id_MinimumReducedE_DPDCH_GainFactor, "id-MinimumReducedE-DPDCH-GainFactor" },
  { id_GANSS_Time_ID, "id-GANSS-Time-ID" },
  { id_GANSS_AddIonoModelReq, "id-GANSS-AddIonoModelReq" },
  { id_GANSS_EarthOrientParaReq, "id-GANSS-EarthOrientParaReq" },
  { id_GANSS_AddNavigationModelsReq, "id-GANSS-AddNavigationModelsReq" },
  { id_GANSS_AddUTCModelsReq, "id-GANSS-AddUTCModelsReq" },
  { id_GANSS_AuxInfoReq, "id-GANSS-AuxInfoReq" },
  { id_GANSS_SBAS_ID, "id-GANSS-SBAS-ID" },
  { id_GANSS_ID, "id-GANSS-ID" },
  { id_GANSS_Additional_Ionospheric_Model, "id-GANSS-Additional-Ionospheric-Model" },
  { id_GANSS_Earth_Orientation_Parameters, "id-GANSS-Earth-Orientation-Parameters" },
  { id_GANSS_Additional_Time_Models, "id-GANSS-Additional-Time-Models" },
  { id_GANSS_Additional_Navigation_Models, "id-GANSS-Additional-Navigation-Models" },
  { id_GANSS_Additional_UTC_Models, "id-GANSS-Additional-UTC-Models" },
  { id_GANSS_Auxiliary_Information, "id-GANSS-Auxiliary-Information" },
  { id_ERACH_CM_Rqst, "id-ERACH-CM-Rqst" },
  { id_ERACH_CM_Rsp, "id-ERACH-CM-Rsp" },
  { id_ERACH_CM_Rprt, "id-ERACH-CM-Rprt" },
  { id_EDCH_RACH_Report_Value, "id-EDCH-RACH-Report-Value" },
  { id_EDCH_RACH_Report_IncrDecrThres, "id-EDCH-RACH-Report-IncrDecrThres" },
  { id_EDCH_RACH_Report_ThresholdInformation, "id-EDCH-RACH-Report-ThresholdInformation" },
  { id_E_DPCCH_Power_Boosting_Capability, "id-E-DPCCH-Power-Boosting-Capability" },
  { id_HSDSCH_Common_System_InformationLCR, "id-HSDSCH-Common-System-InformationLCR" },
  { id_Unknown_1022, "id-Unknown-1022" },
  { id_HSDSCH_Paging_System_InformationLCR, "id-HSDSCH-Paging-System-InformationLCR" },
  { id_HSDSCH_Paging_System_Information_ResponseLCR, "id-HSDSCH-Paging-System-Information-ResponseLCR" },
  { id_Common_MACFlows_to_DeleteLCR, "id-Common-MACFlows-to-DeleteLCR" },
  { id_Paging_MACFlows_to_DeleteLCR, "id-Paging-MACFlows-to-DeleteLCR" },
  { id_Common_EDCH_System_InformationLCR, "id-Common-EDCH-System-InformationLCR" },
  { id_Common_UL_MACFlows_to_DeleteLCR, "id-Common-UL-MACFlows-to-DeleteLCR" },
  { id_Common_EDCH_MACdFlows_to_DeleteLCR, "id-Common-EDCH-MACdFlows-to-DeleteLCR" },
  { id_Common_EDCH_System_Information_ResponseLCR, "id-Common-EDCH-System-Information-ResponseLCR" },
  { id_Enhanced_UE_DRX_CapabilityLCR, "id-Enhanced-UE-DRX-CapabilityLCR" },
  { id_Enhanced_UE_DRX_InformationLCR, "id-Enhanced-UE-DRX-InformationLCR" },
  { id_HSDSCH_PreconfigurationSetup, "id-HSDSCH-PreconfigurationSetup" },
  { id_HSDSCH_PreconfigurationInfo, "id-HSDSCH-PreconfigurationInfo" },
  { id_NoOfTargetCellHS_SCCH_Order, "id-NoOfTargetCellHS-SCCH-Order" },
  { id_EnhancedHSServingCC_Abort, "id-EnhancedHSServingCC-Abort" },
  { id_Additional_HS_Cell_Information_RL_Setup, "id-Additional-HS-Cell-Information-RL-Setup" },
  { id_Additional_HS_Cell_Information_Response, "id-Additional-HS-Cell-Information-Response" },
  { id_Additional_HS_Cell_Information_RL_Addition, "id-Additional-HS-Cell-Information-RL-Addition" },
  { id_Additional_HS_Cell_Change_Information_Response, "id-Additional-HS-Cell-Change-Information-Response" },
  { id_Additional_HS_Cell_Information_RL_Reconf_Prep, "id-Additional-HS-Cell-Information-RL-Reconf-Prep" },
  { id_Additional_HS_Cell_Information_RL_Reconf_Req, "id-Additional-HS-Cell-Information-RL-Reconf-Req" },
  { id_Additional_HS_Cell_Information_RL_Param_Upd, "id-Additional-HS-Cell-Information-RL-Param-Upd" },
  { id_Multi_Cell_Capability_Info, "id-Multi-Cell-Capability-Info" },
  { id_IMB_Parameters, "id-IMB-Parameters" },
  { id_MACes_Maximum_Bitrate_LCR, "id-MACes-Maximum-Bitrate-LCR" },
  { id_Semi_PersistentScheduling_CapabilityLCR, "id-Semi-PersistentScheduling-CapabilityLCR" },
  { id_E_DCH_Semi_PersistentScheduling_Information_LCR, "id-E-DCH-Semi-PersistentScheduling-Information-LCR" },
  { id_HS_DSCH_Semi_PersistentScheduling_Information_LCR, "id-HS-DSCH-Semi-PersistentScheduling-Information-LCR" },
  { id_Add_To_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst, "id-Add-To-Non-HS-SCCH-Associated-HS-SICH-Resource-Pool-LCR-PSCH-ReconfRqst" },
  { id_Modify_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst, "id-Modify-Non-HS-SCCH-Associated-HS-SICH-Resource-Pool-LCR-PSCH-ReconfRqst" },
  { id_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst, "id-Delete-From-Non-HS-SCCH-Associated-HS-SICH-Resource-Pool-LCR-PSCH-ReconfRqst" },
  { id_ContinuousPacketConnectivity_DRX_CapabilityLCR, "id-ContinuousPacketConnectivity-DRX-CapabilityLCR" },
  { id_ContinuousPacketConnectivity_DRX_InformationLCR, "id-ContinuousPacketConnectivity-DRX-InformationLCR" },
  { id_ContinuousPacketConnectivity_DRX_Information_ResponseLCR, "id-ContinuousPacketConnectivity-DRX-Information-ResponseLCR" },
  { id_CPC_InformationLCR, "id-CPC-InformationLCR" },
  { id_HS_DSCH_Semi_PersistentScheduling_Information_ResponseLCR, "id-HS-DSCH-Semi-PersistentScheduling-Information-ResponseLCR" },
  { id_E_DCH_Semi_PersistentScheduling_Information_ResponseLCR, "id-E-DCH-Semi-PersistentScheduling-Information-ResponseLCR" },
  { id_E_AGCH_UE_Inactivity_Monitor_Threshold, "id-E-AGCH-UE-Inactivity-Monitor-Threshold" },
  { id_Unknown_1060, "id-Unknown-1060" },
  { id_Unknown_1061, "id-Unknown-1061" },
  { id_Unknown_1062, "id-Unknown-1062" },
  { id_IdleIntervalInformation, "id-IdleIntervalInformation" },
  { id_GANSS_alm_keplerianNAVAlmanac, "id-GANSS-alm-keplerianNAVAlmanac" },
  { id_GANSS_alm_keplerianReducedAlmanac, "id-GANSS-alm-keplerianReducedAlmanac" },
  { id_GANSS_alm_keplerianMidiAlmanac, "id-GANSS-alm-keplerianMidiAlmanac" },
  { id_GANSS_alm_keplerianGLONASS, "id-GANSS-alm-keplerianGLONASS" },
  { id_GANSS_alm_ecefSBASAlmanac, "id-GANSS-alm-ecefSBASAlmanac" },
  { id_Unknown_1069, "id-Unknown-1069" },
  { id_HSSICH_ReferenceSignal_InformationLCR, "id-HSSICH-ReferenceSignal-InformationLCR" },
  { id_MIMO_ReferenceSignal_InformationListLCR, "id-MIMO-ReferenceSignal-InformationListLCR" },
  { id_MIMO_SFMode_For_HSPDSCHDualStream, "id-MIMO-SFMode-For-HSPDSCHDualStream" },
  { id_MIMO_SFMode_Supported_For_HSPDSCHDualStream, "id-MIMO-SFMode-Supported-For-HSPDSCHDualStream" },
  { id_UE_Selected_MBMS_Service_Information, "id-UE-Selected-MBMS-Service-Information" },
  { id_Unknown_1075, "id-Unknown-1075" },
  { id_Unknown_1076, "id-Unknown-1076" },
  { id_MultiCarrier_HSDSCH_Physical_Layer_Category, "id-MultiCarrier-HSDSCH-Physical-Layer-Category" },
  { id_Common_E_DCH_HSDPCCH_Capability, "id-Common-E-DCH-HSDPCCH-Capability" },
  { id_DL_RLC_PDU_Size_Format, "id-DL-RLC-PDU-Size-Format" },
  { id_HSSICH_ReferenceSignal_InformationModifyLCR, "id-HSSICH-ReferenceSignal-InformationModifyLCR" },
  { id_schedulingPriorityIndicator, "id-schedulingPriorityIndicator" },
  { id_TimeSlotMeasurementValueListLCR, "id-TimeSlotMeasurementValueListLCR" },
  { id_Unknown_1083, "id-Unknown-1083" },
  { id_Unknown_1084, "id-Unknown-1084" },
  { id_UE_SupportIndicatorExtension, "id-UE-SupportIndicatorExtension" },
  { id_Unknown_1086, "id-Unknown-1086" },
  { id_Unknown_1087, "id-Unknown-1087" },
  { id_Single_Stream_MIMO_ActivationIndicator, "id-Single-Stream-MIMO-ActivationIndicator" },
  { id_Single_Stream_MIMO_Capability, "id-Single-Stream-MIMO-Capability" },
  { id_Single_Stream_MIMO_Mode_Indicator, "id-Single-Stream-MIMO-Mode-Indicator" },
  { id_Dual_Band_Capability_Info, "id-Dual-Band-Capability-Info" },
  { id_UE_AggregateMaximumBitRate, "id-UE-AggregateMaximumBitRate" },
  { id_UE_AggregateMaximumBitRate_Enforcement_Indicator, "id-UE-AggregateMaximumBitRate-Enforcement-Indicator" },
  { id_Unknown_1094, "id-Unknown-1094" },
  { id_Unknown_1095, "id-Unknown-1095" },
  { id_Unknown_1096, "id-Unknown-1096" },
  { id_Unknown_1097, "id-Unknown-1097" },
  { id_Unknown_1098, "id-Unknown-1098" },
  { id_Unknown_1099, "id-Unknown-1099" },
  { id_Unknown_1100, "id-Unknown-1100" },
  { id_MIMO_Power_Offset_For_S_CPICH_Capability, "id-MIMO-Power-Offset-For-S-CPICH-Capability" },
  { id_MIMO_PilotConfigurationExtension, "id-MIMO-PilotConfigurationExtension" },
  { id_TxDiversityOnDLControlChannelsByMIMOUECapability, "id-TxDiversityOnDLControlChannelsByMIMOUECapability" },
  { id_ULTimeslotISCPValue_For_CellPortion, "id-ULTimeslotISCPValue-For-CellPortion" },
  { id_UpPTSInterferenceValue_For_CellPortion, "id-UpPTSInterferenceValue-For-CellPortion" },
  { id_Best_Cell_Portions_ValueLCR, "id-Best-Cell-Portions-ValueLCR" },
  { id_Transmitted_Carrier_Power_For_CellPortion_ValueLCR, "id-Transmitted-Carrier-Power-For-CellPortion-ValueLCR" },
  { id_Received_total_wide_band_power_For_CellPortion_ValueLCR, "id-Received-total-wide-band-power-For-CellPortion-ValueLCR" },
  { id_UL_TimeslotISCP_For_CellPortion_Value, "id-UL-TimeslotISCP-For-CellPortion-Value" },
  { id_HS_DSCHRequiredPowerValueInformation_For_CellPortionLCR, "id-HS-DSCHRequiredPowerValueInformation-For-CellPortionLCR" },
  { id_HS_DSCHProvidedBitRateValueInformation_For_CellPortionLCR, "id-HS-DSCHProvidedBitRateValueInformation-For-CellPortionLCR" },
  { id_E_DCHProvidedBitRateValueInformation_For_CellPortion, "id-E-DCHProvidedBitRateValueInformation-For-CellPortion" },
  { id_UpPTSInterference_For_CellPortion_Value, "id-UpPTSInterference-For-CellPortion-Value" },
  { id_NumberOfReportedCellPortionsLCR, "id-NumberOfReportedCellPortionsLCR" },
  { id_CellPortion_CapabilityLCR, "id-CellPortion-CapabilityLCR" },
  { id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortionValue, "id-TransmittedCarrierPowerOfAllCodesNotUsedForHS-PDSCH-HS-SCCH-E-AGCHOrE-HICHTransmissionCellPortionValue" },
  { id_TransmittedCarrierPowerOfAllCodesNotUsedForHS_PDSCH_HS_SCCH_E_AGCHOrE_HICHTransmissionCellPortion, "id-TransmittedCarrierPowerOfAllCodesNotUsedForHS-PDSCH-HS-SCCH-E-AGCHOrE-HICHTransmissionCellPortion" },
  { id_Unknown_1118, "id-Unknown-1118" },
  { id_ActivationInformation, "id-ActivationInformation" },
  { id_Additional_EDCH_Cell_Information_RL_Setup_Req, "id-Additional-EDCH-Cell-Information-RL-Setup-Req" },
  { id_Additional_EDCH_Cell_Information_Response, "id-Additional-EDCH-Cell-Information-Response" },
  { id_Additional_EDCH_Cell_Information_RL_Add_Req, "id-Additional-EDCH-Cell-Information-RL-Add-Req" },
  { id_Additional_EDCH_Cell_Information_Response_RL_Add, "id-Additional-EDCH-Cell-Information-Response-RL-Add" },
  { id_Additional_EDCH_Cell_Information_RL_Reconf_Prep, "id-Additional-EDCH-Cell-Information-RL-Reconf-Prep" },
  { id_Additional_EDCH_Cell_Information_RL_Reconf_Req, "id-Additional-EDCH-Cell-Information-RL-Reconf-Req" },
  { id_Additional_EDCH_Cell_Information_Bearer_Rearrangement, "id-Additional-EDCH-Cell-Information-Bearer-Rearrangement" },
  { id_Additional_EDCH_Cell_Information_RL_Param_Upd, "id-Additional-EDCH-Cell-Information-RL-Param-Upd" },
  { id_Additional_EDCH_Preconfiguration_Information, "id-Additional-EDCH-Preconfiguration-Information" },
  { id_EDCH_Indicator, "id-EDCH-Indicator" },
  { id_Unknown_1130, "id-Unknown-1130" },
  { id_HS_DSCH_SPS_Reservation_Indicator, "id-HS-DSCH-SPS-Reservation-Indicator" },
  { id_E_DCH_SPS_Reservation_Indicator, "id-E-DCH-SPS-Reservation-Indicator" },
  { id_MultipleFreq_HARQ_MemoryPartitioning_InformationList, "id-MultipleFreq-HARQ-MemoryPartitioning-InformationList" },
  { id_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext, "id-Ul-common-E-DCH-MACflow-Specific-InfoResponseListLCR-Ext" },
  { id_RepetitionPeriodIndex, "id-RepetitionPeriodIndex" },
  { id_MidambleShiftLCR, "id-MidambleShiftLCR" },
  { id_MaxHSDSCH_HSSCCH_Power_per_CELLPORTION, "id-MaxHSDSCH-HSSCCH-Power-per-CELLPORTION" },
  { id_DormantModeIndicator, "id-DormantModeIndicator" },
  { id_DiversityMode, "id-DiversityMode" },
  { id_TransmitDiversityIndicator, "id-TransmitDiversityIndicator" },
  { id_NonCellSpecificTxDiversity, "id-NonCellSpecificTxDiversity" },
  { id_Cell_Capability_Container, "id-Cell-Capability-Container" },
  { id_E_RNTI_List_Request, "id-E-RNTI-List-Request" },
  { id_E_RNTI_List, "id-E-RNTI-List" },
  { id_PowerControlGAP_For_CellFACHLCR, "id-PowerControlGAP-For-CellFACHLCR" },
  { id_Unknown_1146, "id-Unknown-1146" },
  { id_UL_Synchronisation_Parameters_For_FACHLCR, "id-UL-Synchronisation-Parameters-For-FACHLCR" },
  { id_HS_DSCH_SPS_Operation_Indicator, "id-HS-DSCH-SPS-Operation-Indicator" },
  { id_HSDSCH_RNTI_For_FACH, "id-HSDSCH-RNTI-For-FACH" },
  { id_E_RNTI_For_FACH, "id-E-RNTI-For-FACH" },
  { id_Out_of_Sychronization_Window, "id-Out-of-Sychronization-Window" },
  { id_Max_RTWP_perUARFCN_Information_LCR_PSCH_ReconfRqst, "id-Max-RTWP-perUARFCN-Information-LCR-PSCH-ReconfRqst" },
  { id_E_HICH_TimeOffset_ReconfFailureTDD, "id-E-HICH-TimeOffset-ReconfFailureTDD" },
  { id_HSSCCH_TPC_StepSize, "id-HSSCCH-TPC-StepSize" },
  { id_TS0_CapabilityLCR, "id-TS0-CapabilityLCR" },
  { id_UE_TS0_CapabilityLCR, "id-UE-TS0-CapabilityLCR" },
  { id_Common_System_Information_ResponseLCR, "id-Common-System-Information-ResponseLCR" },
  { id_Additional_EDCH_Cell_Information_ResponseRLReconf, "id-Additional-EDCH-Cell-Information-ResponseRLReconf" },
  { id_Multicell_EDCH_InformationItemIEs, "id-Multicell-EDCH-InformationItemIEs" },
  { id_Multicell_EDCH_RL_Specific_InformationItemIEs, "id-Multicell-EDCH-RL-Specific-InformationItemIEs" },
  { id_Add_To_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext, "id-Add-To-Non-HS-SCCH-Associated-HS-SICH-Resource-Pool-LCR-PSCH-ReconfRqst-Ext" },
  { id_Modify_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext, "id-Modify-Non-HS-SCCH-Associated-HS-SICH-Resource-Pool-LCR-PSCH-ReconfRqst-Ext" },
  { id_Delete_From_Non_HS_SCCH_Associated_HS_SICH_Resource_Pool_LCR_PSCH_ReconfRqst_Ext, "id-Delete-From-Non-HS-SCCH-Associated-HS-SICH-Resource-Pool-LCR-PSCH-ReconfRqst-Ext" },
  { id_Initial_DL_Transmission_Power, "id-Initial-DL-Transmission-Power" },
  { id_Maximum_DL_Power, "id-Maximum-DL-Power" },
  { id_Minimum_DL_Power, "id-Minimum-DL-Power" },
  { id_DCH_MeasurementOccasion_Information, "id-DCH-MeasurementOccasion-Information" },
  { id_AssociatedPhsicalChannelID, "id-AssociatedPhsicalChannelID" },
  { id_DGNSS_ValidityPeriod, "id-DGNSS-ValidityPeriod" },
  { id_PhysicalChannelID_for_CommonERNTI_RequestedIndicator, "id-PhysicalChannelID-for-CommonERNTI-RequestedIndicator" },
  { id_PrecodingWeightSetRestriction, "id-PrecodingWeightSetRestriction" },
  { id_Treset_Usage_Indicator, "id-Treset-Usage-Indicator" },
  { id_Non_Serving_RL_Preconfig_Info, "id-Non-Serving-RL-Preconfig-Info" },
  { id_Non_Serving_RL_Preconfig_Setup, "id-Non-Serving-RL-Preconfig-Setup" },
  { id_Non_Serving_RL_Preconfig_Removal, "id-Non-Serving-RL-Preconfig-Removal" },
  { id_Additional_E_DCH_Non_Serving_RL_Preconfiguration_Setup, "id-Additional-E-DCH-Non-Serving-RL-Preconfiguration-Setup" },
  { id_Additional_E_DCH_New_non_serving_RL_E_DCH_FDD_DL_Control_Channel_InfoList, "id-Additional-E-DCH-New-non-serving-RL-E-DCH-FDD-DL-Control-Channel-InfoList" },
  { id_Ul_common_E_DCH_MACflow_Specific_InfoListLCR_Ext, "id-Ul-common-E-DCH-MACflow-Specific-InfoListLCR-Ext" },
  { id_CommonMACFlow_Specific_InfoList_ResponseLCR_Ext, "id-CommonMACFlow-Specific-InfoList-ResponseLCR-Ext" },
  { id_Enabling_Delay_Ext_LCR, "id-Enabling-Delay-Ext-LCR" },
  { id_Unallocated_1181, "id-Unallocated-1181" },
  { id_Unallocated_1182, "id-Unallocated-1182" },
  { id_Unallocated_1183, "id-Unallocated-1183" },
  { id_Unallocated_1184, "id-Unallocated-1184" },
  { id_Unallocated_1185, "id-Unallocated-1185" },
  { id_Unallocated_1186, "id-Unallocated-1186" },
  { id_Unallocated_1187, "id-Unallocated-1187" },
  { id_Unallocated_1188, "id-Unallocated-1188" },
  { id_Unallocated_1189, "id-Unallocated-1189" },
  { id_Unallocated_1190, "id-Unallocated-1190" },
  { id_Unallocated_1191, "id-Unallocated-1191" },
  { id_Unallocated_1192, "id-Unallocated-1192" },
  { id_Unallocated_1193, "id-Unallocated-1193" },
  { id_Unallocated_1194, "id-Unallocated-1194" },
  { id_Unallocated_1195, "id-Unallocated-1195" },
  { id_Unallocated_1196, "id-Unallocated-1196" },
  { id_Unallocated_1197, "id-Unallocated-1197" },
  { id_Unallocated_1198, "id-Unallocated-1198" },
  { id_Unallocated_1199, "id-Unallocated-1199" },
  { id_Unallocated_1200, "id-Unallocated-1200" },
  { id_Unallocated_1201, "id-Unallocated-1201" },
  { id_Unallocated_1202, "id-Unallocated-1202" },
  { id_Unallocated_1203, "id-Unallocated-1203" },
  { id_Unallocated_1204, "id-Unallocated-1204" },
  { id_Unallocated_1205, "id-Unallocated-1205" },
  { id_Unallocated_1206, "id-Unallocated-1206" },
  { id_Unallocated_1207, "id-Unallocated-1207" },
  { id_Unallocated_1208, "id-Unallocated-1208" },
  { id_Unallocated_1209, "id-Unallocated-1209" },
  { id_Unallocated_1210, "id-Unallocated-1210" },
  { id_Unallocated_1211, "id-Unallocated-1211" },
  { id_Unallocated_1212, "id-Unallocated-1212" },
  { id_Unallocated_1213, "id-Unallocated-1213" },
  { id_Unallocated_1214, "id-Unallocated-1214" },
  { id_Unallocated_1215, "id-Unallocated-1215" },
  { id_Unallocated_1216, "id-Unallocated-1216" },
  { id_Unallocated_1217, "id-Unallocated-1217" },
  { id_Unallocated_1218, "id-Unallocated-1218" },
  { id_Unallocated_1219, "id-Unallocated-1219" },
  { id_Unallocated_1220, "id-Unallocated-1220" },
  { id_Unallocated_1221, "id-Unallocated-1221" },
  { id_HSDSCH_Common_System_Information_ResponseLCR, "id-HSDSCH-Common-System-Information-ResponseLCR" },
  { 0, NULL }
};

static value_string_ext nbap_ProtocolIE_ID_vals_ext = VALUE_STRING_EXT_INIT(nbap_ProtocolIE_ID_vals);


static int
dissect_nbap_ProtocolIE_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 81 "./asn1/nbap/nbap.cnf"
  guint32 protocol_ie_id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxProtocolIEs, &protocol_ie_id, FALSE);

  private_data_set_protocol_ie_id(actx->pinfo, protocol_ie_id); /* To carry around the packet */
  if (tree) {
    proto_item_append_text(proto_item_get_parent_nth(actx->created_item, 2), ": %s", val_to_str_ext(protocol_ie_id, &nbap_ProtocolIE_ID_vals_ext, "unknown (%d)"));
  }


  return offset;
}



static int
dissect_nbap_T_shortTransActionId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 116 "./asn1/nbap/nbap.cnf"
  guint32 transaction_id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, &transaction_id, FALSE);

  private_data_set_transaction_id(actx->pinfo, transaction_id);



  return offset;
}



static int
dissect_nbap_T_longTransActionId(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 121 "./asn1/nbap/nbap.cnf"
  guint32 transaction_id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, &transaction_id, FALSE);

  private_data_set_transaction_id(actx->pinfo, transaction_id);



  return offset;
}


static const value_string nbap_TransactionID_vals[] = {
  {   0, "shortTransActionId" },
  {   1, "longTransActionId" },
  { 0, NULL }
};

static const per_choice_t TransactionID_choice[] = {
  {   0, &hf_nbap_shortTransActionId, ASN1_NO_EXTENSIONS     , dissect_nbap_T_shortTransActionId },
  {   1, &hf_nbap_longTransActionId, ASN1_NO_EXTENSIONS     , dissect_nbap_T_longTransActionId },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_TransactionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_TransactionID, TransactionID_choice,
                                 NULL);

  return offset;
}


static const value_string nbap_TriggeringMessage_vals[] = {
  {   0, "initiating-message" },
  {   1, "successful-outcome" },
  {   2, "unsuccessfull-outcome" },
  {   3, "outcome" },
  { 0, NULL }
};


static int
dissect_nbap_TriggeringMessage(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_ProtocolIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolIEFieldValue);

  return offset;
}


static const per_sequence_t ProtocolIE_Field_sequence[] = {
  { &hf_nbap_id             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_ProtocolIE_ID },
  { &hf_nbap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Criticality },
  { &hf_nbap_ie_field_value , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_ProtocolIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ProtocolIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ProtocolIE_Field, ProtocolIE_Field_sequence);

  return offset;
}


static const per_sequence_t ProtocolIE_Container_sequence_of[1] = {
  { &hf_nbap_ProtocolIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_ProtocolIE_Field },
};

static int
dissect_nbap_ProtocolIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_ProtocolIE_Container, ProtocolIE_Container_sequence_of,
                                                  0, maxProtocolIEs, FALSE);

  return offset;
}



static int
dissect_nbap_ProtocolIE_Single_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_nbap_ProtocolIE_Field(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_nbap_T_extensionValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type_pdu_new(tvb, offset, actx, tree, hf_index, dissect_ProtocolExtensionFieldExtensionValue);

  return offset;
}


static const per_sequence_t ProtocolExtensionField_sequence[] = {
  { &hf_nbap_id             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_ProtocolIE_ID },
  { &hf_nbap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Criticality },
  { &hf_nbap_extensionValue , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_T_extensionValue },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ProtocolExtensionField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ProtocolExtensionField, ProtocolExtensionField_sequence);

  return offset;
}


static const per_sequence_t ProtocolExtensionContainer_sequence_of[1] = {
  { &hf_nbap_ProtocolExtensionContainer_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_ProtocolExtensionField },
};

static int
dissect_nbap_ProtocolExtensionContainer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_ProtocolExtensionContainer, ProtocolExtensionContainer_sequence_of,
                                                  1, maxProtocolExtensions, FALSE);

  return offset;
}



static int
dissect_nbap_PrivateIE_Field_value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_open_type(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t PrivateIE_Field_sequence[] = {
  { &hf_nbap_id_01          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_PrivateIE_ID },
  { &hf_nbap_criticality    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Criticality },
  { &hf_nbap_private_value  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_PrivateIE_Field_value },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_PrivateIE_Field(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_PrivateIE_Field, PrivateIE_Field_sequence);

  return offset;
}


static const per_sequence_t PrivateIE_Container_sequence_of[1] = {
  { &hf_nbap_PrivateIE_Container_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_PrivateIE_Field },
};

static int
dissect_nbap_PrivateIE_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_PrivateIE_Container, PrivateIE_Container_sequence_of,
                                                  1, maxPrivateIEs, FALSE);

  return offset;
}



static int
dissect_nbap_AckNack_RepetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_Ack_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_Acknowledged_PRACH_preambles_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 240U, NULL, TRUE);

  return offset;
}


static const value_string nbap_Uu_ActivationState_vals[] = {
  {   0, "activated" },
  {   1, "de-activated" },
  { 0, NULL }
};


static int
dissect_nbap_Uu_ActivationState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t ActivationInformationItem_sequence[] = {
  { &hf_nbap_uU_ActivationState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Uu_ActivationState },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ActivationInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ActivationInformationItem, ActivationInformationItem_sequence);

  return offset;
}


static const per_sequence_t ActivationInformation_sequence_of[1] = {
  { &hf_nbap_ActivationInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_ActivationInformationItem },
};

static int
dissect_nbap_ActivationInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_ActivationInformation, ActivationInformation_sequence_of,
                                                  1, maxNrOfEDCH_1, FALSE);

  return offset;
}


static const value_string nbap_Multicell_EDCH_Transport_Bearer_Mode_vals[] = {
  {   0, "separate-Iub-Transport-Bearer-Mode" },
  {   1, "uL-Flow-Multiplexing-Mode" },
  { 0, NULL }
};


static int
dissect_nbap_Multicell_EDCH_Transport_Bearer_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_UL_ScramblingCodeNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 976 "./asn1/nbap/nbap.cnf"
  guint32 ul_scrambling_code;
  guint32 com_context_id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, &ul_scrambling_code, FALSE);

  private_data_set_ul_scrambling_code(actx->pinfo, ul_scrambling_code);
  com_context_id = private_data_get_com_context_id(actx->pinfo);
  if(ul_scrambling_code != 0 && com_context_id != 0) {
    wmem_tree_insert32(nbap_scrambling_code_crncc_map,ul_scrambling_code,GUINT_TO_POINTER(com_context_id));
  }



  return offset;
}


static const value_string nbap_UL_ScramblingCodeLength_vals[] = {
  {   0, "short" },
  {   1, "long" },
  { 0, NULL }
};


static int
dissect_nbap_UL_ScramblingCodeLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t UL_ScramblingCode_sequence[] = {
  { &hf_nbap_uL_ScramblingCodeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UL_ScramblingCodeNumber },
  { &hf_nbap_uL_ScramblingCodeLength, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UL_ScramblingCodeLength },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_UL_ScramblingCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_UL_ScramblingCode, UL_ScramblingCode_sequence);

  return offset;
}



static int
dissect_nbap_UL_SIR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -82, 173U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_UL_DPCH_Information_Setup_sequence[] = {
  { &hf_nbap_ul_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UL_ScramblingCode },
  { &hf_nbap_ul_SIR_Target  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UL_SIR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_UL_DPCH_Information_Setup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_UL_DPCH_Information_Setup, Additional_EDCH_UL_DPCH_Information_Setup_sequence);

  return offset;
}



static int
dissect_nbap_RL_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_C_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const value_string nbap_FirstRLS_Indicator_vals[] = {
  {   0, "first-RLS" },
  {   1, "not-first-RLS" },
  { 0, NULL }
};


static int
dissect_nbap_FirstRLS_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_PropagationDelay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_DL_ScramblingCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_FDD_DL_ChannelisationCodeNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const value_string nbap_TransmissionGapPatternSequenceCodeInformation_vals[] = {
  {   0, "code-change" },
  {   1, "nocode-change" },
  { 0, NULL }
};


static int
dissect_nbap_TransmissionGapPatternSequenceCodeInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t FDD_DL_CodeInformationItem_sequence[] = {
  { &hf_nbap_dl_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_ScramblingCode },
  { &hf_nbap_fdd_DL_ChannelisationCodeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_DL_ChannelisationCodeNumber },
  { &hf_nbap_transmissionGapPatternSequenceCodeInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransmissionGapPatternSequenceCodeInformation },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_FDD_DL_CodeInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_FDD_DL_CodeInformationItem, FDD_DL_CodeInformationItem_sequence);

  return offset;
}


static const per_sequence_t FDD_DL_CodeInformation_sequence_of[1] = {
  { &hf_nbap_FDD_DL_CodeInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_DL_CodeInformationItem },
};

static int
dissect_nbap_FDD_DL_CodeInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_FDD_DL_CodeInformation, FDD_DL_CodeInformation_sequence_of,
                                                  1, maxNrOfCodes, FALSE);

  return offset;
}



static int
dissect_nbap_DL_Power(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -350, 150U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_F_DPCH_SlotFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Multicell_EDCH_RL_Specific_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_nbap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t Additional_EDCH_RL_Specific_Information_To_Setup_ItemIEs_sequence[] = {
  { &hf_nbap_eDCH_Additional_RL_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_ID },
  { &hf_nbap_c_ID           , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_C_ID },
  { &hf_nbap_firstRLS_indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FirstRLS_Indicator },
  { &hf_nbap_propagationDelay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_PropagationDelay },
  { &hf_nbap_dl_CodeInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_DL_CodeInformation },
  { &hf_nbap_initialDL_transmissionPower, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Power },
  { &hf_nbap_maximumDL_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Power },
  { &hf_nbap_minimumDL_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Power },
  { &hf_nbap_f_DPCH_SlotFormat, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_F_DPCH_SlotFormat },
  { &hf_nbap_e_RNTI         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_RNTI },
  { &hf_nbap_multicell_EDCH_RL_Specific_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Multicell_EDCH_RL_Specific_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_ItemIEs, Additional_EDCH_RL_Specific_Information_To_Setup_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_RL_Specific_Information_To_Setup_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_ItemIEs },
};

static int
dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_List, Additional_EDCH_RL_Specific_Information_To_Setup_List_sequence_of,
                                                  1, maxNrOfEDCHRLs, FALSE);

  return offset;
}



static int
dissect_nbap_E_DCH_MACdFlow_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 941 "./asn1/nbap/nbap.cnf"
  guint32 e_dch_macdflow_id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCHMACdFlows_1, &e_dch_macdflow_id, FALSE);

  private_data_set_e_dch_macdflow_id(actx->pinfo, e_dch_macdflow_id);



  return offset;
}



static int
dissect_nbap_BindingID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 960 "./asn1/nbap/nbap.cnf"
  tvbuff_t *parameter_tvb=NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       1, 4, TRUE, &parameter_tvb);


  if (!parameter_tvb)
    return offset;

  if(tvb_reported_length(parameter_tvb)>=2){
    private_data_set_binding_id_port(actx->pinfo, tvb_get_ntohs(parameter_tvb,0));
    proto_item_append_text(actx->created_item, " (%u)",private_data_get_binding_id_port(actx->pinfo));
  }



  return offset;
}



static int
dissect_nbap_TransportLayerAddress(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 836 "./asn1/nbap/nbap.cnf"
  tvbuff_t *parameter_tvb=NULL;
  proto_item *item;
  proto_tree *subtree, *nsap_tree;
  guint8 *padded_nsap_bytes;
  tvbuff_t *nsap_tvb;
  gint tvb_len;

  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 160, TRUE, &parameter_tvb, NULL);

  if (!parameter_tvb)
    return offset;
    /* Get the length */
    tvb_len = tvb_reported_length(parameter_tvb);
    subtree = proto_item_add_subtree(actx->created_item, ett_nbap_TransportLayerAddress);
    if (tvb_len==4){
        /* IPv4 */
         proto_tree_add_item(subtree, hf_nbap_transportLayerAddress_ipv4, parameter_tvb, 0, tvb_len, ENC_BIG_ENDIAN);
         private_data_set_transportLayerAddress_ipv4(actx->pinfo, tvb_get_ipv4(parameter_tvb, 0));
    }
    if (tvb_len==16){
        /* IPv6 */
         proto_tree_add_item(subtree, hf_nbap_transportLayerAddress_ipv6, parameter_tvb, 0, tvb_len, ENC_NA);
    }
    if (tvb_len == 20 || tvb_len == 7){
        /* NSAP */
        if (tvb_len == 7){
            /* Unpadded IPv4 NSAP */
            /* Creating a new TVB with padding */
            padded_nsap_bytes = (guint8*) wmem_alloc0(actx->pinfo->pool, 20);
            tvb_memcpy(parameter_tvb, padded_nsap_bytes, 0, tvb_len);
            nsap_tvb = tvb_new_child_real_data(tvb, padded_nsap_bytes, 20, 20);
            add_new_data_source(actx->pinfo, nsap_tvb, "Padded NSAP Data");
        }else{
            /* Padded NSAP*/
            nsap_tvb = parameter_tvb;
        }
        item = proto_tree_add_item(subtree, hf_nbap_transportLayerAddress_nsap, parameter_tvb, 0, tvb_len, ENC_NA);
        nsap_tree = proto_item_add_subtree(item, ett_nbap_TransportLayerAddress_nsap);
        if(tvb_get_ntoh24(parameter_tvb,0) == 0x350001){
            /* IPv4 */
            private_data_set_transportLayerAddress_ipv4(actx->pinfo, tvb_get_ipv4(parameter_tvb, 3));
        }
        dissect_nsap(nsap_tvb, 0, 20, nsap_tree);
    }




  return offset;
}


static const per_sequence_t Additional_EDCH_MAC_d_Flows_Specific_Info_sequence[] = {
  { &hf_nbap_e_DCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_MACdFlow_ID },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info, Additional_EDCH_MAC_d_Flows_Specific_Info_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_MAC_d_Flows_Specific_Info_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info },
};

static int
dissect_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_List, Additional_EDCH_MAC_d_Flows_Specific_Info_List_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows, FALSE);

  return offset;
}



static int
dissect_nbap_HARQ_Process_Allocation_2ms_EDCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     maxNrOfEDCHHARQProcesses2msEDCH, maxNrOfEDCHHARQProcesses2msEDCH, FALSE, NULL, NULL);

  return offset;
}



static int
dissect_nbap_E_DCH_Maximum_Bitrate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5742U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_E_DCH_Processing_Overload_Level(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_E_TFCI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_FDD_Information_sequence[] = {
  { &hf_nbap_additional_EDCH_MAC_d_Flows_Specific_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_List },
  { &hf_nbap_hARQ_Process_Allocation_Scheduled_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_nbap_e_DCH_Maximum_Bitrate, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_Maximum_Bitrate },
  { &hf_nbap_e_DCH_Processing_Overload_Level, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_Processing_Overload_Level },
  { &hf_nbap_e_DCH_Min_Set_E_TFCI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_TFCI },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_FDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_FDD_Information, Additional_EDCH_FDD_Information_sequence);

  return offset;
}


static const value_string nbap_FDD_TPC_DownlinkStepSize_vals[] = {
  {   0, "step-size0-5" },
  {   1, "step-size1" },
  {   2, "step-size1-5" },
  {   3, "step-size2" },
  { 0, NULL }
};


static int
dissect_nbap_FDD_TPC_DownlinkStepSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_LimitedPowerIncrease_vals[] = {
  {   0, "used" },
  {   1, "not-used" },
  { 0, NULL }
};


static int
dissect_nbap_LimitedPowerIncrease(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_InnerLoopDLPCStatus_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_nbap_InnerLoopDLPCStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Additional_EDCH_F_DPCH_Information_sequence[] = {
  { &hf_nbap_fdd_TPC_DownlinkStepSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_TPC_DownlinkStepSize },
  { &hf_nbap_limitedPowerIncrease, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_LimitedPowerIncrease },
  { &hf_nbap_innerLoopDLPCStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_InnerLoopDLPCStatus },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_F_DPCH_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_F_DPCH_Information, Additional_EDCH_F_DPCH_Information_sequence);

  return offset;
}



static int
dissect_nbap_Multicell_EDCH_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_nbap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t Additional_EDCH_FDD_Setup_Cell_Information_sequence[] = {
  { &hf_nbap_additional_EDCH_UL_DPCH_Information_Setup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_UL_DPCH_Information_Setup },
  { &hf_nbap_additional_EDCH_RL_Specific_Information_To_Setup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Setup_List },
  { &hf_nbap_additional_EDCH_FDD_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_FDD_Information },
  { &hf_nbap_additional_EDCH_F_DPCH_Information_Setup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_F_DPCH_Information },
  { &hf_nbap_multicell_EDCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Multicell_EDCH_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_FDD_Setup_Cell_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_FDD_Setup_Cell_Information, Additional_EDCH_FDD_Setup_Cell_Information_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_Setup_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_Cell_Information_Setup_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_FDD_Setup_Cell_Information },
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_Setup(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_Cell_Information_Setup, Additional_EDCH_Cell_Information_Setup_sequence_of,
                                                  1, maxNrOfEDCH_1, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_Setup_Info_sequence[] = {
  { &hf_nbap_multicell_EDCH_Transport_Bearer_Mode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Multicell_EDCH_Transport_Bearer_Mode },
  { &hf_nbap_additional_EDCH_Cell_Information_Setup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_Cell_Information_Setup },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_Setup_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_Setup_Info, Additional_EDCH_Setup_Info_sequence);

  return offset;
}


static const per_sequence_t EDCH_Additional_RL_Specific_Information_To_Add_List_sequence[] = {
  { &hf_nbap_eDCH_Additional_RL_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_ID },
  { &hf_nbap_c_ID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_C_ID },
  { &hf_nbap_dl_CodeInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_DL_CodeInformation },
  { &hf_nbap_initialDL_transmissionPower, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DL_Power },
  { &hf_nbap_maximumDL_power, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DL_Power },
  { &hf_nbap_minimumDL_power, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DL_Power },
  { &hf_nbap_f_DPCH_SlotFormat, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_F_DPCH_SlotFormat },
  { &hf_nbap_multicell_EDCH_RL_Specific_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Multicell_EDCH_RL_Specific_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_EDCH_Additional_RL_Specific_Information_To_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_EDCH_Additional_RL_Specific_Information_To_Add_List, EDCH_Additional_RL_Specific_Information_To_Add_List_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_EDCH_Additional_RL_Specific_Information_To_Add_List },
};

static int
dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs, Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs_sequence_of,
                                                  1, maxNrOfEDCHRLs, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_To_Add_ItemIEs_sequence[] = {
  { &hf_nbap_additional_EDCH_RL_Specific_Information_To_Add_ItemIEs, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs },
  { &hf_nbap_additional_EDCH_FDD_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_FDD_Information },
  { &hf_nbap_multicell_EDCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Multicell_EDCH_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_To_Add_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_Cell_Information_To_Add_ItemIEs, Additional_EDCH_Cell_Information_To_Add_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_To_Add_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_Cell_Information_To_Add_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_Cell_Information_To_Add_ItemIEs },
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_To_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_Cell_Information_To_Add_List, Additional_EDCH_Cell_Information_To_Add_List_sequence_of,
                                                  1, maxNrOfEDCH_1, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_RL_Specific_Information_To_Modify_ItemIEs_sequence[] = {
  { &hf_nbap_eDCH_Additional_RL_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_ID },
  { &hf_nbap_dl_CodeInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_FDD_DL_CodeInformation },
  { &hf_nbap_maximumDL_power, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DL_Power },
  { &hf_nbap_minimumDL_power, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DL_Power },
  { &hf_nbap_f_DPCH_SlotFormat, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_F_DPCH_SlotFormat },
  { &hf_nbap_multicell_EDCH_RL_Specific_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Multicell_EDCH_RL_Specific_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_ItemIEs, Additional_EDCH_RL_Specific_Information_To_Modify_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_RL_Specific_Information_To_Modify_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_ItemIEs },
};

static int
dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_List, Additional_EDCH_RL_Specific_Information_To_Modify_List_sequence_of,
                                                  1, maxNrOfEDCHRLs, FALSE);

  return offset;
}



static int
dissect_nbap_Received_total_wide_band_power_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 621U, NULL, FALSE);

  return offset;
}


static const value_string nbap_DL_PowerBalancing_ActivationIndicator_vals[] = {
  {   0, "dL-PowerBalancing-Activated" },
  { 0, NULL }
};


static int
dissect_nbap_DL_PowerBalancing_ActivationIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_RL_Set_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_RGCH_Signature_Sequence(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSigSeqRGHI_1, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_HICH_Signature_Sequence(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrofSigSeqRGHI_1, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_Serving_Grant_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 38U, NULL, FALSE);

  return offset;
}


static const value_string nbap_E_Primary_Secondary_Grant_Selector_vals[] = {
  {   0, "primary" },
  {   1, "secondary" },
  { 0, NULL }
};


static int
dissect_nbap_E_Primary_Secondary_Grant_Selector(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_E_RGCH_Release_Indicator_vals[] = {
  {   0, "e-RGCHreleased" },
  { 0, NULL }
};


static int
dissect_nbap_E_RGCH_Release_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t E_DCH_FDD_DL_Control_Channel_Information_sequence[] = {
  { &hf_nbap_e_AGCH_And_E_RGCH_E_HICH_FDD_Scrambling_Code, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DL_ScramblingCode },
  { &hf_nbap_e_AGCH_Channelisation_Code, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_FDD_DL_ChannelisationCodeNumber },
  { &hf_nbap_primary_e_RNTI , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_RNTI },
  { &hf_nbap_secondary_e_RNTI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_RNTI },
  { &hf_nbap_e_RGCH_E_HICH_Channelisation_Code, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_FDD_DL_ChannelisationCodeNumber },
  { &hf_nbap_e_RGCH_Signature_Sequence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_RGCH_Signature_Sequence },
  { &hf_nbap_e_HICH_Signature_Sequence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_HICH_Signature_Sequence },
  { &hf_nbap_serving_Grant_Value, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_Serving_Grant_Value },
  { &hf_nbap_primary_Secondary_Grant_Selector, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_Primary_Secondary_Grant_Selector },
  { &hf_nbap_e_RGCH_Release_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_RGCH_Release_Indicator },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_DCH_FDD_DL_Control_Channel_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_DCH_FDD_DL_Control_Channel_Information, E_DCH_FDD_DL_Control_Channel_Information_sequence);

  return offset;
}


static const per_sequence_t EDCH_Additional_RL_Specific_Information_Response_ItemIEs_sequence[] = {
  { &hf_nbap_eDCH_Additional_RL_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_ID },
  { &hf_nbap_received_total_wide_band_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Received_total_wide_band_power_Value },
  { &hf_nbap_dL_PowerBalancing_ActivationIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DL_PowerBalancing_ActivationIndicator },
  { &hf_nbap_rL_Set_ID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_Set_ID },
  { &hf_nbap_e_DCH_RL_Set_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_Set_ID },
  { &hf_nbap_e_DCH_FDD_DL_Control_Channel_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_FDD_DL_Control_Channel_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_EDCH_Additional_RL_Specific_Information_Response_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_EDCH_Additional_RL_Specific_Information_Response_ItemIEs, EDCH_Additional_RL_Specific_Information_Response_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t EDCH_Additional_RL_Specific_Information_Response_List_sequence_of[1] = {
  { &hf_nbap_EDCH_Additional_RL_Specific_Information_Response_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_EDCH_Additional_RL_Specific_Information_Response_ItemIEs },
};

static int
dissect_nbap_EDCH_Additional_RL_Specific_Information_Response_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_EDCH_Additional_RL_Specific_Information_Response_List, EDCH_Additional_RL_Specific_Information_Response_List_sequence_of,
                                                  1, maxNrOfEDCHRLs, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_MAC_d_Flows_Specific_Info_Response_sequence[] = {
  { &hf_nbap_e_DCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_MACdFlow_ID },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_Response, Additional_EDCH_MAC_d_Flows_Specific_Info_Response_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_MAC_d_Flows_Specific_Info_Response },
};

static int
dissect_nbap_Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List, Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_FDD_Information_Response_ItemIEs_sequence[] = {
  { &hf_nbap_eDCH_Additional_RL_Specific_Information_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_EDCH_Additional_RL_Specific_Information_Response_List },
  { &hf_nbap_additional_EDCH_MAC_d_Flow_Specific_Information_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List },
  { &hf_nbap_hARQ_Process_Allocation_Scheduled_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_FDD_Information_Response_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_FDD_Information_Response_ItemIEs, Additional_EDCH_FDD_Information_Response_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_Response_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_Cell_Information_Response_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_FDD_Information_Response_ItemIEs },
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_Response_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_Cell_Information_Response_List, Additional_EDCH_Cell_Information_Response_List_sequence_of,
                                                  1, maxNrOfEDCH_1, FALSE);

  return offset;
}


static const value_string nbap_DL_PowerBalancing_UpdatedIndicator_vals[] = {
  {   0, "dL-PowerBalancing-Updated" },
  { 0, NULL }
};


static int
dissect_nbap_DL_PowerBalancing_UpdatedIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t EDCH_Additional_Modified_RL_Specific_Information_Response_List_Items_sequence[] = {
  { &hf_nbap_eDCH_Additional_RL_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_ID },
  { &hf_nbap_dL_PowerBalancing_UpdatedIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DL_PowerBalancing_UpdatedIndicator },
  { &hf_nbap_e_DCH_FDD_DL_Control_Channel_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_FDD_DL_Control_Channel_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List_Items, EDCH_Additional_Modified_RL_Specific_Information_Response_List_Items_sequence);

  return offset;
}


static const per_sequence_t EDCH_Additional_Modified_RL_Specific_Information_Response_List_sequence_of[1] = {
  { &hf_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List_Items },
};

static int
dissect_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List, EDCH_Additional_Modified_RL_Specific_Information_Response_List_sequence_of,
                                                  1, maxNrOfEDCHRLs, FALSE);

  return offset;
}


static const per_sequence_t Additional_Modififed_EDCH_FDD_Information_Response_ItemIEs_sequence[] = {
  { &hf_nbap_eDCH_Additional_Modified_RL_Specific_Information_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_EDCH_Additional_Modified_RL_Specific_Information_Response_List },
  { &hf_nbap_additional_EDCH_MAC_d_Flow_Specific_Information_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_MAC_d_Flow_Specific_Information_Response_List },
  { &hf_nbap_hARQ_Process_Allocation_Scheduled_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_Modififed_EDCH_FDD_Information_Response_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_Modififed_EDCH_FDD_Information_Response_ItemIEs, Additional_Modififed_EDCH_FDD_Information_Response_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_FDD_Information_Response_RLReconf_Items_sequence[] = {
  { &hf_nbap_additional_EDCH_FDD_Information_Response_ItemIEs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_FDD_Information_Response_ItemIEs },
  { &hf_nbap_additional_Modififed_EDCH_FDD_Information_Response_ItemIEs, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_Modififed_EDCH_FDD_Information_Response_ItemIEs },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_FDD_Information_Response_RLReconf_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_FDD_Information_Response_RLReconf_Items, Additional_EDCH_FDD_Information_Response_RLReconf_Items_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_Response_RLReconf_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_Cell_Information_Response_RLReconf_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_FDD_Information_Response_RLReconf_Items },
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_Response_RLReconf_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_Cell_Information_Response_RLReconf_List, Additional_EDCH_Cell_Information_Response_RLReconf_List_sequence_of,
                                                  1, maxNrOfEDCH_1, FALSE);

  return offset;
}


static const per_sequence_t E_DCH_RL_InformationList_Rsp_Item_sequence[] = {
  { &hf_nbap_rl_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_ID },
  { &hf_nbap_e_DCH_FDD_DL_Control_Channel_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_FDD_DL_Control_Channel_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_DCH_RL_InformationList_Rsp_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_DCH_RL_InformationList_Rsp_Item, E_DCH_RL_InformationList_Rsp_Item_sequence);

  return offset;
}


static const per_sequence_t E_DCH_RL_InformationList_Rsp_sequence_of[1] = {
  { &hf_nbap_E_DCH_RL_InformationList_Rsp_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_RL_InformationList_Rsp_Item },
};

static int
dissect_nbap_E_DCH_RL_InformationList_Rsp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_E_DCH_RL_InformationList_Rsp, E_DCH_RL_InformationList_Rsp_sequence_of,
                                                  0, maxNrOfRLs, FALSE);

  return offset;
}


static const per_sequence_t E_DCH_serving_cell_change_successful_sequence[] = {
  { &hf_nbap_e_DCH_RL_InformationList_Rsp, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_RL_InformationList_Rsp },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_DCH_serving_cell_change_successful(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_DCH_serving_cell_change_successful, E_DCH_serving_cell_change_successful_sequence);

  return offset;
}


static const value_string nbap_CauseRadioNetwork_vals[] = {
  {   0, "unknown-C-ID" },
  {   1, "cell-not-available" },
  {   2, "power-level-not-supported" },
  {   3, "dl-radio-resources-not-available" },
  {   4, "ul-radio-resources-not-available" },
  {   5, "rl-already-ActivatedOrAllocated" },
  {   6, "nodeB-Resources-unavailable" },
  {   7, "measurement-not-supported-for-the-object" },
  {   8, "combining-resources-not-available" },
  {   9, "requested-configuration-not-supported" },
  {  10, "synchronisation-failure" },
  {  11, "priority-transport-channel-established" },
  {  12, "sIB-Origination-in-Node-B-not-Supported" },
  {  13, "requested-tx-diversity-mode-not-supported" },
  {  14, "unspecified" },
  {  15, "bCCH-scheduling-error" },
  {  16, "measurement-temporarily-not-available" },
  {  17, "invalid-CM-settings" },
  {  18, "reconfiguration-CFN-not-elapsed" },
  {  19, "number-of-DL-codes-not-supported" },
  {  20, "s-cpich-not-supported" },
  {  21, "combining-not-supported" },
  {  22, "ul-sf-not-supported" },
  {  23, "dl-SF-not-supported" },
  {  24, "common-transport-channel-type-not-supported" },
  {  25, "dedicated-transport-channel-type-not-supported" },
  {  26, "downlink-shared-channel-type-not-supported" },
  {  27, "uplink-shared-channel-type-not-supported" },
  {  28, "cm-not-supported" },
  {  29, "tx-diversity-no-longer-supported" },
  {  30, "unknown-Local-Cell-ID" },
  {  31, "number-of-UL-codes-not-supported" },
  {  32, "information-temporarily-not-available" },
  {  33, "information-provision-not-supported-for-the-object" },
  {  34, "cell-synchronisation-not-supported" },
  {  35, "cell-synchronisation-adjustment-not-supported" },
  {  36, "dpc-mode-change-not-supported" },
  {  37, "iPDL-already-activated" },
  {  38, "iPDL-not-supported" },
  {  39, "iPDL-parameters-not-available" },
  {  40, "frequency-acquisition-not-supported" },
  {  41, "power-balancing-status-not-compatible" },
  {  42, "requested-typeofbearer-re-arrangement-not-supported" },
  {  43, "signalling-Bearer-Re-arrangement-not-supported" },
  {  44, "bearer-Re-arrangement-needed" },
  {  45, "delayed-activation-not-supported" },
  {  46, "rl-timing-adjustment-not-supported" },
  {  47, "mich-not-supported" },
  {  48, "f-DPCH-not-supported" },
  {  49, "modification-period-not-available" },
  {  50, "pLCCH-not-supported" },
  {  51, "continuous-packet-connectivity-DTX-DRX-operation-not-available" },
  {  52, "continuous-packet-connectivity-UE-DTX-Cycle-not-available" },
  {  53, "mIMO-not-available" },
  {  54, "e-DCH-MACdPDU-SizeFormat-not-available" },
  {  55, "multi-Cell-operation-not-available" },
  {  56, "semi-Persistent-scheduling-not-supported" },
  {  57, "continuous-Packet-Connectivity-DRX-not-supported" },
  {  58, "continuous-Packet-Connectivity-DRX-not-available" },
  {  59, "sixtyfourQAM-DL-and-MIMO-Combined-not-available" },
  {  60, "s-cpich-power-offset-not-available" },
  {  61, "tx-diversity-for-mimo-on-DL-control-channels-not-available" },
  {  62, "single-Stream-MIMO-not-available" },
  {  63, "multi-Cell-operation-with-MIMO-not-available" },
  {  64, "multi-Cell-operation-with-Single-Stream-MIMO-not-available" },
  {  65, "cellSpecificTxDiversityHandlingForMultiCellOperationNotAvailable" },
  {  66, "multi-Cell-EDCH-operation-not-available" },
  { 0, NULL }
};


static int
dissect_nbap_CauseRadioNetwork(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, TRUE, 36, NULL);

  return offset;
}


static const value_string nbap_CauseTransport_vals[] = {
  {   0, "transport-resource-unavailable" },
  {   1, "unspecified" },
  { 0, NULL }
};


static int
dissect_nbap_CauseTransport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_CauseProtocol_vals[] = {
  {   0, "transfer-syntax-error" },
  {   1, "abstract-syntax-error-reject" },
  {   2, "abstract-syntax-error-ignore-and-notify" },
  {   3, "message-not-compatible-with-receiver-state" },
  {   4, "semantic-error" },
  {   5, "unspecified" },
  {   6, "abstract-syntax-error-falsely-constructed-message" },
  { 0, NULL }
};


static int
dissect_nbap_CauseProtocol(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_CauseMisc_vals[] = {
  {   0, "control-processing-overload" },
  {   1, "hardware-failure" },
  {   2, "oam-intervention" },
  {   3, "not-enough-user-plane-processing-resources" },
  {   4, "unspecified" },
  { 0, NULL }
};


static int
dissect_nbap_CauseMisc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_Cause_vals[] = {
  {   0, "radioNetwork" },
  {   1, "transport" },
  {   2, "protocol" },
  {   3, "misc" },
  { 0, NULL }
};

static const per_choice_t Cause_choice[] = {
  {   0, &hf_nbap_radioNetwork   , ASN1_EXTENSION_ROOT    , dissect_nbap_CauseRadioNetwork },
  {   1, &hf_nbap_transport      , ASN1_EXTENSION_ROOT    , dissect_nbap_CauseTransport },
  {   2, &hf_nbap_protocol       , ASN1_EXTENSION_ROOT    , dissect_nbap_CauseProtocol },
  {   3, &hf_nbap_misc           , ASN1_EXTENSION_ROOT    , dissect_nbap_CauseMisc },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_Cause(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_Cause, Cause_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_DCH_serving_cell_change_unsuccessful_sequence[] = {
  { &hf_nbap_cause          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Cause },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_DCH_serving_cell_change_unsuccessful(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_DCH_serving_cell_change_unsuccessful, E_DCH_serving_cell_change_unsuccessful_sequence);

  return offset;
}


static const value_string nbap_E_DCH_serving_cell_choice_vals[] = {
  {   0, "e-DCH-serving-cell-change-successful" },
  {   1, "e-DCH-serving-cell-change-unsuccessful" },
  { 0, NULL }
};

static const per_choice_t E_DCH_serving_cell_choice_choice[] = {
  {   0, &hf_nbap_e_DCH_serving_cell_change_successful, ASN1_EXTENSION_ROOT    , dissect_nbap_E_DCH_serving_cell_change_successful },
  {   1, &hf_nbap_e_DCH_serving_cell_change_unsuccessful, ASN1_EXTENSION_ROOT    , dissect_nbap_E_DCH_serving_cell_change_unsuccessful },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_E_DCH_serving_cell_choice(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_E_DCH_serving_cell_choice, E_DCH_serving_cell_choice_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t E_DCH_Serving_Cell_Change_Info_Response_sequence[] = {
  { &hf_nbap_e_DCH_serving_cell_choice, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_serving_cell_choice },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_DCH_Serving_Cell_Change_Info_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_DCH_Serving_Cell_Change_Info_Response, E_DCH_Serving_Cell_Change_Info_Response_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_Response_RL_Add_ItemIEs_sequence[] = {
  { &hf_nbap_additional_EDCH_FDD_Information_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_FDD_Information_Response_ItemIEs },
  { &hf_nbap_additional_EDCH_Serving_Cell_Change_Information_Response, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_Serving_Cell_Change_Info_Response },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_ItemIEs, Additional_EDCH_Cell_Information_Response_RL_Add_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_Response_RL_Add_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_ItemIEs },
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_Cell_Information_Response_RL_Add_List, Additional_EDCH_Cell_Information_Response_RL_Add_List_sequence_of,
                                                  1, maxNrOfEDCH_1, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_UL_DPCH_Information_Modify_sequence[] = {
  { &hf_nbap_ul_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UL_ScramblingCode },
  { &hf_nbap_ul_SIR_Target  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UL_SIR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_UL_DPCH_Information_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_UL_DPCH_Information_Modify, Additional_EDCH_UL_DPCH_Information_Modify_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_ConfigurationChange_Info_ItemIEs_sequence[] = {
  { &hf_nbap_additional_EDCH_UL_DPCH_Information_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_UL_DPCH_Information_Modify },
  { &hf_nbap_additional_EDCH_RL_Specific_Information_To_Add, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Add_ItemIEs },
  { &hf_nbap_additional_EDCH_RL_Specific_Information_To_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_RL_Specific_Information_To_Modify_List },
  { &hf_nbap_additional_EDCH_FDD_Information_To_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_FDD_Information },
  { &hf_nbap_additional_EDCH_F_DPCH_Information_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_F_DPCH_Information },
  { &hf_nbap_multicell_EDCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Multicell_EDCH_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_ConfigurationChange_Info_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_ConfigurationChange_Info_ItemIEs, Additional_EDCH_ConfigurationChange_Info_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_ConfigurationChange_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_Cell_Information_ConfigurationChange_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_ConfigurationChange_Info_ItemIEs },
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_ConfigurationChange_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_Cell_Information_ConfigurationChange_List, Additional_EDCH_Cell_Information_ConfigurationChange_List_sequence_of,
                                                  1, maxNrOfEDCH_1, FALSE);

  return offset;
}


static const value_string nbap_RL_on_Secondary_UL_Frequency_vals[] = {
  {   0, "remove" },
  { 0, NULL }
};


static int
dissect_nbap_RL_on_Secondary_UL_Frequency(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_Removal_Info_ItemIEs_sequence[] = {
  { &hf_nbap_rL_on_Secondary_UL_Frequency, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_on_Secondary_UL_Frequency },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_Removal_Info_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_Cell_Information_Removal_Info_ItemIEs, Additional_EDCH_Cell_Information_Removal_Info_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_Cell_Information_Removal_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_Cell_Information_Removal_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_Cell_Information_Removal_Info_ItemIEs },
};

static int
dissect_nbap_Additional_EDCH_Cell_Information_Removal_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_Cell_Information_Removal_List, Additional_EDCH_Cell_Information_Removal_List_sequence_of,
                                                  1, maxNrOfEDCH_1, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_DL_Control_Channel_Change_Info_ItemIEs_sequence[] = {
  { &hf_nbap_eDCH_Additional_RL_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RL_ID },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_DL_Control_Channel_Change_Info_ItemIEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_DL_Control_Channel_Change_Info_ItemIEs, Additional_EDCH_DL_Control_Channel_Change_Info_ItemIEs_sequence);

  return offset;
}


static const per_sequence_t Additional_EDCH_DL_Control_Channel_Change_Information_List_sequence_of[1] = {
  { &hf_nbap_Additional_EDCH_DL_Control_Channel_Change_Information_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Additional_EDCH_DL_Control_Channel_Change_Info_ItemIEs },
};

static int
dissect_nbap_Additional_EDCH_DL_Control_Channel_Change_Information_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Additional_EDCH_DL_Control_Channel_Change_Information_List, Additional_EDCH_DL_Control_Channel_Change_Information_List_sequence_of,
                                                  1, maxNrOfEDCHRLs, FALSE);

  return offset;
}


static const per_sequence_t Additional_EDCH_FDD_Update_Information_sequence[] = {
  { &hf_nbap_hARQ_Process_Allocation_Scheduled_2ms_EDCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HARQ_Process_Allocation_2ms_EDCH },
  { &hf_nbap_additional_EDCH_DL_Control_Channel_Change_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Additional_EDCH_DL_Control_Channel_Change_Information_List },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Additional_EDCH_FDD_Update_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Additional_EDCH_FDD_Update_Information, Additional_EDCH_FDD_Update_Information_sequence);

  return offset;
}



static int
dissect_nbap_UARFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_TimeSlotLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 6U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Transmitted_Carrier_Power_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_UL_TimeslotISCP_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_nbap_Extension_CommonMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_nbap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string nbap_CommonMeasurementValue_vals[] = {
  {   0, "transmitted-carrier-power" },
  {   1, "received-total-wide-band-power" },
  {   2, "acknowledged-prach-preambles" },
  {   3, "uL-TimeslotISCP" },
  {   4, "notUsed-1-acknowledged-PCPCH-access-preambles" },
  {   5, "notUsed-2-detected-PCPCH-access-preambles" },
  {   6, "extension-CommonMeasurementValue" },
  { 0, NULL }
};

static const per_choice_t CommonMeasurementValue_choice[] = {
  {   0, &hf_nbap_transmitted_carrier_power, ASN1_EXTENSION_ROOT    , dissect_nbap_Transmitted_Carrier_Power_Value },
  {   1, &hf_nbap_received_total_wide_band_power, ASN1_EXTENSION_ROOT    , dissect_nbap_Received_total_wide_band_power_Value },
  {   2, &hf_nbap_acknowledged_prach_preambles, ASN1_EXTENSION_ROOT    , dissect_nbap_Acknowledged_PRACH_preambles_Value },
  {   3, &hf_nbap_uL_TimeslotISCP, ASN1_EXTENSION_ROOT    , dissect_nbap_UL_TimeslotISCP_Value },
  {   4, &hf_nbap_notUsed_1_acknowledged_PCPCH_access_preambles, ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   5, &hf_nbap_notUsed_2_detected_PCPCH_access_preambles, ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   6, &hf_nbap_extension_CommonMeasurementValue, ASN1_NOT_EXTENSION_ROOT, dissect_nbap_Extension_CommonMeasurementValue },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_CommonMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_CommonMeasurementValue, CommonMeasurementValue_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TimeSlotMeasurementValueLCR_sequence[] = {
  { &hf_nbap_timeSlotLCR    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TimeSlotLCR },
  { &hf_nbap_commonMeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonMeasurementValue },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TimeSlotMeasurementValueLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TimeSlotMeasurementValueLCR, TimeSlotMeasurementValueLCR_sequence);

  return offset;
}


static const per_sequence_t TimeSlotMeasurementValueListLCR_sequence_of[1] = {
  { &hf_nbap_TimeSlotMeasurementValueListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_TimeSlotMeasurementValueLCR },
};

static int
dissect_nbap_TimeSlotMeasurementValueListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_TimeSlotMeasurementValueListLCR, TimeSlotMeasurementValueListLCR_sequence_of,
                                                  1, 6, FALSE);

  return offset;
}


static const per_sequence_t AdditionalMeasurementValue_sequence[] = {
  { &hf_nbap_uARFCN         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UARFCN },
  { &hf_nbap_timeSlotMeasurementValueListLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TimeSlotMeasurementValueListLCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_AdditionalMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_AdditionalMeasurementValue, AdditionalMeasurementValue_sequence);

  return offset;
}


static const per_sequence_t AdditionalMeasurementValueList_sequence_of[1] = {
  { &hf_nbap_AdditionalMeasurementValueList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_AdditionalMeasurementValue },
};

static int
dissect_nbap_AdditionalMeasurementValueList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_AdditionalMeasurementValueList, AdditionalMeasurementValueList_sequence_of,
                                                  1, maxFrequencyinCell_1, FALSE);

  return offset;
}


static const per_sequence_t TimeSlot_InitiatedListLCR_sequence_of[1] = {
  { &hf_nbap_TimeSlot_InitiatedListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_TimeSlotLCR },
};

static int
dissect_nbap_TimeSlot_InitiatedListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_TimeSlot_InitiatedListLCR, TimeSlot_InitiatedListLCR_sequence_of,
                                                  0, 6, FALSE);

  return offset;
}


static const per_sequence_t AdditionalTimeSlotLCR_sequence[] = {
  { &hf_nbap_uARFCN         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UARFCN },
  { &hf_nbap_timeslot_InitiatedListLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TimeSlot_InitiatedListLCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_AdditionalTimeSlotLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_AdditionalTimeSlotLCR, AdditionalTimeSlotLCR_sequence);

  return offset;
}


static const per_sequence_t AdditionalTimeSlotListLCR_sequence_of[1] = {
  { &hf_nbap_AdditionalTimeSlotListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_AdditionalTimeSlotLCR },
};

static int
dissect_nbap_AdditionalTimeSlotListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_AdditionalTimeSlotListLCR, AdditionalTimeSlotListLCR_sequence_of,
                                                  0, maxFrequencyinCell_1, FALSE);

  return offset;
}


static const value_string nbap_AddorDeleteIndicator_vals[] = {
  {   0, "add" },
  {   1, "delete" },
  { 0, NULL }
};


static int
dissect_nbap_AddorDeleteIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_CFN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_TGPSID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxTGPS, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_TGPRC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Status_List_item_sequence[] = {
  { &hf_nbap_tGPSID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TGPSID },
  { &hf_nbap_tGPRC          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TGPRC },
  { &hf_nbap_tGCFN          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CFN },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Transmission_Gap_Pattern_Sequence_Status_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Transmission_Gap_Pattern_Sequence_Status_List_item, Transmission_Gap_Pattern_Sequence_Status_List_item_sequence);

  return offset;
}


static const per_sequence_t Transmission_Gap_Pattern_Sequence_Status_List_sequence_of[1] = {
  { &hf_nbap_Transmission_Gap_Pattern_Sequence_Status_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Transmission_Gap_Pattern_Sequence_Status_List_item },
};

static int
dissect_nbap_Transmission_Gap_Pattern_Sequence_Status_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Transmission_Gap_Pattern_Sequence_Status_List, Transmission_Gap_Pattern_Sequence_Status_List_sequence_of,
                                                  0, maxTGPS, FALSE);

  return offset;
}


static const per_sequence_t Active_Pattern_Sequence_Information_sequence[] = {
  { &hf_nbap_cMConfigurationChangeCFN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CFN },
  { &hf_nbap_transmission_Gap_Pattern_Sequence_Status, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Transmission_Gap_Pattern_Sequence_Status_List },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Active_Pattern_Sequence_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Active_Pattern_Sequence_Information, Active_Pattern_Sequence_Information_sequence);

  return offset;
}



static int
dissect_nbap_AICH_Power(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -22, 5U, NULL, FALSE);

  return offset;
}


static const value_string nbap_AICH_TransmissionTiming_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  { 0, NULL }
};


static int
dissect_nbap_AICH_TransmissionTiming(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_PriorityLevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string nbap_Pre_emptionCapability_vals[] = {
  {   0, "shall-not-trigger-pre-emption" },
  {   1, "may-trigger-pre-emption" },
  { 0, NULL }
};


static int
dissect_nbap_Pre_emptionCapability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_Pre_emptionVulnerability_vals[] = {
  {   0, "not-pre-emptable" },
  {   1, "pre-emptable" },
  { 0, NULL }
};


static int
dissect_nbap_Pre_emptionVulnerability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AllocationRetentionPriority_sequence[] = {
  { &hf_nbap_priorityLevel  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PriorityLevel },
  { &hf_nbap_pre_emptionCapability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Pre_emptionCapability },
  { &hf_nbap_pre_emptionVulnerability, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Pre_emptionVulnerability },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_AllocationRetentionPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_AllocationRetentionPriority, AllocationRetentionPriority_sequence);

  return offset;
}


static const value_string nbap_AlternativeFormatReportingIndicator_vals[] = {
  {   0, "alternativeFormatAllowed" },
  { 0, NULL }
};


static int
dissect_nbap_AlternativeFormatReportingIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_AOA_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 719U, NULL, FALSE);

  return offset;
}


static const value_string nbap_AOA_LCR_Accuracy_Class_vals[] = {
  {   0, "a" },
  {   1, "b" },
  {   2, "c" },
  {   3, "d" },
  {   4, "e" },
  {   5, "f" },
  {   6, "g" },
  {   7, "h" },
  { 0, NULL }
};


static int
dissect_nbap_AOA_LCR_Accuracy_Class(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Angle_Of_Arrival_Value_LCR_sequence[] = {
  { &hf_nbap_aOA_LCR        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AOA_LCR },
  { &hf_nbap_aOA_LCR_Accuracy_Class, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AOA_LCR_Accuracy_Class },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Angle_Of_Arrival_Value_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Angle_Of_Arrival_Value_LCR, Angle_Of_Arrival_Value_LCR_sequence);

  return offset;
}


static const value_string nbap_AvailabilityStatus_vals[] = {
  {   0, "empty" },
  {   1, "in-test" },
  {   2, "failed" },
  {   3, "power-off" },
  {   4, "off-line" },
  {   5, "off-duty" },
  {   6, "dependency" },
  {   7, "degraded" },
  {   8, "not-installed" },
  {   9, "log-full" },
  { 0, NULL }
};


static int
dissect_nbap_AvailabilityStatus(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_HSDSCH_RNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2525 "./asn1/nbap/nbap.cnf"
  gint hrnti;
umts_fp_conversation_info_t *umts_fp_conversation_info = NULL;
fp_hsdsch_channel_info_t* fp_hsdsch_channel_info = NULL;
address     null_addr;
conversation_t   *conversation = NULL;
int i;
nbap_hsdsch_channel_info_t* nbap_hsdsch_channel_info;
nbap_hsdsch_channel_info = private_data_get_nbap_hsdsch_channel_info(actx->pinfo);

  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, &hrnti, FALSE);

  private_data_set_hrnti(actx->pinfo, hrnti);

    if (actx->pinfo->fd->flags.visited){
        return offset;
    }

    /*Find the conversations assoicated with the HS-DSCH flows in this packet and set proper H-RNTI*/
    clear_address(&null_addr);
    for (i = 0; i < maxNrOfMACdFlows; i++) {
        if (nbap_hsdsch_channel_info[i].crnc_port != 0){
            conversation = find_conversation(actx->pinfo->num, &(nbap_hsdsch_channel_info[i].crnc_address), &null_addr,
                               ENDPOINT_UDP, nbap_hsdsch_channel_info[i].crnc_port, 0, NO_ADDR_B);
            if(conversation != NULL){
                umts_fp_conversation_info = (umts_fp_conversation_info_t *)conversation_get_proto_data(conversation, proto_fp);
                DISSECTOR_ASSERT(umts_fp_conversation_info != NULL);
                fp_hsdsch_channel_info = (fp_hsdsch_channel_info_t*)umts_fp_conversation_info->channel_specific_info;
                DISSECTOR_ASSERT(fp_hsdsch_channel_info != NULL);
                fp_hsdsch_channel_info->hrnti = private_data_get_hrnti(actx->pinfo);
            }
         }
     }



  return offset;
}


static const per_sequence_t BCCH_Specific_HSDSCH_RNTI_Information_sequence[] = {
  { &hf_nbap_bCCH_Specific_HSDSCH_RNTI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HSDSCH_RNTI },
  { &hf_nbap_hSSCCH_Power   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Power },
  { &hf_nbap_hSPDSCH_Power  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Power },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_BCCH_Specific_HSDSCH_RNTI_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_BCCH_Specific_HSDSCH_RNTI_Information, BCCH_Specific_HSDSCH_RNTI_Information_sequence);

  return offset;
}


static const per_sequence_t BCCH_Specific_HSDSCH_RNTI_InformationLCR_sequence[] = {
  { &hf_nbap_bCCH_Specific_HSDSCH_RNTI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HSDSCH_RNTI },
  { &hf_nbap_hSSCCH_Power   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Power },
  { &hf_nbap_hSPDSCH_Power  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Power },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_BCCH_Specific_HSDSCH_RNTI_InformationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_BCCH_Specific_HSDSCH_RNTI_InformationLCR, BCCH_Specific_HSDSCH_RNTI_InformationLCR_sequence);

  return offset;
}



static int
dissect_nbap_BCCH_ModificationTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_CellPortionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfCellPortionsPerCell_1, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_SIR_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Best_Cell_Portions_Item_sequence[] = {
  { &hf_nbap_cellPortionID  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CellPortionID },
  { &hf_nbap_sIRValue       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_SIR_Value },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Best_Cell_Portions_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Best_Cell_Portions_Item, Best_Cell_Portions_Item_sequence);

  return offset;
}


static const per_sequence_t Best_Cell_Portions_Value_sequence_of[1] = {
  { &hf_nbap_Best_Cell_Portions_Value_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Best_Cell_Portions_Item },
};

static int
dissect_nbap_Best_Cell_Portions_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Best_Cell_Portions_Value, Best_Cell_Portions_Value_sequence_of,
                                                  1, maxNrOfCellPortionsPerCell, FALSE);

  return offset;
}



static int
dissect_nbap_CellPortionLCRID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfCellPortionsPerCellLCR_1, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_RSCP_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Best_Cell_Portions_ItemLCR_sequence[] = {
  { &hf_nbap_cellPortionLCRID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CellPortionLCRID },
  { &hf_nbap_rSCPValue      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RSCP_Value },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Best_Cell_Portions_ItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Best_Cell_Portions_ItemLCR, Best_Cell_Portions_ItemLCR_sequence);

  return offset;
}


static const per_sequence_t Best_Cell_Portions_ValueLCR_sequence_of[1] = {
  { &hf_nbap_Best_Cell_Portions_ValueLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Best_Cell_Portions_ItemLCR },
};

static int
dissect_nbap_Best_Cell_Portions_ValueLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Best_Cell_Portions_ValueLCR, Best_Cell_Portions_ValueLCR_sequence_of,
                                                  1, maxNrOfCellPortionsPerCellLCR, FALSE);

  return offset;
}



static int
dissect_nbap_BetaCD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string nbap_BlockingPriorityIndicator_vals[] = {
  {   0, "high" },
  {   1, "normal" },
  {   2, "low" },
  { 0, NULL }
};


static int
dissect_nbap_BlockingPriorityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_SCTD_Indicator_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_nbap_SCTD_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_BundlingModeIndicator_vals[] = {
  {   0, "bundling" },
  {   1, "no-bundling" },
  { 0, NULL }
};


static int
dissect_nbap_BundlingModeIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_CommonTransportChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 932 "./asn1/nbap/nbap.cnf"
  guint32 commontransportchannelid;
  nbap_dch_channel_info_t* nbap_dch_chnl_info;
  nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &commontransportchannelid, FALSE);

private_data_set_common_transport_channel_id(actx->pinfo, commontransportchannelid);
if(commontransportchannelid<maxNrOfDCHs)
  nbap_dch_chnl_info[commontransportchannelid].next_dch = 0;



  return offset;
}


static const per_sequence_t BroadcastCommonTransportBearerIndication_sequence[] = {
  { &hf_nbap_commonTransportChannelID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonTransportChannelID },
  { &hf_nbap_cid            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_C_ID },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_BroadcastCommonTransportBearerIndication(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_BroadcastCommonTransportBearerIndication, BroadcastCommonTransportBearerIndication_sequence);

  return offset;
}



static int
dissect_nbap_BroadcastReference(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     24, 24, FALSE, NULL, NULL);

  return offset;
}



static int
dissect_nbap_CCTrCH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Cell_Capability_Container(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     128, 128, FALSE, NULL, NULL);

  return offset;
}


static const per_sequence_t Vacant_ERNTI_sequence_of[1] = {
  { &hf_nbap_Vacant_ERNTI_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_E_RNTI },
};

static int
dissect_nbap_Vacant_ERNTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Vacant_ERNTI, Vacant_ERNTI_sequence_of,
                                                  1, maxERNTItoRelease, FALSE);

  return offset;
}


static const per_sequence_t Cell_ERNTI_Status_Information_Item_sequence[] = {
  { &hf_nbap_c_ID           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_C_ID },
  { &hf_nbap_vacant_ERNTI   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Vacant_ERNTI },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Cell_ERNTI_Status_Information_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Cell_ERNTI_Status_Information_Item, Cell_ERNTI_Status_Information_Item_sequence);

  return offset;
}


static const per_sequence_t Cell_ERNTI_Status_Information_sequence_of[1] = {
  { &hf_nbap_Cell_ERNTI_Status_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Cell_ERNTI_Status_Information_Item },
};

static int
dissect_nbap_Cell_ERNTI_Status_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Cell_ERNTI_Status_Information, Cell_ERNTI_Status_Information_sequence_of,
                                                  1, maxCellinNodeB, FALSE);

  return offset;
}



static int
dissect_nbap_CellParameterID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, TRUE);

  return offset;
}


static const value_string nbap_CellPortion_CapabilityLCR_vals[] = {
  {   0, "cell-portion-capable" },
  {   1, "cell-portion-non-capable" },
  { 0, NULL }
};


static int
dissect_nbap_CellPortion_CapabilityLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_CellSyncBurstCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_CellSyncBurstCodeShift(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_CellSyncBurstRepetitionPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_CellSyncBurstSIR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_INTEGER_0_1048575_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_INTEGER_0_255_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, TRUE);

  return offset;
}


static const value_string nbap_CellSyncBurstTiming_vals[] = {
  {   0, "initialPhase" },
  {   1, "steadyStatePhase" },
  { 0, NULL }
};

static const per_choice_t CellSyncBurstTiming_choice[] = {
  {   0, &hf_nbap_initialPhase_0_1048575, ASN1_NO_EXTENSIONS     , dissect_nbap_INTEGER_0_1048575_ },
  {   1, &hf_nbap_steadyStatePhase, ASN1_NO_EXTENSIONS     , dissect_nbap_INTEGER_0_255_ },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_CellSyncBurstTiming(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_CellSyncBurstTiming, CellSyncBurstTiming_choice,
                                 NULL);

  return offset;
}



static int
dissect_nbap_INTEGER_0_524287_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 524287U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_INTEGER_0_127_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, TRUE);

  return offset;
}


static const value_string nbap_CellSyncBurstTimingLCR_vals[] = {
  {   0, "initialPhase" },
  {   1, "steadyStatePhase" },
  { 0, NULL }
};

static const per_choice_t CellSyncBurstTimingLCR_choice[] = {
  {   0, &hf_nbap_initialPhase   , ASN1_NO_EXTENSIONS     , dissect_nbap_INTEGER_0_524287_ },
  {   1, &hf_nbap_steadyStatePhase_01, ASN1_NO_EXTENSIONS     , dissect_nbap_INTEGER_0_127_ },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_CellSyncBurstTimingLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_CellSyncBurstTimingLCR, CellSyncBurstTimingLCR_choice,
                                 NULL);

  return offset;
}



static int
dissect_nbap_CellSyncBurstTimingThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 254U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_ChipOffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 38399U, NULL, FALSE);

  return offset;
}


static const value_string nbap_Closedlooptimingadjustmentmode_vals[] = {
  {   0, "adj-1-slot" },
  {   1, "adj-2-slot" },
  { 0, NULL }
};


static int
dissect_nbap_Closedlooptimingadjustmentmode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_CodeRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_CodeRate_short(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 10U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_INTEGER_0_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CommonChannelsCapacityConsumptionLaw_item_sequence[] = {
  { &hf_nbap_dl_Cost        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_65535 },
  { &hf_nbap_ul_Cost        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_65535 },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CommonChannelsCapacityConsumptionLaw_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CommonChannelsCapacityConsumptionLaw_item, CommonChannelsCapacityConsumptionLaw_item_sequence);

  return offset;
}


static const per_sequence_t CommonChannelsCapacityConsumptionLaw_sequence_of[1] = {
  { &hf_nbap_CommonChannelsCapacityConsumptionLaw_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_CommonChannelsCapacityConsumptionLaw_item },
};

static int
dissect_nbap_CommonChannelsCapacityConsumptionLaw(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_CommonChannelsCapacityConsumptionLaw, CommonChannelsCapacityConsumptionLaw_sequence_of,
                                                  1, maxNrOfSF, FALSE);

  return offset;
}


static const value_string nbap_Common_EDCH_Capability_vals[] = {
  {   0, "common-EDCH-capable" },
  {   1, "common-EDCH-non-capable" },
  { 0, NULL }
};


static int
dissect_nbap_Common_EDCH_Capability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_Common_E_DCH_HSDPCCH_Capability_vals[] = {
  {   0, "hSDPCCH-non-capable" },
  {   1, "aCK-NACK-capable" },
  {   2, "aCK-NACK-CQI-capable" },
  { 0, NULL }
};


static int
dissect_nbap_Common_E_DCH_HSDPCCH_Capability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_DPC_Mode_vals[] = {
  {   0, "mode0" },
  {   1, "mode1" },
  { 0, NULL }
};


static int
dissect_nbap_DPC_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Common_E_DCH_UL_DPCH_InfoItem_sequence[] = {
  { &hf_nbap_uL_SIR_Target  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UL_SIR },
  { &hf_nbap_dPC_Mode       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DPC_Mode },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_UL_DPCH_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_UL_DPCH_InfoItem, Common_E_DCH_UL_DPCH_InfoItem_sequence);

  return offset;
}


static const value_string nbap_Max_Set_E_DPDCHs_vals[] = {
  {   0, "vN256" },
  {   1, "vN128" },
  {   2, "vN64" },
  {   3, "vN32" },
  {   4, "vN16" },
  {   5, "vN8" },
  {   6, "vN4" },
  {   7, "v2xN4" },
  {   8, "v2xN2" },
  {   9, "v2xN2plus2xN4" },
  {  10, "v2xM2plus2xM4" },
  { 0, NULL }
};


static int
dissect_nbap_Max_Set_E_DPDCHs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, TRUE, 1, NULL);

  return offset;
}



static int
dissect_nbap_PunctureLimit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_DCH_TFCI_Table_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_Reference_E_TFCI_PO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfRefETFCI_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}


static const per_sequence_t Reference_E_TFCI_Information_Item_sequence[] = {
  { &hf_nbap_reference_E_TFCI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_TFCI },
  { &hf_nbap_reference_E_TFCI_PO, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Reference_E_TFCI_PO },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Reference_E_TFCI_Information_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Reference_E_TFCI_Information_Item, Reference_E_TFCI_Information_Item_sequence);

  return offset;
}


static const per_sequence_t Reference_E_TFCI_Information_sequence_of[1] = {
  { &hf_nbap_Reference_E_TFCI_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Reference_E_TFCI_Information_Item },
};

static int
dissect_nbap_Reference_E_TFCI_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Reference_E_TFCI_Information, Reference_E_TFCI_Information_sequence_of,
                                                  1, maxNrOfRefETFCIs, FALSE);

  return offset;
}


static const per_sequence_t E_TFCS_Information_sequence[] = {
  { &hf_nbap_e_DCH_TFCI_Table_Index, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_TFCI_Table_Index },
  { &hf_nbap_e_DCH_Min_Set_E_TFCI, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_TFCI },
  { &hf_nbap_reference_E_TFCI_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Reference_E_TFCI_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_TFCS_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_TFCS_Information, E_TFCS_Information_sequence);

  return offset;
}


static const value_string nbap_E_TTI_vals[] = {
  {   0, "e-TTI-2ms" },
  {   1, "e-TTI-10ms" },
  { 0, NULL }
};


static int
dissect_nbap_E_TTI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_E_DPCCH_PO(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDPCCH_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_RGCH_2_IndexStepThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_RGCH_3_IndexStepThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37U, NULL, FALSE);

  return offset;
}


static const value_string nbap_HARQ_Info_for_E_DCH_vals[] = {
  {   0, "rv0" },
  {   1, "rvtable" },
  { 0, NULL }
};


static int
dissect_nbap_HARQ_Info_for_E_DCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Common_E_DCH_EDPCH_InfoItem_sequence[] = {
  { &hf_nbap_maxSet_E_DPDCHs, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Max_Set_E_DPDCHs },
  { &hf_nbap_ul_PunctureLimit, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PunctureLimit },
  { &hf_nbap_e_TFCS_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_TFCS_Information },
  { &hf_nbap_e_TTI          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_TTI },
  { &hf_nbap_e_DPCCH_PO     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DPCCH_PO },
  { &hf_nbap_e_RGCH_2_IndexStepThreshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_RGCH_2_IndexStepThreshold },
  { &hf_nbap_e_RGCH_3_IndexStepThreshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_RGCH_3_IndexStepThreshold },
  { &hf_nbap_hARQ_Info_for_E_DCH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HARQ_Info_for_E_DCH },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_EDPCH_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_EDPCH_InfoItem, Common_E_DCH_EDPCH_InfoItem_sequence);

  return offset;
}



static int
dissect_nbap_E_DCH_Reference_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCH_HARQ_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_DCH_PowerOffset_for_SchedulingInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCH_HARQ_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}


static const value_string nbap_Max_EDCH_Resource_Allocation_for_CCCH_vals[] = {
  {   0, "v8" },
  {   1, "v12" },
  {   2, "v16" },
  {   3, "v24" },
  {   4, "v32" },
  {   5, "v40" },
  {   6, "v80" },
  {   7, "v120" },
  { 0, NULL }
};


static int
dissect_nbap_Max_EDCH_Resource_Allocation_for_CCCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_Max_Period_for_Collistion_Resolution(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            8U, 24U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_INTEGER_0_5000_(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5000U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Max_TB_Sizes_sequence[] = {
  { &hf_nbap_maximum_TB_Size_cell_edge_users, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_5000_ },
  { &hf_nbap_maximum_TB_Size_other_users, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_5000_ },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Max_TB_Sizes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Max_TB_Sizes, Max_TB_Sizes_sequence);

  return offset;
}



static int
dissect_nbap_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t Common_E_DCH_InfoItem_sequence[] = {
  { &hf_nbap_e_DCH_Reference_Power_Offset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_Reference_Power_Offset },
  { &hf_nbap_e_DCH_PowerOffset_for_SchedulingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_PowerOffset_for_SchedulingInfo },
  { &hf_nbap_max_EDCH_Resource_Allocation_for_CCCH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Max_EDCH_Resource_Allocation_for_CCCH },
  { &hf_nbap_max_Period_for_Collistion_Resolution, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Max_Period_for_Collistion_Resolution },
  { &hf_nbap_max_TB_Sizes   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Max_TB_Sizes },
  { &hf_nbap_common_E_DCH_ImplicitRelease_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_BOOLEAN },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_InfoItem, Common_E_DCH_InfoItem_sequence);

  return offset;
}



static int
dissect_nbap_Nack_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, TRUE);

  return offset;
}


static const value_string nbap_CQI_Feedback_Cycle_vals[] = {
  {   0, "v0" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v10" },
  {   5, "v20" },
  {   6, "v40" },
  {   7, "v80" },
  {   8, "v160" },
  {   9, "v16" },
  {  10, "v32" },
  {  11, "v64" },
  { 0, NULL }
};


static int
dissect_nbap_CQI_Feedback_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, TRUE, 3, NULL);

  return offset;
}



static int
dissect_nbap_CQI_RepetitionFactor(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_CQI_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_Measurement_Power_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -12, 26U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Common_E_DCH_CQI_Info_sequence[] = {
  { &hf_nbap_cqiFeedback_CycleK, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CQI_Feedback_Cycle },
  { &hf_nbap_cqiRepetitionFactor, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_CQI_RepetitionFactor },
  { &hf_nbap_cqiPowerOffset , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CQI_Power_Offset },
  { &hf_nbap_measurement_Power_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Measurement_Power_Offset },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_CQI_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_CQI_Info, Common_E_DCH_CQI_Info_sequence);

  return offset;
}


static const per_sequence_t Common_E_DCH_HSDPCCH_InfoItem_sequence[] = {
  { &hf_nbap_ackNackRepetitionFactor, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AckNack_RepetitionFactor },
  { &hf_nbap_ackPowerOffset , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Ack_Power_Offset },
  { &hf_nbap_nackPowerOffset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Nack_Power_Offset },
  { &hf_nbap_common_E_DCH_CQI_Info, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_CQI_Info },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_HSDPCCH_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_HSDPCCH_InfoItem, Common_E_DCH_HSDPCCH_InfoItem_sequence);

  return offset;
}



static int
dissect_nbap_CommonPhysicalChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 923 "./asn1/nbap/nbap.cnf"
guint32 commonphysicalchannelid;
nbap_dch_channel_info_t* nbap_dch_chnl_info;
nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &commonphysicalchannelid, FALSE);

private_data_set_common_physical_channel_id(actx->pinfo, commonphysicalchannelid);
if(commonphysicalchannelid<maxNrOfDCHs)
  nbap_dch_chnl_info[commonphysicalchannelid].next_dch = 0;



  return offset;
}



static int
dissect_nbap_PreambleSignatures(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, NULL);

  return offset;
}



static int
dissect_nbap_ScramblingCodeNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_PreambleThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 72U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_AI_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const value_string nbap_STTD_Indicator_vals[] = {
  {   0, "active" },
  {   1, "inactive" },
  { 0, NULL }
};


static int
dissect_nbap_STTD_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Common_E_DCH_AICH_Information_sequence[] = {
  { &hf_nbap_commonPhysicalChannelID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonPhysicalChannelID },
  { &hf_nbap_aICH_TransmissionTiming, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AICH_TransmissionTiming },
  { &hf_nbap_fdd_dl_ChannelisationCodeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_DL_ChannelisationCodeNumber },
  { &hf_nbap_aICH_Power     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AICH_Power },
  { &hf_nbap_sTTD_Indicator , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_STTD_Indicator },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_AICH_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_AICH_Information, Common_E_DCH_AICH_Information_sequence);

  return offset;
}


static const per_sequence_t Common_E_DCH_Preamble_Control_InfoItem_sequence[] = {
  { &hf_nbap_commonPhysicalChannelID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonPhysicalChannelID },
  { &hf_nbap_common_E_DCH_PreambleSignatures, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PreambleSignatures },
  { &hf_nbap_scramblingCodeNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ScramblingCodeNumber },
  { &hf_nbap_preambleThreshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PreambleThreshold },
  { &hf_nbap_e_AI_Indicator , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_AI_Indicator },
  { &hf_nbap_common_E_DCH_AICH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_AICH_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_Preamble_Control_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_Preamble_Control_InfoItem, Common_E_DCH_Preamble_Control_InfoItem_sequence);

  return offset;
}


static const per_sequence_t Common_E_DCH_FDPCH_InfoItem_sequence[] = {
  { &hf_nbap_f_DPCH_SlotFormat, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_F_DPCH_SlotFormat },
  { &hf_nbap_fdd_TPC_DownlinkStepSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_TPC_DownlinkStepSize },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_FDPCH_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_FDPCH_InfoItem, Common_E_DCH_FDPCH_InfoItem_sequence);

  return offset;
}



static int
dissect_nbap_Soffset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Common_E_DCH_Resource_Combination_InfoList_Item_sequence[] = {
  { &hf_nbap_soffset        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Soffset },
  { &hf_nbap_f_DPCH_DL_Code_Number, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_DL_ChannelisationCodeNumber },
  { &hf_nbap_ul_DPCH_ScramblingCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UL_ScramblingCode },
  { &hf_nbap_e_RGCH_E_HICH_Channelisation_Code, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_DL_ChannelisationCodeNumber },
  { &hf_nbap_e_RGCH_Signature_Sequence, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_RGCH_Signature_Sequence },
  { &hf_nbap_e_HICH_Signature_Sequence, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_HICH_Signature_Sequence },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_Resource_Combination_InfoList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_Resource_Combination_InfoList_Item, Common_E_DCH_Resource_Combination_InfoList_Item_sequence);

  return offset;
}


static const per_sequence_t Common_E_DCH_Resource_Combination_InfoList_sequence_of[1] = {
  { &hf_nbap_Common_E_DCH_Resource_Combination_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_DCH_Resource_Combination_InfoList_Item },
};

static int
dissect_nbap_Common_E_DCH_Resource_Combination_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_E_DCH_Resource_Combination_InfoList, Common_E_DCH_Resource_Combination_InfoList_sequence_of,
                                                  1, maxNrOfCommonEDCH, FALSE);

  return offset;
}



static int
dissect_nbap_Common_MACFlow_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2359 "./asn1/nbap/nbap.cnf"
guint32 common_macdflow_id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfCommonMACFlows_1, &common_macdflow_id, FALSE);

private_data_set_common_macdflow_id(actx->pinfo, common_macdflow_id);


/*hsdsch_macdflow_ids[private_data_get_num_items(actx->pinfo)-1] = private_data_get_hsdsch_macdflow_id(actx->pinfo);*/
/*THIS STUFF IST NOT DONE YET!*/


  return offset;
}


static const value_string nbap_TransportBearerRequestIndicator_vals[] = {
  {   0, "bearerRequested" },
  {   1, "bearerNotRequested" },
  { 0, NULL }
};


static int
dissect_nbap_TransportBearerRequestIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_DsField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, NULL);

  return offset;
}



static int
dissect_nbap_GenericTrafficCategory(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, NULL);

  return offset;
}


static const value_string nbap_TnlQos_vals[] = {
  {   0, "dsField" },
  {   1, "genericTrafficCategory" },
  { 0, NULL }
};

static const per_choice_t TnlQos_choice[] = {
  {   0, &hf_nbap_dsField        , ASN1_EXTENSION_ROOT    , dissect_nbap_DsField },
  {   1, &hf_nbap_genericTrafficCategory, ASN1_EXTENSION_ROOT    , dissect_nbap_GenericTrafficCategory },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_TnlQos(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_TnlQos, TnlQos_choice,
                                 NULL);

  return offset;
}


static const value_string nbap_PayloadCRC_PresenceIndicator_vals[] = {
  {   0, "cRC-Included" },
  {   1, "cRC-NotIncluded" },
  { 0, NULL }
};


static int
dissect_nbap_PayloadCRC_PresenceIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 884 "./asn1/nbap/nbap.cnf"
guint32 payload_crc_value;

  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, &payload_crc_value, TRUE, 0, NULL);


    if(payload_crc_value == 0){
        private_data_set_dch_crc_present(actx->pinfo, TRUE);
    }else{
        private_data_set_dch_crc_present(actx->pinfo, FALSE);
    }



  return offset;
}



static int
dissect_nbap_Maximum_Number_of_Retransmissions_For_E_DCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_DCH_HARQ_PO_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCH_HARQ_PO_QUANTSTEPs, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_DCH_MACdFlow_Multiplexing_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     maxNrOfEDCHMACdFlows, maxNrOfEDCHMACdFlows, FALSE, NULL, NULL);

  return offset;
}



static int
dissect_nbap_LogicalChannelID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1972 "./asn1/nbap/nbap.cnf"
  guint32 logical_channel_id;
  guint num_items;
  nbap_edch_channel_info_t* nbap_edch_channel_info;
  nbap_edch_channel_info = private_data_get_nbap_edch_channel_info(actx->pinfo);
  /* Set logical channel id for this entry*/
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 15U, &logical_channel_id, FALSE);


    private_data_set_logical_channel_id(actx->pinfo, logical_channel_id);
    num_items = private_data_get_num_items(actx->pinfo);
    if(num_items>0)
        nbap_edch_channel_info[private_data_get_e_dch_macdflow_id(actx->pinfo)].lchId[num_items-1] = private_data_get_logical_channel_id(actx->pinfo);



  return offset;
}



static int
dissect_nbap_MAC_PDU_SizeExtended(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2090 "./asn1/nbap/nbap.cnf"
guint32 hsdsch_macdflow_id;
nbap_hsdsch_channel_info_t* nbap_hsdsch_channel_info;
nbap_hsdsch_channel_info = private_data_get_nbap_hsdsch_channel_info(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1504U, NULL, TRUE);

    hsdsch_macdflow_id = private_data_get_hsdsch_macdflow_id(actx->pinfo);
    if(nbap_hsdsch_channel_info[hsdsch_macdflow_id].crnc_port != 0){
            nbap_hsdsch_channel_info[hsdsch_macdflow_id].entity = ehs;
    }




  return offset;
}


static const per_sequence_t Common_E_DCH_LogicalChannel_InfoList_Item_sequence[] = {
  { &hf_nbap_logicalChannelId, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_LogicalChannelID },
  { &hf_nbap_maximumMACcPDU_SizeExtended, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_PDU_SizeExtended },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_LogicalChannel_InfoList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_LogicalChannel_InfoList_Item, Common_E_DCH_LogicalChannel_InfoList_Item_sequence);

  return offset;
}


static const per_sequence_t Common_E_DCH_LogicalChannel_InfoList_sequence_of[1] = {
  { &hf_nbap_Common_E_DCH_LogicalChannel_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_DCH_LogicalChannel_InfoList_Item },
};

static int
dissect_nbap_Common_E_DCH_LogicalChannel_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_E_DCH_LogicalChannel_InfoList, Common_E_DCH_LogicalChannel_InfoList_sequence_of,
                                                  1, maxNoOfLogicalChannels, FALSE);

  return offset;
}


static const per_sequence_t Common_E_DCH_MACdFlow_Specific_InfoList_Item_sequence[] = {
  { &hf_nbap_common_e_DCH_MACdFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_MACdFlow_ID },
  { &hf_nbap_maximum_Number_of_Retransmissions_For_E_DCH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Maximum_Number_of_Retransmissions_For_E_DCH },
  { &hf_nbap_eDCH_HARQ_PO_FDD, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_HARQ_PO_FDD },
  { &hf_nbap_eDCH_MACdFlow_Multiplexing_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_MACdFlow_Multiplexing_List },
  { &hf_nbap_common_E_DCHLogicalChannelInformation, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_DCH_LogicalChannel_InfoList },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_Item, Common_E_DCH_MACdFlow_Specific_InfoList_Item_sequence);

  return offset;
}


static const per_sequence_t Common_E_DCH_MACdFlow_Specific_InfoList_sequence_of[1] = {
  { &hf_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_Item },
};

static int
dissect_nbap_Common_E_DCH_MACdFlow_Specific_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_E_DCH_MACdFlow_Specific_InfoList, Common_E_DCH_MACdFlow_Specific_InfoList_sequence_of,
                                                  1, maxNrOfEDCHMACdFlows, FALSE);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoList_Item_sequence[] = {
  { &hf_nbap_ul_Common_MACFlowID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID },
  { &hf_nbap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportBearerRequestIndicator },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_tnlQos         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TnlQos },
  { &hf_nbap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PayloadCRC_PresenceIndicator },
  { &hf_nbap_bundlingModeIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BundlingModeIndicator },
  { &hf_nbap_common_E_DCH_MACdFlow_Specific_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_DCH_MACdFlow_Specific_InfoList },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_Item, Ul_common_E_DCH_MACflow_Specific_InfoList_Item_sequence);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoList_sequence_of[1] = {
  { &hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_Item },
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList, Ul_common_E_DCH_MACflow_Specific_InfoList_sequence_of,
                                                  1, maxNrOfCommonMACFlows, FALSE);

  return offset;
}


static const per_sequence_t Common_EDCH_System_InformationFDD_sequence[] = {
  { &hf_nbap_common_E_DCH_UL_DPCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_UL_DPCH_InfoItem },
  { &hf_nbap_common_E_DCH_EDPCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_EDPCH_InfoItem },
  { &hf_nbap_common_E_DCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_InfoItem },
  { &hf_nbap_common_E_DCH_HSDPCCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_HSDPCCH_InfoItem },
  { &hf_nbap_common_E_DCH_Preamble_Control_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_Preamble_Control_InfoItem },
  { &hf_nbap_common_E_DCH_FDPCH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_FDPCH_InfoItem },
  { &hf_nbap_common_E_DCH_E_AGCH_ChannelisationCodeNumber, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_FDD_DL_ChannelisationCodeNumber },
  { &hf_nbap_common_E_DCH_Resource_Combination_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_Resource_Combination_InfoList },
  { &hf_nbap_ul_common_E_DCH_MACflow_Specific_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_EDCH_System_InformationFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_EDCH_System_InformationFDD, Common_EDCH_System_InformationFDD_sequence);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoResponseList_Item_sequence[] = {
  { &hf_nbap_ul_Common_MACFlowID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_Item, Ul_common_E_DCH_MACflow_Specific_InfoResponseList_Item_sequence);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoResponseList_sequence_of[1] = {
  { &hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_Item },
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList, Ul_common_E_DCH_MACflow_Specific_InfoResponseList_sequence_of,
                                                  1, maxNrOfCommonMACFlows, FALSE);

  return offset;
}


static const per_sequence_t Common_EDCH_System_Information_ResponseFDD_sequence[] = {
  { &hf_nbap_ul_common_E_DCH_MACflow_Specific_InfoResponse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList },
  { &hf_nbap_serving_Grant_Value, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_Serving_Grant_Value },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_EDCH_System_Information_ResponseFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_EDCH_System_Information_ResponseFDD, Common_EDCH_System_Information_ResponseFDD_sequence);

  return offset;
}


static const per_sequence_t E_RNTI_List_sequence_of[1] = {
  { &hf_nbap_E_RNTI_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_E_RNTI },
};

static int
dissect_nbap_E_RNTI_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_E_RNTI_List, E_RNTI_List_sequence_of,
                                                  1, maxofERNTI, FALSE);

  return offset;
}


static const per_sequence_t Common_MACFlows_to_DeleteFDD_Item_sequence[] = {
  { &hf_nbap_common_MACFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_MACFlows_to_DeleteFDD_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_MACFlows_to_DeleteFDD_Item, Common_MACFlows_to_DeleteFDD_Item_sequence);

  return offset;
}


static const per_sequence_t Common_MACFlows_to_DeleteFDD_sequence_of[1] = {
  { &hf_nbap_Common_MACFlows_to_DeleteFDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlows_to_DeleteFDD_Item },
};

static int
dissect_nbap_Common_MACFlows_to_DeleteFDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_MACFlows_to_DeleteFDD, Common_MACFlows_to_DeleteFDD_sequence_of,
                                                  1, maxNrOfCommonMACFlows, FALSE);

  return offset;
}



static int
dissect_nbap_PriorityQueue_Id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfPriorityQueues_1, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_SchedulingPriorityIndicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string nbap_T1_vals[] = {
  {   0, "v10" },
  {   1, "v20" },
  {   2, "v30" },
  {   3, "v40" },
  {   4, "v50" },
  {   5, "v60" },
  {   6, "v70" },
  {   7, "v80" },
  {   8, "v90" },
  {   9, "v100" },
  {  10, "v120" },
  {  11, "v140" },
  {  12, "v160" },
  {  13, "v200" },
  {  14, "v300" },
  {  15, "v400" },
  { 0, NULL }
};


static int
dissect_nbap_T1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     16, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_MAC_ehs_Reset_Timer_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v3" },
  {   3, "v4" },
  { 0, NULL }
};


static int
dissect_nbap_MAC_ehs_Reset_Timer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_DiscardTimer_vals[] = {
  {   0, "v20" },
  {   1, "v40" },
  {   2, "v60" },
  {   3, "v80" },
  {   4, "v100" },
  {   5, "v120" },
  {   6, "v140" },
  {   7, "v160" },
  {   8, "v180" },
  {   9, "v200" },
  {  10, "v250" },
  {  11, "v300" },
  {  12, "v400" },
  {  13, "v500" },
  {  14, "v750" },
  {  15, "v1000" },
  {  16, "v1250" },
  {  17, "v1500" },
  {  18, "v1750" },
  {  19, "v2000" },
  {  20, "v2500" },
  {  21, "v3000" },
  {  22, "v3500" },
  {  23, "v4000" },
  {  24, "v4500" },
  {  25, "v5000" },
  {  26, "v7500" },
  { 0, NULL }
};

static value_string_ext nbap_DiscardTimer_vals_ext = VALUE_STRING_EXT_INIT(nbap_DiscardTimer_vals);


static int
dissect_nbap_DiscardTimer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     27, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_MAC_hsWindowSize_vals[] = {
  {   0, "v4" },
  {   1, "v6" },
  {   2, "v8" },
  {   3, "v12" },
  {   4, "v16" },
  {   5, "v24" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  { 0, NULL }
};


static int
dissect_nbap_MAC_hsWindowSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 2, NULL);

  return offset;
}


static const per_sequence_t Priority_Queue_Information_for_Enhanced_FACH_PCH_sequence[] = {
  { &hf_nbap_priorityQueue_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PriorityQueue_Id },
  { &hf_nbap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_SchedulingPriorityIndicator },
  { &hf_nbap_t1             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_T1 },
  { &hf_nbap_mAC_ehs_Reset_Timer, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_ehs_Reset_Timer },
  { &hf_nbap_discardTimer   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DiscardTimer },
  { &hf_nbap_mAC_hsWindowSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_hsWindowSize },
  { &hf_nbap_maximum_MACcPDU_Size, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_PDU_SizeExtended },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Priority_Queue_Information_for_Enhanced_FACH_PCH(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Priority_Queue_Information_for_Enhanced_FACH_PCH, Priority_Queue_Information_for_Enhanced_FACH_PCH_sequence);

  return offset;
}


static const per_sequence_t Common_MACFlow_PriorityQueue_Item_sequence[] = {
  { &hf_nbap_priority_Queue_Information_for_Enhanced_FACH, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Priority_Queue_Information_for_Enhanced_FACH_PCH },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_MACFlow_PriorityQueue_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_MACFlow_PriorityQueue_Item, Common_MACFlow_PriorityQueue_Item_sequence);

  return offset;
}


static const per_sequence_t Common_MACFlow_PriorityQueue_Information_sequence_of[1] = {
  { &hf_nbap_Common_MACFlow_PriorityQueue_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_PriorityQueue_Item },
};

static int
dissect_nbap_Common_MACFlow_PriorityQueue_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_MACFlow_PriorityQueue_Information, Common_MACFlow_PriorityQueue_Information_sequence_of,
                                                  1, maxNrOfcommonMACQueues, FALSE);

  return offset;
}


static const per_sequence_t CommonMACFlow_Specific_InfoItem_sequence[] = {
  { &hf_nbap_common_MACFlow_Id, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_tnl_qos        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TnlQos },
  { &hf_nbap_common_MACFlow_PriorityQueue_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_MACFlow_PriorityQueue_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CommonMACFlow_Specific_InfoItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2367 "./asn1/nbap/nbap.cnf"
    address     dst_addr;
    guint32 transportLayerAddress_ipv4;
    guint16 bindingID;
    guint32 common_macdflow_id;
    private_data_set_transportLayerAddress_ipv4(actx->pinfo, 0);
    private_data_set_binding_id_port(actx->pinfo, 0);
    private_data_increment_num_items(actx->pinfo);
    nbap_common_channel_info_t* nbap_common_channel_info;
    nbap_common_channel_info = private_data_get_nbap_common_channel_info(actx->pinfo);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CommonMACFlow_Specific_InfoItem, CommonMACFlow_Specific_InfoItem_sequence);


    transportLayerAddress_ipv4 = private_data_get_transportLayerAddress_ipv4(actx->pinfo);
    bindingID = private_data_get_binding_id_port(actx->pinfo);
    if (actx->pinfo->fd->flags.visited || transportLayerAddress_ipv4 == 0 || bindingID == 0){
        return offset;
    }

    set_address(&dst_addr, AT_IPv4, 4, &transportLayerAddress_ipv4);

    /* Set address for collection of common entries */
    common_macdflow_id = private_data_get_common_macdflow_id(actx->pinfo);
    copy_address_wmem(actx->pinfo->pool,&(nbap_common_channel_info[common_macdflow_id].crnc_address),&dst_addr);
    nbap_common_channel_info[common_macdflow_id].crnc_port = private_data_get_binding_id_port(actx->pinfo);




  return offset;
}


static const per_sequence_t CommonMACFlow_Specific_InfoList_sequence_of[1] = {
  { &hf_nbap_CommonMACFlow_Specific_InfoList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_CommonMACFlow_Specific_InfoItem },
};

static int
dissect_nbap_CommonMACFlow_Specific_InfoList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_CommonMACFlow_Specific_InfoList, CommonMACFlow_Specific_InfoList_sequence_of,
                                                  1, maxNrOfCommonMACFlows, FALSE);

  return offset;
}



static int
dissect_nbap_MACdPDU_Size(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1956 "./asn1/nbap/nbap.cnf"
guint32 mac_d_pdu_size;
guint num_items;
nbap_edch_channel_info_t* nbap_edch_channel_info;
nbap_edch_channel_info = private_data_get_nbap_edch_channel_info(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 5000U, &mac_d_pdu_size, TRUE);


    private_data_set_mac_d_pdu_size(actx->pinfo, mac_d_pdu_size);
    if (actx->pinfo->fd->flags.visited)
    {
        return offset;
    }
    num_items = private_data_get_num_items(actx->pinfo);
    if(num_items>0)
        nbap_edch_channel_info[private_data_get_e_dch_macdflow_id(actx->pinfo)].edch_macd_pdu_size[num_items-1] = private_data_get_mac_d_pdu_size(actx->pinfo);



  return offset;
}



static int
dissect_nbap_HSDSCH_InitialWindowSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t HSDSCH_Initial_Capacity_AllocationItem_sequence[] = {
  { &hf_nbap_schedulingPriorityIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_SchedulingPriorityIndicator },
  { &hf_nbap_maximum_MACdPDU_Size, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MACdPDU_Size },
  { &hf_nbap_hSDSCH_InitialWindowSize, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HSDSCH_InitialWindowSize },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_HSDSCH_Initial_Capacity_AllocationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_HSDSCH_Initial_Capacity_AllocationItem, HSDSCH_Initial_Capacity_AllocationItem_sequence);

  return offset;
}


static const per_sequence_t HSDSCH_Initial_Capacity_Allocation_sequence_of[1] = {
  { &hf_nbap_HSDSCH_Initial_Capacity_Allocation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_HSDSCH_Initial_Capacity_AllocationItem },
};

static int
dissect_nbap_HSDSCH_Initial_Capacity_Allocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_HSDSCH_Initial_Capacity_Allocation, HSDSCH_Initial_Capacity_Allocation_sequence_of,
                                                  1, maxNrOfPriorityQueues, FALSE);

  return offset;
}


static const per_sequence_t CommonMACFlow_Specific_InfoItem_Response_sequence[] = {
  { &hf_nbap_commonMACFlow_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_hSDSCH_Initial_Capacity_Allocation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HSDSCH_Initial_Capacity_Allocation },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CommonMACFlow_Specific_InfoItem_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CommonMACFlow_Specific_InfoItem_Response, CommonMACFlow_Specific_InfoItem_Response_sequence);

  return offset;
}


static const per_sequence_t CommonMACFlow_Specific_InfoList_Response_sequence_of[1] = {
  { &hf_nbap_CommonMACFlow_Specific_InfoList_Response_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_CommonMACFlow_Specific_InfoItem_Response },
};

static int
dissect_nbap_CommonMACFlow_Specific_InfoList_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_CommonMACFlow_Specific_InfoList_Response, CommonMACFlow_Specific_InfoList_Response_sequence_of,
                                                  1, maxNrOfCommonMACFlows, FALSE);

  return offset;
}


static const value_string nbap_TUTRANGPSAccuracyClass_vals[] = {
  {   0, "accuracy-class-A" },
  {   1, "accuracy-class-B" },
  {   2, "accuracy-class-C" },
  { 0, NULL }
};


static int
dissect_nbap_TUTRANGPSAccuracyClass(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_TUTRANGANSSAccuracyClass_vals[] = {
  {   0, "ganssAccuracy-class-A" },
  {   1, "ganssAccuracy-class-B" },
  {   2, "ganssAccuracy-class-C" },
  { 0, NULL }
};


static int
dissect_nbap_TUTRANGANSSAccuracyClass(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_CommonMeasurementAccuracy_vals[] = {
  {   0, "tUTRANGPSMeasurementAccuracyClass" },
  {   1, "tUTRANGANSSMeasurementAccuracyClass" },
  { 0, NULL }
};

static const per_choice_t CommonMeasurementAccuracy_choice[] = {
  {   0, &hf_nbap_tUTRANGPSMeasurementAccuracyClass, ASN1_EXTENSION_ROOT    , dissect_nbap_TUTRANGPSAccuracyClass },
  {   1, &hf_nbap_tUTRANGANSSMeasurementAccuracyClass, ASN1_NOT_EXTENSION_ROOT, dissect_nbap_TUTRANGANSSAccuracyClass },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_CommonMeasurementAccuracy(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_CommonMeasurementAccuracy, CommonMeasurementAccuracy_choice,
                                 NULL);

  return offset;
}


static const value_string nbap_CommonMeasurementType_vals[] = {
  {   0, "received-total-wide-band-power" },
  {   1, "transmitted-carrier-power" },
  {   2, "acknowledged-prach-preambles" },
  {   3, "ul-timeslot-iscp" },
  {   4, "notUsed-1-acknowledged-PCPCH-access-preambles" },
  {   5, "notUsed-2-detected-PCPCH-access-preambles" },
  {   6, "uTRAN-GPS-Timing-of-Cell-Frames-for-UE-Positioning" },
  {   7, "sFN-SFN-Observed-Time-Difference" },
  {   8, "transmittedCarrierPowerOfAllCodesNotUsedForHSTransmission" },
  {   9, "hS-DSCH-Required-Power" },
  {  10, "hS-DSCH-Provided-Bit-Rate" },
  {  11, "received-total-wide-band-power-for-cellPortion" },
  {  12, "transmitted-carrier-power-for-cellPortion" },
  {  13, "transmittedCarrierPowerOfAllCodesNotUsedForHS-PDSCH-HS-SCCH-E-AGCH-E-RGCHOrE-HICHTransmission-for-cellPortion" },
  {  14, "upPTS-Interference" },
  {  15, "dLTransmissionBranchLoad" },
  {  16, "hS-DSCH-Required-Power-for-cell-portion" },
  {  17, "hS-DSCH-Provided-Bit-Rate-for-cell-portion" },
  {  18, "e-DCH-Provided-Bit-Rate" },
  {  19, "e-DCH-Non-serving-Relative-Grant-Down-Commands" },
  {  20, "received-Scheduled-EDCH-Power-Share" },
  {  21, "received-Scheduled-EDCH-Power-Share-for-cellPortion" },
  {  22, "uTRAN-GANSS-timing-of-cell-frames-for-UE-Positioning" },
  {  23, "eDCH-RACH-report" },
  {  24, "transmittedCarrierPowerOfAllCodesNotUsedForHS-PDSCH-HS-SCCH-E-AGCHOrE-HICHTransmission-for-cellPortion" },
  {  25, "ul-timeslot-iscp-for-cellPortion" },
  {  26, "upPTS-Interference-for-cellPortion" },
  {  27, "e-DCH-Provided-Bit-Rate-for-cellPortion" },
  { 0, NULL }
};

static value_string_ext nbap_CommonMeasurementType_vals_ext = VALUE_STRING_EXT_INIT(nbap_CommonMeasurementType_vals);


static int
dissect_nbap_CommonMeasurementType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 22, NULL);

  return offset;
}


static const per_sequence_t CommonMeasurementAvailable_sequence[] = {
  { &hf_nbap_commonmeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonMeasurementValue },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CommonMeasurementAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CommonMeasurementAvailable, CommonMeasurementAvailable_sequence);

  return offset;
}



static int
dissect_nbap_CommonMeasurementnotAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string nbap_CommonMeasurementValueInformation_vals[] = {
  {   0, "measurementAvailable" },
  {   1, "measurementnotAvailable" },
  { 0, NULL }
};

static const per_choice_t CommonMeasurementValueInformation_choice[] = {
  {   0, &hf_nbap_measurementAvailable, ASN1_NO_EXTENSIONS     , dissect_nbap_CommonMeasurementAvailable },
  {   1, &hf_nbap_measurementnotAvailable, ASN1_NO_EXTENSIONS     , dissect_nbap_CommonMeasurementnotAvailable },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_CommonMeasurementValueInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_CommonMeasurementValueInformation, CommonMeasurementValueInformation_choice,
                                 NULL);

  return offset;
}



static int
dissect_nbap_CommonPhysicalChannelID768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const value_string nbap_ResourceOperationalState_vals[] = {
  {   0, "enabled" },
  {   1, "disabled" },
  { 0, NULL }
};


static int
dissect_nbap_ResourceOperationalState(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Common_PhysicalChannel_Status_Information_sequence[] = {
  { &hf_nbap_commonPhysicalChannelID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonPhysicalChannelID },
  { &hf_nbap_resourceOperationalState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ResourceOperationalState },
  { &hf_nbap_availabilityStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AvailabilityStatus },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_PhysicalChannel_Status_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_PhysicalChannel_Status_Information, Common_PhysicalChannel_Status_Information_sequence);

  return offset;
}


static const per_sequence_t Common_PhysicalChannel_Status_Information768_sequence[] = {
  { &hf_nbap_commonPhysicalChannelID768, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonPhysicalChannelID768 },
  { &hf_nbap_resourceOperationalState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ResourceOperationalState },
  { &hf_nbap_availabilityStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AvailabilityStatus },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_PhysicalChannel_Status_Information768(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_PhysicalChannel_Status_Information768, Common_PhysicalChannel_Status_Information768_sequence);

  return offset;
}


static const per_sequence_t CommonTransportChannel_InformationResponse_sequence[] = {
  { &hf_nbap_commonTransportChannelID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonTransportChannelID },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CommonTransportChannel_InformationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 184 "./asn1/nbap/nbap.cnf"
address dst_addr;
nbap_setup_conv_t *request_conv;
conversation_t *conv;
guint32 transportLayerAddress_ipv4;
guint16 bindingID;

nbap_debug("Frame %u CommonTransportChannel-InformationResponse Start", actx->pinfo->num);

private_data_set_transportLayerAddress_ipv4(actx->pinfo, 0);
private_data_set_binding_id_port(actx->pinfo, 0);

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CommonTransportChannel_InformationResponse, CommonTransportChannel_InformationResponse_sequence);


  transportLayerAddress_ipv4 = private_data_get_transportLayerAddress_ipv4(actx->pinfo);
  bindingID = private_data_get_binding_id_port(actx->pinfo);
  if (actx->pinfo->fd->flags.visited || transportLayerAddress_ipv4 == 0 || bindingID == 0){
    return offset;
  }

  set_address(&dst_addr, AT_IPv4, 4, &transportLayerAddress_ipv4);

  request_conv = find_setup_conv(private_data_get_transaction_id(actx->pinfo),private_data_get_dd_mode(actx->pinfo),private_data_get_common_transport_channel_id(actx->pinfo));

  if(request_conv == NULL){
    return offset;
  }

  conv = request_conv->conv;
  conversation_set_addr2(conv, &dst_addr);
  conversation_set_port2(conv, bindingID);

  delete_setup_conv(request_conv);
  nbap_debug("    Frame %u conversation setup frame: %u %s:%u -> %s:%u", actx->pinfo->num, conv->setup_frame,
            address_to_str(wmem_packet_scope(), &conv->key_ptr->addr1), conv->key_ptr->port1,
            address_to_str(wmem_packet_scope(), &conv->key_ptr->addr2), conv->key_ptr->port2);

  nbap_debug("Frame %u CommonTransportChannel-InformationResponse End", actx->pinfo->num);




  return offset;
}


static const per_sequence_t Common_TransportChannel_Status_Information_sequence[] = {
  { &hf_nbap_commonTransportChannelID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CommonTransportChannelID },
  { &hf_nbap_resourceOperationalState, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ResourceOperationalState },
  { &hf_nbap_availabilityStatus, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AvailabilityStatus },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_TransportChannel_Status_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_TransportChannel_Status_Information, Common_TransportChannel_Status_Information_sequence);

  return offset;
}



static int
dissect_nbap_CommunicationControlPortID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}


static const value_string nbap_Compressed_Mode_Deactivation_Flag_vals[] = {
  {   0, "deactivate" },
  {   1, "maintain-Active" },
  { 0, NULL }
};


static int
dissect_nbap_Compressed_Mode_Deactivation_Flag(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_ConfigurationGenerationID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_ConstantValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -10, 10U, NULL, TRUE);

  return offset;
}


static const value_string nbap_ContinuousPacketConnectivityDTX_DRX_Capability_vals[] = {
  {   0, "continuous-Packet-Connectivity-DTX-DRX-capable" },
  {   1, "continuous-Packet-Connectivity-DTX-DRX-non-capable" },
  { 0, NULL }
};


static int
dissect_nbap_ContinuousPacketConnectivityDTX_DRX_Capability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_UE_DTX_DRX_Offset(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 159U, NULL, FALSE);

  return offset;
}


static const value_string nbap_Enabling_Delay_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  {   2, "v2" },
  {   3, "v4" },
  {   4, "v8" },
  {   5, "v16" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  { 0, NULL }
};


static int
dissect_nbap_Enabling_Delay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_UE_DTX_Cycle1_2ms_vals[] = {
  {   0, "v1" },
  {   1, "v4" },
  {   2, "v5" },
  {   3, "v8" },
  {   4, "v10" },
  {   5, "v16" },
  {   6, "v20" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DTX_Cycle1_2ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_UE_DTX_Cycle2_2ms_vals[] = {
  {   0, "v4" },
  {   1, "v5" },
  {   2, "v8" },
  {   3, "v10" },
  {   4, "v16" },
  {   5, "v20" },
  {   6, "v32" },
  {   7, "v40" },
  {   8, "v64" },
  {   9, "v80" },
  {  10, "v128" },
  {  11, "v160" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DTX_Cycle2_2ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_MAC_DTX_Cycle_2ms_vals[] = {
  {   0, "v1" },
  {   1, "v4" },
  {   2, "v5" },
  {   3, "v8" },
  {   4, "v10" },
  {   5, "v16" },
  {   6, "v20" },
  { 0, NULL }
};


static int
dissect_nbap_MAC_DTX_Cycle_2ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DTX_Cycle_2ms_Items_sequence[] = {
  { &hf_nbap_uE_DTX_Cycle1_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Cycle1_2ms },
  { &hf_nbap_uE_DTX_Cycle2_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Cycle2_2ms },
  { &hf_nbap_mAC_DTX_Cycle_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_DTX_Cycle_2ms },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DTX_Cycle_2ms_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DTX_Cycle_2ms_Items, DTX_Cycle_2ms_Items_sequence);

  return offset;
}


static const value_string nbap_UE_DTX_Cycle1_10ms_vals[] = {
  {   0, "v1" },
  {   1, "v5" },
  {   2, "v10" },
  {   3, "v20" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DTX_Cycle1_10ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_UE_DTX_Cycle2_10ms_vals[] = {
  {   0, "v5" },
  {   1, "v10" },
  {   2, "v20" },
  {   3, "v40" },
  {   4, "v80" },
  {   5, "v160" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DTX_Cycle2_10ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_MAC_DTX_Cycle_10ms_vals[] = {
  {   0, "v5" },
  {   1, "v10" },
  {   2, "v20" },
  { 0, NULL }
};


static int
dissect_nbap_MAC_DTX_Cycle_10ms(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DTX_Cycle_10ms_Items_sequence[] = {
  { &hf_nbap_uE_DTX_Cycle1_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Cycle1_10ms },
  { &hf_nbap_uE_DTX_Cycle2_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Cycle2_10ms },
  { &hf_nbap_mAC_DTX_Cycle_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_DTX_Cycle_10ms },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DTX_Cycle_10ms_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DTX_Cycle_10ms_Items, DTX_Cycle_10ms_Items_sequence);

  return offset;
}


static const value_string nbap_E_DCH_TTI_Length_vals[] = {
  {   0, "two-ms" },
  {   1, "ten-ms" },
  { 0, NULL }
};

static const per_choice_t E_DCH_TTI_Length_choice[] = {
  {   0, &hf_nbap_two_ms         , ASN1_EXTENSION_ROOT    , dissect_nbap_DTX_Cycle_2ms_Items },
  {   1, &hf_nbap_ten_ms         , ASN1_EXTENSION_ROOT    , dissect_nbap_DTX_Cycle_10ms_Items },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_E_DCH_TTI_Length(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_E_DCH_TTI_Length, E_DCH_TTI_Length_choice,
                                 NULL);

  return offset;
}


static const value_string nbap_Inactivity_Threshold_for_UE_DTX_Cycle2_vals[] = {
  {   0, "v1" },
  {   1, "v4" },
  {   2, "v8" },
  {   3, "v16" },
  {   4, "v32" },
  {   5, "v64" },
  {   6, "v128" },
  {   7, "v256" },
  { 0, NULL }
};


static int
dissect_nbap_Inactivity_Threshold_for_UE_DTX_Cycle2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_UE_DTX_Long_Preamble_vals[] = {
  {   0, "v2" },
  {   1, "v4" },
  {   2, "v15" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DTX_Long_Preamble(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_MAC_Inactivity_Threshold_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  {   7, "v128" },
  {   8, "v256" },
  {   9, "v512" },
  {  10, "infinity" },
  { 0, NULL }
};


static int
dissect_nbap_MAC_Inactivity_Threshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_CQI_DTX_Timer_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  {   2, "v2" },
  {   3, "v4" },
  {   4, "v8" },
  {   5, "v16" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  {   9, "v256" },
  {  10, "v512" },
  {  11, "infinity" },
  { 0, NULL }
};


static int
dissect_nbap_CQI_DTX_Timer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_UE_DPCCH_burst1_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v5" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DPCCH_burst1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_UE_DPCCH_burst2_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v5" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DPCCH_burst2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DTX_Information_sequence[] = {
  { &hf_nbap_e_DCH_TTI_Length, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_TTI_Length },
  { &hf_nbap_inactivity_Threshold_for_UE_DTX_Cycle2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Inactivity_Threshold_for_UE_DTX_Cycle2 },
  { &hf_nbap_uE_DTX_Long_Preamble, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Long_Preamble },
  { &hf_nbap_mAC_Inactivity_Threshold, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_Inactivity_Threshold },
  { &hf_nbap_cQI_DTX_Timer  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CQI_DTX_Timer },
  { &hf_nbap_uE_DPCCH_burst1, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DPCCH_burst1 },
  { &hf_nbap_uE_DPCCH_burst2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DPCCH_burst2 },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DTX_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DTX_Information, DTX_Information_sequence);

  return offset;
}


static const value_string nbap_UE_DRX_Cycle_vals[] = {
  {   0, "v4" },
  {   1, "v5" },
  {   2, "v8" },
  {   3, "v10" },
  {   4, "v16" },
  {   5, "v20" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_Inactivity_Threshold_for_UE_DRX_Cycle_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  {   2, "v2" },
  {   3, "v4" },
  {   4, "v8" },
  {   5, "v16" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  {   9, "v256" },
  {  10, "v512" },
  { 0, NULL }
};


static int
dissect_nbap_Inactivity_Threshold_for_UE_DRX_Cycle(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_Inactivity_Threshold_for_UE_Grant_Monitoring_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  {   2, "v2" },
  {   3, "v4" },
  {   4, "v8" },
  {   5, "v16" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  {   9, "v256" },
  { 0, NULL }
};


static int
dissect_nbap_Inactivity_Threshold_for_UE_Grant_Monitoring(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_UE_DRX_Grant_Monitoring(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t DRX_Information_sequence[] = {
  { &hf_nbap_uE_DRX_Cycle   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DRX_Cycle },
  { &hf_nbap_inactivity_Threshold_for_UE_DRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Inactivity_Threshold_for_UE_DRX_Cycle },
  { &hf_nbap_inactivity_Threshold_for_UE_Grant_Monitoring, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Inactivity_Threshold_for_UE_Grant_Monitoring },
  { &hf_nbap_uE_DRX_Grant_Monitoring, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DRX_Grant_Monitoring },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DRX_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DRX_Information, DRX_Information_sequence);

  return offset;
}


static const per_sequence_t ContinuousPacketConnectivityDTX_DRX_Information_sequence[] = {
  { &hf_nbap_uE_DTX_DRX_Offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_DRX_Offset },
  { &hf_nbap_enabling_Delay , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Enabling_Delay },
  { &hf_nbap_dTX_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DTX_Information },
  { &hf_nbap_dRX_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DRX_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ContinuousPacketConnectivityDTX_DRX_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ContinuousPacketConnectivityDTX_DRX_Information, ContinuousPacketConnectivityDTX_DRX_Information_sequence);

  return offset;
}


static const per_sequence_t DTX_Cycle_2ms_to_Modify_Items_sequence[] = {
  { &hf_nbap_uE_DTX_Cycle1_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Cycle1_2ms },
  { &hf_nbap_uE_DTX_Cycle2_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Cycle2_2ms },
  { &hf_nbap_mAC_DTX_Cycle_2ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_DTX_Cycle_2ms },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DTX_Cycle_2ms_to_Modify_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DTX_Cycle_2ms_to_Modify_Items, DTX_Cycle_2ms_to_Modify_Items_sequence);

  return offset;
}


static const per_sequence_t DTX_Cycle_10ms_to_Modify_Items_sequence[] = {
  { &hf_nbap_uE_DTX_Cycle1_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Cycle1_10ms },
  { &hf_nbap_uE_DTX_Cycle2_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DTX_Cycle2_10ms },
  { &hf_nbap_mAC_DTX_Cycle_10ms, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MAC_DTX_Cycle_10ms },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DTX_Cycle_10ms_to_Modify_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DTX_Cycle_10ms_to_Modify_Items, DTX_Cycle_10ms_to_Modify_Items_sequence);

  return offset;
}


static const value_string nbap_E_DCH_TTI_Length_to_Modify_vals[] = {
  {   0, "two-ms" },
  {   1, "ten-ms" },
  { 0, NULL }
};

static const per_choice_t E_DCH_TTI_Length_to_Modify_choice[] = {
  {   0, &hf_nbap_two_ms_01      , ASN1_EXTENSION_ROOT    , dissect_nbap_DTX_Cycle_2ms_to_Modify_Items },
  {   1, &hf_nbap_ten_ms_01      , ASN1_EXTENSION_ROOT    , dissect_nbap_DTX_Cycle_10ms_to_Modify_Items },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_E_DCH_TTI_Length_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_E_DCH_TTI_Length_to_Modify, E_DCH_TTI_Length_to_Modify_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DTX_Information_to_Modify_Items_sequence[] = {
  { &hf_nbap_e_DCH_TTI_Length_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_TTI_Length_to_Modify },
  { &hf_nbap_inactivity_Threshold_for_UE_DTX_Cycle2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Inactivity_Threshold_for_UE_DTX_Cycle2 },
  { &hf_nbap_uE_DTX_Long_Preamble, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DTX_Long_Preamble },
  { &hf_nbap_mAC_Inactivity_Threshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_MAC_Inactivity_Threshold },
  { &hf_nbap_cQI_DTX_Timer  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_CQI_DTX_Timer },
  { &hf_nbap_uE_DPCCH_burst1, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DPCCH_burst1 },
  { &hf_nbap_uE_DPCCH_burst2, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DPCCH_burst2 },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DTX_Information_to_Modify_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DTX_Information_to_Modify_Items, DTX_Information_to_Modify_Items_sequence);

  return offset;
}


static const value_string nbap_DTX_Information_to_Modify_vals[] = {
  {   0, "modify" },
  {   1, "deactivate" },
  { 0, NULL }
};

static const per_choice_t DTX_Information_to_Modify_choice[] = {
  {   0, &hf_nbap_modify_02      , ASN1_EXTENSION_ROOT    , dissect_nbap_DTX_Information_to_Modify_Items },
  {   1, &hf_nbap_deactivate     , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_DTX_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_DTX_Information_to_Modify, DTX_Information_to_Modify_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DRX_Information_to_Modify_Items_sequence[] = {
  { &hf_nbap_uE_DRX_Cycle   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DRX_Cycle },
  { &hf_nbap_inactivity_Threshold_for_UE_DRX_Cycle, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Inactivity_Threshold_for_UE_DRX_Cycle },
  { &hf_nbap_inactivity_Threshold_for_UE_Grant_Monitoring, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Inactivity_Threshold_for_UE_Grant_Monitoring },
  { &hf_nbap_uE_DRX_Grant_Monitoring, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DRX_Grant_Monitoring },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DRX_Information_to_Modify_Items(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DRX_Information_to_Modify_Items, DRX_Information_to_Modify_Items_sequence);

  return offset;
}


static const value_string nbap_DRX_Information_to_Modify_vals[] = {
  {   0, "modify" },
  {   1, "deactivate" },
  { 0, NULL }
};

static const per_choice_t DRX_Information_to_Modify_choice[] = {
  {   0, &hf_nbap_modify_01      , ASN1_EXTENSION_ROOT    , dissect_nbap_DRX_Information_to_Modify_Items },
  {   1, &hf_nbap_deactivate     , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_DRX_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_DRX_Information_to_Modify, DRX_Information_to_Modify_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ContinuousPacketConnectivityDTX_DRX_Information_to_Modify_sequence[] = {
  { &hf_nbap_uE_DTX_DRX_Offset, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DTX_DRX_Offset },
  { &hf_nbap_enabling_Delay , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Enabling_Delay },
  { &hf_nbap_dTX_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DTX_Information_to_Modify },
  { &hf_nbap_dRX_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DRX_Information_to_Modify },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ContinuousPacketConnectivityDTX_DRX_Information_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ContinuousPacketConnectivityDTX_DRX_Information_to_Modify, ContinuousPacketConnectivityDTX_DRX_Information_to_Modify_sequence);

  return offset;
}


static const value_string nbap_ContinuousPacketConnectivityHS_SCCH_less_Capability_vals[] = {
  {   0, "continuous-Packet-Connectivity-HS-SCCH-less-capable" },
  {   1, "continuous-Packet-Connectivity-HS-SCCH-less-capable-non-capable" },
  { 0, NULL }
};


static int
dissect_nbap_ContinuousPacketConnectivityHS_SCCH_less_Capability(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_Transport_Block_Size_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrOfHS_DSCH_TBSs, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_HSPDSCH_Second_Code_Support(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}


static const per_sequence_t ContinuousPacketConnectivityHS_SCCH_less_InformationItem_sequence[] = {
  { &hf_nbap_transport_Block_Size_Index, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Transport_Block_Size_Index },
  { &hf_nbap_hSPDSCH_Second_Code_Support, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HSPDSCH_Second_Code_Support },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ContinuousPacketConnectivityHS_SCCH_less_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ContinuousPacketConnectivityHS_SCCH_less_InformationItem, ContinuousPacketConnectivityHS_SCCH_less_InformationItem_sequence);

  return offset;
}


static const per_sequence_t ContinuousPacketConnectivityHS_SCCH_less_Information_sequence_of[1] = {
  { &hf_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_ContinuousPacketConnectivityHS_SCCH_less_InformationItem },
};

static int
dissect_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information, ContinuousPacketConnectivityHS_SCCH_less_Information_sequence_of,
                                                  1, maxNrOfHS_DSCH_TBSs_HS_SCCHless, FALSE);

  return offset;
}



static int
dissect_nbap_HSPDSCH_First_Code_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxHS_PDSCHCodeNrComp_1, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_HSPDSCH_Second_Code_Index(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxHS_PDSCHCodeNrComp_1, NULL, FALSE);

  return offset;
}


static const per_sequence_t ContinuousPacketConnectivityHS_SCCH_less_Information_Response_sequence[] = {
  { &hf_nbap_hSPDSCH_First_Code_Index, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HSPDSCH_First_Code_Index },
  { &hf_nbap_hSPDSCH_Second_Code_Index, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HSPDSCH_Second_Code_Index },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information_Response, ContinuousPacketConnectivityHS_SCCH_less_Information_Response_sequence);

  return offset;
}



static int
dissect_nbap_ControlGAP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CPC_Information_sequence[] = {
  { &hf_nbap_continuousPacketConnectivityDTX_DRX_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ContinuousPacketConnectivityDTX_DRX_Information },
  { &hf_nbap_continuousPacketConnectivityDTX_DRX_Information_to_Modify, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ContinuousPacketConnectivityDTX_DRX_Information_to_Modify },
  { &hf_nbap_continuousPacketConnectivityHS_SCCH_less_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ContinuousPacketConnectivityHS_SCCH_less_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CPC_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CPC_Information, CPC_Information_sequence);

  return offset;
}



static int
dissect_nbap_ContinuousPacketConnectivityHS_SCCH_less_Deactivate_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_nbap_RepetitionNumber0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_item_sequence[] = {
  { &hf_nbap_iECriticality  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Criticality },
  { &hf_nbap_iE_ID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ProtocolIE_ID },
  { &hf_nbap_repetitionNumber, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_RepetitionNumber0 },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CriticalityDiagnostics_IE_List_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CriticalityDiagnostics_IE_List_item, CriticalityDiagnostics_IE_List_item_sequence);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_IE_List_sequence_of[1] = {
  { &hf_nbap_CriticalityDiagnostics_IE_List_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_CriticalityDiagnostics_IE_List_item },
};

static int
dissect_nbap_CriticalityDiagnostics_IE_List(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_CriticalityDiagnostics_IE_List, CriticalityDiagnostics_IE_List_sequence_of,
                                                  1, maxNrOfErrors, FALSE);

  return offset;
}


static const per_sequence_t CriticalityDiagnostics_sequence[] = {
  { &hf_nbap_procedureID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProcedureID },
  { &hf_nbap_triggeringMessage, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TriggeringMessage },
  { &hf_nbap_procedureCriticality, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Criticality },
  { &hf_nbap_transactionID  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransactionID },
  { &hf_nbap_iEsCriticalityDiagnostics, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_CriticalityDiagnostics_IE_List },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CriticalityDiagnostics(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CriticalityDiagnostics, CriticalityDiagnostics_sequence);

  return offset;
}



static int
dissect_nbap_CRNC_CommunicationContextID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 2485 "./asn1/nbap/nbap.cnf"
guint32 com_context_id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1048575U, &com_context_id, FALSE);

private_data_set_com_context_id(actx->pinfo, com_context_id);
private_data_set_crnc_context_present(actx->pinfo, TRUE);



  return offset;
}



static int
dissect_nbap_CSBMeasurementID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_CSBTransmissionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Common_MACFlow_ID_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfCommonMACFlowsLCR_1, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_DCH_MACdFlow_ID_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNrOfEDCHMACdFlowsLCR_1, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_DCH_HARQ_PO_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 6U, NULL, FALSE);

  return offset;
}


static const value_string nbap_E_DCH_MACdFlow_Retransmission_Timer_vals[] = {
  {   0, "ms10" },
  {   1, "ms15" },
  {   2, "ms20" },
  {   3, "ms25" },
  {   4, "ms30" },
  {   5, "ms35" },
  {   6, "ms40" },
  {   7, "ms45" },
  {   8, "ms50" },
  {   9, "ms55" },
  {  10, "ms60" },
  {  11, "ms65" },
  {  12, "ms70" },
  {  13, "ms75" },
  {  14, "ms80" },
  {  15, "ms85" },
  {  16, "ms90" },
  {  17, "ms95" },
  {  18, "ms100" },
  {  19, "ms110" },
  {  20, "ms120" },
  {  21, "ms140" },
  {  22, "ms160" },
  {  23, "ms200" },
  {  24, "ms240" },
  {  25, "ms280" },
  {  26, "ms320" },
  {  27, "ms400" },
  {  28, "ms480" },
  {  29, "ms560" },
  { 0, NULL }
};

static value_string_ext nbap_E_DCH_MACdFlow_Retransmission_Timer_vals_ext = VALUE_STRING_EXT_INIT(nbap_E_DCH_MACdFlow_Retransmission_Timer_vals);


static int
dissect_nbap_E_DCH_MACdFlow_Retransmission_Timer(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     30, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Common_E_DCH_MACdFlow_Specific_InfoList_ItemLCR_sequence[] = {
  { &hf_nbap_common_e_DCH_MACdFlow_ID_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_MACdFlow_ID_LCR },
  { &hf_nbap_maximum_Number_of_Retransmissions_For_E_DCH, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Maximum_Number_of_Retransmissions_For_E_DCH },
  { &hf_nbap_eDCH_MACdFlow_Multiplexing_List, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_MACdFlow_Multiplexing_List },
  { &hf_nbap_common_E_DCHLogicalChannelInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_LogicalChannel_InfoList },
  { &hf_nbap_eDCH_HARQ_PO_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_HARQ_PO_TDD },
  { &hf_nbap_eDCH_MACdFlow_Retransmission_Timer, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_MACdFlow_Retransmission_Timer },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_ItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_ItemLCR, Common_E_DCH_MACdFlow_Specific_InfoList_ItemLCR_sequence);

  return offset;
}


static const per_sequence_t Common_E_DCH_MACdFlow_Specific_InfoListLCR_sequence_of[1] = {
  { &hf_nbap_Common_E_DCH_MACdFlow_Specific_InfoListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_DCH_MACdFlow_Specific_InfoList_ItemLCR },
};

static int
dissect_nbap_Common_E_DCH_MACdFlow_Specific_InfoListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_E_DCH_MACdFlow_Specific_InfoListLCR, Common_E_DCH_MACdFlow_Specific_InfoListLCR_sequence_of,
                                                  1, maxNrOfEDCHMACdFlowsLCR, FALSE);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoList_ItemLCR_sequence[] = {
  { &hf_nbap_ul_Common_MACFlowIDLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID_LCR },
  { &hf_nbap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportBearerRequestIndicator },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_tnlQos         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TnlQos },
  { &hf_nbap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_PayloadCRC_PresenceIndicator },
  { &hf_nbap_common_E_DCH_MACdFlow_Specific_InformationLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_DCH_MACdFlow_Specific_InfoListLCR },
  { &hf_nbap_uARFCN         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UARFCN },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_ItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_ItemLCR, Ul_common_E_DCH_MACflow_Specific_InfoList_ItemLCR_sequence);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoListLCR_sequence_of[1] = {
  { &hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoList_ItemLCR },
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoListLCR, Ul_common_E_DCH_MACflow_Specific_InfoListLCR_sequence_of,
                                                  1, maxNrOfCommonMACFlows, FALSE);

  return offset;
}



static int
dissect_nbap_PRXdes_base(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -112, -50, NULL, FALSE);

  return offset;
}


static const per_sequence_t PRXdes_base_Item_sequence[] = {
  { &hf_nbap_pRXdes_base    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PRXdes_base },
  { &hf_nbap_uARFCN         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UARFCN },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_PRXdes_base_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_PRXdes_base_Item, PRXdes_base_Item_sequence);

  return offset;
}


static const per_sequence_t PRXdes_base_perURAFCN_sequence_of[1] = {
  { &hf_nbap_PRXdes_base_perURAFCN_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_PRXdes_base_Item },
};

static int
dissect_nbap_PRXdes_base_perURAFCN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_PRXdes_base_perURAFCN, PRXdes_base_perURAFCN_sequence_of,
                                                  1, maxFrequencyinCell, FALSE);

  return offset;
}


static const value_string nbap_TDD_TPC_UplinkStepSize_LCR_vals[] = {
  {   0, "step-size1" },
  {   1, "step-size2" },
  {   2, "step-size3" },
  { 0, NULL }
};


static int
dissect_nbap_TDD_TPC_UplinkStepSize_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_TDD_TPC_DownlinkStepSize_vals[] = {
  {   0, "step-size1" },
  {   1, "step-size2" },
  {   2, "step-size3" },
  { 0, NULL }
};


static int
dissect_nbap_TDD_TPC_DownlinkStepSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t Common_E_PUCH_InformationLCR_sequence[] = {
  { &hf_nbap_minCR          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CodeRate },
  { &hf_nbap_maxCR          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CodeRate },
  { &hf_nbap_harqInfo       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HARQ_Info_for_E_DCH },
  { &hf_nbap_pRXdes_base_perURAFCN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_PRXdes_base_perURAFCN },
  { &hf_nbap_e_PUCH_TPC_StepSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TDD_TPC_UplinkStepSize_LCR },
  { &hf_nbap_e_AGCH_TPC_StepSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TDD_TPC_DownlinkStepSize },
  { &hf_nbap_e_PUCH_PowerControlGAP, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ControlGAP },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_PUCH_InformationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_PUCH_InformationLCR, Common_E_PUCH_InformationLCR_sequence);

  return offset;
}



static int
dissect_nbap_RefBeta(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -15, 16U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_DCH_RefBeta_Item_sequence[] = {
  { &hf_nbap_refCodeRate    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_CodeRate_short },
  { &hf_nbap_refBeta        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_RefBeta },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_DCH_RefBeta_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_DCH_RefBeta_Item, E_DCH_RefBeta_Item_sequence);

  return offset;
}


static const per_sequence_t E_DCH_QPSK_RefBetaInfo_sequence_of[1] = {
  { &hf_nbap_E_DCH_QPSK_RefBetaInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_RefBeta_Item },
};

static int
dissect_nbap_E_DCH_QPSK_RefBetaInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_E_DCH_QPSK_RefBetaInfo, E_DCH_QPSK_RefBetaInfo_sequence_of,
                                                  1, maxNrOfRefBetas, FALSE);

  return offset;
}


static const per_sequence_t E_DCH_sixteenQAM_RefBetaInfo_sequence_of[1] = {
  { &hf_nbap_E_DCH_sixteenQAM_RefBetaInfo_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_RefBeta_Item },
};

static int
dissect_nbap_E_DCH_sixteenQAM_RefBetaInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_E_DCH_sixteenQAM_RefBetaInfo, E_DCH_sixteenQAM_RefBetaInfo_sequence_of,
                                                  1, maxNrOfRefBetas, FALSE);

  return offset;
}


static const per_sequence_t E_TFCS_Information_TDD_sequence[] = {
  { &hf_nbap_e_DCH_QPSK_RefBetaInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_QPSK_RefBetaInfo },
  { &hf_nbap_e_DCH_sixteenQAM_RefBetaInfo, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_sixteenQAM_RefBetaInfo },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_TFCS_Information_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_TFCS_Information_TDD, E_TFCS_Information_TDD_sequence);

  return offset;
}


static const per_sequence_t Common_EDCH_System_InformationLCR_sequence[] = {
  { &hf_nbap_ul_common_E_DCH_MACflow_Specific_InformationLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoListLCR },
  { &hf_nbap_common_E_PUCH_InformationLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_PUCH_InformationLCR },
  { &hf_nbap_e_TFCS_Information_TDD, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_TFCS_Information_TDD },
  { &hf_nbap_maximum_Number_of_Retransmissions_For_SchedulingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Maximum_Number_of_Retransmissions_For_E_DCH },
  { &hf_nbap_eDCH_Retransmission_Timer_SchedulingInfo, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_MACdFlow_Retransmission_Timer },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_EDCH_System_InformationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_EDCH_System_InformationLCR, Common_EDCH_System_InformationLCR_sequence);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR_sequence[] = {
  { &hf_nbap_ul_Common_MACFlowID_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID_LCR },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_uARFCN         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UARFCN },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR, Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR_sequence);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_sequence_of[1] = {
  { &hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR },
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR, Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_sequence_of,
                                                  1, maxNrOfCommonMACFlows, FALSE);

  return offset;
}



static int
dissect_nbap_E_AGCH_Id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, TRUE);

  return offset;
}


static const per_sequence_t Common_E_AGCH_ItemLCR_sequence[] = {
  { &hf_nbap_e_AGCH_ID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_AGCH_Id },
  { &hf_nbap_uARFCN         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UARFCN },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_AGCH_ItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_AGCH_ItemLCR, Common_E_AGCH_ItemLCR_sequence);

  return offset;
}


static const per_sequence_t Common_E_AGCH_ListLCR_sequence_of[1] = {
  { &hf_nbap_Common_E_AGCH_ListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_AGCH_ItemLCR },
};

static int
dissect_nbap_Common_E_AGCH_ListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_E_AGCH_ListLCR, Common_E_AGCH_ListLCR_sequence_of,
                                                  1, maxNrOfEAGCHsLCR, FALSE);

  return offset;
}



static int
dissect_nbap_EI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_E_HICH_ID_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Common_E_HICH_ItemLCR_sequence[] = {
  { &hf_nbap_eI             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_EI },
  { &hf_nbap_e_HICH_ID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_HICH_ID_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_HICH_ItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_HICH_ItemLCR, Common_E_HICH_ItemLCR_sequence);

  return offset;
}


static const per_sequence_t Common_E_HICH_ListLCR_sequence_of[1] = {
  { &hf_nbap_Common_E_HICH_ListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_HICH_ItemLCR },
};

static int
dissect_nbap_Common_E_HICH_ListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_E_HICH_ListLCR, Common_E_HICH_ListLCR_sequence_of,
                                                  1, maxNrOfEHICHsLCR, FALSE);

  return offset;
}



static int
dissect_nbap_INTEGER_1_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_INTEGER_1_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Common_E_RNTI_Info_ItemLCR_sequence[] = {
  { &hf_nbap_starting_E_RNTI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_RNTI },
  { &hf_nbap_number_of_Group, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_1_32 },
  { &hf_nbap_number_of_e_E_RNTI_perGroup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_1_7 },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_E_RNTI_Info_ItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_E_RNTI_Info_ItemLCR, Common_E_RNTI_Info_ItemLCR_sequence);

  return offset;
}


static const per_sequence_t Common_E_RNTI_Info_LCR_sequence_of[1] = {
  { &hf_nbap_Common_E_RNTI_Info_LCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_E_RNTI_Info_ItemLCR },
};

static int
dissect_nbap_Common_E_RNTI_Info_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_E_RNTI_Info_LCR, Common_E_RNTI_Info_LCR_sequence_of,
                                                  1, maxnrofERUCCHsLCR, FALSE);

  return offset;
}


static const per_sequence_t Common_EDCH_System_Information_ResponseLCR_sequence[] = {
  { &hf_nbap_ul_common_E_DCH_MACflow_Specific_InfoResponseLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR },
  { &hf_nbap_common_E_AGCH_ListLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_AGCH_ListLCR },
  { &hf_nbap_common_E_HICH_ListLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_HICH_ListLCR },
  { &hf_nbap_common_E_RNTI_Info_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_E_RNTI_Info_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_EDCH_System_Information_ResponseLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_EDCH_System_Information_ResponseLCR, Common_EDCH_System_Information_ResponseLCR_sequence);

  return offset;
}


static const per_sequence_t Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext_sequence_of[1] = {
  { &hf_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseList_ItemLCR },
};

static int
dissect_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext, Ul_common_E_DCH_MACflow_Specific_InfoResponseListLCR_Ext_sequence_of,
                                                  1, maxNrOfCommonMACFlowsLCRExt, FALSE);

  return offset;
}


static const per_sequence_t Common_MACFlows_to_DeleteLCR_Item_sequence[] = {
  { &hf_nbap_common_MACFlow_ID_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_MACFlows_to_DeleteLCR_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_MACFlows_to_DeleteLCR_Item, Common_MACFlows_to_DeleteLCR_Item_sequence);

  return offset;
}


static const per_sequence_t Common_MACFlows_to_DeleteLCR_sequence_of[1] = {
  { &hf_nbap_Common_MACFlows_to_DeleteLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlows_to_DeleteLCR_Item },
};

static int
dissect_nbap_Common_MACFlows_to_DeleteLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_MACFlows_to_DeleteLCR, Common_MACFlows_to_DeleteLCR_sequence_of,
                                                  1, maxNrOfCommonMACFlowsLCR, FALSE);

  return offset;
}


static const per_sequence_t CommonMACFlow_Specific_InfoItemLCR_sequence[] = {
  { &hf_nbap_common_MACFlow_ID_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID_LCR },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_tnl_qos        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TnlQos },
  { &hf_nbap_common_MACFlow_PriorityQueue_InformationLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Common_MACFlow_PriorityQueue_Information },
  { &hf_nbap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportBearerRequestIndicator },
  { &hf_nbap_uARFCN         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UARFCN },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CommonMACFlow_Specific_InfoItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CommonMACFlow_Specific_InfoItemLCR, CommonMACFlow_Specific_InfoItemLCR_sequence);

  return offset;
}


static const per_sequence_t CommonMACFlow_Specific_InfoListLCR_sequence_of[1] = {
  { &hf_nbap_CommonMACFlow_Specific_InfoListLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_CommonMACFlow_Specific_InfoItemLCR },
};

static int
dissect_nbap_CommonMACFlow_Specific_InfoListLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_CommonMACFlow_Specific_InfoListLCR, CommonMACFlow_Specific_InfoListLCR_sequence_of,
                                                  1, maxNrOfCommonMACFlowsLCR, FALSE);

  return offset;
}


static const per_sequence_t Common_H_RNTI_InfoItemLCR_sequence[] = {
  { &hf_nbap_common_H_RNTI  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HSDSCH_RNTI },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Common_H_RNTI_InfoItemLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Common_H_RNTI_InfoItemLCR, Common_H_RNTI_InfoItemLCR_sequence);

  return offset;
}


static const per_sequence_t Common_H_RNTI_InformationLCR_sequence_of[1] = {
  { &hf_nbap_Common_H_RNTI_InformationLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Common_H_RNTI_InfoItemLCR },
};

static int
dissect_nbap_Common_H_RNTI_InformationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Common_H_RNTI_InformationLCR, Common_H_RNTI_InformationLCR_sequence_of,
                                                  1, maxNoOfCommonH_RNTI, FALSE);

  return offset;
}


static const value_string nbap_T_SYNC_vals[] = {
  {   0, "v40" },
  {   1, "v80" },
  {   2, "v120" },
  {   3, "v160" },
  {   4, "v200" },
  {   5, "v300" },
  {   6, "v400" },
  {   7, "v500" },
  { 0, NULL }
};


static int
dissect_nbap_T_SYNC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_T_PROTECT_vals[] = {
  {   0, "v40" },
  {   1, "v60" },
  {   2, "v80" },
  {   3, "v100" },
  {   4, "v120" },
  {   5, "v200" },
  {   6, "v400" },
  { 0, NULL }
};


static int
dissect_nbap_T_PROTECT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_N_PROTECT(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Sync_InformationLCR_sequence[] = {
  { &hf_nbap_t_SYNC         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_T_SYNC },
  { &hf_nbap_t_PROTECT      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_T_PROTECT },
  { &hf_nbap_n_PROTECT      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_N_PROTECT },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Sync_InformationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Sync_InformationLCR, Sync_InformationLCR_sequence);

  return offset;
}


static const per_sequence_t CommonMACFlow_Specific_InfoItem_ResponseLCR_sequence[] = {
  { &hf_nbap_common_MACFlow_ID_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Common_MACFlow_ID_LCR },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_hSDSCH_Initial_Capacity_Allocation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HSDSCH_Initial_Capacity_Allocation },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CommonMACFlow_Specific_InfoItem_ResponseLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CommonMACFlow_Specific_InfoItem_ResponseLCR, CommonMACFlow_Specific_InfoItem_ResponseLCR_sequence);

  return offset;
}


static const per_sequence_t CommonMACFlow_Specific_InfoList_ResponseLCR_sequence_of[1] = {
  { &hf_nbap_CommonMACFlow_Specific_InfoList_ResponseLCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_CommonMACFlow_Specific_InfoItem_ResponseLCR },
};

static int
dissect_nbap_CommonMACFlow_Specific_InfoList_ResponseLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_CommonMACFlow_Specific_InfoList_ResponseLCR, CommonMACFlow_Specific_InfoList_ResponseLCR_sequence_of,
                                                  1, maxNrOfCommonMACFlows, FALSE);

  return offset;
}


static const value_string nbap_UE_DRX_Cycle_LCR_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  { 0, NULL }
};


static int
dissect_nbap_UE_DRX_Cycle_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_Inactivity_Threshold_for_UE_DRX_Cycle_LCR_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  { 0, NULL }
};


static int
dissect_nbap_Inactivity_Threshold_for_UE_DRX_Cycle_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_UE_DRX_Offset_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t HS_SCCH_DRX_Information_LCR_sequence[] = {
  { &hf_nbap_hS_SCCH_UE_DRX_Cycle_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DRX_Cycle_LCR },
  { &hf_nbap_hS_SCCH_Inactivity_Threshold_for_UE_DRX_Cycle_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Inactivity_Threshold_for_UE_DRX_Cycle_LCR },
  { &hf_nbap_hS_SCCH_UE_DRX_Offset_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DRX_Offset_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_HS_SCCH_DRX_Information_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_HS_SCCH_DRX_Information_LCR, HS_SCCH_DRX_Information_LCR_sequence);

  return offset;
}


static const value_string nbap_E_AGCH_UE_Inactivity_Monitor_Threshold_vals[] = {
  {   0, "v0" },
  {   1, "v1" },
  {   2, "v2" },
  {   3, "v4" },
  {   4, "v8" },
  {   5, "v16" },
  {   6, "v32" },
  {   7, "v64" },
  {   8, "v128" },
  {   9, "v256" },
  {  10, "v512" },
  {  11, "infinity" },
  { 0, NULL }
};

static value_string_ext nbap_E_AGCH_UE_Inactivity_Monitor_Threshold_vals_ext = VALUE_STRING_EXT_INIT(nbap_E_AGCH_UE_Inactivity_Monitor_Threshold_vals);


static int
dissect_nbap_E_AGCH_UE_Inactivity_Monitor_Threshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t E_AGCH_DRX_Parameters_sequence[] = {
  { &hf_nbap_e_AGCH_UE_DRX_Cycle_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DRX_Cycle_LCR },
  { &hf_nbap_e_AGCH_UE_Inactivity_Monitor_Threshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_AGCH_UE_Inactivity_Monitor_Threshold },
  { &hf_nbap_e_AGCH_UE_DRX_Offset_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UE_DRX_Offset_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_AGCH_DRX_Parameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_AGCH_DRX_Parameters, E_AGCH_DRX_Parameters_sequence);

  return offset;
}


static const value_string nbap_E_AGCH_DRX_Information_LCR_vals[] = {
  {   0, "sameAsHS-SCCH" },
  {   1, "e-AGCH-DRX-Parameters" },
  { 0, NULL }
};

static const per_choice_t E_AGCH_DRX_Information_LCR_choice[] = {
  {   0, &hf_nbap_sameAsHS_SCCH  , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   1, &hf_nbap_e_AGCH_DRX_Parameters, ASN1_EXTENSION_ROOT    , dissect_nbap_E_AGCH_DRX_Parameters },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_E_AGCH_DRX_Information_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_E_AGCH_DRX_Information_LCR, E_AGCH_DRX_Information_LCR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ContinuousPacketConnectivity_DRX_InformationLCR_sequence[] = {
  { &hf_nbap_enabling_Delay , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Enabling_Delay },
  { &hf_nbap_hS_SCCH_DRX_Information_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HS_SCCH_DRX_Information_LCR },
  { &hf_nbap_e_AGCH_DRX_Information_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_AGCH_DRX_Information_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ContinuousPacketConnectivity_DRX_InformationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ContinuousPacketConnectivity_DRX_InformationLCR, ContinuousPacketConnectivity_DRX_InformationLCR_sequence);

  return offset;
}


static const per_sequence_t DRX_Information_to_Modify_Items_LCR_sequence[] = {
  { &hf_nbap_hS_SCCH_DRX_Information_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HS_SCCH_DRX_Information_LCR },
  { &hf_nbap_e_AGCH_DRX_Information_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_AGCH_DRX_Information_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DRX_Information_to_Modify_Items_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DRX_Information_to_Modify_Items_LCR, DRX_Information_to_Modify_Items_LCR_sequence);

  return offset;
}


static const value_string nbap_DRX_Information_to_Modify_LCR_vals[] = {
  {   0, "modify" },
  {   1, "deactivate" },
  { 0, NULL }
};

static const per_choice_t DRX_Information_to_Modify_LCR_choice[] = {
  {   0, &hf_nbap_modify         , ASN1_EXTENSION_ROOT    , dissect_nbap_DRX_Information_to_Modify_Items_LCR },
  {   1, &hf_nbap_deactivate     , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_DRX_Information_to_Modify_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_DRX_Information_to_Modify_LCR, DRX_Information_to_Modify_LCR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ContinuousPacketConnectivity_DRX_Information_to_Modify_LCR_sequence[] = {
  { &hf_nbap_enabling_Delay , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Enabling_Delay },
  { &hf_nbap_dRX_Information_to_Modify_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DRX_Information_to_Modify_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ContinuousPacketConnectivity_DRX_Information_to_Modify_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ContinuousPacketConnectivity_DRX_Information_to_Modify_LCR, ContinuousPacketConnectivity_DRX_Information_to_Modify_LCR_sequence);

  return offset;
}



static int
dissect_nbap_Transport_Block_Size_maping_Index_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNoOfTBSs_Mapping_HS_DSCH_SPS_1, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Transport_Block_Size_Index_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNoOfHS_DSCH_TBSsLCR, NULL, FALSE);

  return offset;
}


static const per_sequence_t Transport_Block_Size_Item_LCR_sequence[] = {
  { &hf_nbap_transport_Block_Size_maping_Index_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Transport_Block_Size_maping_Index_LCR },
  { &hf_nbap_transport_Block_Size_Index_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Transport_Block_Size_Index_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Transport_Block_Size_Item_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Transport_Block_Size_Item_LCR, Transport_Block_Size_Item_LCR_sequence);

  return offset;
}


static const per_sequence_t Transport_Block_Size_List_LCR_sequence_of[1] = {
  { &hf_nbap_Transport_Block_Size_List_LCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Transport_Block_Size_Item_LCR },
};

static int
dissect_nbap_Transport_Block_Size_List_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Transport_Block_Size_List_LCR, Transport_Block_Size_List_LCR_sequence_of,
                                                  1, maxNoOfTBSs_Mapping_HS_DSCH_SPS, FALSE);

  return offset;
}



static int
dissect_nbap_RepetitionPeriodIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxNoOfRepetitionPeriod_SPS_LCR_1, NULL, FALSE);

  return offset;
}


static const value_string nbap_RepetitionPeriod_vals[] = {
  {   0, "v1" },
  {   1, "v2" },
  {   2, "v4" },
  {   3, "v8" },
  {   4, "v16" },
  {   5, "v32" },
  {   6, "v64" },
  { 0, NULL }
};


static int
dissect_nbap_RepetitionPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_RepetitionLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Repetition_Period_Item_LCR_sequence[] = {
  { &hf_nbap_repetitionPeriodIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RepetitionPeriodIndex },
  { &hf_nbap_repetitionPeriod, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_RepetitionPeriod },
  { &hf_nbap_repetitionLength, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_RepetitionLength },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Repetition_Period_Item_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Repetition_Period_Item_LCR, Repetition_Period_Item_LCR_sequence);

  return offset;
}


static const per_sequence_t Repetition_Period_List_LCR_sequence_of[1] = {
  { &hf_nbap_Repetition_Period_List_LCR_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_Repetition_Period_Item_LCR },
};

static int
dissect_nbap_Repetition_Period_List_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_Repetition_Period_List_LCR, Repetition_Period_List_LCR_sequence_of,
                                                  1, maxNoOfRepetition_Period_LCR, FALSE);

  return offset;
}


static const value_string nbap_SPS_Reservation_Indicator_vals[] = {
  {   0, "reserve" },
  { 0, NULL }
};


static int
dissect_nbap_SPS_Reservation_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_LogicalChannellevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, NULL);

  return offset;
}



static int
dissect_nbap_PriorityQueuelevel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, NULL);

  return offset;
}


static const value_string nbap_HS_DSCH_SPS_Operation_Indicator_vals[] = {
  {   0, "logicalChannellevel" },
  {   1, "priorityQueuelevel" },
  { 0, NULL }
};

static const per_choice_t HS_DSCH_SPS_Operation_Indicator_choice[] = {
  {   0, &hf_nbap_logicalChannellevel, ASN1_EXTENSION_ROOT    , dissect_nbap_LogicalChannellevel },
  {   1, &hf_nbap_priorityQueuelevel, ASN1_EXTENSION_ROOT    , dissect_nbap_PriorityQueuelevel },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_HS_DSCH_SPS_Operation_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_HS_DSCH_SPS_Operation_Indicator, HS_DSCH_SPS_Operation_Indicator_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t HS_DSCH_Semi_PersistentScheduling_Information_LCR_sequence[] = {
  { &hf_nbap_transport_Block_Size_List_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Transport_Block_Size_List_LCR },
  { &hf_nbap_repetition_Period_List_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Repetition_Period_List_LCR },
  { &hf_nbap_hS_DSCH_SPS_Reservation_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_SPS_Reservation_Indicator },
  { &hf_nbap_hS_DSCH_SPS_Operation_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_HS_DSCH_SPS_Operation_Indicator },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_HS_DSCH_Semi_PersistentScheduling_Information_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_HS_DSCH_Semi_PersistentScheduling_Information_LCR, HS_DSCH_Semi_PersistentScheduling_Information_LCR_sequence);

  return offset;
}


static const per_sequence_t HS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR_sequence[] = {
  { &hf_nbap_transport_Block_Size_List_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Transport_Block_Size_List_LCR },
  { &hf_nbap_repetition_Period_List_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Repetition_Period_List_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_HS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_HS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR, HS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR_sequence);

  return offset;
}



static int
dissect_nbap_E_DCH_SPS_Indicator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, NULL);

  return offset;
}



static int
dissect_nbap_E_HICH_ID_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_SignatureSequenceGroupIndex(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 19U, NULL, FALSE);

  return offset;
}


static const per_sequence_t E_HICH_LCR_Information_sequence[] = {
  { &hf_nbap_e_HICH_ID_TDD  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_HICH_ID_TDD },
  { &hf_nbap_signatureSequenceGroupIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_SignatureSequenceGroupIndex },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_HICH_LCR_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_HICH_LCR_Information, E_HICH_LCR_Information_sequence);

  return offset;
}


static const per_sequence_t E_DCH_Semi_PersistentScheduling_Information_LCR_sequence[] = {
  { &hf_nbap_repetition_Period_List_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Repetition_Period_List_LCR },
  { &hf_nbap_e_DCH_SPS_Indicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_DCH_SPS_Indicator },
  { &hf_nbap_sPS_E_DCH_releted_E_HICH_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_E_HICH_LCR_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_DCH_Semi_PersistentScheduling_Information_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_DCH_Semi_PersistentScheduling_Information_LCR, E_DCH_Semi_PersistentScheduling_Information_LCR_sequence);

  return offset;
}


static const per_sequence_t E_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR_sequence[] = {
  { &hf_nbap_repetition_Period_List_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Repetition_Period_List_LCR },
  { &hf_nbap_e_DCH_SPS_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_SPS_Indicator },
  { &hf_nbap_sPS_E_DCH_releted_E_HICH_Information, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_HICH_LCR_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR, E_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR_sequence);

  return offset;
}


static const per_sequence_t CPC_InformationLCR_sequence[] = {
  { &hf_nbap_continuousPacketConnectivity_DRX_InformationLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ContinuousPacketConnectivity_DRX_InformationLCR },
  { &hf_nbap_continuousPacketConnectivity_DRX_Information_to_Modify_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ContinuousPacketConnectivity_DRX_Information_to_Modify_LCR },
  { &hf_nbap_hS_DSCH_Semi_PersistentScheduling_Information_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HS_DSCH_Semi_PersistentScheduling_Information_LCR },
  { &hf_nbap_hS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HS_DSCH_Semi_PersistentScheduling_Information_to_Modify_LCR },
  { &hf_nbap_hS_DSCH_SPS_Deactivate_Indicator_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_NULL },
  { &hf_nbap_e_DCH_Semi_PersistentScheduling_Information_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_Semi_PersistentScheduling_Information_LCR },
  { &hf_nbap_e_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_DCH_Semi_PersistentScheduling_Information_to_Modify_LCR },
  { &hf_nbap_e_DCH_SPS_Deactivate_Indicator_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_NULL },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_CPC_InformationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_CPC_InformationLCR, CPC_InformationLCR_sequence);

  return offset;
}


static const value_string nbap_ContinuousPacketConnectivity_DRX_CapabilityLCR_vals[] = {
  {   0, "continuous-Packet-Connectivity-DRX-Capable" },
  {   1, "continuous-Packet-Connectivity-DRX-Non-Capable" },
  { 0, NULL }
};


static int
dissect_nbap_ContinuousPacketConnectivity_DRX_CapabilityLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t HS_SCCH_DRX_Information_ResponseLCR_sequence[] = {
  { &hf_nbap_hS_SCCH_UE_DRX_Cycle_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DRX_Cycle_LCR },
  { &hf_nbap_hS_SCCH_Inactivity_Threshold_for_UE_DRX_Cycle_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Inactivity_Threshold_for_UE_DRX_Cycle_LCR },
  { &hf_nbap_hS_SCCH_UE_DRX_Offset_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DRX_Offset_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_HS_SCCH_DRX_Information_ResponseLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_HS_SCCH_DRX_Information_ResponseLCR, HS_SCCH_DRX_Information_ResponseLCR_sequence);

  return offset;
}


static const per_sequence_t E_AGCH_DRX_Parameters_Response_sequence[] = {
  { &hf_nbap_e_AGCH_UE_DRX_Cycle_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DRX_Cycle_LCR },
  { &hf_nbap_e_AGCH_UE_Inactivity_Monitor_Threshold, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_AGCH_UE_Inactivity_Monitor_Threshold },
  { &hf_nbap_e_AGCH_UE_DRX_Offset_LCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UE_DRX_Offset_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_E_AGCH_DRX_Parameters_Response(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_E_AGCH_DRX_Parameters_Response, E_AGCH_DRX_Parameters_Response_sequence);

  return offset;
}


static const value_string nbap_E_AGCH_DRX_Information_ResponseLCR_vals[] = {
  {   0, "sameAsHS-SCCH" },
  {   1, "e-AGCH-DRX-Parameters-Response" },
  { 0, NULL }
};

static const per_choice_t E_AGCH_DRX_Information_ResponseLCR_choice[] = {
  {   0, &hf_nbap_sameAsHS_SCCH  , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   1, &hf_nbap_e_AGCH_DRX_Parameters_Response, ASN1_EXTENSION_ROOT    , dissect_nbap_E_AGCH_DRX_Parameters_Response },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_E_AGCH_DRX_Information_ResponseLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_E_AGCH_DRX_Information_ResponseLCR, E_AGCH_DRX_Information_ResponseLCR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ContinuousPacketConnectivity_DRX_Information_ResponseLCR_sequence[] = {
  { &hf_nbap_enabling_Delay , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Enabling_Delay },
  { &hf_nbap_hS_SCCH_DRX_Information_ResponseLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_HS_SCCH_DRX_Information_ResponseLCR },
  { &hf_nbap_e_AGCH_DRX_Information_ResponseLCR, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_E_AGCH_DRX_Information_ResponseLCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_ContinuousPacketConnectivity_DRX_Information_ResponseLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_ContinuousPacketConnectivity_DRX_Information_ResponseLCR, ContinuousPacketConnectivity_DRX_Information_ResponseLCR_sequence);

  return offset;
}



static int
dissect_nbap_DATA_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_DCH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 895 "./asn1/nbap/nbap.cnf"
  guint32 t_dch_id;
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &t_dch_id, FALSE);

  private_data_set_t_dch_id(actx->pinfo, t_dch_id);



  return offset;
}


static const value_string nbap_UL_FP_Mode_vals[] = {
  {   0, "normal" },
  {   1, "silent" },
  { 0, NULL }
};


static int
dissect_nbap_UL_FP_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_ToAWS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1279U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_ToAWE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2559U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_T_dCH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 900 "./asn1/nbap/nbap.cnf"
  guint32 dch_id;
  gint num_dch_in_flow;
  nbap_dch_channel_info_t* nbap_dch_chnl_info;
  nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &dch_id, FALSE);

  num_dch_in_flow = private_data_get_num_dch_in_flow(actx->pinfo);
  private_data_set_dch_id(actx->pinfo, dch_id);
  if(num_dch_in_flow>0){
      guint32 prev_dch_id = private_data_get_prev_dch_id(actx->pinfo);
      nbap_dch_chnl_info[dch_id].next_dch = 0;
      if(prev_dch_id != 0 && prev_dch_id != 0xffffffff && prev_dch_id != dch_id){
          nbap_dch_chnl_info[prev_dch_id].next_dch = dch_id;
      }
  }



  return offset;
}



static int
dissect_nbap_TransportFormatSet_NrOfTransportBlocks(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1357 "./asn1/nbap/nbap.cnf"
guint32 NrOfTransportBlocks;
guint num_items;
guint32 dch_id;
guint32 common_physical_channel_id;
guint32 common_transport_channel_id;
nbap_dch_channel_info_t* nbap_dch_chnl_info;
nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);

  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 512U, &NrOfTransportBlocks, FALSE);


    if(private_data_get_num_items(actx->pinfo)>0){
        num_items = private_data_get_num_items(actx->pinfo);
        dch_id = private_data_get_dch_id(actx->pinfo);
        if (num_items > 0 && dch_id != 0xffffffff) {
            common_physical_channel_id = private_data_get_common_physical_channel_id(actx->pinfo);
            common_transport_channel_id = private_data_get_common_transport_channel_id(actx->pinfo);
            switch(private_data_get_transport_format_set_type(actx->pinfo)){
                case NBAP_DCH_UL:
                    nbap_dch_chnl_info[dch_id].num_ul_chans++;
                    nbap_dch_chnl_info[dch_id].ul_chan_num_tbs[num_items-1] = NrOfTransportBlocks;
                    break;
                case NBAP_DCH_DL:
                    nbap_dch_chnl_info[dch_id].num_dl_chans++;
                    nbap_dch_chnl_info[dch_id].dl_chan_num_tbs[num_items-1] = NrOfTransportBlocks;
                    break;
                case NBAP_CPCH:
                    nbap_dch_chnl_info[common_physical_channel_id].num_ul_chans++;
                    nbap_dch_chnl_info[common_physical_channel_id].ul_chan_num_tbs[num_items-1] = NrOfTransportBlocks;
                    nbap_dch_chnl_info[common_physical_channel_id].num_dl_chans++;
                    nbap_dch_chnl_info[common_physical_channel_id].dl_chan_num_tbs[num_items-1] = NrOfTransportBlocks;
                    break;
                case NBAP_PCH:
                    nbap_dch_chnl_info[common_transport_channel_id].num_ul_chans++;
                    nbap_dch_chnl_info[common_transport_channel_id].ul_chan_num_tbs[num_items-1] = NrOfTransportBlocks;
                    nbap_dch_chnl_info[common_transport_channel_id].num_dl_chans++;
                    nbap_dch_chnl_info[common_transport_channel_id].dl_chan_num_tbs[num_items-1] = NrOfTransportBlocks;
                    break;
                default:
                    break;
            }
        }
    }



  return offset;
}



static int
dissect_nbap_TransportFormatSet_TransportBlockSize(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1401 "./asn1/nbap/nbap.cnf"
guint32 TransportBlockSize;
guint num_items;
guint32 dch_id;
guint32 common_physical_channel_id;
guint32 common_transport_channel_id;
nbap_dch_channel_info_t* nbap_dch_chnl_info;
nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);

  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5000U, &TransportBlockSize, FALSE);


    if(private_data_get_num_items(actx->pinfo)>0){
        num_items = private_data_get_num_items(actx->pinfo);
        dch_id = private_data_get_dch_id(actx->pinfo);
        if (num_items > 0 && dch_id != 0xffffffff) {
            common_physical_channel_id = private_data_get_common_physical_channel_id(actx->pinfo);
            common_transport_channel_id = private_data_get_common_transport_channel_id(actx->pinfo);
            switch(private_data_get_transport_format_set_type(actx->pinfo)){
                case NBAP_DCH_UL:
                    nbap_dch_chnl_info[dch_id].ul_chan_tf_size[num_items-1] = TransportBlockSize;
                    break;
                case NBAP_DCH_DL:
                    nbap_dch_chnl_info[dch_id].dl_chan_tf_size[num_items-1] = TransportBlockSize;
                    break;
                case NBAP_CPCH:
                    nbap_dch_chnl_info[common_physical_channel_id].ul_chan_tf_size[num_items-1] = TransportBlockSize;
                    nbap_dch_chnl_info[common_physical_channel_id].dl_chan_tf_size[num_items-1] = TransportBlockSize;
                    break;
                case NBAP_PCH:
                    nbap_dch_chnl_info[common_transport_channel_id].ul_chan_tf_size[num_items-1] = TransportBlockSize;
                    nbap_dch_chnl_info[common_transport_channel_id].dl_chan_tf_size[num_items-1] = TransportBlockSize;
                    break;
                default:
                    break;
            }
        }
    }



  return offset;
}


static const value_string nbap_TransportFormatSet_TransmissionTimeIntervalDynamic_vals[] = {
  {   0, "msec-10" },
  {   1, "msec-20" },
  {   2, "msec-40" },
  {   3, "msec-80" },
  { 0, NULL }
};


static int
dissect_nbap_TransportFormatSet_TransmissionTimeIntervalDynamic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TransmissionTimeIntervalInformation_item_sequence[] = {
  { &hf_nbap_transmissionTimeInterval, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_TransmissionTimeIntervalDynamic },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TransmissionTimeIntervalInformation_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TransmissionTimeIntervalInformation_item, TransmissionTimeIntervalInformation_item_sequence);

  return offset;
}


static const per_sequence_t TransmissionTimeIntervalInformation_sequence_of[1] = {
  { &hf_nbap_TransmissionTimeIntervalInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_TransmissionTimeIntervalInformation_item },
};

static int
dissect_nbap_TransmissionTimeIntervalInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_TransmissionTimeIntervalInformation, TransmissionTimeIntervalInformation_sequence_of,
                                                  1, maxTTI_count, FALSE);

  return offset;
}


static const per_sequence_t TDD_TransportFormatSet_ModeDP_sequence[] = {
  { &hf_nbap_transmissionTimeIntervalInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransmissionTimeIntervalInformation },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TDD_TransportFormatSet_ModeDP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TDD_TransportFormatSet_ModeDP, TDD_TransportFormatSet_ModeDP_sequence);

  return offset;
}


static const value_string nbap_TransportFormatSet_ModeDP_vals[] = {
  {   0, "tdd" },
  {   1, "notApplicable" },
  { 0, NULL }
};

static const per_choice_t TransportFormatSet_ModeDP_choice[] = {
  {   0, &hf_nbap_tdd_01         , ASN1_EXTENSION_ROOT    , dissect_nbap_TDD_TransportFormatSet_ModeDP },
  {   1, &hf_nbap_notApplicable  , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_TransportFormatSet_ModeDP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_TransportFormatSet_ModeDP, TransportFormatSet_ModeDP_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TransportFormatSet_DynamicPartList_item_sequence[] = {
  { &hf_nbap_nrOfTransportBlocks, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_NrOfTransportBlocks },
  { &hf_nbap_transportBlockSize, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportFormatSet_TransportBlockSize },
  { &hf_nbap_mode           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_ModeDP },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TransportFormatSet_DynamicPartList_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1353 "./asn1/nbap/nbap.cnf"
    private_data_increment_num_items(actx->pinfo);



  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TransportFormatSet_DynamicPartList_item, TransportFormatSet_DynamicPartList_item_sequence);

  return offset;
}


static const per_sequence_t TransportFormatSet_DynamicPartList_sequence_of[1] = {
  { &hf_nbap_TransportFormatSet_DynamicPartList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_DynamicPartList_item },
};

static int
dissect_nbap_TransportFormatSet_DynamicPartList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1350 "./asn1/nbap/nbap.cnf"
    private_data_set_num_items(actx->pinfo, 0);


  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_TransportFormatSet_DynamicPartList, TransportFormatSet_DynamicPartList_sequence_of,
                                                  1, maxNrOfTFs, FALSE);

  return offset;
}


static const value_string nbap_TransportFormatSet_TransmissionTimeIntervalSemiStatic_vals[] = {
  {   0, "msec-10" },
  {   1, "msec-20" },
  {   2, "msec-40" },
  {   3, "msec-80" },
  {   4, "dynamic" },
  {   5, "msec-5" },
  { 0, NULL }
};


static int
dissect_nbap_TransportFormatSet_TransmissionTimeIntervalSemiStatic(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 1, NULL);

  return offset;
}


static const value_string nbap_TransportFormatSet_ChannelCodingType_vals[] = {
  {   0, "no-codingTDD" },
  {   1, "convolutional-coding" },
  {   2, "turbo-coding" },
  { 0, NULL }
};


static int
dissect_nbap_TransportFormatSet_ChannelCodingType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_TransportFormatSet_CodingRate_vals[] = {
  {   0, "half" },
  {   1, "third" },
  { 0, NULL }
};


static int
dissect_nbap_TransportFormatSet_CodingRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_TransportFormatSet_RateMatchingAttribute(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxRateMatching, NULL, FALSE);

  return offset;
}


static const value_string nbap_TransportFormatSet_CRC_Size_vals[] = {
  {   0, "v0" },
  {   1, "v8" },
  {   2, "v12" },
  {   3, "v16" },
  {   4, "v24" },
  { 0, NULL }
};


static int
dissect_nbap_TransportFormatSet_CRC_Size(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_TransportFormatSet_SecondInterleavingMode_vals[] = {
  {   0, "frame-related" },
  {   1, "timeSlot-related" },
  { 0, NULL }
};


static int
dissect_nbap_TransportFormatSet_SecondInterleavingMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_TransportFormatSet_ModeSSP_vals[] = {
  {   0, "tdd" },
  {   1, "notApplicable" },
  { 0, NULL }
};

static const per_choice_t TransportFormatSet_ModeSSP_choice[] = {
  {   0, &hf_nbap_tdd_02         , ASN1_EXTENSION_ROOT    , dissect_nbap_TransportFormatSet_SecondInterleavingMode },
  {   1, &hf_nbap_notApplicable  , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_TransportFormatSet_ModeSSP(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_TransportFormatSet_ModeSSP, TransportFormatSet_ModeSSP_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TransportFormatSet_Semi_staticPart_sequence[] = {
  { &hf_nbap_transmissionTimeInterval_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_TransmissionTimeIntervalSemiStatic },
  { &hf_nbap_channelCoding  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_ChannelCodingType },
  { &hf_nbap_codingRate     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportFormatSet_CodingRate },
  { &hf_nbap_rateMatchingAttribute, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_RateMatchingAttribute },
  { &hf_nbap_cRC_Size       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_CRC_Size },
  { &hf_nbap_mode_01        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_ModeSSP },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TransportFormatSet_Semi_staticPart(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TransportFormatSet_Semi_staticPart, TransportFormatSet_Semi_staticPart_sequence);

  return offset;
}


static const per_sequence_t TransportFormatSet_sequence[] = {
  { &hf_nbap_dynamicParts   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_DynamicPartList },
  { &hf_nbap_semi_staticPart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet_Semi_staticPart },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TransportFormatSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TransportFormatSet, TransportFormatSet_sequence);

  return offset;
}



static int
dissect_nbap_T_ul_TransportFormatSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1306 "./asn1/nbap/nbap.cnf"
    guint32 dch_id = private_data_get_dch_id(actx->pinfo);
    nbap_dch_channel_info_t* nbap_dch_chnl_info;
    nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);
    private_data_set_transport_format_set_type(actx->pinfo, NBAP_DCH_UL);
    if (dch_id != 0xffffffff) {
        nbap_dch_chnl_info[dch_id].num_ul_chans = 0;
    }


  offset = dissect_nbap_TransportFormatSet(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_nbap_T_dl_TransportFormatSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1315 "./asn1/nbap/nbap.cnf"
    guint32 dch_id = private_data_get_dch_id(actx->pinfo);
    nbap_dch_channel_info_t* nbap_dch_chnl_info;
    nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);
    private_data_set_transport_format_set_type(actx->pinfo, NBAP_DCH_DL);
    if (dch_id != 0xffffffff) {
        nbap_dch_chnl_info[dch_id].num_dl_chans = 0;
    }


  offset = dissect_nbap_TransportFormatSet(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_nbap_FrameHandlingPriority(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string nbap_QE_Selector_vals[] = {
  {   0, "selected" },
  {   1, "non-selected" },
  { 0, NULL }
};


static int
dissect_nbap_QE_Selector(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DCH_Specific_FDD_Item_sequence[] = {
  { &hf_nbap_dCH_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_T_dCH_ID },
  { &hf_nbap_ul_TransportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_T_ul_TransportFormatSet },
  { &hf_nbap_dl_TransportFormatSet, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_T_dl_TransportFormatSet },
  { &hf_nbap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AllocationRetentionPriority },
  { &hf_nbap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FrameHandlingPriority },
  { &hf_nbap_qE_Selector    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_QE_Selector },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DCH_Specific_FDD_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1300 "./asn1/nbap/nbap.cnf"
    private_data_increment_num_dch_in_flow(actx->pinfo);


  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DCH_Specific_FDD_Item, DCH_Specific_FDD_Item_sequence);

#line 1303 "./asn1/nbap/nbap.cnf"
    private_data_set_prev_dch_id(actx->pinfo,private_data_get_dch_id(actx->pinfo));


  return offset;
}


static const per_sequence_t DCH_Specific_FDD_InformationList_sequence_of[1] = {
  { &hf_nbap_DCH_Specific_FDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_Specific_FDD_Item },
};

static int
dissect_nbap_DCH_Specific_FDD_InformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1296 "./asn1/nbap/nbap.cnf"
    private_data_set_num_dch_in_flow(actx->pinfo, 0);
    private_data_set_prev_dch_id(actx->pinfo, 0);


  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DCH_Specific_FDD_InformationList, DCH_Specific_FDD_InformationList_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}


static const per_sequence_t DCH_FDD_InformationItem_sequence[] = {
  { &hf_nbap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PayloadCRC_PresenceIndicator },
  { &hf_nbap_ul_FP_Mode     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UL_FP_Mode },
  { &hf_nbap_toAWS          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ToAWS },
  { &hf_nbap_toAWE          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ToAWE },
  { &hf_nbap_dCH_SpecificInformationList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_Specific_FDD_InformationList },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DCH_FDD_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DCH_FDD_InformationItem, DCH_FDD_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DCH_FDD_Information_sequence_of[1] = {
  { &hf_nbap_DCH_FDD_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_FDD_InformationItem },
};

static int
dissect_nbap_DCH_FDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DCH_FDD_Information, DCH_FDD_Information_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}


static const value_string nbap_DCH_Indicator_For_E_DCH_HSDPA_Operation_vals[] = {
  {   0, "dch-not-present" },
  { 0, NULL }
};


static int
dissect_nbap_DCH_Indicator_For_E_DCH_HSDPA_Operation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DCH_InformationResponseItem_sequence[] = {
  { &hf_nbap_dCH_ID_01      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_ID },
  { &hf_nbap_bindingID      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_BindingID },
  { &hf_nbap_transportLayerAddress, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportLayerAddress },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DCH_InformationResponseItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DCH_InformationResponseItem, DCH_InformationResponseItem_sequence);

  return offset;
}


static const per_sequence_t DCH_InformationResponse_sequence_of[1] = {
  { &hf_nbap_DCH_InformationResponse_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_InformationResponseItem },
};

static int
dissect_nbap_DCH_InformationResponse(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DCH_InformationResponse, DCH_InformationResponse_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}



static int
dissect_nbap_Pattern_Sequence_Identifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrOfDCHMeasurementOccasionPatternSequence, NULL, FALSE);

  return offset;
}


static const value_string nbap_Status_Flag_vals[] = {
  {   0, "activate" },
  {   1, "deactivate" },
  { 0, NULL }
};


static int
dissect_nbap_Status_Flag(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_INTEGER_1_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 9U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_INTEGER_1_512(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 512U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_BIT_STRING_SIZE_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     7, 7, FALSE, NULL, NULL);

  return offset;
}


static const per_sequence_t Measurement_Occasion_Pattern_Sequence_parameters_sequence[] = {
  { &hf_nbap_measurement_Occasion_Pattern_Sequence_parameters_k, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_1_9 },
  { &hf_nbap_measurement_Occasion_Pattern_Sequence_parameters_offset, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_511 },
  { &hf_nbap_measurement_Occasion_Pattern_Sequence_parameters_M_Length, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_1_512 },
  { &hf_nbap_measurement_Occasion_Pattern_Sequence_parameters_Timeslot_Bitmap, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_BIT_STRING_SIZE_7 },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Measurement_Occasion_Pattern_Sequence_parameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Measurement_Occasion_Pattern_Sequence_parameters, Measurement_Occasion_Pattern_Sequence_parameters_sequence);

  return offset;
}


static const per_sequence_t DchMeasurementOccasionInformation_Item_sequence[] = {
  { &hf_nbap_pattern_Sequence_Identifier, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Pattern_Sequence_Identifier },
  { &hf_nbap_status_Flag    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Status_Flag },
  { &hf_nbap_measurement_Occasion_Pattern_Sequence_parameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_Measurement_Occasion_Pattern_Sequence_parameters },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DchMeasurementOccasionInformation_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DchMeasurementOccasionInformation_Item, DchMeasurementOccasionInformation_Item_sequence);

  return offset;
}


static const per_sequence_t DCH_MeasurementOccasion_Information_sequence_of[1] = {
  { &hf_nbap_DCH_MeasurementOccasion_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DchMeasurementOccasionInformation_Item },
};

static int
dissect_nbap_DCH_MeasurementOccasion_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DCH_MeasurementOccasion_Information, DCH_MeasurementOccasion_Information_sequence_of,
                                                  1, maxNrOfDCHMeasurementOccasionPatternSequence, FALSE);

  return offset;
}


static const per_sequence_t DCH_Specific_TDD_Item_sequence[] = {
  { &hf_nbap_dCH_ID_01      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_ID },
  { &hf_nbap_ul_CCTrCH_ID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CCTrCH_ID },
  { &hf_nbap_dl_CCTrCH_ID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_CCTrCH_ID },
  { &hf_nbap_ul_TransportFormatSet_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet },
  { &hf_nbap_dl_TransportFormatSet_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportFormatSet },
  { &hf_nbap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_AllocationRetentionPriority },
  { &hf_nbap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_FrameHandlingPriority },
  { &hf_nbap_qE_Selector    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_QE_Selector },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DCH_Specific_TDD_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DCH_Specific_TDD_Item, DCH_Specific_TDD_Item_sequence);

  return offset;
}


static const per_sequence_t DCH_Specific_TDD_InformationList_sequence_of[1] = {
  { &hf_nbap_DCH_Specific_TDD_InformationList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_Specific_TDD_Item },
};

static int
dissect_nbap_DCH_Specific_TDD_InformationList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DCH_Specific_TDD_InformationList, DCH_Specific_TDD_InformationList_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}


static const per_sequence_t DCH_TDD_InformationItem_sequence[] = {
  { &hf_nbap_payloadCRC_PresenceIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PayloadCRC_PresenceIndicator },
  { &hf_nbap_ul_FP_Mode     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UL_FP_Mode },
  { &hf_nbap_toAWS          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ToAWS },
  { &hf_nbap_toAWE          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_ToAWE },
  { &hf_nbap_dCH_SpecificInformationList_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_Specific_TDD_InformationList },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DCH_TDD_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DCH_TDD_InformationItem, DCH_TDD_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DCH_TDD_Information_sequence_of[1] = {
  { &hf_nbap_DCH_TDD_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_TDD_InformationItem },
};

static int
dissect_nbap_DCH_TDD_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DCH_TDD_Information, DCH_TDD_Information_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}



static int
dissect_nbap_T_dCH_ID_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 918 "./asn1/nbap/nbap.cnf"

  offset = dissect_nbap_DCH_ID(tvb, offset, actx, tree, hf_index);

    private_data_set_dch_id(actx->pinfo, private_data_get_t_dch_id(actx->pinfo));



  return offset;
}



static int
dissect_nbap_T_ul_TransportFormatSet_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1324 "./asn1/nbap/nbap.cnf"
    guint32 dch_id = private_data_get_dch_id(actx->pinfo);
    nbap_dch_channel_info_t* nbap_dch_chnl_info;
    nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);
    private_data_set_transport_format_set_type(actx->pinfo, NBAP_DCH_UL);
    if (dch_id != 0xffffffff) {
        nbap_dch_chnl_info[dch_id].num_ul_chans = 0;
    }


  offset = dissect_nbap_TransportFormatSet(tvb, offset, actx, tree, hf_index);

  return offset;
}



static int
dissect_nbap_T_dl_TransportFormatSet_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1333 "./asn1/nbap/nbap.cnf"
    guint32 dch_id = private_data_get_dch_id(actx->pinfo);
    nbap_dch_channel_info_t* nbap_dch_chnl_info;
    nbap_dch_chnl_info = private_data_get_nbap_dch_chnl_info(actx->pinfo);
    private_data_set_transport_format_set_type(actx->pinfo, NBAP_DCH_DL);
    if (dch_id != 0xffffffff) {
        nbap_dch_chnl_info[dch_id].num_dl_chans = 0;
    }


  offset = dissect_nbap_TransportFormatSet(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const per_sequence_t DCH_ModifySpecificItem_FDD_sequence[] = {
  { &hf_nbap_dCH_ID_02      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_T_dCH_ID_01 },
  { &hf_nbap_ul_TransportFormatSet_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_T_ul_TransportFormatSet_01 },
  { &hf_nbap_dl_TransportFormatSet_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_T_dl_TransportFormatSet_01 },
  { &hf_nbap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_AllocationRetentionPriority },
  { &hf_nbap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_FrameHandlingPriority },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DCH_ModifySpecificItem_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DCH_ModifySpecificItem_FDD, DCH_ModifySpecificItem_FDD_sequence);

  return offset;
}


static const per_sequence_t DCH_ModifySpecificInformation_FDD_sequence_of[1] = {
  { &hf_nbap_DCH_ModifySpecificInformation_FDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_ModifySpecificItem_FDD },
};

static int
dissect_nbap_DCH_ModifySpecificInformation_FDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DCH_ModifySpecificInformation_FDD, DCH_ModifySpecificInformation_FDD_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}


static const per_sequence_t FDD_DCHs_to_ModifyItem_sequence[] = {
  { &hf_nbap_ul_FP_Mode     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UL_FP_Mode },
  { &hf_nbap_toAWS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ToAWS },
  { &hf_nbap_toAWE          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ToAWE },
  { &hf_nbap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportBearerRequestIndicator },
  { &hf_nbap_dCH_SpecificInformationList_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_ModifySpecificInformation_FDD },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_FDD_DCHs_to_ModifyItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
#line 1440 "./asn1/nbap/nbap.cnf"

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_FDD_DCHs_to_ModifyItem, FDD_DCHs_to_ModifyItem_sequence);

    /*g_warning("I'm going to modify dch_id: %d and t_dch_id: %d",private_data_get_dch_id(actx->pinfo),private_data_get_t_dch_id(actx->pinfo));
    */



  return offset;
}


static const per_sequence_t FDD_DCHs_to_Modify_sequence_of[1] = {
  { &hf_nbap_FDD_DCHs_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_FDD_DCHs_to_ModifyItem },
};

static int
dissect_nbap_FDD_DCHs_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_FDD_DCHs_to_Modify, FDD_DCHs_to_Modify_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}


static const per_sequence_t DCH_ModifySpecificItem_TDD_sequence[] = {
  { &hf_nbap_dCH_ID_01      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_ID },
  { &hf_nbap_ul_CCTrCH_ID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_CCTrCH_ID },
  { &hf_nbap_dl_CCTrCH_ID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_CCTrCH_ID },
  { &hf_nbap_ul_TransportFormatSet_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportFormatSet },
  { &hf_nbap_dl_TransportFormatSet_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_TransportFormatSet },
  { &hf_nbap_allocationRetentionPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_AllocationRetentionPriority },
  { &hf_nbap_frameHandlingPriority, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_FrameHandlingPriority },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DCH_ModifySpecificItem_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DCH_ModifySpecificItem_TDD, DCH_ModifySpecificItem_TDD_sequence);

  return offset;
}


static const per_sequence_t DCH_ModifySpecificInformation_TDD_sequence_of[1] = {
  { &hf_nbap_DCH_ModifySpecificInformation_TDD_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_ModifySpecificItem_TDD },
};

static int
dissect_nbap_DCH_ModifySpecificInformation_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DCH_ModifySpecificInformation_TDD, DCH_ModifySpecificInformation_TDD_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}


static const per_sequence_t DCH_ModifyItem_TDD_sequence[] = {
  { &hf_nbap_ul_FP_Mode     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_UL_FP_Mode },
  { &hf_nbap_toAWS          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ToAWS },
  { &hf_nbap_toAWE          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ToAWE },
  { &hf_nbap_transportBearerRequestIndicator, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TransportBearerRequestIndicator },
  { &hf_nbap_dCH_SpecificInformationList_03, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_ModifySpecificInformation_TDD },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DCH_ModifyItem_TDD(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DCH_ModifyItem_TDD, DCH_ModifyItem_TDD_sequence);

  return offset;
}


static const per_sequence_t TDD_DCHs_to_Modify_sequence_of[1] = {
  { &hf_nbap_TDD_DCHs_to_Modify_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DCH_ModifyItem_TDD },
};

static int
dissect_nbap_TDD_DCHs_to_Modify(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_TDD_DCHs_to_Modify, TDD_DCHs_to_Modify_sequence_of,
                                                  1, maxNrOfDCHs, FALSE);

  return offset;
}


static const per_sequence_t DedicatedChannelsCapacityConsumptionLaw_item_sequence[] = {
  { &hf_nbap_dl_Cost_1      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_65535 },
  { &hf_nbap_dl_Cost_2      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_65535 },
  { &hf_nbap_ul_Cost_1      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_65535 },
  { &hf_nbap_ul_Cost_2      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_65535 },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DedicatedChannelsCapacityConsumptionLaw_item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DedicatedChannelsCapacityConsumptionLaw_item, DedicatedChannelsCapacityConsumptionLaw_item_sequence);

  return offset;
}


static const per_sequence_t DedicatedChannelsCapacityConsumptionLaw_sequence_of[1] = {
  { &hf_nbap_DedicatedChannelsCapacityConsumptionLaw_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DedicatedChannelsCapacityConsumptionLaw_item },
};

static int
dissect_nbap_DedicatedChannelsCapacityConsumptionLaw(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DedicatedChannelsCapacityConsumptionLaw, DedicatedChannelsCapacityConsumptionLaw_sequence_of,
                                                  1, maxNrOfSF, FALSE);

  return offset;
}


static const value_string nbap_DedicatedMeasurementType_vals[] = {
  {   0, "sir" },
  {   1, "sir-error" },
  {   2, "transmitted-code-power" },
  {   3, "rscp" },
  {   4, "rx-timing-deviation" },
  {   5, "round-trip-time" },
  {   6, "rx-timing-deviation-LCR" },
  {   7, "angle-Of-Arrival-LCR" },
  {   8, "hs-sich-quality" },
  {   9, "best-Cell-Portions" },
  {  10, "rx-timing-deviation-768" },
  {  11, "rx-timing-deviation-384-extended" },
  {  12, "best-Cell-PortionsLCR" },
  { 0, NULL }
};

static value_string_ext nbap_DedicatedMeasurementType_vals_ext = VALUE_STRING_EXT_INIT(nbap_DedicatedMeasurementType_vals);


static int
dissect_nbap_DedicatedMeasurementType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 7, NULL);

  return offset;
}



static int
dissect_nbap_SIR_Error_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 125U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Transmitted_Code_Power_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Rx_Timing_Deviation_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8191U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Round_Trip_Time_Value(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Extension_DedicatedMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_nbap_ProtocolIE_Single_Container(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string nbap_DedicatedMeasurementValue_vals[] = {
  {   0, "sIR-Value" },
  {   1, "sIR-ErrorValue" },
  {   2, "transmittedCodePowerValue" },
  {   3, "rSCP" },
  {   4, "rxTimingDeviationValue" },
  {   5, "roundTripTime" },
  {   6, "extension-DedicatedMeasurementValue" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementValue_choice[] = {
  {   0, &hf_nbap_sIR_Value      , ASN1_EXTENSION_ROOT    , dissect_nbap_SIR_Value },
  {   1, &hf_nbap_sIR_ErrorValue , ASN1_EXTENSION_ROOT    , dissect_nbap_SIR_Error_Value },
  {   2, &hf_nbap_transmittedCodePowerValue, ASN1_EXTENSION_ROOT    , dissect_nbap_Transmitted_Code_Power_Value },
  {   3, &hf_nbap_rSCP           , ASN1_EXTENSION_ROOT    , dissect_nbap_RSCP_Value },
  {   4, &hf_nbap_rxTimingDeviationValue, ASN1_EXTENSION_ROOT    , dissect_nbap_Rx_Timing_Deviation_Value },
  {   5, &hf_nbap_roundTripTime  , ASN1_EXTENSION_ROOT    , dissect_nbap_Round_Trip_Time_Value },
  {   6, &hf_nbap_extension_DedicatedMeasurementValue, ASN1_NOT_EXTENSION_ROOT, dissect_nbap_Extension_DedicatedMeasurementValue },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_DedicatedMeasurementValue(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_DedicatedMeasurementValue, DedicatedMeasurementValue_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DedicatedMeasurementAvailable_sequence[] = {
  { &hf_nbap_dedicatedmeasurementValue, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DedicatedMeasurementValue },
  { &hf_nbap_cFN            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_CFN },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DedicatedMeasurementAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DedicatedMeasurementAvailable, DedicatedMeasurementAvailable_sequence);

  return offset;
}



static int
dissect_nbap_DedicatedMeasurementnotAvailable(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string nbap_DedicatedMeasurementValueInformation_vals[] = {
  {   0, "measurementAvailable" },
  {   1, "measurementnotAvailable" },
  { 0, NULL }
};

static const per_choice_t DedicatedMeasurementValueInformation_choice[] = {
  {   0, &hf_nbap_measurementAvailable_01, ASN1_NO_EXTENSIONS     , dissect_nbap_DedicatedMeasurementAvailable },
  {   1, &hf_nbap_measurementnotAvailable_01, ASN1_NO_EXTENSIONS     , dissect_nbap_DedicatedMeasurementnotAvailable },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_DedicatedMeasurementValueInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_DedicatedMeasurementValueInformation, DedicatedMeasurementValueInformation_choice,
                                 NULL);

  return offset;
}


static const value_string nbap_DelayedActivation_vals[] = {
  {   0, "cfn" },
  {   1, "separate-indication" },
  { 0, NULL }
};

static const per_choice_t DelayedActivation_choice[] = {
  {   0, &hf_nbap_cfn            , ASN1_NO_EXTENSIONS     , dissect_nbap_CFN },
  {   1, &hf_nbap_separate_indication, ASN1_NO_EXTENSIONS     , dissect_nbap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_DelayedActivation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_DelayedActivation, DelayedActivation_choice,
                                 NULL);

  return offset;
}


static const value_string nbap_Execution_Type_vals[] = {
  {   0, "synchronised" },
  {   1, "unsynchronised" },
  { 0, NULL }
};

static const per_choice_t Execution_Type_choice[] = {
  {   0, &hf_nbap_synchronised   , ASN1_NO_EXTENSIONS     , dissect_nbap_CFN },
  {   1, &hf_nbap_unsynchronised , ASN1_NO_EXTENSIONS     , dissect_nbap_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_Execution_Type(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_Execution_Type, Execution_Type_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Activate_Info_sequence[] = {
  { &hf_nbap_activation_type, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Execution_Type },
  { &hf_nbap_initial_dl_tx_power, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Power },
  { &hf_nbap_firstRLS_Indicator, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_FirstRLS_Indicator },
  { &hf_nbap_propagation_delay, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_PropagationDelay },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Activate_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Activate_Info, Activate_Info_sequence);

  return offset;
}


static const per_sequence_t Deactivate_Info_sequence[] = {
  { &hf_nbap_deactivation_type, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Execution_Type },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Deactivate_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Deactivate_Info, Deactivate_Info_sequence);

  return offset;
}


static const value_string nbap_DelayedActivationUpdate_vals[] = {
  {   0, "activate" },
  {   1, "deactivate" },
  { 0, NULL }
};

static const per_choice_t DelayedActivationUpdate_choice[] = {
  {   0, &hf_nbap_activate       , ASN1_NO_EXTENSIONS     , dissect_nbap_Activate_Info },
  {   1, &hf_nbap_deactivate_01  , ASN1_NO_EXTENSIONS     , dissect_nbap_Deactivate_Info },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_DelayedActivationUpdate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_DelayedActivationUpdate, DelayedActivationUpdate_choice,
                                 NULL);

  return offset;
}



static int
dissect_nbap_DeltaSIR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 30U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_INTEGER_0_119(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 119U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_GANSS_Signal_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, TRUE);

  return offset;
}


static const value_string nbap_GANSS_StatusHealth_vals[] = {
  {   0, "udre-scale-1dot0" },
  {   1, "udre-scale-0dot75" },
  {   2, "udre-scale-0dot5" },
  {   3, "udre-scale-0dot3" },
  {   4, "udre-scale-0dot2" },
  {   5, "udre-scale-0dot1" },
  {   6, "no-data" },
  {   7, "invalid-data" },
  { 0, NULL }
};


static int
dissect_nbap_GANSS_StatusHealth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_BIT_STRING_SIZE_10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     10, 10, FALSE, NULL, NULL);

  return offset;
}


static const value_string nbap_UDRE_vals[] = {
  {   0, "udre-minusequal-one-m" },
  {   1, "udre-betweenoneandfour-m" },
  {   2, "udre-betweenfourandeight-m" },
  {   3, "udre-greaterequaleight-m" },
  { 0, NULL }
};


static int
dissect_nbap_UDRE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_INTEGER_M2047_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2047, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_INTEGER_M127_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DGANSS_SignalInformationItem_sequence[] = {
  { &hf_nbap_satId          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_63 },
  { &hf_nbap_gANSS_iod      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_BIT_STRING_SIZE_10 },
  { &hf_nbap_udre           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UDRE },
  { &hf_nbap_ganss_prc      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_M2047_2047 },
  { &hf_nbap_ganss_rrc      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_M127_127 },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DGANSS_SignalInformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DGANSS_SignalInformationItem, DGANSS_SignalInformationItem_sequence);

  return offset;
}


static const per_sequence_t DGANSS_SignalInformation_sequence_of[1] = {
  { &hf_nbap_DGANSS_SignalInformation_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DGANSS_SignalInformationItem },
};

static int
dissect_nbap_DGANSS_SignalInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DGANSS_SignalInformation, DGANSS_SignalInformation_sequence_of,
                                                  1, maxGANSSSat, FALSE);

  return offset;
}


static const per_sequence_t DGANSS_InformationItem_sequence[] = {
  { &hf_nbap_gANSS_SignalId , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_GANSS_Signal_ID },
  { &hf_nbap_gANSS_StatusHealth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_GANSS_StatusHealth },
  { &hf_nbap_dGANSS_SignalInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_DGANSS_SignalInformation },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DGANSS_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DGANSS_InformationItem, DGANSS_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DGANSS_Information_sequence_of[1] = {
  { &hf_nbap_DGANSS_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DGANSS_InformationItem },
};

static int
dissect_nbap_DGANSS_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DGANSS_Information, DGANSS_Information_sequence_of,
                                                  1, maxSgnType, FALSE);

  return offset;
}


static const per_sequence_t DGANSSCorrections_sequence[] = {
  { &hf_nbap_dGANSS_ReferenceTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_INTEGER_0_119 },
  { &hf_nbap_dGANSS_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DGANSS_Information },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DGANSSCorrections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DGANSSCorrections, DGANSSCorrections_sequence);

  return offset;
}



static int
dissect_nbap_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, NULL);

  return offset;
}


static const per_sequence_t DGANSS_Corrections_Req_sequence[] = {
  { &hf_nbap_dGANSS_Signal_ID, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_BIT_STRING_SIZE_8 },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DGANSS_Corrections_Req(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DGANSS_Corrections_Req, DGANSS_Corrections_Req_sequence);

  return offset;
}


static const value_string nbap_PRCDeviation_vals[] = {
  {   0, "one" },
  {   1, "two" },
  {   2, "five" },
  {   3, "ten" },
  { 0, NULL }
};


static int
dissect_nbap_PRCDeviation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DGANSSThreshold_sequence[] = {
  { &hf_nbap_pRCDeviation   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PRCDeviation },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DGANSSThreshold(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DGANSSThreshold, DGANSSThreshold_sequence);

  return offset;
}


static const value_string nbap_UDREGrowthRate_vals[] = {
  {   0, "growth-1-point-5" },
  {   1, "growth-2" },
  {   2, "growth-4" },
  {   3, "growth-6" },
  {   4, "growth-8" },
  {   5, "growth-10" },
  {   6, "growth-12" },
  {   7, "growth-16" },
  { 0, NULL }
};


static int
dissect_nbap_UDREGrowthRate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string nbap_UDREValidityTime_vals[] = {
  {   0, "val-20sec" },
  {   1, "val-40sec" },
  {   2, "val-80sec" },
  {   3, "val-160sec" },
  {   4, "val-320sec" },
  {   5, "val-640sec" },
  {   6, "val-1280sec" },
  {   7, "val-2560sec" },
  { 0, NULL }
};


static int
dissect_nbap_UDREValidityTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DGNSS_ValidityPeriod_sequence[] = {
  { &hf_nbap_udreGrowthRate , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UDREGrowthRate },
  { &hf_nbap_udreValidityTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UDREValidityTime },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DGNSS_ValidityPeriod(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DGNSS_ValidityPeriod, DGNSS_ValidityPeriod_sequence);

  return offset;
}



static int
dissect_nbap_GPSTOW(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 604799U, NULL, FALSE);

  return offset;
}


static const value_string nbap_GPS_Status_Health_vals[] = {
  {   0, "udre-scale-1dot0" },
  {   1, "udre-scale-0dot75" },
  {   2, "udre-scale-0dot5" },
  {   3, "udre-scale-0dot3" },
  {   4, "udre-scale-0dot1" },
  {   5, "no-data" },
  {   6, "invalid-data" },
  { 0, NULL }
};


static int
dissect_nbap_GPS_Status_Health(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_SAT_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_PRC(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2047, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_nbap_Range_Correction_Rate(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SAT_Info_DGPSCorrections_Item_sequence[] = {
  { &hf_nbap_sat_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_SAT_ID },
  { &hf_nbap_iode_dgps      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_BIT_STRING_SIZE_8 },
  { &hf_nbap_udre           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_UDRE },
  { &hf_nbap_prc            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PRC },
  { &hf_nbap_range_correction_rate, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Range_Correction_Rate },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_SAT_Info_DGPSCorrections_Item(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_SAT_Info_DGPSCorrections_Item, SAT_Info_DGPSCorrections_Item_sequence);

  return offset;
}


static const per_sequence_t SAT_Info_DGPSCorrections_sequence_of[1] = {
  { &hf_nbap_SAT_Info_DGPSCorrections_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_SAT_Info_DGPSCorrections_Item },
};

static int
dissect_nbap_SAT_Info_DGPSCorrections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_SAT_Info_DGPSCorrections, SAT_Info_DGPSCorrections_sequence_of,
                                                  1, maxNoSat, FALSE);

  return offset;
}


static const per_sequence_t DGPSCorrections_sequence[] = {
  { &hf_nbap_gpstow         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_GPSTOW },
  { &hf_nbap_status_health  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_GPS_Status_Health },
  { &hf_nbap_satelliteinfo  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_SAT_Info_DGPSCorrections },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DGPSCorrections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DGPSCorrections, DGPSCorrections_sequence);

  return offset;
}


static const per_sequence_t DGPSThresholds_sequence[] = {
  { &hf_nbap_prcdeviation   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_PRCDeviation },
  { &hf_nbap_ie_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DGPSThresholds(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DGPSThresholds, DGPSThresholds_sequence);

  return offset;
}


static const value_string nbap_DiversityControlField_vals[] = {
  {   0, "may" },
  {   1, "must" },
  {   2, "must-not" },
  { 0, NULL }
};


static int
dissect_nbap_DiversityControlField(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_DiversityMode_vals[] = {
  {   0, "none" },
  {   1, "sTTD" },
  {   2, "closed-loop-mode1" },
  {   3, "not-used-closed-loop-mode2" },
  { 0, NULL }
};


static int
dissect_nbap_DiversityMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_nbap_DL_DPCH_SlotFormat(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16U, NULL, TRUE);

  return offset;
}


static const value_string nbap_DL_DPCH_TimingAdjustment_vals[] = {
  {   0, "timing-advance" },
  {   1, "timing-delay" },
  { 0, NULL }
};


static int
dissect_nbap_DL_DPCH_TimingAdjustment(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_TimeSlot(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 14U, NULL, FALSE);

  return offset;
}


static const value_string nbap_MidambleConfigurationBurstType1And3_vals[] = {
  {   0, "v4" },
  {   1, "v8" },
  {   2, "v16" },
  { 0, NULL }
};


static int
dissect_nbap_MidambleConfigurationBurstType1And3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_MidambleShiftLong(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const value_string nbap_MidambleAllocationMode1_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode1_choice[] = {
  {   0, &hf_nbap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   1, &hf_nbap_commonMidamble , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   2, &hf_nbap_ueSpecificMidamble, ASN1_EXTENSION_ROOT    , dissect_nbap_MidambleShiftLong },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_MidambleAllocationMode1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_MidambleAllocationMode1, MidambleAllocationMode1_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type1_sequence[] = {
  { &hf_nbap_midambleConfigurationBurstType1And3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleConfigurationBurstType1And3 },
  { &hf_nbap_midambleAllocationMode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleAllocationMode1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Type1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Type1, Type1_sequence);

  return offset;
}


static const value_string nbap_MidambleConfigurationBurstType2_vals[] = {
  {   0, "v3" },
  {   1, "v6" },
  { 0, NULL }
};


static int
dissect_nbap_MidambleConfigurationBurstType2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_MidambleShiftShort(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5U, NULL, FALSE);

  return offset;
}


static const value_string nbap_MidambleAllocationMode2_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode2_choice[] = {
  {   0, &hf_nbap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   1, &hf_nbap_commonMidamble , ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   2, &hf_nbap_ueSpecificMidamble_01, ASN1_EXTENSION_ROOT    , dissect_nbap_MidambleShiftShort },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_MidambleAllocationMode2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_MidambleAllocationMode2, MidambleAllocationMode2_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type2_sequence[] = {
  { &hf_nbap_midambleConfigurationBurstType2, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleConfigurationBurstType2 },
  { &hf_nbap_midambleAllocationMode_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleAllocationMode2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Type2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Type2, Type2_sequence);

  return offset;
}


static const value_string nbap_MidambleAllocationMode3_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "ueSpecificMidamble" },
  { 0, NULL }
};

static const per_choice_t MidambleAllocationMode3_choice[] = {
  {   0, &hf_nbap_defaultMidamble, ASN1_EXTENSION_ROOT    , dissect_nbap_NULL },
  {   1, &hf_nbap_ueSpecificMidamble, ASN1_EXTENSION_ROOT    , dissect_nbap_MidambleShiftLong },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_MidambleAllocationMode3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_MidambleAllocationMode3, MidambleAllocationMode3_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t Type3_sequence[] = {
  { &hf_nbap_midambleConfigurationBurstType1And3, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleConfigurationBurstType1And3 },
  { &hf_nbap_midambleAllocationMode_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleAllocationMode3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_Type3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_Type3, Type3_sequence);

  return offset;
}


static const value_string nbap_MidambleShiftAndBurstType_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  {   2, "type3" },
  { 0, NULL }
};

static const per_choice_t MidambleShiftAndBurstType_choice[] = {
  {   0, &hf_nbap_type1          , ASN1_EXTENSION_ROOT    , dissect_nbap_Type1 },
  {   1, &hf_nbap_type2          , ASN1_EXTENSION_ROOT    , dissect_nbap_Type2 },
  {   2, &hf_nbap_type3          , ASN1_EXTENSION_ROOT    , dissect_nbap_Type3 },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_MidambleShiftAndBurstType(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_MidambleShiftAndBurstType, MidambleShiftAndBurstType_choice,
                                 NULL);

  return offset;
}


static const value_string nbap_TFCI_Presence_vals[] = {
  {   0, "present" },
  {   1, "not-present" },
  { 0, NULL }
};


static int
dissect_nbap_TFCI_Presence(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_nbap_DPCH_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 239U, NULL, FALSE);

  return offset;
}


static const value_string nbap_TDD_ChannelisationCode_vals[] = {
  {   0, "chCode1div1" },
  {   1, "chCode2div1" },
  {   2, "chCode2div2" },
  {   3, "chCode4div1" },
  {   4, "chCode4div2" },
  {   5, "chCode4div3" },
  {   6, "chCode4div4" },
  {   7, "chCode8div1" },
  {   8, "chCode8div2" },
  {   9, "chCode8div3" },
  {  10, "chCode8div4" },
  {  11, "chCode8div5" },
  {  12, "chCode8div6" },
  {  13, "chCode8div7" },
  {  14, "chCode8div8" },
  {  15, "chCode16div1" },
  {  16, "chCode16div2" },
  {  17, "chCode16div3" },
  {  18, "chCode16div4" },
  {  19, "chCode16div5" },
  {  20, "chCode16div6" },
  {  21, "chCode16div7" },
  {  22, "chCode16div8" },
  {  23, "chCode16div9" },
  {  24, "chCode16div10" },
  {  25, "chCode16div11" },
  {  26, "chCode16div12" },
  {  27, "chCode16div13" },
  {  28, "chCode16div14" },
  {  29, "chCode16div15" },
  {  30, "chCode16div16" },
  { 0, NULL }
};

static value_string_ext nbap_TDD_ChannelisationCode_vals_ext = VALUE_STRING_EXT_INIT(nbap_TDD_ChannelisationCode_vals);


static int
dissect_nbap_TDD_ChannelisationCode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     31, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_DL_Code_InformationItem_sequence[] = {
  { &hf_nbap_dPCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DPCH_ID },
  { &hf_nbap_tdd_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TDD_ChannelisationCode },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TDD_DL_Code_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TDD_DL_Code_InformationItem, TDD_DL_Code_InformationItem_sequence);

  return offset;
}


static const per_sequence_t TDD_DL_Code_Information_sequence_of[1] = {
  { &hf_nbap_TDD_DL_Code_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_TDD_DL_Code_InformationItem },
};

static int
dissect_nbap_TDD_DL_Code_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_TDD_DL_Code_Information, TDD_DL_Code_Information_sequence_of,
                                                  1, maxNrOfDPCHs, FALSE);

  return offset;
}


static const per_sequence_t DL_Timeslot_InformationItem_sequence[] = {
  { &hf_nbap_timeSlot       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TimeSlot },
  { &hf_nbap_midambleShiftAndBurstType, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleShiftAndBurstType },
  { &hf_nbap_tFCI_Presence  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TFCI_Presence },
  { &hf_nbap_dL_Code_Information, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TDD_DL_Code_Information },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_DL_Timeslot_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_DL_Timeslot_InformationItem, DL_Timeslot_InformationItem_sequence);

  return offset;
}


static const per_sequence_t DL_Timeslot_Information_sequence_of[1] = {
  { &hf_nbap_DL_Timeslot_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_DL_Timeslot_InformationItem },
};

static int
dissect_nbap_DL_Timeslot_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_DL_Timeslot_Information, DL_Timeslot_Information_sequence_of,
                                                  1, maxNrOfDLTSs, FALSE);

  return offset;
}


static const value_string nbap_MidambleAllocationMode_vals[] = {
  {   0, "defaultMidamble" },
  {   1, "commonMidamble" },
  {   2, "uESpecificMidamble" },
  { 0, NULL }
};


static int
dissect_nbap_MidambleAllocationMode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string nbap_MidambleConfigurationLCR_vals[] = {
  {   0, "v2" },
  {   1, "v4" },
  {   2, "v6" },
  {   3, "v8" },
  {   4, "v10" },
  {   5, "v12" },
  {   6, "v14" },
  {   7, "v16" },
  { 0, NULL }
};


static int
dissect_nbap_MidambleConfigurationLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t MidambleShiftLCR_sequence[] = {
  { &hf_nbap_midambleAllocationMode_03, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleAllocationMode },
  { &hf_nbap_midambleShift_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_MidambleShiftLong },
  { &hf_nbap_midambleConfigurationLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleConfigurationLCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_MidambleShiftLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_MidambleShiftLCR, MidambleShiftLCR_sequence);

  return offset;
}


static const value_string nbap_Modulation_vals[] = {
  {   0, "qPSK" },
  {   1, "eightPSK" },
  { 0, NULL }
};


static int
dissect_nbap_Modulation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_ChannelisationCodeLCR_sequence[] = {
  { &hf_nbap_tDD_ChannelisationCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TDD_ChannelisationCode },
  { &hf_nbap_modulation     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_Modulation },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TDD_ChannelisationCodeLCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TDD_ChannelisationCodeLCR, TDD_ChannelisationCodeLCR_sequence);

  return offset;
}



static int
dissect_nbap_QPSK_DL_DPCH_TimeSlotFormatTDD_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 24U, NULL, TRUE);

  return offset;
}



static int
dissect_nbap_EightPSK_DL_DPCH_TimeSlotFormatTDD_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 24U, NULL, TRUE);

  return offset;
}


static const value_string nbap_TDD_DL_DPCH_TimeSlotFormat_LCR_vals[] = {
  {   0, "qPSK" },
  {   1, "eightPSK" },
  { 0, NULL }
};

static const per_choice_t TDD_DL_DPCH_TimeSlotFormat_LCR_choice[] = {
  {   0, &hf_nbap_qPSK_01        , ASN1_EXTENSION_ROOT    , dissect_nbap_QPSK_DL_DPCH_TimeSlotFormatTDD_LCR },
  {   1, &hf_nbap_eightPSK       , ASN1_EXTENSION_ROOT    , dissect_nbap_EightPSK_DL_DPCH_TimeSlotFormatTDD_LCR },
  { 0, NULL, 0, NULL }
};

static int
dissect_nbap_TDD_DL_DPCH_TimeSlotFormat_LCR(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_nbap_TDD_DL_DPCH_TimeSlotFormat_LCR, TDD_DL_DPCH_TimeSlotFormat_LCR_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t TDD_DL_Code_LCR_InformationItem_sequence[] = {
  { &hf_nbap_dPCH_ID        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_DPCH_ID },
  { &hf_nbap_tdd_ChannelisationCodeLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TDD_ChannelisationCodeLCR },
  { &hf_nbap_tdd_DL_DPCH_TimeSlotFormat_LCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TDD_DL_DPCH_TimeSlotFormat_LCR },
  { &hf_nbap_iE_Extensions  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_nbap_ProtocolExtensionContainer },
  { NULL, 0, 0, NULL }
};

static int
dissect_nbap_TDD_DL_Code_LCR_InformationItem(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_nbap_TDD_DL_Code_LCR_InformationItem, TDD_DL_Code_LCR_InformationItem_sequence);

  return offset;
}


static const per_sequence_t TDD_DL_Code_LCR_Information_sequence_of[1] = {
  { &hf_nbap_TDD_DL_Code_LCR_Information_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_nbap_TDD_DL_Code_LCR_InformationItem },
};

static int
dissect_nbap_TDD_DL_Code_LCR_Information(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_nbap_TDD_DL_Code_LCR_Information, TDD_DL_Code_LCR_Information_sequence_of,
                                                  1, maxNrOfDPCHLCRs, FALSE);

  return offset;
}


static const per_sequence_t DL_TimeslotLCR_InformationItem_sequence[] = {
  { &hf_nbap_timeSlotLCR    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TimeSlotLCR },
  { &hf_nbap_midambleShiftLCR, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_MidambleShiftLCR },
  { &hf_nbap_tFCI_Presence  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_nbap_TFCI_Presence },
  { &hf_nbap_dL_Code_LCR_Information, ASN1_EXTENSION_ROOT    , ASN1_NO