/* common.h */

/* Copyright (C) 1993 Free Software Foundation, Inc.

This file is part of the GNU Accounting Utilities

The GNU Accounting Utilities are free software; you can redistribute
them and/or modify them under the terms of the GNU General Public
License as published by the Free Software Foundation; either version
2, or (at your option) any later version.

The GNU Accounting Utilities are distributed in the hope that they will
be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Accounting Utilities; see the file COPYING.  If
not, write to the Free Software Foundation, 675 Mass Ave, Cambridge,
MA 02139, USA.  */

#ifndef __CONFIG_H__
#define __CONFIG_H__

#include "config.h"		/* can't hurt!  work that compiler! */
#include "consts.h"

#include <sys/types.h>		/* so the below doesn't barf */

/* including acct.h for the definition of comp_t and so that we don't
   have to include it everywhere else...  Wise?  Dunno. */

#include ACCT_H_FILE

/* defines */

#define stddebug stdout

#define TRUE 1
#define FALSE 0

/* for those machines that don't have this stuff in stdio.h */
#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

#ifndef AHZ
#define AHZ 64
#endif

/* data structures */

struct name_entry {
  struct name_entry *next;
  char *name;
};

/* prototypes */

char *xmalloc (unsigned);
void fatal (char *);
FILE *open_binary (char *);
int desired_name (char *, struct name_entry *);

#ifdef HAVE_COMP_T
double comp_t_2_double (comp_t);
#endif

#endif /* __CONFIG_H__ */
