/*
 * initreq.h    Interface to let init spawn programs on behalf of
 *              other programs/daemons.
 *              Definitions based on sys_term.c from the BSD 4.4
 *              telnetd source.
 *
 * Version:     @(#)initreq.h 1.00 12-Sep-1994 MvS
 *
 * Notes:       Not implemented yet. I am thinking of doing this
 *              with a Unix Domain socket instead of a pipe, so
 *              that init can look up the uid of the requestor
 *              in /proc/net/udp (needs kernel patch).
 */
#ifndef _INITREQ_H
#define _INITREQ_H

#include <sys/param.h>

#define INIT_MAGIC 0x03091969
#define INIT_FIFO  "/etc/init.fifo"

struct init_request {
  int magic;			/* Magic number            */
  char gen_id[8];		/* Beats me..              */
  char tty_id[16];		/* Tty name minus /dev/tty */
  char host[MAXHOSTNAMELEN];    /* Hostname                */
  char term_type[16];		/* Terminal type           */
  int sig;			/* Signal to send          */
  int pid;			/* Process to send to      */
  char exec_name[MAXPATHLEN];	/* Program to execute      */
};

#endif
