case $CONFIG in
'')
	if test -f config.sh; then TOP=.;
	elif test -f ../config.sh; then TOP=..;
	elif test -f ../../config.sh; then TOP=../..;
	elif test -f ../../../config.sh; then TOP=../../..;
	elif test -f ../../../../config.sh; then TOP=../../../..;
	else
		echo "Can't find config.sh."; exit 1
	fi
	. $TOP/config.sh
	;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

case "$d_dosuid" in
*define*) suidperl='suidperl' ;;
*) suidperl='';;
esac

shrpenv=""
case "$d_shrplib" in
*define*)
    patchlevel=`egrep '^#define[ 	]+PATCHLEVEL' patchlevel.h \
	| awk '{print $3}'`
    case "$patchlevel" in
     *[0-9]) plibsuf=.$so.$patchlevel;;
     *)	    plibsuf=.$so;;
    esac
    case "$shrpdir" in
     /usr/lib)	;;
     "")	;;
     *)		shrpenv="env LD_RUN_PATH=$shrpdir";;
    esac
    pldlflags="$cccdlflags";;
*)  plibsuf=.a
    pldlflags="";;
esac

: Prepare dependency lists for Makefile.
dynamic_list=' '
for f in $dynamic_ext; do
    : the dependency named here will never exist
      base=`echo "$f" | sed 's/.*\///'`
    dynamic_list="$dynamic_list lib/auto/$f/$base.$dlext"
done

static_list=' '
static_ai_list=' '
for f in $static_ext; do
	base=`echo "$f" | sed 's/.*\///'`
	static_list="$static_list lib/auto/$f/$base.a"
	if test -f ext/$f/AutoInit.c; then
	    static_ai_list="$static_ai_list ext/$f/AutoInit.c"
	fi
	if test -f ext/$f/AutoInit.pl; then
	    static_ai_list="$static_ai_list ext/$f/AutoInit.pl"
	fi
done

echo "Extracting Makefile (with variable substitutions)"
$spitshell >Makefile <<'!NO!SUBS!'
# Makefile.SH
# This file is derived from Makefile.SH.  Any changes made here will
# be lost the next time you run Configure.
#  Makefile is used to generate makefile.  The only difference
#  is that makefile has the dependencies filled in at the end.
#
#
!NO!SUBS!

$spitshell >>Makefile <<!GROK!THIS!
# I now supply perly.c with the kits, so don't remake perly.c without byacc
BYACC = $byacc
CC = $cc
LD = $ld
bin = $installbin
scriptdir = $scriptdir
privlib = $installprivlib
mansrc = $mansrc
manext = $manext
LDFLAGS = $ldflags
CLDFLAGS = $ldflags

SMALL = $small
LARGE = $large $split
mallocsrc = $mallocsrc
mallocobj = $mallocobj
LNS = $lns
RMS = rm -f
ranlib = $ranlib

# The following are used to build and install shared libraries for
# dynamic loading.
LDDLFLAGS = $lddlflags
CCDLFLAGS = $ccdlflags
DLSUFFIX = .$dlext
PLDLFLAGS = $pldlflags
PLIBSUF = $plibsuf
SHRPENV = $shrpenv

dynamic_ext = $dynamic_list
static_ext = $static_list
ext = \$(dynamic_ext) \$(static_ext)
static_ext_autoinit = $static_ai_list
DYNALOADER = lib/auto/DynaLoader/DynaLoader.a


libs = $libs $cryptlib

public = perl $suidperl

shellflags = $shellflags

## To use an alternate make, set \$altmake in config.sh.
MAKE = ${altmake-make}
!GROK!THIS!

## In the following dollars and backticks do not need the extra backslash.
$spitshell >>Makefile <<'!NO!SUBS!'

CCCMD = `sh $(shellflags) cflags $(perllib) $@`

private = preplibrary lib/ExtUtils/Miniperl.pm lib/Config.pm

scripts =

manpages = perl.man

util =

sh = Makefile.SH cflags.SH makedepend.SH makedir.SH writemain.SH

h1 = EXTERN.h INTERN.h XSUB.h av.h config.h cop.h cv.h dosish.h
h2 = embed.h form.h gv.h handy.h hv.h keywords.h mg.h op.h
h3 = opcode.h patchlevel.h perl.h perly.h pp.h proto.h regcomp.h
h4 = regexp.h scope.h sv.h unixish.h util.h
h = $(h1) $(h2) $(h3) $(h4)

c1 = $(mallocsrc) av.c scope.c op.c doop.c doio.c dump.c hv.c mg.c
c2 = perl.c perly.c pp.c pp_hot.c pp_ctl.c pp_sys.c regcomp.c regexec.c
c3 = gv.c sv.c taint.c toke.c util.c deb.c run.c globals.c

c = $(c1) $(c2) $(c3) miniperlmain.c perlmain.c

obj1 = $(mallocobj) gv.o toke.o perly.o op.o regcomp.o dump.o util.o mg.o
obj2 = hv.o av.o run.o pp_hot.o sv.o pp.o scope.o pp_ctl.o pp_sys.o
obj3 = doop.o doio.o regexec.o taint.o deb.o globals.o

obj = $(obj1) $(obj2) $(obj3)

# Once perl has been Configure'd and built ok you build different
# perl variants (Debugging, Embedded, Multiplicity etc) by saying:
#	make clean; make perllib=libperl<type>.a
# where <type> is some combination of 'd' and(or) 'e' or 'm'.
# See cflags to understand how this works.
#
# Eventually some form of 'make-a-perl' script will automate this
# together with linking a perl executable with any desired
# static modules.
perllib = libperl$(PLIBSUF)

lintflags = -hbvxac

addedbyconf = UU

# grrr
SHELL = /bin/sh

.c.o:
	$(CCCMD) $(PLDLFLAGS) $*.c

all: makefile miniperl $(private) $(public) $(dynamic_ext)
	@echo " "; echo "	Making x2p stuff"; cd x2p; $(MAKE) all
	@echo " "; echo "	Making docs"; cd pod; $(MAKE) all;

# Phony target to force checking subdirectories.
FORCE:

!NO!SUBS!

: Now on to the rest of the Makefile.
$spitshell >>Makefile <<'!NO!SUBS!'
# The $& notation tells Sequent machines that it can do a parallel make,
# and is harmless otherwise.

miniperl: $& miniperlmain.o $(perllib)
	$(CC) $(LARGE) $(CLDFLAGS) -o miniperl miniperlmain.o $(perllib) $(libs)

miniperlmain.o: miniperlmain.c
	$(CCCMD) $(PLDLFLAGS) $*.c

perlmain.c: miniperlmain.c config.sh makefile $(static_ext_autoinit)
	sh writemain $(DYNALOADER) $(static_ext) > tmp
	sh mv-if-diff tmp perlmain.c

perlmain.o: perlmain.c
	$(CCCMD) $(PLDLFLAGS) $*.c

# The file ext.libs is a list of libraries that must be linked in
# for static extensions, e.g. -lm -lgdbm, etc.  The individual
# static extension Makefile's add to it.
ext.libs: $(static_ext)
	-@test -f ext.libs || touch ext.libs

perl: $& perlmain.o $(perllib) $(DYNALOADER) $(static_ext) ext.libs
	$(SHRPENV) $(CC) $(LARGE) $(CLDFLAGS) $(CCDLFLAGS) -o perl perlmain.o $(perllib) $(DYNALOADER) $(static_ext) `cat ext.libs` $(libs)

pureperl: $& perlmain.o $(perllib) $(DYNALOADER) $(static_ext) ext.libs
	purify $(CC) $(LARGE) $(CLDFLAGS) $(CCDLFLAGS) -o pureperl perlmain.o $(perllib) $(DYNALOADER) $(static_ext) `cat ext.libs` $(libs)

quantperl: $& perlmain.o $(perllib) $(DYNALOADER) $(static_ext) ext.libs
	quantify $(CC) $(LARGE) $(CLDFLAGS) $(CCDLFLAGS) -o quantperl perlmain.o $(perllib) $(DYNALOADER) $(static_ext) `cat ext.libs` $(libs)

$(perllib): $& perl.o $(obj)
!NO!SUBS!

case "$d_shrplib" in
*define*)
$spitshell >>Makefile <<'!NO!SUBS!'
	$(LD) $(LDDLFLAGS) -o $@ perl.o $(obj)
!NO!SUBS!
;;
*)
$spitshell >>Makefile <<'!NO!SUBS!'
	rm -f $(perllib)
	ar rcu $(perllib) perl.o $(obj)
	@$(ranlib) $(perllib)
!NO!SUBS!
;;
esac

$spitshell >>Makefile <<'!NO!SUBS!'

# This version, if specified in Configure, does ONLY those scripts which need
# set-id emulation.  Suidperl must be setuid root.  It contains the "taint"
# checks as well as the special code to validate that the script in question
# has been invoked correctly.

suidperl: $& sperl.o perlmain.o $(perllib) $(DYNALOADER) $(static_ext) ext.libs
	$(CC) $(LARGE) $(CLDFLAGS) $(CCDLFLAGS) -o suidperl perlmain.o sperl.o $(perllib) $(DYNALOADER) $(static_ext) `cat ext.libs` $(libs)

sperl.o: perl.c perly.h patchlevel.h $(h)
	$(RMS) sperl.c
	$(LNS) perl.c sperl.c
	$(CCCMD) -DIAMSUID sperl.c
	$(RMS) sperl.c

opcode.h: opcode.pl
	- perl opcode.pl

embed.h: embed_h.sh global.sym interp.sym
	sh embed_h.sh

# We have to call our ./makedir because Ultrix 4.3 make can't handle the line
#	test -d lib/auto || mkdir lib/auto
#
preplibrary: miniperl lib/Config.pm
	@./makedir lib/auto
	@echo "	AutoSplitting perl library"
	@./miniperl -Ilib -e 'use AutoSplit; \
		autosplit_lib_modules(@ARGV)' lib/*.pm lib/*/*.pm

# Take care to avoid modifying lib/Config.pm without reason
lib/Config.pm: config.sh miniperl
	./miniperl configpm tmp
	sh mv-if-diff tmp lib/Config.pm

lib/ExtUtils/Miniperl.pm: miniperlmain.c miniperl minimod.PL lib/Config.pm
	./miniperl minimod.PL > tmp && mv tmp $@

install: all
	./perl installperl

# I now supply perly.c with the kits, so the following section is
# used only if you force byacc to run by saying
# 	make run_byacc
# Since we patch up the byacc output, the perly.fixer script needs
# to run with precisely the same version of byacc as I use.  You
# normally shouldn't remake perly.[ch].

run_byacc:	FORCE
	@ echo 'Expect' 109 shift/reduce and 1 reduce/reduce conflict
	$(BYACC) -d perly.y
	sh $(shellflags) ./perly.fixer y.tab.c perly.c
	mv y.tab.h perly.h
	echo 'extern YYSTYPE yylval;' >>perly.h

# We don't want to regenerate perly.c and perly.h, but they might
# appear out-of-date after a patch is applied or a new distribution is
# made.
perly.c: perly.y
	-@touch perly.c

perly.h: perly.y
	-@touch perly.h

# Extensions:
# Names added to $(dynamic_ext) or $(static_ext) will automatically
# get built.  There should ordinarily be no need to change any of
# this part of makefile.
#
# The dummy dependency is a place holder in case $(dynamic_ext) or
# $(static_ext) is empty.
#
# DynaLoader may be needed for extensions that use Makefile.PL.

$(DYNALOADER):	miniperl preplibrary FORCE
	@sh ext/util/make_ext static $@ LIBPERL_A=$(perllib)

d_dummy $(dynamic_ext):	miniperl preplibrary $(DYNALOADER) FORCE
	@sh ext/util/make_ext dynamic $@ LIBPERL_A=$(perllib)

s_dummy $(static_ext):	miniperl preplibrary $(DYNALOADER) FORCE
	@sh ext/util/make_ext static $@ LIBPERL_A=$(perllib)

clean:
	rm -f *.o *.a all perlmain.c
	rm -f perl.exp ext.libs
	-cd x2p; $(MAKE) clean
	-cd pod; $(MAKE) clean
	-@for x in $(DYNALOADER) $(dynamic_ext) $(static_ext) ; do \
	sh ext/util/make_ext clean $$x ; \
	done
	rm -f perl suidperl miniperl $(perllib)

realclean: clean
	-cd x2p; $(MAKE) realclean
	-cd pod; $(MAKE) realclean
	@for x in $(DYNALOADER) $(dynamic_ext) $(static_ext) ; do \
	sh ext/util/make_ext realclean $$x ; \
	done
	rm -f *.orig */*.orig *~ */*~ core t/core t/c t/perl
	rm -rf $(addedbyconf)
	rm -f Makefile cflags makedepend makedir writemain
	rm -f config.h makefile makefile.old
	rm -f $(private)
	rm -rf lib/auto
	rm -f lib/.exists
	rm -f h2ph h2ph.man c2ph pstruct h2xs makeaperl
	rm -rf .config
	@echo "Note that make realclean does not delete config.sh"

clobber:	realclean
	rm -f config.sh cppstdin

distclean:	clobber

# The following lint has practically everything turned on.  Unfortunately,
# you have to wade through a lot of mumbo jumbo that can't be suppressed.
# If the source file has a /*NOSTRICT*/ somewhere, ignore the lint message
# for that spot.

lint: perly.c $(c)
	lint $(lintflags) $(defs) perly.c $(c) > perl.fuzz

makefile:	Makefile
	$(MAKE) depend

config.h: config.sh
	/bin/sh config_h.SH

# When done, touch perlmain.c so that it doesn't get remade each time.
depend: makedepend
	./makedepend
	- test -s perlmain.c && touch perlmain.c
	cd x2p; $(MAKE) depend

test: miniperl perl preplibrary $(dynamic_ext)
	- cd t && chmod +x TEST */*.t
	- cd t && (rm -f perl; $(LNS) ../perl perl) && ./perl TEST </dev/tty

clist:	$(c)
	echo $(c) | tr ' ' '\012' >.clist

hlist:  $(h)
	echo $(h) | tr ' ' '\012' >.hlist

shlist: $(sh)
	echo $(sh) | tr ' ' '\012' >.shlist

# AUTOMATICALLY GENERATED MAKE DEPENDENCIES--PUT NOTHING BELOW THIS LINE
# If this runs make out of memory, delete /usr/include lines.
!NO!SUBS!

$eunicefix Makefile
case `pwd` in
*SH)
    $rm -f ../Makefile
    ln Makefile ../Makefile
    ;;
esac
rm -f makefile
