/*
 * Mailbox locking.
 * Local hacks for mailbox access should be grafted here.
 *
 * COPYRIGHT
 * Unfortunately the copyright notice for to this file appears to
 * have become separated from the file itself.
 * Unless there are any prior claims to the contrary it is hereby
 * placed under the protection of the GNU General Public License
 * version 2 (or a later version, at your option).
 *
 *  - Ian Jackson <ijackson@nyx.cs.du.edu>
 * 
 * Log:	lock.c,v
 *
 * Revision 1.4  94/09/11  21:06:12  svalente
 * Removed the 90% of the code that I'm not using.
 *
 * Revision 1.3  93/06/30  12:00:00  ijackson
 * Added code to make setgid secure - hopefully!
 *
 * Revision 1.2  88/08/30  16:13:14  network
 * Portability fixes from Ronald Karr <tron@uts.amdahl.com>.
 *
 * This is the lock.c file which is distributed with the deliver program.
 * It has been modified to work with ucb mail
 *	2/1/89		J. Bayer
 */

#include	"rcv.h"
#include	<fcntl.h>
#include	<errno.h>

/*
 * Maximum filename length.
 * Note that this is for _filenames_, not _pathnames_.
 * For AT&T file systems, the usual value is 14.
 * For Berzerkley file systems, use something big like 255.
 * For Linux, use 14 in case /var is a minix filesystem.
 */

#define MAX_NAMESIZE    14

/*
 * Set the gid if the path is in the normal mail spool
 */
static int perhaps_setgid (name, gid)
char *name;
gid_t gid;
{
	char safepath[]= _PATH_MAILDIR;

	if (strncmp (name, safepath, sizeof (safepath)-1) ||
	    strchr (name + sizeof (safepath), '/'))
	{
		return 0;
	}
	return (setgid (gid));
}

/*
 * Return the last component of the given pathname.
 */
/*
 * char *
 * basename(name)
 * char    *name;
 * {
 * 	char    *b;
 * 
 * 	if ((b = strrchr(name, '/')) != NULL)
 * 		++b;
 * 	else
 * 		b = name;
 * 
 * 	return (b);
 * }
 * 
 */
/*
 * Local functions.
 */
char	*dotlock_name __P((char *));
int	 create_lockfile __P((char *));
int	 remove_lockfile __P((char *));

/*
 * Lock a mailbox by name.
 */
int
lock_name(name)
char    *name;
{
	char    *dotlock;
	int	status;

	dotlock = dotlock_name (name);
	if (! dotlock) return (-1);

	status = create_lockfile (dotlock);
	free (dotlock);
	return (status);
}

/*
 * Unlock a mailbox by name.
 */
int
unlock_name(name)
char    *name;
{
	char    *dotlock;
	int	status;

	dotlock = dotlock_name (name);
	if (! dotlock) return (-1);

	status = remove_lockfile (dotlock);
	free (dotlock);
	return (status);
}

/*
 * Return the name of the appropriate ".lock" file for a mailbox.
 */
char *
dotlock_name(name)
char    *name;
{
	char	*lname;
	char    *p;
	int	 n, i;

	n = strlen(name);
	lname = (char *)malloc(n+6);
	strcpy(lname, name);

	/*
	 * We want as much of `basename.lock' as will fit in a string
	 * MAX_NAMESIZE long.
	 */
	for (i = 0, p = basename(lname); (i < MAX_NAMESIZE - 5) && (*p); ++i)
		++p;
	(void) strcpy(p, ".lock");

	return lname;
}

/*
 * Create a lockfile.
 */
int
create_lockfile(name)
char    *name;
{
	int     tries, fd;
	char	buf[10];

	for (tries = 0; tries < 10; ++tries)
	{
		if (tries)
			sleep(1);

		perhaps_setgid(name, effectivegid);

		fd = open(name, O_RDWR|O_CREAT|O_EXCL, 00400);

		setgid(realgid);
                
		if (fd >= 0) {
			sprintf (buf, "%d\n", getpid ());
			write(fd, buf, strlen (buf));
			(void) close(fd);
			if (debug)
				printf("created lockfile %s\n", name);
			return 0;
		}
	}

	fprintf(stderr, "can't create lockfile ");
	perror(name);
	return -1;
}

/*
 * Remove a lockfile.
 */
int
remove_lockfile(name)
char    *name;
{
	int rv;

	perhaps_setgid(name, effectivegid);

	rv = unlink(name);

	setgid(realgid);

        if (rv == -1)
	{
		fprintf(stderr, "can't remove lockfile ");
		perror(name);
		return -1;
	}

	if (debug)
		printf("removed lockfile %s\n", name);

	return 0;
}
