/*
 * pop.h: Header file for the "pop.c" client POP3 protocol
 * implementation.
 * 
 * Copyright (c) 1991,1993 by Jonathan Kamens.
 *
 * Distribution and use of this file is governed by the GNU Public
 * License (version 1 or any later version).
 *
 * If you make any enhancements, bug fixes or porting changes to this
 * file, please make sure that they get sent to me so that I can
 * incorporate them into my master version of it.  Try sending me
 * E-mail at jik@security.ov.com, or, if that fails, at
 * jik@athena.mit.edu.
 *
 * The current version of this file is $Revision: 1.1 $.
 */

#include <stdio.h>

#define GETLINE_MIN 1024	/* the getline buffer starts out this */
				/* size */
#define GETLINE_INCR 1024	/* the getline buffer is grown by this */
				/* size when it needs to grow */

extern char pop_error[];
extern int pop_debug;

typedef struct _PopServer {
     int file, data;
     char *buffer;
     int buffer_size, buffer_index;
     int in_multi;
} *PopServer;

/*
 * Valid flags for the pop_open function.
 */

#define POP_NO_KERBEROS	(1<<0)
#define POP_NO_HESIOD	(1<<1)
#define POP_NO_GETPASS 	(1<<2)

#ifdef __STDC__
#define _ARGS(a) a
#else
#define _ARGS(a) ()
#endif

extern PopServer pop_open _ARGS((char *host, char *username, char *password,
				 int flags));
extern int pop_stat _ARGS((PopServer server, int *count, int *size));
extern int pop_list _ARGS((PopServer server, int message, int **IDs,
			   int **size));
extern char *pop_retrieve _ARGS((PopServer server, int message, int markfrom));
extern int pop_retrieve_first _ARGS((PopServer server, int message,
				     char **response));
extern int pop_retrieve_next _ARGS((PopServer server, char **line));
extern int pop_retrieve_flush _ARGS((PopServer server));
extern int pop_top_first _ARGS((PopServer server, int message, int lines,
				char **response));
extern int pop_top_next _ARGS((PopServer server, char **line));
extern int pop_top_flush _ARGS((PopServer server));
extern int pop_multi_first _ARGS((PopServer server, char *command,
				  char **response));
extern int pop_multi_next _ARGS((PopServer server, char **line));
extern int pop_multi_flush _ARGS((PopServer server));
extern int pop_delete _ARGS((PopServer server, int message));
extern int pop_noop _ARGS((PopServer server));
extern int pop_last _ARGS((PopServer server));
extern int pop_reset _ARGS((PopServer server));
extern int pop_quit _ARGS((PopServer server));
extern void pop_close _ARGS((PopServer));

#undef _ARGS
