;;; hyperlatex.el - Support for Hyperlatex files in AUCtex.

;;
;; $Modified: Friday, September 23, 1994 by otfried $
;;
;; This file is part of Hyperlatex
;; Copyright (C) 1994 Otfried Schwarzkopf	
;;  
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or (at
;; your option) any later version.
;;      
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;     
;; A copy of the GNU General Public License is available on the World
;; Wide web at "http://www.cs.ruu.nl/people/otfried/txt/copying.txt".
;; You can also obtain it by writing to the Free Software Foundation,
;; Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;
;;
;; Simply put this file in the path searched by AUCtex.
;;

;;; Hook
  
(TeX-add-style-hook "hyperlatex"
 (function
  (lambda ()
    (TeX-add-symbols
     '("html" t)
     '("htmladdress" t)
     '("htmlautomenu" t)
     '("htmldepth" t)
     '("htmldirectory" t)
     '("htmlfile" t)
     '("htmlimage" t)
     '("htmlmenu" t)
     '("htmlname" t)
     '("htmlprintindex")
     '("htmlrule" t)
     '("htmlsym" t)
     '("htmlmathitalics")

     '("exampleindent" t)
     '("topnode" t)

     '("htmlonly" t)
     '("texonly" t)

     '("math" t)
     '("S")
     '("cindex" t)

     '("Cite")
     '("Pageref" t)
     '("Ref" t)

     '("back")
     '("bold" t)
     '("cit" t)
     '("code" t) 
     '("dfn" t) 
     '("dmn" t)
     '("emph" t) 
     '("file" t)
     '("italic" t)
     '("kbd" t)
     '("samp" t)
     '("scap" t)
     '("strong" t)
     '("typew" t)
     '("var" t)

     '("clear" t)
     '("set" t)
     '("link" 2)
     '("xlink" 2)
     '("xname" t)
     '("xlabel" t)
     )

    (LaTeX-add-environments "menu" "tex" "ifset" "ifhtml" "iftex"
			    "ifclear" "example")

    (setq paragraph-start
	  (concat
	   "\\("
	   "^[ \t]*$"
	   "\\|"
	   "^[ \t]*"
	   (regexp-quote TeX-esc)
	   "\\("
	   "\\[\\|\\]\\|"  ; display math delimitors
	   "begin\\|end\\|item\\|part\\|chapter\\|label\\|caption\\|"
	   "section\\|subsection\\|subsubsection\\|par\\|noindent\\|"
	   "paragraph\\|include\\|includeonly\\|"
	   "T\\b\\|H\\b\\|H\\b\\|"
	   "cindex\\|"
	   "tableofcontents\\|appendix\\|" (regexp-quote TeX-esc)
	   "\\)"
	   "\\|"
	   "^[ \t]*\\$\\$" ; display math delimitor
	   "\\)" ))
    (setq paragraph-separate
	  (concat
	   "\\("
	   (regexp-quote TeX-esc)
	   "par\\|"
	   "^[ \t]*$\\|"
	   "^[ \t]*"
	   (regexp-quote TeX-esc)
	   "\\("
	   "\\[\\|\\]\\|"  ; display math delimitors
	   "begin\\|end\\|part\\|chapter\\|label\\|caption\\|"
	   "section\\|subsection\\|subsubsection\\|"
	   "paragraph\\|include\\|includeonly\\|"
	   "T\\b\\|H\\b\\|H\\b\\|"
	   "cindex\\|"
	   "tableofcontents\\|appendix\\|" (regexp-quote TeX-esc)
	   "\\)"
	   "\\)"))

    (make-local-variable 'TeX-font-list)
    (setq TeX-font-list
	  (list (list ?\C-b (concat TeX-esc "bold{") "}")
		(list ?\C-c (concat TeX-esc "scap{") "}")
		(list ?\C-e (concat TeX-esc "emph{") "}")
		(list ?\C-i (concat TeX-esc "italic{") "}")
		(list ?\C-s (concat TeX-esc "samp{") "}")
		(list ?\C-t (concat TeX-esc "typew{") "}")
		(list ?s    (concat TeX-esc "strong{") "}")
		(list ?\C-f (concat TeX-esc "file{") "}")
		(list ?\C-d (concat TeX-esc "dfn{") "}")
		(list ?\C-v (concat TeX-esc "var{") "}")
		(list ?k    (concat TeX-esc "key{") "}")
		(list ?\C-k (concat TeX-esc "kbd{") "}")
		(list ?c    (concat TeX-esc "code{") "}")
		(list ?C    (concat TeX-esc "cit{") "}"))))))


;;;
;;; ----------------------------------------------------------------------
;;;
;;; Local Variables:
;;; mode: emacs-lisp
;;; update-last-edit-date: t
;;; End:
;;;

