/*
  Copyright (C) 1997  Dimitrios P. Bouras

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   For author contact information, look in the README file.
*/

/* Constants for xisp and xispdial */

#define MAXNUM_ISP      8	/* number of configurations in options file */
#define MAXLEN_DESCR   32	/* configuration description string length */
#define MAXLEN_PHONE   16	/* phone string length */
#define MAXNUM_TELS     8	/* telephone numbers in options */
#define MAXLEN_ACCOUNT  8	/* account number of characters */
#define MAXLEN_PASSWD   8	/* password characters */
#define MAXNUM_SLINES   8	/* number of saved script lines */
#define MAXLEN_SLINE   32	/* characters in each script line */

/* xISP file names */

#define RCFNAME		".xisprc"		/* for all program options */
#define PIPEFNAME	".xisppipe"		/* named pipe for reporting */
#define ENVFNAME	".xispenv"		/* generated dialer environment */
#define SCRIPTFNAME	".xispscript"	/* generated dialing script */


/* Chat/PPPD interface defines */

#define CHAT		  "/usr/sbin/chat"					/* chat executable */
#define PPPD          "/usr/sbin/pppd"					/* pppd executable */
#define PPPD_OPTIONS  "/usr/lib/ppp/options.xisp"		/* and its options */
#define PPPD_CONNECT  "/usr/lib/ppp/xispdial"			/* pppd connect prog */

#define MAXBUF_CHILD  128	/* buffer size for dialer output reads by xISP */
#define MAXNUM_RETRY  10	/* default total number of dialing tries */
#define MAXSEC_DELAY  5		/* default delay between dials */


/* Modem defines */

#define MODEM_INIT "AT"		/* initialization string; modify as desired */
#define DIAL_TYPE  'T'		/* use 'T' for tone dialing and 'P' for pulse */

