.TH gk_defaultMenu n "19 Jan 1995" "GroupKit"
.SH NAME
gk_defaultMenu \- Create a standard GroupKit menubar
.SH SYNOPSIS
.TP 
\fBgk_defaultMenu\fI pathname \fR?\fIoptions\fR?

.SH "STANDARD OPTIONS"
.nf
.ta 4c 8c 12c
.VS
\fBactiveBackground	bitmap	font	padY
\fBactiveForeground	borderWidth	foreground	relief
\fBanchor	cursor	textVariable	text
\fBbackground	disabledForeground	padX	underline
.VE
.fi

See the ``options'' manual entry for details on the standard options.

.SH DESCRIPTION
This widget is a menu bar that contains pulldown menus.  By default
the menubar contains three menus: File, Collaboration, and Help.
Menus can be added and deleted from the menubar (see the Widget Command
section).

Indices in the menubar may be either integer value or a character
string.  The numeric values indicate the position of the menu, with
0 being the leftmost menu.  The character strings are the names given
to the various menus.  Either of these methods can be used to refer
to the menu's.  However, it is probably less danger to use the numeric
Indices since they will be unique values but the strings may or 
may not be unique.  The menubar initally has a "File", "Collaboration"
and "Help" menus which are at positions 0, 1 and 2 respectively. A
nice way to check the positions and what the menu names are is with
the itemlist command (see Widget Command section).

.SH "WIDGET COMMAND"
The \fBgk_defaultMenu\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.IP
\fIpathName option \fR?\fIarg arg ...\fR?
.LP
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for gk_defaultMenu widgets:
.TP
\fIpathName \fBadd \fIname index\fR
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBgk_defaultMenu\fR
command.
.TP
\fIpathName \fBdelete \fIindex\fR
Delete the item at position \fIindex\fR on the menubar.
.TP
\fIpathName \fBindex active\fR
Set the item at position \fIindex\fR as active.
.TP
\fIpathName \fBindex configure \fI?option? ?value option value...?\fR
Works just like configure except it is for the item at \fIindex\fR.
See \fIpathName \fBconfigure\fR for more details on how configure
works.
.TP
\fIpathName \fBindex deactivate\fR
Set the item at position \fIindex\fR as deactive, not useable.
.TP
\fIpathName \fBitemcommand \fIindex menuCommand\fR
This command allows all of the normal operations to be executed on
the menu fIindex\fR.  Use this to add and delete entries on a menu
as well as adding separators or any other of the usual functions.
See the Tk Menu widget for more details.
.TP
\fIpathName \fBitemconfigure \fIindex ?menuOption? ?value menuOption value ...\fR
Works just like configure except it is for a partiuclar entry on
a the menu at \fIindex\fR.  Refer to the Tk menu widget, in particular
fIpathName \fBentryconfigure\fR for more details.
.TP
\fIpathName \fBitemList\fR
Returns the list of indicies in string format for a particular menubar.  
The position of the string index in this list is its numerical index.

.SH "DEFAULT BINDINGS"
The only default bindings are those that are automatically created for
the menu buttons.

.SH NOTE
This widget is built using the GroupKit class builder; see the
GroupKit User Manual for more information.

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca)
