.TH gk_initConf n "6 Jan 1995" "GroupKit"
.SH NAME
gk_initConf, gk_initGenericRC, gk_initApplication \- 
initializing GroupKit applications
.SH SYNOPSIS
.TP 
\fBgk_initConf\fI argv\fR
.TP 
\fBgk_initGenericRC\fI argv\fR
.TP
\fBgk_initApplication

.SH DESCRIPTION
These commands are used to initialize a GroupKit conference or 
registrar client, which establishes its run-time infrastructure.  
\fBgk_initApplication\fR is called by \fBgk_initConf\fR or 
\fBgk_initGenericRC\fR, so you should not need to call it
directly.

.SH COMMANDS

.TP 
\fBgk_initConf\fI argv\fR
This routine initializes the conference, and should be the first
thing called by a conference application.  It sets up all the information
about the conference and local user, and connects back to the registrar
client to receive messages about newcomers and so on.  For details 
about the runtime architecture, see the \fBgk_runtime\fR manual entry. 
This command invokes \fBgk_initApplication\fR, described below.

.TP
\fBgk_initGenericRC \fIargv\fR
This routine initializes a registrar client, and should be the first
thing called by a registrar client application.  It sets up some
needed information and connects to the central registrar.  More details
on the runtime architecture for registrar clients can be found in
the PostScript user manual.
This command invokes \fBgk_initApplication\fR, described below.

.TP
\fBgk_initApplication
This command is used to initialize a GroupKit application, whether it
be a conference or registrar client.  Programs should not call this
command directly, but instead use either \fBgk_initConf\fR or
\fBgk_initGenericRC\fR as described above.

This command creates both the \fIuserprefs\fR and \fIregistrar\fR
environments, and reads in the user's initialization file,
.groupkitrc, located in their home directory.  If this file is not
present, the user is prompted for the information needed in the
file, and it is created.

.SH "SEE ALSO"
.PP
gk_runtime(n), gk_newenv(n)

.SH AUTHOR
Mark Roseman (roseman@cpsc.ucalgary.ca)
