.TH gk_runtime n "6 Jan 1995" "GroupKit"
.SH NAME
gk_runtime \-
description of GroupKit conference runtime environment

.SH DESCRIPTION
This manual entry describes the runtime environment of GroupKit
conferences and the way its information may be accessed.
This document is broken into several sections: creating the
runtime environment, events generated by GroupKit conferences,
and extracting information from the runtime environment.

This manual entry assumes knowledge of two constructs used in
GroupKit: events and environments.  See \fIgk_newenv(n)\fR and
\fIgk_event(n)\fR respectively.

.SH CREATING THE RUNTIME ENVIRONMENT

The runtime environment for conferences is created via 
\fBgk_initConf\fR.  This routine must be passed several
pieces of information that describe the conference, including
information about the local user.  This information is passed
to the conference program by the registrar client that created
it on its command line.  It is therefore sufficient to pass
\fBgk_initConf\fR the conference's command line arguments (\fIargv\fR).

.SH GROUPKIT CONFERENCE EVENTS

The runtime environment for GroupKit conferences will automatically
take care of users joining and leaving conferences, under the 
direction of its registrar client.  However, if your conference
needs to know about these circumstances, a number of events are 
generated.

Note that your program can intercept these events using either
the gk_on(n) mechanism, or the gk_bind(n) mechanism.

.TP 
\fBnewUserArrived\fR
An event of this type is generated when a new user is joined to the
conference.  The attribute \fIusernum\fR contains the user number of
the newly arrived user, which may be used to find out further
information, as described below.

.TP
\fBuserDeleted\fR
An event of this type is generated when a user leaves the conference.
The attribute \fIusernum\fR contains the user number of the departing
user.  At this point, the user's information has not yet been deleted,
so it can be queried as described below.

.TP
\fBupdateEntrant\fR
An event of this type is sent to one existing user in the conference
when a new user joins.  The recipient of this event can bring the new
user up to date (for example, by sending them a copy of the current
conference state) if this is required by the conference.  The 
attribute \fIusernum\fR specifies the new user to be updated.

.SH EXTRACTING INFORMATION FROM THE RUNTIME ENVIRONMENT

GroupKit maintains the "users" environment containing information
about all conference users, including the local user.  The 
information in this environment may be accessed directly, for 
example as "users local.username" or "users remote.1.username"
to retrieve the user name of either the local user or the remote user
having user number 1.  See the description of peer connections in
the \fIgk_server(n)\fR manual entry for more information on how 
the environment is organized.  

The entry for each user minimally provides the following information:
"userid", "host", "port", and "username".  As well, additional information 
about the local user, the conference itself and the registrar client that
spawned it can be found as "local.usernum", "local.confnum", 
"local.reghost" and "local.regport".  Additional attributes may be
added, and existing ones changed, but do the latter at your own risk!

The following commands are also available to retrieve and change
information in the "users" environment.  They are provided for
compatibility with earlier versions of GroupKit; it is preferable
to access the environment directly.

.TP
\fBgk_getUserAttrib\fI usernum attribute\fR
This command retrieves the value of \fIattribute\fR for the given
\fIusernum\fR.  
\fIUsernum\fR may specify either the local or a remote user.

.TP
\fBgk_setUserAttrib\fI usernum attribute value\fR
This command sets the attribute specified by \fIattribute\fR for
\fIusernum\fR to be \fIvalue\fR.
\fIUsernum\fR may specify either the local or a remote user.

.TP 
\fBgk_getLocalAttrib\fI attribute\fR
This command retrieves the value of \fIattribute\fR for the local user.

.TP
\fBgk_setLocalAttrib\fI attribute value\fR
This command sets the attribute specified by \fIattribute\fR for the
local user to be \fIvalue\fR.

.SH USER PREFERENCES
There is also an environment called "userprefs" which holds user 
preference information.  This is read in from the user's .groupkitrc
file.  This environment is supplemented with the following information:

.TP
\fBuserprefs host\fR
This holds the name of the host the conference is running on.

.TP
\fBuserprefs port\fR
This holds the port number of the socket that listens for connections
from other conference processes.

.TP
\fBuserprefs scriptpath\fR
This holds the name of the directory path where the Tcl script for
the conference was located.  The full path including the file name can
be retrieved via the Tcl global \fBargv0\fR.

.SH "SEE ALSO"
.PP
gk_server(n), gk_initConf(n), gk_event(n), gk_newenv(n), gk_toAll(n)

.SH AUTHOR
Mark Roseman (roseman@cpsc.ucalgary.ca)
