/*
 * tiny-getty.h - This file is part of the tiny-utils package for Linux & ELKS,
 * Copyright (C) 1995, 1996 Nat Friedman <ndf@linux.mit.edu>.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "config.h"

struct settings
{
  const char *tty;    /* Filename of the tty to use */
  const char *login;  /* Full path to the login program */
  const char *issue;  /* Full path to the issue file */
  int set_term; /* true if we should set the TERM environ variable */
  const char *term;   /* string to which we should set the TERM environ var */
#ifdef SUPPORT_SERIAL
  int baud_rate; /* speed of the line */
#endif
};

#ifdef SUPPORT_SERIAL
struct speed
{
  int baud_rate;
  int baud_const;
};

#define NUM_SPEEDS 15

struct speed speed[] = {
  {50, B50},
  {75, B75},
  {110, B110},
  {134, B134},
  {150, B150},
  {200, B200},
  {300, B300},
  {600, B600},
  {1200, B1200},
  {1800, B1800},
  {2400, B2400},
  {4800, B4800},
  {9600, B9600},
  {19200, B19200},
  {38400, B38400}};
#endif /* SUPPORT_SERIAL */

void report_error(const char *err_str1, const char *err_str2, const int fatal);
void parse_commandline(int argc, char **argv, struct settings *settings);
void open_tty(const char *filename);
#ifdef SUPPORT_SERIAL
int baud_constant(int baud_rate);
#endif
void display_issue(const char *filename);
void setup_termio(struct settings *settings);
void get_login(char *login);
