/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  arpainit.c
 * Purpose: Initialize the ARPA network module
 * Entries: init_arpa
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "../../headers/general.h"
#include "../public/net.h"
#include "../public/arpa.h"
#include "../public/romlib.h"
#include "./arpapriv.h"
#include "./tftp.h"
#include "./bootp.h"
#include "./resolve.h"



/*
 **************************************************************************
 * 
 * Global variables for the network library
 *
 */
char    *arpa_module_name;		/* name of init module	*/



/*
 **************************************************************************
 * 
 * ARPA intialization:
 */
void init_arpa(void)
{
  /*
   * Initialize the different ARPA network modules.
   */
#ifndef NODNS
  if (!init_tftp() || !init_bootp() || !init_resolve()) {
#else
  if (!init_tftp() || !init_bootp()) {
#endif
	printf("\nERROR: init_%s\n", arpa_module_name);
	fatal();
  }
}

