.\" t
.\" @(#)FvwmIconMan.1	12/8/96
.TH FvwmIconMan 0.9 "Dec 8 1996"
.UC
.SH NAME
FvwmIconMan \- an Fvwm Icon Manager
.SH SYNOPSIS
FvwmIconMan is spawned by fvwm, so no command line invocation will work.

.SH DESCRIPTION
FvwmIconMan is an icon manager modeled after the TWM icon manager. 
The user may have multiple icon managers, each of which are armed with a list
of window types which it manages. For example, the user may have one manager
which lists only emacs windows, and another which lists everything else. You
may also specify what resolution each icon manager uses, for example, one
icon manager may manage windows on all desks, and another may manage only 
those on the current desk, or page. If you have appplied the MiniIcons patch
to fvwm2, then FvwmIconMan can display the miniature icons for its managed
windows.

Unlike the TWM icon manager, FvwmIconMan is limited in only having the icons 
listed vertically. Also unlike the TWM icon manager, it sports a three 
dimensional look (when the display depth is sufficient). 

You may bind fvwm functions to mouse buttondown events, and to the event 
where the mouse enters one of the buttons. For example, you could bind the
first mouse button to the Iconify function, and the second mouse button to
the Identify function.

FvwmIconMan can be set to display which window currently has the keyboard
focus, and by binding the select event (see below) to the fvwm Focus function,
you can emulate the TWM icon manager's behavior. 

.SH INITIALIZATION
During initialization, FvwmIconMan searches though the fvwm configuration file
for the options which are described below. It is highly recommended that you
make FvwmIconMan be a sticky window. And if you want to make use of the 
followfocus option, and/or binding an action to Focus, then you should make
FvwmIconMan clicktofocus.

.SH INVOCATION
FvwmIconMan can be invoked by inserting the line 'Module FvwmIconMan' in the .fvwmrc file. If FvwmIconMan is to be spawned during fvwm's initialization,
then this line should be placed in the InitFunction and ResetFunction
declarations, or it can be bound to a menu, mouse button, or keystroke to
invoke it later. FvwmIconMan should be placed in the ModulePath (defined in
the .fvwmrc file) in order for fvwm to find it.

If you wish to run FvwmIconMan in a transient mode, such as with the built
in window list, then pass Transient as an argument. The invocation 
"Module FvwmIconMan Transient" will do nicely. In this mode, FvwmIconMan
will pop up one manager window directly under the cursor. When the mouse
button is released, it will execute the appropriate action, and then exit.
Things are somewhat complicated by the fact that you can specify that 
FvwmIconMan create multiple manager windows, behavior which is unsuitable
when running transiently. So, when running transiently, FvwmIconMan will
only create one manager window. Use the manager id 'transient' to specify
options for this manager window.

.SH CONFIGURATION OPTIONS REFERENCE CHART
FvwmIconMan has acquired quite a few options. I assume others share my
dislike of paging though a long manpage, so here is a terse reference
chart describing the available options. They are described in more detail
in the next section.

.ft C                   \" Courier
.nf
Name            Description                Default
.ft P

action          binds command to event     Mouse 0 N sendcommand select select Iconify
background      default background         gray
dontshow        list of windows to ignore  
drawicons       use miniicons              false
focusandselectbutton                       flat,black,white
focusbutton     style for focused buttons  up,black,white
followfocus     show which win has focus   false
font                                       8x13
foreground      default text color         white
format          describes button label     "%c: %i"
geometry                                   100x100
iconname        manger icon name           FvwmIconMan
nummanagers     number of managers         1
plainbutton     style for normal buttons   up,white,gray
resolution      global, desk, or page      global  
selectbutton    style for selected buttons flat,white,gray 
show            list of windows to show
sort            keep managers sorted       true
title           manager title              FvwmIconMan
usewinlist      honor WinListSkip?         true

.fi

.SH CONFIGURATION OPTIONS
With the exception of the nummanagers option, all of the options may be
defined on a per-manager basis. So, for example, the user may have his emacs
manager with a red foreground, and his xterm manager with a blue one. A
configuration line may therefore have one of two forms:

.IP "*FvwmIconMan*optionname optionvalue"
To specify that the \fIoptionname\fP takes the value \fIoptionvalue\fP 
for all managers.
.IP "*FvwmIconMan*managerid*optionname optionvalue"
To specify that the option \fIoptionname\fP takes the value \fIoptionvalue\fP
for manager \fImanagerid\fP. \fIMangerid\fP may either be a positive integer,
or the string "transient". An integral id refers to managers which FvwmIconMan
creates when running normally, and an id of "transient" refers to the single
manager which FvwmIconMan creates when running transiently.

.PP
The following options may be specified:

.IP "*FvwmIconMan*nummanagers \fInum\fP"
\fInum\fP is a positive integer specifying the total number of icon managers.
Since FvwmIconMan would like to know how many managers there are before
handling any manager specific options, this should come first. The default
is 1.

.IP "*FvwmIconMan*[id*]resolution \fIresolution\fP"
Specifies when the manager will display an entry for a certain
window. \fIresolution\fP may take one of the following values: global, desk,
or page. If global, then all windows of the appropriate type (see the show
and dontshow options below) will be shown. If desk, then only those windows 
on the current desk will be down. And if page, then only those windows on the 
current page will be shown. The default is global.

.IP "*FvwmIconMan*[id*]drawicons \fIboolean\fP"
If your version of fvwm2 is capable of using MiniIcons, then this option
determines if FvwmIconMan displays the MiniIcons. Otherwise, it generates
an error message.

.IP "*FvwmIconMan*[id*]font \fIfont\fP"
Specifies the font to be used for labeling the buttons. The default is 8x13.

.IP "*FvwmIconMan*[id*]format \fIformatstring\fP"
A printf like format string which describes the string to be printed in the
manager window for each managed window. Possible flags are: %t, %i, %c, and
%r for the window's title, icon, class, or resource name, respectively. 
The default is "%c: %i". \fBWarning\fP: m4 reserves the word \fIformat\fP, 
so if you use m4, take appropriate action.

.IP "*FvwmIconMan*[id*]geometry \fIgeometry\fP"
Specifies the geometry of the manager. If the geometry is specified with a 
negative y coordinate, then the window manager will grow upwards. Otherwise,
it will shrink downwards.

.IP "*FvwmIconMan*[id*]title \fItitlestring\fP"
Specifies the window title string for that manager window. \fITitlestring\fP
may either be a single word, or a string enclosed in quotes. The default is
"FvwmIconMan".

.IP "*FvwmIconMan*[id*]iconname \fIiconstring\fP"
Specifies the window icon name for that manager window. \fIIconstring\fP
may either be a single word, or a string enclosed in quotes. The default is
"FvwmIconMan".

.IP "*FvwmIconMan*[id*]foreground \fIforeground\fP"
Specifies the default foreground color.

.IP "*FvwmIconMan*[id*]background \fIbackground\fP"
Specifies the default background color.

.IP "*FvwmIconMan*[id*]plainbutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Specifies how normal buttons look. \fIstyle\fP may be one of \fIflat\fP,
\fIup\fP, or \fIdown\fP, and describes how the button is drawn. The
color options are both optional, and if not set, then the default
colors are used. If on a monochrome screen, then the \fIstyle\fP option is
ignored, but must still be set.

.IP "*FvwmIconMan*[id*]selectbutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Same as the plainbutton option, but specifies the look of buttons when the
mouse is over them.

.IP "*FvwmIconMan*[id*]focusbutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Same as the plainbutton option, but specifies the look of buttons whose
windows have the keyboard focus.

.IP "*FvwmIconMan*[id*]focusandselectbutton \fIstyle\fP [\fIforecolor\fP \fIbackcolor\fP]"
Same as the plainbutton option, but specifies the look of buttons which are
both selected, and have the keyboard focus.

.IP "*FvwmIconMan*[id*]action \fItype\fP \fIbinding\fP
Binds an FvwmIconMan command to an event. \fIType\fP may be one of the values:
Key, Mouse, or Select. Actions are described in the following section ACTIONS.

.PP
The two following options control which windows get handled by which
managers. A manager can get two lists, one of windows to show, and one of
windows to ignore. If only the \fIshow\fP list is given, then that manager
will show only the windows in the list. If only the \fIdontshow\fP list is
given, then the manager will show all windows except those in the list. If
both lists are given, then a window will be shown if it is not in the
\fIdontshow\fP list, and in the \fIshow\fP list. And finally, if neither list
is given, then the manager will handle all windows. Each list is made up of
patterns of the form \fItype=pattern\fP, where type is one of \fIclass\fP,
\fIresource\fP, \fItitle\fP, or \fIicon\fP, and pattern is a regular
expression of the same format used in the fvwm style command. Quotes around
the pattern will be taken as part of the regular expression. If a window could
be handled by more than one manager, then the manager with the lowest id gets 
it.

.IP "*FvwmIconMan*[id*]show \fIpattern list\fP"
If a window matches one of the patterns in the list, then it may be handled
by this manager.

.IP "*FvwmIconMan*[id*]dontshow \fIpattern list\fP"
If a window matches one of the patterns in the list, then it may not be
handled by this manager.

.IP "*FvwmIconMan*[id*]usewinlist \fIboolean\fP"
If \fItrue\fP, then honor the WinListSkip style flag. Otherwise, all windows
are subject to possible management according to the show and dontshow lists.

.IP "*FvwmIconMan*[id*]followfocus \fIboolean\fP"
If \fItrue\fP, then the button appearance reflects
which window currently has focus.  Default is false.

.IP "*FvwmIconMan*[id*]sort \fIboolean\fP"
If \fItrue\fP, then the icon manager is kept sorted. Default is true.

.SH ACTIONS
Actions are commands which may be bound to an event of the type: a keypress,
a mouse click, or the mouse entering a window manager button - denoted by
the action types \fIKey\fP, \fIMouse\fP, and \fISelect\fP. 

Normally, actions bound to a mouse click are executed when the button is
pressed. In transient mode, the action is executed when the button is
released, since it is assumed that FvwmIconMan was bound to some mouse
event. A tip/warning: FvwmIconMan still keeps track of the mouse button
and any modifier keys in this case, so if you bind FvwmIconMan to say,
meta-button3, then it would be wise to ensure that the action you want
to execute will be executed when the meta-button3 event occurs (which would
be the button release, assuming you kept your finger on the meta key).

The syntax for actions are:

.IP "\fBKey actions\fP: Key \fIKeysym\fP \fIModifiers\fP \fIFunction\fP"
\fIKeysym\fP and \fIModifiers\fP are exactly the same as for the fvwm \fIKey\fP
command. 

.IP "\fBMouse actions\fP: Mouse \fIButton\fP \fIModifiers\fP \fIFunction\fP"
\fIButton\fP and \fIModifiers\fP are exactly the same as for the fvwm 
\fIMouse\fP command.

.IP "\fBSelect actions\fP: Select \fIFunction\fP"

.PP
Commands take four types of arguments: \fIManager\fP, \fIWindow\fP, 
\fIButton\fP, and \fIString\fP. A \fIString\fP is a string specifed exactly 
as for fvwm - either in quotes or as a single word not in quotes. 

\fIManager\fP, \fIWindow\fP, and \fIButton\fP types all look exactly the same
in the .fvwmrc file, but are interpreted either as specifing a manager, a
window, or a window manager button corresponding to a window. They can either
be an integer (which is intepreted module N where N is the number of nonempty
managers or buttons - so 0 is the first and -1 is the last), or a simple
additive expression of the form "\fIbutton\fP [+-] \fIinteger\fP" where
\fIbutton\fP can be \fIselect\fP or \fIfocus\fP to specify the manager or
button which is currently selected or focused. If \fIselect\fP or \fIfocus\fP
is used in a command, then whenever it is executed it will do nothing if there
is in fact no selected (or focused) window. FvwmIconMan uses the same rules to
tokenize as fvwm, so you must seperate all tokens with whitespace.

The following functions are currently defined:
.IP "lowermanager"
Lowers all manager windows.

.IP "raisemanager"
Raises all manager windows.

.IP "selectbutton \fIManager\fP \fIButton\fP"
Selects the button specified by \fIManager\fP and \fIButton\fP.

.IP "sendcommand \fIManager\fP \fIWindow\fP \fICommand\fP"
Sends the fvwm command \fICommand\fP to the window specified by \fIManager\fP
and \fIWindow\fP.

.IP "quit"
Quits FvwmIconMan.

.IP "warp \fIManager\fP \fIButton\fP"
Warps the cursor to the button specified by \fIManager\fP and \fIButton\fP.

.PP
.B Examples:
.IP "selectbutton select select + 1"
Selects the button below the currently selected button.

.IP "selectbutton select select - 1"
Selects the button above the currently selected button.

.IP "selectbutton select 0"
Selects the first button of the current manager.

.IP "selectbutton select -1"
Selects the last button of the current manager.

.IP "selectbutton focus focus"
Selects the button corresponding to the focused window.

.IP "sendcommand focus focus Iconify"
Sends the fvwm command Iconify to the focused window.

.PP
In addition to being bound to keys and mice, actions can be sent from fvwm to
FvwmIconMan via the SendToModule command. Don't quote the command when using
SendToModule.

When parsing commands which use \fIButton\fP type arguments, FvwmIconMan first
determines the manager, and then finds the button or window. This has the
potential for confusing effects.

Again: if you use \fIselect\fP or \fIfocus\fP in an argument to a command,
then that command will only be executed when it can find such a window. For
example, when the mouse leaves a manager window, there is no selected button,
so sending a command with SendToModule which expects one will result in 
nothing happening. Sending "selectbutton 0 0" or similar will work fine.

.SH SAMPLE CONFIGURATIONS
This first example is of a the simplest invocation of FvwmIconMan, which only
has one manager, and handles all windows:

.nf
.sp
##############################################################
# Load any modules which should be started during 
# fvwm initialization
ModulePath /usr/lib/X11/fvwm:/usr/bin/X11
Module FvwmIconMan

# Make FvwmIconMan title-bar-less, sticky, and give it an icon	
Style "Fvwm*"      Icon toolbox.xpm,NoTitle,NoHandles,Sticky
Style "FvwmIconMan" HandleWidth 5, Handles, BorderWidth 5


##############################################################
##############################################################
#Definitions used by the modules

*FvwmIconMan*nummanagers 1
*FvwmIconMan*resolution  global
*FvwmIconMan*background  slategrey
*FvwmIconMan*foreground  white
*FvwmIconMan*font        7x13
*FvwmIconMan*geometry    194x100-0+73
.sp
.fi

This example is my personal configuration. It has two managers, one for emacs
and one for everything else, minus things with no icon title. Only windows on
the current page are displayed. Note how the geometry and show options are
specified per manager, and the others are common to all:

.nf
.sp
*FvwmIconMan*numManagers 2
*FvwmIconMan*Resolution  page
*FvwmIconMan*background  steelblue
*FvwmIconMan*foreground  white
*FvwmIconMan*font        7x13
*FvwmIconMan*action      Mouse  1 N sendcommand select select Iconify
*FvwmIconMan*action      Mouse  2 N sendcommand select select Iconify
*FvwmIconMan*action      Mouse  3 N sendcommand select select "Module FvwmIdent FvwmIdent"
*FvwmIconMan*action      Select     sendcommand select select Focus
*FvwmIconMan*action      Key    q N quit
*FvwmIconMan*followfocus true
*FvwmIconMan*sort        true
*FvwmIconMan*format      "%i"
*FvwmIconMan*plainbutton          up white steelblue
*FvwmIconMan*selectbutton         down white steelblue
*FvwmIconMan*focusbutton          up white brown
*FvwmIconMan*focusandselectButton down white brown

*FvwmIconMan*1*geometry   194x100-204-90
*FvwmIconMan*1*show       resource=emacs resource=gemacs
*FvwmIconMan*1*title      "Emacs windows"
*FvwmIconMan*1*iconname   "FvwmIconMan: Emacs"


*FvwmIconMan*2*geometry   194x100-0-90
*FvwmIconMan*2*dontshow   icon=Untitled
*FvwmIconMan*2*title      "All windows"
*FvwmIconMan*2*iconname   "FvwmIconMan: all"

*FvwmIconMan*transient*geometry 194x100
*FvwmIconMan*transient*dontshow icon=Untitled
*FvwmIconMan*transient*action   Mouse 0 A sendcommand select select Iconify

.sp
.fi

For mouseless operation, these actions could be useful:

.nf
.sp

*FvwmIconMan*action Key  Down    S warp select select + 1
*FvwmIconMan*action Key  Up      S warp select select - 1
*FvwmIconMan*action Key  Left    S warp select - 1 0
*FvwmIconMan*action Key  Right   S warp select + 1 0
*FvwmIconMan*action Key  Down    N selectbutton select select + 1
*FvwmIconMan*action Key  Up      N selectbutton select select - 1
*FvwmIconMan*action Key  Left    N selectbutton select - 1 0
*FvwmIconMan*action Key  Right   N selectbutton select + 1 0
*FvwmIconMan*action Key  Return  N sendcommand select select Iconify
*FvwmIconMan*action Key  space   N sendcommand select select Focus
*FvwmIconMan*action Key  End     N selectbutton select -1
*FvwmIconMan*action Key  Home    N selectbutton select 0

Key Down  A M SendToModule FvwmIconMan sendcommand focus focus + 1 Focus
Key Up    A M SendToModule FvwmIconMan sendcommand focus focus - 1 Focus
Key Left  A M SendToModule FvwmIconMan sendcommand focus - 1 0 Focus
Key Right A M SendToModule FvwmIconMan sendcommand focus + 1 0 Focus
.sp
.fi

.SH UNFINISHED BUSINESS
There is one bug that I know of. A honest to goodness solution to this would
be appreciated. When an icon manager is set to grow upwards, on some machines
it may wander occasionally.

When a manager is in page resolution, and the page is switched, the manager
updates the windows after every fvwm event comes in, causing it to rapidly
grow and shrink until it finally settles into the new configuration. This
doesn't happen when in desk resolution.

It doesn't handle windows without resource names as gracefully as it should.

Actions need to be refined.

.SH AUTHOR
Brady Montz (bradym@cs.arizona.edu).

.SH THANKS
Thanks to David Berson (berson@cs.pitt.edu).
