/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/prgm/project/bigloo/cigloo0.0/Example/c-file.c           */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Thu Dec  7 13:08:17 1995                          */
/*    Last change :  Sun Dec 10 14:16:56 1995 (serrano)                */
/*    -------------------------------------------------------------    */
/*    The C part                                                       */
/*=====================================================================*/

#include "c-file.h"

double
vect_norm( Vect *vect )
{
   double d1 = (vect->p1.x - vect->p2.x);
   double d2 = (vect->p1.x - vect->p2.y);
   
   return sqrt( (d1 * d1) + (d2 * d2) );
}

Vect *
vect_neg( Vect *v )
{
   Vect *new;

   new = malloc( sizeof( struct vect ) );

   new->p1.x = -v->p1.x;
   new->p1.y = -v->p1.y;
   new->p2.x = -v->p2.x;
   new->p2.y = -v->p2.y;
   
   return new;
}

Vect *
vect_add( Vect *v1, Vect *v2 )
{
   Vect *new;

   new = malloc( sizeof( struct vect ) );

   new->p1.x = (v1->p1.x + v2->p1.x);
   new->p1.y = (v1->p1.y + v2->p1.y);
   new->p2.x = (v1->p2.x + v2->p2.x);
   new->p2.y = (v1->p2.y + v2->p2.y);
   
   return new;
}
