;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/duplicate.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Dec 31 07:26:21 1994                          */
;*    Last change :  Tue Feb  6 15:32:53 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We copy an `Ast'                                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_duplicate
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_error
	    tools_shape
	    tools_misc
	    tools_location
	    engine_param
	    parse_definition
	    type_env
	    ast_dump
	    ast_env
	    ast_global
	    ast_local)
   (export  (duplicate-ast <quoi.par>* <ast>)))

;*---------------------------------------------------------------------*/
;*    duplicate-ast ...                                                */
;*    -------------------------------------------------------------    */
;*    We copy an Ast will performing the substitution from `quoi'      */
;*    by `par'.                                                        */
;*---------------------------------------------------------------------*/
(define (duplicate-ast quoi.par ast)
   (trace loop "duplicate-ast: "
	  (shape ast)
	  #\Newline
	  (map (lambda (q.p)
		  (shape (car q.p)) (shape (cdr q.p)))
	       quoi.par)
	  #\Newline)
   ;; we set alpha-fast slot 
   (for-each (lambda (q.p)
		(variable-fast-alpha-set! (car q.p) (cdr q.p)))
	     quoi.par)
   (let ((res (duplicate ast)))
      ;; we remove alpha-fast slots
      (for-each (lambda (q.p)
		   (variable-fast-alpha-set! (car q.p) #f))
		quoi.par)
      res))

;*---------------------------------------------------------------------*/
;*    duplicate ...                                                    */
;*    -------------------------------------------------------------    */
;*    We allocate a new Ast                                            */
;*---------------------------------------------------------------------*/
(define (duplicate ast)
   (trace loop "duplicate: " (ast->sexp ast) #\Newline)
   (ast-case ast
      ((atom)
       (ast-atom (ast-location ast)
		 (ast-type ast)
		 (ast-info ast)
		 (atom-value ast)))
      ((var)
       (let* ((var   (var-variable ast))
	      (alpha (variable-fast-alpha var)))
	  (cond
	     ((not alpha)
	      (trace inline "not alpha" #\Newline)
	      (variable-occurrence-set! var
					(+fx (variable-occurrence var) 1))
	      (ast-var (ast-location ast)
		       (ast-type ast)
		       (ast-info ast)
		       var))
	     ((var? alpha)
	      (trace inline "var? alpha" #\Newline)
	      (let ((new (ast-var (ast-location ast)
				  #f
				  (ast-info ast)
				  (var-variable alpha))))
		 (variable-occurrence-set! (var-variable new)
					   (+fx (variable-occurrence
						 (var-variable new))
						1))
		 new))
	     ((fun? alpha)
	      (duplicate alpha))
	     ((atom? alpha)
	      alpha)
	     ((variable? alpha)
	      (trace inline "variable? alpha" #\Newline)
	      (variable-occurrence-set! alpha
					(+fx (variable-occurrence alpha) 1))
	      (ast-var (ast-location ast)
		       #f
		       (ast-info ast)
		       alpha))
	     (else
	      (trace inline "alpha: " alpha)
	      (internal-error "duplicate"
			      "Illegal substitution"
			      (ast->sexp ast))))))
      ((kwote)
       (ast-kwote (ast-location ast)
		  (ast-type ast)
		  (ast-info ast)
		  (kwote-value ast)
		  (kwote-cfa-info ast)))
      ((sequence)
       (ast-sequence (ast-location ast)
		     (ast-type ast)
		     (ast-info ast)
                     (map duplicate (sequence-exp ast))))
      ((make-box)
       (ast-make-box (ast-location ast)
		     (ast-type ast)
		     (ast-info ast)
		     (duplicate (make-box-value ast))))
      ((box-ref)
       (ast-box-ref (ast-location ast)
		    (ast-type ast)
		    (ast-info ast)
		    (duplicate (box-ref-var ast))))
      ((box-set!)
       (ast-box-set! (ast-location ast)
		     (ast-type ast)
		     (ast-info ast)
		     (duplicate (box-set!-var ast))
		     (duplicate (box-set!-value ast))))
      ((setq)
       (let ((ast (ast-setq (ast-location ast)
			    (ast-type ast)
			    (ast-info ast)
			    (duplicate (setq-var ast))
			    (duplicate (setq-val ast)))))
	  (if (not (var? (setq-var ast)))
	      (internal-error "ast-duplicate"
			      "Illegal duplication"
			      (ast->sexp ast))
	      ast)))
      ((conditional)
       (ast-conditional (ast-location ast)
			(ast-type ast)
			(ast-info ast)
			(duplicate (conditional-test ast))
			(duplicate (conditional-then ast))
			(duplicate (conditional-else ast))))
      ((fail)
       (ast-fail (ast-location ast)
		 (ast-type ast)
		 (ast-info ast)
		 (duplicate (fail-proc ast))
		 (duplicate (fail-msg ast))
		 (duplicate (fail-obj ast))))
      ((let-fun)
       (duplicate-let-fun ast))
      ((let-var)
       (duplicate-let-var ast))
      ((app-ly)
       (ast-app-ly (ast-location ast)
		   (ast-type ast)
		   (ast-info ast)
		   (duplicate (app-ly-fun ast))
		   (duplicate (app-ly-value ast))))
      ((app)
       (ast-app (ast-location ast)
		(ast-type ast)
		(ast-info ast)
		(duplicate (app-fun ast))
		(map duplicate (app-actuals ast))
		(app-cfa-info ast)
		(app-cfa-info-aux ast)
		(app-stack-info ast)
		(app-tvector-info ast)))
      ((funcall)
       (ast-funcall (ast-location ast)
		    (ast-type ast)
		    (ast-info ast)
		    (duplicate (funcall-fun ast))
		    (map duplicate (funcall-actuals ast))
		    #unspecified))
      ((fun)
       (ast-fun (ast-location ast)
		(ast-type ast)
		(ast-info ast)
		(duplicate (fun-value ast))))
      ((set-ex-it)
       (let* ((old-exit (var-variable (set-ex-it-exit ast)))
	      (new-exit (make-local-variable 'dummy (local-type old-exit))))
	  (assert check (old-exit) (and (boolean? (local-fast-alpha old-exit))
					(not (local-fast-alpha old-exit))))
	  (let ((key (local-key new-exit)))
	     (struct-update! new-exit (var-variable (set-ex-it-exit ast)))
	     (local-value-set! new-exit (make-return))
	     (let* ((old-hdlg (return-handler (local-value old-exit)))
		    (new-hdlg (if (variable? (local-fast-alpha old-hdlg))
				  (local-fast-alpha old-hdlg)
				  old-hdlg)))
		(return-detached-set! (local-value new-exit)
				      (return-detached
				       (local-value old-exit)))
		(return-handler-set! (local-value new-exit) new-hdlg))
	     (local-key-set! new-exit key))
	  (local-fast-alpha-set! old-exit new-exit)
	  (let ((body (duplicate (set-ex-it-body ast))))
	     (local-fast-alpha-set! old-exit #f)
	     (ast-set-ex-it (ast-location ast)
			   (ast-type ast)
			   (ast-info ast)
			   (ast-var (ast-location (set-ex-it-exit ast))
				    (ast-type (set-ex-it-exit ast))
				    #f
				    new-exit)
			   body))))
      ((jump-ex-it)
       (ast-jump-ex-it (ast-location ast)
		      (ast-type ast)
		      (ast-info ast)
		      (duplicate (jump-ex-it-exit ast))
		      (duplicate (jump-ex-it-value ast))))
      ((switch)
       (ast-switch (ast-location ast)
		   (ast-type ast)
		   (ast-info ast)
		   (duplicate (switch-test ast))
		   (map (lambda (clause)
			   (cons (car clause)
				 (duplicate (cdr clause))))
			(switch-clauses ast))))
      ((prag-ma)
       (ast-prag-ma (ast-location ast)
		    (ast-type ast)
 		    (ast-info ast)
		    (prag-ma-string ast)
		    (map duplicate (prag-ma-values ast))))))
	 
;*---------------------------------------------------------------------*/
;*    duplicate-let-fun ...                                            */
;*---------------------------------------------------------------------*/
(define (duplicate-let-fun ast)
   ;; first we allocate all the new-functions
   ;; then we compute the new body and the new functions body.
   (let* ((new-funs (map (lambda (fun)
			    (let* ((new (make-local-variable 'dummy
							     (local-type fun)))
				   (key (local-key new)))
			       (struct-update! new fun)
			       (local-key-set! new key)
			       (local-fast-alpha-set! fun new)
			       new))
			 (let-fun-locals ast)))
	  (new-body (duplicate (let-fun-body ast))))
      (for-each (lambda (new old)
		   (duplicate-local-fun new old))
		new-funs
		(let-fun-locals ast))
      ;; we restore fast-alpha slot
      (for-each (lambda (fun)
		   (local-fast-alpha-set! fun #f))
		(let-fun-locals ast))
      ;; we build the `let-fun' form
      (ast-let-fun (ast-location ast)
		   (ast-type ast)
		   (ast-info ast)
		   new-funs
		   new-body)))

;*---------------------------------------------------------------------*/
;*    duplicate-local-fun ...                                          */
;*---------------------------------------------------------------------*/
(define (duplicate-local-fun new old)
   [assert check (new old) (not (eq? new old))] 
   (local-value-set! new (make-function))
   (trace loop "duplicate-local-fun.2: " (shape old) " "
	  (ast->sexp (function-body (local-value old)))
	  #\Newline)
   (struct-update! (local-value new) (local-value old))
   (trace loop "duplicate-local-fun.3: " (shape old) " "
	  (ast->sexp (function-body (local-value old)))
	  #\Newline)
   ;; we allocate formals and we compute the new body
   (let* ((new-args (map (lambda (f)
			    (let* ((nf  (make-local-variable 'dummy
							     (local-type f)))
				   (key (local-key nf)))
			       (struct-update! nf f)
			       (local-key-set! nf key)
			       (local-fast-alpha-set! f nf)
			       nf))
			 (function-args (local-value old))))
	  (new-body (duplicate (function-body (local-value old)))))
      ;; we restore `fast-alpha' slot
      (for-each (lambda (f)
		   (local-fast-alpha-set! f #f))
		(function-args (local-value old)))
      (function-args-set! (local-value new) new-args)
      (function-body-set! (local-value new) new-body)))

;*---------------------------------------------------------------------*/
;*    duplicate-let-var ...                                            */
;*---------------------------------------------------------------------*/
(define (duplicate-let-var ast)
   (let* ((new-bindings (map
			 (lambda (binding)
			    (let* ((local   (car binding))
				   (new-var (make-local-variable 'dummy
								 (local-type
								  local)))
				   (key     (local-key new-var)))
			       (struct-update! new-var local)
			       (local-key-set! new-var key)
			       (local-fast-alpha-set! local new-var)
			       (let ((new-val (duplicate (cdr binding))))
				  (cons new-var new-val))))
			 (let-var-bindings ast)))
	  (new-body   (duplicate (let-var-body ast))))
      ;; we restore fast-alpha slots
      (for-each (lambda (binding)
		   (local-fast-alpha-set! (car binding) #f))
		(let-var-bindings ast))
      ;; we build the new form
      (ast-let-var (ast-location ast)
		   (ast-type ast)
		   (ast-info ast)
		   new-bindings
		   new-body
		   (let-var-removable? ast))))
  
