;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Ast/module.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sat Jul 15 09:28:46 1995                          */
;*    Last change :  Mon Feb 12 17:58:20 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The managment of the module initializations.                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_module
   (include "Ast/ast.sch"
	    "Tools/trace.sch")
   (import  tools_module
	    tools_error
	    tools_shape
	    ast_sexp
	    ast_env
	    engine_param)
   (export (fill-initialize-imported-modules!)))

;*---------------------------------------------------------------------*/
;*    fill-initialize-imported-modules! ...                            */
;*---------------------------------------------------------------------*/
(define (fill-initialize-imported-modules!)
   (let ((fun (find-global 'initialize-imported-modules! *module-name*)))
      (cond
	 ((not (global? fun))
	  (internal-error "fill-initialize-imported-modules!"
			  "Can't find initialization module function"
			  *module-name*))
	 ((not (function? (global-value fun)))
	  (internal-error "fill-initialize-imported-modules!"
			  "Illegal `initialize-imported-modules!' function"
			  (shape fun)))
	 (else
	  (function-body-set! (global-value fun)
			      (sexp->ast `(begin
					     ,@(initialize-imported-modules))
					 '()
					 #f
					 #f
					 'read))))))
	   
;*---------------------------------------------------------------------*/
;*    initialize-imported-modules ...                                  */
;*---------------------------------------------------------------------*/
(define (initialize-imported-modules)
   (trace init "initialize-imported-module.s." #\Newline)
   (let laap ((module (append *used-modules* *used-library-modules*))
	      (res    '(#unspecified)))
      (cond
	 ((null? module)
	  (append *init-functions* res))
	 ((eq? (getprop (car module) 'used) 'done)
	  (laap (cdr module)
		res))
	 (else
	  (putprop! (car module) 'used 'done)
	  (laap (cdr module)
		(cons `((@ ,(module-init-name (car module))
			   ,(car module)))
		      res))))))
				     
