;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Callcc/walk.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 28 10:50:15 1995                          */
;*    Last change :  Tue Apr  9 15:54:39 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    When compiling for call/cc we put all written local variables    */
;*    in cells.                                                        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module callcc_walk
   (include "Tools/pass.sch"
	    "Ast/node.sch")
   (import  tools_error
	    tools_shape
	    type_cache
	    ast_local)
   (export  (callcc-walk! ast)))

;*---------------------------------------------------------------------*/
;*    callcc-walk! ...                                                 */
;*---------------------------------------------------------------------*/
(define (callcc-walk! ast)
   (pass-prelude "Callcc")
   (for-each callcc-function! ast)
   (pass-postlude ast))

;*---------------------------------------------------------------------*/
;*    callcc-function! ...                                             */
;*---------------------------------------------------------------------*/
(define (callcc-function! var)
   (let* ((fun    (variable-value var))
	  (body   (function-body fun))
	  (celled (celled-bindings (function-args fun))))
      ;; we set alpha-fast slot
      (for-each (lambda (w.b)
		   (variable-fast-alpha-set! (car w.b) (cdr w.b)))
		celled)
      (function-body-set! fun (cell-formals celled (callcc! body)))
      ;; we remove alpha-fast slots
      (for-each (lambda (w.b)
		   (variable-fast-alpha-set! (car w.b) #f))
		celled)))

;*---------------------------------------------------------------------*/
;*    celled-bindings ...                                              */
;*---------------------------------------------------------------------*/
(define (celled-bindings formals)
   (let loop ((celled   '())
	      (formals  formals))
      (cond
	 ((null? formals)
	  celled)
	 ((not (celled? (car formals)))
	  (loop celled (cdr formals)))
	 (else
	  (let* ((var (make-local-variable (local-name (car formals)) *obj*))
		 (o.n (cons (car formals) var)))
	     (local-access-set! var 'read)
	     (local-info-set!   var 'celled-callcc)
	     (loop (cons o.n celled)
		   (cdr formals)))))))

;*---------------------------------------------------------------------*/
;*    cell-formals ...                                                 */
;*---------------------------------------------------------------------*/
(define (cell-formals celled body)
   (if (null? celled)
       body
       (let ((loc (ast-location body)))
	  (ast-let-var #f
		       #f
		       #f
		       (map (lambda (o.n)
			       (cons (cdr o.n)
				     (a-make-cell (ast-var loc
							   #f
							   #f
							   (car o.n))
						  (car o.n))))
			    celled)
		       body
		       #t))))

;*---------------------------------------------------------------------*/
;*    a-make-cell ...                                                  */
;*---------------------------------------------------------------------*/
(define (a-make-cell ast var)
   (let ((loc (ast-location ast)))
      (local-access-set! var 'read)
      (local-info-set!   var 'celled-callcc)
      (ast-make-box loc #f #f ast)))

;*---------------------------------------------------------------------*/
;*    celled? ...                                                      */
;*---------------------------------------------------------------------*/
(define (celled? var)
   (and (local? var)
	(or (eq? (local-info var) 'celled-callcc)
	    (eq? (local-access var) 'write))))

;*---------------------------------------------------------------------*/
;*    callcc! ...                                                      */
;*---------------------------------------------------------------------*/
(define (callcc! ast)
   (ast-case ast
      ((atom)
       ast)
      ((var)
       (let ((var (var-variable ast)))
	  (let loop ((var   var)
		     (alpha (variable-fast-alpha var)))
	     (if (local? alpha)
		 (begin
		    (var-variable-set! ast alpha)
		    (loop alpha (variable-fast-alpha alpha)))
		 (cond
		    ((local? alpha)
		     (var-variable-set! ast alpha)
		     (callcc! ast))
		    ((global? var)
		     ast)
		    ((not (celled? var))
		     ast)
		    (else
		     (ast-box-ref (ast-location ast)
				  #f
				  #f
				  ast)))))))
      ((kwote)
       ast)
      ((sequence)
       (callcc*! (sequence-exp ast))
       ast)
      ((app)
       (app-fun-set! ast (callcc! (app-fun ast)))
       (callcc*! (app-actuals ast))
       ast)
      ((prag-ma)
       (callcc*! (prag-ma-values ast))
       ast)
      ((setq)
       (setq-val-set! ast (callcc! (setq-val ast)))
       (let ((var (var-variable (setq-var ast))))
	  (let loop ((var   var)
		     (alpha (variable-fast-alpha var)))
	     (if (local? alpha)
		 (begin
		    (var-variable-set! (setq-var ast) alpha)
		    (loop alpha (variable-fast-alpha alpha)))
		 (cond
		    ((global? var)
		     ast)
		    ((not (celled? var))
		     ast)
		    (else
		     (let ((a-var (make-local-variable (gensym 'a-cell)
						       (local-type var)))
			   (loc   (ast-location ast)))
			(ast-let-var (ast-location ast)
				     #f
				     #f
				     (list (cons a-var (setq-val ast)))
				     (ast-box-set! loc
						   #f
						   #f
						   (setq-var ast)
						   (ast-var loc #f #f a-var))
				     #t))))))))
      ((conditional)
       (conditional-test-set! ast (callcc! (conditional-test ast)))
       (conditional-then-set! ast (callcc! (conditional-then ast)))
       (conditional-else-set! ast (callcc! (conditional-else ast)))
       ast)
      ((fail)
       (fail-proc-set! ast (callcc! (fail-proc ast)))
       (fail-msg-set! ast (callcc! (fail-msg ast)))
       (fail-obj-set! ast (callcc! (fail-obj ast)))
       ast)
      ((app-ly)
       (app-ly-fun-set! ast (callcc! (app-ly-fun ast)))
       (app-ly-value-set! ast (callcc! (app-ly-value ast)))
       ast)
      ((switch)
       (switch-test-set! ast (callcc! (switch-test ast)))
       (for-each (lambda (clause)
		    (set-cdr! clause (callcc! (cdr clause))))
		 (switch-clauses ast))
       ast)
      ((let-fun)
       (for-each callcc-function! (let-fun-locals ast))
       (let-fun-body-set! ast (callcc! (let-fun-body ast)))
       ast)
      ((set-ex-it)
       (set-ex-it-body-set! ast (callcc! (set-ex-it-body ast)))
       ast)
      ((jump-ex-it)
       (jump-ex-it-exit-set! ast (callcc! (jump-ex-it-exit ast)))
       (jump-ex-it-value-set! ast (callcc! (jump-ex-it-value ast)))
       ast)
      ((let-var)
       (for-each (lambda (binding)
		    (let ((var (car binding))
			  (val (cdr binding)))
		       (set-cdr! binding (callcc! val))
		       (if (celled? var)
			   (begin
			      (local-type-set! var *obj*)
			      (set-cdr! binding
					(a-make-cell (cdr binding) var))))))
		 (let-var-bindings ast))
       (let-var-body-set! ast (callcc! (let-var-body ast)))
       ast)))

;*---------------------------------------------------------------------*/
;*    callcc*! ...                                                     */
;*---------------------------------------------------------------------*/
(define (callcc*! ast*)
   (if (null? ast*)
       'done
       (begin
	  (set-car! ast* (callcc! (car ast*)))
	  (callcc*! (cdr ast*)))))
   

