;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Globalize/gn.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 26 14:54:22 1995                          */
;*    Last change :  Wed Oct 11 11:31:58 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We compute the G0 and G1 properties which is defined as follow:  */
;*                                                                     */
;*    Let  A(f,g)  <=> f is a free function in g, called by g          */
;*         E(f)    <=> f is a function used as value                   */
;*                                                                     */
;*    then G0(f,g) <=> E(f) v (#g, E(f) ^ A(g,f))                      */
;*         G1(f,g) <=> G0(f) ^ !(E(f))                                 */
;*                                                                     */
;*    # = exists                                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_Gn
   (include "Globalize/globalize.sch"
	    "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    globalize_globalize)
   (export  (Gn! <local>* <ast> <variable> <variable>*)))
 
;*---------------------------------------------------------------------*/
;*    Gn! ...                                                          */
;*    -------------------------------------------------------------    */
;*    In order to compute the E property, we first compute the E       */
;*    set, the set of all escaping functions. During this tree         */
;*    walk, we compute the call-graph (using the fun-Ginfo             */
;*    structure).                                                      */
;*---------------------------------------------------------------------*/
(define (Gn! args ast caller g)
   ;; we prepare all the formals
   (for-each (lambda (local)
		(local-info-set! local (default-var-Ginfo)))
	     args)
   (set! *E* (E ast caller g))
   (let loop ((G  *E*)
	      (G1 '()))
      (if (null? G)
	  (begin
	     (set! *G0* (append *E* G1))
	     (set! *G1* G1))
	  (let ((new-G (G-from-cto (car G))))
	     (loop (append new-G (cdr G))
		   (append new-G G1))))))
      
;*---------------------------------------------------------------------*/
;*    E ...                                                            */
;*---------------------------------------------------------------------*/
(define (E ast caller g)
   (ast-case ast
      ((atom)
       g)
      ((kwote)
       g)
      ((var)
       g)
      ((make-box)
       (E (make-box-value ast) caller g))
      ((box-ref)
       (E (box-ref-var ast) caller g))
      ((box-set!)
       (E (box-set!-var ast)
	  caller
	  (E (box-set!-value ast)
	     caller
	     g)))
      ((fun)
       (let ((var (var-variable (fun-value ast))))
	  (save-fun! caller var)
	  (if (and (local? var)
		   ;; du to 0cfa, `fun' may introduce non escaping
		   ;; functions
		   (function-escape? (local-value var))
		   (not (fun-Ginfo-G? (local-info var))))
	      (begin
		 (fun-Ginfo-G?-set! (local-info var) #t)
		 (cons var g))
	      g)))
      ((prag-ma)
       (E* (prag-ma-values ast) caller g))
      ((fail)
       (E (fail-proc ast)
	  caller
	  (E (fail-msg ast)
	     caller
	     (E (fail-obj ast)
		caller
		g))))
      ((sequence)
       (E* (sequence-exp ast) caller g))
      ((conditional)
       (E (conditional-test ast)
	  caller
	  (E (conditional-then ast)
	     caller
	     (E (conditional-else ast)
		caller
		g))))
      ((setq)
       (E (setq-val ast) caller g))
      ((let-var)
       (let loop ((bindings (let-var-bindings ast))
		  (g        g))
	  (if (null? bindings)
	      (E (let-var-body ast) caller g)
	      (begin
		 (local-info-set! (car (car bindings))
				  (default-var-Ginfo))
		 (loop (cdr bindings)
		       (E (cdr (car bindings)) caller g))))))
      ((let-fun)
       ;; first, for each functions, we associate a `fun-Ginfo' structure
       (for-each (lambda (local)
		    (local-info-set! local (default-fun-Ginfo))
		    (for-each (lambda (local)
				 (local-info-set!
				  local
				  (default-var-Ginfo)))
			      (function-args (local-value local))))
		 (let-fun-locals ast))
       ;; then, we realize the same computation as for `let-var' nodes
       (let loop ((locals (let-fun-locals ast))
		  (g      g))
	  (if (null? locals)
	      (E (let-fun-body ast) caller g)
	      (loop (cdr locals)
		    (E (function-body (local-value (car locals)))
		       (car locals)
		       g)))))
      ((set-ex-it)
       (local-info-set! (var-variable (set-ex-it-exit ast))
			(default-var-Ginfo))
       (E (set-ex-it-body ast) caller g))
      ((jump-ex-it)
       (E (jump-ex-it-exit ast)
	  caller
	  (E (jump-ex-it-value ast) caller g)))
      ((funcall)
       (E (funcall-fun ast)
	  caller
	  (E* (funcall-actuals ast) caller g)))
      ((app-ly)
       (E (app-ly-fun ast)
	  caller
	  (E (app-ly-value ast) caller g)))
      ((app)
       (save-app! caller (var-variable (app-fun ast)))
       (E* (app-actuals ast) caller g))
      ((switch)
       (let loop ((clauses (switch-clauses ast))
		  (g       g))
	  (if (null? clauses)
	      (E (switch-test ast) caller g)
	      (loop (cdr clauses)
		    (E (cdr (car clauses))
		       caller
		       g)))))))

;*---------------------------------------------------------------------*/
;*    E* ...                                                           */
;*---------------------------------------------------------------------*/
(define (E* asts caller g)
   (let loop ((asts asts)
	      (g    g))
      (if (null? asts)
	  g
	  (loop (cdr asts)
		(E (car asts) caller g)))))
		    
;*---------------------------------------------------------------------*/
;*    save-app! ...                                                    */
;*---------------------------------------------------------------------*/
(define (save-app! caller callee)
   [assert check (caller callee)
	   (and (function? (variable-value caller))
		(or (function? (variable-value callee))
		    (ffunction? (variable-value callee))))]
   (if (global? callee)
       'done
       (let ((callee-info (local-info callee)))
	  (if (not (memq caller (fun-Ginfo-cfrom callee-info)))
	      (begin
		 (fun-Ginfo-cfrom-set! callee-info
				       (cons caller
					     (fun-Ginfo-cfrom callee-info)))
		 (if (local? caller)
		     (let ((caller-info (local-info caller)))
			(fun-Ginfo-cto-set! caller-info
					    (cons callee
						  (fun-Ginfo-cto
						   caller-info)))))))
	  'done)))
	  
;*---------------------------------------------------------------------*/
;*    save-fun! ...                                                    */
;*---------------------------------------------------------------------*/
(define (save-fun! caller callee)
   [assert check (caller callee)
	   (and (function? (variable-value caller))
		(or (function? (variable-value callee))
		    (ffunction? (variable-value callee))))]
   (if (or (global? caller) (global? callee))
       'done
       (let ((caller-info (local-info caller)))
	  (if (not (memq callee (fun-Ginfo-cfunction caller-info)))
	      (fun-Ginfo-cfunction-set! caller-info
					(cons callee
					      (fun-Ginfo-cfunction
					       caller-info))))
	  'done)))
	  
;*---------------------------------------------------------------------*/
;*    G-from-cto ...                                                   */
;*---------------------------------------------------------------------*/
(define (G-from-cto local)
   (let loop ((cto (fun-Ginfo-cto (local-info local)))
	      (G   '()))
      (cond
	 ((null? cto)
	  G)
	 ((fun-Ginfo-G? (local-info (car cto)))
	  ;; this function is already in a list
	  (loop (cdr cto) G))
	 (else
	  (fun-Ginfo-G?-set! (local-info (car cto)) #t)
	  (loop (cdr cto) (cons (car cto) G))))))
	  
