;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Inline/walk.scm          */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan  9 19:15:23 1995                          */
;*    Last change :  Mon Jul 31 16:16:20 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The inlining pass                                                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module inline_walk
   (include "Tools/pass.sch"
	    "Tools/trace.sch"
	    "Ast/ast.sch")
   (import  inline_inline
	    tools_shape
	    ast_global)
   (export  (inline-walk! <ast>)))

;*---------------------------------------------------------------------*/
;*    inline-walk! ...                                                 */
;*---------------------------------------------------------------------*/
(define (inline-walk! ast)
   (pass-prelude "Inlining")
   (for-each (lambda (global)
                (let ((fun (global-value global)))
		   (if (or (>fx (global-occurrence global) 0)
			   (not (eq? (global-import global) 'static)))
		       (begin
			  (enter-function (global-shape global))
			  (trace inline "--- SCANNING: " (shape global)
				 #\Newline)
			  (function-body-set! fun
					      (inline-ast (function-body fun)
							  #f
							  (list global)))
			  (leave-function)))))
             ast)
   ;; we remove definition which are became used
   (let loop ((ast  ast)
              (new-ast  '()))
      (if (not (null? ast))
	  (trace inline (shape (car ast))
		 "  occurrence : " (global-occurrence (car ast))
		 "  import : " (global-import (car ast))
		 #\Newline))
      (cond
         ((null? ast)
          ;; it is finished ...
          (pass-postlude (reverse! new-ast)))
         ((and (<=fx (global-occurrence (car ast)) 0)
               (eq? (global-import (car ast)) 'static))
          ;; this function is never used, we skip it
          (loop (cdr ast)
                new-ast))
	 ((eq? (global-import (car ast)) 'import)
	 ;; the import case is for imported inline functions
	  (loop (cdr ast)
		new-ast))
         (else
          (loop (cdr ast)
                (cons (car ast) new-ast))))))

