/*---------------------------------------------------------------------*/
/*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/runtime1.9/Clib/struct.c             */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Jun 16 09:28:53 1992                          */
/*    Last change :  Mon Apr  1 15:28:34 1996 (serrano)                */
/*                                                                     */
/*    La construction des structures                                   */
/*---------------------------------------------------------------------*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    create_struct ...                                                */
/*---------------------------------------------------------------------*/
obj_t
create_struct( key, len )
obj_t key;
long  len;
{
   obj_t structure;
   obj_t aux;
   long  byte_size;

   byte_size = STRUCT_SIZE + ( (len-1) * OBJ_SIZE );
   
#if( defined( BUMPY_GC ) )
   if( byte_size < BUMPY_MAX_OBJ_SIZE )
   {
      BUMPY_MALLOC( byte_size, structure );
   
      WRITE_BARRIER( BSTRUCTURE( structure ), key );
   }
   else
      structure = GC_MALLOC( byte_size );
#else
   structure = GC_MALLOC( byte_size );
#endif
   
#if( !defined( TAG_STRUCTURE ) || defined( BUMPY_GC ) )
   structure->struct_t.header = MAKE_HEADER( STRUCT_TYPE, byte_size );
#endif	

   structure->struct_t.key    = key;
   structure->struct_t.length = len;
   
   return BSTRUCTURE( structure );
}

/*---------------------------------------------------------------------*/
/*    make_struct ...                                                  */
/*---------------------------------------------------------------------*/
obj_t
make_struct( key, len, init )
obj_t key;
long  len;
obj_t init;
{
   obj_t structure;
   long  i;

   structure = create_struct( key, len );
   
   for( i = 0; i < len; i++ )
      STRUCT_SET( structure, i, init );

   return structure;
}

