/*
    CTHUGHA-L 							cthugha.h
	
    General definitions for everyone.
*/

#ifndef __CTHUGHA_H__
#define __CTHUGHA_H__

#define CTHUGHA_VERSION			80

#define BETA
#undef DEBUG 

/* CTH_... 
 * CTH_console		Console version of Cthugha-L
 * CTH_X11		X11 version of Cthugha-L (normal or screen saver)
 * CTH_normalX11	normal X11 version 
 * CTH_saverX11		X11 screen saver version
 * CTH_server		Sound Server
 */
#ifndef CTH_X11
    #define CTH_console
#endif

#ifdef CTH_X11
    #include "cthugha-X11.h"
    #include <X11/Xlib.h>
#endif

extern int cthugha_pause;
extern int cthugha_verbose;
extern int cthugha_finish;

int init_cthugha(int argc, char ** argv);
int exit_cthugha(int );
void pause_for_key();

#define printfv(args...)  if(cthugha_verbose) printf(## args);fflush(stdout)
/* The SPACE after %s\n" is important !!! */
#define printfee(fmt, args...)	{					  \
   printf("\n"); fflush(stdout);					  \
   fprintf(stderr, fmt " (%d - %s)\n" , ## args, errno, strerror(errno)); \
   fflush(stderr);                                                        \
   if(cthugha_pause < 0) cthugha_pause = 1;				  \
}
#define printfe(fmt, args...)	{					  \
   printf("\n"); fflush(stdout);					  \
   fprintf(stderr, fmt, ## args);					  \
   fflush(stderr);                                                        \
   if(cthugha_pause < 0) cthugha_pause = 1;				  \
}


static inline int max(int a, int b) {
    return (a < b) ? b : a;
}
static inline int min(int a, int b) {
    return (a < b) ? a : b;
}	


#endif







