/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
/*
 * @(#)sysmacros_md.h	1.3 96/03/20
 *
 */

#ifndef _SOLARIS_SYSMACROS_MD_H_
#define _SOLARIS_SYSMACROS_MD_H_

/*
 * #define sysMalloc(size) (malloc(size))
 * #define sysFree(ptr)	(free(ptr))
 * #define sysCalloc(num, size) (calloc(num, size))
 * #define sysRealloc(ptr, size) (realloc(ptr, size))
 */

/*
 * because these are used directly as function ptrs, just redefine the name */
#define sysMalloc	malloc
#define sysFree		free
#define sysCalloc	calloc
#define sysRealloc	realloc

/* filesystem macros */

#define sysSeek(fd, offset, whence)		(lseek(fd, offset, whence))
#define sysRename(s, d)					(rename(s, d))

#ifdef DEBUG
extern void DumpThreads(void);
void panic (const char *, ...);
#define sysAssert(expression) {		\
    if (!(expression)) {		\
	DumpThreads();			\
	panic("\"%s\", line %d: assertion failure\n", __FILE__, __LINE__); \
    }					\
}
#else
#define sysAssert(expression) 0
#endif

/*
 * Check whether an exception occurred.  This also gives us the oppor-
 * tunity to use the already-required exception check as a trap for other
 * system-specific conditions.
 */
#define sysCheckException(ee) \
	if (!exceptionOccurred(ee)) { \
	   continue; \
	}

/*
 * file system macros moved here from io_md.h
 */

#define sysOpen(_path,_oflag,_mode)     open(_path,_oflag,_mode)
#define sysRead(_fd,_buf,_n)		read(_fd,_buf,_n)
#define sysWrite(_fd,_buf,_n)		write(_fd,_buf,_n)
#define sysClose(_fd)			close(_fd)
#define sysAccess(_path,_mode)		access(_path,_mode)
#define sysStat(_path,_buf)		stat(_path,_buf)
#define sysMkdir(_path,_mode)		mkdir(_path,_mode)
#define sysUnlink(_path)		unlink(_path)
#define sysIsAbsolute(_path)		(*(_path) == '/')
#define sysCloseDir(_dir)		closedir(_dir)
#define sysOpenDir(_path)		opendir(_path)
#define sysReadDir(_dir)		readdir(_dir)

#endif /*_SOLARIS_SYSMACROS_MD_H_*/
