// -*- C++ -*-
/* This file is part of
* ======================================================
* 
*           LyX, the High Level Word Processor
*	    Copyright (C) 1995 Matthias Ettrich
*
*           This file is Copyright (C) 1996
*           Lars Gullik Bjnnes
*
*======================================================*/

#ifndef _TOOLBAR_H_
#define _TOOLBAR_H_

#include "config.h"

#include "forms.h"

#include "keybind.h"
#include "lyxlex.h"
#include "combox.h"

/// The special toolbar actions
enum {
TOOL_SEPERATOR = -1,
TOOL_LAYOUTS = -2,
TOOL_NEWLINE = -3
};
/// The LyX toolbar class
/** This class bla, bla
    and more bla bla about the class
    */
class Toolbar
{
private:
	///
	struct toolbarItem
	{
		///
		toolbarItem *next;
		///
		int action;
		///
		char* help;
		///
		FL_OBJECT *icon;
		///
		bool IsBitmap;
		///
		char **pixmap;
		///
		toolbarItem(){
			next = NULL;
			action = LFUN_NOACTION;
			help = NULL;
			icon = NULL;
			pixmap = NULL;
			IsBitmap = false;
		}
		///
		~toolbarItem(){
			if (icon){
				fl_delete_object(icon);
				fl_free_object(icon);
			}
		}
			
	};
	/// a list containing all the buttons
	toolbarItem *toollist;
	///
	int xpos, ypos;
	///
	int buttonwidth, height;
	///
	int standardspacing, sepspace;
	///
	bool cleaned;
	///
	char **getPixmap(kb_action, char* arg=NULL);
	///
	char *getHelp(kb_action, char* arg=NULL);
	///
	int get_toolbar_func(const char*);
	/// removes all toolbar buttons from the toolbar.
	void clean();
	///
	static void ToolbarCB(FL_OBJECT*, long);
	///
	static void BubbleTimerCB(FL_OBJECT *, long);
	///
	static int BubblePost(FL_OBJECT *ob, int event,
			      FL_Coord mx, FL_Coord my, int key, void *xev);
	///
	void reset(){
		toollist = NULL;
		cleaned = false;
		
		lightReset();
	}
	///
	void lightReset(){
				// these positions are hardcoded now, but
		ypos = 44; // that will change in the near future. (I hope)
		buttonwidth = 30; // the standard button width
		height = 30; // the height of all items in the toolbar
		standardspacing = 2; // the usuall space between items
		sepspace = 8; // extra space
		xpos = 10 - standardspacing;
	}
public:
	///
	Toolbar(){
		toolobj = new FL_OBJECT;
		combox = NULL;
		reset();
	}
	///
	FL_OBJECT *toolobj;
	///
	Combox *combox;
	///
	void read(LyXLexClass*);
	/// sets up the default toolbar
	void init();
	/// (re)sets the toolbar
	void set();
	/** this is to be the entry point to the toolbar
	  frame, where you can change the toolbar realtime. */
	void edit();
	/// add a new button to the toolbar.
    	void add(int ,bool doclean=true);
	/// name of func instead of kb_action
	void add(const char*, bool doclean=true);
	/// invokes the n'th icon in the toolbar
	void push(int);
	///
        void activate();
	///
        void deactivate();
};

/// a reference to the global toolbar object
extern Toolbar toolbar;
#endif

//@}
