/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
static char rcsid[] = "$Id: xm.c,v 1.5 1995/04/11 14:07:15 pierre Exp $";

/*
 * Couche Toolkit OSF-MOTIF
 */

#include "xtel.h"
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <malloc.h>

#include <Mrm/MrmAppl.h>
#include <Mrm/MrmPublic.h>
#include <Xm/Xm.h>
#include <Xm/Text.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/FileSB.h>
#include <Xm/MessageB.h>
#include <Xm/Form.h>

#define XmStringDefCreate(s) XmStringLtoRCreate((s),XmSTRING_DEFAULT_CHARSET)
#define K_Charge	0
#define K_Sauve		1

static char *Mrm_files[] = {"xtel.uid", "icones.uid", "pf.uid"};
static MrmHierarchy hier;
static char buf[256];
static Arg args[10];
static int n;

static char *toolkit = "OSF/Motif";

static Widget lecteur, compteur_lecteur_page, compteur_lecteur_caractere;
static Widget stop_lecteur, play_lecteur, bouton_lecteur;
static Widget bouton_demarre, bouton_arrete;
static Widget fem, em, top;
static Widget forme_base, menu_compose, menu_procedure;
static Widget selecteur_fichier, boite_saisie, confirmation_sortie, message_erreur;

static void Ouverture_boite_saisie ();
static void Validation_selecteur_fichier ();
static void Composition_service ();
static void Appel_procedure ();
static void Ouverture_selecteur_fichier ();
static void Annulation_selecteur_fichier ();
static void Validation_boite_saisie ();
static void Annulation_boite_saisie ();
static void Ouverture_confirmation_sortie ();
static void Validation_confirmation_sortie ();
static void Annulation_confirmation_sortie ();
static void Validation_message_erreur ();
static void Affiche_menu_clavier ();
static void Valide_le_bouton_stop();
static void Demarre_enregistrement ();
static void Arrete_enregistrement();
static void Nouvel_enregistrement();
static void Arret_a_chaque_page ();
static void Affiche_copyright ();

#if XmREVISION > 1
#define XTPOINTER	XtPointer
#else
#define XTPOINTER	caddr_t
#endif

static MRMRegisterArg mrm_names[] = {
        {"Ouverture_selecteur_fichier", (XTPOINTER)Ouverture_selecteur_fichier },
        {"Imprime_page_courante", (XTPOINTER)imprime_page_courante },
        {"Annulation_selecteur_fichier", (XTPOINTER)Annulation_selecteur_fichier },
        {"Validation_boite_saisie", (XTPOINTER)Validation_boite_saisie },
        {"Annulation_boite_saisie", (XTPOINTER)Annulation_boite_saisie },
        {"Ouverture_confirmation_sortie", (XTPOINTER)Ouverture_confirmation_sortie },
        {"Validation_confirmation_sortie", (XTPOINTER)Validation_confirmation_sortie },
        {"Annulation_confirmation_sortie", (XTPOINTER)Annulation_confirmation_sortie },
        {"Validation_message_erreur", (XTPOINTER)Validation_message_erreur },
        {"Demarre_enregistrement", (XTPOINTER)Demarre_enregistrement },
        {"Arrete_enregistrement", (XTPOINTER)Arrete_enregistrement },
        {"Nouvel_enregistrement", (XTPOINTER)Nouvel_enregistrement },
        {"Zero_lecteur", (XTPOINTER)Zero_lecteur },
        {"Rewind_lecteur", (XTPOINTER)Rewind_lecteur },
        {"Stop_lecteur", (XTPOINTER)Stop_lecteur },
        {"Play_lecteur", (XTPOINTER)Play_lecteur },
        {"Wind_lecteur", (XTPOINTER)Wind_lecteur },
        {"fin_lecteur", (XTPOINTER)fin_lecteur },
        {"debut_lecteur", (XTPOINTER)debut_lecteur },
        {"arret_a_chaque_page", (XTPOINTER) Arret_a_chaque_page},
        {"Valide_le_bouton_stop", (XTPOINTER) Valide_le_bouton_stop},
        {"commandes", (XTPOINTER)commandes },
        {"selection_mode_emulation", (XTPOINTER)selection_mode_emulation },
        {"Affiche_copyright", (XTPOINTER)Affiche_copyright },
        {"Raccrocher", (XTPOINTER)raccrocher }
};

static XtActionsRec actions_touches[] = {
    {"affiche_menu_clavier", Affiche_menu_clavier}
  };

static XrmOptionDescRec options[] = {
    {"-serveur",	"*serveur",	XrmoptionSepArg, NULL},
    {"-service",	"*nomService",	XrmoptionSepArg, NULL},
    {"-petit",		"*petiteFonte",	XrmoptionNoArg, "True"},
    {"-ng",		"*nGris",	XrmoptionNoArg, "True"},
    {"-br",		"*boutonRaccrocher",	XrmoptionNoArg, "True"}
};

/*
 * Fonctions utilitaires Fetch & NameToWidget
 */
static void fetch_widget (hier, nom, parentw, pw)
MrmHierarchy hier;
char *nom;
Widget parentw, *pw;
{
    MrmType type;

    if (MrmFetchWidget (hier, nom, parentw, pw, &type) != MrmSUCCESS) {
	fprintf (stderr, "erreur fetch_widget %s\n", nom);
	exit (1);
    }
}

static void fetch_widget_override (hier, nom, parentw, arguments, n, pw)
MrmHierarchy hier;
char *nom;
Widget parentw;
Arg arguments[];
int n;
Widget *pw;
{
    MrmType type;

    if (MrmFetchWidgetOverride (hier, nom, parentw, NULL, args, n, pw, &type) != MrmSUCCESS) {
	fprintf (stderr, "erreur fetch_widget_override %s\n", nom);
	exit (1);
    }
}

static Widget name_to_widget (parentw, nom)
Widget parentw;
char *nom;
{
    Widget w;

    if ((w = XtNameToWidget (parentw, nom)) == NULL) {
	fprintf (stderr, "erreur name_to_widget %s\n", nom);
	exit (1);
    }

    return (w);
}

/* 
 * Affichage du popup-menu clavier 
 */
void Affiche_menu_clavier (w, pevent, params, nb_params)
Widget w;
XButtonEvent *pevent;
String *params;
Cardinal nb_params;
{
    XmMenuPosition(menu_clavier, pevent);
    XtManageChild (menu_clavier);
}

/*
 * Initialisation du toolkit 
 */
Widget init_toolkit (pargc, argv)
int *pargc;
char **argv; 
{
    MrmHierarchy hier;
    MrmType type;

#ifdef DEBUG
    printf ("Initialisation du toolkit\n");
#endif

    toolkit_utilise = toolkit;

    MrmInitialize ();

    top = XtAppInitialize(&app_context, "XTelm", options, XtNumber(options), pargc, argv, NULL, NULL, 0);

    if (*pargc > 1) {
	fprintf (stderr, "Usage : xtel [-ng -petit -br -service service_xtel -serveur serveur_xtel [options_standards]]\n");
	exit (1);
    }

    XtAppAddActions(app_context, actions_touches, XtNumber(actions_touches));

    return (top);
}

/*
 * Initialisation des widgets
 */
Widget init_widgets (topLevel)
Widget topLevel;
{
    register int i;
    MrmType type;
    Widget entry;

#ifdef DEBUG
    printf ("Initialisation des widgets\n");
#endif

    MrmOpenHierarchy (XtNumber(Mrm_files), Mrm_files, NULL, &hier);
    MrmRegisterNames (mrm_names, XtNumber(mrm_names));

    fetch_widget (hier, "forme_base", topLevel, &forme_base);

    XtManageChild (forme_base);

    fetch_widget (hier, "lecteur", topLevel, &lecteur);

    bouton_lecteur = name_to_widget (forme_base, "*bouton_lecteur");
    play_lecteur = name_to_widget (lecteur, "*play_lecteur");
    stop_lecteur = name_to_widget(lecteur, "*stop_lecteur");
    compteur_lecteur_caractere = name_to_widget (lecteur, "*compteur_lecteur_caractere");
    compteur_lecteur_page = name_to_widget (lecteur, "*compteur_lecteur_page");
    fem = name_to_widget (forme_base, "f_ecran_minitel");

    /* ecran */
    n = 0;

    XtSetArg (args[n], XtNcommandeDeconnexion, CHAINE_COMMANDE_FIN); n++;

    if (rsc_xtel.nGris) {
	XtSetArg (args[n], XtNnGris, True);
	n++;
    }
    
    if (rsc_xtel.petiteFonte) {
	XtSetArg (args[n], XtNpetiteFonte, True);
	n++;
    }

    em = XtCreateManagedWidget ("ecran_minitel", videotexWidgetClass, fem, args, n);

    bouton_compose = name_to_widget (forme_base, "*bouton_compose");
    bouton_procedure = name_to_widget (forme_base, "*bouton_procedure");
    bouton_demarre = name_to_widget (forme_base, "*bouton_demarre");
    bouton_arrete = name_to_widget (forme_base, "*bouton_arrete");

    /*
     * Creation du menu Services
     */

    if (nb_services == 0) {
	XtUnmanageChild (bouton_compose);
    }
    else {
	XtVaGetValues (bouton_compose,  XmNsubMenuId, &menu_compose, NULL);
	
	for (i = 0 ; i != nb_services ; i++) {
	    register int j, jj;
	    
	    /*
	     * On tient compte des caracteres accentues (\xyz en octal)
	     */
	    j = jj = 0;
	    while (entree_compose[i][j] != 0) {
		
		if (entree_compose[i][j] == '\\') {
		    int x;
		    
		    sscanf (&entree_compose[i][j+1], "%o", &x);
		    buf[jj] = (char)x;
		    j += 4;
		}
		else
		    buf[jj] = entree_compose[i][j++];
		
		jj++;
	    }
	    buf[jj] = 0;
	    
	    n = 0;
	    XtSetArg (args[n], XmNlabelString, XmStringCreate (buf, XmSTRING_DEFAULT_CHARSET)); n++;
	    fetch_widget_override (hier, "prototype_bouton", menu_compose, args, n, &entry);
	    if (i == nb_services-1 && !strcmp (entree_compose[i], "Direct"))
		XtAddCallback(entry, XmNactivateCallback, Ouverture_boite_saisie, NULL);
	    else
		XtAddCallback(entry, XmNactivateCallback, Composition_service, (XtPointer) i);
	    
	    XtManageChild (entry);
	}
	
	XtManageChild (menu_compose);
    }

    /*
     * Creation du menu Procedures
     */
    if (nb_procedures != 0) {

	n = 0;
	XtSetArg (args[n], XmNsubMenuId, &menu_procedure); n++;
	XtGetValues (bouton_procedure, args, n);
	
	for (i = 0 ; i != nb_procedures ; i++) {
	    n = 0;
	    XtSetArg (args[n], XmNlabelString, XmStringCreate (procedures[i].nom, XmSTRING_DEFAULT_CHARSET)); n++;
	    fetch_widget_override (hier, "prototype_bouton", menu_procedure, args, n, &entry);
	    XtAddCallback(entry, XmNactivateCallback, Appel_procedure, (XtPointer) i);
	    XtManageChild (entry);
	}
	XtManageChild (menu_procedure);
    }
    else
	XtUnmanageChild (bouton_procedure);

    fetch_widget (hier, "menu_clavier", em, &menu_clavier);
    fetch_widget (hier, "confirmation_sortie", topLevel, &confirmation_sortie);
    fetch_widget (hier, "message_erreur", topLevel, &message_erreur);
    fetch_widget (hier, "selecteur_fichier", topLevel, &selecteur_fichier);
    fetch_widget (hier, "boite_saisie", topLevel, &boite_saisie);

    XtAddEventHandler (lecteur, LeaveWindowMask, False, (XtEventHandler)sauve_l_ecran, NULL);

    /* Bouton "Raccrocher" ? */
    if (!rsc_xtel.boutonRaccrocher) {
	Widget r;

	r = name_to_widget (menu_clavier, "*raccrocher");
	XtUnmanageChild (r);
    }

    return (em);
}

static void Affiche_copyright (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    Pixmap pixmap_pf;
    Display *display = XtDisplay(w);
    Screen *screen = DefaultScreenOfDisplay(display);
    if (!flag_copyright_affiche) {
	MrmFetchIconLiteral (hier, "pixmap_pf", screen, display, 1, 0, &pixmap_pf);
	affiche_copyright (top, xmFormWidgetClass, pixmap_pf);
    }
}

/*	
 * fonctions utilisees pour la gestion des menus deroulants
 */

/*
 * Traitement des selecteurs de fichiers
 */
static void Ouverture_selecteur_fichier (w, flag, call_data)
Widget w;
int *flag;
XtPointer call_data;
{
    XtAddCallback(selecteur_fichier, XmNokCallback, Validation_selecteur_fichier, (XtPointer)flag);
    XtUnmanageChild (XmSelectionBoxGetChild (selecteur_fichier, XmDIALOG_HELP_BUTTON));
    XtManageChild (selecteur_fichier);
}

static void Validation_selecteur_fichier (w, flag, call_data)
Widget w;
int *flag;
XtPointer call_data;
{
    Widget text_w;

    XtRemoveAllCallbacks (selecteur_fichier, XmNokCallback);

    text_w = XmSelectionBoxGetChild(selecteur_fichier, XmDIALOG_TEXT);
    if (*flag == K_Sauve) {
	strcpy (nom_fichier_sauve, XmTextGetString(text_w));
	Sauve ();
	XtUnmanageChild (selecteur_fichier);
    }
    else {
	strcpy (nom_fichier_charge, XmTextGetString(text_w));
	XtUnmanageChild (selecteur_fichier);
	Charge ();
    }
}

static void Annulation_selecteur_fichier (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    XtRemoveAllCallbacks (selecteur_fichier, XmNokCallback);
    XtUnmanageChild (selecteur_fichier);
}

/*
 * Traitement de la boite de saisie
 */
static void Ouverture_boite_saisie (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    XtUnmanageChild (XmSelectionBoxGetChild (boite_saisie, XmDIALOG_HELP_BUTTON));
    XtManageChild (boite_saisie);
}

static void Validation_boite_saisie (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    Widget text_w;

    text_w = XmSelectionBoxGetChild(boite_saisie, XmDIALOG_TEXT);
    init_xtel ();
    connexion_service (XmTextGetString(text_w));

    XtUnmanageChild (boite_saisie);
}

static void Annulation_boite_saisie (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    XtUnmanageChild (boite_saisie);
}

/*
 * Composition d'un service
 */
/* ARGSUSED */
static void
Composition_service (w, numero_choisi, call_data)
Widget w;
int numero_choisi;	     
XtPointer call_data;	
{
    /* composition */
#ifdef DEBUG
    printf ("service uucp %s\n", definition_services[numero_choisi].nom_uucp);
#endif

    init_xtel ();
    connexion_service (definition_services[numero_choisi].nom_uucp);
}

/*
 * Appel d'une procedure
 */
/* ARGSUSED */
static void
Appel_procedure (w, numero_procedure, call_data)
Widget w;
int numero_procedure;	     
XtPointer call_data;	
{
    /* composition */
#ifdef DEBUG
    printf ("Procedure numero %%d\n", numero_procedure);
#endif

    chat_courant = procedures[numero_procedure].chat;
    init_xtel ();
    /* Si M1, on compose a la main... */
    if (!nb_services)
	connexion_service (NULL);
    else
	connexion_service (procedures[numero_procedure].service);
}

/*
 * Traitement de la boite de confirmation de sortie
 */
static void Ouverture_confirmation_sortie (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    XtUnmanageChild (XmMessageBoxGetChild (confirmation_sortie, XmDIALOG_HELP_BUTTON));
    XtManageChild (confirmation_sortie);
}

/* ARGSUSED */
static void
Validation_confirmation_sortie (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;	
{
    Boolean flag_connexion;

    XtVaGetValues (ecran_minitel, XtNconnecte, &flag_connexion, NULL);

    /* Si on est connecte, on deconnecte et on quitte */
    if (flag_connexion) {
	write (socket_xteld, CHAINE_COMMANDE_FIN, 1);
	sortie_violente = True;
    }
    else
	ce_n_est_qu_un_au_revoir ();
}

/* ARGSUSED */
static void
Annulation_confirmation_sortie (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;	
{
    XtUnmanageChild (confirmation_sortie);
}

/*
 * Traitement de la boite d'erreur
 */ 
static void Validation_message_erreur (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    XtUnmanageChild (message_erreur);
}

/* 
 * Affichage d'une erreur donnee par code_erreur 
 */
void affiche_erreur(s, code_erreur)
char *s;
int code_erreur;
{
    Widget text_w;

    if (code_erreur != 0)
	sprintf (buf, "%s : %s", s, sys_errlist[code_erreur]);
    else
	strcpy (buf, s);

    n = 0;
    XtSetArg (args[n], XmNmessageString, XmStringDefCreate(buf)); n++;
    XtSetValues (message_erreur, args, n);

    XtUnmanageChild (XmMessageBoxGetChild(message_erreur, XmDIALOG_CANCEL_BUTTON));
    XtUnmanageChild (XmMessageBoxGetChild(message_erreur, XmDIALOG_HELP_BUTTON));
    XtManageChild (message_erreur);
}

/* Traitement de l'enregistrement */
static void Demarre_enregistrement (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    flag_enregistrement = 1;
    XtSetSensitive (bouton_demarre, False);
    XtSetSensitive (bouton_arrete, True);
}

static void Arrete_enregistrement (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    flag_enregistrement = 0;
    XtSetSensitive (bouton_demarre, True);
    XtSetSensitive (bouton_arrete, False);
}

static void Nouvel_enregistrement (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    cpt_buffer = 0;
    taille_zone_enregistrement = 1000;
    zone_enregistrement = realloc (zone_enregistrement, taille_zone_enregistrement);
}

/* 
 * Fonctions du lecteur 
 */
void activation_bouton_stop ()
{
    XmToggleButtonSetState (stop_lecteur, True, True);
}

/* Force le bouton STOP valide si appel de stop_rapide() */
static void Valide_le_bouton_stop (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    activation_bouton_stop ();
}

/*
 * Callback des boutons "oui/non_arret_page_lecteur"
 */
static void Arret_a_chaque_page (w, pflag, call_data)
Widget w;
int *pflag;
XtPointer call_data;
{
    flag_arret_a_chaque_page = *pflag;
}




/* validation/invalidation */
void lecteur_valide (flag)
char flag;
{
    XtSetSensitive (bouton_lecteur, flag);
}

/* Affiche/efface le lecteur */
void efface_lecteur ()
{
    XtUnmanageChild (lecteur);
}

void affiche_lecteur ()
{
    XtManageChild (lecteur);
}

/* Affiche les compteurs */
void affiche_compteur_lecteur_caractere ()
{
    sprintf (buf, "%05d", numero_caractere_courant);

    n = 0;
    XtSetArg (args[n], XmNlabelString, XmStringDefCreate(buf)); n++;
    XtSetValues (compteur_lecteur_caractere, args, n);
}

void affiche_compteur_lecteur_page ()
{
    sprintf (buf, "%03d", numero_page_courante);

    n = 0;
    XtSetArg (args[n], XmNlabelString, XmStringDefCreate(buf)); n++;
    XtSetValues (compteur_lecteur_page, args, n);
}
