extract_base ()
{
	require_root
	if [ $? -ne 0 ]; then return 1; fi

	# Only verify root choice if it is not empty.
    if [ ! -z "`ls /target/. 2>/dev/null | sed -e 's/lost+found//'`" ]; then
		cat > $TempFile << EOF
		yesNoBox \\
"The following filesystems are mounted, and will have the
base system installed to them:
EOF
		mount | sed -n '/\/target/p' | sed -e 's:target/::' \
		 -e 's:/target:/:' >> $TempFile

echo '
Install the base system?" "Verify Filesystem Choice?"' >> $TempFile
		. $TempFile
		if [ $? -ne 0 ]; then return 1; fi
	fi

	# Mark Shuttleworth, this is for you.
	# See if the base archive is on the root filesystem, or something that's
	# mounted.
	local base_archive=""
	local archive=base1_1.tgz

	infoBox \
"The installation program is searching for a local copy of
the base system in \"/*/$archive\" and \"/*/*/$archive\".
Please wait." "Please Wait"
	if [ $? -ne 0 ]; then return 255; fi

	local list="`echo /*/$archive /*/*/$archive`"
	if [ ! -z "$list" ]; then
		for f in $list; do
			if [ -f $f ]; then
				base_archive=$f
				break;
			fi
		done
	fi
	if [ ! -z "$base_archive" ]; then
		cd /target
		echo \
$clear$bold"The system is being extracted from $base_archive ..."$norm
		echo ""
		< $base_archive gunzip | star
		local status=$?
		cd /Install
		if [ $status -ne 0 ]; then
			write_it_down
			msgBox \
"There was a problem extracting the system from
$base_archive ." "Problem"
			return 1
		fi
	else
		local device=""
		local designation=""
		cat > $TempFile <<EOF
		menu \\
"Please select the disk drive you will use to install
the system. If you are using floppy disk drives, you
will need the \"base\" floppy disks." \\
		 "Select Disk Drive" \\
EOF
		if [ $InstallationRootDevice != /dev/fd0 ]; then
			echo "\"/dev/fd0\" \"First floppy drive\"" \\>>$TempFile
		fi
		if [ $InstallationRootDevice != /dev/fd1 ]; then
			echo "\"/dev/fd1\" \"Second floppy drive\"" \\>>$TempFile
		fi
		# echo "\"CD-ROM\" \"Any CD-ROM drive on your system.\"">>$TempFile

		local device="`. $TempFile`"
		local status=$?
		if [ $status -ne 0 -o -z "$device" ]; then return 1; fi

		case $device in
		/dev/fd0)
			designation=first
			;;
		/dev/fd1)
			designation=second
			;;
		CD-ROM)
			extract_cd
			if [ $? -ne 0 ]; then return 1; fi
		esac

		if [ $device = /dev/fd0 -o $device = /dev/fd1 ]; then
			echo  $clear$bold\
"The system is being installed from the $designation floppy drive.
Please respond to the prompts below."$norm
			echo ""
			echo ""
			local status=$?
			if [ -f /target/base.tar.gz ]; then
				rm -f /target/base.tar.gz
			fi
			floppy_merge $device > /target/base.tar.gz
			status=$?
			if [ "$status" -eq 0 ]; then
				echo $bold"Extracting files, this will take several minutes..."
				echo $norm
				cd /target
				gunzip < /target/base.tar.gz | star
				status=$?
			fi
			if [ -f /target/base.tar.gz ]; then
				rm -f /target/base.tar.gz
			fi
			cd /Install
			if [ $status -ne 0 ]; then
				write_it_down
				msgBox \
	"There was a problem extracting the system from
	$device ." "Problem"
				return 1
			fi
		fi
	fi
	cp /etc/unconf.sh /target/sbin/unconfigured.sh
	mv /target/etc/inittab /target/etc/inittab.real
	cp /etc/init_tab /target/etc/inittab
	chmod 755 /target/etc/inittab /target/sbin/unconfigured.sh
	chown root.root /target/etc/inittab /target/sbin/unconfigured.sh
	sync
	return 0
}
