main_menu ()
{
	title="Debian Linux 1.1 Installation Main Menu"
	while true; do
		# Ignore interrupt in scripts, catch it in programs started by scripts.
		trap true 2 3
		infoBox \
"The installation program is determining the current state
of your system and the next installation step that should
be performed." \
		 "Please Wait"
		if [ $? -ne 0 ]; then return 255; fi

		local next_action=true
		local previous_action=true
		local previous1_action=true
		local alternate_action=true
		local alternate1_action=true

		local linux_partitions="`scan_partitions \"Linux native\"`"
		local swap_partitions="`scan_partitions \"Linux swap\"`"
		Root=`find_root`

		echo "menu \\" > $TempFile

		if [ -z "$Swap" -a -z "$swap_partitions" ]; then
			# No "Linux swap" partitions have been created.
			next_action=partition_disk
			alternate_action=no_swap
			cat >> $TempFile << EOF
" There are no \\"Linux swap\\" disk partitions present on the system. A
swap disk partition is necessary to provide virtual memory for
Linux. Please select \\"Next\\" from the menu to partition your hard
disk. Use the disk partitioning program to add \\"Linux native\\" and
\\"Linux swap\\" disk partitions to your disks." "$title" \\
			"Next" "Partition A Hard Disk" \\
			"Alternate" "Do Without a Swap Partition" \\
EOF
		elif [ -z "$linux_partitions" ]; then
			# No "Linux native" partitions have been created.
			next_action=partition_disk
			cat >> $TempFile << EOF
"There are no \\"Linux native\\" disk partitions present on the system.
You must create at least one \"Linux native\" disk partition to hold the
root filesystem, and you may create additional ones. Please select \\"Next\\"
from the menu to partition your hard disk. Use the disk partitioning
program to add \\"Linux native\\" disk partitions to your disks." \\
			"$title" \\
			"Next" "Partition A Hard Disk" \\
EOF
		elif [ -z "$Swap" ]; then
			# The swap partition has not been initialized and activated.
			next_action=init_swap
			alternate_action=activate_swap
			alternate1_action=no_swap
			previous_action=partition_disk
			cat >> $TempFile << EOF
"There are \\"Linux native\\" and \\"Linux swap\\" disk partitions
present on your system. The next step would be to initialize
and activate a swap partition to provide virtual memory to your
system. If you have not finished partitioning your disks or wish to
change the partitions, please select \\"Previous\\" from the menu
to partition them. If you are satisfied with your disk partitions,
please select \\"Next\\" from the menu to initialize and activate
your swap partition, or \\"Alternate\\" to activate a
previously-initialized swap partition. If you absolutely insist on
doing without a swap partition, select \\"Alternate1\\"." "$title" \\
			"Next" "Initialize and Activate the Swap Disk Partition" \\
			"Alternate" "Activate a Previously-Initialized Swap Partition" \\
			"Alternate1" "Do Without a Swap Partition" \\
			"Previous" "Partition A Hard Disk" \\
EOF
		elif [ -z "$Root" ]; then
			# The root partition has not been mounted.
			next_action=init_linux
			alternate_action=mount_any
			cat >> $TempFile << EOF
"There are \\"Linux native\\" disk partitions present on your system but
none are mounted. You must mount a root filesystem, and you may mount
other filesystems, before installing the system. If you have just created
the partitions, you must initialize them before you can mount them. Please
select \\"Next\" to initialize and mount a Linux disk partition, or
\\"Alternate\\" to mount a previously-initialized partition." \\
			"$title" \\
			"Next" "Initialize A Linux Disk Partition" \\
			"Alternate" "Mount a Previously-Initialized Disk Partition" \\
EOF
		elif [ ! -f /target/sbin/init ]; then
			# The base system has not been installed.
			next_action=extract_base
			alternate_action=init_linux
			alternate1_action=mount_any
			cat >> $TempFile << EOF
"You've mounted your root filesystem. You may initialize and mount
additional filesystems, or you may go on to install the base system." \\
			"Debian Linux Installation Main Menu" \\
			"Next" "Install the Base System" \\
			"Alternate" "Initialize A Linux Disk Partition" \\
			"Alternate1" "Mount a Previously-Initialized Disk Partition" \\
EOF
		elif [ ! -f /target/vmlinuz ]; then
			# The operating system kernel has not been installed.
			next_action=extract_kernel
			cat >> $TempFile << EOF
"You've installed the base system. Please select \\"Next\\" to install
the operating system kernel." "$title" \\
			"Next" "Install the Operating System Kernel" \\
EOF
		elif [ ! -f /target/etc/modules.old ]; then
			# The modules have not been configured.
			next_action=modules
			cat >> $TempFile << EOF
"You've installed the operating system. Please select \\"Next\\" to
configure the device driver modules." "$title" \\
			"Next" "Configure Device Driver Modules" \\
EOF
		elif [ -f /target/sbin/unconfigured.sh ]; then
			# The base system has not been configured.
			next_action=config_base
			cat >> $TempFile << EOF
"You've installed the base system and the operating system kernel.
Please select \\"Next\\" to configure the base system." "$title" \\
			"Next" "Configure the Base System" \\
EOF
		elif [ ! -f /target/etc/hostname ]; then
			# The network has not been configured.
			next_action=config_network
			cat >> $TempFile << EOF
"You've configured the base system but not the network.
Please select \\"Next\\" to configure the network." "$title" \\
			"Next" "Configure the Network" \\
EOF
		elif [ $CreatedBootFloppy -eq 0 -a ! -f /target/etc/lilo.conf ]; then
			next_action=make_bootable
			alternate_action=make_boot_floppy
			alternate1_action=reboot_system
			cat >> $TempFile << EOF
"You will either boot Linux from a floppy disk, or you will have it
boot from the hard disk when your system is turned on.
Please select \\"Next\\" to make Linux bootable the hard disk, select
\\"Alternate\\" to make a boot floppy, or select \\"Alternate1\\" to
reboot the system." \\
			"$title" \\
			"Next" "Make Linux Bootable Directly From Hard Disk" \\
			"Alternate" "Make A Boot Floppy" \\
			"Alternate1" "Reboot the System" \\
EOF
		elif [ $CreatedBootFloppy -eq 0 ]; then
			# The boot floppy has not been created.
			next_action=make_boot_floppy
			alternate_action=reboot_system
			cat >> $TempFile << EOF
"You've built your system. You should build a boot floppy that will
start the system just in case it doesn't start directly from the hard
disk. Please select \\"Next\\" to build the boot floppy." \\
			"$title" \\
			"Next" "Make A Boot Floppy" \\
			"Alternate" "Reboot the System" \\
EOF
		else
			# Nothing left to do but reboot the system.
			next_action=reboot_system
			cat >> $TempFile << EOF
"You've built your system and boot floppy. The moment of truth
approaches!  Please select \\"Next\\" to reboot the system." "$title" \\
			"Next" "Reboot The System" \\
EOF
		fi
		
cat >>$TempFile << EOF
		" " " " \\
		"A" "Partition A Hard Disk" \\
		"B" "Initialize and Activate a Swap Disk Partition" \\
		"C" "Activate a Previously-Initialized Swap Partition" \\
		"D" "Do Without a Swap Partition" \\
		"E" "Initialize A Linux Disk Partition" \\
		"F" "Mount a Previously-Initialized Disk Partition" \\
		"G" "Un-Mount a Disk Partition" \\
		"H" "Install the Base System" \\
		"I" "Install the Operating System Kernel" \\
		"J" "Configure Device Driver Modules" \\
		"K" "Configure the Base System" \\
		"L" "Configure the Network" \\
		"M" "Make Linux Bootable Directly From Hard Disk" \\
		"N" "Make A Boot Floppy" \\
		"O" "Reboot The System" \\
		"P" "View the Disk Partition Table" \\
		"Q" "Execute A Shell" \\
EOF

		local action
		action="`. $TempFile`"
		if [ $? -ne 0 -o -z "$action" ]; then continue; fi
		case $action in
		Next) $next_action;;
		Alternate) $alternate_action;;
		Alternate1) $alternate1_action;;
		Previous) $previous_action;;
		Previous1) $previous1_action;;
		A) partition_disk;;
		B) init_swap;;
		C) activate_swap;;
		D) no_swap;;
		E) init_linux;;
		F) mount_any;;
		G) unmount_any;;
		H) extract_base;;
		I) extract_kernel;;
		J) modules;;
		K) config_base;;
		L) config_network;;
		M) make_bootable;;
		N) make_boot_floppy;;
		O) reboot_system;;
		P) view_partitions;;
		Q) interactive_shell;;
		esac
	done
}
