/* s_ac_set.cc
 *$Header: /al/acs/src/RCS/s_ac_set.cc,v 9.21 95/10/21 18:10:08 al Exp $
 * ac analysis setup
 */
#include "constant.h"
#include "ap.h"
#include "error.h"
#include "io.h"
#include "u_opt.h"
#include "s_ac.h"
/*--------------------------------------------------------------------------*/
//	void	AC::setup(CS&);
//	void	AC::by(CS&);
//	void	AC::decade(CS&);
//	void	AC::lin(CS&);
//	void	AC::octave(CS&);
//	void	AC::times(CS&);
/*--------------------------------------------------------------------------*/
static int needslinfix;	// flag: lin option needs patch later (spice compat)
static AC *This;	// fudge to work around argparse
/*--------------------------------------------------------------------------*/
void AC::setup(CS& cmd)
{
  This = this;
  IO::where |= IO::mstdout;
  temp = OPT::tempamb;
  alarmlist = PROBE_LISTS::alarm[mode];
  plotlist  = PROBE_LISTS::plot[mode];
  printlist = PROBE_LISTS::print[mode];
  storelist = PROBE_LISTS::store[mode];
  IO::ploton = IO::plotset  &&  plotlist.count() > 0;
  cold = cont = echo = FALSE;
  worstcase = wNONE;
  for (;;){
    if (cmd.argparse(REPEAT,
	"*",		aFFUNCTION, times,
    	"ACMAx",	aENUM,	    &worstcase,	 wMAXAC,
	"ACMIn",	aENUM,	    &worstcase,	 wMINAC,
	"Ambient",	aODOUBLE,   &temp,	 OPT::tempamb,
	"By",		aFFUNCTION, by,
	"COLD",		aENUM,	    &cold,	 TRUE,
	"CONTinue",	aENUM,	    &cont,	 TRUE,
    	"DCMAx",	aENUM,	    &worstcase,	 wMAXDC,
	"DCMIn",	aENUM,	    &worstcase,	 wMINDC,
	"Decade",	aFFUNCTION, decade,
	"Echo",		aENUM,	    &echo,	 TRUE,
	"LAg",		aENUM,	    &worstcase,  wLAG,
	"LEad",		aENUM,	    &worstcase,  wLEAD,
        "LIn",		aFFUNCTION, lin,
	"MAx",		aENUM,	    &worstcase,  wMAXAC,
	"MIn",		aENUM,	    &worstcase,  wMINAC,
	"NOPlot",	aENUM,	    &IO::ploton, FALSE,
	"Octave",	aFFUNCTION, octave,
	"PLot",		aENUM,	    &IO::ploton, TRUE,
	"Reftemp",	aODOUBLE,   &temp,	 OPT::tnom,
	"SEnsitivity",	aENUM,	    &worstcase,  wSENS,
	"Temperature",	aODOUBLE,   &temp,	 -ABS_ZERO,
	"TImes",	aFFUNCTION, times,
	"")){
	;	
    }else if (cmd.is_float()){
      start = cmd.ctof();
      stop  = cmd.ctof();
      if (stop==0.)
	stop = start;
      if (cmd.is_float())
	by(cmd);
    }else if (outset(cmd,"","")){
      ;
    }else{
      cmd.check(bWARNING);
      break;
    }
  }
  initio(IO::where,IO::whence);
  if (worstcase==wRAND  ||  worstcase==wWORST)
    IO::ploton = FALSE;
  if (needslinfix){			    // LIN option is # of points.
    step=(stop-start)/(step-1.);	    // Must compute step after 
    needslinfix = FALSE;		    // reading start and stop,
  }					    // but step must be read first
  if (step==0.){			    // for Spice compatibility
    step = stop - start;
    linswp = TRUE;
  }
}
/*--------------------------------------------------------------------------*/
/*static*/ void AC::by(CS& cmd)
{
  This->step = cmd.ctof();
  needslinfix = FALSE;
  This->linswp = TRUE;
}
/*--------------------------------------------------------------------------*/
/*static*/ void AC::decade(CS& cmd)
{
  This->step = cmd.ctopf();
  if (This->step == 0.)
    This->step = 1.;
  This->step = pow(10., 1./This->step);
  needslinfix = FALSE;
  This->linswp = FALSE;
}
/*--------------------------------------------------------------------------*/
/*static*/ void AC::lin(CS& cmd)
{
  This->step = cmd.ctopf();		// need to fix step, later
  if (This->step == 0.)			// do it at the end of setup
    This->step = 1.;			// a kluge, but this is a patch
  needslinfix = TRUE;			// and I am too lazy to do it
  This->linswp = TRUE;			// right.
}
/*--------------------------------------------------------------------------*/
/*static*/ void AC::octave(CS& cmd)
{
  This->step = cmd.ctopf();
  if (This->step == 0.)
    This->step = 1.;
  This->step = pow(2.00000001, 1./This->step);
  needslinfix = FALSE;
  This->linswp = FALSE;
}
/*--------------------------------------------------------------------------*/
/*static*/ void AC::times(CS& cmd)
{
  This->step = cmd.ctopf();
  if (This->step == 0.   &&   This->start != 0.)
    This->step = This->stop / This->start;
  needslinfix = FALSE;
  This->linswp = FALSE;
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
