
/* The standard Maelstrom colormap + 8 levels of gamma correction */

Color full_colors[9][256] = {
	/* Gamma level 0 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xcccc, 0xcccc, 0xcccc },  /* Pixel 43 */
		{ 0xcccc, 0xcccc, 0x9999 },  /* Pixel 44 */
		{ 0xcccc, 0xcccc, 0x6666 },  /* Pixel 45 */
		{ 0xcccc, 0xcccc, 0x3333 },  /* Pixel 46 */
		{ 0xcccc, 0xcccc, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xcccc, 0x9999, 0xcccc },  /* Pixel 49 */
		{ 0xcccc, 0x9999, 0x9999 },  /* Pixel 50 */
		{ 0xcccc, 0x9999, 0x6666 },  /* Pixel 51 */
		{ 0xcccc, 0x9999, 0x3333 },  /* Pixel 52 */
		{ 0xcccc, 0x9999, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xcccc, 0x6666, 0xcccc },  /* Pixel 55 */
		{ 0xcccc, 0x6666, 0x9999 },  /* Pixel 56 */
		{ 0xcccc, 0x6666, 0x6666 },  /* Pixel 57 */
		{ 0xcccc, 0x6666, 0x3333 },  /* Pixel 58 */
		{ 0xcccc, 0x6666, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xcccc, 0x3333, 0xcccc },  /* Pixel 61 */
		{ 0xcccc, 0x3333, 0x9999 },  /* Pixel 62 */
		{ 0xcccc, 0x3333, 0x6666 },  /* Pixel 63 */
		{ 0xcccc, 0x3333, 0x3333 },  /* Pixel 64 */
		{ 0xcccc, 0x3333, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xcccc, 0x0000, 0xcccc },  /* Pixel 67 */
		{ 0xcccc, 0x0000, 0x9999 },  /* Pixel 68 */
		{ 0xcccc, 0x0000, 0x6666 },  /* Pixel 69 */
		{ 0xcccc, 0x0000, 0x3333 },  /* Pixel 70 */
		{ 0xcccc, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0x9999, 0xcccc, 0xcccc },  /* Pixel 79 */
		{ 0x9999, 0xcccc, 0x9999 },  /* Pixel 80 */
		{ 0x9999, 0xcccc, 0x6666 },  /* Pixel 81 */
		{ 0x9999, 0xcccc, 0x3333 },  /* Pixel 82 */
		{ 0x9999, 0xcccc, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0x9999, 0x9999, 0xcccc },  /* Pixel 85 */
		{ 0x9999, 0x9999, 0x9999 },  /* Pixel 86 */
		{ 0x9999, 0x9999, 0x6666 },  /* Pixel 87 */
		{ 0x9999, 0x9999, 0x3333 },  /* Pixel 88 */
		{ 0x9999, 0x9999, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0x9999, 0x6666, 0xcccc },  /* Pixel 91 */
		{ 0x9999, 0x6666, 0x9999 },  /* Pixel 92 */
		{ 0x9999, 0x6666, 0x6666 },  /* Pixel 93 */
		{ 0x9999, 0x6666, 0x3333 },  /* Pixel 94 */
		{ 0x9999, 0x6666, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0x9999, 0x3333, 0xcccc },  /* Pixel 97 */
		{ 0x9999, 0x3333, 0x9999 },  /* Pixel 98 */
		{ 0x9999, 0x3333, 0x6666 },  /* Pixel 99 */
		{ 0x9999, 0x3333, 0x3333 },  /* Pixel 100 */
		{ 0x9999, 0x3333, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0x9999, 0x0000, 0xcccc },  /* Pixel 103 */
		{ 0x9999, 0x0000, 0x9999 },  /* Pixel 104 */
		{ 0x9999, 0x0000, 0x6666 },  /* Pixel 105 */
		{ 0x9999, 0x0000, 0x3333 },  /* Pixel 106 */
		{ 0x9999, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x6666, 0xcccc, 0xcccc },  /* Pixel 115 */
		{ 0x6666, 0xcccc, 0x9999 },  /* Pixel 116 */
		{ 0x6666, 0xcccc, 0x6666 },  /* Pixel 117 */
		{ 0x6666, 0xcccc, 0x3333 },  /* Pixel 118 */
		{ 0x6666, 0xcccc, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x6666, 0x9999, 0xcccc },  /* Pixel 121 */
		{ 0x6666, 0x9999, 0x9999 },  /* Pixel 122 */
		{ 0x6666, 0x9999, 0x6666 },  /* Pixel 123 */
		{ 0x6666, 0x9999, 0x3333 },  /* Pixel 124 */
		{ 0x6666, 0x9999, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x6666, 0x6666, 0xcccc },  /* Pixel 127 */
		{ 0x6666, 0x6666, 0x9999 },  /* Pixel 128 */
		{ 0x6666, 0x6666, 0x6666 },  /* Pixel 129 */
		{ 0x6666, 0x6666, 0x3333 },  /* Pixel 130 */
		{ 0x6666, 0x6666, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x6666, 0x3333, 0xcccc },  /* Pixel 133 */
		{ 0x6666, 0x3333, 0x9999 },  /* Pixel 134 */
		{ 0x6666, 0x3333, 0x6666 },  /* Pixel 135 */
		{ 0x6666, 0x3333, 0x3333 },  /* Pixel 136 */
		{ 0x6666, 0x3333, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x6666, 0x0000, 0xcccc },  /* Pixel 139 */
		{ 0x6666, 0x0000, 0x9999 },  /* Pixel 140 */
		{ 0x6666, 0x0000, 0x6666 },  /* Pixel 141 */
		{ 0x6666, 0x0000, 0x3333 },  /* Pixel 142 */
		{ 0x6666, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3333, 0xcccc, 0xcccc },  /* Pixel 151 */
		{ 0x3333, 0xcccc, 0x9999 },  /* Pixel 152 */
		{ 0x3333, 0xcccc, 0x6666 },  /* Pixel 153 */
		{ 0x3333, 0xcccc, 0x3333 },  /* Pixel 154 */
		{ 0x3333, 0xcccc, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3333, 0x9999, 0xcccc },  /* Pixel 157 */
		{ 0x3333, 0x9999, 0x9999 },  /* Pixel 158 */
		{ 0x3333, 0x9999, 0x6666 },  /* Pixel 159 */
		{ 0x3333, 0x9999, 0x3333 },  /* Pixel 160 */
		{ 0x3333, 0x9999, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3333, 0x6666, 0xcccc },  /* Pixel 163 */
		{ 0x3333, 0x6666, 0x9999 },  /* Pixel 164 */
		{ 0x3333, 0x6666, 0x6666 },  /* Pixel 165 */
		{ 0x3333, 0x6666, 0x3333 },  /* Pixel 166 */
		{ 0x3333, 0x6666, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3333, 0x3333, 0xcccc },  /* Pixel 169 */
		{ 0x3333, 0x3333, 0x9999 },  /* Pixel 170 */
		{ 0x3333, 0x3333, 0x6666 },  /* Pixel 171 */
		{ 0x3333, 0x3333, 0x3333 },  /* Pixel 172 */
		{ 0x3333, 0x3333, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3333, 0x0000, 0xcccc },  /* Pixel 175 */
		{ 0x3333, 0x0000, 0x9999 },  /* Pixel 176 */
		{ 0x3333, 0x0000, 0x6666 },  /* Pixel 177 */
		{ 0x3333, 0x0000, 0x3333 },  /* Pixel 178 */
		{ 0x3333, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xcccc, 0xcccc },  /* Pixel 187 */
		{ 0x0000, 0xcccc, 0x9999 },  /* Pixel 188 */
		{ 0x0000, 0xcccc, 0x6666 },  /* Pixel 189 */
		{ 0x0000, 0xcccc, 0x3333 },  /* Pixel 190 */
		{ 0x0000, 0xcccc, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0x9999, 0xcccc },  /* Pixel 193 */
		{ 0x0000, 0x9999, 0x9999 },  /* Pixel 194 */
		{ 0x0000, 0x9999, 0x6666 },  /* Pixel 195 */
		{ 0x0000, 0x9999, 0x3333 },  /* Pixel 196 */
		{ 0x0000, 0x9999, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x6666, 0xcccc },  /* Pixel 199 */
		{ 0x0000, 0x6666, 0x9999 },  /* Pixel 200 */
		{ 0x0000, 0x6666, 0x6666 },  /* Pixel 201 */
		{ 0x0000, 0x6666, 0x3333 },  /* Pixel 202 */
		{ 0x0000, 0x6666, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3333, 0xcccc },  /* Pixel 205 */
		{ 0x0000, 0x3333, 0x9999 },  /* Pixel 206 */
		{ 0x0000, 0x3333, 0x6666 },  /* Pixel 207 */
		{ 0x0000, 0x3333, 0x3333 },  /* Pixel 208 */
		{ 0x0000, 0x3333, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xcccc },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0x9999 },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0x6666 },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x3333 },  /* Pixel 214 */
		{ 0xeeee, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xdddd, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xbbbb, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xaaaa, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0x8888, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0x7777, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0x5555, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x4444, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x2222, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x1111, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xeeee, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xdddd, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xbbbb, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xaaaa, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0x8888, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0x7777, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0x5555, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x4444, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x2222, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x1111, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xeeee },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xdddd },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xbbbb },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xaaaa },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0x8888 },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0x7777 },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0x5555 },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x4444 },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x2222 },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x1111 },  /* Pixel 244 */
		{ 0xeeee, 0xeeee, 0xeeee },  /* Pixel 245 */
		{ 0xdddd, 0xdddd, 0xdddd },  /* Pixel 246 */
		{ 0xbbbb, 0xbbbb, 0xbbbb },  /* Pixel 247 */
		{ 0xaaaa, 0xaaaa, 0xaaaa },  /* Pixel 248 */
		{ 0x8888, 0x8888, 0x8888 },  /* Pixel 249 */
		{ 0x7777, 0x7777, 0x7777 },  /* Pixel 250 */
		{ 0x5555, 0x5555, 0x5555 },  /* Pixel 251 */
		{ 0x4444, 0x4444, 0x4444 },  /* Pixel 252 */
		{ 0x2222, 0x2222, 0x2222 },  /* Pixel 253 */
		{ 0x1111, 0x1111, 0x1111 },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},

	/* Gamma level 1 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xd5d5, 0xd5d5, 0xd5d5 },  /* Pixel 43 */
		{ 0xd5d5, 0xd5d5, 0xa0a0 },  /* Pixel 44 */
		{ 0xd5d5, 0xd5d5, 0x6b6b },  /* Pixel 45 */
		{ 0xd5d5, 0xd5d5, 0x3535 },  /* Pixel 46 */
		{ 0xd5d5, 0xd5d5, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xd5d5, 0xa0a0, 0xd5d5 },  /* Pixel 49 */
		{ 0xd5d5, 0xa0a0, 0xa0a0 },  /* Pixel 50 */
		{ 0xd5d5, 0xa0a0, 0x6b6b },  /* Pixel 51 */
		{ 0xd5d5, 0xa0a0, 0x3535 },  /* Pixel 52 */
		{ 0xd5d5, 0xa0a0, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xd5d5, 0x6b6b, 0xd5d5 },  /* Pixel 55 */
		{ 0xd5d5, 0x6b6b, 0xa0a0 },  /* Pixel 56 */
		{ 0xd5d5, 0x6b6b, 0x6b6b },  /* Pixel 57 */
		{ 0xd5d5, 0x6b6b, 0x3535 },  /* Pixel 58 */
		{ 0xd5d5, 0x6b6b, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xd5d5, 0x3535, 0xd5d5 },  /* Pixel 61 */
		{ 0xd5d5, 0x3535, 0xa0a0 },  /* Pixel 62 */
		{ 0xd5d5, 0x3535, 0x6a6a },  /* Pixel 63 */
		{ 0xd5d5, 0x3535, 0x3535 },  /* Pixel 64 */
		{ 0xd5d5, 0x3535, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xd5d5, 0x0000, 0xd5d5 },  /* Pixel 67 */
		{ 0xd5d5, 0x0000, 0xa0a0 },  /* Pixel 68 */
		{ 0xd5d5, 0x0000, 0x6b6b },  /* Pixel 69 */
		{ 0xd5d5, 0x0000, 0x3535 },  /* Pixel 70 */
		{ 0xd5d5, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0xa0a0, 0xd5d5, 0xd5d5 },  /* Pixel 79 */
		{ 0xa0a0, 0xd5d5, 0xa0a0 },  /* Pixel 80 */
		{ 0xa0a0, 0xd5d5, 0x6b6b },  /* Pixel 81 */
		{ 0xa0a0, 0xd5d5, 0x3535 },  /* Pixel 82 */
		{ 0xa0a0, 0xd5d5, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0xa0a0, 0xa0a0, 0xd5d5 },  /* Pixel 85 */
		{ 0xa9a9, 0xa9a9, 0xa9a9 },  /* Pixel 86 */
		{ 0xa9a9, 0xa9a9, 0x7171 },  /* Pixel 87 */
		{ 0xa9a9, 0xa9a9, 0x3838 },  /* Pixel 88 */
		{ 0xa9a9, 0xa9a9, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0xa0a0, 0x6b6b, 0xd5d5 },  /* Pixel 91 */
		{ 0xa9a9, 0x7171, 0xa9a9 },  /* Pixel 92 */
		{ 0xa9a9, 0x7171, 0x7171 },  /* Pixel 93 */
		{ 0xa9a9, 0x7171, 0x3838 },  /* Pixel 94 */
		{ 0xa9a9, 0x7171, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0xa0a0, 0x3535, 0xd5d5 },  /* Pixel 97 */
		{ 0xa9a9, 0x3838, 0xa9a9 },  /* Pixel 98 */
		{ 0xa9a9, 0x3838, 0x7171 },  /* Pixel 99 */
		{ 0xa9a9, 0x3838, 0x3838 },  /* Pixel 100 */
		{ 0xa9a9, 0x3838, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0xa0a0, 0x0000, 0xd5d5 },  /* Pixel 103 */
		{ 0xa9a9, 0x0000, 0xa9a9 },  /* Pixel 104 */
		{ 0xa9a9, 0x0000, 0x7171 },  /* Pixel 105 */
		{ 0xa9a9, 0x0000, 0x3838 },  /* Pixel 106 */
		{ 0xa9a9, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x6b6b, 0xd5d5, 0xd5d5 },  /* Pixel 115 */
		{ 0x6b6b, 0xd5d5, 0xa0a0 },  /* Pixel 116 */
		{ 0x6b6b, 0xd5d5, 0x6b6b },  /* Pixel 117 */
		{ 0x6a6a, 0xd5d5, 0x3535 },  /* Pixel 118 */
		{ 0x6b6b, 0xd5d5, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x6b6b, 0xa0a0, 0xd5d5 },  /* Pixel 121 */
		{ 0x7171, 0xa9a9, 0xa9a9 },  /* Pixel 122 */
		{ 0x7171, 0xa9a9, 0x7171 },  /* Pixel 123 */
		{ 0x7171, 0xa9a9, 0x3838 },  /* Pixel 124 */
		{ 0x7171, 0xa9a9, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x6b6b, 0x6b6b, 0xd5d5 },  /* Pixel 127 */
		{ 0x7171, 0x7171, 0xa9a9 },  /* Pixel 128 */
		{ 0x7b7b, 0x7b7b, 0x7b7b },  /* Pixel 129 */
		{ 0x7b7b, 0x7b7b, 0x3e3e },  /* Pixel 130 */
		{ 0x7b7b, 0x7b7b, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x6a6a, 0x3535, 0xd5d5 },  /* Pixel 133 */
		{ 0x7171, 0x3838, 0xa9a9 },  /* Pixel 134 */
		{ 0x7b7b, 0x3e3e, 0x7b7b },  /* Pixel 135 */
		{ 0x7b7b, 0x3e3e, 0x3e3e },  /* Pixel 136 */
		{ 0x7b7b, 0x3e3e, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x6b6b, 0x0000, 0xd5d5 },  /* Pixel 139 */
		{ 0x7171, 0x0000, 0xa9a9 },  /* Pixel 140 */
		{ 0x7b7b, 0x0000, 0x7b7b },  /* Pixel 141 */
		{ 0x7b7b, 0x0000, 0x3e3e },  /* Pixel 142 */
		{ 0x7b7b, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3535, 0xd5d5, 0xd5d5 },  /* Pixel 151 */
		{ 0x3535, 0xd5d5, 0xa0a0 },  /* Pixel 152 */
		{ 0x3535, 0xd5d5, 0x6b6b },  /* Pixel 153 */
		{ 0x3535, 0xd5d5, 0x3535 },  /* Pixel 154 */
		{ 0x3535, 0xd5d5, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3535, 0xa0a0, 0xd5d5 },  /* Pixel 157 */
		{ 0x3838, 0xa9a9, 0xa9a9 },  /* Pixel 158 */
		{ 0x3838, 0xa9a9, 0x7171 },  /* Pixel 159 */
		{ 0x3838, 0xa9a9, 0x3838 },  /* Pixel 160 */
		{ 0x3838, 0xa9a9, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3535, 0x6b6b, 0xd5d5 },  /* Pixel 163 */
		{ 0x3838, 0x7171, 0xa9a9 },  /* Pixel 164 */
		{ 0x3e3e, 0x7b7b, 0x7b7b },  /* Pixel 165 */
		{ 0x3e3e, 0x7b7b, 0x3e3e },  /* Pixel 166 */
		{ 0x3e3e, 0x7b7b, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3535, 0x3535, 0xd5d5 },  /* Pixel 169 */
		{ 0x3838, 0x3838, 0xa9a9 },  /* Pixel 170 */
		{ 0x3e3e, 0x3e3e, 0x7b7b },  /* Pixel 171 */
		{ 0x4646, 0x4646, 0x4646 },  /* Pixel 172 */
		{ 0x4646, 0x4646, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3535, 0x0000, 0xd5d5 },  /* Pixel 175 */
		{ 0x3838, 0x0000, 0xa9a9 },  /* Pixel 176 */
		{ 0x3e3e, 0x0000, 0x7b7b },  /* Pixel 177 */
		{ 0x4646, 0x0000, 0x4646 },  /* Pixel 178 */
		{ 0x4646, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xd5d5, 0xd5d5 },  /* Pixel 187 */
		{ 0x0000, 0xd5d5, 0xa0a0 },  /* Pixel 188 */
		{ 0x0000, 0xd5d5, 0x6b6b },  /* Pixel 189 */
		{ 0x0000, 0xd5d5, 0x3535 },  /* Pixel 190 */
		{ 0x0000, 0xd5d5, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0xa0a0, 0xd5d5 },  /* Pixel 193 */
		{ 0x0000, 0xa9a9, 0xa9a9 },  /* Pixel 194 */
		{ 0x0000, 0xa9a9, 0x7171 },  /* Pixel 195 */
		{ 0x0000, 0xa9a9, 0x3838 },  /* Pixel 196 */
		{ 0x0000, 0xa9a9, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x6b6b, 0xd5d5 },  /* Pixel 199 */
		{ 0x0000, 0x7171, 0xa9a9 },  /* Pixel 200 */
		{ 0x0000, 0x7b7b, 0x7b7b },  /* Pixel 201 */
		{ 0x0000, 0x7b7b, 0x3e3e },  /* Pixel 202 */
		{ 0x0000, 0x7b7b, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3535, 0xd5d5 },  /* Pixel 205 */
		{ 0x0000, 0x3838, 0xa9a9 },  /* Pixel 206 */
		{ 0x0000, 0x3e3e, 0x7b7b },  /* Pixel 207 */
		{ 0x0000, 0x4646, 0x4646 },  /* Pixel 208 */
		{ 0x0000, 0x4646, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xd5d5 },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0xa9a9 },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0x7b7b },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x4646 },  /* Pixel 214 */
		{ 0xf1f1, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xe3e3, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xc7c7, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xb8b8, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0x9a9a, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0x8b8b, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0x6a6a, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x5959, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x3333, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x1d1d, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xf1f1, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xe3e3, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xc7c7, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xb8b8, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0x9a9a, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0x8b8b, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0x6a6a, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x5959, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x3333, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x1d1d, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xf1f1 },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xe3e3 },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xc7c7 },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xb8b8 },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0x9a9a },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0x8b8b },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0x6a6a },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x5959 },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x3333 },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x1d1d },  /* Pixel 244 */
		{ 0xf1f1, 0xf1f1, 0xf1f1 },  /* Pixel 245 */
		{ 0xe3e3, 0xe3e3, 0xe3e3 },  /* Pixel 246 */
		{ 0xc7c7, 0xc7c7, 0xc7c7 },  /* Pixel 247 */
		{ 0xb8b8, 0xb8b8, 0xb8b8 },  /* Pixel 248 */
		{ 0x9a9a, 0x9a9a, 0x9a9a },  /* Pixel 249 */
		{ 0x8b8b, 0x8b8b, 0x8b8b },  /* Pixel 250 */
		{ 0x6a6a, 0x6a6a, 0x6a6a },  /* Pixel 251 */
		{ 0x5959, 0x5959, 0x5959 },  /* Pixel 252 */
		{ 0x3333, 0x3333, 0x3333 },  /* Pixel 253 */
		{ 0x1d1d, 0x1d1d, 0x1d1d },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},

	/* Gamma level 2 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xdcdc, 0xdcdc, 0xdcdc },  /* Pixel 43 */
		{ 0xdcdc, 0xdcdc, 0xa5a5 },  /* Pixel 44 */
		{ 0xdcdc, 0xdcdc, 0x6e6e },  /* Pixel 45 */
		{ 0xdcdc, 0xdcdc, 0x3737 },  /* Pixel 46 */
		{ 0xdcdc, 0xdcdc, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xdcdc, 0xa5a5, 0xdcdc },  /* Pixel 49 */
		{ 0xdcdc, 0xa5a5, 0xa5a5 },  /* Pixel 50 */
		{ 0xdcdc, 0xa5a5, 0x6e6e },  /* Pixel 51 */
		{ 0xdcdc, 0xa5a5, 0x3737 },  /* Pixel 52 */
		{ 0xdcdc, 0xa5a5, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xdcdc, 0x6e6e, 0xdcdc },  /* Pixel 55 */
		{ 0xdcdc, 0x6e6e, 0xa5a5 },  /* Pixel 56 */
		{ 0xdcdc, 0x6e6e, 0x6e6e },  /* Pixel 57 */
		{ 0xdcdc, 0x6e6e, 0x3737 },  /* Pixel 58 */
		{ 0xdcdc, 0x6e6e, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xdcdc, 0x3737, 0xdcdc },  /* Pixel 61 */
		{ 0xdcdc, 0x3737, 0xa5a5 },  /* Pixel 62 */
		{ 0xdcdc, 0x3737, 0x6e6e },  /* Pixel 63 */
		{ 0xdcdc, 0x3737, 0x3737 },  /* Pixel 64 */
		{ 0xdcdc, 0x3737, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xdcdc, 0x0000, 0xdcdc },  /* Pixel 67 */
		{ 0xdcdc, 0x0000, 0xa5a5 },  /* Pixel 68 */
		{ 0xdcdc, 0x0000, 0x6e6e },  /* Pixel 69 */
		{ 0xdcdc, 0x0000, 0x3737 },  /* Pixel 70 */
		{ 0xdcdc, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0xa5a5, 0xdcdc, 0xdcdc },  /* Pixel 79 */
		{ 0xa5a5, 0xdcdc, 0xa5a5 },  /* Pixel 80 */
		{ 0xa5a5, 0xdcdc, 0x6e6e },  /* Pixel 81 */
		{ 0xa5a5, 0xdcdc, 0x3737 },  /* Pixel 82 */
		{ 0xa5a5, 0xdcdc, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0xa5a5, 0xa5a5, 0xdcdc },  /* Pixel 85 */
		{ 0xb5b5, 0xb5b5, 0xb5b5 },  /* Pixel 86 */
		{ 0xb5b5, 0xb5b5, 0x7979 },  /* Pixel 87 */
		{ 0xb5b5, 0xb5b5, 0x3c3c },  /* Pixel 88 */
		{ 0xb5b5, 0xb5b5, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0xa5a5, 0x6e6e, 0xdcdc },  /* Pixel 91 */
		{ 0xb5b5, 0x7979, 0xb5b5 },  /* Pixel 92 */
		{ 0xb5b5, 0x7979, 0x7979 },  /* Pixel 93 */
		{ 0xb5b5, 0x7979, 0x3c3c },  /* Pixel 94 */
		{ 0xb5b5, 0x7979, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0xa5a5, 0x3737, 0xdcdc },  /* Pixel 97 */
		{ 0xb5b5, 0x3c3c, 0xb5b5 },  /* Pixel 98 */
		{ 0xb5b5, 0x3c3c, 0x7979 },  /* Pixel 99 */
		{ 0xb5b5, 0x3c3c, 0x3c3c },  /* Pixel 100 */
		{ 0xb5b5, 0x3c3c, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0xa5a5, 0x0000, 0xdcdc },  /* Pixel 103 */
		{ 0xb5b5, 0x0000, 0xb5b5 },  /* Pixel 104 */
		{ 0xb5b5, 0x0000, 0x7979 },  /* Pixel 105 */
		{ 0xb5b5, 0x0000, 0x3c3c },  /* Pixel 106 */
		{ 0xb5b5, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x6e6e, 0xdcdc, 0xdcdc },  /* Pixel 115 */
		{ 0x6e6e, 0xdcdc, 0xa5a5 },  /* Pixel 116 */
		{ 0x6e6e, 0xdcdc, 0x6e6e },  /* Pixel 117 */
		{ 0x6e6e, 0xdcdc, 0x3737 },  /* Pixel 118 */
		{ 0x6e6e, 0xdcdc, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x6e6e, 0xa5a5, 0xdcdc },  /* Pixel 121 */
		{ 0x7979, 0xb5b5, 0xb5b5 },  /* Pixel 122 */
		{ 0x7979, 0xb5b5, 0x7979 },  /* Pixel 123 */
		{ 0x7979, 0xb5b5, 0x3c3c },  /* Pixel 124 */
		{ 0x7979, 0xb5b5, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x6e6e, 0x6e6e, 0xdcdc },  /* Pixel 127 */
		{ 0x7979, 0x7979, 0xb5b5 },  /* Pixel 128 */
		{ 0x8a8a, 0x8a8a, 0x8a8a },  /* Pixel 129 */
		{ 0x8a8a, 0x8a8a, 0x4545 },  /* Pixel 130 */
		{ 0x8a8a, 0x8a8a, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x6e6e, 0x3737, 0xdcdc },  /* Pixel 133 */
		{ 0x7979, 0x3c3c, 0xb5b5 },  /* Pixel 134 */
		{ 0x8a8a, 0x4545, 0x8a8a },  /* Pixel 135 */
		{ 0x8a8a, 0x4545, 0x4545 },  /* Pixel 136 */
		{ 0x8a8a, 0x4545, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x6e6e, 0x0000, 0xdcdc },  /* Pixel 139 */
		{ 0x7979, 0x0000, 0xb5b5 },  /* Pixel 140 */
		{ 0x8a8a, 0x0000, 0x8a8a },  /* Pixel 141 */
		{ 0x8a8a, 0x0000, 0x4545 },  /* Pixel 142 */
		{ 0x8a8a, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3737, 0xdcdc, 0xdcdc },  /* Pixel 151 */
		{ 0x3737, 0xdcdc, 0xa5a5 },  /* Pixel 152 */
		{ 0x3737, 0xdcdc, 0x6e6e },  /* Pixel 153 */
		{ 0x3737, 0xdcdc, 0x3737 },  /* Pixel 154 */
		{ 0x3737, 0xdcdc, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3737, 0xa5a5, 0xdcdc },  /* Pixel 157 */
		{ 0x3c3c, 0xb5b5, 0xb5b5 },  /* Pixel 158 */
		{ 0x3c3c, 0xb5b5, 0x7979 },  /* Pixel 159 */
		{ 0x3c3c, 0xb5b5, 0x3c3c },  /* Pixel 160 */
		{ 0x3c3c, 0xb5b5, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3737, 0x6e6e, 0xdcdc },  /* Pixel 163 */
		{ 0x3c3c, 0x7979, 0xb5b5 },  /* Pixel 164 */
		{ 0x4545, 0x8a8a, 0x8a8a },  /* Pixel 165 */
		{ 0x4545, 0x8a8a, 0x4545 },  /* Pixel 166 */
		{ 0x4545, 0x8a8a, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3737, 0x3737, 0xdcdc },  /* Pixel 169 */
		{ 0x3c3c, 0x3c3c, 0xb5b5 },  /* Pixel 170 */
		{ 0x4545, 0x4545, 0x8a8a },  /* Pixel 171 */
		{ 0x5757, 0x5757, 0x5757 },  /* Pixel 172 */
		{ 0x5757, 0x5757, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3737, 0x0000, 0xdcdc },  /* Pixel 175 */
		{ 0x3c3c, 0x0000, 0xb5b5 },  /* Pixel 176 */
		{ 0x4545, 0x0000, 0x8a8a },  /* Pixel 177 */
		{ 0x5757, 0x0000, 0x5757 },  /* Pixel 178 */
		{ 0x5757, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xdcdc, 0xdcdc },  /* Pixel 187 */
		{ 0x0000, 0xdcdc, 0xa5a5 },  /* Pixel 188 */
		{ 0x0000, 0xdcdc, 0x6e6e },  /* Pixel 189 */
		{ 0x0000, 0xdcdc, 0x3737 },  /* Pixel 190 */
		{ 0x0000, 0xdcdc, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0xa5a5, 0xdcdc },  /* Pixel 193 */
		{ 0x0000, 0xb5b5, 0xb5b5 },  /* Pixel 194 */
		{ 0x0000, 0xb5b5, 0x7979 },  /* Pixel 195 */
		{ 0x0000, 0xb5b5, 0x3c3c },  /* Pixel 196 */
		{ 0x0000, 0xb5b5, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x6e6e, 0xdcdc },  /* Pixel 199 */
		{ 0x0000, 0x7979, 0xb5b5 },  /* Pixel 200 */
		{ 0x0000, 0x8a8a, 0x8a8a },  /* Pixel 201 */
		{ 0x0000, 0x8a8a, 0x4545 },  /* Pixel 202 */
		{ 0x0000, 0x8a8a, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3737, 0xdcdc },  /* Pixel 205 */
		{ 0x0000, 0x3c3c, 0xb5b5 },  /* Pixel 206 */
		{ 0x0000, 0x4545, 0x8a8a },  /* Pixel 207 */
		{ 0x0000, 0x5757, 0x5757 },  /* Pixel 208 */
		{ 0x0000, 0x5757, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xdcdc },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0xb5b5 },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0x8a8a },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x5757 },  /* Pixel 214 */
		{ 0xf4f4, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xe8e8, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xcfcf, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xc3c3, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0xa8a8, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0x9999, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0x7b7b, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x6a6a, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x4343, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x2a2a, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xf4f4, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xe8e8, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xcfcf, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xc3c3, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0xa8a8, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0x9999, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0x7b7b, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x6a6a, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x4343, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x2a2a, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xf4f4 },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xe8e8 },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xcfcf },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xc3c3 },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0xa8a8 },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0x9999 },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0x7b7b },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x6a6a },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x4343 },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x2a2a },  /* Pixel 244 */
		{ 0xf4f4, 0xf4f4, 0xf4f4 },  /* Pixel 245 */
		{ 0xe8e8, 0xe8e8, 0xe8e8 },  /* Pixel 246 */
		{ 0xcfcf, 0xcfcf, 0xcfcf },  /* Pixel 247 */
		{ 0xc3c3, 0xc3c3, 0xc3c3 },  /* Pixel 248 */
		{ 0xa8a8, 0xa8a8, 0xa8a8 },  /* Pixel 249 */
		{ 0x9999, 0x9999, 0x9999 },  /* Pixel 250 */
		{ 0x7b7b, 0x7b7b, 0x7b7b },  /* Pixel 251 */
		{ 0x6a6a, 0x6a6a, 0x6a6a },  /* Pixel 252 */
		{ 0x4343, 0x4343, 0x4343 },  /* Pixel 253 */
		{ 0x2a2a, 0x2a2a, 0x2a2a },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},

	/* Gamma level 3 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xe0e0, 0xe0e0, 0xe0e0 },  /* Pixel 43 */
		{ 0xe0e0, 0xe0e0, 0xa8a8 },  /* Pixel 44 */
		{ 0xe0e0, 0xe0e0, 0x7070 },  /* Pixel 45 */
		{ 0xe0e0, 0xe0e0, 0x3838 },  /* Pixel 46 */
		{ 0xe0e0, 0xe0e0, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xe0e0, 0xa8a8, 0xe0e0 },  /* Pixel 49 */
		{ 0xe0e0, 0xa8a8, 0xa8a8 },  /* Pixel 50 */
		{ 0xe0e0, 0xa8a8, 0x7070 },  /* Pixel 51 */
		{ 0xe0e0, 0xa8a8, 0x3838 },  /* Pixel 52 */
		{ 0xe0e0, 0xa8a8, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xe0e0, 0x7070, 0xe0e0 },  /* Pixel 55 */
		{ 0xe0e0, 0x7070, 0xa8a8 },  /* Pixel 56 */
		{ 0xe0e0, 0x7070, 0x7070 },  /* Pixel 57 */
		{ 0xe0e0, 0x7070, 0x3838 },  /* Pixel 58 */
		{ 0xe0e0, 0x7070, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xe0e0, 0x3838, 0xe0e0 },  /* Pixel 61 */
		{ 0xe0e0, 0x3838, 0xa8a8 },  /* Pixel 62 */
		{ 0xe0e0, 0x3838, 0x7070 },  /* Pixel 63 */
		{ 0xe0e0, 0x3838, 0x3838 },  /* Pixel 64 */
		{ 0xe0e0, 0x3838, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xe0e0, 0x0000, 0xe0e0 },  /* Pixel 67 */
		{ 0xe0e0, 0x0000, 0xa8a8 },  /* Pixel 68 */
		{ 0xe0e0, 0x0000, 0x7070 },  /* Pixel 69 */
		{ 0xe0e0, 0x0000, 0x3838 },  /* Pixel 70 */
		{ 0xe0e0, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0xa8a8, 0xe0e0, 0xe0e0 },  /* Pixel 79 */
		{ 0xa8a8, 0xe0e0, 0xa8a8 },  /* Pixel 80 */
		{ 0xa8a8, 0xe0e0, 0x7070 },  /* Pixel 81 */
		{ 0xa8a8, 0xe0e0, 0x3838 },  /* Pixel 82 */
		{ 0xa8a8, 0xe0e0, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0xa8a8, 0xa8a8, 0xe0e0 },  /* Pixel 85 */
		{ 0xbebe, 0xbebe, 0xbebe },  /* Pixel 86 */
		{ 0xbebe, 0xbebe, 0x7f7f },  /* Pixel 87 */
		{ 0xbebe, 0xbebe, 0x3f3f },  /* Pixel 88 */
		{ 0xbebe, 0xbebe, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0xa8a8, 0x7070, 0xe0e0 },  /* Pixel 91 */
		{ 0xbebe, 0x7f7f, 0xbebe },  /* Pixel 92 */
		{ 0xbebe, 0x7f7f, 0x7f7f },  /* Pixel 93 */
		{ 0xbebe, 0x7f7f, 0x3f3f },  /* Pixel 94 */
		{ 0xbebe, 0x7f7f, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0xa8a8, 0x3838, 0xe0e0 },  /* Pixel 97 */
		{ 0xbebe, 0x3f3f, 0xbebe },  /* Pixel 98 */
		{ 0xbebe, 0x3f3f, 0x7f7f },  /* Pixel 99 */
		{ 0xbebe, 0x3f3f, 0x3f3f },  /* Pixel 100 */
		{ 0xbebe, 0x3f3f, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0xa8a8, 0x0000, 0xe0e0 },  /* Pixel 103 */
		{ 0xbebe, 0x0000, 0xbebe },  /* Pixel 104 */
		{ 0xbebe, 0x0000, 0x7f7f },  /* Pixel 105 */
		{ 0xbebe, 0x0000, 0x3f3f },  /* Pixel 106 */
		{ 0xbebe, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x7070, 0xe0e0, 0xe0e0 },  /* Pixel 115 */
		{ 0x7070, 0xe0e0, 0xa8a8 },  /* Pixel 116 */
		{ 0x7070, 0xe0e0, 0x7070 },  /* Pixel 117 */
		{ 0x7070, 0xe0e0, 0x3838 },  /* Pixel 118 */
		{ 0x7070, 0xe0e0, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x7070, 0xa8a8, 0xe0e0 },  /* Pixel 121 */
		{ 0x7f7f, 0xbebe, 0xbebe },  /* Pixel 122 */
		{ 0x7f7f, 0xbebe, 0x7f7f },  /* Pixel 123 */
		{ 0x7f7f, 0xbebe, 0x3f3f },  /* Pixel 124 */
		{ 0x7f7f, 0xbebe, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x7070, 0x7070, 0xe0e0 },  /* Pixel 127 */
		{ 0x7f7f, 0x7f7f, 0xbebe },  /* Pixel 128 */
		{ 0x9797, 0x9797, 0x9797 },  /* Pixel 129 */
		{ 0x9797, 0x9797, 0x4c4c },  /* Pixel 130 */
		{ 0x9797, 0x9797, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x7070, 0x3838, 0xe0e0 },  /* Pixel 133 */
		{ 0x7f7f, 0x3f3f, 0xbebe },  /* Pixel 134 */
		{ 0x9797, 0x4c4c, 0x9797 },  /* Pixel 135 */
		{ 0x9797, 0x4c4c, 0x4c4c },  /* Pixel 136 */
		{ 0x9797, 0x4c4c, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x7070, 0x0000, 0xe0e0 },  /* Pixel 139 */
		{ 0x7f7f, 0x0000, 0xbebe },  /* Pixel 140 */
		{ 0x9797, 0x0000, 0x9797 },  /* Pixel 141 */
		{ 0x9797, 0x0000, 0x4c4c },  /* Pixel 142 */
		{ 0x9797, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3838, 0xe0e0, 0xe0e0 },  /* Pixel 151 */
		{ 0x3838, 0xe0e0, 0xa8a8 },  /* Pixel 152 */
		{ 0x3838, 0xe0e0, 0x7070 },  /* Pixel 153 */
		{ 0x3838, 0xe0e0, 0x3838 },  /* Pixel 154 */
		{ 0x3838, 0xe0e0, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3838, 0xa8a8, 0xe0e0 },  /* Pixel 157 */
		{ 0x3f3f, 0xbebe, 0xbebe },  /* Pixel 158 */
		{ 0x3f3f, 0xbebe, 0x7f7f },  /* Pixel 159 */
		{ 0x3f3f, 0xbebe, 0x3f3f },  /* Pixel 160 */
		{ 0x3f3f, 0xbebe, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3838, 0x7070, 0xe0e0 },  /* Pixel 163 */
		{ 0x3f3f, 0x7f7f, 0xbebe },  /* Pixel 164 */
		{ 0x4c4c, 0x9797, 0x9797 },  /* Pixel 165 */
		{ 0x4c4c, 0x9797, 0x4c4c },  /* Pixel 166 */
		{ 0x4c4c, 0x9797, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3838, 0x3838, 0xe0e0 },  /* Pixel 169 */
		{ 0x3f3f, 0x3f3f, 0xbebe },  /* Pixel 170 */
		{ 0x4c4c, 0x4c4c, 0x9797 },  /* Pixel 171 */
		{ 0x6666, 0x6666, 0x6666 },  /* Pixel 172 */
		{ 0x6666, 0x6666, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3838, 0x0000, 0xe0e0 },  /* Pixel 175 */
		{ 0x3f3f, 0x0000, 0xbebe },  /* Pixel 176 */
		{ 0x4c4c, 0x0000, 0x9797 },  /* Pixel 177 */
		{ 0x6666, 0x0000, 0x6666 },  /* Pixel 178 */
		{ 0x6666, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xe0e0, 0xe0e0 },  /* Pixel 187 */
		{ 0x0000, 0xe0e0, 0xa8a8 },  /* Pixel 188 */
		{ 0x0000, 0xe0e0, 0x7070 },  /* Pixel 189 */
		{ 0x0000, 0xe0e0, 0x3838 },  /* Pixel 190 */
		{ 0x0000, 0xe0e0, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0xa8a8, 0xe0e0 },  /* Pixel 193 */
		{ 0x0000, 0xbebe, 0xbebe },  /* Pixel 194 */
		{ 0x0000, 0xbebe, 0x7f7f },  /* Pixel 195 */
		{ 0x0000, 0xbebe, 0x3f3f },  /* Pixel 196 */
		{ 0x0000, 0xbebe, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x7070, 0xe0e0 },  /* Pixel 199 */
		{ 0x0000, 0x7f7f, 0xbebe },  /* Pixel 200 */
		{ 0x0000, 0x9797, 0x9797 },  /* Pixel 201 */
		{ 0x0000, 0x9797, 0x4c4c },  /* Pixel 202 */
		{ 0x0000, 0x9797, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3838, 0xe0e0 },  /* Pixel 205 */
		{ 0x0000, 0x3f3f, 0xbebe },  /* Pixel 206 */
		{ 0x0000, 0x4c4c, 0x9797 },  /* Pixel 207 */
		{ 0x0000, 0x6666, 0x6666 },  /* Pixel 208 */
		{ 0x0000, 0x6666, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xe0e0 },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0xbebe },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0x9797 },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x6666 },  /* Pixel 214 */
		{ 0xf5f5, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xebeb, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xd6d6, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xcaca, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0xb2b2, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0xa5a5, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0x8888, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x7878, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x5151, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x3636, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xf5f5, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xebeb, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xd6d6, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xcaca, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0xb2b2, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0xa5a5, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0x8888, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x7878, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x5151, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x3636, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xf5f5 },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xebeb },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xd6d6 },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xcaca },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0xb2b2 },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0xa5a5 },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0x8888 },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x7878 },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x5151 },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x3636 },  /* Pixel 244 */
		{ 0xf5f5, 0xf5f5, 0xf5f5 },  /* Pixel 245 */
		{ 0xebeb, 0xebeb, 0xebeb },  /* Pixel 246 */
		{ 0xd6d6, 0xd6d6, 0xd6d6 },  /* Pixel 247 */
		{ 0xcaca, 0xcaca, 0xcaca },  /* Pixel 248 */
		{ 0xb2b2, 0xb2b2, 0xb2b2 },  /* Pixel 249 */
		{ 0xa5a5, 0xa5a5, 0xa5a5 },  /* Pixel 250 */
		{ 0x8888, 0x8888, 0x8888 },  /* Pixel 251 */
		{ 0x7878, 0x7878, 0x7878 },  /* Pixel 252 */
		{ 0x5151, 0x5151, 0x5151 },  /* Pixel 253 */
		{ 0x3636, 0x3636, 0x3636 },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},

	/* Gamma level 4 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xe4e4, 0xe4e4, 0xe4e4 },  /* Pixel 43 */
		{ 0xe4e4, 0xe4e4, 0xabab },  /* Pixel 44 */
		{ 0xe4e4, 0xe4e4, 0x7272 },  /* Pixel 45 */
		{ 0xe4e4, 0xe4e4, 0x3939 },  /* Pixel 46 */
		{ 0xe4e4, 0xe4e4, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xe4e4, 0xabab, 0xe4e4 },  /* Pixel 49 */
		{ 0xe4e4, 0xabab, 0xabab },  /* Pixel 50 */
		{ 0xe4e4, 0xabab, 0x7272 },  /* Pixel 51 */
		{ 0xe4e4, 0xabab, 0x3939 },  /* Pixel 52 */
		{ 0xe4e4, 0xabab, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xe4e4, 0x7272, 0xe4e4 },  /* Pixel 55 */
		{ 0xe4e4, 0x7272, 0xabab },  /* Pixel 56 */
		{ 0xe4e4, 0x7272, 0x7272 },  /* Pixel 57 */
		{ 0xe4e4, 0x7272, 0x3939 },  /* Pixel 58 */
		{ 0xe4e4, 0x7272, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xe4e4, 0x3939, 0xe4e4 },  /* Pixel 61 */
		{ 0xe4e4, 0x3939, 0xabab },  /* Pixel 62 */
		{ 0xe4e4, 0x3939, 0x7272 },  /* Pixel 63 */
		{ 0xe4e4, 0x3939, 0x3939 },  /* Pixel 64 */
		{ 0xe4e4, 0x3939, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xe4e4, 0x0000, 0xe4e4 },  /* Pixel 67 */
		{ 0xe4e4, 0x0000, 0xabab },  /* Pixel 68 */
		{ 0xe4e4, 0x0000, 0x7272 },  /* Pixel 69 */
		{ 0xe4e4, 0x0000, 0x3939 },  /* Pixel 70 */
		{ 0xe4e4, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0xabab, 0xe4e4, 0xe4e4 },  /* Pixel 79 */
		{ 0xabab, 0xe4e4, 0xabab },  /* Pixel 80 */
		{ 0xabab, 0xe4e4, 0x7272 },  /* Pixel 81 */
		{ 0xabab, 0xe4e4, 0x3939 },  /* Pixel 82 */
		{ 0xabab, 0xe4e4, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0xabab, 0xabab, 0xe4e4 },  /* Pixel 85 */
		{ 0xc6c6, 0xc6c6, 0xc6c6 },  /* Pixel 86 */
		{ 0xc6c6, 0xc6c6, 0x8484 },  /* Pixel 87 */
		{ 0xc6c6, 0xc6c6, 0x4242 },  /* Pixel 88 */
		{ 0xc6c6, 0xc6c6, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0xabab, 0x7272, 0xe4e4 },  /* Pixel 91 */
		{ 0xc6c6, 0x8484, 0xc6c6 },  /* Pixel 92 */
		{ 0xc6c6, 0x8484, 0x8484 },  /* Pixel 93 */
		{ 0xc6c6, 0x8484, 0x4242 },  /* Pixel 94 */
		{ 0xc6c6, 0x8484, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0xabab, 0x3939, 0xe4e4 },  /* Pixel 97 */
		{ 0xc6c6, 0x4242, 0xc6c6 },  /* Pixel 98 */
		{ 0xc6c6, 0x4242, 0x8484 },  /* Pixel 99 */
		{ 0xc6c6, 0x4242, 0x4242 },  /* Pixel 100 */
		{ 0xc6c6, 0x4242, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0xabab, 0x0000, 0xe4e4 },  /* Pixel 103 */
		{ 0xc6c6, 0x0000, 0xc6c6 },  /* Pixel 104 */
		{ 0xc6c6, 0x0000, 0x8484 },  /* Pixel 105 */
		{ 0xc6c6, 0x0000, 0x4242 },  /* Pixel 106 */
		{ 0xc6c6, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x7272, 0xe4e4, 0xe4e4 },  /* Pixel 115 */
		{ 0x7272, 0xe4e4, 0xabab },  /* Pixel 116 */
		{ 0x7272, 0xe4e4, 0x7272 },  /* Pixel 117 */
		{ 0x7272, 0xe4e4, 0x3939 },  /* Pixel 118 */
		{ 0x7272, 0xe4e4, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x7272, 0xabab, 0xe4e4 },  /* Pixel 121 */
		{ 0x8484, 0xc6c6, 0xc6c6 },  /* Pixel 122 */
		{ 0x8484, 0xc6c6, 0x8484 },  /* Pixel 123 */
		{ 0x8484, 0xc6c6, 0x4242 },  /* Pixel 124 */
		{ 0x8484, 0xc6c6, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x7272, 0x7272, 0xe4e4 },  /* Pixel 127 */
		{ 0x8484, 0x8484, 0xc6c6 },  /* Pixel 128 */
		{ 0xa1a1, 0xa1a1, 0xa1a1 },  /* Pixel 129 */
		{ 0xa1a1, 0xa1a1, 0x5151 },  /* Pixel 130 */
		{ 0xa1a1, 0xa1a1, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x7272, 0x3939, 0xe4e4 },  /* Pixel 133 */
		{ 0x8484, 0x4242, 0xc6c6 },  /* Pixel 134 */
		{ 0xa1a1, 0x5151, 0xa1a1 },  /* Pixel 135 */
		{ 0xa1a1, 0x5151, 0x5151 },  /* Pixel 136 */
		{ 0xa1a1, 0x5151, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x7272, 0x0000, 0xe4e4 },  /* Pixel 139 */
		{ 0x8484, 0x0000, 0xc6c6 },  /* Pixel 140 */
		{ 0xa1a1, 0x0000, 0xa1a1 },  /* Pixel 141 */
		{ 0xa1a1, 0x0000, 0x5151 },  /* Pixel 142 */
		{ 0xa1a1, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3939, 0xe4e4, 0xe4e4 },  /* Pixel 151 */
		{ 0x3939, 0xe4e4, 0xabab },  /* Pixel 152 */
		{ 0x3939, 0xe4e4, 0x7272 },  /* Pixel 153 */
		{ 0x3939, 0xe4e4, 0x3939 },  /* Pixel 154 */
		{ 0x3939, 0xe4e4, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3939, 0xabab, 0xe4e4 },  /* Pixel 157 */
		{ 0x4242, 0xc6c6, 0xc6c6 },  /* Pixel 158 */
		{ 0x4242, 0xc6c6, 0x8484 },  /* Pixel 159 */
		{ 0x4242, 0xc6c6, 0x4242 },  /* Pixel 160 */
		{ 0x4242, 0xc6c6, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3939, 0x7272, 0xe4e4 },  /* Pixel 163 */
		{ 0x4242, 0x8484, 0xc6c6 },  /* Pixel 164 */
		{ 0x5151, 0xa1a1, 0xa1a1 },  /* Pixel 165 */
		{ 0x5151, 0xa1a1, 0x5151 },  /* Pixel 166 */
		{ 0x5151, 0xa1a1, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3939, 0x3939, 0xe4e4 },  /* Pixel 169 */
		{ 0x4242, 0x4242, 0xc6c6 },  /* Pixel 170 */
		{ 0x5151, 0x5151, 0xa1a1 },  /* Pixel 171 */
		{ 0x7272, 0x7272, 0x7272 },  /* Pixel 172 */
		{ 0x7272, 0x7272, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3939, 0x0000, 0xe4e4 },  /* Pixel 175 */
		{ 0x4242, 0x0000, 0xc6c6 },  /* Pixel 176 */
		{ 0x5151, 0x0000, 0xa1a1 },  /* Pixel 177 */
		{ 0x7272, 0x0000, 0x7272 },  /* Pixel 178 */
		{ 0x7272, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xe4e4, 0xe4e4 },  /* Pixel 187 */
		{ 0x0000, 0xe4e4, 0xabab },  /* Pixel 188 */
		{ 0x0000, 0xe4e4, 0x7272 },  /* Pixel 189 */
		{ 0x0000, 0xe4e4, 0x3939 },  /* Pixel 190 */
		{ 0x0000, 0xe4e4, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0xabab, 0xe4e4 },  /* Pixel 193 */
		{ 0x0000, 0xc6c6, 0xc6c6 },  /* Pixel 194 */
		{ 0x0000, 0xc6c6, 0x8484 },  /* Pixel 195 */
		{ 0x0000, 0xc6c6, 0x4242 },  /* Pixel 196 */
		{ 0x0000, 0xc6c6, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x7272, 0xe4e4 },  /* Pixel 199 */
		{ 0x0000, 0x8484, 0xc6c6 },  /* Pixel 200 */
		{ 0x0000, 0xa1a1, 0xa1a1 },  /* Pixel 201 */
		{ 0x0000, 0xa1a1, 0x5151 },  /* Pixel 202 */
		{ 0x0000, 0xa1a1, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3939, 0xe4e4 },  /* Pixel 205 */
		{ 0x0000, 0x4242, 0xc6c6 },  /* Pixel 206 */
		{ 0x0000, 0x5151, 0xa1a1 },  /* Pixel 207 */
		{ 0x0000, 0x7272, 0x7272 },  /* Pixel 208 */
		{ 0x0000, 0x7272, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xe4e4 },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0xc6c6 },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0xa1a1 },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x7272 },  /* Pixel 214 */
		{ 0xf6f6, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xeded, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xdada, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xd0d0, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0xbaba, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0xaeae, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0x9393, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x8484, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x5d5d, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x4242, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xf6f6, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xeded, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xdada, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xd0d0, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0xbaba, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0xaeae, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0x9393, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x8484, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x5d5d, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x4242, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xf6f6 },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xeded },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xdada },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xd0d0 },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0xbaba },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0xaeae },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0x9393 },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x8484 },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x5d5d },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x4242 },  /* Pixel 244 */
		{ 0xf6f6, 0xf6f6, 0xf6f6 },  /* Pixel 245 */
		{ 0xeded, 0xeded, 0xeded },  /* Pixel 246 */
		{ 0xdada, 0xdada, 0xdada },  /* Pixel 247 */
		{ 0xd0d0, 0xd0d0, 0xd0d0 },  /* Pixel 248 */
		{ 0xbaba, 0xbaba, 0xbaba },  /* Pixel 249 */
		{ 0xaeae, 0xaeae, 0xaeae },  /* Pixel 250 */
		{ 0x9393, 0x9393, 0x9393 },  /* Pixel 251 */
		{ 0x8484, 0x8484, 0x8484 },  /* Pixel 252 */
		{ 0x5d5d, 0x5d5d, 0x5d5d },  /* Pixel 253 */
		{ 0x4242, 0x4242, 0x4242 },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},

	/* Gamma level 5 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xe7e7, 0xe7e7, 0xe7e7 },  /* Pixel 43 */
		{ 0xe7e7, 0xe7e7, 0xadad },  /* Pixel 44 */
		{ 0xe7e7, 0xe7e7, 0x7474 },  /* Pixel 45 */
		{ 0xe7e7, 0xe7e7, 0x3a3a },  /* Pixel 46 */
		{ 0xe7e7, 0xe7e7, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xe7e7, 0xadad, 0xe7e7 },  /* Pixel 49 */
		{ 0xe7e7, 0xadad, 0xadad },  /* Pixel 50 */
		{ 0xe7e7, 0xadad, 0x7474 },  /* Pixel 51 */
		{ 0xe7e7, 0xadad, 0x3a3a },  /* Pixel 52 */
		{ 0xe7e7, 0xadad, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xe7e7, 0x7474, 0xe7e7 },  /* Pixel 55 */
		{ 0xe7e7, 0x7474, 0xadad },  /* Pixel 56 */
		{ 0xe7e7, 0x7474, 0x7474 },  /* Pixel 57 */
		{ 0xe7e7, 0x7474, 0x3a3a },  /* Pixel 58 */
		{ 0xe7e7, 0x7474, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xe7e7, 0x3a3a, 0xe7e7 },  /* Pixel 61 */
		{ 0xe7e7, 0x3a3a, 0xadad },  /* Pixel 62 */
		{ 0xe7e7, 0x3a3a, 0x7373 },  /* Pixel 63 */
		{ 0xe7e7, 0x3a3a, 0x3a3a },  /* Pixel 64 */
		{ 0xe7e7, 0x3a3a, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xe7e7, 0x0000, 0xe7e7 },  /* Pixel 67 */
		{ 0xe7e7, 0x0000, 0xadad },  /* Pixel 68 */
		{ 0xe7e7, 0x0000, 0x7474 },  /* Pixel 69 */
		{ 0xe7e7, 0x0000, 0x3a3a },  /* Pixel 70 */
		{ 0xe7e7, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0xadad, 0xe7e7, 0xe7e7 },  /* Pixel 79 */
		{ 0xadad, 0xe7e7, 0xadad },  /* Pixel 80 */
		{ 0xadad, 0xe7e7, 0x7474 },  /* Pixel 81 */
		{ 0xadad, 0xe7e7, 0x3a3a },  /* Pixel 82 */
		{ 0xadad, 0xe7e7, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0xadad, 0xadad, 0xe7e7 },  /* Pixel 85 */
		{ 0xcbcb, 0xcbcb, 0xcbcb },  /* Pixel 86 */
		{ 0xcbcb, 0xcbcb, 0x8787 },  /* Pixel 87 */
		{ 0xcbcb, 0xcbcb, 0x4444 },  /* Pixel 88 */
		{ 0xcbcb, 0xcbcb, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0xadad, 0x7474, 0xe7e7 },  /* Pixel 91 */
		{ 0xcbcb, 0x8787, 0xcbcb },  /* Pixel 92 */
		{ 0xcbcb, 0x8787, 0x8787 },  /* Pixel 93 */
		{ 0xcbcb, 0x8787, 0x4444 },  /* Pixel 94 */
		{ 0xcbcb, 0x8787, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0xadad, 0x3a3a, 0xe7e7 },  /* Pixel 97 */
		{ 0xcbcb, 0x4444, 0xcbcb },  /* Pixel 98 */
		{ 0xcbcb, 0x4444, 0x8787 },  /* Pixel 99 */
		{ 0xcbcb, 0x4444, 0x4444 },  /* Pixel 100 */
		{ 0xcbcb, 0x4444, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0xadad, 0x0000, 0xe7e7 },  /* Pixel 103 */
		{ 0xcbcb, 0x0000, 0xcbcb },  /* Pixel 104 */
		{ 0xcbcb, 0x0000, 0x8787 },  /* Pixel 105 */
		{ 0xcbcb, 0x0000, 0x4444 },  /* Pixel 106 */
		{ 0xcbcb, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x7474, 0xe7e7, 0xe7e7 },  /* Pixel 115 */
		{ 0x7474, 0xe7e7, 0xadad },  /* Pixel 116 */
		{ 0x7474, 0xe7e7, 0x7474 },  /* Pixel 117 */
		{ 0x7373, 0xe7e7, 0x3a3a },  /* Pixel 118 */
		{ 0x7474, 0xe7e7, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x7474, 0xadad, 0xe7e7 },  /* Pixel 121 */
		{ 0x8787, 0xcbcb, 0xcbcb },  /* Pixel 122 */
		{ 0x8787, 0xcbcb, 0x8787 },  /* Pixel 123 */
		{ 0x8787, 0xcbcb, 0x4444 },  /* Pixel 124 */
		{ 0x8787, 0xcbcb, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x7474, 0x7474, 0xe7e7 },  /* Pixel 127 */
		{ 0x8787, 0x8787, 0xcbcb },  /* Pixel 128 */
		{ 0xaaaa, 0xaaaa, 0xaaaa },  /* Pixel 129 */
		{ 0xaaaa, 0xaaaa, 0x5555 },  /* Pixel 130 */
		{ 0xaaaa, 0xaaaa, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x7373, 0x3a3a, 0xe7e7 },  /* Pixel 133 */
		{ 0x8787, 0x4444, 0xcbcb },  /* Pixel 134 */
		{ 0xaaaa, 0x5555, 0xaaaa },  /* Pixel 135 */
		{ 0xaaaa, 0x5555, 0x5555 },  /* Pixel 136 */
		{ 0xaaaa, 0x5555, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x7474, 0x0000, 0xe7e7 },  /* Pixel 139 */
		{ 0x8787, 0x0000, 0xcbcb },  /* Pixel 140 */
		{ 0xaaaa, 0x0000, 0xaaaa },  /* Pixel 141 */
		{ 0xaaaa, 0x0000, 0x5555 },  /* Pixel 142 */
		{ 0xaaaa, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3a3a, 0xe7e7, 0xe7e7 },  /* Pixel 151 */
		{ 0x3a3a, 0xe7e7, 0xadad },  /* Pixel 152 */
		{ 0x3a3a, 0xe7e7, 0x7474 },  /* Pixel 153 */
		{ 0x3a3a, 0xe7e7, 0x3a3a },  /* Pixel 154 */
		{ 0x3a3a, 0xe7e7, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3a3a, 0xadad, 0xe7e7 },  /* Pixel 157 */
		{ 0x4444, 0xcbcb, 0xcbcb },  /* Pixel 158 */
		{ 0x4444, 0xcbcb, 0x8787 },  /* Pixel 159 */
		{ 0x4444, 0xcbcb, 0x4444 },  /* Pixel 160 */
		{ 0x4444, 0xcbcb, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3a3a, 0x7474, 0xe7e7 },  /* Pixel 163 */
		{ 0x4444, 0x8787, 0xcbcb },  /* Pixel 164 */
		{ 0x5555, 0xaaaa, 0xaaaa },  /* Pixel 165 */
		{ 0x5555, 0xaaaa, 0x5555 },  /* Pixel 166 */
		{ 0x5555, 0xaaaa, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3a3a, 0x3a3a, 0xe7e7 },  /* Pixel 169 */
		{ 0x4444, 0x4444, 0xcbcb },  /* Pixel 170 */
		{ 0x5555, 0x5555, 0xaaaa },  /* Pixel 171 */
		{ 0x7d7d, 0x7d7d, 0x7d7d },  /* Pixel 172 */
		{ 0x7d7d, 0x7d7d, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3a3a, 0x0000, 0xe7e7 },  /* Pixel 175 */
		{ 0x4444, 0x0000, 0xcbcb },  /* Pixel 176 */
		{ 0x5555, 0x0000, 0xaaaa },  /* Pixel 177 */
		{ 0x7d7d, 0x0000, 0x7d7d },  /* Pixel 178 */
		{ 0x7d7d, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xe7e7, 0xe7e7 },  /* Pixel 187 */
		{ 0x0000, 0xe7e7, 0xadad },  /* Pixel 188 */
		{ 0x0000, 0xe7e7, 0x7474 },  /* Pixel 189 */
		{ 0x0000, 0xe7e7, 0x3a3a },  /* Pixel 190 */
		{ 0x0000, 0xe7e7, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0xadad, 0xe7e7 },  /* Pixel 193 */
		{ 0x0000, 0xcbcb, 0xcbcb },  /* Pixel 194 */
		{ 0x0000, 0xcbcb, 0x8787 },  /* Pixel 195 */
		{ 0x0000, 0xcbcb, 0x4444 },  /* Pixel 196 */
		{ 0x0000, 0xcbcb, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x7474, 0xe7e7 },  /* Pixel 199 */
		{ 0x0000, 0x8787, 0xcbcb },  /* Pixel 200 */
		{ 0x0000, 0xaaaa, 0xaaaa },  /* Pixel 201 */
		{ 0x0000, 0xaaaa, 0x5555 },  /* Pixel 202 */
		{ 0x0000, 0xaaaa, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3a3a, 0xe7e7 },  /* Pixel 205 */
		{ 0x0000, 0x4444, 0xcbcb },  /* Pixel 206 */
		{ 0x0000, 0x5555, 0xaaaa },  /* Pixel 207 */
		{ 0x0000, 0x7d7d, 0x7d7d },  /* Pixel 208 */
		{ 0x0000, 0x7d7d, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xe7e7 },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0xcbcb },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0xaaaa },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x7d7d },  /* Pixel 214 */
		{ 0xf7f7, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xefef, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xdede, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xd5d5, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0xc1c1, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0xb6b6, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0x9c9c, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x8e8e, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x6868, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x4d4d, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xf7f7, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xefef, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xdede, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xd5d5, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0xc1c1, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0xb6b6, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0x9c9c, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x8e8e, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x6868, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x4d4d, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xf7f7 },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xefef },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xdede },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xd5d5 },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0xc1c1 },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0xb6b6 },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0x9c9c },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x8e8e },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x6868 },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x4d4d },  /* Pixel 244 */
		{ 0xf7f7, 0xf7f7, 0xf7f7 },  /* Pixel 245 */
		{ 0xefef, 0xefef, 0xefef },  /* Pixel 246 */
		{ 0xdede, 0xdede, 0xdede },  /* Pixel 247 */
		{ 0xd5d5, 0xd5d5, 0xd5d5 },  /* Pixel 248 */
		{ 0xc1c1, 0xc1c1, 0xc1c1 },  /* Pixel 249 */
		{ 0xb6b6, 0xb6b6, 0xb6b6 },  /* Pixel 250 */
		{ 0x9c9c, 0x9c9c, 0x9c9c },  /* Pixel 251 */
		{ 0x8e8e, 0x8e8e, 0x8e8e },  /* Pixel 252 */
		{ 0x6868, 0x6868, 0x6868 },  /* Pixel 253 */
		{ 0x4d4d, 0x4d4d, 0x4d4d },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},

	/* Gamma level 6 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xe9e9, 0xe9e9, 0xe9e9 },  /* Pixel 43 */
		{ 0xe9e9, 0xe9e9, 0xafaf },  /* Pixel 44 */
		{ 0xe9e9, 0xe9e9, 0x7575 },  /* Pixel 45 */
		{ 0xe9e9, 0xe9e9, 0x3a3a },  /* Pixel 46 */
		{ 0xe9e9, 0xe9e9, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xe9e9, 0xafaf, 0xe9e9 },  /* Pixel 49 */
		{ 0xe9e9, 0xafaf, 0xafaf },  /* Pixel 50 */
		{ 0xe9e9, 0xafaf, 0x7575 },  /* Pixel 51 */
		{ 0xe9e9, 0xafaf, 0x3a3a },  /* Pixel 52 */
		{ 0xe9e9, 0xafaf, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xe9e9, 0x7575, 0xe9e9 },  /* Pixel 55 */
		{ 0xe9e9, 0x7575, 0xafaf },  /* Pixel 56 */
		{ 0xe9e9, 0x7575, 0x7575 },  /* Pixel 57 */
		{ 0xe9e9, 0x7575, 0x3a3a },  /* Pixel 58 */
		{ 0xe9e9, 0x7575, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xe9e9, 0x3a3a, 0xe9e9 },  /* Pixel 61 */
		{ 0xe9e9, 0x3a3a, 0xafaf },  /* Pixel 62 */
		{ 0xe9e9, 0x3a3a, 0x7474 },  /* Pixel 63 */
		{ 0xe9e9, 0x3a3a, 0x3a3a },  /* Pixel 64 */
		{ 0xe9e9, 0x3a3a, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xe9e9, 0x0000, 0xe9e9 },  /* Pixel 67 */
		{ 0xe9e9, 0x0000, 0xafaf },  /* Pixel 68 */
		{ 0xe9e9, 0x0000, 0x7575 },  /* Pixel 69 */
		{ 0xe9e9, 0x0000, 0x3a3a },  /* Pixel 70 */
		{ 0xe9e9, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0xafaf, 0xe9e9, 0xe9e9 },  /* Pixel 79 */
		{ 0xafaf, 0xe9e9, 0xafaf },  /* Pixel 80 */
		{ 0xafaf, 0xe9e9, 0x7575 },  /* Pixel 81 */
		{ 0xafaf, 0xe9e9, 0x3a3a },  /* Pixel 82 */
		{ 0xafaf, 0xe9e9, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0xafaf, 0xafaf, 0xe9e9 },  /* Pixel 85 */
		{ 0xd0d0, 0xd0d0, 0xd0d0 },  /* Pixel 86 */
		{ 0xd0d0, 0xd0d0, 0x8b8b },  /* Pixel 87 */
		{ 0xd0d0, 0xd0d0, 0x4545 },  /* Pixel 88 */
		{ 0xd0d0, 0xd0d0, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0xafaf, 0x7575, 0xe9e9 },  /* Pixel 91 */
		{ 0xd0d0, 0x8b8b, 0xd0d0 },  /* Pixel 92 */
		{ 0xd0d0, 0x8b8b, 0x8b8b },  /* Pixel 93 */
		{ 0xd0d0, 0x8b8b, 0x4545 },  /* Pixel 94 */
		{ 0xd0d0, 0x8b8b, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0xafaf, 0x3a3a, 0xe9e9 },  /* Pixel 97 */
		{ 0xd0d0, 0x4545, 0xd0d0 },  /* Pixel 98 */
		{ 0xd0d0, 0x4545, 0x8b8b },  /* Pixel 99 */
		{ 0xd0d0, 0x4545, 0x4545 },  /* Pixel 100 */
		{ 0xd0d0, 0x4545, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0xafaf, 0x0000, 0xe9e9 },  /* Pixel 103 */
		{ 0xd0d0, 0x0000, 0xd0d0 },  /* Pixel 104 */
		{ 0xd0d0, 0x0000, 0x8b8b },  /* Pixel 105 */
		{ 0xd0d0, 0x0000, 0x4545 },  /* Pixel 106 */
		{ 0xd0d0, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x7575, 0xe9e9, 0xe9e9 },  /* Pixel 115 */
		{ 0x7575, 0xe9e9, 0xafaf },  /* Pixel 116 */
		{ 0x7575, 0xe9e9, 0x7575 },  /* Pixel 117 */
		{ 0x7474, 0xe9e9, 0x3a3a },  /* Pixel 118 */
		{ 0x7575, 0xe9e9, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x7575, 0xafaf, 0xe9e9 },  /* Pixel 121 */
		{ 0x8b8b, 0xd0d0, 0xd0d0 },  /* Pixel 122 */
		{ 0x8b8b, 0xd0d0, 0x8b8b },  /* Pixel 123 */
		{ 0x8b8b, 0xd0d0, 0x4545 },  /* Pixel 124 */
		{ 0x8b8b, 0xd0d0, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x7575, 0x7575, 0xe9e9 },  /* Pixel 127 */
		{ 0x8b8b, 0x8b8b, 0xd0d0 },  /* Pixel 128 */
		{ 0xb1b1, 0xb1b1, 0xb1b1 },  /* Pixel 129 */
		{ 0xb1b1, 0xb1b1, 0x5959 },  /* Pixel 130 */
		{ 0xb1b1, 0xb1b1, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x7474, 0x3a3a, 0xe9e9 },  /* Pixel 133 */
		{ 0x8b8b, 0x4545, 0xd0d0 },  /* Pixel 134 */
		{ 0xb1b1, 0x5959, 0xb1b1 },  /* Pixel 135 */
		{ 0xb1b1, 0x5959, 0x5959 },  /* Pixel 136 */
		{ 0xb1b1, 0x5959, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x7575, 0x0000, 0xe9e9 },  /* Pixel 139 */
		{ 0x8b8b, 0x0000, 0xd0d0 },  /* Pixel 140 */
		{ 0xb1b1, 0x0000, 0xb1b1 },  /* Pixel 141 */
		{ 0xb1b1, 0x0000, 0x5959 },  /* Pixel 142 */
		{ 0xb1b1, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3a3a, 0xe9e9, 0xe9e9 },  /* Pixel 151 */
		{ 0x3a3a, 0xe9e9, 0xafaf },  /* Pixel 152 */
		{ 0x3a3a, 0xe9e9, 0x7575 },  /* Pixel 153 */
		{ 0x3a3a, 0xe9e9, 0x3a3a },  /* Pixel 154 */
		{ 0x3a3a, 0xe9e9, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3a3a, 0xafaf, 0xe9e9 },  /* Pixel 157 */
		{ 0x4545, 0xd0d0, 0xd0d0 },  /* Pixel 158 */
		{ 0x4545, 0xd0d0, 0x8b8b },  /* Pixel 159 */
		{ 0x4545, 0xd0d0, 0x4545 },  /* Pixel 160 */
		{ 0x4545, 0xd0d0, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3a3a, 0x7575, 0xe9e9 },  /* Pixel 163 */
		{ 0x4545, 0x8b8b, 0xd0d0 },  /* Pixel 164 */
		{ 0x5959, 0xb1b1, 0xb1b1 },  /* Pixel 165 */
		{ 0x5959, 0xb1b1, 0x5959 },  /* Pixel 166 */
		{ 0x5959, 0xb1b1, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3a3a, 0x3a3a, 0xe9e9 },  /* Pixel 169 */
		{ 0x4545, 0x4545, 0xd0d0 },  /* Pixel 170 */
		{ 0x5959, 0x5959, 0xb1b1 },  /* Pixel 171 */
		{ 0x8686, 0x8686, 0x8686 },  /* Pixel 172 */
		{ 0x8686, 0x8686, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3a3a, 0x0000, 0xe9e9 },  /* Pixel 175 */
		{ 0x4545, 0x0000, 0xd0d0 },  /* Pixel 176 */
		{ 0x5959, 0x0000, 0xb1b1 },  /* Pixel 177 */
		{ 0x8686, 0x0000, 0x8686 },  /* Pixel 178 */
		{ 0x8686, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xe9e9, 0xe9e9 },  /* Pixel 187 */
		{ 0x0000, 0xe9e9, 0xafaf },  /* Pixel 188 */
		{ 0x0000, 0xe9e9, 0x7575 },  /* Pixel 189 */
		{ 0x0000, 0xe9e9, 0x3a3a },  /* Pixel 190 */
		{ 0x0000, 0xe9e9, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0xafaf, 0xe9e9 },  /* Pixel 193 */
		{ 0x0000, 0xd0d0, 0xd0d0 },  /* Pixel 194 */
		{ 0x0000, 0xd0d0, 0x8b8b },  /* Pixel 195 */
		{ 0x0000, 0xd0d0, 0x4545 },  /* Pixel 196 */
		{ 0x0000, 0xd0d0, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x7575, 0xe9e9 },  /* Pixel 199 */
		{ 0x0000, 0x8b8b, 0xd0d0 },  /* Pixel 200 */
		{ 0x0000, 0xb1b1, 0xb1b1 },  /* Pixel 201 */
		{ 0x0000, 0xb1b1, 0x5959 },  /* Pixel 202 */
		{ 0x0000, 0xb1b1, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3a3a, 0xe9e9 },  /* Pixel 205 */
		{ 0x0000, 0x4545, 0xd0d0 },  /* Pixel 206 */
		{ 0x0000, 0x5959, 0xb1b1 },  /* Pixel 207 */
		{ 0x0000, 0x8686, 0x8686 },  /* Pixel 208 */
		{ 0x0000, 0x8686, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xe9e9 },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0xd0d0 },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0xb1b1 },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x8686 },  /* Pixel 214 */
		{ 0xf8f8, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xf1f1, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xe1e1, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xd9d9, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0xc6c6, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0xbcbc, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0xa4a4, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x9696, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x7272, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x5656, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xf8f8, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xf1f1, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xe1e1, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xd9d9, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0xc6c6, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0xbcbc, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0xa4a4, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x9696, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x7272, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x5656, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xf8f8 },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xf1f1 },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xe1e1 },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xd9d9 },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0xc6c6 },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0xbcbc },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0xa4a4 },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x9696 },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x7272 },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x5656 },  /* Pixel 244 */
		{ 0xf8f8, 0xf8f8, 0xf8f8 },  /* Pixel 245 */
		{ 0xf1f1, 0xf1f1, 0xf1f1 },  /* Pixel 246 */
		{ 0xe1e1, 0xe1e1, 0xe1e1 },  /* Pixel 247 */
		{ 0xd9d9, 0xd9d9, 0xd9d9 },  /* Pixel 248 */
		{ 0xc6c6, 0xc6c6, 0xc6c6 },  /* Pixel 249 */
		{ 0xbcbc, 0xbcbc, 0xbcbc },  /* Pixel 250 */
		{ 0xa4a4, 0xa4a4, 0xa4a4 },  /* Pixel 251 */
		{ 0x9696, 0x9696, 0x9696 },  /* Pixel 252 */
		{ 0x7272, 0x7272, 0x7272 },  /* Pixel 253 */
		{ 0x5656, 0x5656, 0x5656 },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},

	/* Gamma level 7 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xebeb, 0xebeb, 0xebeb },  /* Pixel 43 */
		{ 0xebeb, 0xebeb, 0xb0b0 },  /* Pixel 44 */
		{ 0xebeb, 0xebeb, 0x7676 },  /* Pixel 45 */
		{ 0xebeb, 0xebeb, 0x3b3b },  /* Pixel 46 */
		{ 0xebeb, 0xebeb, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xebeb, 0xb0b0, 0xebeb },  /* Pixel 49 */
		{ 0xebeb, 0xb0b0, 0xb0b0 },  /* Pixel 50 */
		{ 0xebeb, 0xb0b0, 0x7676 },  /* Pixel 51 */
		{ 0xebeb, 0xb0b0, 0x3b3b },  /* Pixel 52 */
		{ 0xebeb, 0xb0b0, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xebeb, 0x7676, 0xebeb },  /* Pixel 55 */
		{ 0xebeb, 0x7676, 0xb0b0 },  /* Pixel 56 */
		{ 0xebeb, 0x7676, 0x7676 },  /* Pixel 57 */
		{ 0xebeb, 0x7676, 0x3b3b },  /* Pixel 58 */
		{ 0xebeb, 0x7676, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xebeb, 0x3b3b, 0xebeb },  /* Pixel 61 */
		{ 0xebeb, 0x3b3b, 0xb0b0 },  /* Pixel 62 */
		{ 0xebeb, 0x3b3b, 0x7575 },  /* Pixel 63 */
		{ 0xebeb, 0x3b3b, 0x3b3b },  /* Pixel 64 */
		{ 0xebeb, 0x3b3b, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xebeb, 0x0000, 0xebeb },  /* Pixel 67 */
		{ 0xebeb, 0x0000, 0xb0b0 },  /* Pixel 68 */
		{ 0xebeb, 0x0000, 0x7676 },  /* Pixel 69 */
		{ 0xebeb, 0x0000, 0x3b3b },  /* Pixel 70 */
		{ 0xebeb, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0xb0b0, 0xebeb, 0xebeb },  /* Pixel 79 */
		{ 0xb0b0, 0xebeb, 0xb0b0 },  /* Pixel 80 */
		{ 0xb0b0, 0xebeb, 0x7676 },  /* Pixel 81 */
		{ 0xb0b0, 0xebeb, 0x3b3b },  /* Pixel 82 */
		{ 0xb0b0, 0xebeb, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0xb0b0, 0xb0b0, 0xebeb },  /* Pixel 85 */
		{ 0xd4d4, 0xd4d4, 0xd4d4 },  /* Pixel 86 */
		{ 0xd4d4, 0xd4d4, 0x8d8d },  /* Pixel 87 */
		{ 0xd4d4, 0xd4d4, 0x4747 },  /* Pixel 88 */
		{ 0xd4d4, 0xd4d4, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0xb0b0, 0x7676, 0xebeb },  /* Pixel 91 */
		{ 0xd4d4, 0x8d8d, 0xd4d4 },  /* Pixel 92 */
		{ 0xd4d4, 0x8d8d, 0x8d8d },  /* Pixel 93 */
		{ 0xd4d4, 0x8d8d, 0x4747 },  /* Pixel 94 */
		{ 0xd4d4, 0x8d8d, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0xb0b0, 0x3b3b, 0xebeb },  /* Pixel 97 */
		{ 0xd4d4, 0x4747, 0xd4d4 },  /* Pixel 98 */
		{ 0xd4d4, 0x4747, 0x8d8d },  /* Pixel 99 */
		{ 0xd4d4, 0x4747, 0x4747 },  /* Pixel 100 */
		{ 0xd4d4, 0x4747, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0xb0b0, 0x0000, 0xebeb },  /* Pixel 103 */
		{ 0xd4d4, 0x0000, 0xd4d4 },  /* Pixel 104 */
		{ 0xd4d4, 0x0000, 0x8d8d },  /* Pixel 105 */
		{ 0xd4d4, 0x0000, 0x4747 },  /* Pixel 106 */
		{ 0xd4d4, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x7676, 0xebeb, 0xebeb },  /* Pixel 115 */
		{ 0x7676, 0xebeb, 0xb0b0 },  /* Pixel 116 */
		{ 0x7676, 0xebeb, 0x7676 },  /* Pixel 117 */
		{ 0x7575, 0xebeb, 0x3b3b },  /* Pixel 118 */
		{ 0x7676, 0xebeb, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x7676, 0xb0b0, 0xebeb },  /* Pixel 121 */
		{ 0x8d8d, 0xd4d4, 0xd4d4 },  /* Pixel 122 */
		{ 0x8d8d, 0xd4d4, 0x8d8d },  /* Pixel 123 */
		{ 0x8d8d, 0xd4d4, 0x4747 },  /* Pixel 124 */
		{ 0x8d8d, 0xd4d4, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x7676, 0x7676, 0xebeb },  /* Pixel 127 */
		{ 0x8d8d, 0x8d8d, 0xd4d4 },  /* Pixel 128 */
		{ 0xb7b7, 0xb7b7, 0xb7b7 },  /* Pixel 129 */
		{ 0xb7b7, 0xb7b7, 0x5c5c },  /* Pixel 130 */
		{ 0xb7b7, 0xb7b7, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x7575, 0x3b3b, 0xebeb },  /* Pixel 133 */
		{ 0x8d8d, 0x4747, 0xd4d4 },  /* Pixel 134 */
		{ 0xb7b7, 0x5c5c, 0xb7b7 },  /* Pixel 135 */
		{ 0xb7b7, 0x5c5c, 0x5c5c },  /* Pixel 136 */
		{ 0xb7b7, 0x5c5c, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x7676, 0x0000, 0xebeb },  /* Pixel 139 */
		{ 0x8d8d, 0x0000, 0xd4d4 },  /* Pixel 140 */
		{ 0xb7b7, 0x0000, 0xb7b7 },  /* Pixel 141 */
		{ 0xb7b7, 0x0000, 0x5c5c },  /* Pixel 142 */
		{ 0xb7b7, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3b3b, 0xebeb, 0xebeb },  /* Pixel 151 */
		{ 0x3b3b, 0xebeb, 0xb0b0 },  /* Pixel 152 */
		{ 0x3b3b, 0xebeb, 0x7676 },  /* Pixel 153 */
		{ 0x3b3b, 0xebeb, 0x3b3b },  /* Pixel 154 */
		{ 0x3b3b, 0xebeb, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3b3b, 0xb0b0, 0xebeb },  /* Pixel 157 */
		{ 0x4747, 0xd4d4, 0xd4d4 },  /* Pixel 158 */
		{ 0x4747, 0xd4d4, 0x8d8d },  /* Pixel 159 */
		{ 0x4747, 0xd4d4, 0x4747 },  /* Pixel 160 */
		{ 0x4747, 0xd4d4, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3b3b, 0x7676, 0xebeb },  /* Pixel 163 */
		{ 0x4747, 0x8d8d, 0xd4d4 },  /* Pixel 164 */
		{ 0x5c5c, 0xb7b7, 0xb7b7 },  /* Pixel 165 */
		{ 0x5c5c, 0xb7b7, 0x5c5c },  /* Pixel 166 */
		{ 0x5c5c, 0xb7b7, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3b3b, 0x3b3b, 0xebeb },  /* Pixel 169 */
		{ 0x4747, 0x4747, 0xd4d4 },  /* Pixel 170 */
		{ 0x5c5c, 0x5c5c, 0xb7b7 },  /* Pixel 171 */
		{ 0x8e8e, 0x8e8e, 0x8e8e },  /* Pixel 172 */
		{ 0x8e8e, 0x8e8e, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3b3b, 0x0000, 0xebeb },  /* Pixel 175 */
		{ 0x4747, 0x0000, 0xd4d4 },  /* Pixel 176 */
		{ 0x5c5c, 0x0000, 0xb7b7 },  /* Pixel 177 */
		{ 0x8e8e, 0x0000, 0x8e8e },  /* Pixel 178 */
		{ 0x8e8e, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xebeb, 0xebeb },  /* Pixel 187 */
		{ 0x0000, 0xebeb, 0xb0b0 },  /* Pixel 188 */
		{ 0x0000, 0xebeb, 0x7676 },  /* Pixel 189 */
		{ 0x0000, 0xebeb, 0x3b3b },  /* Pixel 190 */
		{ 0x0000, 0xebeb, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0xb0b0, 0xebeb },  /* Pixel 193 */
		{ 0x0000, 0xd4d4, 0xd4d4 },  /* Pixel 194 */
		{ 0x0000, 0xd4d4, 0x8d8d },  /* Pixel 195 */
		{ 0x0000, 0xd4d4, 0x4747 },  /* Pixel 196 */
		{ 0x0000, 0xd4d4, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x7676, 0xebeb },  /* Pixel 199 */
		{ 0x0000, 0x8d8d, 0xd4d4 },  /* Pixel 200 */
		{ 0x0000, 0xb7b7, 0xb7b7 },  /* Pixel 201 */
		{ 0x0000, 0xb7b7, 0x5c5c },  /* Pixel 202 */
		{ 0x0000, 0xb7b7, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3b3b, 0xebeb },  /* Pixel 205 */
		{ 0x0000, 0x4747, 0xd4d4 },  /* Pixel 206 */
		{ 0x0000, 0x5c5c, 0xb7b7 },  /* Pixel 207 */
		{ 0x0000, 0x8e8e, 0x8e8e },  /* Pixel 208 */
		{ 0x0000, 0x8e8e, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xebeb },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0xd4d4 },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0xb7b7 },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x8e8e },  /* Pixel 214 */
		{ 0xf9f9, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xf2f2, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xe4e4, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xdcdc, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0xcbcb, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0xc1c1, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0xabab, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0x9e9e, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x7b7b, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x5f5f, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xf9f9, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xf2f2, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xe4e4, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xdcdc, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0xcbcb, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0xc1c1, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0xabab, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0x9e9e, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x7b7b, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x5f5f, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xf9f9 },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xf2f2 },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xe4e4 },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xdcdc },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0xcbcb },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0xc1c1 },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0xabab },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0x9e9e },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x7b7b },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x5f5f },  /* Pixel 244 */
		{ 0xf9f9, 0xf9f9, 0xf9f9 },  /* Pixel 245 */
		{ 0xf2f2, 0xf2f2, 0xf2f2 },  /* Pixel 246 */
		{ 0xe4e4, 0xe4e4, 0xe4e4 },  /* Pixel 247 */
		{ 0xdcdc, 0xdcdc, 0xdcdc },  /* Pixel 248 */
		{ 0xcbcb, 0xcbcb, 0xcbcb },  /* Pixel 249 */
		{ 0xc1c1, 0xc1c1, 0xc1c1 },  /* Pixel 250 */
		{ 0xabab, 0xabab, 0xabab },  /* Pixel 251 */
		{ 0x9e9e, 0x9e9e, 0x9e9e },  /* Pixel 252 */
		{ 0x7b7b, 0x7b7b, 0x7b7b },  /* Pixel 253 */
		{ 0x5f5f, 0x5f5f, 0x5f5f },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},

	/* Gamma level 8 */
	{
		{ 0xffff, 0xffff, 0xffff },  /* Pixel 0 */
		{ 0xffff, 0xffff, 0xcccc },  /* Pixel 1 */
		{ 0xffff, 0xffff, 0x9999 },  /* Pixel 2 */
		{ 0xffff, 0xffff, 0x6666 },  /* Pixel 3 */
		{ 0xffff, 0xffff, 0x3333 },  /* Pixel 4 */
		{ 0xffff, 0xffff, 0x0000 },  /* Pixel 5 */
		{ 0xffff, 0xcccc, 0xffff },  /* Pixel 6 */
		{ 0xffff, 0xcccc, 0xcccc },  /* Pixel 7 */
		{ 0xffff, 0xcccc, 0x9999 },  /* Pixel 8 */
		{ 0xffff, 0xcccc, 0x6666 },  /* Pixel 9 */
		{ 0xffff, 0xcccc, 0x3333 },  /* Pixel 10 */
		{ 0xffff, 0xcccc, 0x0000 },  /* Pixel 11 */
		{ 0xffff, 0x9999, 0xffff },  /* Pixel 12 */
		{ 0xffff, 0x9999, 0xcccc },  /* Pixel 13 */
		{ 0xffff, 0x9999, 0x9999 },  /* Pixel 14 */
		{ 0xffff, 0x9999, 0x6666 },  /* Pixel 15 */
		{ 0xffff, 0x9999, 0x3333 },  /* Pixel 16 */
		{ 0xffff, 0x9999, 0x0000 },  /* Pixel 17 */
		{ 0xffff, 0x6666, 0xffff },  /* Pixel 18 */
		{ 0xffff, 0x6666, 0xcccc },  /* Pixel 19 */
		{ 0xffff, 0x6666, 0x9999 },  /* Pixel 20 */
		{ 0xffff, 0x6666, 0x6666 },  /* Pixel 21 */
		{ 0xffff, 0x6666, 0x3333 },  /* Pixel 22 */
		{ 0xffff, 0x6666, 0x0000 },  /* Pixel 23 */
		{ 0xffff, 0x3333, 0xffff },  /* Pixel 24 */
		{ 0xffff, 0x3333, 0xcccc },  /* Pixel 25 */
		{ 0xffff, 0x3333, 0x9999 },  /* Pixel 26 */
		{ 0xffff, 0x3333, 0x6666 },  /* Pixel 27 */
		{ 0xffff, 0x3333, 0x3333 },  /* Pixel 28 */
		{ 0xffff, 0x3333, 0x0000 },  /* Pixel 29 */
		{ 0xffff, 0x0000, 0xffff },  /* Pixel 30 */
		{ 0xffff, 0x0000, 0xcccc },  /* Pixel 31 */
		{ 0xffff, 0x0000, 0x9999 },  /* Pixel 32 */
		{ 0xffff, 0x0000, 0x6666 },  /* Pixel 33 */
		{ 0xffff, 0x0000, 0x3333 },  /* Pixel 34 */
		{ 0xffff, 0x0000, 0x0000 },  /* Pixel 35 */
		{ 0xcccc, 0xffff, 0xffff },  /* Pixel 36 */
		{ 0xcccc, 0xffff, 0xcccc },  /* Pixel 37 */
		{ 0xcccc, 0xffff, 0x9999 },  /* Pixel 38 */
		{ 0xcccc, 0xffff, 0x6666 },  /* Pixel 39 */
		{ 0xcccc, 0xffff, 0x3333 },  /* Pixel 40 */
		{ 0xcccc, 0xffff, 0x0000 },  /* Pixel 41 */
		{ 0xcccc, 0xcccc, 0xffff },  /* Pixel 42 */
		{ 0xeded, 0xeded, 0xeded },  /* Pixel 43 */
		{ 0xeded, 0xeded, 0xb2b2 },  /* Pixel 44 */
		{ 0xeded, 0xeded, 0x7777 },  /* Pixel 45 */
		{ 0xeded, 0xeded, 0x3b3b },  /* Pixel 46 */
		{ 0xeded, 0xeded, 0x0000 },  /* Pixel 47 */
		{ 0xcccc, 0x9999, 0xffff },  /* Pixel 48 */
		{ 0xeded, 0xb2b2, 0xeded },  /* Pixel 49 */
		{ 0xeded, 0xb2b2, 0xb2b2 },  /* Pixel 50 */
		{ 0xeded, 0xb2b2, 0x7777 },  /* Pixel 51 */
		{ 0xeded, 0xb2b2, 0x3b3b },  /* Pixel 52 */
		{ 0xeded, 0xb2b2, 0x0000 },  /* Pixel 53 */
		{ 0xcccc, 0x6666, 0xffff },  /* Pixel 54 */
		{ 0xeded, 0x7777, 0xeded },  /* Pixel 55 */
		{ 0xeded, 0x7777, 0xb2b2 },  /* Pixel 56 */
		{ 0xeded, 0x7777, 0x7777 },  /* Pixel 57 */
		{ 0xeded, 0x7777, 0x3b3b },  /* Pixel 58 */
		{ 0xeded, 0x7777, 0x0000 },  /* Pixel 59 */
		{ 0xcccc, 0x3333, 0xffff },  /* Pixel 60 */
		{ 0xeded, 0x3b3b, 0xeded },  /* Pixel 61 */
		{ 0xeded, 0x3b3b, 0xb2b2 },  /* Pixel 62 */
		{ 0xeded, 0x3b3b, 0x7676 },  /* Pixel 63 */
		{ 0xeded, 0x3b3b, 0x3b3b },  /* Pixel 64 */
		{ 0xeded, 0x3b3b, 0x0000 },  /* Pixel 65 */
		{ 0xcccc, 0x0000, 0xffff },  /* Pixel 66 */
		{ 0xeded, 0x0000, 0xeded },  /* Pixel 67 */
		{ 0xeded, 0x0000, 0xb2b2 },  /* Pixel 68 */
		{ 0xeded, 0x0000, 0x7777 },  /* Pixel 69 */
		{ 0xeded, 0x0000, 0x3b3b },  /* Pixel 70 */
		{ 0xeded, 0x0000, 0x0000 },  /* Pixel 71 */
		{ 0x9999, 0xffff, 0xffff },  /* Pixel 72 */
		{ 0x9999, 0xffff, 0xcccc },  /* Pixel 73 */
		{ 0x9999, 0xffff, 0x9999 },  /* Pixel 74 */
		{ 0x9999, 0xffff, 0x6666 },  /* Pixel 75 */
		{ 0x9999, 0xffff, 0x3333 },  /* Pixel 76 */
		{ 0x9999, 0xffff, 0x0000 },  /* Pixel 77 */
		{ 0x9999, 0xcccc, 0xffff },  /* Pixel 78 */
		{ 0xb2b2, 0xeded, 0xeded },  /* Pixel 79 */
		{ 0xb2b2, 0xeded, 0xb2b2 },  /* Pixel 80 */
		{ 0xb2b2, 0xeded, 0x7777 },  /* Pixel 81 */
		{ 0xb2b2, 0xeded, 0x3b3b },  /* Pixel 82 */
		{ 0xb2b2, 0xeded, 0x0000 },  /* Pixel 83 */
		{ 0x9999, 0x9999, 0xffff },  /* Pixel 84 */
		{ 0xb2b2, 0xb2b2, 0xeded },  /* Pixel 85 */
		{ 0xd7d7, 0xd7d7, 0xd7d7 },  /* Pixel 86 */
		{ 0xd7d7, 0xd7d7, 0x8f8f },  /* Pixel 87 */
		{ 0xd7d7, 0xd7d7, 0x4848 },  /* Pixel 88 */
		{ 0xd7d7, 0xd7d7, 0x0000 },  /* Pixel 89 */
		{ 0x9999, 0x6666, 0xffff },  /* Pixel 90 */
		{ 0xb2b2, 0x7777, 0xeded },  /* Pixel 91 */
		{ 0xd7d7, 0x8f8f, 0xd7d7 },  /* Pixel 92 */
		{ 0xd7d7, 0x8f8f, 0x8f8f },  /* Pixel 93 */
		{ 0xd7d7, 0x8f8f, 0x4848 },  /* Pixel 94 */
		{ 0xd7d7, 0x8f8f, 0x0000 },  /* Pixel 95 */
		{ 0x9999, 0x3333, 0xffff },  /* Pixel 96 */
		{ 0xb2b2, 0x3b3b, 0xeded },  /* Pixel 97 */
		{ 0xd7d7, 0x4848, 0xd7d7 },  /* Pixel 98 */
		{ 0xd7d7, 0x4848, 0x8f8f },  /* Pixel 99 */
		{ 0xd7d7, 0x4848, 0x4848 },  /* Pixel 100 */
		{ 0xd7d7, 0x4848, 0x0000 },  /* Pixel 101 */
		{ 0x9999, 0x0000, 0xffff },  /* Pixel 102 */
		{ 0xb2b2, 0x0000, 0xeded },  /* Pixel 103 */
		{ 0xd7d7, 0x0000, 0xd7d7 },  /* Pixel 104 */
		{ 0xd7d7, 0x0000, 0x8f8f },  /* Pixel 105 */
		{ 0xd7d7, 0x0000, 0x4848 },  /* Pixel 106 */
		{ 0xd7d7, 0x0000, 0x0000 },  /* Pixel 107 */
		{ 0x6666, 0xffff, 0xffff },  /* Pixel 108 */
		{ 0x6666, 0xffff, 0xcccc },  /* Pixel 109 */
		{ 0x6666, 0xffff, 0x9999 },  /* Pixel 110 */
		{ 0x6666, 0xffff, 0x6666 },  /* Pixel 111 */
		{ 0x6666, 0xffff, 0x3333 },  /* Pixel 112 */
		{ 0x6666, 0xffff, 0x0000 },  /* Pixel 113 */
		{ 0x6666, 0xcccc, 0xffff },  /* Pixel 114 */
		{ 0x7777, 0xeded, 0xeded },  /* Pixel 115 */
		{ 0x7777, 0xeded, 0xb2b2 },  /* Pixel 116 */
		{ 0x7777, 0xeded, 0x7777 },  /* Pixel 117 */
		{ 0x7676, 0xeded, 0x3b3b },  /* Pixel 118 */
		{ 0x7777, 0xeded, 0x0000 },  /* Pixel 119 */
		{ 0x6666, 0x9999, 0xffff },  /* Pixel 120 */
		{ 0x7777, 0xb2b2, 0xeded },  /* Pixel 121 */
		{ 0x8f8f, 0xd7d7, 0xd7d7 },  /* Pixel 122 */
		{ 0x8f8f, 0xd7d7, 0x8f8f },  /* Pixel 123 */
		{ 0x8f8f, 0xd7d7, 0x4848 },  /* Pixel 124 */
		{ 0x8f8f, 0xd7d7, 0x0000 },  /* Pixel 125 */
		{ 0x6666, 0x6666, 0xffff },  /* Pixel 126 */
		{ 0x7777, 0x7777, 0xeded },  /* Pixel 127 */
		{ 0x8f8f, 0x8f8f, 0xd7d7 },  /* Pixel 128 */
		{ 0xbcbc, 0xbcbc, 0xbcbc },  /* Pixel 129 */
		{ 0xbcbc, 0xbcbc, 0x5e5e },  /* Pixel 130 */
		{ 0xbcbc, 0xbcbc, 0x0000 },  /* Pixel 131 */
		{ 0x6666, 0x3333, 0xffff },  /* Pixel 132 */
		{ 0x7676, 0x3b3b, 0xeded },  /* Pixel 133 */
		{ 0x8f8f, 0x4848, 0xd7d7 },  /* Pixel 134 */
		{ 0xbcbc, 0x5e5e, 0xbcbc },  /* Pixel 135 */
		{ 0xbcbc, 0x5e5e, 0x5e5e },  /* Pixel 136 */
		{ 0xbcbc, 0x5e5e, 0x0000 },  /* Pixel 137 */
		{ 0x6666, 0x0000, 0xffff },  /* Pixel 138 */
		{ 0x7777, 0x0000, 0xeded },  /* Pixel 139 */
		{ 0x8f8f, 0x0000, 0xd7d7 },  /* Pixel 140 */
		{ 0xbcbc, 0x0000, 0xbcbc },  /* Pixel 141 */
		{ 0xbcbc, 0x0000, 0x5e5e },  /* Pixel 142 */
		{ 0xbcbc, 0x0000, 0x0000 },  /* Pixel 143 */
		{ 0x3333, 0xffff, 0xffff },  /* Pixel 144 */
		{ 0x3333, 0xffff, 0xcccc },  /* Pixel 145 */
		{ 0x3333, 0xffff, 0x9999 },  /* Pixel 146 */
		{ 0x3333, 0xffff, 0x6666 },  /* Pixel 147 */
		{ 0x3333, 0xffff, 0x3333 },  /* Pixel 148 */
		{ 0x3333, 0xffff, 0x0000 },  /* Pixel 149 */
		{ 0x3333, 0xcccc, 0xffff },  /* Pixel 150 */
		{ 0x3b3b, 0xeded, 0xeded },  /* Pixel 151 */
		{ 0x3b3b, 0xeded, 0xb2b2 },  /* Pixel 152 */
		{ 0x3b3b, 0xeded, 0x7777 },  /* Pixel 153 */
		{ 0x3b3b, 0xeded, 0x3b3b },  /* Pixel 154 */
		{ 0x3b3b, 0xeded, 0x0000 },  /* Pixel 155 */
		{ 0x3333, 0x9999, 0xffff },  /* Pixel 156 */
		{ 0x3b3b, 0xb2b2, 0xeded },  /* Pixel 157 */
		{ 0x4848, 0xd7d7, 0xd7d7 },  /* Pixel 158 */
		{ 0x4848, 0xd7d7, 0x8f8f },  /* Pixel 159 */
		{ 0x4848, 0xd7d7, 0x4848 },  /* Pixel 160 */
		{ 0x4848, 0xd7d7, 0x0000 },  /* Pixel 161 */
		{ 0x3333, 0x6666, 0xffff },  /* Pixel 162 */
		{ 0x3b3b, 0x7777, 0xeded },  /* Pixel 163 */
		{ 0x4848, 0x8f8f, 0xd7d7 },  /* Pixel 164 */
		{ 0x5e5e, 0xbcbc, 0xbcbc },  /* Pixel 165 */
		{ 0x5e5e, 0xbcbc, 0x5e5e },  /* Pixel 166 */
		{ 0x5e5e, 0xbcbc, 0x0000 },  /* Pixel 167 */
		{ 0x3333, 0x3333, 0xffff },  /* Pixel 168 */
		{ 0x3b3b, 0x3b3b, 0xeded },  /* Pixel 169 */
		{ 0x4848, 0x4848, 0xd7d7 },  /* Pixel 170 */
		{ 0x5e5e, 0x5e5e, 0xbcbc },  /* Pixel 171 */
		{ 0x9595, 0x9595, 0x9595 },  /* Pixel 172 */
		{ 0x9595, 0x9595, 0x0000 },  /* Pixel 173 */
		{ 0x3333, 0x0000, 0xffff },  /* Pixel 174 */
		{ 0x3b3b, 0x0000, 0xeded },  /* Pixel 175 */
		{ 0x4848, 0x0000, 0xd7d7 },  /* Pixel 176 */
		{ 0x5e5e, 0x0000, 0xbcbc },  /* Pixel 177 */
		{ 0x9595, 0x0000, 0x9595 },  /* Pixel 178 */
		{ 0x9595, 0x0000, 0x0000 },  /* Pixel 179 */
		{ 0x0000, 0xffff, 0xffff },  /* Pixel 180 */
		{ 0x0000, 0xffff, 0xcccc },  /* Pixel 181 */
		{ 0x0000, 0xffff, 0x9999 },  /* Pixel 182 */
		{ 0x0000, 0xffff, 0x6666 },  /* Pixel 183 */
		{ 0x0000, 0xffff, 0x3333 },  /* Pixel 184 */
		{ 0x0000, 0xffff, 0x0000 },  /* Pixel 185 */
		{ 0x0000, 0xcccc, 0xffff },  /* Pixel 186 */
		{ 0x0000, 0xeded, 0xeded },  /* Pixel 187 */
		{ 0x0000, 0xeded, 0xb2b2 },  /* Pixel 188 */
		{ 0x0000, 0xeded, 0x7777 },  /* Pixel 189 */
		{ 0x0000, 0xeded, 0x3b3b },  /* Pixel 190 */
		{ 0x0000, 0xeded, 0x0000 },  /* Pixel 191 */
		{ 0x0000, 0x9999, 0xffff },  /* Pixel 192 */
		{ 0x0000, 0xb2b2, 0xeded },  /* Pixel 193 */
		{ 0x0000, 0xd7d7, 0xd7d7 },  /* Pixel 194 */
		{ 0x0000, 0xd7d7, 0x8f8f },  /* Pixel 195 */
		{ 0x0000, 0xd7d7, 0x4848 },  /* Pixel 196 */
		{ 0x0000, 0xd7d7, 0x0000 },  /* Pixel 197 */
		{ 0x0000, 0x6666, 0xffff },  /* Pixel 198 */
		{ 0x0000, 0x7777, 0xeded },  /* Pixel 199 */
		{ 0x0000, 0x8f8f, 0xd7d7 },  /* Pixel 200 */
		{ 0x0000, 0xbcbc, 0xbcbc },  /* Pixel 201 */
		{ 0x0000, 0xbcbc, 0x5e5e },  /* Pixel 202 */
		{ 0x0000, 0xbcbc, 0x0000 },  /* Pixel 203 */
		{ 0x0000, 0x3333, 0xffff },  /* Pixel 204 */
		{ 0x0000, 0x3b3b, 0xeded },  /* Pixel 205 */
		{ 0x0000, 0x4848, 0xd7d7 },  /* Pixel 206 */
		{ 0x0000, 0x5e5e, 0xbcbc },  /* Pixel 207 */
		{ 0x0000, 0x9595, 0x9595 },  /* Pixel 208 */
		{ 0x0000, 0x9595, 0x0000 },  /* Pixel 209 */
		{ 0x0000, 0x0000, 0xffff },  /* Pixel 210 */
		{ 0x0000, 0x0000, 0xeded },  /* Pixel 211 */
		{ 0x0000, 0x0000, 0xd7d7 },  /* Pixel 212 */
		{ 0x0000, 0x0000, 0xbcbc },  /* Pixel 213 */
		{ 0x0000, 0x0000, 0x9595 },  /* Pixel 214 */
		{ 0xf9f9, 0x0000, 0x0000 },  /* Pixel 215 */
		{ 0xf3f3, 0x0000, 0x0000 },  /* Pixel 216 */
		{ 0xe6e6, 0x0000, 0x0000 },  /* Pixel 217 */
		{ 0xdfdf, 0x0000, 0x0000 },  /* Pixel 218 */
		{ 0xcfcf, 0x0000, 0x0000 },  /* Pixel 219 */
		{ 0xc6c6, 0x0000, 0x0000 },  /* Pixel 220 */
		{ 0xb1b1, 0x0000, 0x0000 },  /* Pixel 221 */
		{ 0xa4a4, 0x0000, 0x0000 },  /* Pixel 222 */
		{ 0x8282, 0x0000, 0x0000 },  /* Pixel 223 */
		{ 0x6767, 0x0000, 0x0000 },  /* Pixel 224 */
		{ 0x0000, 0xf9f9, 0x0000 },  /* Pixel 225 */
		{ 0x0000, 0xf3f3, 0x0000 },  /* Pixel 226 */
		{ 0x0000, 0xe6e6, 0x0000 },  /* Pixel 227 */
		{ 0x0000, 0xdfdf, 0x0000 },  /* Pixel 228 */
		{ 0x0000, 0xcfcf, 0x0000 },  /* Pixel 229 */
		{ 0x0000, 0xc6c6, 0x0000 },  /* Pixel 230 */
		{ 0x0000, 0xb1b1, 0x0000 },  /* Pixel 231 */
		{ 0x0000, 0xa4a4, 0x0000 },  /* Pixel 232 */
		{ 0x0000, 0x8282, 0x0000 },  /* Pixel 233 */
		{ 0x0000, 0x6767, 0x0000 },  /* Pixel 234 */
		{ 0x0000, 0x0000, 0xf9f9 },  /* Pixel 235 */
		{ 0x0000, 0x0000, 0xf3f3 },  /* Pixel 236 */
		{ 0x0000, 0x0000, 0xe6e6 },  /* Pixel 237 */
		{ 0x0000, 0x0000, 0xdfdf },  /* Pixel 238 */
		{ 0x0000, 0x0000, 0xcfcf },  /* Pixel 239 */
		{ 0x0000, 0x0000, 0xc6c6 },  /* Pixel 240 */
		{ 0x0000, 0x0000, 0xb1b1 },  /* Pixel 241 */
		{ 0x0000, 0x0000, 0xa4a4 },  /* Pixel 242 */
		{ 0x0000, 0x0000, 0x8282 },  /* Pixel 243 */
		{ 0x0000, 0x0000, 0x6767 },  /* Pixel 244 */
		{ 0xf9f9, 0xf9f9, 0xf9f9 },  /* Pixel 245 */
		{ 0xf3f3, 0xf3f3, 0xf3f3 },  /* Pixel 246 */
		{ 0xe6e6, 0xe6e6, 0xe6e6 },  /* Pixel 247 */
		{ 0xdfdf, 0xdfdf, 0xdfdf },  /* Pixel 248 */
		{ 0xcfcf, 0xcfcf, 0xcfcf },  /* Pixel 249 */
		{ 0xc6c6, 0xc6c6, 0xc6c6 },  /* Pixel 250 */
		{ 0xb1b1, 0xb1b1, 0xb1b1 },  /* Pixel 251 */
		{ 0xa4a4, 0xa4a4, 0xa4a4 },  /* Pixel 252 */
		{ 0x8282, 0x8282, 0x8282 },  /* Pixel 253 */
		{ 0x6767, 0x6767, 0x6767 },  /* Pixel 254 */
		{ 0x0000, 0x0000, 0x0000 },  /* Pixel 255 */
	},
};
