.TH XPAT2 6 "June 1994" "Handmade"
.SH NAME
xpat2 \- generic patience game for X11
.SH SYNOPSIS
.B xpat2
[
.I options
] [
.I seed
] [
.I saved game
]
.SH DESCRIPTION
.I xpat2
is the successor of \fBxpat\fP, a generic patience game which can be used with
different rule sets.
It does understand the rules of the well-known
.I Spider
game, as well as
.I Klondike
and others.
It features a flexible layout which responds to window resize commands
and possibilities to customize the existing rules.
.I xpat2
has either a bitmap-based card drawing routine or a pixmap based
routine (selectable at compile time).
With the pixmap based drawing routine, antialiased colour images of the rank
and suit symbols are supplied. 
The bitmap card images are black and red by default, but users can supply
images of complete colour cards in XPM format.

.I xpat2
may be compiled with the Athena widget set (or its nicer replacement, the Xaw3d
widget set), or with a standard Xlib interface. The command line parameters
and X resource names of these versions differ. This manual page describes 
only the Athena widget version, for the Xlib options please refer to the
.I xpat
manual page.

.SH RULE CUSTOMIZATION OPTIONS
.TP 4
.B \-rules \fIrule name\fP
(Resource: \fBTableau.rules\fP)

This option specifies the initial rule set for \fIxpat\fP.
Valid rule names are \fBGypsy\fP, \fBSpider\fP, \fBFreeCell\fP,
\fBKlondike\fP, and \fBSeahaven\fP, \fBMonte Carlo\fP, \fBCalculation\fP,
\fBCanfield\fP, \fBBaker's Dozen\fP, and others. Supply an invalid rule name
to see a complete listing.

The initial rule set may also be given by the name of the executable
(capitalisation is important). A predefined rule set may be customized
by the following options, but not all options apply to every rule set.
.TP 4
.B \-slots \fIslots\fP
(Resource: \fBTableau.slots\fP)

Use a different number of slots.
.TP 4
.B \-tmps \fItmps\fP
(Resource: \fBTableau.tmps\fP)

Use a different number of temporary storage places.
.TP 4
.B \-decks \fIdecks\fP
(Resource: \fBTableau.decks\fP)

Use a different number of decks. Every deck has a full set of 52 cards.
This option does also set the number of stacks. (To 4 times the number of
decks, naturally.)
.TP 4
.B \-facedown \fInumber\fP
(Resource: \fBTableau.facedown\fP)

Specifies the number of cards per slot which are initially dealt face-down
(i.e. invisible).
.TP 4
.B \-faceup \fInumber\fP
(Resource: \fBTableau.faceup\fP)

Specifies the number of cards per slot which are initially dealt face-up.
.TP 4
.B \-jokers \fInumber\fP
(Resource: \fBTableau.jokers\fP)

Specifies the number of jokers in the game (increasing the number of cards).
With jokers, you have to put all ordinary cards onto the stacks and keep the
jokers on the slots.
.TP 4
.B \-relaxed \fInumber\fP
.B \-flips \fInumber\fP
.B \-turn \fInumber\fP
.B \-rotations \fInumber\fP
(Resource: \fBTableau.relaxed\fP to \fBTableau.rotations\fP)

Defines game specific customisation parameters.
.TP 4
.B \-rng \fInumber\fP
(Resource: \fBTableau.rng\fP)

This option affects the random number generator. rng 0 (used up to version 1.03
of xpat2) has been found to generate not uniformly distributed permutations.
You may activate it to be able to replay old saved games. The default is rng 1.


.SH GRAPHIC OPTIONS
All standard X toolkit parameters may be given, such as
.TP 4
.B \-display \fIdisplay\fP
Specifies on which display to run.
.TP 4
.B \-geometry \fIgeometry\fP
(Resource: \fBgeometry\fP)
Specifies the initial geometry.

Other options are:
.TP 4
.B \-cards \fIcardset\fP
(Resource: \fBTableau.cardset\fP)

\fIcardset\fP is the filename of an external bitmap card set which will
be used instead of the built-in cardset. There are two card sets,
namely \fB small\fP and \fB french\fP. You can also give the full pathname
of a cardset here.  This option works with the bitmap drawing routine only.
.TP 4
.B \-xpmdir \fIxpmdir\fP
(Resource: \fBTableau.xpmdir\fP)

Tells \fIxpat2\fP to search \fIxpmdir\fP for colour replacements of
the card images. The filenames searched for
are \fBJoker.xpm\fP and \fIRank.Suit\fP\fB.xpm\fP, where \fIRank\fP
is one of \fBTwo\fP to \fBTen\fP, or one of \fBJack, Queen, King, Ace\fP.
The display must be capable of displaying all images at the same time.
For a 256-colour display, no more than 128 colours should be used for
all card images together. An additional file, \fBCardback.xpm\fP, may give you
nice cardbacks.

If the directory name \fIxpmdir\fP does not start with a dot or a slash,
it is interpreted as a subdirectory of \fB/usr/games/lib/xpat\fP.
.TP 4
.B \-tb \fIcolor\fP
(Resource: \fBTableau.background\fP)

Sets the background color to \fIcolor\fP. The default
is \fBLightSlateGrey\fP.
.TP 4
.B \-cb \fIcolor\fP
(Resource: \fBTableau.cardbackColor\fP)

Sets the background color of the cards to \fIcolor\fP. The default
is \fBSlateGrey\fP. This option is not in effect when an XPM replacement
for the cardback is used.
.TP 4
.B \-markwidth \fIwidth\fP
(Resource: \fBTableau.markWidth\fP)

Sets the width of the dashed frame which marks selected cards.
If this width is at least half of the card width, marked cards will be
shaded. The default is to shade the cards.
.TP 4
.B \-markcolor \fIcolor\fP
(Resource: \fBmarkColor\fP)

Sets the color of the marking frame.
.TP 4
.B \-sound, \-nosound
(Resource: \fBSound.state\fP)

Enables or Disables sound.

.SH NATIVE LANGUAGE SUPPORT
\fBxpat2\fP has simple support for different languages. All messages which
appear in the X11 window may be overloaded by files, as well as the key
bindings.
The typical support consists of an application-defaults file, a message file,
and a keyboard file. Possibly translated online-help files are also there.
To select a different language, call \fBxpat2\fP
after setting the environment variable \fBLANG\fP to the desired value.
Currently, italian and german versions are available, and fragments
of a french and russian version.
The russian version requires a special cyrillic font, \fBsq01\fP.
The bdf-file is distributed with \fBxpat2\fP, you have to convert it into
a format supported by your X-server (pcf, snf, ...)

.SH FILES
(Directories may differ on your system.)

 \fB/usr/games/xpat2\fP
 \fB/var/lib/games/xpat2/xpat.log\fP
 \fB/usr/doc/copyright/xpat2\fP
 \fB/usr/lib/games/xpat/small.cards\fP
 \fB/usr/lib/games/xpat/french.cards\fP
 \fB/usr/lib/games/xpat/audio/success.au\fP
 \fB/usr/lib/games/xpat/audio/giveup.au\fP
 \fB/usr/lib/games/xpat/audio/goodbye.au\fP
 \fB/usr/lib/games/xpat/audio/cannotsave.au\fP
 \fB/usr/lib/games/xpat/help.*\fP
 \fB/usr/lib/games/xpat/hlp*\fP

and a number of subdirs of \fB/usr/lib/games/xpat\fP, containing sets of colour
cards.

.SH DIAGNOSTICS
Almost none. (Type '\fBv\fP' to see the version number. This is the man-page of
xpat2 version 1.04.)

.SH BUGS
Correct cheat counting is not implemented in all rules.

Only a few rule custonisations are checked and meaningful.

The Motif interface doesn't work. Any volunteers?

There is a problem with X-servers which are short on memory. In this case, some
parts of the xpat2 window may be left blank after a resize event.  You have to
hit <ctrl-L> to get the window redrawn correctly.

Please mail bug reports to \fBmbi@mo.math.nat.tu-bs.de\fP.
Fixes are especially welcome.
.SH SEE ALSO
\fBxpat(6x)\fP, \fBspider(1)\fP, \fBxsol(1)\fP

.SH AUTHORS
Heiko Eissfeldt and Michael Bischoff

.SH COPYRIGHT
Copyright (c) 1994 by Heiko Eissfeldt and Michael Bischoff
.br
(\fBheiko@colossus.escape.de\fP and \fBmbi@mo.math.nat.tu-bs.de\fP)
.sp 1
Copyright (c) 1990 by David Lemke & Network Computing Devices, Inc.
.br
(\fBlemke@ncd.com\fP)
.sp 1
Copyright 1990 Heather Rose and Sun Microsystems, Inc.
.sp 1
Copyright (c) 1989, Donald R. Woods and Sun Microsystems, Inc.


Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.

\fBxpat\fP and \fBxpat2\fP were developed under Linux, the free UNIX for the
IBM-PC and compatibles. \fBxpat\fP is based on the game \fBspider\fP.  All new
code which is not covered by \fBspider\fP copyrights is distributed by terms of
the GNU General public license (GNU Copyleft).
