#include <stdio.h>
#include <sys/socket.h>
#include <linux/sockios.h>
#include <linux/if.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <ctype.h>
#include <termios.h>
#include <fcntl.h>
#include <signal.h>

void setifcall(char *ifn, char *name)
{
	char call[7];
	int ct=0;
	int ssid=0;
	char *p=name;
	struct ifreq ifr;
	int fd=socket(AF_INET,SOCK_DGRAM,0);
	
	while(ct<6)
	{
		if(islower(*p))
			*p=toupper(*p);
		call[ct]=(*p<<1);
		p++;
		ct++;
		if(*p=='-' || *p==0)
			break;
	}
	while(ct<6)
	{
		call[ct]=' '<<1;
		ct++;
	}
	if(*p==0)
		ssid=0;
	else
	{
		p++;
		if(sscanf(p,"%d",&ssid)!=1 || ssid<0 || ssid>15)
		{
			fprintf(stderr,"SSID must follow '-' and be numeric in the range 0-15.\n");
			exit(1);
		}
	}
	call[6]=((ssid+'0')<<1)&0x1E;
	
	strcpy(ifr.ifr_name,ifn);
	memcpy(ifr.ifr_hwaddr.sa_data,call,7);
	ifr.ifr_hwaddr.sa_family=AF_AX25;
	
	if(ioctl(fd,SIOCSIFHWADDR,&ifr)!=0)
	{
		close(fd);
		perror("SIOCSIFHWADDR");
		exit(1);
	}
	close(fd);
}
	
void main(int argc,char *argv[])
{
	
	if(argc!=3)
	{
		fprintf(stderr,"%s <interface> <callsign>.\n",argv[0]);
		exit(1);
	}
	
	setifcall(argv[1],argv[2]);
}


