#ifndef __YPSERV_H__
#define __YPSERV_H__

/* 
** $Id: ypserv.h,v 1.10 1996/04/09 20:49:03 kukuk Exp $ 
*/

#include <rpc/rpc.h>

/* Struct for ypserv.conf options */
typedef struct conffile 
{
  struct in_addr netmask;
  struct in_addr network;
  char *map;
  int security;
  int mangle;
  int field;
  struct conffile *next;
} conffile_t;

extern char *progname;      	/* ypserv.c */
extern char *path_ypdb;		/* ypserv.c */
extern int debug_flag;		/* ypserv.c */
extern int dns_flag;		/* ypserv.c */
extern int sunos_kludge_flag;   /* ypserv.c */
extern int tryresolve_flag;     /* ypserv.c */
extern int children;		/* server.c */

/* 
** returns 1, if secure, else 0 
*/
extern int is_valid_host(struct svc_req *rqstp, const char *map);
extern int is_valid_domain(const char *domain);

/* 
** load/reload the YPMAPDIR/securenets file 
*/
extern void load_securenets(void);
extern void load_config(void);
extern conffile_t *load_ypserv_conf(const char *);

extern void ypserv_svc_run(void);

/*
** Defines for ypserv.conf
*/

/* Security field: */
#define SEC_NONE 0
#define SEC_DENY 1
#define SEC_PORT 2

/* Mangle field: */
#define MANGLE_NO 0
#define MANGLE_YES 1

#endif
