#
# $Source: /home/nlfm/Working/Zircon/Development/lib/RCS/errors.tcl,v $
# $Date: 1996/04/03 09:30:15 $
# $Revision: 1.16.1.6 $
#
proc irc401 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    if [regexp -nocase {^zirconbot$} [set chan [lindex $pargs 1]]] return
    if [[set this [Message :: find $chan]] active] {
	$this addText @ERROR "*** $chan is not on IRC"
    } {
	$net display @ERROR "*** $param - $chan"
    }
}

proc irc404 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    if [[set this [Channel :: find [set chan [lindex $pargs 1]]]] active] {
	$this addText @ERROR "*** $param"
    } {
	$net display @ERROR "*** Cannot send to channel $chan"
    }
}

proc irc406 {net prefix param pargs} {
    global whois
    regsub -all {\\} $pargs {\\\\} pargs
    set whois(err) [lindex $pargs 1]
}

proc resetNick {net} {
    global nickname
    entrySet [[$net control] window].nSFrm.nickname.entry "$nickname"
}

proc irc432 {net prefix param pargs} {
    resetNick $net
    regsub -all {\\} $pargs {\\\\} pargs
    mkInfoBox ERROR .@nicker {Nickname Error} "[lindex $pargs 1] : $param"
}

proc irc433 {net prefix param pargs} {
    global startup
    resetNick $net
    regsub -all {\\} $pargs {\\\\} pargs
    mkInfoBox [expr {$startup ? {SERROR} : {ERROR}}] .@nicker \
      {Nickname Error} "[lindex $pargs 1] : $param"
}

proc irc442 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    if [[set ch [Channel :: find [set nm [lindex $pargs 1]]]] active] {
	$ch delete
    } {
	mkInfoBox ERROR .@chaner {Channel Error} \
	  "$nm $param [lindex $pargs 2]"
    }
}

proc irc443 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    set who [lindex $pargs 1]
    if [[set ch [Channel :: find [set cn [lindex $pargs 2]]]] active] {
	$ch addText @ERROR "*** $who $param $cn"
    } {
	mkInfoBox ERROR .@inver {Invite Error} \
	  "$who $param $cn"
    }
}

proc irc471 {net prefix param pargs} {
    global ztrans
    regsub -all {\\} $pargs {\\\\} pargs
    set chn [Channel :: find [set chan [lindex $pargs 1]]]
    mkDialog {} .@full {Channel Full} "Channel ${chan} is full!" \
      {} "$ztrans(ok) {}" "{Try Again} {$chn sendJoin}"
}

proc irc473 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    if [[set ch [Channel :: find [lindex $pargs 1]]] active] {
	$ch addText @ERROR "*** \007Channel is invitation only!"
    } {
	mkInfoBox ERROR .@invonly {Invitation Only} \
	  "Channel [lindex $pargs 1] is invitation only!"
    }
}

proc irc474 {net prefix param pargs} {
    regsub -all {\\} $pargs {\\\\} pargs
    if [[set ch [Channel :: find [lindex $pargs 1]]] active] {
	$ch addText @ERROR "*** \007You are banned from this channel!"
    } {
	mkInfoBox ERROR .@banned$net Banned \
	  "You are banned from channel [lindex $pargs 1]!"
    }
}

proc irc475 {net prefix param pargs} {
    global ztrans
    regsub -all {\\} $pargs {\\\\} pargs
    if {[[set chn [Channel :: find [set chan [lindex $pargs 1]]]] key] == {}} {
	mkEntryBox .@key$net $ztrans(key) "Enter key for channel $chan:" \
	  "{$ztrans(key) {}}" "$ztrans(join) {$chn sendJoin}" \
	  "$ztrans(cancel) {}"
    } {
	mkDialog {} .@key$net "Bad Key" \
	  "Bad key for channel $chan!" [list [list Key [$chn key]]] \
	  "{Try Again} {$chn sendJoin}" "$ztrans(cancel) {}"
    }
}



