/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
typedef void (*child_context_callback)(void*, int, char*);

extern void	 init_child_contexts(void);
extern void	 suspend_child_contexts(void);
extern void	 resume_child_contexts(void);
extern pid_t	 fork_nicely(void*, child_context_callback, int);
extern pid_t	 wait_for_pid(pid_t, int*, char*);
extern char	*signal_string(int);
extern void	 sighup_handler(int);
extern int	 default_sigchld(void);

#define STDERR_BUFFLEN	512

extern volatile int	sighup_may_exit;
extern volatile int	caught_sighup;
