      SUBROUTINE slETRM (EP, EV)
*+
*     - - - - - -
*      E T R M
*     - - - - - -
*
*  Compute the E-terms (elliptic component of annual aberration)
*  vector (double precision)
*
*  Given:
*     EP      dp      Besselian epoch
*
*  Returned:
*     EV      dp(3)   E-terms as (dx,dy,dz)
*
*  Note the use of the J2000 aberration constant (20.49552 arcsec).
*  This is a reflection of the fact that the E-terms embodied in
*  existing star catalogues were computed from a variety of
*  aberration constants.  Rather than adopting one of the old
*  constants the latest value is used here.
*
*  References:
*     1  Smith, C.A. et al., 1989.  Astr.J. 97, 265.
*     2  Yallop, B.D. et al., 1989.  Astr.J. 97, 274.
*
*  P.T.Wallace   Starlink   10 April 1990
*
*  Copyright (C) 1995 Rutherford Appleton Laboratory
*  Copyright (C) 1995 Association of Universities for Research in Astronomy Inc.
*-

      IMPLICIT NONE

      DOUBLE PRECISION EP,EV(3)

*  Arcseconds to radians
      DOUBLE PRECISION AS2R
      PARAMETER (AS2R=0.4848136811095359949D-5)

      DOUBLE PRECISION T,E,E0,P,EK,CP



*  Julian centuries since B1950
      T=(EP-1950D0)*1.00002135903D-2

*  Eccentricity
      E=0.01673011D0-(0.00004193D0+0.000000126D0*T)*T

*  Mean obliquity
      E0=(84404.836D0-(46.8495D0+(0.00319D0+0.00181D0*T)*T)*T)*AS2R

*  Mean longitude of perihelion
      P=(1015489.951D0+(6190.67D0+(1.65D0+0.012D0*T)*T)*T)*AS2R

*  E-terms
      EK=E*20.49552D0*AS2R
      CP=COS(P)
      EV(1)= EK*SIN(P)
      EV(2)=-EK*CP*COS(E0)
      EV(3)=-EK*CP*SIN(E0)

      END
